/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import org.jetbrains.annotations.NotNull;

public class PyOverridingMethodsSearchExecutor
implements QueryExecutor<PyFunction, PyOverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull PyOverridingMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super PyFunction> consumer) {
        if (queryParameters == null) {
            PyOverridingMethodsSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PyOverridingMethodsSearchExecutor.$$$reportNull$$$0(1);
        }
        PyFunction baseMethod = queryParameters.getFunction();
        PyClass containingClass = (PyClass)ReadAction.compute(() -> baseMethod.getContainingClass());
        return PyClassInheritorsSearch.search(containingClass, queryParameters.isCheckDeep()).forEach(pyClass -> {
            PyFunction overridingMethod = (PyFunction)ReadAction.compute(() -> {
                PyFunction o = pyClass.findMethodByName(baseMethod.getName(), false, null);
                if (o != null) {
                    Property baseProperty = baseMethod.getProperty();
                    Property overridingProperty = o.getProperty();
                    if (baseProperty != null && overridingProperty != null) {
                        AccessDirection direction = PyUtil.getPropertyAccessDirection(baseMethod);
                        PyCallable callable = overridingProperty.getByDirection(direction).valueOrNull();
                        o = callable instanceof PyFunction ? (PyFunction)callable : null;
                    }
                }
                return o;
            });
            if (overridingMethod != null) {
                return consumer.process((Object)overridingMethod);
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/psi/search/PyOverridingMethodsSearchExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

