/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript.providers;

import com.intellij.configurationScript.BeanConstructorKt;
import com.intellij.configurationScript.ConfigurationFileManager;
import com.intellij.configurationScript.providers.ConfigurationScriptProjectStoreFactory;
import com.intellij.configurationScript.providers.ReadOnlyStorage;
import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ProjectWithModulesStoreImpl;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ<\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J.\u0010\u001a\u001a\u0004\u0018\u00010\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0014J\u001e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 H\u0016J*\u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/configurationScript/providers/MyProjectStore;", "Lcom/intellij/configurationStore/ProjectWithModulesStoreImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isConfigurationFileListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "storages", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "", "Lcom/intellij/configurationScript/providers/ReadOnlyStorage;", "configurationFileChanged", "", "doCreateStateGetter", "Lcom/intellij/configurationStore/StateGetter;", "reloadData", "", "storage", "Lcom/intellij/openapi/components/StateStorage;", "info", "Lcom/intellij/configurationStore/ComponentInfo;", "name", "", "stateClass", "getReadOnlyStorage", "componentClass", "configurationSchemaKey", "reload", "", "changedStorages", "", "setStateToSaveSessionProducer", "state", "effectiveComponentName", "sessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "intellij.configurationScript"})
final class MyProjectStore
extends ProjectWithModulesStoreImpl {
    @NotNull
    private final AtomicBoolean isConfigurationFileListenerAdded;
    private final ConcurrentHashMap<Class<Object>, ReadOnlyStorage> storages;

    @NotNull
    public final AtomicBoolean isConfigurationFileListenerAdded() {
        return this.isConfigurationFileListenerAdded;
    }

    public final void configurationFileChanged() {
        Map map2 = this.storages;
        boolean bl = false;
        if (!map2.isEmpty()) {
            StoreReloadManager storeReloadManager = StoreReloadManager.Companion.getInstance();
            Project project = this.getProject();
            Collection<ReadOnlyStorage> collection = this.storages.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"storages.values");
            storeReloadManager.storageFilesChanged(MapsKt.mapOf((Pair)TuplesKt.to((Object)project, (Object)CollectionsKt.toList((Iterable)collection))));
        }
    }

    @Nullable
    protected StateStorage getReadOnlyStorage(@NotNull Class<Object> componentClass, @NotNull Class<Object> stateClass, @NotNull String configurationSchemaKey) {
        Intrinsics.checkParameterIsNotNull(componentClass, (String)"componentClass");
        Intrinsics.checkParameterIsNotNull(stateClass, (String)"stateClass");
        Intrinsics.checkParameterIsNotNull((Object)configurationSchemaKey, (String)"configurationSchemaKey");
        ConcurrentMap $this$getOrPut$iv = this.storages;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(componentClass);
        if (object == null) {
            boolean bl = false;
            ReadOnlyStorage readOnlyStorage = new ReadOnlyStorage(configurationSchemaKey, componentClass, this);
            boolean bl2 = false;
            boolean bl3 = false;
            ReadOnlyStorage default$iv = readOnlyStorage;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(componentClass, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (StateStorage)object;
    }

    @NotNull
    protected StateGetter<Object> doCreateStateGetter(boolean reloadData, @NotNull StateStorage storage, @NotNull ComponentInfo info, @NotNull String name, @NotNull Class<Object> stateClass) {
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(stateClass, (String)"stateClass");
        StateGetter stateGetter = super.doCreateStateGetter(reloadData, storage, info, name, stateClass);
        String string = info.getConfigurationSchemaKey();
        if (string == null) {
            return stateGetter;
        }
        String configurationSchemaKey = string;
        ConfigurationFileManager configurationFileManager = ConfigurationFileManager.Companion.getInstance(this.getProject());
        List<NodeTuple> list = configurationFileManager.findValueNode(configurationSchemaKey);
        if (list == null) {
            return stateGetter;
        }
        List<NodeTuple> node = list;
        return (StateGetter)new StateGetter<Object>(stateGetter, stateClass, node, info){
            final /* synthetic */ StateGetter $stateGetter;
            final /* synthetic */ Class $stateClass;
            final /* synthetic */ List $node;
            final /* synthetic */ ComponentInfo $info;

            @Nullable
            public Object getState(@Nullable Object mergeInto) {
                Object state = this.$stateGetter.getState(mergeInto);
                if (state == null) {
                    state = ReflectionUtil.newInstance((Class)this.$stateClass, (boolean)false);
                }
                boolean bl = false;
                List affectedProperties = new ArrayList<E>();
                Object object = state;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.BaseState");
                }
                BeanConstructorKt.readIntoObject((BaseState)object, this.$node, (Function1<? super StoredProperty<Object>, Unit>)((Function1)new Function1<StoredProperty<Object>, Unit>(affectedProperties){
                    final /* synthetic */ List $affectedProperties;

                    public final void invoke(@NotNull StoredProperty<Object> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        String string = it.getName();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$affectedProperties.add(string);
                    }
                    {
                        this.$affectedProperties = list;
                        super(1);
                    }
                }));
                this.$info.setAffectedPropertyNames(affectedProperties);
                return state;
            }

            @Nullable
            public Object archiveState() {
                return null;
            }
            {
                this.$stateGetter = $captured_local_variable$0;
                this.$stateClass = $captured_local_variable$1;
                this.$node = $captured_local_variable$2;
                this.$info = $captured_local_variable$3;
            }
        };
    }

    protected void setStateToSaveSessionProducer(@Nullable Object state, @NotNull ComponentInfo info, @NotNull String effectiveComponentName, @NotNull SaveSessionProducer sessionProducer) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)effectiveComponentName, (String)"effectiveComponentName");
        Intrinsics.checkParameterIsNotNull((Object)sessionProducer, (String)"sessionProducer");
        String configurationSchemaKey = info.getConfigurationSchemaKey();
        if (state == null || configurationSchemaKey == null || info.getAffectedPropertyNames().isEmpty() || !(sessionProducer instanceof SaveSessionBase)) {
            super.setStateToSaveSessionProducer(state, info, effectiveComponentName, sessionProducer);
        } else {
            Element serializedState = XmlSerializerKt.deserializeBaseStateWithCustomNameFilter((BaseState)((BaseState)state), (Collection)info.getAffectedPropertyNames());
            ((SaveSessionBase)sessionProducer).setSerializedState(effectiveComponentName, serializedState);
        }
    }

    @Nullable
    public Collection<String> reload(@NotNull Set<? extends StateStorage> changedStorages) {
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        Collection result = super.reload(changedStorages);
        for (StateStorage stateStorage : changedStorages) {
            if (!(stateStorage instanceof ReadOnlyStorage)) continue;
            Object component = this.getProject().getServiceIfCreated(((ReadOnlyStorage)stateStorage).getComponentClass());
            if (component == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ConfigurationScriptProjectStoreFactory.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error("Cannot find component by " + ((ReadOnlyStorage)stateStorage).getComponentClass().getName());
                continue;
            }
            this.initComponentWithoutStateSpec((PersistentStateComponent)component, ((ReadOnlyStorage)stateStorage).getConfigurationSchemaKey());
        }
        return result;
    }

    public MyProjectStore(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.isConfigurationFileListenerAdded = new AtomicBoolean();
        this.storages = new ConcurrentHashMap();
    }
}

