/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;

public class TagButton
extends JBLayeredPane
implements Disposable {
    protected final JButton myButton;
    private final InplaceButton myCloseButton;
    private final AWTEventListener myEventListener;

    public TagButton(String text, final Runnable action) {
        this.myButton = new JButton(text){

            @Override
            protected void paintComponent(Graphics g) {
                this.putClientProperty("JButton.borderColor", this.hasFocus() ? null : TagButton.getBackgroundColor());
                super.paintComponent(g);
            }
        };
        this.myButton.putClientProperty("JButton.backgroundColor", TagButton.getBackgroundColor());
        this.myButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (8 == e.getKeyCode() || 127 == e.getKeyCode()) {
                    TagButton.this.remove(action);
                }
            }
        });
        this.add((Component)this.myButton, JLayeredPane.DEFAULT_LAYER);
        this.myCloseButton = new InplaceButton(new IconButton(OptionsBundle.message("tag.button.tooltip", new Object[0]), AllIcons.Actions.DeleteTag, AllIcons.Actions.DeleteTagHover), a -> this.remove(action));
        this.myCloseButton.setVisible(false);
        this.myCloseButton.setOpaque(false);
        this.add((Component)this.myCloseButton, JLayeredPane.POPUP_LAYER);
        this.layoutButtons();
        this.myEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                MouseEvent me = (MouseEvent)event;
                Component component = me.getComponent();
                if (component == TagButton.this.myButton || component == TagButton.this.myCloseButton || component == TagButton.this) {
                    if (504 == me.getID() || 503 == me.getID()) {
                        TagButton.this.myCloseButton.setVisible(true);
                    }
                } else if (503 == me.getID()) {
                    TagButton.this.myCloseButton.setVisible(false);
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myEventListener, 48L);
    }

    protected void layoutButtons() {
        Dimension size = this.myButton.getPreferredSize();
        Insets insets = this.myButton.getBorder().getBorderInsets(this.myButton);
        this.setPreferredSize(new Dimension(size.width + 8 - insets.right, size.height + 8 - insets.top));
        this.myButton.setBounds(0, 8 - insets.top, size.width, size.height);
        this.myCloseButton.setBounds(size.width - 8 - insets.right, 0, 16, 16);
    }

    protected void updateButton(String text, Icon icon) {
        this.myButton.setText(text);
        this.myButton.setIcon(icon);
        this.layoutButtons();
    }

    private void remove(Runnable action) {
        this.setVisible(false);
        action.run();
    }

    private static Color getBackgroundColor() {
        return JBUI.CurrentTheme.ActionButton.hoverBackground();
    }

    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myEventListener);
    }
}

