/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0001\u001a \u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006\u001a.\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0014"}, d2={"enableExternalStorageByDefaultInTests", "", "isExternalStorageEnabled", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "appendModuleName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "result", "moduleOnTheLeft", "decorateWithLibraryName", "displayUrlRelativeToProject", "url", "isIncludeFilePath", "doNotEnableExternalStorageByDefaultInTests", "", "action", "Lkotlin/Function0;", "intellij.platform.projectModel"})
@JvmName(name="ProjectUtilCore")
public final class ProjectUtilCore {
    private static boolean enableExternalStorageByDefaultInTests = true;

    @NotNull
    public static final String displayUrlRelativeToProject(@NotNull VirtualFile file, @NotNull String url, @NotNull Project project, boolean isIncludeFilePath, boolean moduleOnTheLeft) {
        String urlWithLibraryName;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String result = url;
        if (isIncludeFilePath) {
            String string;
            String projectHomeUrl = PathUtil.toSystemDependentName(project.getBasePath());
            if (projectHomeUrl != null && StringsKt.startsWith$default((String)result, (String)projectHomeUrl, (boolean)false, (int)2, null)) {
                String string2 = result;
                int n = projectHomeUrl.length();
                StringBuilder stringBuilder = new StringBuilder().append("...");
                boolean bl = false;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                string = stringBuilder.append(string4).toString();
            } else {
                String string5 = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"FileUtil.getLocationRela\u2026Home(file.presentableUrl)");
            }
            result = string;
        }
        if ((urlWithLibraryName = ProjectUtilCore.decorateWithLibraryName(file, project, result)) != null) {
            return urlWithLibraryName;
        }
        if (PlatformUtils.isCidr() || PlatformUtils.isRider()) {
            return result;
        }
        return ProjectUtilCore.appendModuleName(file, project, result, moduleOnTheLeft);
    }

    @Nullable
    public static final String decorateWithLibraryName(@NotNull VirtualFile file, @NotNull Project project, @NotNull String result) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (file.getFileSystem() instanceof LocalFileProvider) {
            VirtualFileSystem virtualFileSystem = file.getFileSystem();
            if (virtualFileSystem == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.LocalFileProvider");
            }
            VirtualFile localFile = ((LocalFileProvider)((Object)virtualFileSystem)).getLocalVirtualFileFor(file);
            if (localFile != null) {
                OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file, project);
                if (libraryEntry instanceof JdkOrderEntry) {
                    return result + " [" + ((JdkOrderEntry)libraryEntry).getJdkName() + ']';
                }
                if (libraryEntry != null) {
                    return result + " [" + libraryEntry.getPresentableName() + ']';
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String appendModuleName(@NotNull VirtualFile file, @NotNull Project project, @NotNull String result, boolean moduleOnTheLeft) {
        String string;
        Module module;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                module = ModuleUtilCore.findModuleForFile(file, project);
                if (module == null) break block4;
                ModuleManager moduleManager = ModuleManager.getInstance(project);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                if (moduleManager.getModules().length != 1) break block5;
            }
            string = result;
            return string;
        }
        if (moduleOnTheLeft) {
            string = '[' + module.getName() + "] " + result;
            return string;
        }
        string = result + " [" + module.getName() + ']';
        return string;
    }

    public static final boolean isExternalStorageEnabled(@NotNull Project $this$isExternalStorageEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isExternalStorageEnabled, (String)"$this$isExternalStorageEnabled");
        String string = $this$isExternalStorageEnabled.getProjectFilePath();
        if (string != null) {
            if (StringsKt.endsWith$default((String)string, (String)".ipr", (boolean)false, (int)2, null)) {
                return false;
            }
        }
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ServiceManager.getService($this$isExternalStorageEnabled, ExternalStorageConfigurationManager.class);
        if (externalStorageConfigurationManager == null) {
            return false;
        }
        ExternalStorageConfigurationManager manager = externalStorageConfigurationManager;
        if (manager.isEnabled()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean testMode = application != null ? application.isUnitTestMode() : false;
        return testMode && enableExternalStorageByDefaultInTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void doNotEnableExternalStorageByDefaultInTests(@NotNull Function0<Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        enableExternalStorageByDefaultInTests = false;
        try {
            action.invoke();
        }
        finally {
            enableExternalStorageByDefaultInTests = true;
        }
    }
}

