/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.SideBorder;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public final class IdeBorderFactory {
    public static final int BORDER_ROUNDNESS = 5;
    public static final int TITLED_BORDER_TOP_INSET = 7;
    public static final int TITLED_BORDER_LEFT_INSET = 0;
    public static final int TITLED_BORDER_BOTTOM_INSET = 10;
    public static final int TITLED_BORDER_RIGHT_INSET = 0;
    public static final int TITLED_BORDER_INDENT = 20;

    private IdeBorderFactory() {
    }

    public static Border createBorder() {
        return IdeBorderFactory.createBorder(15);
    }

    public static Border createBorder(int borders) {
        return IdeBorderFactory.createBorder(IdeBorderFactory.getBorderColor(), borders);
    }

    public static Border createBorder(Color color) {
        return IdeBorderFactory.createBorder(color, 15);
    }

    public static Border createBorder(Color color, int borders) {
        return new SideBorder(color, borders);
    }

    @NotNull
    public static RoundedLineBorder createRoundedBorder() {
        return IdeBorderFactory.createRoundedBorder(5);
    }

    @NotNull
    public static RoundedLineBorder createRoundedBorder(int arcSize) {
        return new RoundedLineBorder(IdeBorderFactory.getBorderColor(), arcSize);
    }

    @NotNull
    public static RoundedLineBorder createRoundedBorder(int arcSize, int thickness) {
        return new RoundedLineBorder(IdeBorderFactory.getBorderColor(), arcSize, thickness);
    }

    public static Border createEmptyBorder(Insets insets) {
        return new EmptyBorder((Insets)JBInsets.create((Insets)insets));
    }

    @Deprecated
    public static Border createEmptyBorder() {
        return JBUI.Borders.empty();
    }

    @Deprecated
    public static Border createEmptyBorder(int thickness) {
        return JBUI.Borders.empty((int)thickness);
    }

    @Deprecated
    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        return JBUI.Borders.empty((int)top, (int)left, (int)bottom, (int)right);
    }

    public static TitledBorder createTitledBorder(@NlsContexts.BorderTitle String s) {
        return IdeBorderFactory.createTitledBorder(s, true);
    }

    public static IdeaTitledBorder createTitledBorder(@NlsContexts.BorderTitle String title, boolean hasIndent) {
        int top = Math.max(0, Registry.intValue((String)"ide.titled.border.top", (int)7));
        int left = Math.max(0, Registry.intValue((String)"ide.titled.border.left", (int)0));
        int right = Math.max(0, Registry.intValue((String)"ide.titled.border.right", (int)0));
        int bottom = Math.max(0, Registry.intValue((String)"ide.titled.border.bottom", (int)10));
        Insets insets = new Insets(top, left, bottom, right);
        return IdeBorderFactory.createTitledBorder(title, hasIndent, insets);
    }

    public static IdeaTitledBorder createTitledBorder(@NlsContexts.BorderTitle String title, boolean hasIndent, Insets insets) {
        int indent = hasIndent ? Math.max(0, Registry.intValue((String)"ide.titled.border.indent", (int)20)) : 0;
        return new IdeaTitledBorder(title, indent, insets);
    }

    private static Color getBorderColor() {
        return JBColor.border();
    }

    public static final class PlainSmallWithIndentWithoutInsets {
        private PlainSmallWithIndentWithoutInsets() {
        }

        public static TitledBorder createTitledBorder(Border border, @NlsContexts.BorderTitle String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title, true, new Insets(7, 0, 0, 0));
        }
    }

    public static final class PlainSmallWithoutIndentWithoutInsets {
        private PlainSmallWithoutIndentWithoutInsets() {
        }

        public static TitledBorder createTitledBorder(Border border, @NlsContexts.BorderTitle String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title, false, new Insets(7, 0, 0, 0));
        }
    }

    public static final class PlainSmallWithoutIndent {
        private PlainSmallWithoutIndent() {
        }

        public static TitledBorder createTitledBorder(Border border, @NlsContexts.BorderTitle String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title, false);
        }
    }

    public static final class PlainSmallWithIndent {
        private PlainSmallWithIndent() {
        }

        public static TitledBorder createTitledBorder(Border border, @NlsContexts.BorderTitle String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title);
        }
    }
}

