/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditSourceOnDoubleClickHandler {
    private EditSourceOnDoubleClickHandler() {
    }

    public static void install(JTree tree, @Nullable Runnable whenPerformed) {
        new TreeMouseListener(tree, whenPerformed).installOn(tree);
    }

    public static void install(JTree tree) {
        EditSourceOnDoubleClickHandler.install(tree, null);
    }

    public static void install(final TreeTable treeTable) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return false;
                }
                if (treeTable.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(treeTable);
                Project project = CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/EditSourceOnDoubleClickHandler$1", "onDoubleClick"));
            }
        }.installOn(treeTable);
    }

    public static void install(final JTable table) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return false;
                }
                if (table.columnAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                if (table.rowAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(table);
                Project project = CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/EditSourceOnDoubleClickHandler$2", "onDoubleClick"));
            }
        }.installOn(table);
    }

    public static void install(final JList list, final Runnable whenPerformed) {
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Point point;
                int index;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((index = list.locationToIndex(point = e.getPoint())) == -1) {
                    return false;
                }
                if (!list.getCellBounds(index, index).contains(point)) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(list);
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                whenPerformed.run();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/EditSourceOnDoubleClickHandler$3", "onDoubleClick"));
            }
        }.installOn(list);
    }

    public static boolean isToggleEvent(@NotNull JTree tree, @NotNull MouseEvent e) {
        TreePath selectionPath;
        if (tree == null) {
            EditSourceOnDoubleClickHandler.$$$reportNull$$$0(0);
        }
        if (e == null) {
            EditSourceOnDoubleClickHandler.$$$reportNull$$$0(1);
        }
        if ((selectionPath = tree.getSelectionPath()) == null) {
            return false;
        }
        return !tree.getModel().isLeaf(selectionPath.getLastPathComponent()) && tree.getToggleClickCount() == e.getClickCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/EditSourceOnDoubleClickHandler";
        objectArray[2] = "isToggleEvent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TreeMouseListener
    extends DoubleClickListener {
        private final JTree myTree;
        @Nullable
        private final Runnable myWhenPerformed;

        public TreeMouseListener(JTree tree) {
            this(tree, null);
        }

        public TreeMouseListener(JTree tree, @Nullable Runnable whenPerformed) {
            this.myTree = tree;
            this.myWhenPerformed = whenPerformed;
        }

        @Override
        public boolean onDoubleClick(@NotNull MouseEvent e) {
            TreePath clickPath;
            if (e == null) {
                TreeMouseListener.$$$reportNull$$$0(0);
            }
            TreePath treePath = clickPath = WideSelectionTreeUI.isWideSelection((JTree)this.myTree) ? this.myTree.getClosestPathForLocation(e.getX(), e.getY()) : this.myTree.getPathForLocation(e.getX(), e.getY());
            if (clickPath == null) {
                return false;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext(this.myTree);
            Project project = CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            TreePath selectionPath = this.myTree.getSelectionPath();
            if (!clickPath.equals(selectionPath)) {
                return false;
            }
            if (EditSourceOnDoubleClickHandler.isToggleEvent(this.myTree, e)) {
                return false;
            }
            this.processDoubleClick(e, dataContext, selectionPath);
            return true;
        }

        protected void processDoubleClick(@NotNull MouseEvent e, @NotNull DataContext dataContext, @NotNull TreePath treePath) {
            if (e == null) {
                TreeMouseListener.$$$reportNull$$$0(1);
            }
            if (dataContext == null) {
                TreeMouseListener.$$$reportNull$$$0(2);
            }
            if (treePath == null) {
                TreeMouseListener.$$$reportNull$$$0(3);
            }
            OpenSourceUtil.openSourcesFrom(dataContext, true);
            if (this.myWhenPerformed != null) {
                this.myWhenPerformed.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treePath";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/EditSourceOnDoubleClickHandler$TreeMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDoubleClick";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDoubleClick";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

