/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalView;

public class TerminalContainer {
    private static final Logger LOG = Logger.getInstance(TerminalContainer.class);
    private final Content myContent;
    private final JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final TerminalView myTerminalView;
    private JPanel myPanel;

    public TerminalContainer(@NotNull Project project, @NotNull Content content, @NotNull JBTerminalWidget terminalWidget, @NotNull TerminalView terminalView) {
        if (project == null) {
            TerminalContainer.$$$reportNull$$$0(0);
        }
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(1);
        }
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(2);
        }
        if (terminalView == null) {
            TerminalContainer.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myContent = content;
        this.myTerminalWidget = terminalWidget;
        this.myTerminalView = terminalView;
        this.myPanel = TerminalContainer.createPanel(terminalWidget);
        terminalWidget.addListener(widget -> ApplicationManager.getApplication().invokeLater(() -> this.onSessionClosed(), this.myProject.getDisposed()));
        terminalView.register(this);
    }

    @NotNull
    public JBTerminalWidget getTerminalWidget() {
        JBTerminalWidget jBTerminalWidget = this.myTerminalWidget;
        if (jBTerminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(4);
        }
        return jBTerminalWidget;
    }

    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            TerminalContainer.$$$reportNull$$$0(5);
        }
        return content;
    }

    @NotNull
    private static JPanel createPanel(@NotNull JBTerminalWidget terminalWidget) {
        if (terminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(6);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(null);
        panel.setFocusable(false);
        panel.add((Component)terminalWidget.getComponent(), "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            TerminalContainer.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TerminalContainer.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void split(boolean vertically, @NotNull JBTerminalWidget newTerminalWidget) {
        if (newTerminalWidget == null) {
            TerminalContainer.$$$reportNull$$$0(9);
        }
        boolean hasFocus = this.myTerminalWidget.getTerminalPanel().hasFocus();
        JPanel parent = this.myPanel;
        parent.remove(this.myTerminalWidget.getComponent());
        this.myPanel = TerminalContainer.createPanel(this.myTerminalWidget);
        Splitter splitter = TerminalContainer.createSplitter(vertically);
        splitter.setFirstComponent((JComponent)this.myPanel);
        TerminalContainer newContainer = new TerminalContainer(this.myProject, this.myContent, newTerminalWidget, this.myTerminalView);
        splitter.setSecondComponent(newContainer.getComponent());
        parent.add((Component)splitter, "Center");
        parent.revalidate();
        if (hasFocus) {
            this.requestFocus(this.myTerminalWidget);
        }
    }

    @NotNull
    private static Splitter createSplitter(boolean vertically) {
        OnePixelSplitter splitter = new OnePixelSplitter(vertically, 0.5f, 0.1f, 0.9f);
        splitter.setDividerWidth(JBUI.scale((int)1));
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        if (color != null) {
            splitter.getDivider().setBackground(color);
        }
        OnePixelSplitter onePixelSplitter = splitter;
        if (onePixelSplitter == null) {
            TerminalContainer.$$$reportNull$$$0(10);
        }
        return onePixelSplitter;
    }

    private void onSessionClosed() {
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            JBTerminalWidget nextToFocus = null;
            if (this.myTerminalWidget.getTerminalPanel().hasFocus()) {
                nextToFocus = this.getNextSplitTerminal(true);
            }
            Splitter splitter = (Splitter)parent;
            parent = parent.getParent();
            JComponent otherComponent = this.myPanel.equals(splitter.getFirstComponent()) ? splitter.getSecondComponent() : splitter.getFirstComponent();
            Component realComponent = TerminalContainer.unwrapComponent(otherComponent);
            if (realComponent instanceof JBTerminalWidget) {
                TerminalContainer otherContainer = this.myTerminalView.getContainer((JBTerminalWidget)realComponent);
                otherContainer.myPanel = (JPanel)parent;
            }
            realComponent.getParent().remove(realComponent);
            parent.remove((Component)splitter);
            parent.add(realComponent, "Center");
            parent.revalidate();
            if (nextToFocus != null) {
                this.requestFocus(nextToFocus);
            }
            this.myTerminalView.unregister(this);
        } else {
            this.myTerminalView.closeTab(this.myContent);
        }
    }

    public boolean isSplitTerminal() {
        return this.findRootSplitter() != null;
    }

    @Nullable
    public JBTerminalWidget getNextSplitTerminal(boolean forward) {
        List<JBTerminalWidget> terminals = this.listTerminals();
        int ind = terminals.indexOf(this.myTerminalWidget);
        if (ind < 0) {
            LOG.error("All split terminal list (" + terminals.size() + ") doesn't contain this terminal");
            return null;
        }
        if (terminals.size() == 1) {
            return null;
        }
        int newInd = (ind + (forward ? 1 : terminals.size() - 1)) % terminals.size();
        return terminals.get(newInd);
    }

    @NotNull
    private List<JBTerminalWidget> listTerminals() {
        Splitter rootSplitter = this.findRootSplitter();
        if (rootSplitter == null) {
            List<JBTerminalWidget> list = Collections.singletonList(this.myTerminalWidget);
            if (list == null) {
                TerminalContainer.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<JBTerminalWidget> terminals = new ArrayList<JBTerminalWidget>();
        this.traverseSplitters(rootSplitter, terminals);
        ArrayList<JBTerminalWidget> arrayList = terminals;
        if (arrayList == null) {
            TerminalContainer.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private void traverseSplitters(@NotNull Splitter splitter, @NotNull List<JBTerminalWidget> terminals) {
        if (splitter == null) {
            TerminalContainer.$$$reportNull$$$0(13);
        }
        if (terminals == null) {
            TerminalContainer.$$$reportNull$$$0(14);
        }
        this.traverseParentPanel(splitter.getFirstComponent(), terminals);
        this.traverseParentPanel(splitter.getSecondComponent(), terminals);
    }

    private void traverseParentPanel(@NotNull JComponent parentPanel, @NotNull List<JBTerminalWidget> terminals) {
        Component[] components;
        if (parentPanel == null) {
            TerminalContainer.$$$reportNull$$$0(15);
        }
        if (terminals == null) {
            TerminalContainer.$$$reportNull$$$0(16);
        }
        if ((components = parentPanel.getComponents()).length == 1) {
            Component c = components[0];
            if (c instanceof Splitter) {
                this.traverseSplitters((Splitter)c, terminals);
            } else if (c instanceof JBTerminalWidget) {
                terminals.add((JBTerminalWidget)c);
            }
        }
    }

    @Nullable
    private Splitter findRootSplitter() {
        Splitter splitter = (Splitter)ObjectUtils.tryCast((Object)this.myPanel.getParent(), Splitter.class);
        while (splitter != null) {
            Splitter parentSplitter;
            Container panel = splitter.getParent();
            Splitter splitter2 = parentSplitter = panel != null ? (Splitter)ObjectUtils.tryCast((Object)panel.getParent(), Splitter.class) : null;
            if (parentSplitter != null) {
                splitter = parentSplitter;
                continue;
            }
            return splitter;
        }
        return null;
    }

    @NotNull
    private static Component unwrapComponent(@NotNull JComponent component) {
        Component c;
        Object[] components;
        if (component == null) {
            TerminalContainer.$$$reportNull$$$0(17);
        }
        if ((components = component.getComponents()).length == 1 && ((c = components[0]) instanceof JBTerminalWidget || c instanceof Splitter)) {
            Component component2 = c;
            if (component2 == null) {
                TerminalContainer.$$$reportNull$$$0(18);
            }
            return component2;
        }
        LOG.error("Cannot unwrap " + component + ", children: " + Arrays.toString(components));
        JComponent jComponent = component;
        if (jComponent == null) {
            TerminalContainer.$$$reportNull$$$0(19);
        }
        return jComponent;
    }

    public void requestFocus(@NotNull JBTerminalWidget terminal) {
        if (terminal == null) {
            TerminalContainer.$$$reportNull$$$0(20);
        }
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)terminal.getTerminalPanel(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalView";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTerminalWidget";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminals";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPanel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/ui/TerminalContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSplitter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "listTerminals";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "traverseSplitters";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "traverseParentPanel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unwrapComponent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

