/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.ReaderModeProvider;
import com.intellij.codeInsight.actions.ReaderModeSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/actions/FontReaderModeProvider;", "Lcom/intellij/codeInsight/actions/ReaderModeProvider;", "()V", "applyModeChanged", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "readerMode", "", "fileIsOpenAlready", "setLineSpacing", "lineSpacing", "", "intellij.platform.lang.impl"})
public final class FontReaderModeProvider
implements ReaderModeProvider {
    @Override
    public void applyModeChanged(@NotNull Project project, @NotNull Editor editor, boolean readerMode, boolean fileIsOpenAlready) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (readerMode) {
            if (ReaderModeSettings.Companion.instance(project).getIncreaseLineSpacing()) {
                this.setLineSpacing(editor, 1.4f);
            }
        } else {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            FontPreferences fontPreferences = appEditorFontOptions.getFontPreferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)fontPreferences, (String)"AppEditorFontOptions.getInstance().fontPreferences");
            this.setLineSpacing(editor, fontPreferences.getLineSpacing());
        }
    }

    private final void setLineSpacing(Editor editor, float lineSpacing) {
        EditorScrollingPositionKeeper.perform(editor, false, new Runnable(editor, lineSpacing){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ float $lineSpacing;

            public final void run() {
                EditorColorsScheme editorColorsScheme = this.$editor.getColorsScheme();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"editor.colorsScheme");
                editorColorsScheme.setLineSpacing(this.$lineSpacing);
            }
            {
                this.$editor = editor;
                this.$lineSpacing = f;
            }
        });
    }
}

