/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.Helpers;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ThreadLocalRandom;
import gnu.trove.TObjectHashingStrategy;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

final class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
TObjectHashingStrategy<K> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = 65535;
    private static final int RESIZE_STAMP_SHIFT = 16;
    static final int MOVED = -1;
    static final int TREEBIN = -2;
    static final int RESERVED = -3;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("segments", Segment[].class), new ObjectStreamField("segmentMask", Integer.TYPE), new ObjectStreamField("segmentShift", Integer.TYPE)};
    private final TObjectHashingStrategy<K> hashingStrategy;
    volatile transient Node<K, V>[] table;
    private volatile transient Node<K, V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient KeySetView<K, V> keySet;
    private transient ValuesView<K, V> values;
    private transient EntrySetView<K, V> entrySet;
    private static final TObjectHashingStrategy THIS = new TObjectHashingStrategy(){

        public int computeHashCode(Object object) {
            throw new IncorrectOperationException();
        }

        public boolean equals(Object o1, Object o2) {
            throw new IncorrectOperationException();
        }
    };
    private static final Unsafe U = AtomicFieldUpdater.getUnsafe();
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final int ABASE;
    private static final int ASHIFT;

    static final int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    private static final int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static Class<?> comparableClassFor(Object x) {
        if (x instanceof Comparable) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (int i2 = 0; i2 < ts.length; ++i2) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = ts[i2];
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> kc, Object k, Object x) {
        return x == null || x.getClass() != kc ? 0 : ((Comparable)k).compareTo(x);
    }

    static final <K, V> Node<K, V> tabAt(Node<K, V>[] tab, int i2) {
        return (Node)U.getObjectVolatile(tab, ((long)i2 << ASHIFT) + (long)ABASE);
    }

    static final <K, V> boolean casTabAt(Node<K, V>[] tab, int i2, Node<K, V> c, Node<K, V> v) {
        return U.compareAndSwapObject(tab, ((long)i2 << ASHIFT) + (long)ABASE, c, v);
    }

    static final <K, V> void setTabAt(Node<K, V>[] tab, int i2, Node<K, V> v) {
        U.putObjectVolatile(tab, ((long)i2 << ASHIFT) + (long)ABASE, v);
    }

    ConcurrentHashMap() {
        this(16, 0.75f);
    }

    ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    ConcurrentHashMap(Map<? extends K, ? extends V> m) {
        this(16);
        this.putAll(m);
    }

    ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this(initialCapacity, loadFactor, concurrencyLevel, THIS);
    }

    ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        long size;
        int cap;
        if (hashingStrategy == null) {
            ConcurrentHashMap.$$$reportNull$$$0(0);
        }
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentHashMap.tableSizeFor((int)size);
        this.hashingStrategy = hashingStrategy == THIS ? this : hashingStrategy;
    }

    ConcurrentHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentHashMap.$$$reportNull$$$0(1);
        }
        this(16, 0.75f, NCPU, hashingStrategy);
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(Object key) {
        Node<K, V> e;
        int n;
        int h = this.hash(key);
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = ConcurrentHashMap.tabAt(tab, n - 1 & h)) != null) {
            Object ek;
            int eh = e.hash;
            if (eh == h) {
                ek = e.key;
                if (ek == key || ek != null && this.isEqual(key, ek)) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<K, V> p = e.find(h, key);
                return p != null ? (V)p.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || (ek = e.key) != key && (ek == null || !this.isEqual(key, ek))) continue;
                return e.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object v = p.val;
                if (v != value2 && (v == null || !value2.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value2) {
        return this.putVal(key, value2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(K key, V value2, boolean onlyIfAbsent) {
        int binCount;
        block21: {
            V oldVal;
            int i2;
            if (key == null || value2 == null) {
                throw new NullPointerException();
            }
            int hash = this.hash(key);
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n - 1 & hash;
                Node<K, V> f = ConcurrentHashMap.tabAt(tab, i2);
                if (f == null) {
                    if (!ConcurrentHashMap.casTabAt(tab, i2, null, new Node<K, V>(hash, key, value2, this.hashingStrategy))) continue;
                    break block21;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                oldVal = null;
                Node<K, V> node = f;
                synchronized (node) {
                    block22: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                while (true) {
                                    Object ek;
                                    if (e.hash == hash && ((ek = e.key) == key || ek != null && this.isEqual(key, ek))) {
                                        oldVal = e.val;
                                        if (!onlyIfAbsent) {
                                            e.val = value2;
                                        }
                                        break block22;
                                    }
                                    Node<K, V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = new Node<K, V>(hash, key, value2, this.hashingStrategy);
                                        break block22;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<K, V> p = ((TreeBin)f).putTreeVal(hash, key, value2);
                                if (p != null) {
                                    oldVal = p.val;
                                    if (!onlyIfAbsent) {
                                        p.val = value2;
                                    }
                                }
                            } else if (f instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.tryPresize(m.size());
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.putVal(e.getKey(), e.getValue(), false);
        }
    }

    @Override
    public V remove(Object key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(Object key, V value2, Object cv) {
        int i2;
        Node<K, V> f;
        int n;
        int hash = this.hash(key);
        Node<K, V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = ConcurrentHashMap.tabAt(tab, i2 = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<K, V> node = f;
            synchronized (node) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<K, V> e = f;
                        Node<K, V> pred = null;
                        do {
                            Object ek;
                            if (e.hash == hash && ((ek = e.key) == key || ek != null && this.isEqual(key, ek))) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value2 != null) {
                                        e.val = value2;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        ConcurrentHashMap.setTabAt(tab, i2, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key, null)) != null) {
                            Object pv = p.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value2 != null) {
                                    p.val = value2;
                                } else if (t.removeTreeNode(p)) {
                                    ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t.first));
                                }
                            }
                        }
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value2 == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i2 = 0;
        Node<K, V>[] tab = this.table;
        while (tab != null && i2 < tab.length) {
            Node<K, V> f = ConcurrentHashMap.tabAt(tab, i2);
            if (f == null) {
                ++i2;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i2 = 0;
                continue;
            }
            Node<K, V> node = f;
            synchronized (node) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                    Node<K, V> p;
                    Node<K, V> node2 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)f).first : null);
                    while (p != null) {
                        --delta;
                        p = p.next;
                    }
                    ConcurrentHashMap.setTabAt(tab, i2++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    public KeySetView<K, V> keySet() {
        KeySetView<K, V> ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySetView(this, null);
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        ValuesView<K, V> vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new ValuesView(this);
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<K, V> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySetView(this);
        return this.entrySet;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                h += this.hash(p.key) ^ p.val.hashCode();
            }
        }
        return h;
    }

    @Override
    public String toString() {
        Node<K, V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        Traverser<K, V> it = new Traverser<K, V>(t, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<K, V> p = it.advance();
        if (p != null) {
            while (true) {
                Object k = p.key;
                Object v = p.val;
                sb.append((Object)(k == this ? "(this Map)" : k));
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                p = it.advance();
                if (p == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            Node<K, V> p;
            if (!(o instanceof Map)) {
                return false;
            }
            Map m = (Map)o;
            Node<K, V>[] t = this.table;
            int f = this.table == null ? 0 : t.length;
            Traverser<K, V> it = new Traverser<K, V>(t, f, 0, f);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                Object v = m.get(p.key);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (Map.Entry e : m.entrySet()) {
                V v;
                Object mv;
                Object mk = e.getKey();
                if (mk != null && (mv = e.getValue()) != null && (v = this.get(mk)) != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public V putIfAbsent(K key, V value2) {
        return this.putVal(key, value2, true);
    }

    @Override
    public boolean remove(Object key, Object value2) {
        if (key == null) {
            throw new NullPointerException();
        }
        return value2 != null && this.replaceNode(key, null, value2) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue2) {
        if (key == null || oldValue == null || newValue2 == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(key, newValue2, oldValue) != null;
    }

    @Override
    public V replace(K key, V value2) {
        if (key == null || value2 == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(key, value2, null);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        return v == null ? defaultValue : v;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                action2.accept(p.key, p.val);
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                V newValue2;
                Object oldValue = p.val;
                Object key = p.key;
                do {
                    if ((newValue2 = function.apply(key, oldValue)) != null) continue;
                    throw new NullPointerException();
                } while (this.replaceNode(key, newValue2, oldValue) == null && (oldValue = this.get(key)) != null);
            }
        }
    }

    boolean removeEntryIf(Predicate<? super Map.Entry<K, V>> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object k = p.key;
                Object v = p.val;
                AbstractMap.SimpleImmutableEntry e = new AbstractMap.SimpleImmutableEntry(k, v);
                if (!function.test(e) || this.replaceNode(k, null, v) == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    boolean removeValueIf(Predicate<? super V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        boolean removed = false;
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object k = p.key;
                Object v = p.val;
                if (!function.test(v) || this.replaceNode(k, null, v) == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        int binCount;
        Object val;
        block33: {
            boolean added;
            int i2;
            if (key == null || mappingFunction == null) {
                throw new NullPointerException();
            }
            int h = this.hash(key);
            val = null;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                Node node;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n - 1 & h;
                Node<K, V> f = ConcurrentHashMap.tabAt(tab, i2);
                if (f == null) {
                    ReservationNode r;
                    node = r = new ReservationNode(this.hashingStrategy);
                    synchronized (node) {
                        if (ConcurrentHashMap.casTabAt(tab, i2, null, r)) {
                            binCount = 1;
                            Node<K, Object> node2 = null;
                            try {
                                V v = mappingFunction.apply(key);
                                val = v;
                                if (v != null) {
                                    node2 = new Node<K, Object>(h, key, val, this.hashingStrategy);
                                }
                            }
                            finally {
                                ConcurrentHashMap.setTabAt(tab, i2, node2);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block33;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                added = false;
                node = f;
                synchronized (node) {
                    block34: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                while (true) {
                                    Object ek;
                                    if (e.hash == h && ((ek = e.key) == key || ek != null && this.isEqual(key, ek))) {
                                        val = e.val;
                                        break block34;
                                    }
                                    Node<K, V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        V v = mappingFunction.apply(key);
                                        val = v;
                                        if (v != null) {
                                            if (pred.next != null) {
                                                throw new IllegalStateException("Recursive update");
                                            }
                                            added = true;
                                            pred.next = new Node<K, Object>(h, key, val, this.hashingStrategy);
                                        }
                                        break block34;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                TreeNode p;
                                binCount = 2;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                if (r != null && (p = r.findTreeNode(h, key, null)) != null) {
                                    val = p.val;
                                } else {
                                    V v = mappingFunction.apply(key);
                                    val = v;
                                    if (v != null) {
                                        added = true;
                                        t.putTreeVal(h, key, val);
                                    }
                                }
                            } else if (f instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
            if (!added) {
                return (V)val;
            }
        }
        if (val != null) {
            this.addCount(1L, binCount);
        }
        return (V)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        V val = null;
        int delta = 0;
        int binCount = 0;
        Node<K, V>[] tab = this.table;
        while (true) {
            int n;
            if (tab == null || (n = tab.length) == 0) {
                tab = this.initTable();
                continue;
            }
            int i2 = n - 1 & h;
            Node<K, V> f = ConcurrentHashMap.tabAt(tab, i2);
            if (f == null) break;
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Node<K, V> node = f;
            synchronized (node) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                    if (fh >= 0) {
                        binCount = 1;
                        Node<K, V> e = f;
                        Node<K, V> pred = null;
                        while (true) {
                            Object ek;
                            if (e.hash == h && ((ek = e.key) == key || ek != null && this.isEqual(key, ek))) {
                                val = remappingFunction.apply(key, e.val);
                                if (val != null) {
                                    e.val = val;
                                } else {
                                    delta = -1;
                                    Node en = e.next;
                                    if (pred != null) {
                                        pred.next = en;
                                    } else {
                                        ConcurrentHashMap.setTabAt(tab, i2, en);
                                    }
                                }
                            } else {
                                pred = e;
                                e = e.next;
                                if (e != null) {
                                    ++binCount;
                                    continue;
                                }
                            }
                            break;
                        }
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        binCount = 2;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(h, key, null)) != null) {
                            val = remappingFunction.apply(key, p.val);
                            if (val != null) {
                                p.val = val;
                            } else {
                                delta = -1;
                                if (t.removeTreeNode(p)) {
                                    ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t.first));
                                }
                            }
                        }
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (binCount != 0) break;
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        int binCount;
        int delta;
        Object val;
        block39: {
            int i2;
            if (key == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            int h = this.hash(key);
            val = null;
            delta = 0;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n - 1 & h;
                Node<K, V> f = ConcurrentHashMap.tabAt(tab, i2);
                if (f == null) {
                    ReservationNode r;
                    ReservationNode reservationNode = r = new ReservationNode(this.hashingStrategy);
                    synchronized (reservationNode) {
                        if (ConcurrentHashMap.casTabAt(tab, i2, null, r)) {
                            binCount = 1;
                            Node<K, Object> node = null;
                            try {
                                V v = remappingFunction.apply(key, null);
                                val = v;
                                if (v != null) {
                                    delta = 1;
                                    node = new Node<K, Object>(h, key, val, this.hashingStrategy);
                                }
                            }
                            finally {
                                ConcurrentHashMap.setTabAt(tab, i2, node);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block39;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                Node<K, V> node = f;
                synchronized (node) {
                    block40: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                Node<K, V> pred = null;
                                while (true) {
                                    Object ek;
                                    if (e.hash == h && ((ek = e.key) == key || ek != null && this.isEqual(key, ek))) {
                                        val = remappingFunction.apply(key, e.val);
                                        if (val != null) {
                                            e.val = val;
                                        } else {
                                            delta = -1;
                                            Node en = e.next;
                                            if (pred != null) {
                                                pred.next = en;
                                            } else {
                                                ConcurrentHashMap.setTabAt(tab, i2, en);
                                            }
                                        }
                                        break block40;
                                    }
                                    pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        val = remappingFunction.apply(key, null);
                                        if (val != null) {
                                            if (pred.next != null) {
                                                throw new IllegalStateException("Recursive update");
                                            }
                                            delta = 1;
                                            pred.next = new Node<K, Object>(h, key, val, this.hashingStrategy);
                                        }
                                        break block40;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 1;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                TreeNode p = r != null ? r.findTreeNode(h, key, null) : null;
                                Object pv = p == null ? null : p.val;
                                val = remappingFunction.apply(key, pv);
                                if (val != null) {
                                    if (p != null) {
                                        p.val = val;
                                    } else {
                                        delta = 1;
                                        t.putTreeVal(h, key, val);
                                    }
                                } else if (p != null) {
                                    delta = -1;
                                    if (t.removeTreeNode(p)) {
                                        ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t.first));
                                    }
                                }
                            } else if (f instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value2, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        int binCount;
        int delta;
        Object val;
        block28: {
            int i2;
            if (key == null || value2 == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            int h = this.hash(key);
            val = null;
            delta = 0;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n - 1 & h;
                Node<K, V> f = ConcurrentHashMap.tabAt(tab, i2);
                if (f == null) {
                    if (!ConcurrentHashMap.casTabAt(tab, i2, null, new Node<K, V>(h, key, value2, this.hashingStrategy))) continue;
                    delta = 1;
                    val = value2;
                    break block28;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                Node<K, V> node = f;
                synchronized (node) {
                    block29: {
                        if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                Node<K, V> pred = null;
                                while (true) {
                                    Object ek;
                                    if (e.hash == h && ((ek = e.key) == key || ek != null && this.isEqual(key, ek))) {
                                        val = remappingFunction.apply(e.val, value2);
                                        if (val != null) {
                                            e.val = val;
                                        } else {
                                            delta = -1;
                                            Node en = e.next;
                                            if (pred != null) {
                                                pred.next = en;
                                            } else {
                                                ConcurrentHashMap.setTabAt(tab, i2, en);
                                            }
                                        }
                                        break block29;
                                    }
                                    pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        delta = 1;
                                        val = value2;
                                        pred.next = new Node<K, Object>(h, key, val, this.hashingStrategy);
                                        break block29;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                TreeNode p = r == null ? null : r.findTreeNode(h, key, null);
                                val = p == null ? value2 : remappingFunction.apply(p.val, value2);
                                if (val != null) {
                                    if (p != null) {
                                        p.val = val;
                                    } else {
                                        delta = 1;
                                        t.putTreeVal(h, key, val);
                                    }
                                } else if (p != null) {
                                    delta = -1;
                                    if (t.removeTreeNode(p)) {
                                        ConcurrentHashMap.setTabAt(tab, i2, this.untreeify(t.first));
                                    }
                                }
                            } else if (f instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    public boolean contains(Object value2) {
        return this.containsValue(value2);
    }

    public Enumeration<K> keys() {
        Node<K, V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        return new KeyIterator<K, V>(t, f, 0, f, this);
    }

    public Enumeration<V> elements() {
        Node<K, V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        return new ValueIterator<K, V>(t, f, 0, f, this);
    }

    public long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    public static <K> KeySetView<K, Boolean> newKeySet() {
        return new KeySetView<K, Boolean>(new ConcurrentHashMap(), Boolean.TRUE);
    }

    public static <K> KeySetView<K, Boolean> newKeySet(int initialCapacity) {
        return new KeySetView<K, Boolean>(new ConcurrentHashMap(initialCapacity), Boolean.TRUE);
    }

    public KeySetView<K, V> keySet(V mappedValue) {
        if (mappedValue == null) {
            throw new NullPointerException();
        }
        return new KeySetView(this, mappedValue);
    }

    static final int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 0x8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<K, V>[] initTable() {
        Node<K, V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (U.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private final void addCount(long x, int check) {
        long s;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !U.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            CounterCell a;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a = as[ThreadLocalRandom.getProbe() & m]) == null || !(uncontended = U.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                int n;
                Node<K, V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = ConcurrentHashMap.resizeStamp(n);
                if (sc < 0) {
                    if (sc >>> 16 != rs || sc == rs + 1 || sc == rs + 65535) break;
                    Node<K, V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (U.compareAndSwapInt(this, SIZECTL, sc, (rs << 16) + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    final Node<K, V>[] helpTransfer(Node<K, V>[] tab, Node<K, V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<K, V>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = ConcurrentHashMap.resizeStamp(tab.length);
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc >>> 16 == rs && sc != rs + 1 && sc != rs + 65535 && this.transferIndex > 0) {
                    if (!U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int rs;
            int n2;
            Node<K, V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table || !U.compareAndSwapInt(this, SIZECTL, sc, ((rs = ConcurrentHashMap.resizeStamp(n2)) << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(Node<K, V>[] tab, Node<K, V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode<K, V> fwd = new ForwardingNode<K, V>(nextTab, this.hashingStrategy);
        boolean advance = true;
        boolean finishing = false;
        int i2 = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i2 >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i2 = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!U.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i2 = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i2 < 0 || i2 >= n || i2 + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentHashMap.resizeStamp(n) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i2 = n;
                continue;
            }
            TreeBin f = ConcurrentHashMap.tabAt(tab, i2);
            if (f == null) {
                advance = ConcurrentHashMap.casTabAt(tab, i2, null, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (ConcurrentHashMap.tabAt(tab, i2) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            Object pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln, this.hashingStrategy);
                            } else {
                                hn = new Node(ph, pk, pv, hn, this.hashingStrategy);
                            }
                            p = p.next;
                        }
                        ConcurrentHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentHashMap.setTabAt(nextTab, i2 + n, hn);
                        ConcurrentHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p = new TreeNode(h, e.key, e.val, null, null, this.hashingStrategy);
                            if ((h & n) == 0) {
                                p.prev = loTail;
                                if (p.prev == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                p.prev = hiTail;
                                if (p.prev == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? this.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo, this.hashingStrategy) : t);
                        hn = hc <= 6 ? this.untreeify(hi) : (lc != 0 ? new TreeBin(hi, this.hashingStrategy) : t);
                        ConcurrentHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentHashMap.setTabAt(nextTab, i2 + n, hn);
                        ConcurrentHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    }
                }
            }
        }
    }

    final long sumCount() {
        CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (int i2 = 0; i2 < as.length; ++i2) {
                CounterCell a = as[i2];
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fullAddCount(long x, boolean wasUncontended) {
        int h = ThreadLocalRandom.getProbe();
        if (h == 0) {
            ThreadLocalRandom.localInit();
            h = ThreadLocalRandom.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                CounterCell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (U.compareAndSwapLong(a, CELLVALUE, v, v + x)) return;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                CounterCell[] rs = new CounterCell[n << 1];
                                for (int i2 = 0; i2 < n; ++i2) {
                                    rs[i2] = as[i2];
                                }
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = ThreadLocalRandom.advanceProbe((int)h);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == as && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init2 = false;
                try {
                    if (this.counterCells == as) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init2 = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init2) continue;
                return;
            }
            v = this.baseCount;
            if (U.compareAndSwapLong(this, BASECOUNT, v, v + x)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(Node<K, V>[] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<K, V> b = ConcurrentHashMap.tabAt(tab, index);
                if (b != null && b.hash >= 0) {
                    Node<K, V> node = b;
                    synchronized (node) {
                        if (ConcurrentHashMap.tabAt(tab, index) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<K, V> e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, e.val, null, null, this.hashingStrategy);
                                p.prev = tl;
                                if (p.prev == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            ConcurrentHashMap.setTabAt(tab, index, new TreeBin(hd, this.hashingStrategy));
                        }
                    }
                }
            }
        }
    }

    Node<K, V> untreeify(Node<K, V> b) {
        Node hd = null;
        Node tl = null;
        Node<K, V> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, q.val, this.hashingStrategy);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    final int batchFor(long b) {
        long n;
        if (b == Long.MAX_VALUE || (n = this.sumCount()) <= 1L || n < b) {
            return 0;
        }
        int sp = ForkJoinPool.getCommonPoolParallelism() << 2;
        return b <= 0L || (n /= b) >= (long)sp ? sp : (int)n;
    }

    public void forEach(long parallelismThreshold, BiConsumer<? super K, ? super V> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachMappingTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEach(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedMappingTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U search(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchMappingsTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public <U> U reduce(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceMappingsTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceToDouble(long parallelismThreshold, ToDoubleBiFunction<? super K, ? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceMappingsToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceToLong(long parallelismThreshold, ToLongBiFunction<? super K, ? super V> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceMappingsToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceToInt(long parallelismThreshold, ToIntBiFunction<? super K, ? super V> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceMappingsToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachKey(long parallelismThreshold, Consumer<? super K> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachKeyTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEachKey(long parallelismThreshold, Function<? super K, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedKeyTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U searchKeys(long parallelismThreshold, Function<? super K, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchKeysTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public K reduceKeys(long parallelismThreshold, BiFunction<? super K, ? super K, ? extends K> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return (K)new ReduceKeysTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceKeys(long parallelismThreshold, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceKeysTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceKeysToDouble(long parallelismThreshold, ToDoubleFunction<? super K> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceKeysToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceKeysToLong(long parallelismThreshold, ToLongFunction<? super K> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceKeysToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceKeysToInt(long parallelismThreshold, ToIntFunction<? super K> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceKeysToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachValue(long parallelismThreshold, Consumer<? super V> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachValueTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEachValue(long parallelismThreshold, Function<? super V, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedValueTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U searchValues(long parallelismThreshold, Function<? super V, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchValuesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public V reduceValues(long parallelismThreshold, BiFunction<? super V, ? super V, ? extends V> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return new ReduceValuesTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceValues(long parallelismThreshold, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceValuesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceValuesToDouble(long parallelismThreshold, ToDoubleFunction<? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceValuesToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceValuesToLong(long parallelismThreshold, ToLongFunction<? super V> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceValuesToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceValuesToInt(long parallelismThreshold, ToIntFunction<? super V> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceValuesToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachEntry(long parallelismThreshold, Consumer<? super Map.Entry<K, V>> action2) {
        if (action2 == null) {
            throw new NullPointerException();
        }
        new ForEachEntryTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action2).invoke();
    }

    public <U> void forEachEntry(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, Consumer<? super U> action2) {
        if (transformer == null || action2 == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedEntryTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action2).invoke();
    }

    public <U> U searchEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchEntriesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public Map.Entry<K, V> reduceEntries(long parallelismThreshold, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return (Map.Entry)new ReduceEntriesTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceEntriesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceEntriesToDouble(long parallelismThreshold, ToDoubleFunction<Map.Entry<K, V>> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceEntriesToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceEntriesToLong(long parallelismThreshold, ToLongFunction<Map.Entry<K, V>> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceEntriesToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceEntriesToInt(long parallelismThreshold, ToIntFunction<Map.Entry<K, V>> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceEntriesToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int computeHashCode(K object) {
        return object == null ? 0 : object.hashCode();
    }

    public boolean equals(K o1, K o2) {
        return o1.equals(o2);
    }

    private int hash(K key) {
        return ConcurrentHashMap.spread(this.hashingStrategy.computeHashCode(key));
    }

    private boolean isEqual(@NotNull K key1, K key2) {
        if (key1 == null) {
            ConcurrentHashMap.$$$reportNull$$$0(2);
        }
        return ConcurrentHashMap.isEqual(key1, key2, this.hashingStrategy);
    }

    private static <K> boolean isEqual(@NotNull K key1, K key2, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (key1 == null) {
            ConcurrentHashMap.$$$reportNull$$$0(3);
        }
        if (hashingStrategy == null) {
            ConcurrentHashMap.$$$reportNull$$$0(4);
        }
        return key1 == key2 || key2 != null && hashingStrategy.equals(key1, key2);
    }

    static {
        try {
            SIZECTL = U.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = U.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("transferIndex"));
            BASECOUNT = U.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("baseCount"));
            CELLSBUSY = U.objectFieldOffset(ConcurrentHashMap.class.getDeclaredField("cellsBusy"));
            CELLVALUE = U.objectFieldOffset(CounterCell.class.getDeclaredField("value"));
            ABASE = U.arrayBaseOffset(Node[].class);
            int scale = U.arrayIndexScale(Node[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("array index scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        Class<LockSupport> clazz = LockSupport.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key1";
                break;
            }
        }
        objectArray2[1] = "com/intellij/concurrency/ConcurrentHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqual";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MapReduceMappingsToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntBiFunction<? super K, ? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceMappingsToIntTask<K, V> rights;
        MapReduceMappingsToIntTask<K, V> nextRight;

        MapReduceMappingsToIntTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceMappingsToIntTask<K, V> nextRight, ToIntBiFunction<? super K, ? super V> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p.key, p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToIntTask t = (MapReduceMappingsToIntTask)c;
                    MapReduceMappingsToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<Map.Entry<K, V>> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceEntriesToIntTask<K, V> rights;
        MapReduceEntriesToIntTask<K, V> nextRight;

        MapReduceEntriesToIntTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceEntriesToIntTask<K, V> nextRight, ToIntFunction<Map.Entry<K, V>> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToIntTask t = (MapReduceEntriesToIntTask)c;
                    MapReduceEntriesToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceValuesToIntTask<K, V> rights;
        MapReduceValuesToIntTask<K, V> nextRight;

        MapReduceValuesToIntTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceValuesToIntTask<K, V> nextRight, ToIntFunction<? super V> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToIntTask t = (MapReduceValuesToIntTask)c;
                    MapReduceValuesToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super K> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceKeysToIntTask<K, V> rights;
        MapReduceKeysToIntTask<K, V> nextRight;

        MapReduceKeysToIntTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceKeysToIntTask<K, V> nextRight, ToIntFunction<? super K> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p.key));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToIntTask t = (MapReduceKeysToIntTask)c;
                    MapReduceKeysToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongBiFunction<? super K, ? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceMappingsToLongTask<K, V> rights;
        MapReduceMappingsToLongTask<K, V> nextRight;

        MapReduceMappingsToLongTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceMappingsToLongTask<K, V> nextRight, ToLongBiFunction<? super K, ? super V> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p.key, p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToLongTask t = (MapReduceMappingsToLongTask)c;
                    MapReduceMappingsToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<Map.Entry<K, V>> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceEntriesToLongTask<K, V> rights;
        MapReduceEntriesToLongTask<K, V> nextRight;

        MapReduceEntriesToLongTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceEntriesToLongTask<K, V> nextRight, ToLongFunction<Map.Entry<K, V>> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToLongTask t = (MapReduceEntriesToLongTask)c;
                    MapReduceEntriesToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceValuesToLongTask<K, V> rights;
        MapReduceValuesToLongTask<K, V> nextRight;

        MapReduceValuesToLongTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceValuesToLongTask<K, V> nextRight, ToLongFunction<? super V> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToLongTask t = (MapReduceValuesToLongTask)c;
                    MapReduceValuesToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super K> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceKeysToLongTask<K, V> rights;
        MapReduceKeysToLongTask<K, V> nextRight;

        MapReduceKeysToLongTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceKeysToLongTask<K, V> nextRight, ToLongFunction<? super K> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p.key));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToLongTask t = (MapReduceKeysToLongTask)c;
                    MapReduceKeysToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleBiFunction<? super K, ? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceMappingsToDoubleTask<K, V> rights;
        MapReduceMappingsToDoubleTask<K, V> nextRight;

        MapReduceMappingsToDoubleTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceMappingsToDoubleTask<K, V> nextRight, ToDoubleBiFunction<? super K, ? super V> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p.key, p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToDoubleTask t = (MapReduceMappingsToDoubleTask)c;
                    MapReduceMappingsToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<Map.Entry<K, V>> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceEntriesToDoubleTask<K, V> rights;
        MapReduceEntriesToDoubleTask<K, V> nextRight;

        MapReduceEntriesToDoubleTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceEntriesToDoubleTask<K, V> nextRight, ToDoubleFunction<Map.Entry<K, V>> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToDoubleTask t = (MapReduceEntriesToDoubleTask)c;
                    MapReduceEntriesToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceValuesToDoubleTask<K, V> rights;
        MapReduceValuesToDoubleTask<K, V> nextRight;

        MapReduceValuesToDoubleTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceValuesToDoubleTask<K, V> nextRight, ToDoubleFunction<? super V> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToDoubleTask t = (MapReduceValuesToDoubleTask)c;
                    MapReduceValuesToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super K> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceKeysToDoubleTask<K, V> rights;
        MapReduceKeysToDoubleTask<K, V> nextRight;

        MapReduceKeysToDoubleTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceKeysToDoubleTask<K, V> nextRight, ToDoubleFunction<? super K> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p.key));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToDoubleTask t = (MapReduceKeysToDoubleTask)c;
                    MapReduceKeysToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceMappingsTask<K, V, U> rights;
        MapReduceMappingsTask<K, V, U> nextRight;

        MapReduceMappingsTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceMappingsTask<K, V, U> nextRight, BiFunction<? super K, ? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            BiFunction transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.key, p.val);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsTask t = (MapReduceMappingsTask)c;
                    MapReduceMappingsTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceEntriesTask<K, V, U> rights;
        MapReduceEntriesTask<K, V, U> nextRight;

        MapReduceEntriesTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceEntriesTask<K, V, U> nextRight, Function<Map.Entry<K, V>, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesTask t = (MapReduceEntriesTask)c;
                    MapReduceEntriesTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceValuesTask<K, V, U> rights;
        MapReduceValuesTask<K, V, U> nextRight;

        MapReduceValuesTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceValuesTask<K, V, U> nextRight, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<V, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.val);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesTask t = (MapReduceValuesTask)c;
                    MapReduceValuesTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceKeysTask<K, V, U> rights;
        MapReduceKeysTask<K, V, U> nextRight;

        MapReduceKeysTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, MapReduceKeysTask<K, V, U> nextRight, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<K, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.key);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysTask t = (MapReduceKeysTask)c;
                    MapReduceKeysTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceEntriesTask<K, V>
    extends BulkTask<K, V, Map.Entry<K, V>> {
        final BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer;
        Map.Entry<K, V> result;
        ReduceEntriesTask<K, V> rights;
        ReduceEntriesTask<K, V> nextRight;

        ReduceEntriesTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, ReduceEntriesTask<K, V> nextRight, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final Map.Entry<K, V> getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, Map.Entry<K, V>> reducer = this.reducer;
            if (reducer != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new ReduceEntriesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Node r = null;
                while ((p = this.advance()) != null) {
                    r = r == null ? p : reducer.apply(r, p);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceEntriesTask t = (ReduceEntriesTask)c;
                    ReduceEntriesTask<K, V> s = t.rights;
                    while (s != null) {
                        Map.Entry<K, V> sr = s.result;
                        if (sr != null) {
                            Map.Entry<K, V> tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceValuesTask<K, V>
    extends BulkTask<K, V, V> {
        final BiFunction<? super V, ? super V, ? extends V> reducer;
        V result;
        ReduceValuesTask<K, V> rights;
        ReduceValuesTask<K, V> nextRight;

        ReduceValuesTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, ReduceValuesTask<K, V> nextRight, BiFunction<? super V, ? super V, ? extends V> reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final V getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<V, V, V> reducer = this.reducer;
            if (reducer != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new ReduceValuesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    Object v = p.val;
                    r = r == null ? v : reducer.apply(r, v);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceValuesTask t = (ReduceValuesTask)c;
                    ReduceValuesTask<K, V> s = t.rights;
                    while (s != null) {
                        V sr = s.result;
                        if (sr != null) {
                            V tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceKeysTask<K, V>
    extends BulkTask<K, V, K> {
        final BiFunction<? super K, ? super K, ? extends K> reducer;
        K result;
        ReduceKeysTask<K, V> rights;
        ReduceKeysTask<K, V> nextRight;

        ReduceKeysTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, ReduceKeysTask<K, V> nextRight, BiFunction<? super K, ? super K, ? extends K> reducer) {
            super(p, b, i2, f, t);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final K getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<K, K, K> reducer = this.reducer;
            if (reducer != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new ReduceKeysTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    Object u = p.key;
                    r = r == null ? u : (u == null ? r : reducer.apply(r, u));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceKeysTask t = (ReduceKeysTask)c;
                    ReduceKeysTask<K, V> s = t.rights;
                    while (s != null) {
                        K sr = s.result;
                        if (sr != null) {
                            K tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class SearchMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchMappingsTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, BiFunction<? super K, ? super V, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p, b, i2, f, t);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            BiFunction searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p.key, p.val);
                    if (u == null) continue;
                    if (!result2.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchEntriesTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Function<Map.Entry<K, V>, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p, b, i2, f, t);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            Function<Map.Entry<K, V>, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p);
                    if (u == null) continue;
                    if (result2.compareAndSet(null, u)) {
                        this.quietlyCompleteRoot();
                    }
                    return;
                }
            }
        }
    }

    static final class SearchValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchValuesTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Function<? super V, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p, b, i2, f, t);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            Function<V, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p.val);
                    if (u == null) continue;
                    if (!result2.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchKeysTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Function<? super K, ? extends U> searchFunction, AtomicReference<U> result2) {
            super(p, b, i2, f, t);
            this.searchFunction = searchFunction;
            this.result = result2;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result2;
            Function<K, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result2 = this.result) != null) {
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    if (result2.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result2).fork();
                }
                while (result2.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p.key);
                    if (u == null) continue;
                    if (!result2.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class ForEachTransformedMappingTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedMappingTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, BiFunction<? super K, ? super V, ? extends U> transformer, Consumer<? super U> action2) {
            super(p, b, i2, f, t);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            BiFunction transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedMappingTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.key, p.val);
                    if (u == null) continue;
                    action2.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedEntryTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedEntryTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Function<Map.Entry<K, V>, ? extends U> transformer, Consumer<? super U> action2) {
            super(p, b, i2, f, t);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            Function<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedEntryTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p);
                    if (u == null) continue;
                    action2.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedValueTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedValueTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Function<? super V, ? extends U> transformer, Consumer<? super U> action2) {
            super(p, b, i2, f, t);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            Function<V, U> transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedValueTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.val);
                    if (u == null) continue;
                    action2.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedKeyTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super K, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedKeyTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Function<? super K, ? extends U> transformer, Consumer<? super U> action2) {
            super(p, b, i2, f, t);
            this.transformer = transformer;
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<U> action2;
            Function<K, U> transformer = this.transformer;
            if (transformer != null && (action2 = this.action) != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedKeyTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.key);
                    if (u == null) continue;
                    action2.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachMappingTask<K, V>
    extends BulkTask<K, V, Void> {
        final BiConsumer<? super K, ? super V> action;

        ForEachMappingTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, BiConsumer<? super K, ? super V> action2) {
            super(p, b, i2, f, t);
            this.action = action2;
        }

        @Override
        public final void compute() {
            BiConsumer<K, V> action2 = this.action;
            if (action2 != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachMappingTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    action2.accept(p.key, p.val);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachEntryTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super Map.Entry<K, V>> action;

        ForEachEntryTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Consumer<? super Map.Entry<K, V>> action2) {
            super(p, b, i2, f, t);
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<Map.Entry<K, V>> action2 = this.action;
            if (action2 != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachEntryTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    action2.accept(p);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachValueTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super V> action;

        ForEachValueTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Consumer<? super V> action2) {
            super(p, b, i2, f, t);
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<V> action2 = this.action;
            if (action2 != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachValueTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    action2.accept(p.val);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachKeyTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super K> action;

        ForEachKeyTask(BulkTask<K, V, ?> p, int b, int i2, int f, Node<K, V>[] t, Consumer<? super K> action2) {
            super(p, b, i2, f, t);
            this.action = action2;
        }

        @Override
        public final void compute() {
            Consumer<K> action2 = this.action;
            if (action2 != null) {
                Node p;
                int f;
                int h;
                int i2 = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i2 >>> 1) > i2) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachKeyTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action2).fork();
                }
                while ((p = this.advance()) != null) {
                    action2.accept(p.key);
                }
                this.propagateCompletion();
            }
        }
    }

    static abstract class BulkTask<K, V, R>
    extends CountedCompleter<R> {
        Node<K, V>[] tab;
        Node<K, V> next;
        TableStack<K, V> stack;
        TableStack<K, V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;
        int batch;

        BulkTask(BulkTask<K, V, ?> par, int b, int i2, int f, Node<K, V>[] t) {
            super(par);
            this.batch = b;
            this.index = this.baseIndex = i2;
            this.tab = t;
            if (t == null) {
                this.baseLimit = 0;
                this.baseSize = 0;
            } else if (par == null) {
                this.baseSize = this.baseLimit = t.length;
            } else {
                this.baseLimit = f;
                this.baseSize = par.baseSize;
            }
        }

        final Node<K, V> advance() {
            Node<K, V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i2;
                int n;
                Node<K, V>[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i2 = this.index) && i2 >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentHashMap.tabAt(t, i2);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t, i2, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i2 + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] t, int i2, int n) {
            TableStack<K, V> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i2;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<K, V> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class EntrySetView<K, V>
    extends CollectionView<K, V, Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;

        EntrySetView(ConcurrentHashMap<K, V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o) {
            Object v;
            Object r;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (r = this.map.get(k)) != null && (v = e.getValue()) != null && (v == r || v.equals(r));
        }

        @Override
        public boolean remove(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (v = e.getValue()) != null && this.map.remove(k, v);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            ConcurrentHashMap m = this.map;
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntryIterator(t, f, 0, f, m);
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            boolean added = false;
            for (Map.Entry<K, V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter2) {
            return this.map.removeEntryIf(filter2);
        }

        @Override
        public final int hashCode() {
            int h = 0;
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    h += p.hashCode();
                }
            }
            return h;
        }

        @Override
        public final boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            ConcurrentHashMap m = this.map;
            long n = m.sumCount();
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntrySpliterator(t, f, 0, f, n < 0L ? 0L : n, m);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    action2.accept(new MapEntry(p.key, p.val, this.map));
                }
            }
        }
    }

    static final class ValuesView<K, V>
    extends CollectionView<K, V, V>
    implements Collection<V>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;

        ValuesView(ConcurrentHashMap<K, V> map2) {
            super(map2);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            if (o != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            ConcurrentHashMap m = this.map;
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new ValueIterator(t, f, 0, f, m);
        }

        @Override
        public final boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter2) {
            return this.map.removeValueIf(filter2);
        }

        @Override
        public Spliterator<V> spliterator() {
            ConcurrentHashMap m = this.map;
            long n = m.sumCount();
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new ValueSpliterator(t, f, 0, f, n < 0L ? 0L : n);
        }

        @Override
        public void forEach(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    action2.accept(p.val);
                }
            }
        }
    }

    public static class KeySetView<K, V>
    extends CollectionView<K, V, K>
    implements Set<K>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        private final V value;

        KeySetView(ConcurrentHashMap<K, V> map2, V value2) {
            super(map2);
            this.value = value2;
        }

        public V getMappedValue() {
            return this.value;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            ConcurrentHashMap m = this.map;
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new KeyIterator(t, f, 0, f, m);
        }

        @Override
        public boolean add(K e) {
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            return this.map.putVal(e, v, true) == null;
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            boolean added = false;
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            for (K e : c) {
                if (this.map.putVal(e, v, true) != null) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (K e : this) {
                h += this.map.hash(e);
            }
            return h;
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        @Override
        public Spliterator<K> spliterator() {
            ConcurrentHashMap m = this.map;
            long n = m.sumCount();
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new KeySpliterator(t, f, 0, f, n < 0L ? 0L : n);
        }

        @Override
        public void forEach(Consumer<? super K> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    action2.accept(p.key);
                }
            }
        }
    }

    static abstract class CollectionView<K, V, E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        final ConcurrentHashMap<K, V> map;
        private static final String OOME_MSG = "Required array size too large";

        CollectionView(ConcurrentHashMap<K, V> map2) {
            this.map = map2;
        }

        public ConcurrentHashMap<K, V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i2 = 0;
            for (E e : this) {
                if (i2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i2++] = e;
            }
            return i2 == n ? r : Arrays.copyOf(r, i2);
        }

        @Override
        public final <T> T[] toArray(T[] a) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(OOME_MSG);
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i2 = 0;
            for (E e : this) {
                if (i2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(OOME_MSG);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i2++] = e;
            }
            if (a == r && i2 < n) {
                r[i2] = null;
                return r;
            }
            return i2 == n ? r : Arrays.copyOf(r, i2);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    static final class EntrySpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        final ConcurrentHashMap<K, V> map;
        long est;

        EntrySpliterator(Node<K, V>[] tab, int size, int index, int limit, long est, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index, limit);
            this.map = map2;
            this.est = est;
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int i2 = this.baseIndex;
            int f = this.baseLimit;
            int h = i2 + f >>> 1;
            if (h <= i2) {
                entrySpliterator = null;
            } else {
                this.baseLimit = h;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1, this.map);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action2) {
            Node p;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                action2.accept(new MapEntry(p.key, p.val, this.map));
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p = this.advance();
            if (p == null) {
                return false;
            }
            action2.accept(new MapEntry(p.key, p.val, this.map));
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class ValueSpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<V> {
        long est;

        ValueSpliterator(Node<K, V>[] tab, int size, int index, int limit, long est) {
            super(tab, size, index, limit);
            this.est = est;
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int i2 = this.baseIndex;
            int f = this.baseLimit;
            int h = i2 + f >>> 1;
            if (h <= i2) {
                valueSpliterator = null;
            } else {
                this.baseLimit = h;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action2) {
            Node p;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                action2.accept(p.val);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p = this.advance();
            if (p == null) {
                return false;
            }
            action2.accept(p.val);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4352;
        }
    }

    static final class KeySpliterator<K, V>
    extends Traverser<K, V>
    implements Spliterator<K> {
        long est;

        KeySpliterator(Node<K, V>[] tab, int size, int index, int limit, long est) {
            super(tab, size, index, limit);
            this.est = est;
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int i2 = this.baseIndex;
            int f = this.baseLimit;
            int h = i2 + f >>> 1;
            if (h <= i2) {
                keySpliterator = null;
            } else {
                this.baseLimit = h;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action2) {
            Node p;
            if (action2 == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                action2.accept(p.key);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action2) {
            if (action2 == null) {
                throw new NullPointerException();
            }
            Node p = this.advance();
            if (p == null) {
                return false;
            }
            action2.accept(p.key);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;
        final ConcurrentHashMap<K, V> map;

        MapEntry(K key, V val, ConcurrentHashMap<K, V> map2) {
            this.key = key;
            this.val = val;
            this.map = map2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public int hashCode() {
            return ((ConcurrentHashMap)this.map).hash(this.key) ^ this.val.hashCode();
        }

        public String toString() {
            return Helpers.mapEntryToString(this.key, this.val);
        }

        @Override
        public boolean equals(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !((ConcurrentHashMap)this.map).isEqual(k, this.key) || v != this.val && !v.equals(this.val));
        }

        @Override
        public V setValue(V value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            V v = this.val;
            this.val = value2;
            this.map.put(this.key, value2);
            return v;
        }
    }

    static final class EntryIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(Node<K, V>[] tab, int size, int index, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index, limit, map2);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object k = p.key;
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return new MapEntry(k, v, this.map);
        }
    }

    static final class ValueIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<K, V>[] tab, int size, int index, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index, limit, map2);
        }

        @Override
        public final V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class KeyIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator(Node<K, V>[] tab, int size, int index, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index, limit, map2);
        }

        @Override
        public final K next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object k = p.key;
            this.lastReturned = p;
            this.advance();
            return k;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    static class BaseIterator<K, V>
    extends Traverser<K, V> {
        final ConcurrentHashMap<K, V> map;
        Node<K, V> lastReturned;

        BaseIterator(Node<K, V>[] tab, int size, int index, int limit, ConcurrentHashMap<K, V> map2) {
            super(tab, size, index, limit);
            this.map = map2;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<K, V> p = this.lastReturned;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(p.key, null, null);
        }
    }

    static class Traverser<K, V> {
        Node<K, V>[] tab;
        Node<K, V> next;
        TableStack<K, V> stack;
        TableStack<K, V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<K, V>[] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index;
            this.baseLimit = limit;
            this.next = null;
        }

        final Node<K, V> advance() {
            Node<K, V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i2;
                int n;
                Node<K, V>[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i2 = this.index) && i2 >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentHashMap.tabAt(t, i2);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t, i2, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i2 + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] t, int i2, int n) {
            TableStack<K, V> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i2;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<K, V> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TableStack<K, V> {
        int length;
        int index;
        Node<K, V>[] tab;
        TableStack<K, V> next;

        TableStack() {
        }
    }

    static final class TreeBin<K, V>
    extends Node<K, V> {
        TreeNode<K, V> root;
        volatile TreeNode<K, V> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final long LOCKSTATE;

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        TreeBin(TreeNode<K, V> b, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                TreeBin.$$$reportNull$$$0(0);
            }
            super(-2, null, null, hashingStrategy);
            this.first = b;
            TreeNode r = null;
            TreeNode x = b;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class<?> kc = null;
                    TreeNode p = r;
                    do {
                        Object pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = ConcurrentHashMap.comparableClassFor(k)) == null || (dir = ConcurrentHashMap.compareComparables(kc, k, pk)) == 0) {
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private final void lockRoot() {
            if (!U.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState = 0;
        }

        private final void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Node<K, V> find(int h, Object k) {
            if (k != null) {
                Node e = this.first;
                while (e != null) {
                    TreeNode<K, V> p;
                    int s = this.lockState;
                    if ((s & 3) != 0) {
                        Object ek;
                        if (e.hash == h && ((ek = e.key) == k || ek != null && ConcurrentHashMap.isEqual(k, ek, this.hashingStrategy))) {
                            return e;
                        }
                        e = e.next;
                        continue;
                    }
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) continue;
                    try {
                        TreeNode<K, V> r = this.root;
                        p = r == null ? null : r.findTreeNode(h, k, null);
                    }
                    finally {
                        Thread w;
                        if (U.getAndAddInt(this, LOCKSTATE, -4) == 6 && (w = this.waiter) != null) {
                            LockSupport.unpark(w);
                        }
                    }
                    return p;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final TreeNode<K, V> putTreeVal(int h, K k, V v) {
            block19: {
                TreeNode<K, V> xp;
                int dir;
                Class<?> kc = null;
                boolean searched = false;
                TreeNode<K, V> p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode<K, V>(h, k, v, null, null, this.hashingStrategy);
                        this.first = this.root;
                        break block19;
                    }
                    int ph = p.hash;
                    if (ph > h) {
                        dir = -1;
                    } else if (ph < h) {
                        dir = 1;
                    } else {
                        Object pk = p.key;
                        if (pk == k || pk != null && ConcurrentHashMap.isEqual(k, pk, this.hashingStrategy)) {
                            return p;
                        }
                        if (kc == null && (kc = ConcurrentHashMap.comparableClassFor(k)) == null || (dir = ConcurrentHashMap.compareComparables(kc, k, pk)) == 0) {
                            if (!searched) {
                                TreeNode q;
                                searched = true;
                                TreeNode ch = p.left;
                                if (ch != null && (q = ch.findTreeNode(h, k, kc)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h, k, kc)) != null) {
                                    return q;
                                }
                            }
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                    }
                    xp = p;
                } while ((p = dir <= 0 ? p.left : p.right) != null);
                TreeNode<K, V> f = this.first;
                TreeNode<K, V> x = new TreeNode<K, V>(h, k, v, f, xp, this.hashingStrategy);
                this.first = x;
                if (f != null) {
                    f.prev = x;
                }
                if (dir <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean removeTreeNode(TreeNode<K, V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<K, V> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        p.parent = sp;
                        if (p.parent != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        if ((s.right = pr) != null) {
                            pr.parent = s;
                        }
                    }
                    p.left = null;
                    p.right = sr;
                    if (p.right != null) {
                        sr.parent = p;
                    }
                    if ((s.left = pl) != null) {
                        pl.parent = s;
                    }
                    if ((s.parent = pp2) == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    replacement.parent = p.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.parent = null;
                    p.right = null;
                    p.left = null;
                }
                TreeNode<K, V> treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> root, TreeNode<K, V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> root, TreeNode<K, V> x) {
            while (x != null && x != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> t) {
            TreeNode tp = t.parent;
            TreeNode tl = t.left;
            TreeNode tr = t.right;
            TreeNode tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                LOCKSTATE = U.objectFieldOffset(TreeBin.class.getDeclaredField("lockState"));
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$TreeBin", "<init>"));
        }
    }

    static final class TreeNode<K, V>
    extends Node<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int hash, K key, V val, Node<K, V> next, TreeNode<K, V> parent, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                TreeNode.$$$reportNull$$$0(0);
            }
            super(hash, key, val, next, hashingStrategy);
            this.parent = parent;
        }

        @Override
        Node<K, V> find(int h, Object k) {
            return this.findTreeNode(h, k, null);
        }

        final TreeNode<K, V> findTreeNode(int h, Object k, Class<?> kc) {
            if (k != null) {
                TreeNode<K, V> p = this;
                do {
                    int dir;
                    TreeNode<K, V> pl = p.left;
                    TreeNode<K, V> pr = p.right;
                    int ph = p.hash;
                    if (ph > h) {
                        p = pl;
                        continue;
                    }
                    if (ph < h) {
                        p = pr;
                        continue;
                    }
                    Object pk = p.key;
                    if (pk == k || pk != null && ConcurrentHashMap.isEqual(k, pk, this.hashingStrategy)) {
                        return p;
                    }
                    if (pl == null) {
                        p = pr;
                        continue;
                    }
                    if (pr == null) {
                        p = pl;
                        continue;
                    }
                    if ((kc != null || (kc = ConcurrentHashMap.comparableClassFor(k)) != null) && (dir = ConcurrentHashMap.compareComparables(kc, k, pk)) != 0) {
                        p = dir < 0 ? pl : pr;
                        continue;
                    }
                    TreeNode<K, V> q = pr.findTreeNode(h, k, kc);
                    if (q != null) {
                        return q;
                    }
                    p = pl;
                } while (p != null);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$TreeNode", "<init>"));
        }
    }

    static final class CounterCell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;

        CounterCell(long x) {
            this.value = x;
        }
    }

    static final class ReservationNode<K, V>
    extends Node<K, V> {
        ReservationNode(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                ReservationNode.$$$reportNull$$$0(0);
            }
            super(-3, null, null, hashingStrategy);
        }

        @Override
        Node<K, V> find(int h, Object k) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$ReservationNode", "<init>"));
        }
    }

    static final class ForwardingNode<K, V>
    extends Node<K, V> {
        final Node<K, V>[] nextTable;

        ForwardingNode(Node<K, V>[] tab, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                ForwardingNode.$$$reportNull$$$0(0);
            }
            super(-1, null, null, hashingStrategy);
            this.nextTable = tab;
        }

        @Override
        Node<K, V> find(int h, Object k) {
            Node<K, V>[] tab = this.nextTable;
            block0: while (true) {
                Node<K, V> e;
                int n;
                if (k == null || tab == null || (n = tab.length) == 0 || (e = ConcurrentHashMap.tabAt(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    Object ek;
                    int eh;
                    if ((eh = e.hash) == h && ((ek = e.key) == k || ek != null && ConcurrentHashMap.isEqual(k, ek, this.hashingStrategy))) {
                        return e;
                    }
                    if (eh >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$ForwardingNode", "<init>"));
        }
    }

    static class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        volatile V val;
        @NotNull
        final TObjectHashingStrategy<K> hashingStrategy;
        volatile Node<K, V> next;

        Node(int hash, K key, V val, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.hashingStrategy = hashingStrategy;
        }

        Node(int hash, K key, V val, Node<K, V> next, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
            if (hashingStrategy == null) {
                Node.$$$reportNull$$$0(1);
            }
            this(hash, key, val, hashingStrategy);
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return this.hashingStrategy.computeHashCode(this.key) ^ this.val.hashCode();
        }

        public final String toString() {
            return Helpers.mapEntryToString(this.key, this.val);
        }

        @Override
        public final V setValue(V value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean equals(Object o) {
            V u;
            Object v;
            Map.Entry e;
            Object k;
            return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !this.hashingStrategy.equals(k, this.key) || v != (u = this.val) && !v.equals(u));
        }

        Node<K, V> find(int h, Object k) {
            Node<K, V> e = this;
            if (k != null) {
                do {
                    K ek;
                    if (e.hash != h || (ek = e.key) != k && (ek == null || !this.hashingStrategy.equals(k, ek))) continue;
                    return e;
                } while ((e = e.next) != null);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/concurrency/ConcurrentHashMap$Node", "<init>"));
        }
    }
}

