/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.diagnostic.PluginException;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThrowableDescription {
    private static final String UNKNOWN = "unknown";
    private static final String THIRD_PARTY = "third.party";
    @Nullable
    private final Throwable myThrowable;
    private final StackTraceElement @Nullable [] myStacktrace;

    public ThrowableDescription(@Nullable Throwable throwable) {
        this.myThrowable = throwable != null ? ThrowableDescription.getCause(throwable) : null;
        this.myStacktrace = this.myThrowable != null ? ThrowableDescription.getStacktrace(this.myThrowable) : null;
    }

    private static StackTraceElement @Nullable [] getStacktrace(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableDescription.$$$reportNull$$$0(0);
        }
        try {
            return throwable.getStackTrace();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @NotNull
    public String getClassName() {
        if (this.myThrowable == null) {
            return UNKNOWN;
        }
        Class<?> throwableClass = this.myThrowable.getClass();
        PluginInfo throwableLocation = PluginInfoDetectorKt.getPluginInfo(throwableClass);
        return throwableLocation.isSafeToReport() ? throwableClass.getName() : THIRD_PARTY;
    }

    public int getSize() {
        if (this.myStacktrace == null) {
            return -1;
        }
        return this.myStacktrace.length;
    }

    @NotNull
    public List<String> getLastFrames(int frameCount) {
        if (this.myStacktrace == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                ThrowableDescription.$$$reportNull$$$0(1);
            }
            return list2;
        }
        int size = Math.min(this.myStacktrace.length, frameCount);
        ArrayList<String> result2 = new ArrayList<String>(size);
        HashMap<String, PluginInfo> pluginInfoCache = new HashMap<String, PluginInfo>();
        for (int i2 = 0; i2 < size; ++i2) {
            StackTraceElement element2 = this.myStacktrace[i2];
            PluginInfo pluginInfo = (PluginInfo)pluginInfoCache.get(element2.getClassName());
            if (pluginInfo == null) {
                pluginInfo = PluginInfoDetectorKt.getPluginInfo((String)element2.getClassName());
                pluginInfoCache.put(element2.getClassName(), pluginInfo);
            }
            if (pluginInfo.isSafeToReport()) {
                result2.add(element2.getClassName() + "." + element2.getMethodName());
                continue;
            }
            result2.add(THIRD_PARTY);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ThrowableDescription.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static Throwable getCause(@NotNull Throwable throwable) {
        if (throwable == null) {
            ThrowableDescription.$$$reportNull$$$0(3);
        }
        boolean isPluginException = throwable instanceof PluginException && throwable.getCause() != null;
        Throwable throwable2 = isPluginException ? throwable.getCause() : throwable;
        if (throwable2 == null) {
            ThrowableDescription.$$$reportNull$$$0(4);
        }
        return throwable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/ThrowableDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/ThrowableDescription";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastFrames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStacktrace";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCause";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

