/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.PsiElementTargetPopupPresentation;
import com.intellij.find.FindBundle;
import com.intellij.find.actions.Item2TargetPresentation;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.TargetVariant;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.usages.SearchTarget;
import com.intellij.find.usages.impl.DefaultSymbolSearchTarget;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.navigation.ChooserKt;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.TargetPopupPresentation;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a9\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a&\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0002\u001a(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u001e\u001a\u00020\u0010*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u001f\u001a\u00020\u0010*\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0007H\u0000\u00a8\u0006 "}, d2={"allTargets", "", "Lcom/intellij/find/actions/TargetVariant;", "project", "Lcom/intellij/openapi/project/Project;", "targets", "", "Lcom/intellij/find/usages/SearchTarget;", "oldTargets", "", "Lcom/intellij/usages/UsageTarget;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;[Lcom/intellij/usages/UsageTarget;)Ljava/util/List;", "containsElementFromUsageTarget", "", "oldTarget", "findShowUsages", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "popupTitle", "", "handler", "Lcom/intellij/find/actions/UsageVariantHandler;", "getPresentation", "Lcom/intellij/navigation/TargetPopupPresentation;", "targetVariant", "searchTargets", "targetPsi", "Lcom/intellij/psi/PsiElement;", "target", "handle", "handlePsiOrSymbol", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class ResolverKt {
    public static final void findShowUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull String popupTitle, @NotNull UsageVariantHandler handler2) {
        UsageTarget[] usageTargetArray;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Intrinsics.checkParameterIsNotNull((Object)popupTitle, (String)"popupTitle");
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        Project project2 = project;
        Collection collection = ResolverKt.searchTargets(dataContext);
        UsageTarget usageTarget = (UsageTarget)dataContext.getData(UsageView.USAGE_TARGETS_KEY);
        if (usageTarget != null && (usageTarget = usageTarget[0]) != null) {
            UsageTarget usageTarget2 = usageTarget;
            Collection collection2 = collection;
            Project project3 = project2;
            boolean bl = false;
            boolean bl2 = false;
            UsageTarget it = usageTarget2;
            boolean bl3 = false;
            UsageTarget[] usageTargetArray2 = new UsageTarget[]{it};
            project2 = project3;
            collection = collection2;
            usageTargetArray = usageTargetArray2;
        } else {
            usageTargetArray = UsageTarget.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)UsageTarget.EMPTY_ARRAY, (String)"UsageTarget.EMPTY_ARRAY");
        }
        List<TargetVariant> allTargets = ResolverKt.allTargets(project2, collection, usageTargetArray);
        switch (allTargets.size()) {
            case 0: {
                Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
                String string = FindBundle.message("find.no.usages.at.cursor.error", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FindBundle.message(\"find\u2026.usages.at.cursor.error\")");
                String message = string;
                if (editor == null) {
                    Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    break;
                }
                HintManager.getInstance().showErrorHint(editor, message);
                break;
            }
            case 1: {
                ResolverKt.handle(handler2, (TargetVariant)CollectionsKt.single(allTargets));
                break;
            }
            default: {
                ChooserKt.chooseTargetPopup(popupTitle, allTargets, findShowUsages.1.INSTANCE, (Function1)new Function1<TargetVariant, Unit>(handler2){

                    public final void invoke(@NotNull TargetVariant p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ResolverKt.access$handle((UsageVariantHandler)this.receiver, p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinPackage(ResolverKt.class, (String)"intellij.platform.lang.impl");
                    }

                    public final String getName() {
                        return "handle";
                    }

                    public final String getSignature() {
                        return "handle(Lcom/intellij/find/actions/UsageVariantHandler;Lcom/intellij/find/actions/TargetVariant;)V";
                    }
                }).showInBestPositionFor(dataContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TargetVariant> allTargets(Project project, Collection<? extends SearchTarget> targets2, UsageTarget[] oldTargets) {
        ArrayList<TargetVariant.UsageTargetVariant> allTargets = new ArrayList<TargetVariant.UsageTargetVariant>();
        Iterable $this$mapTo$iv = targets2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p1;
            SearchTarget searchTarget = (SearchTarget)item$iv;
            Collection collection = allTargets;
            boolean bl = false;
            TargetVariant.SearchTargetVariant searchTargetVariant = new TargetVariant.SearchTargetVariant((SearchTarget)p1);
            collection.add(searchTargetVariant);
        }
        for (UsageTarget usageTarget : oldTargets) {
            if (!usageTarget.isValid() || ResolverKt.containsElementFromUsageTarget(project, targets2, usageTarget)) continue;
            allTargets.add(new TargetVariant.UsageTargetVariant(usageTarget));
        }
        return allTargets;
    }

    private static final boolean containsElementFromUsageTarget(Project project, Collection<? extends SearchTarget> targets2, UsageTarget oldTarget) {
        boolean bl;
        block5: {
            if (!(oldTarget instanceof PsiElement2UsageTargetAdapter)) {
                return false;
            }
            PsiElement psiElement = ((PsiElement2UsageTargetAdapter)oldTarget).getElement();
            if (psiElement == null) {
                return false;
            }
            PsiElement targetElement = psiElement;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
            PsiManager manager = psiManager;
            Function1<SearchTarget, Boolean> $fun$isWrappedTargetElement$1 = new Function1<SearchTarget, Boolean>(manager, targetElement){
                final /* synthetic */ PsiManager $manager;
                final /* synthetic */ PsiElement $targetElement;

                public final boolean invoke(@NotNull SearchTarget target2) {
                    Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
                    PsiElement element2 = ResolverKt.targetPsi(target2);
                    return element2 != null && this.$manager.areElementsEquivalent(element2, this.$targetElement);
                }
                {
                    this.$manager = psiManager;
                    this.$targetElement = psiElement;
                    super(1);
                }
            };
            Iterable $this$any$iv = targets2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SearchTarget p1 = (SearchTarget)element$iv;
                    boolean bl2 = false;
                    if (!$fun$isWrappedTargetElement$1.invoke(p1)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final List<SearchTarget> searchTargets(DataContext dataContext) {
        PsiFile psiFile = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"dataContext.getData(Comm\u2026LE) ?: return emptyList()");
        PsiFile file2 = psiFile;
        Caret caret = (Caret)dataContext.getData(CommonDataKeys.CARET);
        if (caret == null) {
            return CollectionsKt.emptyList();
        }
        int offset = caret.getOffset();
        return ImplKt.symbolSearchTargets(file2, offset);
    }

    private static final void handle(@NotNull UsageVariantHandler $this$handle, TargetVariant targetVariant) {
        block3: {
            TargetVariant targetVariant2;
            block2: {
                targetVariant2 = targetVariant;
                if (!(targetVariant2 instanceof TargetVariant.SearchTargetVariant)) break block2;
                ResolverKt.handlePsiOrSymbol($this$handle, ((TargetVariant.SearchTargetVariant)targetVariant).getTarget());
                break block3;
            }
            if (!(targetVariant2 instanceof TargetVariant.UsageTargetVariant)) break block3;
            UsageTarget target2 = ((TargetVariant.UsageTargetVariant)targetVariant).getTarget();
            if (target2 instanceof PsiElement2UsageTargetAdapter) {
                PsiElement psiElement = ((PsiElement2UsageTargetAdapter)target2).getElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"target.element");
                $this$handle.handlePsi(psiElement);
            } else {
                target2.findUsages();
            }
        }
    }

    public static final void handlePsiOrSymbol(@NotNull UsageVariantHandler $this$handlePsiOrSymbol, @NotNull SearchTarget target2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$handlePsiOrSymbol, (String)"$this$handlePsiOrSymbol");
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        PsiElement element2 = ResolverKt.targetPsi(target2);
        if (element2 != null) {
            $this$handlePsiOrSymbol.handlePsi(element2);
        } else {
            $this$handlePsiOrSymbol.handleTarget(target2);
        }
    }

    private static final TargetPopupPresentation getPresentation(TargetVariant targetVariant) {
        TargetPopupPresentation targetPopupPresentation;
        TargetVariant targetVariant2 = targetVariant;
        if (targetVariant2 instanceof TargetVariant.SearchTargetVariant) {
            targetPopupPresentation = ((TargetVariant.SearchTargetVariant)targetVariant).getTarget().getPresentation();
        } else if (targetVariant2 instanceof TargetVariant.UsageTargetVariant) {
            UsageTarget target2 = ((TargetVariant.UsageTargetVariant)targetVariant).getTarget();
            if (target2 instanceof PsiElement2UsageTargetAdapter) {
                PsiElement psiElement = ((PsiElement2UsageTargetAdapter)target2).getElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"target.element");
                targetPopupPresentation = new PsiElementTargetPopupPresentation(psiElement);
            } else {
                ItemPresentation itemPresentation = target2.getPresentation();
                if (itemPresentation == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)itemPresentation, (String)"target.presentation!!");
                targetPopupPresentation = new Item2TargetPresentation(itemPresentation);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return targetPopupPresentation;
    }

    @Nullable
    public static final PsiElement targetPsi(@NotNull SearchTarget target2) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        if (target2 instanceof DefaultSymbolSearchTarget) {
            return PsiSymbolService.getInstance().extractElementFromSymbol(((DefaultSymbolSearchTarget)target2).getSymbol());
        }
        return null;
    }

    public static final /* synthetic */ TargetPopupPresentation access$getPresentation(TargetVariant targetVariant) {
        return ResolverKt.getPresentation(targetVariant);
    }

    public static final /* synthetic */ void access$handle(UsageVariantHandler $this$access_u24handle, TargetVariant targetVariant) {
        ResolverKt.handle($this$access_u24handle, targetVariant);
    }
}

