/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DisabledPluginsState {
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    private static volatile Set<PluginId> ourDisabledPlugins;
    @Nullable
    private static Runnable disabledPluginListener;

    @ApiStatus.Internal
    public static void setDisabledPluginListener(@NotNull Runnable value2) {
        if (value2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(0);
        }
        disabledPluginListener = value2;
    }

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> disabledPlugins) {
        Path file2;
        if (configPath == null) {
            DisabledPluginsState.$$$reportNull$$$0(1);
        }
        if (disabledPlugins == null) {
            DisabledPluginsState.$$$reportNull$$$0(2);
        }
        if (!Files.isRegularFile(file2 = Paths.get(configPath, DISABLED_PLUGINS_FILENAME), new LinkOption[0])) {
            return;
        }
        List requiredPlugins = StringUtil.split((String)System.getProperty("idea.required.plugins.id", ""), (String)",");
        try {
            boolean updateDisablePluginsList = false;
            try (BufferedReader reader = Files.newBufferedReader(file2);){
                String id2;
                while ((id2 = reader.readLine()) != null) {
                    if (!requiredPlugins.contains(id2 = id2.trim()) && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(id2)) {
                        disabledPlugins.add(PluginId.getId((String)id2));
                        continue;
                    }
                    updateDisablePluginsList = true;
                }
            }
            finally {
                if (updateDisablePluginsList) {
                    PluginManagerCore.savePluginsList(disabledPlugins, file2, false);
                    DisabledPluginsState.fireEditDisablePlugins();
                }
            }
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().info("Unable to load disabled plugins list from " + file2, (Throwable)e);
        }
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        Set<PluginId> set = Collections.unmodifiableSet(DisabledPluginsState.getDisabledIds());
        if (set == null) {
            DisabledPluginsState.$$$reportNull$$$0(3);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            Set<PluginId> set = result2;
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(4);
            }
            return set;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            Set<PluginId> set = Collections.emptySet();
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(5);
            }
            return set;
        }
        Class<PluginManagerCore> clazz = PluginManagerCore.class;
        synchronized (PluginManagerCore.class) {
            block10: {
                result2 = ourDisabledPlugins;
                if (result2 == null) break block10;
                Set<PluginId> set = result2;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (set == null) {
                    DisabledPluginsState.$$$reportNull$$$0(6);
                }
                return set;
            }
            result2 = new LinkedHashSet<PluginId>();
            DisabledPluginsState.loadDisabledPlugins(PathManager.getConfigPath(), result2);
            ourDisabledPlugins = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Set<PluginId> set = result2;
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(7);
            }
            return set;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static List<String> getDisabledPlugins() {
        final Set<PluginId> list2 = DisabledPluginsState.getDisabledIds();
        return new AbstractList<String>(){

            @Override
            public boolean contains(Object o) {
                return list2.contains(o);
            }

            @Override
            public int size() {
                return list2.size();
            }

            @Override
            public String get(int index) {
                if (index < 0 || index >= list2.size()) {
                    throw new IndexOutOfBoundsException("index=" + index + " size=" + list2.size());
                }
                Iterator iterator2 = list2.iterator();
                for (int i2 = 0; i2 < index; ++i2) {
                    iterator2.next();
                }
                return ((PluginId)iterator2.next()).getIdString();
            }
        };
    }

    public static boolean disablePlugin(@NotNull PluginId id2) {
        Set<PluginId> disabledPlugins;
        if (id2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(8);
        }
        return (disabledPlugins = DisabledPluginsState.getDisabledIds()).add(id2) && DisabledPluginsState.trySaveDisabledPlugins(disabledPlugins);
    }

    public static boolean enablePlugin(@NotNull PluginId id2) {
        Set<PluginId> disabledPlugins;
        if (id2 == null) {
            DisabledPluginsState.$$$reportNull$$$0(9);
        }
        return (disabledPlugins = DisabledPluginsState.getDisabledIds()).remove(id2) && DisabledPluginsState.trySaveDisabledPlugins(disabledPlugins);
    }

    public static void enablePlugins(@NotNull Collection<? extends PluginDescriptor> plugins, boolean enabled) {
        if (plugins == null) {
            DisabledPluginsState.$$$reportNull$$$0(10);
        }
        DisabledPluginsState.enablePluginsById(ContainerUtil.map(plugins, plugin -> plugin.getPluginId()), enabled);
    }

    public static void enablePluginsById(@NotNull Collection<PluginId> plugins, boolean enabled) {
        if (plugins == null) {
            DisabledPluginsState.$$$reportNull$$$0(11);
        }
        Set<PluginId> disabled = DisabledPluginsState.getDisabledIds();
        int sizeBefore = disabled.size();
        for (PluginId plugin : plugins) {
            IdeaPluginDescriptor pluginDescriptor;
            if (enabled) {
                disabled.remove(plugin);
            } else {
                disabled.add(plugin);
            }
            if ((pluginDescriptor = PluginManagerCore.getPlugin(plugin)) == null) continue;
            pluginDescriptor.setEnabled(enabled);
        }
        if (sizeBefore == disabled.size()) {
            return;
        }
        DisabledPluginsState.trySaveDisabledPlugins(disabled);
    }

    static boolean trySaveDisabledPlugins(@NotNull Collection<PluginId> disabledPlugins) {
        if (disabledPlugins == null) {
            DisabledPluginsState.$$$reportNull$$$0(12);
        }
        try {
            DisabledPluginsState.saveDisabledPlugins(disabledPlugins, false);
            return true;
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().warn("Unable to save disabled plugins list", (Throwable)e);
            return false;
        }
    }

    public static void saveDisabledPlugins(@NotNull Collection<PluginId> ids, boolean append) throws IOException {
        if (ids == null) {
            DisabledPluginsState.$$$reportNull$$$0(13);
        }
        DisabledPluginsState.saveDisabledPlugins(PathManager.getConfigPath(), ids, append);
    }

    public static void saveDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> ids, boolean append) throws IOException {
        if (configPath == null) {
            DisabledPluginsState.$$$reportNull$$$0(14);
        }
        if (ids == null) {
            DisabledPluginsState.$$$reportNull$$$0(15);
        }
        Path plugins = Paths.get(configPath, DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, plugins, append);
        ourDisabledPlugins = null;
        DisabledPluginsState.fireEditDisablePlugins();
    }

    private static void fireEditDisablePlugins() {
        if (disabledPluginListener != null) {
            disabledPluginListener.run();
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.DisabledPluginsState");
        if (logger == null) {
            DisabledPluginsState.$$$reportNull$$$0(16);
        }
        return logger;
    }

    static void invalidate() {
        ourDisabledPlugins = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledPluginListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugins";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enablePluginsById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

