/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PagePluginLayout;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PluginListLayout
extends AbstractLayoutManager
implements PagePluginLayout {
    private final JBValue myGroupGap = new JBValue.Float(10.0f);
    private int myMiddleLineHeight;

    public Dimension preferredLayoutSize(Container parent) {
        int height = 0;
        int count = parent.getComponentCount();
        int lines = 0;
        this.myMiddleLineHeight = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            Component component2 = parent.getComponent(i2);
            if (component2 instanceof AnimatedIcon) continue;
            int lineHeight = component2.getPreferredSize().height;
            height += lineHeight;
            if (!(component2 instanceof ListPluginComponent)) continue;
            this.myMiddleLineHeight += lineHeight;
            ++lines;
        }
        this.calculateLineHeight(lines);
        int size = ((PluginsGroupComponent)((Object)parent)).getGroups().size();
        if (size > 1) {
            height += this.myGroupGap.get() * (size - 1);
        }
        return new Dimension(0, height);
    }

    public void layoutContainer(Container parent) {
        List<UIPluginGroup> groups = ((PluginsGroupComponent)((Object)parent)).getGroups();
        int width = parent.getWidth();
        int y = 0;
        int groupGap = this.myGroupGap.get();
        int lines = 0;
        this.myMiddleLineHeight = 0;
        for (UIPluginGroup group : groups) {
            Component component2 = group.panel;
            int height = component2.getPreferredSize().height;
            component2.setBounds(0, y, width, height);
            y += height;
            for (ListPluginComponent plugin : group.plugins) {
                int lineHeight = plugin.getPreferredSize().height;
                plugin.setBounds(0, y, width, lineHeight);
                y += lineHeight;
                this.myMiddleLineHeight += lineHeight;
            }
            lines += group.plugins.size();
            y += groupGap;
        }
        this.calculateLineHeight(lines);
    }

    public void calculateLineHeight(int lines) {
        this.myMiddleLineHeight = lines == 0 || this.myMiddleLineHeight == 0 ? 10 : (this.myMiddleLineHeight /= lines);
    }

    @Override
    public int getPageCount(@NotNull JComponent parent) {
        if (parent == null) {
            PluginListLayout.$$$reportNull$$$0(0);
        }
        return parent.getVisibleRect().height / this.myMiddleLineHeight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/plugins/newui/PluginListLayout", "getPageCount"));
    }
}

