/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.CliResult;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.SplashManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    public static final String LAUNCHER_INITIAL_DIRECTORY_ENV_VAR = "IDEA_INITIAL_DIRECTORY";
    private static final String PORT_FILE = "port";
    private static final String PORT_LOCK_FILE = "port.lock";
    private static final String TOKEN_FILE = "token";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String PID_COMMAND = "pid";
    private static final String OK_RESPONSE = "ok";
    private static final String PATHS_EOT_RESPONSE = "---";
    private final AtomicReference<Function<List<String>, Future<CliResult>>> myCommandProcessorRef;
    private final Path myConfigPath;
    private final Path mySystemPath;
    private final List<AutoCloseable> myLockedFiles;
    private volatile CompletableFuture<BuiltInServer> myBuiltinServerFuture;

    public SocketLock(@NotNull Path configPath, @NotNull Path systemPath) {
        if (configPath == null) {
            SocketLock.$$$reportNull$$$0(0);
        }
        if (systemPath == null) {
            SocketLock.$$$reportNull$$$0(1);
        }
        this.myLockedFiles = new ArrayList<AutoCloseable>(4);
        this.myConfigPath = configPath;
        this.mySystemPath = systemPath;
        if (this.myConfigPath.equals(this.mySystemPath)) {
            throw new IllegalArgumentException("'config' and 'system' paths should point to different directories");
        }
        this.myCommandProcessorRef = new AtomicReference<Function<List, Future>>(args -> CliResult.error((int)14, (String)IdeBundle.message((String)"activation.not.initialized", (Object[])new Object[0])));
    }

    @NotNull
    public Path getConfigPath() {
        Path path = this.myConfigPath;
        if (path == null) {
            SocketLock.$$$reportNull$$$0(2);
        }
        return path;
    }

    @NotNull
    public Path getSystemPath() {
        Path path = this.mySystemPath;
        if (path == null) {
            SocketLock.$$$reportNull$$$0(3);
        }
        return path;
    }

    public void setCommandProcessor(@Nullable Function<List<String>, Future<CliResult>> processor2) {
        this.myCommandProcessorRef.set(processor2);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = null;
        try {
            server = this.getServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.myLockedFiles.isEmpty()) {
                this.lockPortFiles();
            }
            if (server != null) {
                Disposer.dispose((Disposable)server);
            }
            Files.deleteIfExists(this.myConfigPath.resolve(PORT_FILE));
            Files.deleteIfExists(this.mySystemPath.resolve(PORT_FILE));
            Files.deleteIfExists(this.mySystemPath.resolve(TOKEN_FILE));
            this.unlockPortFiles();
        }
        catch (Exception e) {
            SocketLock.log(e);
        }
    }

    @Nullable
    BuiltInServer getServer() {
        CompletableFuture<BuiltInServer> future2 = this.myBuiltinServerFuture;
        if (future2 != null) {
            try {
                return (BuiltInServer)future2.get();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getCause());
            }
        }
        return null;
    }

    @Nullable
    CompletableFuture<BuiltInServer> getServerFuture() {
        return this.myBuiltinServerFuture;
    }

    @NotNull
    public Map.Entry<ActivationStatus, CliResult> lockAndTryActivate(@NotNull @NotNull String @NotNull [] args) throws Exception {
        if (args == null) {
            SocketLock.$$$reportNull$$$0(4);
        }
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        this.lockPortFiles();
        HashMap<Integer, List<String>> portToPath = new HashMap<Integer, List<String>>();
        SocketLock.readPort(this.myConfigPath, portToPath);
        SocketLock.readPort(this.mySystemPath, portToPath);
        if (!portToPath.isEmpty()) {
            args = JetBrainsProtocolHandler.checkForJetBrainsProtocolCommand((String[])args);
            for (Map.Entry entry : portToPath.entrySet()) {
                Map.Entry<ActivationStatus, CliResult> status = this.tryActivate((Integer)entry.getKey(), (List)entry.getValue(), args);
                if (status.getKey() == ActivationStatus.NO_INSTANCE) continue;
                SocketLock.log("exit: lock(): " + status.getValue(), new Object[0]);
                this.unlockPortFiles();
                Map.Entry<ActivationStatus, CliResult> entry2 = status;
                if (entry2 == null) {
                    SocketLock.$$$reportNull$$$0(5);
                }
                return entry2;
            }
        }
        if (JetBrainsProtocolHandler.isShutdownCommand()) {
            this.unlockPortFiles();
            System.exit(0);
        }
        this.myBuiltinServerFuture = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity((String)"built-in server launch");
            String token = UUID.randomUUID().toString();
            Path[] lockedPaths = new Path[]{this.myConfigPath, this.mySystemPath};
            Supplier<ChannelHandler> handlerSupplier = () -> new MyChannelInboundHandler(lockedPaths, this.myCommandProcessorRef, token);
            BuiltInServer server = BuiltInServer.startNioOrOio((int)BuiltInServer.getRecommendedWorkerCount(), (int)6942, (int)50, (boolean)false, handlerSupplier);
            try {
                byte[] portBytes = Integer.toString(server.getPort()).getBytes(StandardCharsets.UTF_8);
                Files.write(this.myConfigPath.resolve(PORT_FILE), portBytes, new OpenOption[0]);
                Files.write(this.mySystemPath.resolve(PORT_FILE), portBytes, new OpenOption[0]);
                Path tokenFile = this.mySystemPath.resolve(TOKEN_FILE);
                Files.write(tokenFile, token.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                PosixFileAttributeView view = Files.getFileAttributeView(tokenFile, PosixFileAttributeView.class, new LinkOption[0]);
                if (view != null) {
                    try {
                        view.setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
                    }
                    catch (IOException e) {
                        SocketLock.log(e);
                    }
                }
                this.unlockPortFiles();
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            activity.end();
            return server;
        }, AppExecutorUtil.getAppExecutorService());
        SocketLock.log("exit: lock(): succeed", new Object[0]);
        return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
    }

    private synchronized void lockPortFiles() throws IOException {
        if (!this.myLockedFiles.isEmpty()) {
            throw new IllegalStateException("File locking must not be called twice");
        }
        OpenOption[] options2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        Files.createDirectories(this.myConfigPath, new FileAttribute[0]);
        FileChannel cc = FileChannel.open(this.myConfigPath.resolve(PORT_LOCK_FILE), options2);
        this.myLockedFiles.add(cc);
        this.myLockedFiles.add(cc.lock());
        Files.createDirectories(this.mySystemPath, new FileAttribute[0]);
        FileChannel sc = FileChannel.open(this.mySystemPath.resolve(PORT_LOCK_FILE), options2);
        this.myLockedFiles.add(sc);
        this.myLockedFiles.add(sc.lock());
    }

    private synchronized void unlockPortFiles() throws Exception {
        if (this.myLockedFiles.isEmpty()) {
            throw new IllegalStateException("File unlocking must not be called twice");
        }
        for (int i2 = this.myLockedFiles.size() - 1; i2 >= 0; --i2) {
            this.myLockedFiles.get(i2).close();
        }
        this.myLockedFiles.clear();
    }

    @NotNull
    private static String readOneLine(@NotNull Path file2) throws IOException {
        if (file2 == null) {
            SocketLock.$$$reportNull$$$0(6);
        }
        BufferedReader reader = Files.newBufferedReader(file2);
        String string = reader.readLine().trim();
        String string2 = string;
        if (string2 == null) {
            SocketLock.$$$reportNull$$$0(7);
        }
        return string2;
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static void readPort(@NotNull Path dir, @NotNull Map<Integer, List<String>> portToPath) {
        if (dir == null) {
            SocketLock.$$$reportNull$$$0(8);
        }
        if (portToPath == null) {
            SocketLock.$$$reportNull$$$0(9);
        }
        try {
            portToPath.computeIfAbsent(Integer.parseInt(SocketLock.readOneLine(dir.resolve(PORT_FILE))), it -> new ArrayList()).add(dir.toString());
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (Exception e) {
            SocketLock.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Map.Entry<ActivationStatus, CliResult> tryActivate(int portNumber, @NotNull List<String> paths, String[] args) {
        Socket socket;
        block16: {
            AbstractMap.SimpleEntry<ActivationStatus, CliResult> simpleEntry;
            if (paths == null) {
                SocketLock.$$$reportNull$$$0(10);
            }
            SocketLock.log("trying: port=%s", portNumber);
            try {
                AbstractMap.SimpleEntry<ActivationStatus, CliResult> simpleEntry2;
                socket = new Socket(InetAddress.getLoopbackAddress(), portNumber);
                socket.setSoTimeout(5000);
                DataInputStream in = new DataInputStream(socket.getInputStream());
                List<String> stringList = SocketLock.readStringSequence(in);
                boolean result2 = ContainerUtil.intersects(paths, stringList);
                if (!result2) break block16;
                System.setProperty("nosplash", "true");
                EventQueue.invokeLater(() -> {
                    Runnable hideSplashTask = SplashManager.getHideTask();
                    if (hideSplashTask != null) {
                        hideSplashTask.run();
                    }
                });
                try {
                    String token = SocketLock.readOneLine(this.mySystemPath.resolve(TOKEN_FILE));
                    DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                    String currentDirectory = System.getenv(LAUNCHER_INITIAL_DIRECTORY_ENV_VAR);
                    if (currentDirectory == null) {
                        currentDirectory = ".";
                    }
                    out.writeUTF(ACTIVATE_COMMAND + token + '\u0000' + Paths.get(currentDirectory, new String[0]).toAbsolutePath().toString() + '\u0000' + String.join((CharSequence)"\u0000", args));
                    out.flush();
                    socket.setSoTimeout(0);
                    List<String> response = SocketLock.readStringSequence(in);
                    SocketLock.log("read: response=%s", String.join((CharSequence)";", response));
                    if (!OK_RESPONSE.equals(ContainerUtil.getFirstItem(response))) return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.CANNOT_ACTIVATE, null);
                    if (JetBrainsProtocolHandler.isShutdownCommand()) {
                        SocketLock.printPID(portNumber);
                    }
                    simpleEntry2 = new AbstractMap.SimpleEntry<ActivationStatus, CliResult>(ActivationStatus.ACTIVATED, SocketLock.mapResponseToCliResult(response));
                }
                catch (IOException | IllegalArgumentException e) {
                    SocketLock.log(e);
                    return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.CANNOT_ACTIVATE, null);
                }
                socket.close();
                simpleEntry = simpleEntry2;
            }
            catch (ConnectException e) {
                SocketLock.log("%s (stale port file?)", e.getMessage());
                return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
            }
            catch (IOException e) {
                SocketLock.log(e);
                return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
            }
            if (simpleEntry != null) return simpleEntry;
            SocketLock.$$$reportNull$$$0(11);
            return simpleEntry;
        }
        socket.close();
        return new AbstractMap.SimpleEntry<ActivationStatus, Object>(ActivationStatus.NO_INSTANCE, null);
    }

    private static void printPID(int port) {
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
            socket.setSoTimeout(1000);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeUTF(PID_COMMAND);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int pid = 0;
            try {
                while (true) {
                    String s;
                    if (!Pattern.matches("[0-9]+@.*", s = in.readUTF())) {
                        continue;
                    }
                    pid = Integer.parseInt(s.substring(0, s.indexOf(64)));
                    System.err.println(pid);
                }
            }
            catch (IOException e) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendStringSequence(@NotNull ChannelHandlerContext context, @NotNull List<String> strings) throws IOException {
        if (context == null) {
            SocketLock.$$$reportNull$$$0(13);
        }
        if (strings == null) {
            SocketLock.$$$reportNull$$$0(14);
        }
        ByteBuf buffer = context.alloc().ioBuffer(1024);
        boolean success = false;
        try (ByteBufOutputStream out = new ByteBufOutputStream(buffer);){
            for (String s : strings) {
                out.writeUTF(s);
            }
            out.writeUTF(PATHS_EOT_RESPONSE);
            success = true;
        }
        finally {
            if (!success) {
                buffer.release();
            }
        }
        context.writeAndFlush((Object)buffer);
    }

    @NotNull
    private static List<String> readStringSequence(@NotNull DataInputStream in) {
        if (in == null) {
            SocketLock.$$$reportNull$$$0(15);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        try {
            while (true) {
                String string = in.readUTF();
                SocketLock.log("read: path=%s", string);
                if (!PATHS_EOT_RESPONSE.equals(string)) {
                    result2.add(string);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            SocketLock.log("read: %s", e.getMessage());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SocketLock.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static CliResult mapResponseToCliResult(@NotNull List<String> responseParts) throws IllegalArgumentException {
        int code;
        if (responseParts == null) {
            SocketLock.$$$reportNull$$$0(17);
        }
        if (responseParts.size() > 3 || responseParts.size() < 2) {
            throw new IllegalArgumentException("bad response: " + String.join((CharSequence)";", responseParts));
        }
        try {
            code = Integer.parseInt(responseParts.get(1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Second part is not a parsable return code", e);
        }
        String message = responseParts.size() == 3 ? responseParts.get(2) : null;
        return new CliResult(code, message);
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(@NonNls String format, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    static /* synthetic */ void access$100(Exception x0) {
        SocketLock.log(x0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemPath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/SocketLock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portToPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/SocketLock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "lockAndTryActivate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readOneLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tryActivate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lockAndTryActivate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readOneLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readPort";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryActivate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sendStringSequence";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readStringSequence";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mapResponseToCliResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyChannelInboundHandler
    extends MessageDecoder {
        private final List<String> myLockedPaths;
        private final AtomicReference<Function<List<String>, Future<CliResult>>> myCommandProcessorRef;
        private final String myToken;
        private State myState = State.HEADER;

        MyChannelInboundHandler(Path[] lockedPaths, AtomicReference<Function<List<String>, Future<CliResult>>> commandProcessorRef, String token) {
            this.myLockedPaths = new ArrayList<String>(lockedPaths.length);
            for (Path path : lockedPaths) {
                this.myLockedPaths.add(path.toString());
            }
            this.myCommandProcessorRef = commandProcessorRef;
            this.myToken = token;
        }

        public void channelActive(@NotNull ChannelHandlerContext context) throws Exception {
            if (context == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(0);
            }
            SocketLock.sendStringSequence(context, this.myLockedPaths);
        }

        /*
         * Unable to fully structure code
         */
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            if (context == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(1);
            }
            if (input == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(2);
            }
            while (true) {
                switch (1.$SwitchMap$com$intellij$idea$SocketLock$MyChannelInboundHandler$State[this.myState.ordinal()]) {
                    case 1: {
                        buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        if (this.contentLength > 8192) {
                            context.close();
                            return;
                        }
                        this.myState = State.CONTENT;
                        break;
                    }
                    case 2: {
                        command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (!StringUtil.startsWith((CharSequence)command, (CharSequence)"pid")) ** GOTO lbl34
                        buffer = context.alloc().ioBuffer();
                        out = new ByteBufOutputStream(buffer);
                        try {
                            name = ManagementFactory.getRuntimeMXBean().getName();
                            out.writeUTF(name);
                        }
                        finally {
                            out.close();
                        }
                        context.writeAndFlush((Object)buffer);
lbl34:
                        // 2 sources

                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)"activate ")) {
                            args = StringUtil.split((String)data, (String)((data = command.subSequence("activate ".length(), command.length()).toString()).contains("\u0000") != false ? "\u0000" : "\ufffd"));
                            v0 = tokenOK = args.isEmpty() == false && this.myToken.equals(args.get(0)) != false;
                            if (!tokenOK) {
                                SocketLock.access$100(new UnsupportedOperationException("unauthorized request: " + command));
                                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"activation.auth.title", (Object[])new Object[0]), IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]), NotificationType.WARNING));
                                result = new CliResult(13, IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]));
                            } else {
                                future = this.myCommandProcessorRef.get().apply(args.subList(1, args.size()));
                                result = CliResult.unmap(future, (int)15);
                            }
                            response = new ArrayList<E>();
                            ContainerUtil.addAllNotNull(response, (Object[])new String[]{"ok", String.valueOf(result.exitCode), result.message});
                            SocketLock.access$000(context, response);
                        }
                        context.close();
                        break;
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/idea/SocketLock$MyChannelInboundHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "channelActive";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "messageReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    public static enum ActivationStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

