/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import org.jetbrains.annotations.NotNull;

public final class FileEditorPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private static final Logger LOG = Logger.getInstance(FileEditorPsiTreeChangeListener.class);
    private final Project myProject;

    public FileEditorPsiTreeChangeListener(Project project) {
        this.myProject = project;
        if (this.myProject.isDefault()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
        if (e == null) {
            FileEditorPsiTreeChangeListener.$$$reportNull$$$0(0);
        }
        if ("roots".equals(e.getPropertyName())) {
            ApplicationManager.getApplication().assertIsWriteThread();
            FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject);
            VirtualFile[] openFiles = fileEditorManager.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                LOG.assertTrue(file2 != null);
                fileEditorManager.updateFilePresentation(file2);
            }
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            FileEditorPsiTreeChangeListener.$$$reportNull$$$0(1);
        }
        this.doChange(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            FileEditorPsiTreeChangeListener.$$$reportNull$$$0(2);
        }
        this.doChange(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            FileEditorPsiTreeChangeListener.$$$reportNull$$$0(3);
        }
        this.doChange(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            FileEditorPsiTreeChangeListener.$$$reportNull$$$0(4);
        }
        this.doChange(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            FileEditorPsiTreeChangeListener.$$$reportNull$$$0(5);
        }
        this.doChange(event);
    }

    private void doChange(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return;
        }
        FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject);
        FileEditor[] editors = fileEditorManager.getAllEditors(file2);
        if (editors.length == 0) {
            return;
        }
        VirtualFile currentFile = fileEditorManager.getCurrentFile();
        if (currentFile != null && Comparing.equal((Object)psiFile.getVirtualFile(), (Object)currentFile)) {
            fileEditorManager.updateFilePresentation(currentFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorPsiTreeChangeListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

