/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ConfigurableCardPanel
extends CardLayoutPanel<Configurable, Configurable, JComponent> {
    private static final Logger LOG = Logger.getInstance(ConfigurableCardPanel.class);
    private final Map<Configurable, Disposable> myListeners = new ConcurrentHashMap<Configurable, Disposable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Configurable prepare(Configurable key) {
        long time = System.currentTimeMillis();
        try {
            ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)key);
        }
        catch (Exception unexpected) {
            LOG.error("cannot prepare configurable", (Throwable)unexpected);
        }
        finally {
            ConfigurableCardPanel.warn(key, "prepare", time);
        }
        return key;
    }

    @Override
    protected JComponent create(Configurable configurable2) {
        if (configurable2 == null) {
            return null;
        }
        JComponent component2 = ConfigurableCardPanel.createConfigurableComponent(configurable2);
        if (component2 == null) {
            return null;
        }
        if (configurable2 instanceof ConfigurableWrapper) {
            ReadAction.run(() -> this.addEPChangesListener((ConfigurableWrapper)configurable2));
        }
        return new Wrapper(configurable2, component2);
    }

    protected void addEPChangesListener(@NotNull ConfigurableWrapper wrapper2) {
        if (wrapper2 == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(0);
        }
        if (wrapper2.getExtensionPoint().dynamic) {
            return;
        }
        Configurable.WithEpDependencies configurable2 = ConfigurableWrapper.cast(Configurable.WithEpDependencies.class, (UnnamedConfigurable)wrapper2);
        if (configurable2 != null && !this.myListeners.containsKey(wrapper2)) {
            Disposable disposable2 = Disposer.newDisposable();
            Collection dependencies = configurable2.getDependencies();
            Runnable listener2 = () -> ApplicationManager.getApplication().invokeLater(() -> {
                wrapper2.disposeUIResources();
                this.resetValue(wrapper2);
            }, ModalityState.stateForComponent((Component)this), __ -> this.isDisposed());
            for (BaseExtensionPointName dependency : dependencies) {
                if (dependency instanceof ExtensionPointName) {
                    ((ExtensionPointName)dependency).addChangeListener(listener2, disposable2);
                    continue;
                }
                if (!(dependency instanceof ProjectExtensionPointName)) continue;
                Project project = wrapper2.getProject();
                assert (project != null);
                ((ProjectExtensionPointName)dependency).addChangeListener((AreaInstance)project, listener2, disposable2);
            }
            this.myListeners.put((Configurable)wrapper2, disposable2);
        }
    }

    public static JComponent createConfigurableComponent(Configurable configurable2) {
        return configurable2 == null ? null : (JComponent)ReadAction.compute(() -> {
            JComponent component2 = null;
            long time = System.currentTimeMillis();
            try {
                component2 = configurable2.createComponent();
            }
            catch (Exception unexpected) {
                LOG.error("cannot create configurable component", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable2, "create", time);
            }
            if (component2 != null) {
                ConfigurableCardPanel.reset(configurable2);
                if (ConfigurableWrapper.cast(MasterDetails.class, (UnnamedConfigurable)configurable2) == null) {
                    if (ConfigurableWrapper.cast(Configurable.NoMargin.class, (UnnamedConfigurable)configurable2) == null) {
                        if (!component2.getClass().equals(JPanel.class) && !component2.getClass().equals(DialogPanel.class)) {
                            JPanel panel2 = new JPanel(new BorderLayout());
                            panel2.add("Center", component2);
                            component2 = panel2;
                        }
                        component2.setBorder((Border)JBUI.Borders.empty((int)11, (int)16, (int)16, (int)16));
                    }
                    if (ConfigurableWrapper.cast(Configurable.NoScroll.class, (UnnamedConfigurable)configurable2) == null) {
                        JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
                        scroll.setViewport((JViewport)((Object)new GradientViewport(component2, (Insets)JBUI.insetsTop((int)5), true)));
                        scroll.getVerticalScrollBar().setBackground(JBColor.PanelBackground);
                        scroll.getHorizontalScrollBar().setBackground(JBColor.PanelBackground);
                        component2 = scroll;
                    }
                }
            }
            return component2;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(Configurable configurable2, JComponent component2) {
        if (configurable2 != null) {
            long time = System.currentTimeMillis();
            try {
                configurable2.disposeUIResources();
                Disposable disposer = this.myListeners.remove(configurable2);
                if (disposer != null) {
                    Disposer.dispose((Disposable)disposer);
                }
                if (component2 instanceof Disposable) {
                    Disposer.dispose((Disposable)((Disposable)component2));
                }
                ConfigurableCardPanel.autoDispose(configurable2, component2);
            }
            catch (Exception unexpected) {
                LOG.error("cannot dispose configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable2, "dispose", time);
            }
        }
    }

    private static void autoDispose(Configurable configurable2, Component component2) {
        UIUtil.uiTraverser((Component)component2).traverse().filter(Disposable.class).filter(disposable2 -> !Disposer.isDisposed((Disposable)disposable2)).forEach(disposable2 -> {
            LOG.warn(ConfigurableCardPanel.getString("auto-dispose", configurable2));
            Disposer.dispose((Disposable)disposable2);
            if (LOG.isDebugEnabled()) {
                UIUtil.uiParents((Component)((Component)disposable2), (boolean)false).forEach(parent -> LOG.debug("  in ", new Object[]{parent.getClass()}));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(Configurable configurable2) {
        if (configurable2 != null) {
            long time = System.currentTimeMillis();
            try {
                configurable2.reset();
            }
            catch (Exception unexpected) {
                LOG.error("cannot reset configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable2, "reset", time);
            }
        }
    }

    @NotNull
    private static String getString(@NotNull String prefix, @NotNull Configurable configurable2) {
        if (prefix == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(1);
        }
        if (configurable2 == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(2);
        }
        String name = configurable2.getDisplayName();
        String id2 = ConfigurableVisitor.getId(configurable2);
        String string = prefix + " '" + name + "' id=" + id2;
        if (string == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    static void warn(Configurable configurable2, String action2, long time) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            time = System.currentTimeMillis() - time;
            int threshold = Registry.intValue((String)"ide.settings.configurable.loading.threshold", (int)0);
            if (0 < threshold && (long)threshold < time) {
                LOG.warn(time + " ms to " + ConfigurableCardPanel.getString(action2, configurable2));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myListeners.values().forEach(Disposer::dispose);
        this.myListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableCardPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableCardPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addEPChangesListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Wrapper
    extends JPanel
    implements Disposable,
    DataProvider {
        private final Configurable myConfigurable;

        private Wrapper(@NotNull Configurable configurable2, @NotNull JComponent component2) {
            if (configurable2 == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myConfigurable = configurable2;
            this.add("Center", component2);
        }

        public void dispose() {
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            return PlatformDataKeys.UI_DISPOSABLE.is(dataId) ? this : null;
        }

        @Override
        public String toString() {
            return ConfigurableCardPanel.getString("configurable wrapper", this.myConfigurable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableCardPanel$Wrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

