/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.roots.ui.configuration.SdkListModelBuilder;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Container;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkComboBoxBase<T>
extends ComboBox<T> {
    private final Logger LOG;
    @NotNull
    protected final SdkListModelBuilder myModel;

    protected SdkComboBoxBase(@NotNull SdkListModelBuilder model) {
        if (model == null) {
            SdkComboBoxBase.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getInstance(((Object)((Object)this)).getClass());
        this.myModel = model;
        this.myModel.addModelListener(new SdkListModelBuilder.ModelListener(){

            @Override
            public void syncModel(@NotNull SdkListModel model) {
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                SdkComboBoxBase.this.onModelUpdated(model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/ui/configuration/SdkComboBoxBase$1", "syncModel"));
            }
        });
        ComponentUtil.putClientProperty((JComponent)((Object)this), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        this.setMinimumAndPreferredWidth(JBUI.scale((int)300));
        this.setMaximumRowCount(30);
        this.setSwingPopup(false);
        this.putClientProperty("ComboBox.jbPopup.supportUpdateModel", true);
    }

    protected abstract void onModelUpdated(@NotNull SdkListModel var1);

    public void setInvalidJdk(String name) {
        this.setSelectedItem(this.myModel.showInvalidSdkItem(name));
    }

    @NotNull
    public SdkListItem showInvalidSdkItem(@NotNull String name) {
        if (name == null) {
            SdkComboBoxBase.$$$reportNull$$$0(1);
        }
        SdkListItem sdkListItem = this.myModel.showInvalidSdkItem(name);
        if (sdkListItem == null) {
            SdkComboBoxBase.$$$reportNull$$$0(2);
        }
        return sdkListItem;
    }

    @NotNull
    public SdkListItem showProjectSdkItem() {
        SdkListItem sdkListItem = this.myModel.showProjectSdkItem();
        if (sdkListItem == null) {
            SdkComboBoxBase.$$$reportNull$$$0(3);
        }
        return sdkListItem;
    }

    @NotNull
    public SdkListItem showNoneSdkItem() {
        SdkListItem sdkListItem = this.myModel.showNoneSdkItem();
        if (sdkListItem == null) {
            SdkComboBoxBase.$$$reportNull$$$0(4);
        }
        return sdkListItem;
    }

    @NotNull
    public SdkListItem addSdkReferenceItem(@NotNull SdkType type, @NotNull String name, @Nullable String versionString, boolean isValid) {
        if (type == null) {
            SdkComboBoxBase.$$$reportNull$$$0(5);
        }
        if (name == null) {
            SdkComboBoxBase.$$$reportNull$$$0(6);
        }
        SdkListItem.SdkReferenceItem sdkReferenceItem = this.myModel.addSdkReferenceItem(type, name, versionString, isValid);
        if (sdkReferenceItem == null) {
            SdkComboBoxBase.$$$reportNull$$$0(7);
        }
        return sdkReferenceItem;
    }

    public void reloadModel() {
        this.myModel.reloadSdks();
    }

    @Deprecated
    public void addItem(T item) {
        this.LOG.warn("JdkComboBox#addItem() is deprecated!" + item, (Throwable)new RuntimeException());
    }

    @Deprecated
    public void insertItemAt(T item, int index) {
        this.LOG.warn("insertItemAt() is deprecated!" + item + " at " + index, (Throwable)new RuntimeException());
    }

    @Deprecated
    public void removeItem(Object anObject) {
        this.LOG.warn("removeItem() is deprecated!", (Throwable)new RuntimeException());
    }

    @Deprecated
    public void removeItemAt(int anIndex) {
        this.LOG.warn("removeItemAt() is deprecated!", (Throwable)new RuntimeException());
    }

    @Deprecated
    public void removeAllItems() {
        this.LOG.warn("removeAllItems() is deprecated!", (Throwable)new RuntimeException());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSDKComboboxBaseDelegate(super.getAccessibleContext());
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkComboBoxBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkComboBoxBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "showInvalidSdkItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "showProjectSdkItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showNoneSdkItem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addSdkReferenceItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showInvalidSdkItem";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSdkReferenceItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AccessibleSDKComboboxBaseDelegate
    extends AccessibleContextDelegate {
        AccessibleSDKComboboxBaseDelegate(AccessibleContext context) {
            super(context);
        }

        protected Container getDelegateParent() {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return SdkComboBoxBase.this.getComponentCount();
        }
    }
}

