/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.AppTopics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.highlighter.WorkspaceFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EncodingUtil {
    @NotNull
    static Magic8 isSafeToReloadIn(@NotNull VirtualFile virtualFile, @NotNull CharSequence text, byte @NotNull [] bytes, @NotNull Charset charset) {
        byte[] bytesToSave;
        byte[] bom;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            EncodingUtil.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(2);
        }
        if (bytes == null) {
            EncodingUtil.$$$reportNull$$$0(3);
        }
        if ((bom = virtualFile.getBOM()) != null && !CharsetToolkit.canHaveBom((Charset)charset, (byte[])bom)) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(4);
            }
            return magic8;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)charset);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(5);
            }
            return magic8;
        }
        String loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, charset).toString();
        String separator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        String toSave = StringUtil.convertLineSeparators((String)loaded, (String)separator);
        LoadTextUtil.AutoDetectionReason failReason = LoadTextUtil.getCharsetAutoDetectionReason(virtualFile);
        if (failReason != null && StandardCharsets.UTF_8.equals(virtualFile.getCharset()) && !StandardCharsets.UTF_8.equals(charset)) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(6);
            }
            return magic8;
        }
        try {
            bytesToSave = toSave.getBytes(charset);
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(7);
            }
            return magic8;
        }
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        Magic8 magic8 = !Arrays.equals(bytesToSave, bytes) ? Magic8.NO_WAY : (StringUtil.equals((CharSequence)loaded, (CharSequence)text) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
        if (magic8 == null) {
            EncodingUtil.$$$reportNull$$$0(8);
        }
        return magic8;
    }

    @NotNull
    static Magic8 isSafeToConvertTo(@NotNull VirtualFile virtualFile, @NotNull CharSequence text, byte @NotNull [] bytesOnDisk, @NotNull Charset charset) {
        Magic8 magic8;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(9);
        }
        if (text == null) {
            EncodingUtil.$$$reportNull$$$0(10);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(11);
        }
        if (bytesOnDisk == null) {
            EncodingUtil.$$$reportNull$$$0(12);
        }
        try {
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
            CharSequence textToSave = lineSeparator.equals("\n") ? text : StringUtilRt.convertLineSeparators((CharSequence)text, (String)lineSeparator);
            Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(virtualFile.getCharset(), charset, textToSave.toString());
            byte[] saved = (byte[])chosen.second;
            CharSequence textLoadedBack = LoadTextUtil.getTextByBinaryPresentation(saved, charset);
            magic8 = !StringUtil.equals((CharSequence)text, (CharSequence)textLoadedBack) ? Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            Magic8 magic82 = Magic8.NO_WAY;
            if (magic82 == null) {
                EncodingUtil.$$$reportNull$$$0(14);
            }
            return magic82;
        }
        if (magic8 == null) {
            EncodingUtil.$$$reportNull$$$0(13);
        }
        return magic8;
    }

    static void saveIn(@NotNull Project project, @NotNull Document document, Editor editor, @NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        if (project == null) {
            EncodingUtil.$$$reportNull$$$0(15);
        }
        if (document == null) {
            EncodingUtil.$$$reportNull$$$0(16);
        }
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(17);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(18);
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        documentManager.saveDocument(document);
        boolean writable = ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
        if (!writable) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)IdeBundle.message((String)"dialog.message.cannot.save.the.file.0", (Object[])new Object[]{virtualFile.getPresentableUrl()}), (String)IdeBundle.message((String)"dialog.title.unable.to.save", (Object[])new Object[0]), null);
            return;
        }
        EncodingProjectManagerImpl.suppressReloadDuring(() -> {
            EncodingProjectManager.getInstance((Project)project).setEncoding(virtualFile, charset);
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    virtualFile.setCharset(charset);
                    LoadTextUtil.write(project, virtualFile, virtualFile, document.getText(), document.getModificationStamp());
                    return null;
                });
            }
            catch (IOException io) {
                Messages.showErrorDialog((Project)project, (String)io.getMessage(), (String)IdeBundle.message((String)"dialog.title.error.writing.file", (Object[])new Object[0]));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reloadIn(final @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull Project project) {
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(19);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            EncodingUtil.$$$reportNull$$$0(21);
        }
        final Consumer<VirtualFile> setEncoding = file2 -> EncodingProjectManager.getInstance((Project)project).setEncoding(file2, charset);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.getCachedDocument(virtualFile) == null) {
            setEncoding.accept(virtualFile);
            return;
        }
        final Disposable disposable2 = Disposer.newDisposable();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(disposable2);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void beforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!file2.equals(virtualFile)) {
                    return;
                }
                Disposer.dispose((Disposable)disposable2);
                setEncoding.accept(file2);
                LoadTextUtil.clearCharsetAutoDetectionReason(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vfs/encoding/EncodingUtil$1";
                objectArray[2] = "beforeFileContentReload";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        try {
            EncodingProjectManagerImpl.suppressReloadDuring(() -> ((FileDocumentManagerImpl)documentManager).contentsChanged(new VFileContentChangeEvent(null, virtualFile, 0L, 0L, false)));
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private static String checkHardcodedCharsetFileType(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(22);
        }
        if ((fileType = virtualFile.getFileType()) == FileTypes.PLAIN_TEXT) {
            return null;
        }
        if (fileType == StdFileTypes.GUI_DESIGNER_FORM) {
            return "IDEA GUI Designer form";
        }
        if (fileType == ModuleFileType.INSTANCE) {
            return "IDEA module file";
        }
        if (fileType == ProjectFileType.INSTANCE) {
            return "IDEA project file";
        }
        if (fileType == WorkspaceFileType.INSTANCE) {
            return "IDEA workspace file";
        }
        if (fileType == StdFileTypes.PROPERTIES) {
            return ".properties file\n(see Settings|Editor|File Encodings|Properties Files)";
        }
        if (fileType == StdFileTypes.XML) {
            return "XML file";
        }
        if (fileType == StdFileTypes.JSPX) {
            return "JSPX file";
        }
        return null;
    }

    public static boolean canReload(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(23);
        }
        return EncodingUtil.checkCanReload(virtualFile, null) == null;
    }

    @Nullable
    static FailReason checkCanReload(@NotNull VirtualFile virtualFile, @Nullable Ref<? super Charset> current2) {
        FailReason result2;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(24);
        }
        if (virtualFile.isDirectory()) {
            return FailReason.IS_DIRECTORY;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return FailReason.IS_BINARY;
        }
        Charset charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        Charset existing = virtualFile.getCharset();
        LoadTextUtil.AutoDetectionReason autoDetectedFrom = LoadTextUtil.getCharsetAutoDetectionReason(virtualFile);
        if (autoDetectedFrom != null) {
            result2 = autoDetectedFrom == LoadTextUtil.AutoDetectionReason.FROM_BOM ? FailReason.BY_BOM : FailReason.BY_BYTES;
        } else if (charsetFromContent != null) {
            result2 = FailReason.BY_FILE;
            existing = charsetFromContent;
        } else {
            result2 = EncodingUtil.fileTypeDescriptionError(virtualFile);
        }
        if (current2 != null) {
            current2.set((Object)existing);
        }
        return result2;
    }

    @Nullable
    private static FailReason fileTypeDescriptionError(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(25);
        }
        if (virtualFile.getFileType().isBinary()) {
            return FailReason.IS_BINARY;
        }
        String fileTypeDescription = EncodingUtil.checkHardcodedCharsetFileType(virtualFile);
        return fileTypeDescription == null ? null : FailReason.BY_FILETYPE;
    }

    @Nullable(value="null means enabled, notnull means disabled and contains error message")
    static @Nullable(value="null means enabled, notnull means disabled and contains error message") FailReason checkCanConvert(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(26);
        }
        if (virtualFile.isDirectory()) {
            return FailReason.IS_DIRECTORY;
        }
        Charset charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        return charsetFromContent != null ? FailReason.BY_FILE : EncodingUtil.fileTypeDescriptionError(virtualFile);
    }

    @Nullable
    static FailReason checkCanConvertAndReload(@NotNull VirtualFile selectedFile) {
        FailReason result2;
        if (selectedFile == null) {
            EncodingUtil.$$$reportNull$$$0(27);
        }
        if ((result2 = EncodingUtil.checkCanConvert(selectedFile)) == null) {
            return null;
        }
        return EncodingUtil.checkCanReload(selectedFile, null);
    }

    @Nullable
    public static Pair<Charset, String> getCharsetAndTheReasonTooltip(@NotNull VirtualFile file2) {
        FailReason r1;
        if (file2 == null) {
            EncodingUtil.$$$reportNull$$$0(28);
        }
        if ((r1 = EncodingUtil.checkCanConvert(file2)) == null) {
            return null;
        }
        Ref current2 = Ref.create();
        FailReason r2 = EncodingUtil.checkCanReload(file2, (Ref<? super Charset>)current2);
        if (r2 == null) {
            return null;
        }
        String errorDescription = r1 == r2 ? EncodingUtil.reasonToString(r1, file2) : EncodingUtil.reasonToString(r1, file2) + ", " + EncodingUtil.reasonToString(r2, file2);
        return Pair.create((Object)((Charset)current2.get()), (Object)errorDescription);
    }

    static String reasonToString(@NotNull FailReason reason, VirtualFile file2) {
        if (reason == null) {
            EncodingUtil.$$$reportNull$$$0(29);
        }
        switch (reason) {
            case IS_DIRECTORY: {
                return "disabled for a directory";
            }
            case IS_BINARY: {
                return "disabled for a binary file";
            }
            case BY_FILE: {
                return "charset is hard-coded in the file";
            }
            case BY_BOM: {
                return "charset is auto-detected by BOM";
            }
            case BY_BYTES: {
                return "charset is auto-detected from content";
            }
            case BY_FILETYPE: {
                return "disabled for " + file2.getFileType().getDescription();
            }
        }
        throw new AssertionError((Object)reason);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 11: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytesOnDisk";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isSafeToReloadIn";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "isSafeToConvertTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToReloadIn";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToConvertTo";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveIn";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reloadIn";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkHardcodedCharsetFileType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canReload";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkCanReload";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fileTypeDescriptionError";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkCanConvert";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkCanConvertAndReload";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetAndTheReasonTooltip";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reasonToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Magic8 {
        ABSOLUTELY,
        WELL_IF_YOU_INSIST,
        NO_WAY;

    }

    static enum FailReason {
        IS_DIRECTORY,
        IS_BINARY,
        BY_FILE,
        BY_BOM,
        BY_BYTES,
        BY_FILETYPE;

    }
}

