/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementBase
extends ElementBase
implements NavigatablePsiElement,
Cloneable {
    private static final Logger LOG = Logger.getInstance(PsiElementBase.class);

    public PsiElement getFirstChild() {
        PsiElement[] children2 = this.getChildren();
        if (children2.length == 0) {
            return null;
        }
        return children2[0];
    }

    public PsiElement getLastChild() {
        PsiElement[] children2 = this.getChildren();
        if (children2.length == 0) {
            return null;
        }
        return children2[children2.length - 1];
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling((PsiElement)this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling((PsiElement)this);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiElementBase.$$$reportNull$$$0(0);
        }
        for (PsiElement child2 = this.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            child2.accept(visitor);
        }
    }

    public PsiReference getReference() {
        return null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            PsiElementBase.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this, offset);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            PsiElementBase.$$$reportNull$$$0(2);
        }
        if (last == null) {
            PsiElementBase.$$$reportNull$$$0(3);
        }
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    public PsiElement copy() {
        return (PsiElement)this.clone();
    }

    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiElementBase.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiElementBase.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiElementBase.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiElementBase.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void delete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiElementBase.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiElementBase.$$$reportNull$$$0(9);
        }
        if (state == null) {
            PsiElementBase.$$$reportNull$$$0(10);
        }
        if (place == null) {
            PsiElementBase.$$$reportNull$$$0(11);
        }
        return true;
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElementBase psiElementBase = this;
        if (psiElementBase == null) {
            PsiElementBase.$$$reportNull$$$0(12);
        }
        return psiElementBase;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            PsiElementBase.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope((PsiElement)this);
        if (globalSearchScope == null) {
            PsiElementBase.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    public void navigate(boolean requestFocus) {
        Navigatable descriptor2 = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            PsiElementBase.$$$reportNull$$$0(15);
        }
        return project;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return parent.getContainingFile();
    }

    public boolean isPhysical() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isPhysical();
    }

    public boolean isWritable() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isWritable();
    }

    public boolean isValid() {
        PsiElement parent;
        for (parent = this.getParent(); parent != null && parent.getClass() == this.getClass(); parent = parent.getParent()) {
        }
        return parent != null && parent.isValid();
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            PsiElementBase.$$$reportNull$$$0(16);
        }
        return Comparing.equal((CharSequence)this.getText(), (CharSequence)text, (boolean)true);
    }

    public boolean textMatches(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiElementBase.$$$reportNull$$$0(17);
        }
        return this.getText().equals(element2.getText());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiElementBase.$$$reportNull$$$0(18);
        }
        visitor.visitElement((PsiElement)this);
    }

    public String getName() {
        return null;
    }

    @NotNull
    protected <T> T notNullChild(T child2) {
        if (child2 == null) {
            LOG.error(this.getText() + "\n parent=" + this.getParent().getText());
        }
        T t = child2;
        if (t == null) {
            PsiElementBase.$$$reportNull$$$0(19);
        }
        return t;
    }

    protected <T> T @NotNull [] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            result2.add(cur);
        }
        Object[] objectArray = result2.toArray(ArrayUtil.newArray(aClass, (int)result2.size()));
        if (objectArray == null) {
            PsiElementBase.$$$reportNull$$$0(20);
        }
        return objectArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T findNotNullChildByClass(Class<T> aClass) {
        T t = this.notNullChild(this.findChildByClass(aClass));
        if (t == null) {
            PsiElementBase.$$$reportNull$$$0(21);
        }
        return t;
    }

    public PsiManager getManager() {
        return PsiManager.getInstance((Project)this.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiElementBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiElementBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullChild";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenByClass";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotNullChildByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

