/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.LightIndexPatternSearch;
import com.intellij.psi.impl.search.TodoItemsCreator;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.psi.search.searches.IndexPatternSearch;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiTodoSearchHelperImpl
implements PsiTodoSearchHelper {
    private final PsiManagerEx myManager;
    private static final TodoItem[] EMPTY_TODO_ITEMS = new TodoItem[0];

    public PsiTodoSearchHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(0);
        }
        this.myManager = PsiManagerEx.getInstanceEx(project);
    }

    @Deprecated
    public PsiTodoSearchHelperImpl(@NotNull PsiManagerEx psiManager) {
        if (psiManager == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(1);
        }
        this.myManager = psiManager;
    }

    public PsiFile @NotNull [] findFilesWithTodoItems() {
        PsiFile[] psiFileArray = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithTodoItems();
        if (psiFileArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(2);
        }
        return psiFileArray;
    }

    public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(3);
        }
        TodoItem[] todoItemArray = this.findTodoItems(file2, 0, file2.getTextLength());
        if (todoItemArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(4);
        }
        return todoItemArray;
    }

    public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file2, int startOffset, int endOffset) {
        Collection occurrences;
        if (file2 == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(5);
        }
        if ((occurrences = IndexPatternSearch.search((PsiFile)file2, (IndexPatternProvider)TodoIndexPatternProvider.getInstance(), (boolean)TodoConfiguration.getInstance().isMultiLine()).findAll()).isEmpty()) {
            if (EMPTY_TODO_ITEMS == null) {
                PsiTodoSearchHelperImpl.$$$reportNull$$$0(6);
            }
            return EMPTY_TODO_ITEMS;
        }
        return PsiTodoSearchHelperImpl.processTodoOccurences(startOffset, endOffset, occurrences);
    }

    private static TodoItem @NotNull [] processTodoOccurences(int startOffset, int endOffset, Collection<? extends IndexPatternOccurrence> occurrences) {
        ArrayList<TodoItem> items = new ArrayList<TodoItem>(occurrences.size());
        TextRange textRange = new TextRange(startOffset, endOffset);
        TodoItemsCreator todoItemsCreator = new TodoItemsCreator();
        for (IndexPatternOccurrence indexPatternOccurrence : occurrences) {
            TextRange occurrenceRange = indexPatternOccurrence.getTextRange();
            if (!textRange.intersectsStrict(occurrenceRange) && !indexPatternOccurrence.getAdditionalTextRanges().stream().anyMatch(r -> textRange.intersectsStrict(r))) continue;
            items.add(todoItemsCreator.createTodo(indexPatternOccurrence));
        }
        TodoItem[] todoItemArray = items.toArray(new TodoItem[0]);
        if (todoItemArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(7);
        }
        return todoItemArray;
    }

    public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(8);
        }
        TodoItem[] todoItemArray = this.findTodoItemsLight(file2, 0, file2.getTextLength());
        if (todoItemArray == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(9);
        }
        return todoItemArray;
    }

    public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file2, int startOffset, int endOffset) {
        Collection occurrences;
        if (file2 == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(10);
        }
        if ((occurrences = LightIndexPatternSearch.SEARCH.createQuery(new IndexPatternSearch.SearchParameters(file2, (IndexPatternProvider)TodoIndexPatternProvider.getInstance(), TodoConfiguration.getInstance().isMultiLine())).findAll()).isEmpty()) {
            if (EMPTY_TODO_ITEMS == null) {
                PsiTodoSearchHelperImpl.$$$reportNull$$$0(11);
            }
            return EMPTY_TODO_ITEMS;
        }
        return PsiTodoSearchHelperImpl.processTodoOccurences(startOffset, endOffset, occurrences);
    }

    public int getTodoItemsCount(@NotNull PsiFile file2) {
        int count;
        if (file2 == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(12);
        }
        if ((count = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getTodoCount(file2.getVirtualFile(), TodoIndexPatternProvider.getInstance())) != -1) {
            return count;
        }
        return this.findTodoItems(file2).length;
    }

    public int getTodoItemsCount(@NotNull PsiFile file2, @NotNull TodoPattern pattern) {
        int count;
        if (file2 == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(13);
        }
        if (pattern == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(14);
        }
        if ((count = TodoCacheManager.SERVICE.getInstance(this.myManager.getProject()).getTodoCount(file2.getVirtualFile(), pattern.getIndexPattern())) != -1) {
            return count;
        }
        TodoItem[] items = this.findTodoItems(file2);
        count = 0;
        for (TodoItem item : items) {
            if (!item.getPattern().equals((Object)pattern)) continue;
            ++count;
        }
        return count;
    }

    public boolean shouldHighlightInEditor(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiTodoSearchHelperImpl.$$$reportNull$$$0(15);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiTodoSearchHelperImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithTodoItems";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTodoItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processTodoOccurences";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findTodoItemsLight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTodoItems";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTodoItemsLight";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTodoItemsCount";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

