/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileReferenceHelper {
    public static final ExtensionPointName<FileReferenceHelper> EP_NAME = new ExtensionPointName("com.intellij.psi.fileReferenceHelper");

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            FileReferenceHelper.$$$reportNull$$$0(0);
        }
        String string = url;
        if (string == null) {
            FileReferenceHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference2) {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    public PsiFileSystemItem getPsiFileSystemItem(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(3);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return FileReferenceHelper.getPsiFileSystemItem(psiManager, file2);
    }

    public static PsiFileSystemItem getPsiFileSystemItem(PsiManager psiManager, VirtualFile file2) {
        return file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
    }

    @Nullable
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            FileReferenceHelper.$$$reportNull$$$0(5);
        }
        List<PsiFileSystemItem> list2 = Collections.emptyList();
        if (list2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module, @NotNull VirtualFile file2) {
        if (module == null) {
            FileReferenceHelper.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(8);
        }
        Collection<PsiFileSystemItem> collection = this.getRoots(module);
        if (collection == null) {
            FileReferenceHelper.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public abstract Collection<PsiFileSystemItem> getContexts(Project var1, @NotNull VirtualFile var2);

    public abstract boolean isMine(Project var1, @NotNull VirtualFile var2);

    public boolean isFallback() {
        return false;
    }

    @NotNull
    public Collection<FileTargetContext> getTargetContexts(@NotNull Project project, @NotNull VirtualFile file2, boolean isAbsoluteReference) {
        if (project == null) {
            FileReferenceHelper.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            FileReferenceHelper.$$$reportNull$$$0(11);
        }
        if (isAbsoluteReference) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Module module = index.getModuleForFile(file2);
            if (module == null) {
                List<FileTargetContext> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileReferenceHelper.$$$reportNull$$$0(12);
                }
                return list2;
            }
            List list3 = ContainerUtil.map(this.getRoots(module, file2), FileTargetContext::new);
            if (list3 == null) {
                FileReferenceHelper.$$$reportNull$$$0(13);
            }
            return list3;
        }
        List list4 = ContainerUtil.map(this.getContexts(project, file2), FileTargetContext::new);
        if (list4 == null) {
            FileReferenceHelper.$$$reportNull$$$0(14);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileSystemItem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContexts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

