
if (CMAKE_VERSION VERSION_LESS 3.1.0)
    message(FATAL_ERROR "Qt 5 HunspellInputMethod module requires at least CMake version 3.1.0")
endif()

get_filename_component(_qt5HunspellInputMethod_install_prefix "${CMAKE_CURRENT_LIST_DIR}/./../../" ABSOLUTE)

# For backwards compatibility only. Use Qt5HunspellInputMethod_VERSION instead.
set(Qt5HunspellInputMethod_VERSION_STRING 5.13.2)

set(Qt5HunspellInputMethod_LIBRARIES Qt5::HunspellInputMethod)

macro(_qt5_HunspellInputMethod_check_file_exists file)
    if(NOT EXISTS "${file}" )
        message(FATAL_ERROR "The imported target \"Qt5::HunspellInputMethod\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()


macro(_populate_HunspellInputMethod_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION
      IsDebugAndRelease)
    set_property(TARGET Qt5::HunspellInputMethod APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt5HunspellInputMethod_install_prefix}/./${LIB_LOCATION}")
    _qt5_HunspellInputMethod_check_file_exists(${imported_location})
    set(_deps
        ${_Qt5HunspellInputMethod_LIB_DEPENDENCIES}
    )
    set(_static_deps
    )

    set_target_properties(Qt5::HunspellInputMethod PROPERTIES
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        # For backward compatibility with CMake < 2.8.12
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_deps};${_static_deps}"
    )
    set_property(TARGET Qt5::HunspellInputMethod APPEND PROPERTY INTERFACE_LINK_LIBRARIES
                 "${_deps}"
    )


endmacro()

if (NOT TARGET Qt5::HunspellInputMethod)

    set(_Qt5HunspellInputMethod_OWN_INCLUDE_DIRS "/usr/local/include/X11/qt5/" "/usr/local/include/X11/qt5/QtHunspellInputMethod")
    set(Qt5HunspellInputMethod_PRIVATE_INCLUDE_DIRS
        "/usr/local/include/X11/qt5/QtHunspellInputMethod/5.13.2"
        "/usr/local/include/X11/qt5/QtHunspellInputMethod/5.13.2/QtHunspellInputMethod"
    )
    include("${CMAKE_CURRENT_LIST_DIR}/ExtraSourceIncludes.cmake" OPTIONAL)

    foreach(_dir ${_Qt5HunspellInputMethod_OWN_INCLUDE_DIRS})
        _qt5_HunspellInputMethod_check_file_exists(${_dir})
    endforeach()

    # Only check existence of private includes if the Private component is
    # specified.
    list(FIND Qt5HunspellInputMethod_FIND_COMPONENTS Private _check_private)
    if (NOT _check_private STREQUAL -1)
        foreach(_dir ${Qt5HunspellInputMethod_PRIVATE_INCLUDE_DIRS})
            _qt5_HunspellInputMethod_check_file_exists(${_dir})
        endforeach()
    endif()

    set(Qt5HunspellInputMethod_INCLUDE_DIRS ${_Qt5HunspellInputMethod_OWN_INCLUDE_DIRS})

    set(Qt5HunspellInputMethod_DEFINITIONS -DQT_HUNSPELLINPUTMETHOD_LIB)
    set(Qt5HunspellInputMethod_COMPILE_DEFINITIONS QT_HUNSPELLINPUTMETHOD_LIB)
    set(_Qt5HunspellInputMethod_MODULE_DEPENDENCIES "VirtualKeyboard;Gui;Core")


    set(Qt5HunspellInputMethod_OWN_PRIVATE_INCLUDE_DIRS ${Qt5HunspellInputMethod_PRIVATE_INCLUDE_DIRS})

    set(_Qt5HunspellInputMethod_FIND_DEPENDENCIES_REQUIRED)
    if (Qt5HunspellInputMethod_FIND_REQUIRED)
        set(_Qt5HunspellInputMethod_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt5HunspellInputMethod_FIND_DEPENDENCIES_QUIET)
    if (Qt5HunspellInputMethod_FIND_QUIETLY)
        set(_Qt5HunspellInputMethod_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt5HunspellInputMethod_FIND_VERSION_EXACT)
    if (Qt5HunspellInputMethod_FIND_VERSION_EXACT)
        set(_Qt5HunspellInputMethod_FIND_VERSION_EXACT EXACT)
    endif()

    set(Qt5HunspellInputMethod_EXECUTABLE_COMPILE_FLAGS "")

    foreach(_module_dep ${_Qt5HunspellInputMethod_MODULE_DEPENDENCIES})
        if (NOT Qt5${_module_dep}_FOUND)
            find_package(Qt5${_module_dep}
                5.13.2 ${_Qt5HunspellInputMethod_FIND_VERSION_EXACT}
                ${_Qt5HunspellInputMethod_DEPENDENCIES_FIND_QUIET}
                ${_Qt5HunspellInputMethod_FIND_DEPENDENCIES_REQUIRED}
                PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT Qt5${_module_dep}_FOUND)
            set(Qt5HunspellInputMethod_FOUND False)
            return()
        endif()

        list(APPEND Qt5HunspellInputMethod_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND Qt5HunspellInputMethod_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND Qt5HunspellInputMethod_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND Qt5HunspellInputMethod_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND Qt5HunspellInputMethod_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES Qt5HunspellInputMethod_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5HunspellInputMethod_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt5HunspellInputMethod_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5HunspellInputMethod_COMPILE_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt5HunspellInputMethod_EXECUTABLE_COMPILE_FLAGS)

    set(_Qt5HunspellInputMethod_LIB_DEPENDENCIES "Qt5::VirtualKeyboard;Qt5::Gui;Qt5::Core")


    add_library(Qt5::HunspellInputMethod SHARED IMPORTED)

    set_property(TARGET Qt5::HunspellInputMethod PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt5HunspellInputMethod_OWN_INCLUDE_DIRS})
    set_property(TARGET Qt5::HunspellInputMethod PROPERTY
      INTERFACE_COMPILE_DEFINITIONS QT_HUNSPELLINPUTMETHOD_LIB)

    set_property(TARGET Qt5::HunspellInputMethod PROPERTY INTERFACE_QT_ENABLED_FEATURES )
    set_property(TARGET Qt5::HunspellInputMethod PROPERTY INTERFACE_QT_DISABLED_FEATURES )

    set(_Qt5HunspellInputMethod_PRIVATE_DIRS_EXIST TRUE)
    foreach (_Qt5HunspellInputMethod_PRIVATE_DIR ${Qt5HunspellInputMethod_OWN_PRIVATE_INCLUDE_DIRS})
        if (NOT EXISTS ${_Qt5HunspellInputMethod_PRIVATE_DIR})
            set(_Qt5HunspellInputMethod_PRIVATE_DIRS_EXIST FALSE)
        endif()
    endforeach()

    if (_Qt5HunspellInputMethod_PRIVATE_DIRS_EXIST)
        add_library(Qt5::HunspellInputMethodPrivate INTERFACE IMPORTED)
        set_property(TARGET Qt5::HunspellInputMethodPrivate PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES ${Qt5HunspellInputMethod_OWN_PRIVATE_INCLUDE_DIRS}
        )
        set(_Qt5HunspellInputMethod_PRIVATEDEPS)
        foreach(dep ${_Qt5HunspellInputMethod_LIB_DEPENDENCIES})
            if (TARGET ${dep}Private)
                list(APPEND _Qt5HunspellInputMethod_PRIVATEDEPS ${dep}Private)
            endif()
        endforeach()
        set_property(TARGET Qt5::HunspellInputMethodPrivate PROPERTY
            INTERFACE_LINK_LIBRARIES Qt5::HunspellInputMethod ${_Qt5HunspellInputMethod_PRIVATEDEPS}
        )
    endif()

    _populate_HunspellInputMethod_target_properties(RELEASE "libQt5HunspellInputMethod.so.0.0" "" FALSE)








_qt5_HunspellInputMethod_check_file_exists("${CMAKE_CURRENT_LIST_DIR}/Qt5HunspellInputMethodConfigVersion.cmake")

endif()
