/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class PeriodFormatterUtil {
    private static PeriodFormatter linuxUptimeStyle;
    private static PeriodFormatter standardUptimeStyle;
    private static PeriodType dayHourMinSecPeriodType;

    public static PeriodType getDayHourMinSecPeriodType() {
        return dayHourMinSecPeriodType;
    }

    public static Period createDayHourMinSecPeriod(long durationInMillis) {
        return new Period(durationInMillis).normalizedStandard(dayHourMinSecPeriodType);
    }

    public static PeriodFormatter getLinuxUptimeStyle() {
        return linuxUptimeStyle;
    }

    public static PeriodFormatter getStandardUptimeStyle() {
        return standardUptimeStyle;
    }

    public static String toLinuxUptimeStyleString(long durationInMillis) {
        return PeriodFormatterUtil.getLinuxUptimeStyle().print((ReadablePeriod)PeriodFormatterUtil.createDayHourMinSecPeriod(durationInMillis));
    }

    public static String toStandardUptimeStyleString(long durationInMillis) {
        return PeriodFormatterUtil.getStandardUptimeStyle().print((ReadablePeriod)PeriodFormatterUtil.createDayHourMinSecPeriod(durationInMillis));
    }

    static {
        dayHourMinSecPeriodType = PeriodType.standard().withYearsRemoved().withMonthsRemoved().withWeeksRemoved().withMillisRemoved();
        linuxUptimeStyle = new PeriodFormatterBuilder().printZeroAlways().appendDays().appendSuffix(" day", " days").appendSeparator(", ").minimumPrintedDigits(2).appendHours().appendSeparator(":").minimumPrintedDigits(2).appendMinutes().appendSeparator(":").minimumPrintedDigits(2).appendSeconds().toFormatter();
        standardUptimeStyle = new PeriodFormatterBuilder().printZeroAlways().appendDays().appendSuffix(" day ", " days ").appendHours().appendSuffix(" hours ").appendMinutes().appendSuffix(" mins ").appendSeconds().appendSuffix(" secs").toFormatter();
    }
}

