##########################################################################
# This file is part of Vacuum Magic
# Copyright (C) 2008 by UPi <upi at sourceforge.net>
##########################################################################

use strict;

my $Music = undef;
my $MusicFilename = undef;
my $MusicOn = 0;

my %MusicFilenames = (
  Menu      => 'celesfnt.s3m',
  GameOver  => 'jt_strng.xm',
  Boss      => 'r-light.xm',
  Level0    => '1352-nomorenoise.mod',
  Level1    => 'hymnof.xm',
  Level2    => 'featsofv.xm',
  Level3    => 'hein_-_sloom.mod',
  Level4    => 'hyper.mod',
  Level5    => 'kaos_och_dekadens.mod',
  Level6    => 'liam_the_lemming_-_chip2.s3m',
  Level7    => 'lizardking_-_airwolf.mod',
  Level8    => 'pinball.s3m',
  Level9    => 'deadlock.xm',
);


##########################################################################
# MUSIC
##########################################################################

sub SetMusic {
  my ($musicname) = @_;
  my ($physicalFilename);
  
  return  unless $Mixer;
  $physicalFilename = $MusicFilenames{$musicname};
  unless ($physicalFilename) {
    warn "SetMusic: Unable to find physical filename for logical filename $musicname!";
    $physicalFilename = $musicname;
  }
  _SetMusic("$DataDir/music/$physicalFilename");
}

sub _SetMusic {
  my ($filename) = @_;

  unless ($MusicEnabled) {
    $MusicFilename = $filename;
    return;
  }
  return  if ($MusicOn and $MusicFilename eq $filename);
  
  $Mixer->halt_music();
  $MusicFilename = $filename;
  my $newMusic = &_LoadMusic($MusicFilename);
  die "Unable to load $filename\n"  unless $newMusic;
  $Mixer->play_music($newMusic, -1);
  $MusicOn = 1;
  $Music = $newMusic;
}

sub FadeMusic {
  my ($time) = @_;
  
  return  unless $Mixer;
  return  unless $MusicEnabled and $MusicOn;
  $time = 1000 || $time;
  $Mixer->fade_out_music($time);
  $MusicOn = 0;
}

sub SetMusicEnabled {
  my $musicEnabled = shift;

  $MusicEnabled = $musicEnabled ? 1 : 0;
  return  unless $Mixer;
  if ( (not $MusicEnabled) and $Mixer->playing_music() ) {
    $Mixer->halt_music();
    $MusicOn = 0;
  }
  if ($MusicEnabled and not $Mixer->playing_music()) {
    if ($Music) {
      $Mixer->play_music($Music, -1);
      $MusicOn = 1;
    } elsif ($MusicFilename) {
      &_SetMusic($MusicFilename);
    }
  }
}

sub _LoadMusic {
  my ($filename) = @_;
  my ($result);
  
  return undef  unless -f $filename;
  $result = new SDL::Music($filename);
  
  return undef  unless $result;
  return $result  if $result->isa("SDL::Music"); # SDL_perl 2.*
  return undef  unless ref $result;
  return undef  unless $result->{-data};
  return $result;
}


##########################################################################
# SOUNDS
##########################################################################

sub LoadSounds {
  $Mixer = eval { SDL::Mixer->new(-frequency => 44100, -channels => 2, -size => 4096); };
  if ($@) {
    warn $@;
    return 0;
  }
  return  unless $Mixer;

  my ($soundName, $fileName);
  while (($soundName, $fileName) = each %Sounds) {
    die "Not found: $DataDir/$fileName"  unless -f "$DataDir/$fileName";
    $Sounds{$soundName} = new SDL::Sound("$DataDir/$fileName");
    die "Unable to load: $DataDir/$fileName"  unless $Sounds{$soundName};
  }
  print STDERR "Loaded sounds: ", join(',', sort keys %Sounds), "\n";
}

sub PlaySound {
  return  unless $SoundEnabled;
  return  unless $Mixer;
  my $sound = shift;
  return warn "No such sound: $sound"  unless $Sounds{$sound};
  $Mixer->play_channel(-1, $Sounds{$sound}, 0);
}

1;
