#ifdef SEMASTART
__SEMASTART = DIAG_START_SEMA,
#undef SEMASTART
#endif

DIAG(err_32_bit_builtin_64_bit_tgt, CLASS_ERROR, (unsigned)diag::Severity::Error, "this builtin is only available on 32-bit targets", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_64_bit_builtin_32_bit_tgt, CLASS_ERROR, (unsigned)diag::Severity::Error, "this builtin is only available on 64-bit targets", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_abi_tag_on_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot add 'abi_tag' attribute in a redeclaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_abstract_type_in_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{return|parameter|variable|field|instance variable|synthesized instance variable}0 type %1 is an abstract class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "%1 is a %select{private|protected}0 member of %3", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_base_ctor, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{base class|inherited virtual base class}0 %1 has %select{private|protected}3 %select{default |copy |move |*ERROR* |*ERROR* |*ERROR*|}2constructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_ctor, CLASS_ERROR, (unsigned)diag::Severity::Error, "calling a %select{private|protected}0 constructor of class %2", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "ISO C++11 does not allow access declarations; use using declarations instead", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_access_dtor, CLASS_ERROR, (unsigned)diag::Severity::Error, "calling a %select{private|protected}1 destructor of class %0", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_dtor_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "base class %0 has %select{private|protected}1 destructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_dtor_exception, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception object of type %0 has %select{private|protected}1 destructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_dtor_field, CLASS_ERROR, (unsigned)diag::Severity::Error, "field of type %1 has %select{private|protected}2 destructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_dtor_ivar, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable of type %0 has %select{private|protected}1 destructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_dtor_temp, CLASS_ERROR, (unsigned)diag::Severity::Error, "temporary of type %0 has %select{private|protected}1 destructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_dtor_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable of type %1 has %select{private|protected}2 destructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_dtor_vbase, CLASS_ERROR, (unsigned)diag::Severity::Error, "inherited virtual base class %1 has %select{private|protected}2 destructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_field_ctor, CLASS_ERROR, (unsigned)diag::Severity::Error, "field of type %0 has %select{private|protected}2 %select{default |copy |move |*ERROR* |*ERROR* |*ERROR* |}1constructor", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_friend_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend function %1 is a %select{private|protected}0 member of %3", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_access_lambda_capture, CLASS_ERROR, (unsigned)diag::Severity::Error, "capture of variable '%0' as type %1 calls %select{private|protected}3 %select{default |copy |move |*ERROR* |*ERROR* |*ERROR* |}2constructor", 0, SFINAE_AccessControl, false, true, 3)
DIAG(err_addr_ovl_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "address of overloaded function %0 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_addr_ovl_no_qualifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot form member pointer of type %0 without '&' and class name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_addr_ovl_no_viable, CLASS_ERROR, (unsigned)diag::Severity::Error, "address of overloaded function %0 does not match required type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_addr_ovl_not_func_ptrref, CLASS_ERROR, (unsigned)diag::Severity::Error, "address of overloaded function %0 cannot be converted to type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_address_of_function_with_pass_object_size_params, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot take address of function %0 because parameter %1 has pass_object_size attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_address_space_mismatch_templ_inst, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting address space qualifiers are provided between types %0 and %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_address_space_qualified_delete, CLASS_ERROR, (unsigned)diag::Severity::Error, "'delete' cannot delete objects of type %0 in address space '%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_address_space_qualified_new, CLASS_ERROR, (unsigned)diag::Severity::Error, "'new' cannot allocate objects of type %0 in address space '%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_addrof_function_constraints_not_satisfied, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot take address of function %0 because its constraints are not satisfied", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_addrof_function_disabled_by_enable_if_attr, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot take address of function %0 because it has one or more non-tautological enable_if conditions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alias_after_tentative, CLASS_ERROR, (unsigned)diag::Severity::Error, "alias definition of %0 after tentative definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alias_is_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition %0 cannot also be an %select{alias|ifunc}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alias_not_supported_on_darwin, CLASS_ERROR, (unsigned)diag::Severity::Error, "aliases are not supported on darwin", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alias_not_supported_on_nvptx, CLASS_ERROR, (unsigned)diag::Severity::Error, "CUDA does not support aliases", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alias_template_extra_headers, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous template parameter list in alias template declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_align_value_attribute_argument_not_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "'align_value' attribute requires integer constant", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignas_attribute_wrong_decl_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be applied to a %select{function parameter|variable with 'register' storage class|'catch' variable|bit-field}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignas_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration has different alignment requirement (%1 vs %0)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignas_missing_on_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 must be specified on definition if it is specified on any declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignas_underaligned, CLASS_ERROR, (unsigned)diag::Severity::Error, "requested alignment is less than minimum alignment of %1 for type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_aligned_allocation_unavailable, CLASS_ERROR, (unsigned)diag::Severity::Error, "aligned %select{allocation|deallocation}0 function of type '%1' is only available on %2 %3 or newer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_aligned_attribute_argument_not_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "'aligned' attribute requires integer constant", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignment_dependent_typedef_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "requested alignment is dependent but declaration is not dependent", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignment_not_power_of_two, CLASS_ERROR, (unsigned)diag::Severity::Error, "requested alignment is not a power of 2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignment_too_big, CLASS_ERROR, (unsigned)diag::Severity::Error, "requested alignment must be %0 or smaller", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignment_too_small, CLASS_ERROR, (unsigned)diag::Severity::Error, "requested alignment must be %0 or greater", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_alignof_member_of_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid application of 'alignof' to a field of a class still being defined", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_allocation_of_abstract_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "allocating an object of abstract class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_altivec_empty_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_base_to_derived_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous cast from base %0 to derived %1:%2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_delete_operand, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous conversion of delete expression of type %0 to a pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_derived_to_base_conv, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous conversion from derived class %0 to base class %1:%2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_inherited_constructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "constructor of %0 inherited from multiple base class subobjects", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_member_multiple_subobject_types, CLASS_ERROR, (unsigned)diag::Severity::Error, "member %0 found in multiple base classes of different types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_member_multiple_subobjects, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-static member %0 found in multiple base-class subobjects of type %1:%2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_memptr_conv, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous conversion from pointer to member of %select{base|derived}0 class %1 to pointer to member of %select{derived|base}0 class %2:%3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to %0 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_suitable_delete_member_function_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple suitable %0 functions in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ambiguous_tag_hiding, CLASS_ERROR, (unsigned)diag::Severity::Error, "a type named %0 is hidden by a declaration in a different namespace", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anon_bitfield_has_negative_width, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous bit-field has negative width (%0)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anon_bitfield_qualifiers, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous bit-field cannot have qualifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anon_bitfield_width_exceeds_type_width, CLASS_ERROR, (unsigned)diag::Severity::Error, "width of anonymous bit-field (%0 bits) exceeds %select{width|size}1 of its type (%2 bit%s2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous property is not supported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_record_bad_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous %select{struct|union}0 can only contain non-static data members", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_record_member_redecl, CLASS_ERROR, (unsigned)diag::Severity::Error, "member of anonymous %select{struct|union}0 redeclares %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_record_nonpublic_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous %select{struct|union}0 cannot contain a %select{private|protected}1 data member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_record_with_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "functions cannot be declared in an anonymous %select{struct|union}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_record_with_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "static members cannot be declared in an anonymous %select{struct|union}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_record_with_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "types cannot be declared in an anonymous %select{struct|union}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_struct_not_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous %select{structs|structs and classes}0 must be %select{struct or union|class}0 members", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_union_not_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous unions at namespace or global scope must be declared 'static'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anonymous_union_with_storage_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous union at class scope must not have a storage specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anyx86_interrupt_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{x86|x86-64}0 'interrupt' attribute only applies to functions that have %select{a 'void' return type|only a pointer parameter optionally followed by an integer parameter|a pointer as the first parameter|a %2 type as the second parameter}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_anyx86_interrupt_called, CLASS_ERROR, (unsigned)diag::Severity::Error, "interrupt service routine cannot be called directly", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_arc_array_param_no_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "must explicitly describe intended ownership of an object array parameter", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_assign_property_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "existing instance variable %1 for property %0 with %select{unsafe_unretained|assign}2 attribute must be __unsafe_unretained", 0, SFINAE_SubstitutionFailure, false, true, 6)
DIAG(err_arc_atomic_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot perform atomic operation on a pointer to type %0: type has non-trivial ownership", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_autoreleasing_capture, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot capture __autoreleasing variable in a %select{block|lambda by copy}0", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_autoreleasing_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{__block variables|global variables|fields|instance variables}0 cannot have __autoreleasing ownership", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_bridge_cast_incompatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "incompatible types casting %0 to %1 with a %select{__bridge|__bridge_transfer|__bridge_retained}2 cast", 0, SFINAE_SubstitutionFailure, false, true, 7)
DIAG(err_arc_bridge_cast_wrong_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "cast of %select{Objective-C|block|C}0 pointer type %1 to %select{Objective-C|block|C}2 pointer type %3 cannot use %select{__bridge|__bridge_transfer|__bridge_retained}4", 0, SFINAE_SubstitutionFailure, false, true, 7)
DIAG(err_arc_cast_requires_bridge, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{cast|implicit conversion}0 of %select{Objective-C|block|C}1 pointer type %2 to %select{Objective-C|block|C}3 pointer type %4 requires a bridged cast", 0, SFINAE_SubstitutionFailure, false, true, 7)
DIAG(err_arc_collection_forward, CLASS_ERROR, (unsigned)diag::Severity::Error, "collection expression type %0 is a forward declaration", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_convesion_of_weak_unavailable, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{implicit conversion|cast}0 of weak-unavailable object of type %1 to a __weak object of type %2", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_arc_gained_method_convention, CLASS_ERROR, (unsigned)diag::Severity::Error, "method implementation does not match its declaration", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_illegal_explicit_message, CLASS_ERROR, (unsigned)diag::Severity::Error, "ARC forbids explicit message send of %0", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_arc_illegal_method_def, CLASS_ERROR, (unsigned)diag::Severity::Error, "ARC forbids %select{implementation|synthesis}0 of %1", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_arc_illegal_selector, CLASS_ERROR, (unsigned)diag::Severity::Error, "ARC forbids use of %0 in a @selector", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_arc_inconsistent_property_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|unsafe_unretained|strong|weak}1 property %0 may not also be declared %select{|__unsafe_unretained|__strong|__weak|__autoreleasing}2", 0, SFINAE_SubstitutionFailure, false, true, 6)
DIAG(err_arc_indirect_no_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{pointer|reference}1 to non-const type %0 with no explicit ownership", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_init_method_unrelated_result_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "init methods must return a type related to the receiver type", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_lost_method_convention, CLASS_ERROR, (unsigned)diag::Severity::Error, "method was declared as %select{an 'alloc'|a 'copy'|an 'init'|a 'new'}0 method, but its implementation doesn't match because %select{its result type is not an object pointer|its result type is unrelated to its receiver type}1", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_may_not_respond, CLASS_ERROR, (unsigned)diag::Severity::Error, "no visible @interface for %0 declares the selector %1", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_method_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "no known %select{instance|class}1 method for selector %0", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_mismatched_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{implicit conversion|cast}0 of %select{%2|a non-Objective-C pointer type %2|a block pointer|an Objective-C pointer|an indirect pointer to an Objective-C pointer}1 to %3 is disallowed with ARC", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_arc_multiple_method_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple methods named %0 found with mismatched result, parameter type or attributes", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_new_array_without_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "'new' cannot allocate an array of %0 with no explicit ownership", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_nolifetime_behavior, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit ownership qualifier on cast result has no effect", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_arc_nonlocal_writeback, CLASS_ERROR, (unsigned)diag::Severity::Error, "passing address of %select{non-local|non-scalar}0 object to __autoreleasing parameter for write-back", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_objc_property_default_assign_on_object, CLASS_ERROR, (unsigned)diag::Severity::Error, "ARC forbids synthesizing a property of an Objective-C object with unspecified ownership or storage attribute", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_arc_perform_selector_retains, CLASS_ERROR, (unsigned)diag::Severity::Error, "performSelector names a selector which retains the object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_arc_pseudo_dtor_inconstant_quals, CLASS_ERROR, (unsigned)diag::Severity::Error, "pseudo-destructor destroys object of type %0 with inconsistently-qualified type %1", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_receiver_forward_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "receiver %0 for class message is a forward declaration", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_receiver_forward_instance, CLASS_ERROR, (unsigned)diag::Severity::Error, "receiver type %0 for instance message is a forward declaration", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_strong_property_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "existing instance variable %1 for strong property %0 may not be %select{|__unsafe_unretained||__weak}2", 0, SFINAE_SubstitutionFailure, false, true, 6)
DIAG(err_arc_thread_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "thread-local variable has non-trivial ownership: type is %0", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_arc_typecheck_convert_incompatible_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "incompatible pointer types passing retainable parameter of type %0to a CF function expecting %1 type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_arc_unsupported_weak_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "class is incompatible with __weak references", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_arc_unused_init_message, CLASS_ERROR, (unsigned)diag::Severity::Error, "the result of a delegate init call must be immediately returned or assigned to 'self'", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_arc_weak_disabled, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot create __weak reference in file using manual reference counting", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_arc_weak_ivar_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "dereferencing a __weak pointer is not allowed due to possible null value caused by race condition, assign it to strong variable first", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_arc_weak_no_runtime, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot create __weak reference because the current deployment target does not support weak references", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_arc_weak_unavailable_assign, CLASS_ERROR, (unsigned)diag::Severity::Error, "assignment of a weak-unavailable object to a __weak object", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_arc_weak_unavailable_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "synthesizing __weak instance variable of type %0, which does not support weak references", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_arg_with_address_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter may not be qualified with an address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_argument_invalid_range, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument value %0 is outside the valid range [%1, %2]", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_argument_not_multiple, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument should be a multiple of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_argument_not_power_of_2, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument should be a power of 2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_argument_not_shifted_byte, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument should be an 8-bit value shifted by a multiple of 8 bits", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_argument_not_shifted_byte_or_xxff, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument should be an 8-bit value shifted by a multiple of 8 bits, or in the form 0x??FF", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_arithmetic_nonfragile_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "arithmetic on pointer to interface %0, which is not a constant size for this architecture and platform", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_arm_invalid_specialreg, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid special register for builtin", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_designator_empty_range, CLASS_ERROR, (unsigned)diag::Severity::Error, "array designator range [%0, %1] is empty", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_designator_negative, CLASS_ERROR, (unsigned)diag::Severity::Error, "array designator value '%0' is negative", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_designator_non_array, CLASS_ERROR, (unsigned)diag::Severity::Error, "array designator cannot initialize non-array type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_designator_too_large, CLASS_ERROR, (unsigned)diag::Severity::Error, "array designator index (%0) exceeds array bounds (%1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_different_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot initialize array %diff{of type $ with array of type $|with different type of array}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_incompat_wide_string_into_wchar, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializing wide char array with incompatible wide string literal", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_narrow_string_into_wchar, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializing wide char array with non-wide string literal", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_non_constant_array, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot initialize array %diff{of type $ with non-constant array of type $|with different type of array}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_not_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "array initializer must be an initializer list%select{| or string literal| or wide string literal}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_plain_string_into_char8_t, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializing 'char8_t' array with plain string literal", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_utf8_string_into_char, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|ISO C++20 does not permit }0initialization of char array with UTF-8 string literal%select{ is not permitted by '-fchar8_t'|}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_init_wide_string_into_char, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializing char array with wide string literal", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_new_needs_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "array size must be specified in new expression with no initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_of_abstract_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "array of abstract class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_section_does_not_specify_contiguous_storage, CLASS_ERROR, (unsigned)diag::Severity::Error, "array section does not specify contiguous storage", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_array_size_ambiguous_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous conversion of array size expression of type %0 to an integral or enumeration type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_size_explicit_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "array size expression of type %0 requires explicit conversion to type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_size_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "array size expression has incomplete class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_size_non_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "size of array has non-integer type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_size_not_integral, CLASS_ERROR, (unsigned)diag::Severity::Error, "array size expression must have integral or %select{|unscoped }0enumeration type, not %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_star_in_function_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable length array must be bound in function definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_star_outside_prototype, CLASS_ERROR, (unsigned)diag::Severity::Error, "star modifier used outside of function prototype", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_static_not_outermost, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 used in non-outermost array type derivation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_static_outside_prototype, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 used in array declarator outside of function prototype", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_array_too_large, CLASS_ERROR, (unsigned)diag::Severity::Error, "array is too large (%0 elements)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_as_qualified_auto_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "automatic variable qualified with an%select{| invalid}0 address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_asm_bad_register_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "bad type for named register variable", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "asm operand has incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_input_duplicate_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "more than one input constraint matches the same output '%0'", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_invalid_global_var_reg, CLASS_ERROR, (unsigned)diag::Severity::Error, "register '%0' unsuitable for global register variables on this target", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_invalid_input_constraint, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid input constraint '%0' in asm", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_invalid_input_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid input size for constraint '%0'", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_invalid_lvalue_in_input, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid lvalue in asm input for constraint '%0'", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_invalid_lvalue_in_output, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid lvalue in asm output", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_invalid_output_constraint, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid output constraint '%0' in asm", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_invalid_output_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid output size for constraint '%0'", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_naked_parm_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter references not allowed in naked functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_asm_naked_this_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "'this' pointer references not allowed in naked functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_asm_non_addr_value_in_memory_constraint, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to a %select{bit-field|vector element|global register variable}0 in asm %select{input|output}1 with a memory constraint '%2'", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_register_size_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "size of register '%0' does not match variable size", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_tying_incompatible_types, CLASS_ERROR, (unsigned)diag::Severity::Error, "unsupported inline asm: input with type %diff{$ matching output with type $|}0,1", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_unexpected_constraint_alternatives, CLASS_ERROR, (unsigned)diag::Severity::Error, "asm constraint has an unexpected number of alternatives: %0 vs %1", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_unknown_register_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown register name '%0' in asm", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_assoc_compatible_types, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 in generic association compatible with previously specified type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_assoc_type_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 in generic association incomplete", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_assoc_type_nonobject, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 in generic association not an object type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_assoc_type_variably_modified, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 in generic association is a variably modified type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atdef_nonfragile_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of @defs is not supported on this architecture and platform", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_builtin_cannot_be_const, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic builtin cannot be const-qualified (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_builtin_must_be_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic builtin must be a pointer (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_builtin_must_be_pointer_intfltptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic builtin must be a pointer to integer, floating-point or pointer (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_builtin_must_be_pointer_intptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic builtin must be a pointer to integer or pointer (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_builtin_pointer_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic builtin must be a pointer to 1,2,4,8 or 16 byte type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_exclusive_builtin_pointer_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to load or store exclusive builtin must be a pointer to 1,2,4 or 8 byte type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_load_store_uses_lib, CLASS_ERROR, (unsigned)diag::Severity::Error, "atomic %select{load|store}0 requires runtime support that is not available for this target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_op_has_invalid_synch_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "synchronization scope argument to atomic operation is invalid", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_op_needs_atomic, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic operation must be a pointer to _Atomic type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_op_needs_atomic_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic operation must be a pointer to %select{|atomic }0integer (%1 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_op_needs_atomic_int_or_ptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic operation must be a pointer to %select{|atomic }0integer or pointer (%1 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_op_needs_non_const_atomic, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic operation must be a pointer to non-%select{const|constant}0 _Atomic type (%1 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_op_needs_non_const_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic operation must be a pointer to non-const type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_op_needs_trivial_copy, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to atomic operation must be a pointer to a trivially-copyable type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_property_nontrivial_assign_op, CLASS_ERROR, (unsigned)diag::Severity::Error, "atomic property of reference type %0 cannot have non-trivial assignment operator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atomic_specifier_bad_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "_Atomic cannot be applied to %select{incomplete |array |function |reference |atomic |qualified |}0type %1 %select{||||||which is not trivially copyable}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_atprotocol_protocol, CLASS_ERROR, (unsigned)diag::Severity::Error, "@protocol is using a forward protocol declaration of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attr_cond_never_constant_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute expression never produces a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attr_objc_ownership_redundant, CLASS_ERROR, (unsigned)diag::Severity::Error, "the type %0 is already explicitly ownership-qualified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attr_tlsmodel_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "tls_model must be \"global-dynamic\", \"local-dynamic\", \"initial-exec\" or \"local-exec\"", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_address_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "function type may not be qualified with an address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_address_multiple_qualifiers, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple address spaces specified for type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_address_space_negative, CLASS_ERROR, (unsigned)diag::Severity::Error, "address space is negative", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_address_space_too_high, CLASS_ERROR, (unsigned)diag::Severity::Error, "address space is larger than the maximum supported (%0)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_aligned_too_great, CLASS_ERROR, (unsigned)diag::Severity::Error, "requested alignment must be %0 bytes or smaller", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_argument_invalid, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute argument is invalid: %select{max must be 0 since min is 0|min must not be greater than max}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_argument_is_zero, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute must be greater than 0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_argument_n_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute requires parameter %1 to be %select{int or bool|an integer constant|a string|an identifier}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_argument_out_of_bounds, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute parameter %1 is out of bounds", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_argument_out_of_bounds_extra_info, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute parameter %1 is out of bounds: %plural{0:no parameters to index into|1:can only be 1, since there is one parameter|:must be between 1 and %2}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_argument_out_of_range, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute requires integer constant between %1 and %2 inclusive", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_argument_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute requires %select{int or bool|an integer constant|a string|an identifier}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_arm_mve_alias, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__clang_arm_mve_alias' attribute can only be applied to an ARM MVE builtin", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_bad_neon_vector_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "Neon vector size must be 64 or 128 bits", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_cleanup_arg_not_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'cleanup' argument %select{|%1 |%1 }0is not a %select{||single }0function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_cleanup_func_arg_incompatible_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "'cleanup' function %0 parameter has %diff{type $ which is incompatible with type $|incompatible type}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_cleanup_func_must_take_one_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "'cleanup' function %0 must take 1 parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dll_ambiguous_default_ctor, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__declspec(dllexport)' cannot be applied to more than one default constructor in %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dll_deleted, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %q0 cannot be applied to a deleted function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dll_lambda, CLASS_ERROR, (unsigned)diag::Severity::Error, "lambda cannot be declared %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dll_member_of_dll_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %q0 cannot be applied to member of %q1 class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dll_not_extern, CLASS_ERROR, (unsigned)diag::Severity::Error, "%q0 must have external linkage when declared %q1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dll_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration of %q0 cannot add %q1 attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dll_thread_local, CLASS_ERROR, (unsigned)diag::Severity::Error, "%q0 cannot be thread local when declared %q1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dllimport_data_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of dllimport data", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dllimport_function_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "dllimport cannot be applied to non-inline function definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_dllimport_static_field_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of dllimport static field not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_integers_only, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute argument may only refer to a function parameter of integer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_invalid_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{a reference type|an array type|a non-vector or non-vectorizable scalar type}0 is an invalid argument to attribute %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_invalid_implicit_this_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute is invalid for the implicit this argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_invalid_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector size not an integral multiple of component size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_invalid_vector_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid vector element type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_multiple_objc_gc, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple garbage collection attributes specified for type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_no_builtin_on_defaulted_deleted_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute has no effect on defaulted or deleted functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_no_builtin_on_non_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute is permitted on definitions only", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_no_builtin_wildcard_or_builtin_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "empty %0 cannot be composed with named ones", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_no_member_pointers, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be used with pointers to members", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_not_supported_in_lang, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute is not supported in %select{C|C++|Objective-C}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_not_supported_on_arch, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute is not supported on '%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_only_once_per_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute can only be applied once per parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_output_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute only applies to output parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_overloadable_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration of %0 must %select{not |}1have the 'overloadable' attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_overloadable_multiple_unmarked_overloads, CLASS_ERROR, (unsigned)diag::Severity::Error, "at most one overload for a given name may lack the 'overloadable' attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_overloadable_no_prototype, CLASS_ERROR, (unsigned)diag::Severity::Error, "'overloadable' function %0 must have a prototype", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_pointers_only, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute only applies to%select{| constant}1 pointer arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_regparm_invalid_number, CLASS_ERROR, (unsigned)diag::Severity::Error, "'regparm' parameter must be between 0 and %0 inclusive", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_regparm_wrong_platform, CLASS_ERROR, (unsigned)diag::Severity::Error, "'regparm' is not valid on this platform", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_requires_opencl_version, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute requires OpenCL version %1%select{| or above}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_requires_positive_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute requires a %select{positive|non-negative}1 integral compile time constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_section_invalid_for_target, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument to %select{'code_seg'|'section'}1 attribute is not valid for this target: %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_selectany_non_extern_data, CLASS_ERROR, (unsigned)diag::Severity::Error, "'selectany' can only be applied to data items with external linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_sentinel_less_than_zero, CLASS_ERROR, (unsigned)diag::Severity::Error, "'sentinel' parameter 1 less than zero", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_sentinel_not_zero_or_one, CLASS_ERROR, (unsigned)diag::Severity::Error, "'sentinel' parameter 2 not 0 or 1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_size_too_large, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector size too large", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_too_few_arguments, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute takes at least %1 argument%s1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_too_many_arguments, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute takes no more than %1 argument%s1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute is not supported for this target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_vecreturn_only_pod_record, CLASS_ERROR, (unsigned)diag::Severity::Error, "the vecreturn attribute can only be used on a POD (plain old data) class or structure (i.e. no virtual functions)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_vecreturn_only_vector_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "the vecreturn attribute can only be used on a class or structure with one member, which must be a vector", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_weak_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "weak declaration cannot have internal linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_weakref_not_global_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "weakref declaration of %0 must be in a global context", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_weakref_not_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "weakref declaration must have internal linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_weakref_without_alias, CLASS_ERROR, (unsigned)diag::Severity::Error, "weakref declaration of %0 must also have an alias attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_wrong_decl_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute only applies to %select{functions|unions|variables and functions|functions and methods|functions, methods and blocks|functions, methods, and parameters|variables|variables and fields|variables, data members and tag types|types and namespaces|variables, functions and classes|kernel functions|non-K&R-style functions}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_wrong_decl_type_str, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute only applies to %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_wrong_number_arguments, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute %plural{0:takes no arguments|1:takes one argument|:requires exactly %1 arguments}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attribute_zero_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "zero vector size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_attributes_are_not_compatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 and %1 attributes are not compatible", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot pass bit-field as __auto_type initializer in C", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_different_deductions, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{'auto'|'decltype(auto)'|'__auto_type'|template arguments}0 deduced as %1 in declaration of %2 and deduced as %3 in declaration of %4", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_fn_deduction_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce return type %0 from returned value of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_fn_different_deductions, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%select{auto|decltype(auto)}0' in return type deduced as %1 here but deduced as %2 in earlier return statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_fn_no_return_but_not_auto, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce return type %0 for function with no return statements", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_fn_return_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce return type from initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_fn_return_void_but_not_auto, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce return type %0 from omitted return expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_fn_used_before_defined, CLASS_ERROR, (unsigned)diag::Severity::Error, "function %0 with deduced return type cannot be used before it is defined", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_fn_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "function with deduced return type cannot be virtual", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_inconsistent_deduction, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduced conflicting types %diff{($ vs $) |}0,1for initializer list element type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_init_list_from_c, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use __auto_type with initializer list in C", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_missing_trailing_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "'auto' return without trailing return type; deduced return types are a C++14 extension", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_new_ctor_multiple_expressions, CLASS_ERROR, (unsigned)diag::Severity::Error, "new expression for type %0 contains multiple constructor arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_new_deduction_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "new expression for type %0 has incompatible constructor argument of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_new_requires_ctor_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "new expression for type %0 requires a constructor argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_non_deduced_not_alone, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{function with deduced return type|declaration with trailing return type}0 must be the only declaration in its group", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_not_allowed, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{'auto'|'decltype(auto)'|'__auto_type'|use of %select{class template|function template|variable template|alias template|template template parameter|concept|template}2 %3 requires template arguments; argument deduction}0 not allowed %select{in function prototype|in non-static struct member|in struct member|in non-static union member|in union member|in non-static class member|in interface member|in exception declaration|in template parameter until C++17|in block literal|in template argument|in typedef|in type alias|in function return type|in conversion function type|here|in lambda parameter|in type allocated by 'new'|in K&R-style function parameter|in template parameter|in friend declaration|in function prototype that is not a function declaration|in requires expression parameter}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_not_allowed_var_inst, CLASS_ERROR, (unsigned)diag::Severity::Error, "'auto' variable template instantiation is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_var_deduction_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 with type %1 has incompatible initializer of type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_var_deduction_failure_from_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce actual type for variable %0 with type %1 from initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_var_init_multiple_expressions, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer for variable %0 with type %1 contains multiple expressions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_var_init_no_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer for variable %0 with type %1 is empty", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_var_init_paren_braces, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce type for variable %1 with type %2 from %select{parenthesized|nested}0 initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_var_requires_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of variable %0 with deduced type %1 requires an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_auto_variable_cannot_appear_in_own_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 declared with deduced type %1 cannot appear in its own initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_await_suspend_invalid_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of 'await_suspend' is required to be 'void' or 'bool' (have %0)", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_bad_cast_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is an incomplete type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_category_property_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "property implementation must have its declaration in the category %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_const_cast_dest, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{const_cast||||C-style cast|functional-style cast}0 to %2, which is not a reference, pointer-to-object, or pointer-to-data-member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cstyle_cast_overload, CLASS_ERROR, (unsigned)diag::Severity::Error, "address of overloaded function %0 cannot be cast to type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_addr_space_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 converts between mismatching address spaces", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from bit-field lvalue to reference type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_generic, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_member_pointer_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot %select{||reinterpret_cast||C-style cast|}0 from member pointer type %1 to member pointer type %2 of different size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_qualifiers_away, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 casts away qualifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_rvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from rvalue to reference type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_scalar_to_vector_different_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{||reinterpret_cast||C-style cast|}0 from scalar %1 to vector %2 of different size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_unrelated_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2, which are not related by inheritance, is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_vector_to_scalar_different_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{||reinterpret_cast||C-style cast|}0 from vector %1 to scalar %2 of different size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_cxx_cast_vector_to_vector_different_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{||reinterpret_cast||C-style cast|}0 from vector %1 to vector %2 of different size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_dynamic_cast_not_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not a class type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_dynamic_cast_not_polymorphic, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not polymorphic", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_dynamic_cast_not_ptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use dynamic_cast to convert from %0 to %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_dynamic_cast_not_ref_or_ptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid target type %0 for dynamic_cast; target type must be a reference or pointer type to a defined class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_kernel_param_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be used as the type of a kernel parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_lvalue_to_rvalue_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast from lvalue of type %1 to rvalue reference type %2; types are not compatible", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_memptr_lhs, CLASS_ERROR, (unsigned)diag::Severity::Error, "left hand operand to %0 must be a %select{|pointer to }1class compatible with the right hand operand, but is %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_memptr_rhs, CLASS_ERROR, (unsigned)diag::Severity::Error, "right hand operand to %0 has non-pointer-to-member type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_multiversion_option, CLASS_ERROR, (unsigned)diag::Severity::Error, "function multiversioning doesn't support %select{feature|architecture}0 '%1'", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_bad_new_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot allocate %select{function|reference}1 type %0 with new", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_parameter_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be the name of a parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_parameter_name_template_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter name cannot have template arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_property_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "property implementation must be in a class or category implementation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_property_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "property implementation must have its declaration in interface %0 or one of its extensions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_receiver_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "bad receiver type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_reinterpret_cast_overload, CLASS_ERROR, (unsigned)diag::Severity::Error, "reinterpret_cast cannot resolve overloaded function %0 to type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_reinterpret_cast_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "reinterpret_cast of a %0 to %1 needs its address, which is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_reinterpret_cast_small_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "cast from pointer to smaller type %2 loses information", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_rvalue_to_rvalue_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast from rvalue of type %1 to rvalue reference type %2; types are not compatible", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_static_cast_member_pointer_nonmp, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast from type %1 to member pointer type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_static_cast_overload, CLASS_ERROR, (unsigned)diag::Severity::Error, "address of overloaded function %0 cannot be static_cast to type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_static_cast_pointer_nonpointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast from type %1 to pointer type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bad_variable_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be the name of a variable or data member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_base_class_has_flexible_array_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "base class %0 has a flexible array member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_base_clause_on_union, CLASS_ERROR, (unsigned)diag::Severity::Error, "unions cannot have base classes", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_base_init_direct_and_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "base class initializer %0 names both a direct base class and an inherited virtual base class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_base_init_does_not_name_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "constructor initializer %0 does not name a class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_base_must_be_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "base specifier must name a class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_base_specifier_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be applied to a base specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_binding_cannot_appear_in_own_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "binding %0 cannot appear in the initializer of its own decomposition declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bit_cast_non_trivially_copyable, CLASS_ERROR, (unsigned)diag::Severity::Error, "__builtin_bit_cast %select{source|destination}0 type must be trivially copyable", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_bit_cast_type_size_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "__builtin_bit_cast source size does not equal destination size (%0 vs %1)", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_bitfield_has_negative_width, CLASS_ERROR, (unsigned)diag::Severity::Error, "bit-field %0 has negative width (%1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bitfield_has_zero_width, CLASS_ERROR, (unsigned)diag::Severity::Error, "named bit-field %0 has zero width", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bitfield_width_exceeds_type_width, CLASS_ERROR, (unsigned)diag::Severity::Error, "width of bit-field %0 (%1 bits) exceeds %select{width|size}2 of its type (%3 bit%s3)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_block_decl_ref_not_modifiable_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable is not assignable (missing __block type specifier)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_block_extern_cant_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "'extern' variable cannot have an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_block_on_nonlocal, CLASS_ERROR, (unsigned)diag::Severity::Error, "__block attribute not allowed, only allowed on local variables", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_block_on_vm, CLASS_ERROR, (unsigned)diag::Severity::Error, "__block attribute not allowed on declaration with a variably modified type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_block_return_missing_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-void block should return a value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_block_returning_array_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "block cannot return %select{array|function}0 type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_blocks_disable, CLASS_ERROR, (unsigned)diag::Severity::Error, "blocks support disabled - compile with -fblocks or %select{pick a deployment target that supports them|for OpenCL 2.0}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_bound_member_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to non-static member function must be called%select{|; did you mean to call it with no arguments?}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_box_literal_collection, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{string|character|boolean|numeric}0 literal must be prefixed by '@' in a collection", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_break_not_in_loop_or_switch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'break' statement not in loop or switch statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_annotation_first_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to __builtin_annotation must be an integer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_annotation_second_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "second argument to __builtin_annotation must be a non-wide string constant", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of builtin function %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_fn_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "builtin functions must be directly called", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_func_cast_more_than_one_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "function-style cast to a builtin type can only take one argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_launder_invalid_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-pointer|function pointer|void pointer}0 argument to '__builtin_launder' is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_builtin_longjmp_invalid_val, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument to __builtin_longjmp must be a constant 1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_longjmp_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "__builtin_longjmp is not supported for the current target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_operator_new_delete_not_usual, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to '%select{__builtin_operator_new|__builtin_operator_delete}0' selects non-usual %select{allocation|deallocation}0 function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_redeclare, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot redeclare builtin function %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_requires_language, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' is only available in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_setjmp_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "__builtin_setjmp is not supported for the current target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_target_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "builtin is not supported on this target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_builtin_x64_aarch64_only, CLASS_ERROR, (unsigned)diag::Severity::Error, "this builtin is only available on x86-64 and aarch64 targets", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_c99_array_usage_cxx, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{qualifier in |static |}0array size %select{||'[*] '}0is a C99 feature, not permitted in C++", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_call_function_incomplete_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "calling %0 with incomplete return type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_call_incomplete_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument type %0 is incomplete", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_call_incomplete_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "calling function with incomplete return type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_callback_attribute_argument_unknown, CLASS_ERROR, (unsigned)diag::Severity::Error, "'callback' attribute argument %0 is not a known function parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_callback_attribute_invalid_callee, CLASS_ERROR, (unsigned)diag::Severity::Error, "'callback' attribute specifies invalid callback callee", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_callback_attribute_multiple, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple 'callback' attributes specified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_callback_attribute_no_callee, CLASS_ERROR, (unsigned)diag::Severity::Error, "'callback' attribute specifies no callback callee", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_callback_callee_is_variadic, CLASS_ERROR, (unsigned)diag::Severity::Error, "'callback' attribute callee may not be variadic", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_callback_callee_no_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "'callback' attribute callee does not have function type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_callback_implicit_this_not_available, CLASS_ERROR, (unsigned)diag::Severity::Error, "'callback' argument at position %0 references unavailable implicit 'this'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cannot_find_suitable_accessor, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find suitable %select{getter|setter}0 for property %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cannot_form_pointer_to_member_of_reference_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot form a pointer-to-member to member %0 of reference type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cannot_pass_non_trivial_c_struct_to_vararg, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot pass non-trivial C object of type %0 by value to variadic %select{function|block|method|constructor}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cannot_pass_objc_interface_to_vararg, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot pass object with interface type %0 by value through variadic %select{function|block|method|constructor}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cannot_pass_objc_interface_to_vararg_format, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot pass object with interface type %1 by value to variadic %select{function|block|method|constructor}2; expected type from format string was %3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cannot_pass_to_vararg, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot pass %select{expression of type %1|initializer list}0 to variadic %select{function|block|method|constructor}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cannot_pass_to_vararg_format, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot pass %select{expression of type %1|initializer list}0 to variadic %select{function|block|method|constructor}2; expected type from format string was %3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_capture_block_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "__block variable %0 cannot be captured in a %select{lambda expression|captured statement}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_capture_default_non_local, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-local lambda expression cannot have a capture-default", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_capture_does_not_name_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 in capture list does not name a variable", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_capture_more_than_once, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 can appear only once in a capture list", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_capture_non_automatic_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be captured because it does not have automatic storage duration", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_capture_of_abstract_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "by-copy capture of value of abstract type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_capture_of_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "by-copy capture of variable %0 with incomplete type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_carries_dependency_missing_on_first_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{function|parameter}0 declared '[[carries_dependency]]' after its first declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_carries_dependency_param_not_function_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "'[[carries_dependency]]' attribute only allowed on parameter in a function declaration or lambda", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_case_not_in_switch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'case' statement not in switch statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cast_pointer_from_non_pointer_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "operand of type %0 cannot be cast to a pointer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cast_pointer_to_non_pointer_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "pointer cannot be cast to type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cast_selector_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot type cast @selector expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_catch_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot catch incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_catch_incomplete_ptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot catch pointer to incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_catch_incomplete_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot catch reference to incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_catch_param_not_objc_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "@catch parameter is not a pointer to an interface type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_catch_rvalue_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot catch exceptions by rvalue reference", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_catch_variably_modified, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot catch variably modified type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_category_forward_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot define %select{category|class extension}0 for undefined class %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_category_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "property declared in category %0 cannot be implemented in class implementation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cconv_change, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declared '%0' here was previously declared %select{'%2'|without calling convention}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cconv_incomplete_param_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter %0 must have a complete type to use function %1 with the %2 calling convention", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cconv_knr, CLASS_ERROR, (unsigned)diag::Severity::Error, "function with no prototype cannot use the %0 calling convention", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cconv_varargs, CLASS_ERROR, (unsigned)diag::Severity::Error, "variadic function cannot use %0 calling convention", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cfstring_literal_not_string_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "CFString literal is not a string constant", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_circular_inheritance, CLASS_ERROR, (unsigned)diag::Severity::Error, "circular inheritance between %0 and %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_class_extension_after_impl, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot declare class extension for %0 after class implementation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_class_marked_final_used_as_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "base %0 is marked '%select{final|sealed}1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_class_property_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 is a class property; did you mean to access it with class '%1'?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_class_redeclared_with_different_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 redeclared with '%1' access", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_class_stub_subclassing_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'objc_class_stub' attribute cannot be specified on a class that does not have the 'objc_subclassing_restricted' attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cocoa_naming_owned_rule, CLASS_ERROR, (unsigned)diag::Severity::Error, "property follows Cocoa naming convention for returning 'owned' objects", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_collection_expr_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "the type %0 is not a pointer to a fast-enumerable object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_complex_mode_vector_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of machine mode does not support base vector types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_compound_literal_with_address_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "compound literal in function scope may not be qualified with an address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_compound_qualified_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{block pointer|pointer|reference}0 to function type %select{%2 |}1cannot have '%3' qualifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_concept_decls_may_only_appear_in_global_namespace_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "concept declarations may only appear in global or namespace scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_concept_extra_headers, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous template parameter list in concept definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_concept_no_associated_constraints, CLASS_ERROR, (unsigned)diag::Severity::Error, "concept cannot have associated constraints", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_concept_no_parameters, CLASS_ERROR, (unsigned)diag::Severity::Error, "concept template parameter list must have at least one parameter; explicit specialization of concepts is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_concept_not_implemented, CLASS_ERROR, (unsigned)diag::Severity::Error, "sorry, unimplemented concepts feature %0 used", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cond_voidptr_arc, CLASS_ERROR, (unsigned)diag::Severity::Error, "operands to conditional of types%diff{ $ and $|}0,1 are incompatible in ARC mode", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "conditional expression is ambiguous; %diff{$ can be converted to $ and vice versa|types can be convert to each other}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_ambiguous_ovl, CLASS_ERROR, (unsigned)diag::Severity::Error, "conditional expression is ambiguous; %diff{$ and $|types}0,1 can be converted to several common types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_vector_element_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector condition type %0 and result type %1 do not have elements of the same size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_vector_has_void, CLASS_ERROR, (unsigned)diag::Severity::Error, "GNU vector conditional operand cannot be %select{void|a throw expression}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_vector_mismatched_vectors, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector operands to the vector conditional must be the same type %diff{($ and $)|}0,1}", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_vector_operand_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{enumeration|extended vector}0 type %1 is not allowed in a vector conditional", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_vector_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector condition type %0 and result type %1 do not have the same number of elements", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conditional_void_nonvoid, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{left|right}1 operand to ? is void, but %select{right|left}1 operand is of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_config_scalar_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "CUDA special function '%0' must have scalar return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_aliasing_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting types for alias %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_codeseg_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting code segment specifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_ivar_bitwidth, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable %0 has conflicting bit-field width", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_ivar_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting instance variable names: %0 vs %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_ivar_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable %0 has conflicting type%diff{: $ vs $|}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_overriding_cc_attributes, CLASS_ERROR, (unsigned)diag::Severity::Error, "virtual function %0 has different calling convention attributes %diff{($) than the function it overrides (which has calling convention $)|than the function it overrides}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_super_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting super class name %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conflicting_types, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting types for %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constant_integer_arg_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument to %0 must be a constant integer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_body_invalid_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "statement not allowed in %select{constexpr|consteval}1 %select{function|constructor}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_body_no_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "no return statement in %select{constexpr|consteval}0 function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_dtor, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot be declared %select{<ERROR>|constexpr|consteval|constinit}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_dtor_subobject, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot be declared %select{<ERROR>|constexpr|consteval|constinit}0 because %select{data member %2|base class %3}1 does not have a constexpr destructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_local_var_non_literal_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable of non-literal type %1 cannot be defined in a constexpr %select{function|constructor}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_local_var_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{static|thread_local}1 variable not permitted in a constexpr %select{function|constructor}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_main, CLASS_ERROR, (unsigned)diag::Severity::Error, "'main' is not allowed to be declared %select{constexpr|consteval}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_non_literal_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{constexpr|consteval}2 %select{function|constructor}1's %ordinal0 parameter type %3 is not a literal type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_non_literal_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{constexpr|consteval}0 function's return type %1 is not a literal type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_redecl_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-constexpr|constexpr|consteval}1 declaration of %0 follows %select{non-constexpr|constexpr|consteval}2 declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_return_missing_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-void %select{constexpr|consteval}1 function %0 should return a value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_static_mem_var_requires_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of constexpr static data member %0 requires an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_tag, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class|struct|interface|union|enum}0 cannot be marked %select{<ERROR>|constexpr|consteval|constinit}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_var_non_literal, CLASS_ERROR, (unsigned)diag::Severity::Error, "constexpr variable cannot have non-literal type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_var_requires_const_destruction, CLASS_ERROR, (unsigned)diag::Severity::Error, "constexpr variable %0 must have constant destruction", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_var_requires_const_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "constexpr variable %0 must be initialized by a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "virtual function cannot be constexpr", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_virtual_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "constexpr %select{member function|constructor}0 not allowed in %select{struct|interface|class}1 with virtual base %plural{1:class|:classes}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_vla, CLASS_ERROR, (unsigned)diag::Severity::Error, "variably-modified type %0 cannot be used in a constexpr %select{function|constructor}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constexpr_wrong_decl_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{<ERROR>|constexpr|consteval|constinit}0 can only be used in %select{|variable and function|function|variable}0 declarations", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constinit_added_too_late, CLASS_ERROR, (unsigned)diag::Severity::Error, "'constinit' specifier added after initialization of variable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constinit_local_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "local variable cannot be declared 'constinit'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constrained_virtual_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "virtual function cannot have a requires clause", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constructor_byvalue_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "copy constructor must pass its first argument by reference", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constructor_cannot_be, CLASS_ERROR, (unsigned)diag::Severity::Error, "constructor cannot be declared '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constructor_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "constructor cannot be redeclared", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_constructor_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "constructor cannot have a return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_continuation_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "class extension has no primary class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_continue_not_in_loop, CLASS_ERROR, (unsigned)diag::Severity::Error, "'continue' statement not in loop statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_not_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function must be a non-static member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function cannot be redeclared", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function cannot have a return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_to_array, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function cannot convert to an array type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_to_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function cannot convert to a function type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_variadic, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function cannot be variadic", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_with_complex_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot specify any part of a return type in the declaration of a conversion function%select{; put the complete type after 'operator'|; use a typedef to declare a conversion to %1|; use an alias template to declare a conversion to %1|}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_conv_function_with_params, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function cannot have any parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_convertvector_incompatible_vector, CLASS_ERROR, (unsigned)diag::Severity::Error, "first two arguments to __builtin_convertvector must have the same number of elements", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_convertvector_non_vector, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to __builtin_convertvector must be a vector", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_convertvector_non_vector_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "second argument to __builtin_convertvector must be a vector type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_copy_capture_with_copy_default, CLASS_ERROR, (unsigned)diag::Severity::Error, "'&' must precede a capture when the capture default is '='", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_coroutine_handle_missing_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "std::experimental::coroutine_handle missing a member named '%0'", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_invalid_func_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%1' cannot be used in %select{a constructor|a destructor|the 'main' function|a constexpr function|a function with a deduced return type|a varargs function|a consteval function}0", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_objc_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "Objective-C methods as coroutines are not yet supported", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_outside_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' cannot be used outside a function", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_promise_get_return_object_on_allocation_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0: 'get_return_object_on_allocation_failure()' must be a static member function", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_promise_incompatible_return_functions, CLASS_ERROR, (unsigned)diag::Severity::Error, "the coroutine promise type %0 declares both 'return_value' and 'return_void'", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_promise_new_requires_nothrow, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is required to have a non-throwing noexcept specification when the promise type declares 'get_return_object_on_allocation_failure()'", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_promise_requires_return_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "the coroutine promise type %0 must declare either 'return_value' or 'return_void'", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_promise_type_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "this function cannot be a coroutine: %0 is an incomplete type", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_promise_unhandled_exception_required, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is required to declare the member 'unhandled_exception()'", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_type_missing_specialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "this function cannot be a coroutine: missing definition of specialization %0", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_unevaluated_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' cannot be used in an unevaluated context", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_coroutine_within_handler, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' cannot be used in the handler of a try block", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_covariant_return_ambiguous_derived_to_base_conv, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of virtual function %3 is not covariant with the return type of the function it overrides (ambiguous conversion from derived class %0 to base class %1:%2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_covariant_return_inaccessible_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid covariant return for virtual function: %1 is a %select{private|protected}2 base class of %0", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_covariant_return_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 is incomplete)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_covariant_return_not_derived, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 is not derived from %2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_covariant_return_type_class_type_more_qualified, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of virtual function %0 is not covariant with the return type of the function it overrides (class type %1 is more qualified than class type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_covariant_return_type_different_qualifications, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 has different qualifiers than %2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cpu_dispatch_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'cpu_dispatch' function redeclared with different CPUs", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_cpu_specific_multiple_defs, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple 'cpu_specific' functions cannot specify the same CPU: %0", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_ctor_dtor_returns_void, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{constructor|destructor}1 %0 must not return void expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cuda_device_exceptions, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use '%0' in %select{__device__|__global__|__host__|__host__ __device__}1 function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cuda_extern_shared, CLASS_ERROR, (unsigned)diag::Severity::Error, "__shared__ variable %0 cannot be 'extern'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cuda_host_shared, CLASS_ERROR, (unsigned)diag::Severity::Error, "__shared__ local variables not allowed in %select{__device__|__global__|__host__|__host__ __device__}0 functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cuda_nonglobal_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "__constant__ variables must be global", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cuda_ovl_target, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{__device__|__global__|__host__|__host__ __device__}0 function %1 cannot overload %select{__device__|__global__|__host__|__host__ __device__}2 function %3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cuda_unattributed_constexpr_cannot_overload_device, CLASS_ERROR, (unsigned)diag::Severity::Error, "constexpr function %0 without __host__ or __device__ attributes cannot overload __device__ function with same signature.  Add a __host__ attribute, or build with -fno-cuda-host-device-constexpr.", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_cuda_vla, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use variable-length arrays in %select{__device__|__global__|__host__|__host__ __device__}0 functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_current_module_name_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "module name '%0' specified on command line does not match name of module", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_dangling_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{reference|backing array for 'std::initializer_list'}2 %select{|subobject of }1member %0 %select{binds to|is}2 a temporary object whose lifetime would be shorter than the lifetime of the constructed object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dealloc_bad_result_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "dealloc return type must be correctly specified as 'void' under ARC, instead of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decimal_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "GNU decimal type extension not supported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decl_attribute_invalid_on_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be applied to a statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decl_negative_array_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' declared as an array with a negative size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_declarator_need_ident, CLASS_ERROR, (unsigned)diag::Severity::Error, "declarator requires an identifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_declspec_thread_on_thread_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__declspec(thread)' applied to variable that already has a thread-local storage specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decltype_auto_cannot_be_combined, CLASS_ERROR, (unsigned)diag::Severity::Error, "'decltype(auto)' cannot be combined with other type specifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decltype_auto_compound_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot form %select{pointer to|reference to|array of}0 'decltype(auto)'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decltype_auto_function_declarator_not_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "'decltype(auto)' can only be used as a return type in a function declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decltype_auto_initializer_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce 'decltype(auto)' from initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decltype_auto_invalid, CLASS_ERROR, (unsigned)diag::Severity::Error, "'decltype(auto)' not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decltype_in_declarator, CLASS_ERROR, (unsigned)diag::Severity::Error, "'decltype' cannot be used to name a declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_ambiguous_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose members of ambiguous base class %1 of %0:%2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_anon_union_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose class type %0 because it has an anonymous %select{struct|union}1 member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "decomposition declaration not permitted in this context", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_inaccessible_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose members of inaccessible base class %1 of %0", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_decomp_decl_inaccessible_field, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose %select{private|protected}0 member %1 of %3", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_decomp_decl_multiple_bases_with_members, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose class type %1: %select{its base classes %2 and|both it and its base class}0 %3 have non-static data members", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_not_alone, CLASS_ERROR, (unsigned)diag::Severity::Error, "decomposition declaration must be the only declaration in its group", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_parens, CLASS_ERROR, (unsigned)diag::Severity::Error, "decomposition declaration cannot be declared with parentheses", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_requires_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "decomposition declaration %0 requires an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "decomposition declaration cannot be declared %plural{1:'%1'|:with '%1' specifiers}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_std_tuple_element_not_specialized, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose this type; 'std::tuple_element<%0>::type' does not name a type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_std_tuple_size_not_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose this type; 'std::tuple_size<%0>::value' is not a valid integral constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "decomposition declaration template not supported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "decomposition declaration cannot be declared with type %0; declared type must be 'auto' or reference to 'auto'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_unbindable_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decompose %select{union|non-class, non-array}1 type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decomp_decl_wrong_number_bindings, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 decomposes into %2 elements, but %select{only |}3%1 names were provided", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_decrement_bool, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot decrement expression of type bool", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_class_template_compound_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot %select{form pointer to|form reference to|form array of|form function returning|use parentheses when declaring variable with}0 deduced class template specialization type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_class_template_ctor_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous deduction for template arguments of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_class_template_ctor_no_viable, CLASS_ERROR, (unsigned)diag::Severity::Error, "no viable constructor or deduction guide for deduction of template arguments of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_class_template_deleted, CLASS_ERROR, (unsigned)diag::Severity::Error, "class template argument deduction for %0 selected a deleted constructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_class_template_explicit, CLASS_ERROR, (unsigned)diag::Severity::Error, "class template argument deduction for %0 selected an explicit %select{constructor|deduction guide}1 for copy-list-initialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_class_template_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "template %0 has no definition and no %select{|viable }1deduction guides for deduction of template arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_non_class_template_specialization_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{<error>|function template|variable template|alias template|template template parameter|concept|template}0 %1 requires template arguments; argument deduction only allowed for class templates", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_non_type_template_arg_type_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduced non-type template argument does not have the same type as the corresponding template parameter%diff{ ($ vs $)|}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduced return types are a C++14 extension", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduced_tst, CLASS_ERROR, (unsigned)diag::Severity::Error, "typename specifier refers to %select{class template|function template|variable template|alias template|template template parameter|template}0; argument deduction not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_bad_trailing_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduced type %1 of deduction guide is not %select{|written as }2a specialization of template %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_defines_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide cannot have a function definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_invalid_specifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide cannot be declared '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_name_not_class_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot specify deduction guide for %select{<error>|function template|variable template|alias template|template template parameter|concept|dependent template name}0 %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_no_trailing_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide declaration without trailing return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration of deduction guide", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_specialized, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide cannot be %select{explicitly instantiated|explicitly specialized}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_template_not_deducible, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide template contains %select{a template parameter|template parameters}0 that cannot be deduced", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_with_complex_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot specify any part of a return type in the declaration of a deduction guide", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_wrong_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide has different access from the corresponding member template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deduction_guide_wrong_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide must be declared in the same scope as template %q0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deep_exception_specs_differ, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specifications of %select{return|argument}0 types differ", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_default_arg_in_partial_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "default template argument in a class template partial specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_default_arg_makes_ctor_special, CLASS_ERROR, (unsigned)diag::Severity::Error, "addition of default argument on redeclaration makes this constructor a %select{default|copy|move}0 constructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_default_init_const, CLASS_ERROR, (unsigned)diag::Severity::Error, "default initialization of an object of const type %0%select{| without a user-provided default constructor}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_default_not_in_switch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'default' statement not in switch statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_cannot_deduce_undeduced_auto, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of defaulted 'operator<=>' cannot be deduced because three-way comparison for %select{|member|base class}0 %1 has a deduced return type and is not yet defined", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_deduced_return_type_not_auto, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduced return type for defaulted %select{<ERROR>|equality|three-way|equality|relational}0 comparison operator must be 'auto', not %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_non_const, CLASS_ERROR, (unsigned)diag::Severity::Error, "defaulted member %select{<ERROR>|equality|three-way|equality|relational}0 comparison operator must be const-qualified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_out_of_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{<ERROR>|equality|three-way|equality|relational}0 comparison operator can only be defaulted in a class definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid parameter type for defaulted %select{<ERROR>|equality|three-way|equality|relational}0 comparison operator; found %1, expected %2%select{| or %4}3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_param_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameters for defaulted %select{<ERROR>|equality|three-way|equality|relational}0 comparison operator must have the same type%diff{ (found $ vs $)|}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_return_type_not_bool, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type for defaulted %select{<ERROR>|equality|three-way|equality|relational}0 comparison operator must be 'bool', not %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_comparison_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "comparison operator template cannot be defaulted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_copy_assign_not_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "the parameter for an explicitly-defaulted copy assignment operator must be an lvalue reference type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_special_member_copy_const_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "the parameter for this explicitly-defaulted copy %select{constructor|assignment operator}0 is const, but a member or base requires it to be non-const", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_special_member_move_const_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "the parameter for an explicitly-defaulted move %select{constructor|assignment operator}0 may not be const", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_special_member_params, CLASS_ERROR, (unsigned)diag::Severity::Error, "an explicitly-defaulted %select{|copy |move }0constructor cannot have default arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_special_member_quals, CLASS_ERROR, (unsigned)diag::Severity::Error, "an explicitly-defaulted %select{copy|move}0 assignment operator may not have 'const'%select{, 'constexpr'|}1 or 'volatile' qualifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_special_member_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicitly-defaulted %select{copy|move}0 assignment operator must return %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_special_member_variadic, CLASS_ERROR, (unsigned)diag::Severity::Error, "an explicitly-defaulted %select{|copy |move }0constructor cannot be variadic", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_defaulted_special_member_volatile_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "the parameter for an explicitly-defaulted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 may not be volatile", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_definition_of_explicitly_defaulted_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of explicitly defaulted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor|function}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_definition_of_implicitly_declared_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of implicitly declared %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor|function}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_delegating_ctor, CLASS_ERROR, (unsigned)diag::Severity::Error, "delegating constructors are permitted only in C++11", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_delegating_initializer_alone, CLASS_ERROR, (unsigned)diag::Severity::Error, "an initializer for a delegating constructor must appear alone", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_delete_explicit_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "converting delete expression from type %0 to type %1 invokes an explicit conversion function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_delete_incomplete_class_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "deleting incomplete class type %0; no conversions to pointer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_delete_operand, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot delete expression of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deleted_decl_not_first, CLASS_ERROR, (unsigned)diag::Severity::Error, "deleted definition must be first declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deleted_function_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "attempt to use a deleted function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deleted_inherited_ctor_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "constructor inherited by %0 from base class %1 is implicitly deleted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deleted_main, CLASS_ERROR, (unsigned)diag::Severity::Error, "'main' is not allowed to be deleted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_deleted_override, CLASS_ERROR, (unsigned)diag::Severity::Error, "deleted function %0 cannot override a non-deleted function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dependent_deduced_tst, CLASS_ERROR, (unsigned)diag::Severity::Error, "typename specifier refers to %select{class template|function template|variable template|alias template|template template parameter|template}0 member in %1; argument deduction not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dependent_function_template_spec_no_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "no candidate function template was found for dependent friend function template specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dependent_nested_name_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "nested name specifier for a declaration cannot depend on a template parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dependent_non_type_arg_in_partial_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of specialized non-type template argument depends on a template parameter of the partial specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dependent_tag_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{declaration|definition}0 of %select{struct|interface|union|class|enum}1 in a dependent scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dependent_typed_non_type_arg_in_partial_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument specializes a template parameter with dependent type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dereference_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "dereference of pointer to incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_designated_init_attr_non_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "'objc_designated_initializer' attribute only applies to init methods of interface or class extension declarations", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_designator_for_scalar_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "designator in initializer for scalar type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_designator_into_flexible_array_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "designator into flexible array member subobject", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destroy_attr_on_non_static_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{no_destroy|always_destroy}0 attribute can only be applied to a variable with static or thread storage duration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destroying_operator_delete_not_usual, CLASS_ERROR, (unsigned)diag::Severity::Error, "destroying operator delete can have only an optional size and optional alignment parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_cannot_be, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot be declared '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_class_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected the class name after '~' to name a destructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_expr_type_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor type %0 in object destruction expression does not match the type %1 of the object being destroyed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected the class name after '~' to name the enclosing class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_not_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor must be a non-static member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot be redeclared", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot have a return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot be declared as a template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_typedef_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot be declared using a %select{typedef|type alias}1 %0 of the class name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_variadic, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot be variadic", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_destructor_with_params, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor cannot have any parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_device_static_local_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "within a %select{__device__|__global__|__host__|__host__ __device__}0 function, only __shared__ variables or const variables without device memory qualifier may be marked 'static'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_diagnose_if_invalid_diagnostic_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid diagnostic type for 'diagnose_if'; use \"error\" or \"warning\" instead", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_diagnose_if_succeeded, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_different_asm_label, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting asm label", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_different_language_linkage, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of %0 has a different language linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_different_pass_object_size_params, CLASS_ERROR, (unsigned)diag::Severity::Error, "conflicting pass_object_size attributes on parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_different_return_type_for_overriding_virtual_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "virtual function %0 has a different return type %diff{($) than the function it overrides (which has return type $)|than the function it overrides}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dimension_expr_not_constant_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "dimension expression does not evaluate to a constant unsigned int", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_direct_selector_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "@selector expression formed with direct selector %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_distant_exception_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specifications are not allowed beyond a single level of indirection", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_downcast_from_inaccessible_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast %select{private|protected}2 base class %1 to %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dtor_expr_without_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to %select{destructor|pseudo-destructor}0 must be called%select{|; did you mean to call it with no arguments?}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dup_implementation_category, CLASS_ERROR, (unsigned)diag::Severity::Error, "reimplementation of category %1 for class %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dup_implementation_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "reimplementation of class %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_base_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "base class %0 specified more than once as a direct base class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_case, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate case value '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_case_differing_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate case value: '%0' and '%1' both equal '%2'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_class_def, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate interface definition for class %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_ivar_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable is already declared", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_ivar_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "synthesized properties %0 and %1 both claim instance variable %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_method_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate declaration of method %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_duplicate_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "property has a previous declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dynamic_property_ivar_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "dynamic property cannot have instance variable specification", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_dynamic_var_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "dynamic initialization is not supported for __device__, __constant__, and __shared__ variables.", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_early_catch_all, CLASS_ERROR, (unsigned)diag::Severity::Error, "catch-all handler must come last", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ellipsis_first_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "ISO C requires a named parameter before '...'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ellipsis_in_declarator_not_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "only function and template parameters can be parameter packs", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_empty_scalar_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "scalar initializer cannot be empty", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enum_class_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to %select{|scoped }0enumeration must use 'enum' not 'enum class'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enum_invalid_underlying, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-integral type %0 is an invalid underlying type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enum_mode_vector_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "mode %0 is not supported for enumeration types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enum_redeclare_fixed_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "enumeration previously declared with %select{non|}0fixed underlying type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enum_redeclare_scoped_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "enumeration previously declared as %select{un|}0scoped", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enum_redeclare_type_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "enumeration redeclared with different underlying type %0 (was %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enumerator_does_not_exist, CLASS_ERROR, (unsigned)diag::Severity::Error, "enumerator %0 does not exist in instantiation of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enumerator_too_large, CLASS_ERROR, (unsigned)diag::Severity::Error, "enumerator value is not representable in the underlying type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_enumerator_wrapped, CLASS_ERROR, (unsigned)diag::Severity::Error, "enumerator value %0 is not representable in the underlying type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_event_t_addr_space_qual, CLASS_ERROR, (unsigned)diag::Severity::Error, "the event_t type can only be used with __private address space qualifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_exception_spec_cycle, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specification of %0 uses itself", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_exception_spec_in_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specifications are not allowed in %select{typedefs|type aliases}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_exception_spec_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specification needed for member of incomplete class %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_exception_spec_not_parsed, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specification is not available until end of class definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_exceptions_disabled, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use '%0' with exceptions disabled", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_excess_initializers, CLASS_ERROR, (unsigned)diag::Severity::Error, "excess elements in %select{array|vector|scalar|union|struct}0 initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_excess_initializers_in_char_array_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "excess elements in char array initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_expected_allocator_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an 'allocator' clause inside of the target region; provide an 'allocator' clause or use 'requires' directive with the 'dynamic_allocators' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_expected_allocator_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an allocator expression inside of the target region; provide an allocator expression or use 'requires' directive with the 'dynamic_allocators' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_expected_class_or_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not a class%select{ or namespace|, namespace, or enumeration}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_expected_kernel_void_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel must have void return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "partial ordering for explicit instantiation of %0 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_constexpr, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation cannot be 'constexpr'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_data_member_not_instantiated, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation refers to static data member %q0 that is not an instantiation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_declaration_after_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation declaration (with 'extern') follows explicit instantiation definition (without 'extern')", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_duplicate, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate explicit instantiation of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_in_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of %0 in class scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_inline, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation cannot be 'inline'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_internal_linkage, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation declaration of %0 with internal linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_member_function_not_instantiated, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation refers to member function %q0 that is not an instantiation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_must_be_global, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of %0 must occur at global scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_nontemplate_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of non-templated type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_not_known, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of %0 does not refer to a function template, variable template, member function, member class, or static data member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_of_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of typedef %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_out_of_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of %0 not in a namespace enclosing %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_requires_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation declaration requires a name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_storage_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation cannot have a storage class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_undefined_func_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of undefined function template %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_undefined_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of undefined %select{member class|member function|static data member}0 %1 of class template %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_undefined_var_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of undefined variable template %q0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_unqualified_wrong_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of %q0 must occur in namespace %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_instantiation_without_template_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit instantiation of %q0 must specify a template argument list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_non_ctor_or_conv_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'explicit' can only be applied to a constructor or conversion function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_non_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'explicit' can only appear on non-static member functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_out_of_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "'explicit' can only be specified inside the class definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_explicit_specialization_inconsistent_storage_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit specialization has extraneous, inconsistent storage class '%select{none|extern|static|__private_extern__|auto|register}0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_export_in_private_module_fragment, CLASS_ERROR, (unsigned)diag::Severity::Error, "export declaration cannot be used in a private module fragment", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_export_internal, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of %0 with internal linkage cannot be exported", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_export_no_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{empty|static_assert|asm}0 declaration cannot be exported", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_export_not_in_module_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "export declaration can only be used within a module interface unit%select{ after the module declaration|}0", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_export_using_internal, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration referring to %0 with internal linkage cannot be exported", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_export_within_anonymous_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "export declaration appears within anonymous namespace", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_export_within_export, CLASS_ERROR, (unsigned)diag::Severity::Error, "export declaration appears within another export declaration", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_expr_not_cce, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{case value|enumerator value|non-type template argument|array size|constexpr if condition|explicit specifier argument}0 is not a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_expr_not_ice, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression is not an %select{integer|integral}0 constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_expr_not_string_literal, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression is not a string literal", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ext_vector_component_exceeds_length, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector component access exceeds type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ext_vector_component_name_illegal, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal vector component name '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_extern_c_global_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of %1 %select{with C language linkage|in global scope}0 conflicts with declaration %select{in global scope|with C language linkage}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_extern_non_extern, CLASS_ERROR, (unsigned)diag::Severity::Error, "extern declaration of %0 follows non-extern declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_falloff_nonvoid_block, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-void block does not return a value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_fallthrough_attr_invalid_placement, CLASS_ERROR, (unsigned)diag::Severity::Error, "fallthrough annotation does not directly precede switch label", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_fallthrough_attr_outside_switch, CLASS_ERROR, (unsigned)diag::Severity::Error, "fallthrough annotation is outside switch statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_fallthrough_attr_wrong_target, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute is only allowed on empty statements", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_declared_as_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "field %0 declared as a function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_designator_non_aggr, CLASS_ERROR, (unsigned)diag::Severity::Error, "field designator cannot initialize a %select{non-struct, non-union|non-class}0 type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_designator_nonfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "field designator %0 does not refer to a non-static data member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_designator_unknown, CLASS_ERROR, (unsigned)diag::Severity::Error, "field designator %0 does not refer to any field in type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_designator_unknown_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "field designator %0 does not refer to any field in type %1; did you mean %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "field has incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_instantiates_to_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "data member instantiated with function type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_field_with_address_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "field may not be qualified with an address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_filter_expression_integral, CLASS_ERROR, (unsigned)diag::Severity::Error, "filter expression has non-integral type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_final_function_overridden, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of %0 overrides a '%select{final|sealed}1' function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_first_argument_to_cwsc_block_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to __builtin_call_with_static_chain must not be a block call", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_first_argument_to_cwsc_builtin_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to __builtin_call_with_static_chain must not be a builtin call", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_first_argument_to_cwsc_not_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to __builtin_call_with_static_chain must be a non-member call expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_first_argument_to_cwsc_pdtor_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to __builtin_call_with_static_chain must not be a pseudo-destructor call", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_first_argument_to_va_arg_not_of_type_va_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to 'va_arg' is of type %0 and not 'va_list'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_arc_retainable, CLASS_ERROR, (unsigned)diag::Severity::Error, "ARC forbids flexible array members with retainable object type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_empty_aggregate, CLASS_ERROR, (unsigned)diag::Severity::Error, "flexible array member %0 not allowed in otherwise empty %select{struct|interface|union|class|enum}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_has_nontrivial_dtor, CLASS_ERROR, (unsigned)diag::Severity::Error, "flexible array member %0 of type %1 with non-trivial destruction", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "initialization of flexible array member is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_init_needs_braces, CLASS_ERROR, (unsigned)diag::Severity::Error, "flexible array requires brace-enclosed initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_not_at_end, CLASS_ERROR, (unsigned)diag::Severity::Error, "flexible array member %0 with type %1 is not at the end of %select{struct|interface|union|class|enum}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_union, CLASS_ERROR, (unsigned)diag::Severity::Error, "flexible array member %0 in a union is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_flexible_array_virtual_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "flexible array member %0 not allowed in %select{struct|interface|union|class|enum}1 which has a virtual base class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_fold_expression_bad_operand, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression not permitted as operand of fold expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_fold_expression_empty, CLASS_ERROR, (unsigned)diag::Severity::Error, "unary fold expression has empty expansion for operator '%0' with no fallback value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_fold_expression_packs_both_sides, CLASS_ERROR, (unsigned)diag::Severity::Error, "binary fold expression has unexpanded parameter packs in both operands", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_for_range_decl_must_be_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "for range declaration must declare a variable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_for_range_deduction_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use type %0 as a range", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_for_range_dereference, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid range expression of type %0; did you mean to dereference it with '*'?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_for_range_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use incomplete type %0 as a range", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_for_range_invalid, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid range expression of type %0; no viable '%select{begin|end}1' function available", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_for_range_iter_deduction_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use type %0 as an iterator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_for_range_storage_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "loop variable %0 may not be declared %select{'extern'|'static'|'__private_extern__'|'auto'|'register'|'constexpr'}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_format_attribute_implicit_this_format_string, CLASS_ERROR, (unsigned)diag::Severity::Error, "format attribute cannot specify the implicit this argument as the format string", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_format_attribute_not, CLASS_ERROR, (unsigned)diag::Severity::Error, "format argument not %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_format_attribute_requires_variadic, CLASS_ERROR, (unsigned)diag::Severity::Error, "format attribute requires variadic function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_format_attribute_result_not, CLASS_ERROR, (unsigned)diag::Severity::Error, "function does not return %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_format_strftime_third_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "strftime format attribute requires 3rd parameter to be 0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_forward_ref_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "ISO C++ forbids forward references to 'enum' types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_forward_superclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "attempting to use the forward class %0 as superclass of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_friend_decl_does_not_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend declaration of %0 does not match any declaration in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_friend_decl_with_def_arg_must_be_def, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend declaration specifying a default argument must be a definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_friend_decl_with_def_arg_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend declaration specifying a default argument must be the only declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_friend_def_in_local_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend function cannot be defined in a local class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_friend_is_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "friends cannot be members of the declaring class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_friend_not_first_in_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "'friend' must appear first in a non-function declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_func_def_incomplete_result, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete result type %0 in function definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_func_returning_array_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "function cannot return %select{array|function}0 type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_func_returning_qualified_void, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "function cannot return qualified void type %0", 608, SFINAE_Suppress, false, false, 2)
DIAG(err_function_attribute_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declared with %0 attribute was previously declared without the %0 attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_function_marked_override_not_overriding, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 marked 'override' but does not override any member functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_function_parameter_pack_without_parameter_packs, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 of function parameter pack does not contain any unexpanded parameter packs", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_function_template_partial_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "function template partial specialization is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_function_template_spec_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "function template specialization %0 ambiguously refers to more than one function template; explicitly specify%select{| additional}1 template arguments to identify a particular function template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_function_template_spec_no_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "no function template matches function template specialization %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_gc_weak_property_strong_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "weak attribute declared on a __strong type property in GC mode", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_generic_sel_multi_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "controlling expression type %0 compatible with %1 generic association types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_generic_sel_no_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "controlling expression type %0 not compatible with any generic association type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_getter_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "no getter method for read from property", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_global_call_not_config, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to global function %0 not configured", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_goto_into_protected_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot jump from this goto statement to its label", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_goto_ms_asm_label, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot jump from this goto statement to label %0 inside an inline assembly block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_half_const_requires_fp16, CLASS_ERROR, (unsigned)diag::Severity::Error, "half precision constant requires cl_khr_fp16", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_hexagon_builtin_requires_hvx, CLASS_ERROR, (unsigned)diag::Severity::Error, "builtin requires HVX", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_hexagon_builtin_unsupported_cpu, CLASS_ERROR, (unsigned)diag::Severity::Error, "builtin is not supported on this CPU", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_hexagon_builtin_unsupported_hvx, CLASS_ERROR, (unsigned)diag::Severity::Error, "builtin is not supported on this version of HVX", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_iboutletcollection_builtintype, CLASS_ERROR, (unsigned)diag::Severity::Error, "type argument of iboutletcollection attribute cannot be a builtin type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_iboutletcollection_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid type %0 as argument of iboutletcollection attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ice_ambiguous_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous conversion from type %0 to an integral or unscoped enumeration type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ice_explicit_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "integral constant expression requires explicit conversion from %0 to %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ice_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "integral constant expression has incomplete class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ice_not_integral, CLASS_ERROR, (unsigned)diag::Severity::Error, "integral constant expression must have integral or unscoped enumeration type, not %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ice_too_large, CLASS_ERROR, (unsigned)diag::Severity::Error, "integer constant expression evaluates to value %0 that cannot be represented in a %1-bit %select{signed|unsigned}2 integer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ident_in_dtor_not_a_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "identifier %0 in object destruction expression does not name a type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ident_list_in_fn_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "a parameter list without types is only allowed in a function definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_container_subscripting_op, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal operation on Objective-C container subscripting", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_array_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "array has incomplete element type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_array_of_auto, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' declared as array of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_array_of_functions, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' declared as array of functions of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_array_of_references, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' declared as array of references of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_mempointer_in_nonclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' does not point into a class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_mempointer_to_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' declared as a member pointer to a reference of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_mempointer_to_void, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' declared as a member pointer to void", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_decl_pointer_to_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' declared as a pointer to a reference of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal initializer (only variables can be initialized)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_initializer_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal initializer type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_message_expr_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "Objective-C message has incomplete result type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_qualifiers_on_catch_parm, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal qualifiers on @catch parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_illegal_union_or_anon_struct_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{anonymous struct|union}0 member %1 has a non-trivial %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_imaginary_not_supported, CLASS_ERROR, (unsigned)diag::Severity::Error, "imaginary types are not supported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_impcast_complex_scalar, CLASS_ERROR, (unsigned)diag::Severity::Error, "implicit conversion from %0 to %1 is not permitted in C++", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_implementation_of_class_stub, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot declare implementation of a class declared with the 'objc_class_stub' attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_implicit_coroutine_std_nothrow_type_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "std::nothrow was not found; include <new> before defining a coroutine which uses get_return_object_on_allocation_failure()", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_implicit_empty_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer for aggregate with no elements requires explicit braces", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_implicit_instantiate_member_undefined, CLASS_ERROR, (unsigned)diag::Severity::Error, "implicit instantiation of undefined member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_implied_comparison_category_type_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot %select{use builtin operator '<=>'|default 'operator<=>'}1 because type '%0' was not found; include <compare>", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_implied_coroutine_type_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 type was not found; include <experimental/coroutine> before defining a coroutine", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_implied_omp_allocator_handle_t_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "omp_allocator_handle_t type not found; include <omp.h>", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_implied_std_coroutine_traits_promise_type_not_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "this function cannot be a coroutine: %0 is not a class", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_implied_std_coroutine_traits_promise_type_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "this function cannot be a coroutine: %q0 has no member named 'promise_type'", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_implied_std_initializer_list_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce type of initializer list because std::initializer_list was not found; include <initializer_list>", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_in_class_initializer_bad_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "static data member of type %0 must be initialized out of line", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_in_class_initializer_cycle, CLASS_ERROR, (unsigned)diag::Severity::Error, "default member initializer for %0 uses itself", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_in_class_initializer_literal_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "in-class initializer for static data member of type %0 requires 'constexpr' specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_in_class_initializer_non_const, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-const static data member must be initialized out of line", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_in_class_initializer_non_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "in-class initializer for static data member is not a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_in_class_initializer_not_yet_parsed, CLASS_ERROR, (unsigned)diag::Severity::Error, "default member initializer for %1 needed within definition of enclosing class %0 outside of member functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_in_class_initializer_volatile, CLASS_ERROR, (unsigned)diag::Severity::Error, "static const volatile data member must be initialized out of line", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incompatible_exception_specs, CLASS_ERROR, (unsigned)diag::Severity::Error, "target exception specification is not superset of source", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_base_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "base class has incomplete type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_in_exception_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|pointer to |reference to }0incomplete type %1 is not allowed in exception specification", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_member_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "member access into incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_nested_name_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete type %0 named in nested name specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_object_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete type in call to object of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_receiver_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete receiver type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_synthesized_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot synthesize property %0 with incomplete type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete type %0 where a complete type is required", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_type_objc_at_encode, CLASS_ERROR, (unsigned)diag::Severity::Error, "'@encode' of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_type_used_in_type_trait_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete type %0 used in type trait expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incomplete_typeid, CLASS_ERROR, (unsigned)diag::Severity::Error, "'typeid' of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_inconsistent_ivar_count, CLASS_ERROR, (unsigned)diag::Severity::Error, "inconsistent number of instance variables specified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incorrect_defaulted_comparison_constexpr, CLASS_ERROR, (unsigned)diag::Severity::Error, "defaulted definition of %select{%select{<ERROR>|equality|three-way|equality|relational}1 comparison operator|three-way comparison operator}0 cannot be declared %select{constexpr|consteval}2 because %select{it|the corresponding implicit 'operator=='}0 invokes a non-constexpr comparison function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incorrect_defaulted_consteval, CLASS_ERROR, (unsigned)diag::Severity::Error, "defaulted declaration of %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 cannot be consteval because implicit definition is not constexpr", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incorrect_defaulted_constexpr, CLASS_ERROR, (unsigned)diag::Severity::Error, "defaulted definition of %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 is not constexpr", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_incorrect_number_of_vector_initializers, CLASS_ERROR, (unsigned)diag::Severity::Error, "number of elements must be either one or match the size of the vector", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_increment_decrement_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot %select{decrement|increment}0 expression of enum type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_indirect_goto_in_protected_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot jump from this %select{indirect|asm}0 goto statement to one of its possible targets", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_indirect_goto_without_addrlabel, CLASS_ERROR, (unsigned)diag::Severity::Error, "indirect goto in function with no address-of-label expressions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_capture_deduction_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce type for lambda capture %0 from initializer of type %2", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_init_capture_deduction_failure_from_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce type for lambda capture %0 from initializer list", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_init_capture_multiple_expressions, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer for lambda capture %0 contains multiple expressions", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_init_capture_no_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer missing for lambda capture %0", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_init_capture_paren_braces, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce type for lambda capture %1 from %select{parenthesized|nested}0 initializer list", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_init_conversion_failed, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot initialize %select{a variable|a parameter|return object|statement expression result|an exception object|a member subobject|an array element|a new value|a value|a base class|a constructor delegation|a vector element|a block element|a block element|a complex element|a lambda capture|a compound literal initializer|a related result|a parameter of CF audited function}0 %diff{of type $ with an %select{rvalue|lvalue}2 of type $|with an %select{rvalue|lvalue}2 of incompatible type}1,3%select{|: different classes%diff{ ($ vs $)|}5,6|: different number of parameters (%5 vs %6)|: type mismatch at %ordinal5 parameter%diff{ ($ vs $)|}6,7|: different return type%diff{ ($ vs $)|}5,6|: different qualifiers (%5 vs %6)|: different exception specifications}4", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_element_not_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer element is not a compile-time constant", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_for_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot create object of function type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "initialization of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_list_bad_dest_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|non-aggregate }0type %1 cannot be initialized with an initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_method_bad_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "init methods must return an object pointer type, not %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_non_aggr_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "initialization of non-aggregate type %0 with an initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_objc_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot initialize Objective-C class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_priority_object_attr, CLASS_ERROR, (unsigned)diag::Severity::Error, "can only use 'init_priority' attribute on file-scope definitions of objects of class type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_init_reference_member_uninitialized, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference member of type %0 uninitialized", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_initializer_overrides_destructed, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer would partially override prior initialization of object of type %1 with non-trivial destruction", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_initializer_string_for_char_array_too_long, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer-string for char array is too long", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_inline_decl_follows_def, CLASS_ERROR, (unsigned)diag::Severity::Error, "inline declaration of %0 follows non-inline definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_inline_declaration_block_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "inline declaration of %0 not allowed in block scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_inline_main, CLASS_ERROR, (unsigned)diag::Severity::Error, "'main' is not allowed to be declared inline", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_inline_namespace_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-inline namespace cannot be reopened as inline", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_inline_non_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'inline' can only appear on functions%select{| and non-local variables}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_int_to_block_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid block pointer conversion %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_integer_sequence_integral_element_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "integer sequences must have integral element type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_integer_sequence_negative_length, CLASS_ERROR, (unsigned)diag::Severity::Error, "integer sequences must have non-negative sequence length", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_internal_linkage_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "'internal_linkage' attribute does not appear on the first declaration of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_introducing_special_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "%plural{[0,2]:must use a qualified name when declaring|3:cannot declare}0 a %select{constructor|destructor|conversion operator|deduction guide}0 as a friend", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_asm_cast_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of a cast in a inline asm context requiring an l-value: remove the cast or build with -fheinous-gnu-extensions", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_invalid_asm_value_for_constraint, CLASS_ERROR, (unsigned)diag::Severity::Error, "value '%0' out of range for constraint '%1'", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_invalid_astype_of_different_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid reinterpretation: sizes of %0 and %1 must match", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_attribute_on_virtual_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be applied to virtual functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_base_in_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "interface type cannot inherit from %select{struct|non-public interface|class}0 %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_branch_protection_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid or misplaced branch protection specification '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_collection_element, CLASS_ERROR, (unsigned)diag::Severity::Error, "collection element of type %0 is not an Objective-C object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_complex_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "'_Complex %0' is invalid", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_constexpr, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{function parameter|typedef}0 cannot be %select{<ERROR>|constexpr|consteval|constinit}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_constexpr_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-static data member cannot be constexpr%select{; did you intend to make it %select{const|static}0?|}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_constexpr_var_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "constexpr variable declaration must be a definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_conversion_between_ext_vectors, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid conversion between ext-vector type %0 and %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_conversion_between_vector_and_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid conversion between vector type %0 and integer type %1 of different size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_conversion_between_vector_and_scalar, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid conversion between vector type %0 and scalar type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_conversion_between_vectors, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid conversion between vector type%diff{ $ and $|}0,1 of different size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_cpu_is, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid cpu name for builtin", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_cpu_specific_dispatch_value, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid option '%0' for %select{cpu_specific|cpu_dispatch}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_cpu_supports, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid cpu feature string for builtin", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_decl_spec_combination, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot combine with previous '%0' declaration specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_decl_specifier_in_nontype_parm, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid declaration specifier in template non-type parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_declarator_global_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition or redeclaration of %0 cannot name the global scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_declarator_in_block, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition or redeclaration of %0 not allowed inside a block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_declarator_in_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition or redeclaration of %0 not allowed inside a function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_declarator_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot define or redeclare %0 here because namespace %1 does not enclose namespace %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_form_pointer_member_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot create a non-constant pointer to member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_incomplete_type_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_mask_type_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "mask type size must be between 1-byte and 8-bytes", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_member_use_in_static_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of member %0 in static member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_neon_type_code, CLASS_ERROR, (unsigned)diag::Severity::Error, "incompatible constant for this __builtin_neon function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_non_static_member_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of non-static data member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_nsnumber_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not a valid literal type for NSNumber", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_pcs, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid PCS type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_pixel_decl_spec_combination, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__pixel' must be preceded by '__vector'.  '%0' declaration specifier not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_property_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not a valid property name (accessing an object of type %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_protocol_qualifiers, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid protocol qualifiers on non-ObjC type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_qualified_constructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' qualifier is not allowed on a constructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_qualified_destructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' qualifier is not allowed on a destructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_qualified_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-member function|static member function|deduction guide}0 %select{of type %2 |}1cannot have '%3' qualifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_receiver_class_message, CLASS_ERROR, (unsigned)diag::Severity::Error, "receiver type %0 is not an Objective-C class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_receiver_to_message_super, CLASS_ERROR, (unsigned)diag::Severity::Error, "'super' is only valid in a method body", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_saturation_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "'_Sat' specifier is only valid on '_Fract' or '_Accum', not '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_sign_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' cannot be signed or unsigned", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_super_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of '__super', this keyword can only be used inside class or member function scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_this_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of 'this' outside of a non-static member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_thread, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' is only allowed on variable declarations", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_type_for_program_scope_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "the %0 type cannot be used to declare a program scope variable", 0, SFINAE_SubstitutionFailure, false, true, 19)
DIAG(err_invalid_use_of_array_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "an array type is not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_use_of_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "a function type is not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_var_template_spec_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %2 of %select{explicit instantiation|explicit specialization|partial specialization|redeclaration}0 of %1 does not match expected type %3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_vector_bool_decl_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use '%0' with '__vector bool'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_vector_decl_spec_combination, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot combine with previous '%0' declaration specifier. '__vector' must be first", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_vector_double_decl_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of 'double' with '__vector' requires VSX support to be enabled (available on POWER7 or later)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_vector_float_decl_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use 'float' with '__vector'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_vector_long_decl_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use 'long' with '__vector'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_vector_long_double_decl_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use 'long double' with '__vector'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_vector_long_long_decl_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of 'long long' with '__vector bool' requires VSX support (available on POWER7 or later) or extended Altivec support (available on POWER8 or later) to be enabled", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_invalid_width_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%select{|short|long|long long}0 %1' is invalid", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ivar_access_using_property_syntax_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 not found on object of type %1; did you mean to access instance variable %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ivar_in_superclass_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 attempting to use instance variable %1 declared in super class %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ivar_reference_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variables cannot be of reference type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ivar_use_in_class_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable %0 accessed in class method", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_kern_call_not_global_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel call to non-global function %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_kern_is_nonstatic_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel function %0 must be a free function or static member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_kern_type_not_void_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel function type %0 must have void return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_kernel_arg_address_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "pointer arguments to kernel functions must reside in '__global', '__constant' or '__local' address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lambda_capture_anonymous_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "unnamed variable cannot be implicitly captured in a lambda expression", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_capture_default_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "lambda expression in default argument cannot capture any entity", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_capture_flexarray_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 with flexible array member cannot be captured in a lambda expression", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_decl_ref_not_modifiable_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot assign to a variable captured by copy in a non-mutable lambda", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lambda_impcap, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 cannot be implicitly captured in a lambda with no capture-default specified", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_in_constant_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "a lambda expression may not appear inside of a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_in_invalid_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "a lambda expression cannot appear in this context", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_incomplete_result, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete result type %0 in lambda expression", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_return_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot deduce lambda return type from initializer list", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_lambda_unevaluated_operand, CLASS_ERROR, (unsigned)diag::Severity::Error, "lambda expression in an unevaluated operand", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_language_linkage_spec_not_ascii, CLASS_ERROR, (unsigned)diag::Severity::Error, "string literal in language linkage specifier cannot have an encoding-prefix", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_language_linkage_spec_unknown, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown linkage language", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_late_asm_label_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot apply asm label to %select{variable|function}0 after its first use", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lifetimebound_ctor_dtor, CLASS_ERROR, (unsigned)diag::Severity::Error, "'lifetimebound' attribute cannot be applied to a %select{constructor|destructor}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lifetimebound_no_object_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "'lifetimebound' attribute cannot be applied; %select{static |non-}0member function has no implicit object parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_list_init_in_parens, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot initialize %select{non-class|reference}0 type %1 with a parenthesized initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_bad_param_count, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-template literal operator must have one or two parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_default_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "literal operator cannot have a default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_extern_c, CLASS_ERROR, (unsigned)diag::Severity::Error, "literal operator must have C++ linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_id_outside_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-namespace scope '%0' cannot have a literal operator member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_invalid_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter of literal operator must have type 'unsigned long long', 'long double', 'char', 'wchar_t', 'char16_t', 'char32_t', or 'const char *'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_outside_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "literal operator %0 must be in a namespace or global scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid literal operator parameter type %0, did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter list for literal operator must be either 'char...' or 'typename T, T...'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_literal_operator_template_with_params, CLASS_ERROR, (unsigned)diag::Severity::Error, "literal operator template cannot have any parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_local_cant_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__local' variable cannot have an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lvalue_reference_bind_to_initlist, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-const|volatile}0 lvalue reference to type %1 cannot bind to an initializer list temporary", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lvalue_reference_bind_to_temporary, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-const|volatile}0 lvalue reference %diff{to type $ cannot bind to a temporary of type $|cannot bind to incompatible temporary}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lvalue_reference_bind_to_unrelated, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-const|volatile}0 lvalue reference %diff{to type $ cannot bind to a value of unrelated type $|cannot bind to a value of unrelated type}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_lvalue_to_rvalue_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "rvalue reference %diff{to type $ cannot bind to lvalue of type $|cannot bind to incompatible lvalue}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_machine_mode, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{unknown|unsupported}0 machine mode %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_main_arg_wrong, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{first|second|third|fourth}0 parameter of 'main' (%select{argument count|argument array|environment|platform-specific data}0) must be of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_main_global_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "main cannot be declared as global variable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_main_returns_nonint, CLASS_ERROR, (unsigned)diag::Severity::Error, "'main' must return 'int'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_main_surplus_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "too many parameters (%0) for 'main': must be 0, 2, or 3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mainlike_template_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be a template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_malformed_std_coroutine_handle, CLASS_ERROR, (unsigned)diag::Severity::Error, "std::experimental::coroutine_handle must be a class template", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_malformed_std_coroutine_traits, CLASS_ERROR, (unsigned)diag::Severity::Error, "'std::experimental::coroutine_traits' must be a class template", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_malformed_std_initializer_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "std::initializer_list must be a class template with a single type parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_malformed_std_nothrow, CLASS_ERROR, (unsigned)diag::Severity::Error, "std::nothrow must be a valid variable declaration", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_maybe_falloff_nonvoid_block, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-void block does not return a value in all control paths", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mem_init_not_member_or_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "member initializer %0 does not name a non-static data member or base class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mem_init_not_member_or_class_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer %0 does not name a non-static data member or base class; did you mean the %select{base class|member}1 %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_call_without_object, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to non-static member function without an object argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_decl_does_not_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "out-of-line %select{declaration|definition}2 of %0 does not match any declaration in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_decl_does_not_match_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "out-of-line %select{declaration|definition}2 of %0 does not match any declaration in %1; did you mean %3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_def_does_not_match_ret_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type of out-of-line definition of %q0 differs from that in the declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_def_undefined_record, CLASS_ERROR, (unsigned)diag::Severity::Error, "out-of-line definition of %0 from class %1 without definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_extra_qualification, CLASS_ERROR, (unsigned)diag::Severity::Error, "extra qualification on member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_function_call_bad_cvr, CLASS_ERROR, (unsigned)diag::Severity::Error, "'this' argument to member function %0 has type %1, but function is not marked %select{const|restrict|const or restrict|volatile|const or volatile|volatile or restrict|const, volatile, or restrict}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_function_call_bad_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "'this' argument to member function %0 is an %select{lvalue|rvalue}1, but function has %select{non-const lvalue|rvalue}2 ref-qualifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_function_call_bad_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot initialize object parameter of type %0 with an expression of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_function_initialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer on function does not look like a pure-specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_name_of_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "member %0 has the same name as its class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_not_yet_instantiated, CLASS_ERROR, (unsigned)diag::Severity::Error, "no member %0 in %1; it has not yet been instantiated", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_qualification, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-friend class member %0 cannot have a qualified name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "class member cannot be redeclared", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_redeclared_in_instantiation, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple overloads of %0 instantiate to the same signature %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_member_reference_needs_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "base of member reference is a function; perhaps you meant to call it%select{| with no arguments}0?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mempointer_in_nonclass_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "member pointer refers into non-class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_memptr_conv_via_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion from pointer to member of class %0 to pointer to member of class %1 via virtual base %2 is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_memptr_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "member pointer has incomplete base type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_memtag_any2arg_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "at least one argument of MTE builtin function must be a pointer (%0, %1 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_memtag_arg_must_be_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 argument of MTE builtin function must be an integer type (%1 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_memtag_arg_must_be_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 argument of MTE builtin function must be a pointer (%1 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_memtag_arg_null_or_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 argument of MTE builtin function must be a null or a pointer (%1 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_messaging_class_with_direct_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "messaging a Class with a method that is possibly direct", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_messaging_super_with_direct_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "messaging super with a direct method", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_messaging_unqualified_id_with_direct_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "messaging unqualified id with a method that is possibly direct", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_method_kernel, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel functions cannot be class members", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_method_not_found_with_typo, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{instance|class}1 method %0 not found ; did you mean %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mips_builtin_requires_dsp, CLASS_ERROR, (unsigned)diag::Severity::Error, "this builtin requires 'dsp' ASE, please use -mdsp", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mips_builtin_requires_dspr2, CLASS_ERROR, (unsigned)diag::Severity::Error, "this builtin requires 'dsp r2' ASE, please use -mdspr2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mips_builtin_requires_msa, CLASS_ERROR, (unsigned)diag::Severity::Error, "this builtin requires 'msa' ASE, please use -mmsa", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_code_seg_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "derived class must specify the same code segment as its base classes", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_code_seg_override, CLASS_ERROR, (unsigned)diag::Severity::Error, "overriding virtual function must specify the same code segment as its overridden function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_exception_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specification in declaration does not match previous declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_exception_spec_explicit_instantiation, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specification in explicit instantiation does not match instantiated one", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_ms_inheritance, CLASS_ERROR, (unsigned)diag::Severity::Error, "inheritance model does not match %select{definition|previous declaration}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_owning_module, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of %0 in %select{the global module|module %2}1 follows declaration in %select{the global module|module %4}3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_uuid, CLASS_ERROR, (unsigned)diag::Severity::Error, "uuid does not match previous declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mismatched_visibility, CLASS_ERROR, (unsigned)diag::Severity::Error, "visibility does not match previous declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_misplaced_ivar, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variables may not be placed in %select{categories|class extension}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_actual_pipe_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing actual type specifier for pipe", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_atsign_prefix, CLASS_ERROR, (unsigned)diag::Severity::Error, "string literal must be prefixed by '@' ", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_default_ctor, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{constructor for %1 must explicitly initialize the|implicit default constructor for %1 must explicitly initialize the|cannot use constructor inherited from base class %4;}0 %select{base class|member}2 %3 %select{which|which|of %1}0 does not have a default constructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_exception_specification, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is missing exception specification '%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_method_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing context for method declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_open_square_message_send, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing '[' at start of message send expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_property_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing context for property implementation declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_property_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "property implementation in a category with no category declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_property_ivar_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "synthesized property %0 must either be named the same as a compatible instance variable or must explicitly name an instance variable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_missing_type_specifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "C++ requires a type specifier for all declarations", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mixing_cxx_try_seh_try, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use C++ 'try' in the same function as SEH '__try'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mode_not_primitive, CLASS_ERROR, (unsigned)diag::Severity::Error, "mode attribute only supported for integer and floating-point types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mode_wrong_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of machine mode does not match type of base type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_module_decl_in_header_module, CLASS_ERROR, (unsigned)diag::Severity::Error, "'module' declaration found while building header unit", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_decl_in_module_map_module, CLASS_ERROR, (unsigned)diag::Severity::Error, "'module' declaration found while building module from module map", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_decl_not_at_start, CLASS_ERROR, (unsigned)diag::Severity::Error, "module declaration must occur at the start of the translation unit", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_declaration_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing 'export module' declaration in module interface unit", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_declaration_missing_after_global_module_introducer, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing 'module' declaration at end of global module fragment introduced here", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_import_in_implementation, CLASS_ERROR, (unsigned)diag::Severity::Error, "@import of module '%0' in implementation of '%1'; use #import", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_import_not_at_top_level_fatal, CLASS_ERROR, (unsigned)diag::Severity::Fatal, "import of module '%0' appears within %1", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_interface_implementation_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing 'export' specifier in module declaration while building module interface", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_not_defined, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of module '%0' is not available; use -fmodule-file= to specify path to precompiled module interface", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_private_local, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{local variable|parameter|typedef}0 %1 cannot be declared __module_private__", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_private_local_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "local %select{struct|interface|union|class|enum}0 cannot be declared __module_private__", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_private_specialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{template|partial|member}0 specialization cannot be declared __module_private__", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "translation unit contains multiple module declarations", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_redefinition, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of module '%0'", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_self_import, CLASS_ERROR, (unsigned)diag::Severity::Error, "import of module '%0' appears within same top-level module '%1'", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_unimported_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{declaration|definition|default argument|explicit specialization|partial specialization}0 of %1 must be imported from module '%2' before it is required", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_unimported_use_global_module_fragment, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{missing '#include'|missing '#include %3'}2; %select{||default argument of |explicit specialization of |partial specialization of }0%1 must be %select{declared|defined|defined|declared|declared}0 before it is used", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_unimported_use_header, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing '#include %3'; %select{declaration|definition|default argument|explicit specialization|partial specialization}0 of %1 must be imported from module '%2' before it is required", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_unimported_use_multiple, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{declaration|definition|default argument|explicit specialization|partial specialization}0 of %1 must be imported from one of the following modules before it is required:%2", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_ms___leave_not_in___try, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__leave' statement not in __try block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ms_va_start_used_in_sysv_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__builtin_ms_va_start' used in System V ABI function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_msvc_annotation_wide_str, CLASS_ERROR, (unsigned)diag::Severity::Error, "arguments to __annotation must be wide string constants", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_multiple_base_initialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple initializations given for base %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_multiple_default_labels_defined, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple default labels in one switch", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_multiple_final_overriders, CLASS_ERROR, (unsigned)diag::Severity::Error, "virtual function %q0 has more than one final overrider in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_multiple_mem_initialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple initializations given for non-static member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_multiple_mem_union_initialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializing multiple members of union", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_multiversion_after_used, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declaration cannot become a multiversioned function after first usage", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_diff, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiversioned function declaration has a different %select{calling convention|return type|constexpr specification|inline specification|storage class|linkage}0", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_doesnt_support, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute '%select{target|cpu_specific|cpu_dispatch}0' multiversioned functions do not yet support %select{function templates|virtual functions|deduced return types|constructors|destructors|deleted functions|defaulted functions|constexpr functions|consteval function}1", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_duplicate, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiversioned function redeclarations require identical target attributes", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_no_other_attrs, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute '%select{target|cpu_specific|cpu_dispatch}0' multiversioning cannot be combined with other attributes", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_noproto, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiversioned function must have a prototype", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_not_allowed_on_main, CLASS_ERROR, (unsigned)diag::Severity::Error, "'main' cannot be a multiversioned function", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_not_supported, CLASS_ERROR, (unsigned)diag::Severity::Error, "function multiversioning is not supported on the current target", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_required_in_redecl, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declaration is missing %select{'target'|'cpu_specific' or 'cpu_dispatch'}0 attribute in a multiversioned function", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_multiversion_types_mixed, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiversioning attributes cannot be combined", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_mutable_const, CLASS_ERROR, (unsigned)diag::Severity::Error, "'mutable' and 'const' cannot be mixed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mutable_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'mutable' cannot be applied to functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mutable_nonmember, CLASS_ERROR, (unsigned)diag::Severity::Error, "'mutable' can only be applied to member variables", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_mutable_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "'mutable' cannot be applied to references", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_need_header_before_ms_uuidof, CLASS_ERROR, (unsigned)diag::Severity::Error, "you need to include <guiddef.h> before using the '__uuidof' operator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_need_header_before_typeid, CLASS_ERROR, (unsigned)diag::Severity::Error, "you need to include <typeinfo> before using the 'typeid' operator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nested_name_member_ref_lookup_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "lookup of %0 in member access expression is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nested_name_spec_is_not_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot appear before '::' because it is not a class%select{ or namespace|, namespace, or enumeration}1; did you mean ':'?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nested_name_spec_non_tag, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 cannot be used prior to '::' because it has no members", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nested_non_static_member_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{call to non-static member function|use of non-static data member}0 %2 of %1 from nested type %3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nested_redefinition, CLASS_ERROR, (unsigned)diag::Severity::Error, "nested redefinition of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_new_abi_tag_on_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "'abi_tag' %0 missing in original declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_new_array_init_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "array 'new' cannot have initialization arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_new_array_nonconst, CLASS_ERROR, (unsigned)diag::Severity::Error, "only the first dimension of an allocated array may have dynamic size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_new_array_of_auto, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot allocate array of 'auto'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_new_array_size_unknown_from_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot determine allocated array size from initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_new_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "allocation of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_accessor_for_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "no %select{getter|setter}0 defined for property %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_base_classes, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of '__super', %0 has no base classes", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_dynamic_cast_with_fno_rtti, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of dynamic_cast requires -frtti", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_matching_local_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching function found in local scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_matching_local_friend_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching function %0 found in local scope; did you mean %3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "no member named %0 in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_member_overloaded_arrow, CLASS_ERROR, (unsigned)diag::Severity::Error, "no member named %0 in %1; did you mean to use '->' instead of '.'?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_member_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "no member named %0 in %1; did you mean %select{|simply }2%3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_member_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "no template named %0 in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_member_template_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "no template named %0 in %1; did you mean %select{|simply }2%3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_nsconstant_string_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find interface declaration for %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_subobject_property_setting, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression is not assignable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_suitable_delete_member_function_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "no suitable member %0 in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_super_class_message, CLASS_ERROR, (unsigned)diag::Severity::Error, "no @interface declaration found in class messaging of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "no template named %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_template_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "no template named %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_no_typeid_with_fno_rtti, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of typeid requires -frtti", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_noexcept_needs_constant_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument to noexcept specifier must be a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nogetter_property_compound_assignment, CLASS_ERROR, (unsigned)diag::Severity::Error, "a getter method is needed to perform a compound assignment on a property", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nogetter_property_incdec, CLASS_ERROR, (unsigned)diag::Severity::Error, "no getter method %1 for %select{increment|decrement}0 of property", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_asm_stmt_in_naked_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-ASM statement in naked function is not supported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_bool_atomic_constraint, CLASS_ERROR, (unsigned)diag::Severity::Error, "atomic constraint must be of type 'bool' (found %0)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_constant_constraint_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "substitution into constraint expression resulted in a non-constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_deleted_override, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-deleted function %0 cannot override a deleted function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_extern_extern, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-extern declaration of %0 follows extern declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_first_default_compare_deletes, CLASS_ERROR, (unsigned)diag::Severity::Error, "defaulting %select{this %select{<ERROR>|equality|three-way|equality|relational}1 comparison operator|the corresponding implicit 'operator==' for this defaulted 'operator<=>'}0 would delete it after its first declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_local_variable_decl_in_for, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of non-local variable in 'for' loop", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_static_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-static declaration of %0 follows static declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_template_in_member_template_id_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "member %0 of %1 is not a template; did you mean %select{|simply }2%3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_template_in_template_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not name a template but is followed by template arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_template_in_template_id_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not name a template but is followed by template arguments; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_thread_thread, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-thread-local declaration of %0 follows thread-local declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_trivial_c_union_in_invalid_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot %select{use type %1 for a function/method parameter|use type %1 for function/method return|default-initialize an object of type %1|declare an automatic variable of type %1|copy-initialize an object of type %1|assign to a variable of type %1|construct an automatic compound literal of type %1|capture a variable of type %1|cannot use volatile type %1 where it causes an lvalue-to-rvalue conversion}3 since it %select{contains|is}2 a union that is non-trivial to %select{default-initialize|destruct|copy}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_type_template_arg_addr_label_diff, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument / label address difference / what did you expect?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_type_template_arg_subobject, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument refers to subobject '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_type_template_in_nested_name_specifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "qualified name refers into a specialization of %select{function|variable}0 template %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_type_template_parm_type_deduction_failure, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template parameter %0 with type %1 has incompatible initializer of type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_variable_decl_in_for, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-variable declaration in 'for' loop", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_non_virtual_pure, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not virtual and cannot be declared pure", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nonfunction_block_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "block pointer to non-function type is invalid", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nonstatic_member_out_of_line, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-static data member defined out-of-line", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nontemporal_builtin_must_be_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to nontemporal builtin must be a pointer (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nontemporal_builtin_must_be_pointer_intfltptr_or_vector, CLASS_ERROR, (unsigned)diag::Severity::Error, "address argument to nontemporal builtin must be a pointer to integer, float, pointer, or a vector of such types (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_noreturn_block_has_return_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "block declared 'noreturn' should not return", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_noreturn_lambda_has_return_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "lambda declared 'noreturn' should not return", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_noreturn_missing_on_first_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declared '[[noreturn]]' after its first declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_noreturn_non_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'_Noreturn' can only appear on functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nosetter_property_assignment, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{assignment to readonly property|no setter method %1 for assignment to property}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nosetter_property_incdec, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{%select{increment|decrement}1 of readonly property|no setter method %2 for %select{increment|decrement}1 of property}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_not_class_template_specialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot specialize a %select{dependent template|template template parameter}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_not_direct_base_or_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 is not a direct or virtual base of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_not_found_by_two_phase_lookup, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to function %0 that is neither visible in the template definition nor found by argument-dependent lookup", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_not_integral_type_anon_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "anonymous bit-field has non-integral type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_not_integral_type_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "bit-field %0 has non-integral type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_not_tag_in_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "no %select{struct|interface|union|class|enum}0 named %1 in %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ns_attribute_wrong_parameter_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute only applies to %select{Objective-C object|pointer|pointer-to-CF-pointer}1 parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nsconsumed_attribute_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "overriding method has mismatched ns_consumed attribute on its parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nsobject_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "'NSObject' attribute is for pointer types only", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nsreturns_retained_attribute_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "overriding method has mismatched ns_returns_%select{not_retained|retained}0 attributes", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_nullability_cs_multilevel, CLASS_ERROR, (unsigned)diag::Severity::Error, "nullability keyword %0 cannot be applied to multi-level pointer type %1", 0, SFINAE_SubstitutionFailure, false, true, 21)
DIAG(err_nullability_nonpointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "nullability specifier %0 cannot be applied to non-pointer type %1", 0, SFINAE_SubstitutionFailure, false, true, 21)
DIAG(err_objc_array_of_interfaces, CLASS_ERROR, (unsigned)diag::Severity::Error, "array of interface %0 is invalid (probably should be an array of pointers)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_attr_not_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter of %0 attribute must be a single name of an Objective-C %select{class|protocol}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_attr_protocol_requires_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %0 can only be applied to @protocol definitions, not forward declarations", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_attr_typedef_not_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter of %0 attribute must be 'id' when used on a typedef", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_attr_typedef_not_void_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "'objc_bridge(id)' is only allowed on structs and typedefs of void pointers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_bridged_related_invalid_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "could not find Objective-C class %0 to convert %1 to %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_bridged_related_invalid_class_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 must be name of an Objective-C class to be able to convert %1 to %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_bridged_related_known_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 must be explicitly converted to %1; use %select{%objcclass2|%objcinstance2}3 method for this conversion", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_cf_bridged_not_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "CF object of type %0 is bridged to %1, which is not an Objective-C class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_decls_may_only_appear_in_global_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "Objective-C declarations may only appear in global scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_direct_duplicate_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|direct }0method declaration conflicts with previous %select{|direct }1declaration of method %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_direct_impl_decl_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "direct method was declared in %select{the primary interface|an extension|a category}0 but is implemented in %select{the primary interface|a category|a different category}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_direct_missing_on_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "direct method implementation was previously declared not direct", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_direct_on_override, CLASS_ERROR, (unsigned)diag::Severity::Error, "methods that %select{override superclass methods|implement protocol requirements}0 cannot be direct", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_direct_on_protocol, CLASS_ERROR, (unsigned)diag::Severity::Error, "'objc_direct' attribute cannot be applied to %select{methods|properties}0 declared in an Objective-C protocol", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_exceptions_disabled, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use '%0' with Objective-C exceptions disabled", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_for_range_init_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "initialization statement is not supported when iterating over Objective-C collection", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_illegal_boxed_expression_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal type %0 used in a boxed expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_incomplete_boxed_expression_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete type %0 used in a boxed expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_index_incomplete_class_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "Objective-C index expression has incomplete class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_indexing_method_result_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "method for accessing %select{dictionary|array}1 element must have Objective-C object return type instead of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_kindof_nonobject, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__kindof' specifier cannot be applied to non-object type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_kindof_wrong_position, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__kindof' type specifier must precede the declarator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_literal_method_sig, CLASS_ERROR, (unsigned)diag::Severity::Error, "literal construction method %0 has incompatible signature", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_method_unsupported_param_ret_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 %select{parameter|return}1 type is unsupported; support for vector types for this target is introduced in %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_multiple_subscript_type_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "indexing expression is invalid because subscript type %0 has multiple type conversion functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_non_trivially_copyable_boxed_expression_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-trivially copyable type %0 cannot be used in a boxed expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_ns_bridged_invalid_cfobject, CLASS_ERROR, (unsigned)diag::Severity::Error, "ObjectiveC object of type %0 is bridged to %1, which is not valid CF object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_object_assignment, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot assign to class object (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_object_catch, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot catch an Objective-C object by value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_override_direct_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot override a method that is declared direct by a superclass", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_parameterized_category_nonclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{extension|category}0 of non-parameterized class %1 cannot have type parameters", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_parameterized_forward_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "forward declaration of non-parameterized class %0 cannot have type parameters", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_parameterized_forward_class_first, CLASS_ERROR, (unsigned)diag::Severity::Error, "class %0 previously declared with type parameters", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_precise_lifetime_bad_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "objc_precise_lifetime only applies to retainable types; type here is %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_property_attr_mutually_exclusive, CLASS_ERROR, (unsigned)diag::Severity::Error, "property attributes '%0' and '%1' are mutually exclusive", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_property_requires_object, CLASS_ERROR, (unsigned)diag::Severity::Error, "property with '%0' attribute must be of object type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_root_class_subclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "objc_root_class attribute may only be specified on a root class declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_runtime_visible_category, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot implement a category for class %0 that is only visible via the Objective-C runtime", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_runtime_visible_subclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot implement subclass %0 of a superclass %1 that is only visible via the Objective-C runtime", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_base_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{dictionary|array}1 subscript base type %0 is not an Objective-C object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_dic_object_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "method object parameter type %0 is not object type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_index_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "method index parameter type %0 is not integral type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_key_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "method key parameter type %0 is not object type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_method_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected method to %select{read|write}1 %select{dictionary|array}2 element not found on object of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_object_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot assign to this %select{dictionary|array}1 because assigning method's 2nd parameter of type %0 is not an Objective-C pointer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "indexing expression is invalid because subscript type %0 is not an Objective-C pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_subscript_type_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "indexing expression is invalid because subscript type %0 is not an integral or Objective-C pointer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_synchronized_expects_object, CLASS_ERROR, (unsigned)diag::Severity::Error, "@synchronized requires an Objective-C object type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_throw_expects_object, CLASS_ERROR, (unsigned)diag::Severity::Error, "@throw requires an Objective-C object type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_type_arg_does_not_match_bound, CLASS_ERROR, (unsigned)diag::Severity::Error, "type argument %0 does not satisfy the bound (%1) of type parameter %2", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_objc_type_arg_explicit_nullability, CLASS_ERROR, (unsigned)diag::Severity::Error, "type argument %0 cannot explicitly specify nullability", 0, SFINAE_SubstitutionFailure, false, true, 21)
DIAG(err_objc_type_arg_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "no type or protocol named %0", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_arg_missing_star, CLASS_ERROR, (unsigned)diag::Severity::Error, "type argument %0 must be a pointer (requires a '*')", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_arg_not_id_compatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "type argument %0 is neither an Objective-C object nor a block type", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_objc_type_arg_qualified, CLASS_ERROR, (unsigned)diag::Severity::Error, "type argument %0 cannot be qualified with '%1'", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_args_and_protocols, CLASS_ERROR, (unsigned)diag::Severity::Error, "angle brackets contain both a %select{type|protocol}0 (%1) and a %select{protocol|type}0 (%2)", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_args_non_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "type arguments cannot be applied to non-class type %0", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_args_non_parameterized_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "type arguments cannot be applied to non-parameterized class %0", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_args_specialized_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "type arguments cannot be applied to already-specialized class type %0", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_args_wrong_arity, CLASS_ERROR, (unsigned)diag::Severity::Error, "too %select{many|few}0 type arguments for class %1 (have %2, expected %3)", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_arity_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{forward class declaration|class definition|category|extension}0 has too %select{few|many}1 type parameters (expected %2, have %3)", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_bound_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "type bound %0 for type parameter %1 conflicts with %select{implicit|previous}2 bound %3%select{for type parameter %5|}4", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_bound_explicit_nullability, CLASS_ERROR, (unsigned)diag::Severity::Error, "type parameter %0 bound %1 cannot explicitly specify nullability", 0, SFINAE_SubstitutionFailure, false, true, 21)
DIAG(err_objc_type_param_bound_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing type bound %0 for type parameter %1 in %select{@interface|@class}2", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_bound_missing_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing '*' in type bound %0 for type parameter %1", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_bound_nonobject, CLASS_ERROR, (unsigned)diag::Severity::Error, "type bound %0 for type parameter %1 is not an Objective-C pointer type", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_bound_qualified, CLASS_ERROR, (unsigned)diag::Severity::Error, "type bound %1 for type parameter %0 cannot be qualified with '%2'", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_redecl, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration of type parameter %0", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_type_param_variance_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{in|co|contra}0variant type parameter %1 conflicts with previous %select{in|co|contra}2variant type parameter %3", 0, SFINAE_SubstitutionFailure, false, true, 22)
DIAG(err_objc_var_decl_inclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot declare variable inside @interface or @protocol", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_objc_variable_sized_type_not_at_end, CLASS_ERROR, (unsigned)diag::Severity::Error, "field %0 with variable sized type %1 is not at the end of class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_object_cannot_be_passed_returned_by_value, CLASS_ERROR, (unsigned)diag::Severity::Error, "interface type %1 cannot be %select{returned|passed}0 by value; did you forget * in %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_offsetof_array_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "offsetof requires array type, %0 invalid", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_offsetof_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot compute offset of bit-field %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_offsetof_field_of_virtual_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid application of 'offsetof' to a field of a virtual base", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_offsetof_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "offsetof of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_offsetof_record_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "offsetof requires struct, union, or class type, %0 invalid", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_omp_aligned_expected_array_or_ptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument of aligned clause should be array%select{ or pointer|, pointer, reference to array or reference to pointer}1, not %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_ambiguous_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous conversion from type %0 to an integral or unscoped enumeration type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_argument_type_isdeviceptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected pointer, array, reference to pointer, or reference to array in 'is_device_ptr clause'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_array_section_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "OpenMP array section is not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_at_least_one_motion_clause_required, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected at least one 'to' clause or 'from' clause specified to '#pragma omp target update'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_atomic_capture_not_compound_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for 'atomic capture' must be a compound statement of form '{v = x; x binop= expr;}', '{x binop= expr; v = x;}', '{v = x; x = x binop expr;}', '{v = x; x = expr binop x;}', '{x = x binop expr; v = x;}', '{x = expr binop x; v = x;}' or '{v = x; x = expr;}', '{v = x; x++;}', '{v = x; ++x;}', '{++x; v = x;}', '{x++; v = x;}', '{v = x; x--;}', '{v = x; --x;}', '{--x; v = x;}', '{x--; v = x;}' where x is an l-value expression with scalar type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_atomic_capture_not_expression_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for 'atomic capture' must be an expression statement of form 'v = ++x;', 'v = --x;', 'v = x++;', 'v = x--;', 'v = x binop= expr;', 'v = x = x binop expr' or 'v = x = expr binop x', where x and v are both l-value expressions with scalar type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_atomic_not_expression_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for 'atomic' must be an expression statement of form '++x;', '--x;', 'x++;', 'x--;', 'x binop= expr;', 'x = x binop expr' or 'x = expr binop x', where x is an l-value expression with scalar type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_atomic_read_not_expression_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for 'atomic read' must be an expression statement of form 'v = x;', where v and x are both lvalue expressions with scalar type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_atomic_several_clauses, CLASS_ERROR, (unsigned)diag::Severity::Error, "directive '#pragma omp atomic' cannot contain more than one 'read', 'write', 'update' or 'capture' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_atomic_update_not_expression_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for 'atomic update' must be an expression statement of form '++x;', '--x;', 'x++;', 'x--;', 'x binop= expr;', 'x = x binop expr' or 'x = expr binop x', where x is an l-value expression with scalar type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_atomic_write_not_expression_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for 'atomic write' must be an expression statement of form 'x = expr;', where x is a lvalue expression with scalar type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_bit_fields_forbidden_in_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "bit fields cannot be used to specify storage in a '%0' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_clause_floating_type_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "arguments of OpenMP clause '%0' with bitwise operators cannot be of floating type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_clause_not_arithmetic_type_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "arguments of OpenMP clause '%0' for 'min' or 'max' must be of %select{scalar|arithmetic}1 type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_const_list_item, CLASS_ERROR, (unsigned)diag::Severity::Error, "const-qualified list item cannot be %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_const_not_mutable_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "const-qualified variable without mutable fields cannot be %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_const_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "const-qualified variable cannot be %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_critical_with_hint, CLASS_ERROR, (unsigned)diag::Severity::Error, "constructs with the same name must have a 'hint' clause with the same value", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_mapper_redefinition, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of user-defined mapper for type %0 with name %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_mapper_wrong_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "only variable %0 is allowed in map clauses of this 'omp declare mapper' directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_reduction_redefinition, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of user-defined reduction for type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_target_multiple, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 appears multiple times in clauses on the same declare target directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_target_to_and_link, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 must not appear in both clauses 'to' and 'link'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_variant_diff, CLASS_ERROR, (unsigned)diag::Severity::Error, "function with '#pragma omp declare variant' has a different %select{calling convention|return type|constexpr specification|inline specification|storage class|linkage}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_variant_doesnt_support, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma omp declare variant' does not support %select{function templates|virtual functions|deduced return types|constructors|destructors|deleted functions|defaulted functions|constexpr functions|consteval function}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_variant_incompat_attributes, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma omp declare variant' is not compatible with any target-specific attributes", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_declare_variant_incompat_types, CLASS_ERROR, (unsigned)diag::Severity::Error, "variant in '#pragma omp declare variant' with type %0 is incompatible with type %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_defaultmap_no_attr_for_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 must have explicitly specified data sharing attributes, data mapping attributes, or in an is_device_ptr clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_depend_clause_thread_simd, CLASS_ERROR, (unsigned)diag::Severity::Error, "'depend' clauses cannot be mixed with '%0' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_depend_sink_expected_loop_iteration, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected%select{| %1}0 loop iteration variable", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_depend_sink_expected_plus_minus, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '+' or '-' operation", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_depend_sink_source_not_allowed, CLASS_ERROR, (unsigned)diag::Severity::Error, "'depend(%select{source|sink:vec}0)' clause%select{|s}0 cannot be mixed with 'depend(%select{sink:vec|source}0)' clause%select{s|}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_depend_sink_unexpected_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected expression: number of expressions is larger than the number of associated loops", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_depend_zero_length_array_section_not_allowed, CLASS_ERROR, (unsigned)diag::Severity::Error, "zero-length array section is not allowed in 'depend' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_device_type_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'device_type(%0)' does not match previously specified 'device_type(%1)' for the same declaration", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_duplicate_map_type_modifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "same map type modifier has been specified more than once", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_access_to_data_field, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected access to data field", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_addressable_lvalue_or_array_item, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected addressable lvalue expression, array element or array section", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_base_var_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected variable name as a base of the array %select{subscript|section}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_int_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a reference to an integer-typed parameter", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_named_var_member_or_array_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected expression containing only member accesses and/or array sections based on named variables", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_predefined_allocator, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected one of the predefined allocators for the variables with the static storage: 'omp_default_mem_alloc', 'omp_large_cap_mem_alloc', 'omp_const_mem_alloc', 'omp_high_bw_mem_alloc', 'omp_low_lat_mem_alloc', 'omp_cgroup_mem_alloc', 'omp_pteam_mem_alloc' or 'omp_thread_mem_alloc'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_private_copy_for_allocate, CLASS_ERROR, (unsigned)diag::Severity::Error, "the referenced item is not found in any private clause on the same directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_uniform_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a reference to a parameter specified in a 'uniform' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_var_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not a global variable, static local variable or static data member", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_var_arg_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not a global variable, static local variable or static data member; did you mean %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_var_name_member_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected variable name%select{| or data member of current class}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_expected_var_name_member_expr_or_array_item, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected variable name%select{|, data member of current class}0, array element or array section", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_explicit_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression requires explicit conversion from %0 to %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_firstprivate_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "a firstprivate variable with incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_function_expected, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma omp declare %select{simd|variant}0' can only be applied to functions", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_function_in_link_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "function name is not allowed in 'link' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_global_var_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "arguments of '#pragma omp %0' must have %select{global storage|static storage duration}1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_grainsize_num_tasks_mutually_exclusive, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' and '%1' clause are mutually exclusive and may not appear on the same directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_hint_clause_no_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "the name of the construct must be specified in presence of 'hint' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_in_reduction_not_task_reduction, CLASS_ERROR, (unsigned)diag::Severity::Error, "in_reduction variable must appear in a task_reduction clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression has incomplete class type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_invalid_map_this_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid 'this' expression on 'map' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_invalid_map_type_for_directive, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{map type '%1' is not allowed|map type must be specified}0 for '#pragma omp %2'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_invalid_mapper, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find a valid user-defined mapper for type %0 with name %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_invalid_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma omp %0' directive must appear only in file scope", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_invalid_target_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 used in declare target directive is not a variable or a function name", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_invariant_or_linear_dependency, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected loop invariant expression or '<invariant1> * %0 + <invariant2>' kind of expression", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_lambda_capture_in_declare_target_not_to, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable captured in declare target region must appear in a to clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_lastprivate_conditional_non_scalar, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected list item of scalar type in 'lastprivate' clause with 'conditional' modifier", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_lastprivate_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "a lastprivate variable with incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_linear_distribute_var_non_loop_iteration, CLASS_ERROR, (unsigned)diag::Severity::Error, "only loop iteration variables are allowed in 'linear' clause in distribute directives", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_linear_expected_int_or_ptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument of a linear clause should be of integral or pointer type, not %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_linear_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "a linear variable with incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_linear_ordered, CLASS_ERROR, (unsigned)diag::Severity::Error, "'linear' clause cannot be specified along with 'ordered' clause with a parameter", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_local_var_in_threadprivate_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable with local storage in initial value of threadprivate variable", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_cannot_use_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' statement cannot be used in OpenMP for loop", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_diff_cxx, CLASS_ERROR, (unsigned)diag::Severity::Error, "could not calculate number of iterations calling 'operator-' with upper and lower loop bounds", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_incr_not_compatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "increment expression must cause %0 to %select{decrease|increase}1 on each iteration of OpenMP for loop", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_not_canonical_cond, CLASS_ERROR, (unsigned)diag::Severity::Error, "condition of OpenMP for loop must be a relational comparison ('<', '<=', '>', %select{or '>='|'>=', or '!='}0) of loop variable %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_not_canonical_incr, CLASS_ERROR, (unsigned)diag::Severity::Error, "increment clause of OpenMP for loop must perform simple addition or subtraction on loop variable %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_not_canonical_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "initialization clause of OpenMP for loop is not in canonical form ('var = init' or 'T var = init')", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_var_dsa, CLASS_ERROR, (unsigned)diag::Severity::Error, "loop iteration variable in the associated loop of 'omp %1' directive may not be %0, predetermined as %2", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_loop_variable_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable must be of integer or %select{pointer|random access iterator}0 type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_map_shared_storage, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable already marked as mapped in current construct", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_mapper_wrong_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "mapper type must be of struct, union or class type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_multiple_array_items_in_map_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple array elements associated with the same variable are not allowed in map clauses of the same construct", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_negative_expression_in_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument to '%0' clause must be a %select{non-negative|strictly positive}1 integer value", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_no_clause_for_directive, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected at least one %0 clause for '#pragma omp %1'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_no_dsa_for_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 must have explicitly specified data sharing attributes", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_no_more_if_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "no more 'if' clause is allowed", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_not_for, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{statement after '#pragma omp %1' must be a for loop|expected %2 for loops after '#pragma omp %1'%select{|, but found only %4}3}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_not_integral, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression must have integral or unscoped enumeration type, not %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_not_resolved_reduction_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "unable to resolve declare reduction construct for type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_once_referenced, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable can appear only once in OpenMP '%0' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_once_referenced_in_target_update, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable can appear only once in OpenMP 'target update' construct", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_one_defaultmap_each_category, CLASS_ERROR, (unsigned)diag::Severity::Error, "at most one defaultmap clause for each variable-category can appear on the directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_ordered_directive_with_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "'ordered' directive %select{without any clauses|with 'threads' clause}0 cannot be closely nested inside ordered region with specified parameter", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_ordered_directive_without_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "'ordered' directive with 'depend' clause cannot be closely nested inside ordered region without specified parameter", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_ordered_simd, CLASS_ERROR, (unsigned)diag::Severity::Error, "'ordered' clause with a parameter can not be specified in '#pragma omp %0' directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_original_storage_is_shared_and_does_not_contain, CLASS_ERROR, (unsigned)diag::Severity::Error, "original storage of expression in data environment is shared but data environment do not fully contain mapped expression storage", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_orphaned_device_directive, CLASS_ERROR, (unsigned)diag::Severity::Error, "orphaned 'omp %0' directives are prohibited; perhaps you forget to enclose the directive into a %select{|||target |teams }1region?", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_orphaned_section_directive, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{orphaned 'omp section' directives are prohibited, it|'omp section' directive}0 must be closely nested to a sections region%select{|, not a %1 region}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_parallel_reduction_in_task_firstprivate, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument of a reduction clause of a %0 construct must not appear in a firstprivate clause on a task construct", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_parallel_sections_not_compound_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for '#pragma omp parallel sections' must be a compound statement", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_parallel_sections_substmt_not_section, CLASS_ERROR, (unsigned)diag::Severity::Error, "statement in 'omp parallel sections' directive must be enclosed into a section region", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_param_or_this_in_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected reference to one of the parameters of function %0%select{| or 'this'}1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_parent_cancel_region_nowait, CLASS_ERROR, (unsigned)diag::Severity::Error, "parent region for 'omp %select{cancellation point|cancel}0' construct cannot be nowait", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_parent_cancel_region_ordered, CLASS_ERROR, (unsigned)diag::Severity::Error, "parent region for 'omp %select{cancellation point|cancel}0' construct cannot be ordered", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_pointer_mapped_along_with_derived_section, CLASS_ERROR, (unsigned)diag::Severity::Error, "pointer cannot be mapped along with a section derived from itself", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_private_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "a private variable with incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_prohibited_region, CLASS_ERROR, (unsigned)diag::Severity::Error, "region cannot be%select{| closely}0 nested inside '%1' region%select{|; perhaps you forget to enclose 'omp %3' directive into a parallel region?|; perhaps you forget to enclose 'omp %3' directive into a for or a parallel for region with 'ordered' clause?|; perhaps you forget to enclose 'omp %3' directive into a target region?|; perhaps you forget to enclose 'omp %3' directive into a teams region?}2", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_prohibited_region_atomic, CLASS_ERROR, (unsigned)diag::Severity::Error, "OpenMP constructs may not be nested inside an atomic region", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_prohibited_region_critical_same_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot nest 'critical' regions having the same name %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_prohibited_region_simd, CLASS_ERROR, (unsigned)diag::Severity::Error, "OpenMP constructs may not be nested inside a simd region%select{| except for ordered simd, simd or atomic directive}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_id_not_compatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "list item of type %0 is not valid for specified reduction operation: unable to provide default initialization value", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_identifier_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "in_reduction variable must have the same reduction operation as in a task_reduction clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_in_task, CLASS_ERROR, (unsigned)diag::Severity::Error, "reduction variables may not be accessed in an explicit task", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "a reduction list item with incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_non_addressable_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected addressable reduction item for the task-based directives", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_ref_type_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument of OpenMP clause '%0' must reference the same object in all threads", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_vla_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot generate code for reduction on %select{|array section, which requires a }0variable length array", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_with_nogroup, CLASS_ERROR, (unsigned)diag::Severity::Error, "'reduction' clause cannot be used with 'nogroup' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_reduction_wrong_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "reduction type cannot be %select{qualified with 'const', 'volatile' or 'restrict'|a function|a reference|an array}0 type", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_ref_type_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "arguments of '#pragma omp %0' cannot be of reference type %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_region_not_file_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "directive must be at file or namespace scope", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_required_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 variable must be %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_requires_clause_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "Only one %0 clause can appear on a requires directive in a single translation unit", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_same_pointer_dereferenced, CLASS_ERROR, (unsigned)diag::Severity::Error, "same pointer dereferenced in multiple different ways in map clause expressions", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_schedule_nonmonotonic_ordered, CLASS_ERROR, (unsigned)diag::Severity::Error, "'schedule' clause with 'nonmonotonic' modifier cannot be specified if an 'ordered' clause is specified", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_schedule_nonmonotonic_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "'nonmonotonic' modifier can only be specified with 'dynamic' or 'guided' schedule kind", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_section_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "section of pointer to function type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_section_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "section of pointer to incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_section_length_negative, CLASS_ERROR, (unsigned)diag::Severity::Error, "section length is evaluated to a negative value %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_section_length_undefined, CLASS_ERROR, (unsigned)diag::Severity::Error, "section length is unspecified and cannot be inferred because subscripted value is %select{not an array|an array of unknown bound}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_section_not_subset_of_array, CLASS_ERROR, (unsigned)diag::Severity::Error, "array section must be a subset of the original array", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_sections_not_compound_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "the statement for '#pragma omp sections' must be a compound statement", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_sections_substmt_not_section, CLASS_ERROR, (unsigned)diag::Severity::Error, "statement in 'omp sections' directive must be enclosed into a section region", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_simd_region_cannot_use_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' statement cannot be used in OpenMP simd region", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_single_copyprivate_with_nowait, CLASS_ERROR, (unsigned)diag::Severity::Error, "the 'copyprivate' clause must not be used with the 'nowait' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_single_decl_in_declare_simd_variant, CLASS_ERROR, (unsigned)diag::Severity::Error, "single declaration is expected after 'declare %select{simd|variant}0' directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_stmt_depends_on_loop_counter, CLASS_ERROR, (unsigned)diag::Severity::Error, "the loop %select{initializer|condition}0 expression depends on the current loop control variable", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_target_before_requires, CLASS_ERROR, (unsigned)diag::Severity::Error, "target region encountered before requires directive with '%0' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_target_contains_not_only_teams, CLASS_ERROR, (unsigned)diag::Severity::Error, "target construct with nested teams region contains statements outside of the teams construct", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_threadprivate_in_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "threadprivate variables are not allowed in '%0' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_threadprivate_in_target, CLASS_ERROR, (unsigned)diag::Severity::Error, "threadprivate variables cannot be used in target constructs", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_threadprivate_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "threadprivate variable with incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_typecheck_section_not_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "array section %select{lower bound|length}0 is not an integer", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_typecheck_section_value, CLASS_ERROR, (unsigned)diag::Severity::Error, "subscripted value is not an array or pointer", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_unexpected_clause_value, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected %0 in OpenMP clause '%1'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_unexpected_schedule_modifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "modifier '%0' cannot be used along with modifier '%1'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_union_type_not_allowed, CLASS_ERROR, (unsigned)diag::Severity::Error, "mapping of union members is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_unknown_reduction_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "incorrect reduction identifier, expected one of '+', '-', '*', '&', '|', '^', '&&', '||', 'min' or 'max' or declare reduction for type %0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_unnamed_if_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected%select{| one of}0 %1 directive name modifier%select{|s}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_unsupported_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "host requires %0 bit size %1 type support, but device '%2' does not support it", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_used_in_clause_twice, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{a variable|a parameter|'this'}0 cannot appear in more than one %1 clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_usedeviceptr_not_a_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected pointer or reference to pointer in 'use_device_ptr' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_var_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma omp %0' must appear in the scope of the %q1 variable declaration", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_var_thread_local, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 cannot be threadprivate because it is %select{thread-local|a global named register variable}1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_var_used, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma omp %0' must precede all references to variable %q1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_variable_in_given_clause_and_dsa, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 variable cannot be in a %1 clause in '#pragma omp %2' directive", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_variably_modified_type_not_supported, CLASS_ERROR, (unsigned)diag::Severity::Error, "arguments of OpenMP clause '%0' in '#pragma omp %2' directive cannot be of variably-modified type %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_cancel_region, CLASS_ERROR, (unsigned)diag::Severity::Error, "one of 'for', 'parallel', 'sections' or 'taskgroup' is expected", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_dependency_iterator_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an integer or a pointer type of the outer loop counter '%0' for non-rectangular nests", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_device_function_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "function with 'device_type(%0)' is not available on %select{device|host}1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_dsa, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 variable cannot be %1", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_if_directive_name_modifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "directive name modifier '%0' is not allowed for '#pragma omp %1'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_linear_modifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected %select{'val' modifier|one of 'ref', val' or 'uval' modifiers}0", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_linear_modifier_non_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable of non-reference type %0 can be used only with 'val' modifier, but used with '%1'", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_ordered_loop_count, CLASS_ERROR, (unsigned)diag::Severity::Error, "the parameter of the 'ordered' clause must be greater than or equal to the parameter of the 'collapse' clause", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_simdlen_safelen_values, CLASS_ERROR, (unsigned)diag::Severity::Error, "the value of 'simdlen' parameter must be less than or equal to the value of the 'safelen' parameter", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_omp_wrong_var_in_declare_reduction, CLASS_ERROR, (unsigned)diag::Severity::Error, "only %select{'omp_priv' or 'omp_orig'|'omp_in' or 'omp_out'}0 variables are allowed in %select{initializer|combiner}0 expression", 0, SFINAE_SubstitutionFailure, false, true, 11)
DIAG(err_only_annotate_after_access_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "access specifier can only have annotation attributes", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_only_constructors_take_base_inits, CLASS_ERROR, (unsigned)diag::Severity::Error, "only constructors take base initializers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_only_enums_have_underlying_types, CLASS_ERROR, (unsigned)diag::Severity::Error, "only enumeration types have underlying types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_addrspace_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "variables in the %0 address space can only be declared in the outermost scope of a kernel function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_atomic_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "atomic variable can be %select{assigned|initialized}0 to a variable only in global address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_bitfields, CLASS_ERROR, (unsigned)diag::Severity::Error, "bit-fields are not supported in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_block_ref_block, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot refer to a block inside block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_block_storage_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "the __block storage type is not permitted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_builtin_expected_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal call to %0, expected %1 argument type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_builtin_pipe_arg_num, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid number of arguments to function: %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_builtin_pipe_first_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "first argument to %0 must be a pipe type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_builtin_pipe_invalid_access_modifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid pipe access modifier (expecting %0)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_builtin_pipe_invalid_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid argument type to function %0 (expecting %1 having %2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_builtin_to_addr_arg_num, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid number of arguments to function: %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_builtin_to_addr_invalid_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid argument %0 to function: %1, expecting a generic pointer argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_cast_non_zero_to_event_t, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast non-zero value '%0' to 'event_t'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_cast_to_half, CLASS_ERROR, (unsigned)diag::Severity::Error, "casting to type %0 is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_constant_no_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable in constant address space must be initialized", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_enqueue_kernel_blocks_no_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "blocks with parameters are not accepted in this prototype of enqueue_kernel call", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_enqueue_kernel_blocks_non_local_void_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "blocks used in enqueue_kernel call are expected to have parameters of type 'local void*'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_enqueue_kernel_incorrect_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal call to enqueue_kernel, incorrect argument types", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_enqueue_kernel_invalid_local_size_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal call to enqueue_kernel, parameter needs to be specified as integer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_enqueue_kernel_local_size_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "mismatch in number of block parameters and local size arguments passed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_ext_vector_component_invalid_length, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector component access has invalid length %0.  Supported: 1,2,3,4,8,16.", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_extern_block_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid block variable declaration - using 'extern' storage class is disallowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_function_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "pointers to functions are not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_function_variable, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-kernel function|function scope}0 variable cannot be declared in %1 address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_global_invalid_addr_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{program scope|static local|extern}0 variable must reside in %1 address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_half_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaring variable of type %0 is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_half_load_store, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{loading directly from|assigning directly to}0 pointer to type %1 requires cl_khr_fp16. Use vector data %select{load|store}0 builtin functions instead", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_half_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaring function parameter of type %0 is not allowed; did you forget * ?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_implicit_function_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "implicit declaration of function %0 is invalid in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_implicit_vector_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "implicit conversions between vector types (%0 and %1) are not permitted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_invalid_access_qualifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "access qualifier can only be used for pipe and image type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_invalid_block_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid block variable declaration - must be %select{const qualified|initialized}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_invalid_read_write, CLASS_ERROR, (unsigned)diag::Severity::Error, "access qualifier %0 can not be used for %1 %select{|prior to OpenCL version 2.0}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_invalid_return, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaring function return value of type %0 is not allowed %select{; did you forget * ?|}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_invalid_type_array, CLASS_ERROR, (unsigned)diag::Severity::Error, "array of %0 type is invalid in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_kernel_attr, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %0 can only be applied to an OpenCL kernel function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_multiple_access_qualifiers, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple access qualifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_no_main, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{function|kernel}0 cannot be called 'main'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_nonconst_global_sampler, CLASS_ERROR, (unsigned)diag::Severity::Error, "global sampler requires a const or constant address space qualifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_pointer_to_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "pointer to type %0 is invalid in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_ptrptr_kernel_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel parameter cannot be declared as a pointer to a pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_requires_extension, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of %select{type|declaration}0 %1 requires %2 extension to be enabled", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_return_value_with_address_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "return value cannot be qualified with address space", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_scalar_type_rank_greater_than_vector_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "scalar operand type has greater rank than the type of the vector element. (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_sizeof_alignof_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid application of '%select{sizeof|alignof|vec_step|__builtin_omp_required_simd_align|__alignof}0' to a void type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_taking_address_capture, CLASS_ERROR, (unsigned)diag::Severity::Error, "taking address of a capture is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_ternary_with_block, CLASS_ERROR, (unsigned)diag::Severity::Error, "block type cannot be used as expression in ternary expression in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_type_can_only_be_used_as_function_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 can only be used as a function parameter in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_type_struct_or_union_field, CLASS_ERROR, (unsigned)diag::Severity::Error, "the %0 type cannot be used to declare a structure or union field", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_variadic_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid prototype, variadic arguments are not allowed in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_opencl_vla, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable length arrays are not supported in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_openclcxx_placement_new, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of placement new requires explicit declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_openmp_default_simd_align_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid application of '__builtin_omp_required_simd_align' to an expression, only type is allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_arrow_circular, CLASS_ERROR, (unsigned)diag::Severity::Error, "circular pointer delegation detected", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_arrow_depth_exceeded, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of 'operator->' on type %0 would invoke a sequence of more than %1 'operator->' calls", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_delete_dependent_param_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot take a dependent type as first parameter; use %1 instead", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_delete_param_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "first parameter of %0 must have type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_default_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter of %0 cannot have a default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_delete_declared_in_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be declared inside a namespace", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_delete_declared_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be declared static in global scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_delete_dependent_result_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot have a dependent return type; use %1 instead", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_delete_invalid_result_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 must return type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_delete_template_too_few_parameters, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 template must have at least two parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_delete_too_few_parameters, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 must have at least one parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_dependent_param_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot take a dependent type as first parameter; use size_t (%1) instead", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_new_param_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 takes type size_t (%1) as first parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_overload_default_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter of overloaded %0 cannot have a default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_overload_must_be, CLASS_ERROR, (unsigned)diag::Severity::Error, "overloaded %0 must be a %select{unary|binary|unary or binary}2 operator (has %1 parameter%s1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_overload_must_be_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "overloaded %0 must be a non-static member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_overload_needs_class_or_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "overloaded %0 must have at least one parameter of class or enumeration type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_overload_post_incdec_must_be_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter of overloaded post-%select{increment|decrement}1 operator must have type 'int' (not %0)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_overload_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "overloaded %0 cannot be a static member function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_operator_overload_variadic, CLASS_ERROR, (unsigned)diag::Severity::Error, "overloaded %0 cannot be variadic", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_os_log_argument_too_big, CLASS_ERROR, (unsigned)diag::Severity::Error, "os_log() argument %0 is too big (%1 bytes, max %2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_os_log_format_not_string_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "os_log() format argument is not a string constant", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_out_of_line_default_deletes, CLASS_ERROR, (unsigned)diag::Severity::Error, "defaulting this %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 would delete it after its first declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_out_of_line_qualified_id_type_names_constructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "qualified reference to %0 is a constructor name rather than a %select{template name|type}1 in this context", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_overflow_builtin_must_be_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "operand argument to overflow builtin must be an integer (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_overflow_builtin_must_be_ptr_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "result argument to overflow builtin must be a pointer to a non-const integer (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_override_exception_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception specification of overriding function is more lax than base version", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_ambiguous_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to %0 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_ambiguous_conversion_in_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous conversion for %select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_ambiguous_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to constructor of %0 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_ambiguous_member_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to member function %0 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_ambiguous_object_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to object of type %0 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_ambiguous_oper_binary, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of overloaded operator '%0' is ambiguous (with operand types %1 and %2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_ambiguous_oper_unary, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of overloaded operator '%0' is ambiguous (operand type %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to deleted function %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_comparison, CLASS_ERROR, (unsigned)diag::Severity::Error, "object of type %0 cannot be compared because its %1 is implicitly deleted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_conversion_in_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 uses deleted function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to deleted constructor of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_member_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to deleted member function %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_object_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to deleted function call operator in type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_oper, CLASS_ERROR, (unsigned)diag::Severity::Error, "overload resolution selected deleted operator '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_special_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to implicitly-deleted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor|function}0 of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_deleted_special_oper, CLASS_ERROR, (unsigned)diag::Severity::Error, "object of type %0 cannot be %select{constructed|copied|moved|assigned|assigned|destroyed}1 because its %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}1 is implicitly deleted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_diff_return_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "functions that differ only in their return type cannot be overloaded", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_conversion_in_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot convert %1 to %2 without a conversion operator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_oper, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 does not provide a %select{subscript|call}1 operator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_conversion_in_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching conversion for %select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_function_in_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching function for call to %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_function_in_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching constructor for initialization of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_literal_operator, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching literal operator for call to %0%select{| with argument of type %2| with arguments of types %2 and %3}1%select{| or 'const char *'}4%select{|, and no matching literal operator template}5", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_member_function_in_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching member function for call to %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_object_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "no matching function for call to object of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_oper, CLASS_ERROR, (unsigned)diag::Severity::Error, "no viable overloaded '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_no_viable_subscript, CLASS_ERROR, (unsigned)diag::Severity::Error, "no viable overloaded operator[] for type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_rewrite_equalequal_not_bool, CLASS_ERROR, (unsigned)diag::Severity::Error, "return type %0 of selected 'operator==' function for rewritten '%1' comparison is not 'bool'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_static_nonstatic_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "static and non-static member functions with the same parameter types cannot be overloaded", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ovl_unresolvable, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to %select{overloaded|multiversioned}1 function could not be resolved; did you mean to call it%select{| with no arguments}0?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ownership_returns_index_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'ownership_returns' attribute index does not match; here it is %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ownership_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute only applies to %select{pointer|integer}1 arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pack_expansion_length_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "pack expansion contains parameter packs %0 and %1 that have different lengths (%2 vs. %3)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pack_expansion_length_conflict_multilevel, CLASS_ERROR, (unsigned)diag::Severity::Error, "pack expansion contains parameter pack %0 that has a different length (%1 vs. %2) from outer parameter packs", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pack_expansion_length_conflict_partial, CLASS_ERROR, (unsigned)diag::Severity::Error, "pack expansion contains parameter pack %0 that has a different length (at least %1 vs. %2) from outer parameter packs", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pack_expansion_member_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "pack expansion for initialization of member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pack_expansion_without_parameter_packs, CLASS_ERROR, (unsigned)diag::Severity::Error, "pack expansion does not contain any unexpanded parameter packs", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "C does not support default arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_member_template_redecl, CLASS_ERROR, (unsigned)diag::Severity::Error, "default arguments cannot be added to an out-of-line definition of a member of a %select{class template|class template partial specialization|nested class in a template}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing default argument on parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_missing_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing default argument on parameter %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_nonfunc, CLASS_ERROR, (unsigned)diag::Severity::Error, "default arguments can only be specified for parameters in a function declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_on_parameter_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter pack cannot have a default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_redefinition, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_references_local, CLASS_ERROR, (unsigned)diag::Severity::Error, "default argument references local variable %0 of enclosing function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_references_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "default argument references parameter %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_references_this, CLASS_ERROR, (unsigned)diag::Severity::Error, "default argument references 'this'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_default_argument_template_redecl, CLASS_ERROR, (unsigned)diag::Severity::Error, "default arguments cannot be added to a function template that has already been declared", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_param_with_void_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument may not have 'void' type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_parameter_name_omitted, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter name omitted", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_parameter_shadow_capture, CLASS_ERROR, (unsigned)diag::Severity::Error, "a lambda parameter cannot shadow an explicitly captured entity", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_parameters_retval_cannot_have_fp16_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{parameters|function return value}0 cannot have __fp16 type; did you forget * ?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_parens_pointer_member_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot parenthesize the name of a method when forming a member pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_partial_spec_args_match_primary_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class|variable}0 template partial specialization does not specialize any template argument; to %select{declare|define}1 the primary template, remove the template argument list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_partial_spec_fully_specialized, CLASS_ERROR, (unsigned)diag::Severity::Error, "partial specialization of %0 does not use any of its template parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_partial_spec_ordering_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous partial specializations of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_partial_spec_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "class template partial specialization %0 cannot be redeclared", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_partial_specialization_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "partial specialization cannot be declared as a friend", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_placeholder_constraints_not_satisfied, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduced type %0 does not satisfy %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_placement_new_non_placement_delete, CLASS_ERROR, (unsigned)diag::Severity::Error, "'new' expression with placement arguments refers to non-placement 'operator delete'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pointer_to_member_call_drops_quals, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to pointer to member function of type %0 drops '%1' qualifier%s2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pointer_to_member_oper_value_classify, CLASS_ERROR, (unsigned)diag::Severity::Error, "pointer-to-member function type %0 can only be called on an %select{rvalue|lvalue}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pointer_to_member_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid use of pointer to member type after %select{.*|->*}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ppc_builtin_only_on_pwr7, CLASS_ERROR, (unsigned)diag::Severity::Error, "this builtin is only valid on POWER7 or later CPUs", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_attr_attr_no_push, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma clang attribute' attribute with no matching '#pragma clang attribute push'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_attribute_invalid_matchers, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %0 can't be applied to %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_attribute_matcher_negated_subrule_contradicts_subrule, CLASS_ERROR, (unsigned)diag::Severity::Error, "negated attribute subject matcher sub-rule '%0' contradicts sub-rule '%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_attribute_matcher_subrule_contradicts_rule, CLASS_ERROR, (unsigned)diag::Severity::Error, "redundant attribute subject matcher sub-rule '%0'; '%1' already matches those declarations", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_attribute_no_pop_eof, CLASS_ERROR, (unsigned)diag::Severity::Error, "unterminated '#pragma clang attribute push' at end of file", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_attribute_stack_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma clang attribute %select{%1.|}0pop' with no matching '#pragma clang attribute %select{%1.|}0push'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_loop_compatibility, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{incompatible|duplicate}0 directives '%1' and '%2'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_loop_invalid_argument_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid argument of type %0; expected an integer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_loop_invalid_argument_value, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{invalid value '%0'; must be positive|value '%0' is too large}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_loop_precedes_nonloop, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a for, while, or do-while loop to follow '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_options_align_mac68k_target_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "mac68k alignment pragma is not supported on this target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_pop_visibility_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "#pragma visibility pop with no matching #pragma visibility push", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pragma_push_visibility_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "#pragma visibility push with no matching #pragma visibility pop", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_preserve_field_info_not_const, CLASS_ERROR, (unsigned)diag::Severity::Error, "__builtin_preserve_field_info argument %0 not a constant", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_preserve_field_info_not_field, CLASS_ERROR, (unsigned)diag::Severity::Error, "__builtin_preserve_field_info argument %0 not a field access", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_private_ivar_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable %0 is private", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_private_module_fragment_not_module, CLASS_ERROR, (unsigned)diag::Severity::Error, "private module fragment declaration with no preceding module declaration", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_private_module_fragment_not_module_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "private module fragment in module implementation unit", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_private_module_fragment_redefined, CLASS_ERROR, (unsigned)diag::Severity::Error, "private module fragment redefined", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_property_accessor_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of property %0 (%1) does not match type of accessor %2 (%3)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_found_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 found on object of type %1; did you mean to access it with the \".\" operator?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_function_in_objc_container, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of Objective-C property in function nested in Objective-C container not supported, move function outside its container", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_implemented, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 is already implemented", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_is_variably_modified, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 has a variably modified type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_ivar_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of property %0 (%1) does not match type of instance variable %2 (%3)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_method_unavailable, CLASS_ERROR, (unsigned)diag::Severity::Error, "property access is using %0 method which is unavailable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_not_as_forward_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 refers to an incomplete Objective-C class %1 (with no @interface available)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 not found on object of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_not_found_forward_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 cannot be found in forward class object %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_not_found_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 not found on object of type %1; did you mean %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_setter_ambiguous_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "synthesized properties %0 and %1 both claim setter %2 - use of this setter will cause unexpected behavior", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_property_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "property cannot have array or function type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_protected_ivar_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable %0 is protected", 0, SFINAE_AccessControl, false, true, 2)
DIAG(err_protocol_has_circular_dependency, CLASS_ERROR, (unsigned)diag::Severity::Error, "protocol has circular dependency", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_protocol_property_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %select{of type %1|with attribute '%1'|without attribute '%1'|with getter %1|with setter %1}0 was selected for synthesis", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pseudo_dtor_base_not_scalar, CLASS_ERROR, (unsigned)diag::Severity::Error, "object expression of non-scalar type %0 cannot be used in a pseudo-destructor expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pseudo_dtor_call_with_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to pseudo-destructor cannot have any arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pseudo_dtor_destructor_non_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not refer to a type name in pseudo-destructor expression; expected the name of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pseudo_dtor_type_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "the type of object expression %diff{($) does not match the type being destroyed ($)|does not match the type being destroyed}0,1 in pseudo-destructor expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_pure_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend declaration cannot have a pure-specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_catch_declarator, CLASS_ERROR, (unsigned)diag::Severity::Error, "exception declarator cannot be qualified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_friend_def, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend function definition cannot be qualified with '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_friend_no_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend declaration of %0 does not match any declaration in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_function_typeid, CLASS_ERROR, (unsigned)diag::Severity::Error, "type operand %0 of 'typeid' cannot have '%1' qualifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_member_nonclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "qualified member access refers to a member in %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_member_of_unrelated, CLASS_ERROR, (unsigned)diag::Severity::Error, "%q0 is not a member of class %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_objc_access, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{property|instance variable}0 access cannot be qualified with '%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_objc_catch_parm, CLASS_ERROR, (unsigned)diag::Severity::Error, "@catch parameter declarator cannot be qualified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_param_declarator, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter declarator cannot be qualified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_qualified_typedef_declarator, CLASS_ERROR, (unsigned)diag::Severity::Error, "typedef declarator cannot be qualified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_range_on_array_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot build range expression with array function parameter %0 since parameter with array type %1 is treated as pointer type %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_readonly_message_assignment, CLASS_ERROR, (unsigned)diag::Severity::Error, "assigning to 'readonly' return result of an Objective-C message not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_realimag_invalid_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid type %0 to %1 operator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_record_with_pointers_kernel_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{struct|union}0 kernel parameters may not contain pointers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_recursive_default_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "recursive evaluation of default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_recursive_superclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "trying to recursively use %0 as superclass of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redeclaration_different_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration of %0 with a different type%diff{: $ vs $|}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_different_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of %0 as different kind of symbol", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_different_namespace_alias, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of %0 as an alias for a different namespace", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_different_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of %0 with a different type%diff{: $ vs $|}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_different_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{typedef|type alias|type alias template}0 redefinition with different types%diff{ ($ vs $)|}1,2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_extern_inline, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of a 'extern inline' function %0 is not supported in %select{C99 mode|C++}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_of_enumerator, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of enumerator %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_of_label, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of label %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_redefinition_variably_modified_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "redefinition of %select{typedef|type alias}0 for variably-modified type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_array_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot refer to declaration with an array type inside block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_bad_target, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to %select{__device__|__global__|__host__|__host__ __device__}0 function %1 in %select{__device__|__global__|__host__|__host__ __device__}2 function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_bad_target_global_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to %select{__device__|__global__|__host__|__host__ __device__}0 function %1 in global initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_flexarray_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot refer to declaration of structure variable with flexible array member inside block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_init_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference initialization of type %0 with initializer of type %1 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_non_value, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not refer to a value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_qualifier_constructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "ref-qualifier '%select{&&|&}0' is not allowed on a constructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_qualifier_destructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "ref-qualifier '%select{&&|&}0' is not allowed on a destructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_qualifier_overload, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot overload a member function %select{without a ref-qualifier|with ref-qualifier '&'|with ref-qualifier '&&'}0 with a member function %select{without a ref-qualifier|with ref-qualifier '&'|with ref-qualifier '&&'}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ref_vm_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot refer to declaration with a variably modified type inside block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_bind_drops_quals, CLASS_ERROR, (unsigned)diag::Severity::Error, "binding reference %diff{of type $ to value of type $|to value}0,1 %select{drops %3 qualifier%plural{1:|2:|4:|:s}4|changes address space|not permitted due to incompatible qualifiers}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_bind_failed, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference %diff{to %select{type|incomplete type}1 $ could not bind to an %select{rvalue|lvalue}2 of type $|could not bind to %select{rvalue|lvalue}2 of incompatible type}0,3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_bind_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to type %0 cannot bind to an initializer list", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_bind_temporary_addrspace, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference of type %0 cannot bind to a temporary object because of address space mismatch", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_bind_to_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-const|volatile}0 reference cannot bind to bit-field%select{| %1}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_bind_to_vector_element, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-const|volatile}0 reference cannot bind to vector element", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_capture_with_reference_default, CLASS_ERROR, (unsigned)diag::Severity::Error, "'&' cannot precede a capture when the capture default is '&'", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_reference_has_multiple_inits, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference cannot be initialized with multiple values", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_pipe_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "pipes packet types cannot be of reference type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_to_function_with_unsatisfied_constraints, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid reference to function %0: constraints not satisfied", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_to_local_in_enclosing_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to local %select{variable|binding}1 %0 declared in enclosing %select{%3|block literal|lambda expression|context}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_to_void, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot form a reference to 'void'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_var_requires_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of reference variable %0 requires an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_reference_without_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference to type %0 requires an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_regparm_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declared with regparm(%0) attribute was previously declared %plural{0:without the regparm|:with the regparm(%1)}1 attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_repeat_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be repeated", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_require_constant_init_failed, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable does not have a constant initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_requires_expr_local_parameter_default_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "default arguments not allowed for parameters of a requires expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_requires_expr_parameter_referenced_in_evaluated_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "constraint variable %0 cannot be used in an evaluated context", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_restricted_superclass_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot subclass a class that was declared with the 'objc_subclassing_restricted' attribute", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_ret_local_block, CLASS_ERROR, (unsigned)diag::Severity::Error, "returning block that lives on the local stack", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_rethrow_used_outside_catch, CLASS_ERROR, (unsigned)diag::Severity::Error, "@throw (rethrow) used outside of a @catch block", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_return_block_has_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "void block should not return a value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_return_in_captured_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot return from %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_return_in_constructor_handler, CLASS_ERROR, (unsigned)diag::Severity::Error, "return in the catch of a function try block of a constructor is illegal", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_return_in_coroutine, CLASS_ERROR, (unsigned)diag::Severity::Error, "return statement not allowed in coroutine; did you mean 'co_return'?", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_return_init_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{void function|void method|constructor|destructor}1 %0 must not return a value", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_root_class_cannot_use_super, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot use 'super' because it is a root class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_rref_in_exception_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "rvalue reference type %0 is not allowed in exception specification", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sampler_argument_required, CLASS_ERROR, (unsigned)diag::Severity::Error, "sampler_t variable required - got %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sampler_initializer_not_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "sampler_t initialization requires 32-bit integer, not %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_second_argument_to_cwsc_not_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "second argument to __builtin_call_with_static_chain must be of pointer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_second_parameter_to_va_arg_abstract, CLASS_ERROR, (unsigned)diag::Severity::Error, "second argument to 'va_arg' is of abstract type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_second_parameter_to_va_arg_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "second argument to 'va_arg' is of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_section_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 causes a section type conflict with %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_seh_in_a_coroutine_with_cxx_exceptions, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use SEH '__try' in a coroutine when C++ exceptions are enabled", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_seh_try_outside_functions, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use SEH '__try' in blocks, captured regions, or Obj-C method decls", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_seh_try_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "SEH '__try' is not supported on this target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_selected_explicit_constructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "chosen constructor is explicit in copy-initialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_selector_element_const_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "selector element of type %0 cannot be a constant l-value expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_selector_element_not_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "selector element is not a valid lvalue", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_selector_element_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "selector element type %0 is not a valid object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_setter_type_void, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of setter must be void", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_shared_var_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "initialization is not supported for __shared__ variables.", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_shift_rhs_only_vector, CLASS_ERROR, (unsigned)diag::Severity::Error, "requested shift is a vector of type %0 but the first operand is not a vector (%1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_shufflevector_argument_too_large, CLASS_ERROR, (unsigned)diag::Severity::Error, "index for __builtin_shufflevector must be less than the total number of vector elements", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_shufflevector_nonconstant_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "index for __builtin_shufflevector must be a constant integer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sizeof_alignof_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid application of '%select{sizeof|alignof|vec_step|__builtin_omp_required_simd_align|__alignof}0' to a function type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sizeof_alignof_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid application of '%select{sizeof|alignof|vec_step|__builtin_omp_required_simd_align|__alignof}0' to an incomplete type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sizeof_alignof_typeof_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid application of '%select{sizeof|alignof|typeof}0' to bit-field", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sizeof_nonfragile_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "application of '%select{alignof|sizeof}1' to interface %0 is not supported on this architecture and platform", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sizeof_pack_no_pack_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not refer to the name of a parameter pack", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_sizeof_pack_no_pack_name_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not refer to the name of a parameter pack; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_spaceship_argument_narrowing, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument to 'operator<=>' %select{cannot be narrowed from type %1 to %2|evaluates to %1, which cannot be narrowed to type %2}0", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_spec_member_not_instantiated, CLASS_ERROR, (unsigned)diag::Severity::Error, "specialization of member %q0 does not specialize an instantiated member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_specialization_after_instantiation, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit specialization of %0 after instantiation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_specialization_not_primary_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot reference member of primary template because deduced class template specialization %0 is %select{instantiated from a partial|an explicit}1 specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_specialize_member_of_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot specialize %select{|(with 'template<>') }0a member of an unspecialized template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_standalone_class_nested_name_specifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "forward declaration of %select{class|struct|interface|union|enum}0 cannot have a nested name specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_assert_expression_is_not_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "static_assert expression is not an integral constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_assert_failed, CLASS_ERROR, (unsigned)diag::Severity::Error, "static_assert failed%select{ %1|}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_assert_requirement_failed, CLASS_ERROR, (unsigned)diag::Severity::Error, "static_assert failed due to requirement '%0'%select{ %2|}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_block_func, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declared in block scope cannot have 'static' storage class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_data_member_not_allowed_in_anon_struct, CLASS_ERROR, (unsigned)diag::Severity::Error, "static data member %0 not allowed in anonymous struct", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_data_member_not_allowed_in_local_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "static data member %0 not allowed in local class %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_data_member_reinitialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "static data member %0 already has an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_downcast_via_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast %0 to %1 via virtual base %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_function_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "variables in function scope cannot be declared static", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_illegal_in_new, CLASS_ERROR, (unsigned)diag::Severity::Error, "the 'static' modifier for the array size is not legal in new expressions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_kernel, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel functions cannot be declared static", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_main, CLASS_ERROR, (unsigned)diag::Severity::Error, "'main' is not allowed to be declared static", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_non_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "static declaration of %0 follows non-static declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_not_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "static member %0 cannot be a bit-field", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_out_of_line, CLASS_ERROR, (unsigned)diag::Severity::Error, "'static' can only be specified inside the class definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_static_overrides_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "'static' member function %0 overrides a virtual function in a base class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_statically_allocated_object, CLASS_ERROR, (unsigned)diag::Severity::Error, "interface type cannot be statically allocated", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_std_compare_type_not_supported, CLASS_ERROR, (unsigned)diag::Severity::Error, "standard library implementation of %0 is not supported; %select{member '%2' does not have expected form|member '%2' is missing|the type is not trivially copyable|the type does not have the expected form}1", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_std_type_trait_not_class_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "unsupported standard library implementation: 'std::%0' is not a class template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_stmt_attribute_invalid_on_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be applied to a declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_storage_class_for_static_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "static data member definition cannot specify a storage class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_storage_spec_on_catch_parm, CLASS_ERROR, (unsigned)diag::Severity::Error, "@catch parameter cannot have storage specifier '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_storageclass_invalid_for_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "storage class specified for a member declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_strong_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "existing instance variable %1 for strong property %0 may not be __weak", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_subscript_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "subscript of pointer to function type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_subscript_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "subscript of pointer to incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_subscript_nonfragile_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "subscript requires size of interface %0, which is not constant for this architecture and platform", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_super_in_lambda_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of '__super' inside a lambda is unsupported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_swift_abi_parameter_wrong_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' parameter must have pointer%select{| to unqualified pointer}1 type; type here is %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_swift_error_result_not_after_swift_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "'swift_error_result' parameter must follow 'swift_context' parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_swift_indirect_result_not_first, CLASS_ERROR, (unsigned)diag::Severity::Error, "'swift_indirect_result' parameters must be first parameters of function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_swift_param_attr_not_swiftcall, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' parameter can only be used with swiftcall calling convention", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_switch_explicit_conversion, CLASS_ERROR, (unsigned)diag::Severity::Error, "switch condition type %0 requires explicit conversion to %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_switch_incomplete_class_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "switch condition has incomplete class type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_switch_into_protected_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot jump from switch statement to this case label", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_switch_multiple_conversions, CLASS_ERROR, (unsigned)diag::Severity::Error, "multiple conversions from switch condition type %0 to an integral or enumeration type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_synthesize_category_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "@synthesize not allowed in a category's implementation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_synthesize_on_class_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "@synthesize not allowed on a class property %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_synthesize_variable_sized_ivar, CLASS_ERROR, (unsigned)diag::Severity::Error, "synthesized property with variable size type %0 requires an existing instance variable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_synthesizing_arc_weak_property_disabled, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot synthesize weak property in file using manual reference counting", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_synthesizing_arc_weak_property_no_runtime, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot synthesize weak property because the current deployment target does not support weak references", 0, SFINAE_SubstitutionFailure, false, true, 9)
DIAG(err_systemz_invalid_tabort_code, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid transaction abort code", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_tag_definition_of_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of type %0 conflicts with %select{typedef|type alias}1 of the same name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_tag_index_out_of_range, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{type tag|argument}0 index %1 is greater than the number of arguments specified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_tag_reference_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "implicit declaration introduced by elaborated type conflicts with a %select{non-struct type|non-class type|non-union type|non-enum type|typedef|type alias|template|type alias template|template template argument}0 of the same name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_tag_reference_non_tag, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{non-struct type|non-class type|non-union type|non-enum type|typedef|type alias|template|type alias template|template template argument}1 %0 cannot be referenced with a %select{struct|interface|union|class|enum}2 specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_tagless_friend_type_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend type templates must use an elaborated type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_temp_copy_ambiguous, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous constructor call when %select{copying variable|copying parameter|returning object|initializing statement expression result|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_temp_copy_deleted, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{copying variable|copying parameter|returning object|initializing statement expression result|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1 invokes deleted constructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_temp_copy_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "copying a temporary object of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_temp_copy_no_viable, CLASS_ERROR, (unsigned)diag::Severity::Error, "no viable constructor %select{copying variable|copying parameter|returning object|initializing statement expression result|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_address_of_non_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "address taken in non-type template argument for template parameter of reference type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_deduced_incomplete_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduced incomplete pack %0 for template parameter %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_field, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument refers to non-static data member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_list_constraints_not_satisfied, CLASS_ERROR, (unsigned)diag::Severity::Error, "constraints not satisfied for %select{class template|function template|variable template|alias template|template template parameter|template}0 %1%2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_list_different_arity, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{too few|too many}0 template arguments for %select{class template|function template|variable template|alias template|template template parameter|concept|template}1 %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_member_ptr_base_derived_not_supported, CLASS_ERROR, (unsigned)diag::Severity::Error, "sorry, non-type template argument of pointer-to-member type %1 that refers to member %q0 of a different class is not supported yet", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument refers to non-static member function %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_must_be_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument for non-type template parameter must be an expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_must_be_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument for template template parameter must be a class template%select{| or type alias template}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_must_be_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument for template type parameter must be a type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_must_be_type_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument for template type parameter must be a type; did you forget 'typename'?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_no_ref_bind, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template parameter of reference type %diff{$ cannot bind to template argument of type $|cannot bind to template of incompatible argument type}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_nontype_ambig, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument for non-type template parameter is treated as function type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_address_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument of type %0 is not a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_address_of, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument for template parameter of pointer type %0 must have its address taken", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_convertible, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument of type %0 cannot be converted to a value of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_decl_ref, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument does not refer to any declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_ice, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument of type %0 is not an integral constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_integral_or_enumeral, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument of type %0 must have an integral or enumeration type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_object_or_func, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument does not refer to an object or function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_pointer_to_member_form, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument is not a pointer to member constant", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_not_valid_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument does not refer to a class or alias template, or template template parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_object_no_linkage, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument refers to %select{function|object}0 %1 that does not have linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_overload_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "template argument is the type of an unresolved overloaded function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_ref_bind_ignores_quals, CLASS_ERROR, (unsigned)diag::Severity::Error, "reference binding of non-type template parameter %diff{of type $ to template argument of type $|to template argument}0,1 ignores qualifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_reference_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument of reference type %0 is not an object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_template_params_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "template template argument has different template parameters than its corresponding template template parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_thread_local, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template argument refers to thread-local object", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_untyped_null_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "null non-type template argument must be cast to template parameter type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_arg_wrongtype_null_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "null non-type template argument of type %0 does not match template parameter of type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_different_requires_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "requires clause differs in template redeclaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_different_type_constraint, CLASS_ERROR, (unsigned)diag::Severity::Error, "type constraint differs in template redeclaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_expansion_into_fixed_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "pack expansion used as argument for non-pack parameter of %select{alias template|concept}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_id_not_a_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "template name refers to non-type template %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_inside_local_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "templates cannot be declared inside of a local class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_instantiate_undefined, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{implicit|explicit}0 instantiation of undefined template %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_instantiate_within_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{implicit|explicit}0 instantiation of template %1 within its own definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_kernel, CLASS_ERROR, (unsigned)diag::Severity::Error, "kernel functions cannot be used in a template declaration, instantiation or specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_kw_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing 'template' keyword prior to dependent template name '%0%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_kw_refers_to_class_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0%1' instantiated to a class template, not a function template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_kw_refers_to_non_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 following the 'template' keyword does not refer to a template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_linkage, CLASS_ERROR, (unsigned)diag::Severity::Error, "templates must have C++ linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "member %0 declared as a template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_member_noparams, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous 'template<>' in declaration of member %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_missing_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of %select{class template|function template|variable template|alias template|template template parameter|concept|template}0 %1 requires template arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_nontype_parm_bad_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "a non-type template parameter cannot have type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_nontype_parm_different_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "template non-type parameter has a different type %0 in template %select{|template parameter }1redeclaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_outside_namespace_or_class_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "templates can only be declared in namespace or class scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_default_arg_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter missing a default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_default_arg_redefinition, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter redefines default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_different_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter has a different kind in template %select{|template parameter }0redeclaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_list_different_arity, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{too few|too many}0 template parameters in template %select{|template parameter }1redeclaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_list_matches_nontemplate, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter list matching the non-templated nested type %0 should be empty ('template<>')", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_pack_default_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter pack cannot have a default argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_pack_must_be_last_template_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter pack must be the last template parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_param_shadow, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of %0 shadows template parameter", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_parameter_default_friend_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "default template argument not permitted on a friend template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_parameter_default_template_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot add a default template argument to the definition of a member of a class template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_parameter_pack_non_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{template type|non-type template|template template}0 parameter%select{| pack}1 conflicts with previous %select{template type|non-type template|template template}0 parameter%select{ pack|}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_qualified_declarator_no_match, CLASS_ERROR, (unsigned)diag::Severity::Error, "nested name specifier '%0' for declaration does not refer into a class, class template or class template partial specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_recursion_depth_exceeded, CLASS_ERROR, (unsigned)diag::Severity::Fatal, "recursive template instantiation exceeded maximum depth of %0", 0, SFINAE_Report, false, true, 2)
DIAG(err_template_spec_decl_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot declare an explicit specialization in a friend", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_decl_function_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit specialization of %0 in function scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_default_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "default argument not permitted on an explicit %select{instantiation|specialization}0 of function %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_extra_headers, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous template parameter list in template specialization or out-of-line template definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "template specialization declaration cannot be a friend", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_needs_header, CLASS_ERROR, (unsigned)diag::Severity::Error, "template specialization requires 'template<>'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_needs_template_parameters, CLASS_ERROR, (unsigned)diag::Severity::Error, "template specialization or definition requires a template parameter list corresponding to the nested type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_redecl_global_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class template|class template partial|variable template|variable template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 must occur at global scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_redecl_out_of_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class template|class template partial|variable template|variable template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 not in %select{a namespace enclosing %2|class %2 or an enclosing namespace}3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_spec_unknown_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "can only provide an explicit specialization for a class template, function template, variable template, or a member function, static data member, %select{or member class|member class, or member enumeration}0 of a class template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_tag_noparams, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous 'template<>' in declaration of %0 %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_template_parameter_not_at_least_as_constrained, CLASS_ERROR, (unsigned)diag::Severity::Error, "template template argument %0 is more constrained than template template parameter %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_template_parm_no_parms, CLASS_ERROR, (unsigned)diag::Severity::Error, "template template parameter must have its own template parameters", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "a typedef cannot be a template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_unnamed_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot declare a class template with no name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_template_variable_noparams, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous 'template<>' in declaration of variable %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_tentative_def_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "tentative definition has type %0 that is never completed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_this_capture, CLASS_ERROR, (unsigned)diag::Severity::Error, "'this' cannot be %select{implicitly |}0captured in this context", 0, SFINAE_SubstitutionFailure, false, true, 3)
DIAG(err_this_static_member_func, CLASS_ERROR, (unsigned)diag::Severity::Error, "'this' cannot be%select{| implicitly}0 used in a static member function declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_thread_dynamic_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer for thread-local variable must be a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_thread_non_global, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' variables must have global storage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_thread_non_thread, CLASS_ERROR, (unsigned)diag::Severity::Error, "thread-local declaration of %0 follows non-thread-local declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_thread_nontrivial_dtor, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of thread-local variable has non-trivial destruction", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_thread_thread_different_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "thread-local declaration of %0 with %select{static|dynamic}1 initialization follows declaration with %select{dynamic|static}1 initialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_thread_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "thread-local storage is not supported for the current target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_three_way_vector_comparison, CLASS_ERROR, (unsigned)diag::Severity::Error, "three-way comparison between vectors is not supported", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(err_throw_abstract_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot throw an object of abstract type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_throw_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot throw object of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_throw_incomplete_ptr, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot throw pointer to object of incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_tls_var_aligned_over_maximum, CLASS_ERROR, (unsigned)diag::Severity::Error, "alignment (%0) of thread-local variable %1 is greater than the maximum supported alignment (%2) for a thread-local variable on this target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_toomany_element_decls, CLASS_ERROR, (unsigned)diag::Severity::Error, "only one element declaration is allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_trailing_requires_clause_on_deduction_guide, CLASS_ERROR, (unsigned)diag::Severity::Error, "deduction guide cannot have a requires clause", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_trailing_return_in_parens, CLASS_ERROR, (unsigned)diag::Severity::Error, "trailing return type may not be nested within parentheses", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_trailing_return_without_auto, CLASS_ERROR, (unsigned)diag::Severity::Error, "function with trailing return type must specify return type 'auto', not %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_constraint_missing_arguments, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 requires more than 1 template argument; provide the remaining arguments explicitly to use it here", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_constraint_non_type_concept, CLASS_ERROR, (unsigned)diag::Severity::Error, "concept named in type constraint is not a type concept", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_defined_in_alias_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be defined in a type alias template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_defined_in_condition, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be defined in a condition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_defined_in_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be defined in an enumeration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_defined_in_for_range, CLASS_ERROR, (unsigned)diag::Severity::Error, "types may not be defined in a for range declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_defined_in_param_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be defined in a parameter type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_defined_in_result_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be defined in the result type of a function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_defined_in_type_specifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 cannot be defined in a type specifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_mismatch_continuation_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "type of property %0 in class extension does not match property type in primary class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_pack_element_out_of_bounds, CLASS_ERROR, (unsigned)diag::Severity::Error, "a parameter pack may not be accessed at an out of bounds index", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_requirement_no_such_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' does not name a type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_requirement_non_type_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' refers to a %select{class template|function template|variable template|alias template|template template parameter|template}1, not a type template", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_tag_for_datatype_not_ice, CLASS_ERROR, (unsigned)diag::Severity::Error, "'type_tag_for_datatype' attribute requires the initializer to be an %select{integer|integral}0 constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_tag_for_datatype_too_large, CLASS_ERROR, (unsigned)diag::Severity::Error, "'type_tag_for_datatype' attribute requires the initializer to be an %select{integer|integral}0 constant expression that can be represented by a 64 bit integer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_type_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not supported on this target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_address_of, CLASS_ERROR, (unsigned)diag::Severity::Error, "address of %select{bit-field|vector element|property expression|register variable}0 requested", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_addrof_dtor, CLASS_ERROR, (unsigned)diag::Severity::Error, "taking the address of a destructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_addrof_temporary, CLASS_ERROR, (unsigned)diag::Severity::Error, "taking the address of a temporary object of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_ambiguous_condition, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion %diff{from $ to $|between types}0,1 is ambiguous", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_arc_assign_externally_retained, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable declared with 'objc_externally_retained' cannot be modified in ARC", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_typecheck_arc_assign_self, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot assign to 'self' outside of a method in the init family", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_typecheck_arc_assign_self_class_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot assign to 'self' in a class method", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_typecheck_arithmetic_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "arithmetic on a pointer to an incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_arr_assign_enumeration, CLASS_ERROR, (unsigned)diag::Severity::Error, "fast enumeration variables cannot be modified in ARC by default; declare the variable __strong to allow this", 0, SFINAE_SubstitutionFailure, false, true, 5)
DIAG(err_typecheck_array_not_modifiable_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "array type %0 is not assignable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_assign_const, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{cannot assign to return value because function %1 returns a const value|cannot assign to variable %1 with const-qualified type %2|cannot assign to %select{non-|}1static data member %2 with const-qualified type %3|cannot assign to non-static data member within const member function %1|cannot assign to %select{variable %2|non-static data member %2|lvalue}1 with %select{|nested }3const-qualified data member %4|read-only variable is not assignable}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_bool_condition, CLASS_ERROR, (unsigned)diag::Severity::Error, "value of type %0 is not contextually convertible to 'bool'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_invalid_ordered_compare, CLASS_ERROR, (unsigned)diag::Severity::Error, "ordered compare requires two args of floating point type%diff{ ($ and $)|}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_invalid_unary_fp, CLASS_ERROR, (unsigned)diag::Severity::Error, "floating point classification requires argument of floating point type (passed in %0)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_not_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "called object type %0 is not a function or function pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_few_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected %1, have %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_few_args_at_least, CLASS_ERROR, (unsigned)diag::Severity::Error, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at least %1, have %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_few_args_at_least_one, CLASS_ERROR, (unsigned)diag::Severity::Error, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, at least argument %1 must be specified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_few_args_at_least_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at least %1, have %2; did you mean %3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_few_args_one, CLASS_ERROR, (unsigned)diag::Severity::Error, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, single argument %1 was not specified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_few_args_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "too few %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected %1, have %2; did you mean %3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_many_args, CLASS_ERROR, (unsigned)diag::Severity::Error, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected %1, have %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_many_args_at_most, CLASS_ERROR, (unsigned)diag::Severity::Error, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at most %1, have %2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_many_args_at_most_one, CLASS_ERROR, (unsigned)diag::Severity::Error, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at most single argument %1, have %2 arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_many_args_at_most_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected at most %1, have %2; did you mean %3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_many_args_one, CLASS_ERROR, (unsigned)diag::Severity::Error, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected single argument %1, have %2 arguments", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_call_too_many_args_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "too many %select{|||execution configuration }0arguments to %select{function|block|method|kernel function}0 call, expected %1, have %2; did you mean %3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_cast_to_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "cast to incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_cast_to_union_no_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cast to union type from type %0 not present in union", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_choose_expr_requires_constant, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__builtin_choose_expr' requires a constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_comparison_of_distinct_blocks, CLASS_ERROR, (unsigned)diag::Severity::Error, "comparison of distinct block types%diff{ ($ and $)|}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_comparison_of_distinct_pointers, CLASS_ERROR, (unsigned)diag::Severity::Error, "comparison of distinct pointer types%diff{ ($ and $)|}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_comparison_of_fptr_to_void, CLASS_ERROR, (unsigned)diag::Severity::Error, "equality comparison between function pointer and void pointer (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_comparison_of_pointer_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "comparison between pointer and integer (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_cond_expect_int_float, CLASS_ERROR, (unsigned)diag::Severity::Error, "used type %0 where integer or floating point type is required", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_cond_expect_nonfloat, CLASS_ERROR, (unsigned)diag::Severity::Error, "used type %0 where floating point type is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_cond_expect_scalar, CLASS_ERROR, (unsigned)diag::Severity::Error, "used type %0 where arithmetic or pointer type is required", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_cond_incompatible_operands, CLASS_ERROR, (unsigned)diag::Severity::Error, "incompatible operand types%diff{ ($ and $)|}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_cond_incompatible_operands_null, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-pointer operand type %0 incompatible with %select{NULL|nullptr}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_convert_incompatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{%diff{assigning to $ from incompatible type $|assigning to type from incompatible type}0,1|%diff{passing $ to parameter of incompatible type $|passing type to parameter of incompatible type}0,1|%diff{returning $ from a function with incompatible result type $|returning type from a function with incompatible result type}0,1|%diff{converting $ to incompatible type $|converting type to incompatible type}0,1|%diff{initializing $ with an expression of incompatible type $|initializing type with an expression of incompatible type}0,1|%diff{sending $ to parameter of incompatible type $|sending type to parameter of incompatible type}0,1|%diff{casting $ to incompatible type $|casting type to incompatible type}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3%select{|: different classes%diff{ ($ vs $)|}5,6|: different number of parameters (%5 vs %6)|: type mismatch at %ordinal5 parameter%diff{ ($ vs $)|}6,7|: different return type%diff{ ($ vs $)|}5,6|: different qualifiers (%5 vs %6)|: different exception specifications}4", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_convert_incompatible_block_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "incompatible block pointer types %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_converted_constant_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "value of type %0 is not implicitly convertible to %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_converted_constant_expression_disallowed, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion from %0 to %1 is not allowed in a converted constant expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_converted_constant_expression_indirect, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion from %0 to %1 in converted constant expression would bind reference to a temporary", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_decl_incomplete_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable has incomplete type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_deleted_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "conversion function %diff{from $ to $|between types}0,1 invokes a deleted function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_duplicate_vector_components_not_mlvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector is not assignable (contains duplicate components)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_expect_int, CLASS_ERROR, (unsigned)diag::Severity::Error, "used type %0 where integer is required", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_expect_scalar_operand, CLASS_ERROR, (unsigned)diag::Severity::Error, "operand of type %0 where arithmetic or pointer type is required", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_expression_not_modifiable_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "expression is not assignable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_field_variable_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "fields must have a constant size: 'variable length array in structure' extension will never be supported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_illegal_increment_decrement, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot %select{decrement|increment}1 value of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_incompatible_address_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{%diff{assigning $ to $|assigning to different types}1,0|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 changes address space of pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_incompatible_nested_address_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{%diff{assigning $ to $|assigning to different types}1,0|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 changes address space of nested pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_incompatible_ownership, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{%diff{assigning $ to $|assigning to different types}1,0|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 changes retain/release properties of pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_incomplete_array_needs_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of variable with array type needs an explicit size or an initializer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_incomplete_tag, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete definition of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_incomplete_type_not_modifiable_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "incomplete type %0 is not assignable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_indirection_requires_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "indirection requires pointer operand (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_invalid_lvalue_addrof, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot take the address of an rvalue of type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_invalid_lvalue_addrof_addrof_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "extra '&' taking address of overloaded function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_invalid_operands, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid operands to binary expression (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_invalid_restrict_invalid_pointee, CLASS_ERROR, (unsigned)diag::Severity::Error, "pointer to function type %0 may not be 'restrict' qualified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_invalid_restrict_not_pointer, CLASS_ERROR, (unsigned)diag::Severity::Error, "restrict requires a pointer or reference (%0 is invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_invalid_restrict_not_pointer_noarg, CLASS_ERROR, (unsigned)diag::Severity::Error, "restrict requires a pointer or reference", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_ivar_variable_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variables must have a constant size", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_logical_vector_expr_gnu_cpp_restrict, CLASS_ERROR, (unsigned)diag::Severity::Error, "logical expression with vector %select{type %1 and non-vector type %2|types %1 and %2}0 is only supported in C++", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_lvalue_casts_not_supported, CLASS_ERROR, (unsigned)diag::Severity::Error, "assignment to cast is illegal, lvalue casts are not supported", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_member_reference_arrow, CLASS_ERROR, (unsigned)diag::Severity::Error, "member reference type %0 is not a pointer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_member_reference_ivar, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not have a member named %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_member_reference_ivar_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 does not have a member named %1; did you mean %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_member_reference_struct_union, CLASS_ERROR, (unsigned)diag::Severity::Error, "member reference base type %0 is not a structure or union", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_member_reference_suggestion, CLASS_ERROR, (unsigned)diag::Severity::Error, "member reference type %0 is %select{a|not a}1 pointer; did you mean to use '%select{->|.}1'?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_member_reference_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot refer to type member %0 in %1 with '%select{.|->}2'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_member_reference_unknown, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot refer to member %0 in %1 with '%select{.|->}2'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_missing_return_type_incompatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "%diff{return type $ must match previous return type $|return type must match previous return type}0,1 when %select{block literal|lambda expression}2 has unspecified explicit return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_negative_array_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "array size is negative", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_non_object_not_modifiable_lvalue, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-object type %0 is not assignable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_nonviable_condition, CLASS_ERROR, (unsigned)diag::Severity::Error, "no viable conversion%select{%diff{ from $ to $|}1,2|%diff{ from returned value of type $ to function return type $|}1,2}0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_nonviable_condition_incomplete, CLASS_ERROR, (unsigned)diag::Severity::Error, "no viable conversion%diff{ from $ to incomplete type $|}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_op_on_nonoverlapping_address_space_pointers, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{comparison between %diff{ ($ and $)|}0,1|arithmetic operation with operands of type %diff{ ($ and $)|}0,1|conditional operator with the second and third operands of type %diff{ ($ and $)|}0,1}2 which are pointers to non-overlapping address spaces", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_ordered_comparison_of_pointer_and_zero, CLASS_ERROR, (unsigned)diag::Severity::Error, "ordered comparison between pointer and zero (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_pointer_arith_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "arithmetic on%select{ a|}0 pointer%select{|s}0 to%select{ the|}2 function type%select{|s}2 %1%select{| and %3}2", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_pointer_arith_void_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "arithmetic on%select{ a|}0 pointer%select{|s}0 to void", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_sclass_fscope, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal storage class on file-scoped variable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_sclass_func, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal storage class on function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_statement_requires_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "statement requires expression of integer type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_statement_requires_scalar, CLASS_ERROR, (unsigned)diag::Severity::Error, "statement requires expression of scalar type (%0 invalid)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_sub_ptr_compatible, CLASS_ERROR, (unsigned)diag::Severity::Error, "%diff{$ and $ are not pointers to compatible types|pointers to incompatible types}0,1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_subscript_not_integer, CLASS_ERROR, (unsigned)diag::Severity::Error, "array subscript is not an integer", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_subscript_value, CLASS_ERROR, (unsigned)diag::Severity::Error, "subscripted value is not an array, pointer, or vector", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_three_way_comparison_of_pointer_and_zero, CLASS_ERROR, (unsigned)diag::Severity::Error, "three-way comparison between pointer and zero", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_unary_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid argument type %0 to unary expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_vector_lengths_not_equal, CLASS_ERROR, (unsigned)diag::Severity::Error, "vector operands do not have the same number of elements (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_vector_not_convertable, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot convert between vector values of different size (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_vector_not_convertable_implict_truncation, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot convert between %select{scalar|vector}0 type %1 and vector type %2 as implicit conversion would cause truncation", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_vector_not_convertable_non_scalar, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot convert between vector and non-scalar values (%0 and %1)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typecheck_zero_array_size, CLASS_ERROR, (unsigned)diag::Severity::Error, "zero-length arrays are not permitted in C++", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typedef_changes_linkage, CLASS_ERROR, (unsigned)diag::Severity::Error, "unsupported: typedef changes linkage of anonymous type, but linkage was already computed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typedef_not_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "typedef member %0 cannot be a bit-field", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typedef_not_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "typedef name must be an identifier", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing 'typename' prior to dependent type name '%0%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_missing_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing 'typename' prior to dependent type template name '%0%1'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_nested_not_found, CLASS_ERROR, (unsigned)diag::Severity::Error, "no type named %0 in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_nested_not_found_enable_if, CLASS_ERROR, (unsigned)diag::Severity::Error, "no type named 'type' in %0; 'enable_if' cannot be used to disable this declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_nested_not_found_requirement, CLASS_ERROR, (unsigned)diag::Severity::Error, "failed requirement '%0'; 'enable_if' cannot be used to disable this declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_nested_not_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "typename specifier refers to non-type member %0 in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_not_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "typename specifier refers to non-type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_typename_refers_to_using_value_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "typename specifier refers to a dependent using declaration for a value %0 in %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unavailable, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is unavailable", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unavailable_in_arc, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is unavailable in ARC", 0, SFINAE_SubstitutionFailure, false, true, 10)
DIAG(err_unavailable_message, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is unavailable: %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_uncasted_call_of_unknown_any, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 has unknown return type; cast the call to its declared return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_uncasted_send_to_unknown_any_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "no known method %select{%objcinstance1|%objcclass1}0; cast the message send to the method's return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_uncasted_use_of_unknown_any, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 has unknown type; cast it to its declared type to use it", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_boxing_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of %0 is missing in %1 class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_label_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of undeclared label %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_objc_literal_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "definition of class %0 must be available to use Objective-C %select{array literals|dictionary literals|numeric literals|boxed expressions|string literals}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_protocol, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find protocol declaration for %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_protocol_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find protocol declaration for %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of undeclared %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_use_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of undeclared %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_var_use, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of undeclared identifier %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undeclared_var_use_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of undeclared identifier %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undef_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find interface declaration for %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undef_interface_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find interface declaration for %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undef_superclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find interface declaration for %0, superclass of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undef_superclass_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot find interface declaration for %0, superclass of %1; did you mean %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undefined_inline_var, CLASS_ERROR, (unsigned)diag::Severity::Error, "inline variable %q0 is not defined", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_undefined_internal_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{function|variable}0 %q1 is used but not defined in this translation unit, and cannot be defined in any other translation unit because its type does not have linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_underlying_type_of_incomplete_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot determine underlying type of incomplete enumeration type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unexpanded_parameter_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization|__if_exists name|__if_not_exists name|lambda|block|type constraint}0 contains%plural{0: an|:}1 unexpanded parameter pack%plural{0:|1: %2|2:s %2 and %3|:s %2, %3, ...}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unexpected_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "friends can only be classes or functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unexpected_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected interface name %0: expected expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unexpected_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected namespace name %0: expected expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unexpected_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected type name %0: expected expression", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_uninitialized_member_for_assign, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot define the implicit copy assignment operator for %0, because non-static %select{reference|const}1 member %2 cannot use copy assignment operator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_uninitialized_member_in_ctor, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{constructor for %1|implicit default constructor for %1|cannot use constructor inherited from %1:}0 must explicitly initialize the %select{reference|const}2 member %3", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_union_as_base_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "unions cannot be base classes", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_union_member_of_reference_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "union member %0 has reference type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_any_addrof, CLASS_ERROR, (unsigned)diag::Severity::Error, "the address of a declaration with unknown type can only be cast to a pointer type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_any_addrof_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "address-of operator cannot be applied to a call to a function with unknown return type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_any_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "function %0 with unknown type must be given a function type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_any_var_function_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable %0 with unknown type cannot be given a function type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_nested_typename_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "no type named %0 in %1; did you mean %select{|simply }2%3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_receiver_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown receiver %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_type_or_class_name_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown %select{type|class}1 name %0; did you mean %2?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_typename, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown type name %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unknown_typename_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown type name %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unqualified_pointer_member_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "must explicitly qualify name of member function when taking its address", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unsupported_placeholder_constraint, CLASS_ERROR, (unsigned)diag::Severity::Error, "constrained placeholder types other than simple 'auto' on non-type template parameters not supported yet", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unsupported_unknown_any_call, CLASS_ERROR, (unsigned)diag::Severity::Error, "call to unsupported expression with unknown type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unsupported_unknown_any_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 has unknown type, which is not supported for this kind of declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_unsupported_unknown_any_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "unsupported expression with unknown type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_upcast_to_inaccessible_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast %0 to its %select{private|protected}2 base class %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_use_continuation_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal redeclaration of property in class extension %0 (attribute must be 'readwrite', while its primary must be 'readonly')", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_use_continuation_class_redeclaration_readwrite, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal redeclaration of 'readwrite' property in class extension %0 (perhaps you intended this to be a 'readwrite' redeclaration of a 'readonly' public property?)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_use_of_default_argument_to_function_declared_later, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of default argument to function %0 that is declared later in class %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_use_with_wrong_tag, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of %0 with tag type that does not match previous declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_can_not_refer_to_class_member, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration cannot refer to class member", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_can_not_refer_to_namespace, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration cannot refer to a namespace", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_can_not_refer_to_scoped_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration cannot refer to a scoped enumerator", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "target of using declaration conflicts with declaration already in scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_conflict_reverse, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration conflicts with target of using declaration already in scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_constructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration cannot refer to a constructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_constructor_not_in_direct_base, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not a direct base of %1, cannot inherit constructors", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_destructor, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration cannot refer to a destructor", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_friend, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot befriend target of using declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_nested_name_specifier_is_current_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration refers to its own class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_nested_name_specifier_is_not_base_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration refers into '%0', which is not a base class of %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_nested_name_specifier_is_not_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration in class refers into '%0', which is not a class", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration of using declaration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_redeclaration_expansion, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration pack expansion at block scope produces multiple values", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_decl_template_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration cannot refer to a template specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_dependent_value_is_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "dependent using declaration resolved to type without 'typename'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_directive_member_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "no namespace named %0 in %1; did you mean %select{|simply }2%3?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_directive_suggest, CLASS_ERROR, (unsigned)diag::Severity::Error, "no namespace named %0; did you mean %1?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_pack_expansion_empty, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|member}0 using declaration %1 instantiates to an empty pack", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_requires_qualname, CLASS_ERROR, (unsigned)diag::Severity::Error, "using declaration requires a qualified name", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_using_typename_non_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "'typename' keyword used on a non-type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_uuidof_with_multiple_guids, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot call operator __uuidof on a type with multiple GUIDs", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_uuidof_without_guid, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot call operator __uuidof on a type with no GUID", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_va_arg_in_device, CLASS_ERROR, (unsigned)diag::Severity::Error, "CUDA device code does not support va_arg", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_va_start_captured_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "'va_start' cannot be used in a captured statement", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_va_start_fixed_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'va_start' used in function with fixed args", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_va_start_outside_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'va_start' cannot be used outside a function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_va_start_used_in_wrong_abi_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'va_start' used in %select{System V|Win64}0 ABI function", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_value_init_for_array_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "array types cannot be value-initialized", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_var_partial_spec_redeclared, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable template partial specialization %0 cannot be redefined", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_var_spec_no_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "no variable template matches%select{| partial}0 specialization", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_var_spec_no_template_but_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "no variable template matches specialization; did you mean to use %0 as function template instead?", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_variable_instantiates_to_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{variable|static data member}0 instantiated with function type %1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_variable_object_no_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable-sized object may not be initialized", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_variably_modified_new_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "'new' cannot allocate object of variably modified type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_variably_modified_nontype_template_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template parameter of variably modified type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_variably_modified_template_arg, CLASS_ERROR, (unsigned)diag::Severity::Error, "variably modified type %0 cannot be used as a template argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_variably_modified_typeid, CLASS_ERROR, (unsigned)diag::Severity::Error, "'typeid' of variably modified type %0", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_variadic_device_fn, CLASS_ERROR, (unsigned)diag::Severity::Error, "CUDA device code does not support variadic functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vec_builtin_incompatible_vector, CLASS_ERROR, (unsigned)diag::Severity::Error, "first two arguments to %0 must have the same type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vec_builtin_non_vector, CLASS_ERROR, (unsigned)diag::Severity::Error, "first two arguments to %0 must be vectors", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vecstep_non_scalar_vector_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "'vec_step' requires built-in scalar or vector type, %0 invalid", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vector_incorrect_num_initializers, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{too many|too few}0 elements in vector initialization (expected %1 elements, have %2)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_virtual_in_union, CLASS_ERROR, (unsigned)diag::Severity::Error, "unions cannot have virtual functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_virtual_member_function_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "'virtual' cannot be specified on member function templates", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_virtual_non_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "'virtual' can only appear on non-static member functions", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_virtual_out_of_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "'virtual' can only be specified inside the class definition", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vla_decl_has_extern_linkage, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable length array declaration cannot have 'extern' linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vla_decl_has_static_storage, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable length array declaration cannot have 'static' storage duration", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vla_decl_in_file_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable length array declaration not allowed at file scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vla_in_sfinae, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable length array cannot be formed during template argument deduction", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vla_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable length arrays are not supported for the current target", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vm_decl_has_extern_linkage, CLASS_ERROR, (unsigned)diag::Severity::Error, "variably modified type declaration cannot have 'extern' linkage", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vm_decl_in_file_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "variably modified type declaration not allowed at file scope", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vm_func_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declaration cannot have variably modified type", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_void_only_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "'void' must be the first and only parameter if specified", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_void_param_qualified, CLASS_ERROR, (unsigned)diag::Severity::Error, "'void' as parameter must not have type qualifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_vsx_builtin_nonconstant_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument %0 to %1 must be a 2-bit unsigned literal (i.e. 0, 1, 2 or 3)", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_weak_property, CLASS_ERROR, (unsigned)diag::Severity::Error, "existing instance variable %1 for __weak property %0 must be __weak", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_wrong_sampler_addressspace, CLASS_ERROR, (unsigned)diag::Severity::Error, "sampler type cannot be used with the __local and __global address space qualifiers", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_x86_builtin_invalid_rounding, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid rounding argument", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(err_x86_builtin_invalid_scale, CLASS_ERROR, (unsigned)diag::Severity::Error, "scale argument must be 1, 2, 4, or 8", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(error_cconv_unsupported, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 calling convention is not supported %select{for this target|on variadic function|on constructor/destructor|on builtin function}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(error_duplicate_asm_operand_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate use of asm operand name \"%0\"", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(error_inoutput_conflict_with_clobber, CLASS_ERROR, (unsigned)diag::Severity::Error, "asm-specifier for input or output variable conflicts with asm clobber list", 0, SFINAE_SubstitutionFailure, false, true, 0)
DIAG(ext_adl_only_template_id, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of function template name with no prior declaration in function call with explicit template arguments is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_aggregate_init_not_constant, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "initializer for aggregate is not a compile-time constant", 126, SFINAE_Suppress, false, false, 2)
DIAG(ext_anonymous_record_with_anonymous_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "anonymous types declared in an anonymous %select{struct|union}0 are an extension", 477, SFINAE_Suppress, false, false, 2)
DIAG(ext_anonymous_record_with_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "types declared in an anonymous %select{struct|union}0 are a Microsoft extension", 411, SFINAE_Suppress, false, false, 2)
DIAG(ext_anonymous_struct_union_qualified, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "anonymous %select{struct|union}0 cannot be '%1'", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_anonymous_union, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "anonymous unions are a C11 extension", 123, SFINAE_Suppress, false, false, 2)
DIAG(ext_array_init_copy, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "initialization of an array %diff{of type $ from a compound literal of type $|from a compound literal}0,1 is a GNU extension", 293, SFINAE_Suppress, false, false, 2)
DIAG(ext_array_init_parens, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "parenthesized initialization of a member array is a GNU extension", 288, SFINAE_Suppress, false, false, 2)
DIAG(ext_array_size_conversion, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "implicit conversion from array size expression of type %0 to %select{integral|enumeration}1 type %2 is a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_auto_new_list_init, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C++ standards before C++17 do not allow new expression for type %0 to use list-initialization", 98, SFINAE_Suppress, false, false, 2)
DIAG(ext_auto_type_specifier, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'auto' type specifier is a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_bad_cxx_cast_qualifiers_away_incoherent, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++ does not allow %select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 because it casts away qualifiers, even though the source and destination types are unrelated", 132, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_c11_anonymous_struct, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "anonymous structs are a C11 extension", 123, SFINAE_Suppress, false, false, 2)
DIAG(ext_c99_array_usage, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "%select{qualifier in |static |}0array size %select{||'[*] '}0is a C99 feature", 126, SFINAE_Suppress, false, false, 2)
DIAG(ext_c99_flexible_array_member, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "flexible array members are a C99 feature", 126, SFINAE_Suppress, false, false, 2)
DIAG(ext_cannot_use_trivial_abi, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'trivial_abi' cannot be applied to %0", 317, SFINAE_Suppress, false, false, 2)
DIAG(ext_cast_fn_obj, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "cast between pointer-to-function and pointer-to-object is an extension", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_cce_narrowing, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "%select{case value|enumerator value|non-type template argument|array size|constexpr if condition|explicit specifier argument}0 %select{cannot be narrowed from type %2 to %3|evaluates to %2, which cannot be narrowed to type %3}1", 90, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_complex_component_init, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "complex initialization specifying real and imaginary components is an extension", 141, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_body_invalid_stmt, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of this statement in a constexpr %select{function|constructor}0 is a C++14 extension", 94, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_body_invalid_stmt_cxx2a, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of this statement in a constexpr %select{function|constructor}0 is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_body_multiple_return, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "multiple return statements in constexpr function is a C++14 extension", 94, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_ctor_missing_init, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "constexpr constructor that does not initialize all members is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_function_never_constant_expr, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "constexpr %select{function|constructor}0 never produces a constant expression", 374, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_function_try_block_cxx2a, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "function try block in constexpr %select{function|constructor}0 is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_local_var, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "variable declaration in a constexpr %select{function|constructor}0 is a C++14 extension", 94, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_local_var_no_init, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "uninitialized variable in a constexpr %select{function|constructor}0 is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_type_definition, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "type definition in a constexpr %select{function|constructor}0 is a C++14 extension", 94, SFINAE_Suppress, false, false, 2)
DIAG(ext_constexpr_union_ctor_no_init, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "constexpr union constructor that does not initialize any member is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_constinit_missing, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'constinit' specifier missing on initializing declaration of %0", 448, SFINAE_Suppress, false, false, 2)
DIAG(ext_cxx14_attr, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of the %0 attribute is a C++14 extension", 94, SFINAE_Suppress, false, false, 2)
DIAG(ext_cxx17_attr, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of the %0 attribute is a C++17 extension", 98, SFINAE_Suppress, false, false, 2)
DIAG(ext_cxx2a_attr, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of the %0 attribute is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_cxx_designated_init, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "designated initializers are a C++20 extension", 105, SFINAE_Suppress, false, false, 2)
DIAG(ext_decomp_decl, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "decomposition declarations are a C++17 extension", 98, SFINAE_Suppress, false, false, 2)
DIAG(ext_decomp_decl_cond, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++17 does not permit structured binding declaration in a condition", 62, SFINAE_Suppress, false, false, 2)
DIAG(ext_decomp_decl_spec, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "decomposition declaration declared %plural{1:'%1'|:with '%1' specifiers}0 is a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_default_init_const, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "default initialization of an object of const type %0%select{| without a user-provided default constructor}1 is a Microsoft extension", 415, SFINAE_Suppress, false, false, 2)
DIAG(ext_defaulted_comparison, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "defaulted comparison operators are a C++20 extension", 106, SFINAE_Suppress, false, false, 2)
DIAG(ext_delete_void_ptr_operand, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "cannot delete expression with pointer-to-'void' type %0", 176, SFINAE_Suppress, false, false, 2)
DIAG(ext_deprecated_string_literal_conversion, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++11 does not allow conversion from string literal to %0", 822, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_designated_init, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "designated initializers are a C99 feature", 125, SFINAE_Suppress, false, false, 2)
DIAG(ext_designated_init_array, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "array designators are a C99 extension", 125, SFINAE_Suppress, false, false, 2)
DIAG(ext_designated_init_mixed, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "mixture of designated and non-designated initializers in the same initializer list is a C99 extension", 125, SFINAE_Suppress, false, false, 2)
DIAG(ext_designated_init_nested, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "nested designators are a C99 extension", 125, SFINAE_Suppress, false, false, 2)
DIAG(ext_designated_init_reordered, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++ requires field designators to be specified in declaration order; field %1 will be initialized after field %0", 625, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_empty_struct_union, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "empty %select{struct|union}0 is a GNU extension", 297, SFINAE_Suppress, false, false, 2)
DIAG(ext_enum_friend, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "befriending enumeration type %0 is a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_enum_too_large, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "enumeration values exceed range of largest integer", 239, SFINAE_Suppress, false, false, 2)
DIAG(ext_enum_value_not_int, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C restricts enumerator values to range of 'int' (%0 is too %select{small|large}1)", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_enumerator_increment_too_large, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "incremented enumerator value %0 is not representable in the largest integer type", 239, SFINAE_Suppress, false, false, 2)
DIAG(ext_enumerator_too_large, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "enumerator value is not representable in the underlying type %0", 421, SFINAE_Suppress, false, false, 2)
DIAG(ext_equals_this_lambda_capture_cxx2a, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "explicit capture of 'this' with a capture default of '=' is a C++20 extension", 106, SFINAE_Suppress, false, false, 3)
DIAG(ext_equivalent_internal_linkage_decl_in_modules, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ambiguous use of internal linkage declaration %0 defined in multiple modules", 468, SFINAE_Suppress, false, false, 13)
DIAG(ext_excess_initializers, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "excess elements in %select{array|vector|scalar|union|struct}0 initializer", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_excess_initializers_in_char_array_initializer, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "excess elements in char array initializer", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_explicit_conversion_functions, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "explicit conversion functions are a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_explicit_instantiation_duplicate, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "duplicate explicit instantiation of %0 ignored as a Microsoft extension", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_explicit_instantiation_without_qualified_id, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "qualifier in explicit instantiation of %q0 requires a template-id (a typedef is not permitted)", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_explicit_specialization_storage_class, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "explicit specialization cannot have a storage class", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_export_no_name_block, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++20 does not permit %select{an empty|a static_assert}0 declaration to appear in an export block", 246, SFINAE_Suppress, false, false, 13)
DIAG(ext_export_no_names, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++20 does not permit a declaration that does not introduce any names to be exported", 246, SFINAE_Suppress, false, false, 13)
DIAG(ext_export_using_directive, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++20 does not permit using directive to be exported", 247, SFINAE_Suppress, false, false, 13)
DIAG(ext_expr_not_ice, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "expression is not an %select{integer|integral}0 constant expression; folding it to a constant is a GNU extension", 300, SFINAE_Suppress, false, false, 2)
DIAG(ext_flexible_array_empty_aggregate_gnu, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "flexible array member %0 in otherwise empty %select{struct|interface|union|class|enum}1 is a GNU extension", 297, SFINAE_Suppress, false, false, 2)
DIAG(ext_flexible_array_empty_aggregate_ms, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "flexible array member %0 in otherwise empty %select{struct|interface|union|class|enum}1 is a Microsoft extension", 427, SFINAE_Suppress, false, false, 2)
DIAG(ext_flexible_array_in_array, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "%0 may not be used as an array element due to flexible array member", 259, SFINAE_Suppress, false, false, 2)
DIAG(ext_flexible_array_in_struct, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "%0 may not be nested in a struct due to flexible array member", 259, SFINAE_Suppress, false, false, 2)
DIAG(ext_flexible_array_init, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "flexible array initialization is a GNU extension", 298, SFINAE_Suppress, false, false, 2)
DIAG(ext_flexible_array_union_gnu, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "flexible array member %0 in a union is a GNU extension", 299, SFINAE_Suppress, false, false, 2)
DIAG(ext_flexible_array_union_ms, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "flexible array member %0 in a union is a Microsoft extension", 427, SFINAE_Suppress, false, false, 2)
DIAG(ext_for_range_begin_end_types_differ, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'begin' and 'end' returning different types (%0 and %1) is a C++17 extension", 98, SFINAE_Suppress, false, false, 2)
DIAG(ext_forward_ref_enum, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C forbids forward references to 'enum' types", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_forward_ref_enum_def, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "redeclaration of already-defined enum %0 is a GNU extension", 305, SFINAE_Suppress, false, false, 2)
DIAG(ext_found_via_dependent_bases_lookup, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of identifier %0 found via unqualified lookup into dependent bases of class templates is a Microsoft extension", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_freestanding_complex, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "complex numbers are an extension in a freestanding C99 implementation", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_friend_tag_redecl_outside_namespace, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "unqualified friend declaration referring to type outside of the nearest enclosing namespace is a Microsoft extension; add a nested name specifier", 438, SFINAE_Suppress, false, false, 2)
DIAG(ext_gnu_anonymous_struct, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "anonymous structs are a GNU extension", 287, SFINAE_Suppress, false, false, 2)
DIAG(ext_gnu_ptr_func_arith, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "arithmetic on%select{ a|}0 pointer%select{|s}0 to%select{ the|}2 function type%select{|s}2 %1%select{| and %3}2 is a GNU extension", 582, SFINAE_Suppress, false, false, 2)
DIAG(ext_gnu_subscript_void_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "subscript of a pointer to void is a GNU extension", 582, SFINAE_Suppress, false, false, 2)
DIAG(ext_gnu_void_ptr, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "arithmetic on%select{ a|}0 pointer%select{|s}0 to void is a GNU extension", 582, SFINAE_Suppress, false, false, 2)
DIAG(ext_goto_into_protected_scope, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "jump from this goto statement to its label is a Microsoft extension", 428, SFINAE_Suppress, false, false, 2)
DIAG(ext_imaginary_constant, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "imaginary constants are a GNU extension", 301, SFINAE_Suppress, false, false, 2)
DIAG(ext_implicit_exception_spec_mismatch, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "function previously declared with an %select{explicit|implicit}0 exception specification redeclared with an %select{implicit|explicit}0 exception specification", 326, SFINAE_Suppress, false, false, 2)
DIAG(ext_implicit_function_decl, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "implicit declaration of function %0 is invalid in C99", 331, SFINAE_Suppress, false, false, 2)
DIAG(ext_implicit_lib_function_decl, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "implicitly declaring library function '%0' with type %1", 331, SFINAE_Suppress, false, false, 2)
DIAG(ext_in_class_initializer_float_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "in-class initializer for static data member of type %0 is a GNU extension", 307, SFINAE_Suppress, false, false, 2)
DIAG(ext_in_class_initializer_float_type_cxx11, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "in-class initializer for static data member of type %0 requires 'constexpr' specifier", 678, SFINAE_Suppress, false, false, 2)
DIAG(ext_in_class_initializer_non_constant, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "in-class initializer for static data member is not a constant expression; folding it to a constant is a GNU extension", 300, SFINAE_Suppress, false, false, 2)
DIAG(ext_incomplete_in_exception_spec, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%select{|pointer to |reference to }0incomplete type %1 is not allowed in exception specification", 422, SFINAE_Suppress, false, false, 2)
DIAG(ext_increment_bool, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "ISO C++17 does not allow incrementing expression of type bool", 358, SFINAE_Suppress, false, false, 2)
DIAG(ext_init_capture, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "initialized lambda captures are a C++14 extension", 94, SFINAE_Suppress, false, false, 3)
DIAG(ext_init_capture_pack, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "initialized lambda pack captures are a C++20 extension", 106, SFINAE_Suppress, false, false, 3)
DIAG(ext_init_list_constant_narrowing, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "constant expression evaluates to %0 which cannot be narrowed to type %1", 90, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_init_list_type_narrowing, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "type %0 cannot be narrowed to %1 in initializer list", 90, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_init_list_variable_narrowing, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "non-constant-expression cannot be narrowed from type %0 to %1 in initializer list", 90, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_initializer_overrides, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "initializer %select{partially |}0overrides prior initialization of this subobject", 361, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_initializer_string_for_char_array_too_long, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "initializer-string for char array is too long", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_inline_variable, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "inline variables are a C++17 extension", 98, SFINAE_Suppress, false, false, 2)
DIAG(ext_integer_complement_complex, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C does not support '~' for complex conjugation of %0", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_integer_complex, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "complex integer types are a GNU extension", 292, SFINAE_Suppress, false, false, 2)
DIAG(ext_integer_increment_complex, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C does not support '++'/'--' on complex integer type %0", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_internal_in_extern_inline, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "static %select{function|variable}0 %1 is used in an inline function with external linkage", 679, SFINAE_Suppress, false, false, 2)
DIAG(ext_internal_in_extern_inline_quiet, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "static %select{function|variable}0 %1 is used in an inline function with external linkage", 679, SFINAE_Suppress, false, false, 2)
DIAG(ext_main_returns_nonint, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "return type of 'main' is not 'int'", 403, SFINAE_Suppress, false, false, 2)
DIAG(ext_main_used, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C++ does not allow 'main' to be used by a program", 402, SFINAE_Suppress, false, false, 2)
DIAG(ext_many_braces_around_scalar_init, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "too many braces around scalar initializer", 405, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_member_redeclared, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "class member cannot be redeclared", 616, SFINAE_Suppress, false, false, 2)
DIAG(ext_mismatched_exception_spec, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "exception specification in declaration does not match previous declaration", 422, SFINAE_Suppress, false, false, 2)
DIAG(ext_mismatched_exception_spec_explicit_instantiation, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "exception specification in explicit instantiation does not match instantiated one", 422, SFINAE_Suppress, false, false, 2)
DIAG(ext_missing_declspec, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "declaration specifier missing, defaulting to 'int'", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_missing_exception_specification, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%0 is missing exception specification '%1'", 450, SFINAE_Suppress, false, false, 2)
DIAG(ext_missing_type_specifier, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "type specifier missing, defaults to 'int'", 332, SFINAE_Suppress, false, false, 2)
DIAG(ext_mixed_decls_code, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C90 forbids mixing declarations and code", 172, SFINAE_Suppress, false, false, 2)
DIAG(ext_module_import_in_extern_c, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "import of C++ module '%0' appears within extern \"C\" language linkage specification", 467, SFINAE_Suppress, false, false, 13)
DIAG(ext_module_import_not_at_top_level_noop, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "redundant #include of module '%0' appears within %1", 469, SFINAE_Suppress, false, false, 13)
DIAG(ext_ms_ambiguous_direct_base, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "accessing inaccessible direct base %0 of %1 is a Microsoft extension", 429, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_anonymous_record, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "anonymous %select{structs|unions}0 are a Microsoft extension", 411, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_cast_fn_obj, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "static_cast between pointer-to-function and pointer-to-object is a Microsoft extension", 412, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_delayed_template_argument, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "using the undeclared type %0 as a default template argument is a Microsoft extension", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_deref_template_argument, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "non-type template argument containing a dereference operation is a Microsoft extension", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_explicit_constructor_call, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "explicit constructor calls are a Microsoft extension", 424, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_forward_ref_enum, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "forward references to 'enum' types are a Microsoft extension", 420, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_impcast_fn_obj, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "implicit conversion between pointer-to-function and pointer-to-object is a Microsoft extension", 412, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_missing_exception_specification, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%0 is missing exception specification '%1'", 422, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_template_spec_redecl_out_of_scope, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%select{class template|class template partial|variable template|variable template partial|function template|member function|static data member|member class|member enumeration}0 specialization of %1 not in %select{a namespace enclosing %2|class %2 or an enclosing namespace}3 is a Microsoft extension", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_template_type_arg_missing_typename, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "template argument for template type parameter must be a type; omitted 'typename' is a Microsoft extension", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_ms_using_declaration_inaccessible, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "using declaration referring to inaccessible member '%0' (which refers to accessible member '%1') is a Microsoft compatibility extension", 439, SFINAE_AccessControl, false, false, 2)
DIAG(ext_mutable_reference, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'mutable' on a reference type is a Microsoft extension", 431, SFINAE_Suppress, false, false, 2)
DIAG(ext_nested_name_member_ref_lookup_ambiguous, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "lookup of %0 in member access expression is ambiguous; using member of %1", 21, SFINAE_Suppress, false, false, 2)
DIAG(ext_nested_name_spec_is_enum, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of enumeration in a nested name specifier is a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_nested_pointer_qualifier_mismatch, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 discards qualifiers in nested pointer types", 347, SFINAE_Suppress, false, false, 2)
DIAG(ext_new_paren_array_nonconst, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "when type is in parentheses, array cannot have dynamic size", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_no_declarators, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "declaration does not declare anything", 449, SFINAE_Suppress, false, false, 2)
DIAG(ext_no_named_members_in_struct_union, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "%select{struct|union}0 without named members is a GNU extension", 297, SFINAE_Suppress, false, false, 2)
DIAG(ext_nonclass_type_friend, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "non-class friend type %0 is a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_noreturn_main, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'main' is not allowed to be declared _Noreturn", 402, SFINAE_Suppress, false, false, 2)
DIAG(ext_offsetof_non_pod_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "offset of on non-POD type %0", 380, SFINAE_Suppress, false, false, 2)
DIAG(ext_offsetof_non_standardlayout_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "offset of on non-standard-layout type %0", 380, SFINAE_Suppress, false, false, 2)
DIAG(ext_omp_loop_not_canonical_init, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "initialization clause of OpenMP for loop is not in canonical form ('var = init' or 'T var = init')", 553, SFINAE_Suppress, false, false, 11)
DIAG(ext_opencl_ext_vector_type_rgba_selector, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "vector component name '%0' is an OpenCL version 2.2 feature", 550, SFINAE_Suppress, false, false, 2)
DIAG(ext_operator_new_delete_declared_inline, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "replacement function %0 cannot be declared 'inline'", 365, SFINAE_Suppress, false, false, 2)
DIAG(ext_out_of_line_declaration, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "out-of-line declaration of a member must be a definition", 558, SFINAE_Suppress, false, false, 2)
DIAG(ext_out_of_line_qualified_id_type_names_constructor, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++ specifies that qualified reference to %0 is a constructor name rather than a %select{template name|type}1 in this context, despite preceding %select{'typename'|'template'}2 keyword", 362, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_override_exception_spec, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "exception specification of overriding function is more lax than base version", 422, SFINAE_Suppress, false, false, 2)
DIAG(ext_ovl_ambiguous_oper_binary_reversed, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++20 considers use of overloaded operator '%0' (with operand types %1 and %2) to be ambiguous despite there being a unique best viable function", 22, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_param_default_argument_redefinition, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "redefinition of default argument", 417, SFINAE_Suppress, false, false, 2)
DIAG(ext_param_not_declared, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "parameter %0 was not declared, defaulting to type 'int'", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_param_promoted_not_compatible_with_prototype, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%diff{promoted type $ of K&R function parameter is not compatible with the parameter type $|promoted type of K&R function parameter is not compatible with parameter type}0,1 declared in a previous prototype", 390, SFINAE_Suppress, false, false, 2)
DIAG(ext_partial_spec_not_more_specialized_than_primary, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "%select{class|variable}0 template partial specialization is not more specialized than the primary template", 382, SFINAE_Suppress, false, false, 2)
DIAG(ext_partial_specs_not_deducible, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "%select{class|variable}0 template partial specialization contains %select{a template parameter|template parameters}1 that cannot be deduced; this partial specialization will never be used", 783, SFINAE_Suppress, false, false, 2)
DIAG(ext_plain_complex, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "plain '_Complex' requires a type specifier; assuming '_Complex double'", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_pointer_to_const_ref_member_on_rvalue, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "invoking a pointer to a 'const &' member function on an rvalue is a C++20 extension", 106, SFINAE_SubstitutionFailure, false, false, 2)
DIAG(ext_predef_outside_function, CLASS_WARNING, (unsigned)diag::Severity::Warning, "predefined identifier is only valid inside function", 597, SFINAE_Suppress, false, false, 2)
DIAG(ext_pseudo_dtor_on_void, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "pseudo-destructors on type void are a Microsoft extension", 440, SFINAE_Suppress, false, false, 2)
DIAG(ext_pure_function_definition, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "function definition with pure-specifier is a Microsoft extension", 432, SFINAE_Suppress, false, false, 2)
DIAG(ext_redefinition_of_typedef, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "redefinition of typedef %0 is a C11 feature", 736, SFINAE_Suppress, false, false, 2)
DIAG(ext_register_storage_class, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "ISO C++17 does not allow 'register' storage class specifier", 620, SFINAE_Suppress, false, false, 2)
DIAG(ext_retained_language_linkage, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "friend function %0 retaining previous language linkage is an extension", 630, SFINAE_Suppress, false, false, 2)
DIAG(ext_return_has_expr, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "%select{void function|void method|constructor|destructor}1 %0 should not return a value", 634, SFINAE_Suppress, false, false, 2)
DIAG(ext_return_has_void_expr, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "void %select{function|method|block}1 %0 should not return void expression", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_return_missing_expr, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "non-void %select{function|method}1 %0 should return a value", 634, SFINAE_Suppress, false, false, 2)
DIAG(ext_rvalue_to_reference_access_ctor, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "C++98 requires an accessible copy constructor for class %2 when binding a reference to a temporary; was %select{private|protected}0", 61, SFINAE_AccessControl, false, false, 2)
DIAG(ext_rvalue_to_reference_temp_copy_no_viable, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "no viable constructor %select{copying variable|copying parameter|returning object|initializing statement expression result|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}0 of type %1; C++98 requires a copy constructor when binding a reference to a temporary", 61, SFINAE_Suppress, false, false, 2)
DIAG(ext_sizeof_alignof_function_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "invalid application of '%select{sizeof|alignof|vec_step|__builtin_omp_required_simd_align|__alignof}0' to a function type", 582, SFINAE_Suppress, false, false, 2)
DIAG(ext_sizeof_alignof_void_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "invalid application of '%select{sizeof|alignof|vec_step|__builtin_omp_required_simd_align|__alignof}0' to a void type", 582, SFINAE_Suppress, false, false, 2)
DIAG(ext_standalone_specifier, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'%0' is not permitted on a declaration of a type", 449, SFINAE_Suppress, false, false, 2)
DIAG(ext_star_this_lambda_capture_cxx17, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "capture of '*this' by copy is a C++17 extension", 98, SFINAE_Suppress, false, false, 3)
DIAG(ext_static_data_member_in_union, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "static data member %0 in union is a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_static_non_static, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "redeclaring non-static %0 as static is a Microsoft extension", 433, SFINAE_Suppress, false, false, 2)
DIAG(ext_static_out_of_line, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'static' can only be specified inside the class definition", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_string_literal_operator_template, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "string literal operator templates are a GNU extension", 308, SFINAE_Suppress, false, false, 2)
DIAG(ext_subscript_non_lvalue, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C90 does not allow subscripting non-lvalue array", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_template_arg_extra_parens, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "address non-type template argument cannot be surrounded by parentheses", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_template_arg_local_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "template argument uses local type %0", 396, SFINAE_Suppress, false, false, 2)
DIAG(ext_template_arg_object_internal, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "non-type template argument referring to %select{function|object}0 %1 with internal linkage is a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_template_arg_unnamed_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "template argument uses unnamed type", 765, SFINAE_Suppress, false, false, 2)
DIAG(ext_template_outside_of_template, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'template' keyword outside of a template", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_template_param_shadow, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "declaration of %0 shadows template parameter", 436, SFINAE_Suppress, false, false, 2)
DIAG(ext_template_parameter_default_in_function_template, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "default template arguments for a function template are a C++11 extension", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_addrof_temporary, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "taking the address of a temporary object of type %0", 13, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_addrof_void, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C forbids taking the address of an expression of type 'void'", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_base_super, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "method parameter type %diff{$ does not match super class method parameter type $|does not match super class method parameter type}0,1", 703, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_cast_nonscalar, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "C99 forbids casting nonscalar type %0 to the same type", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_cast_to_union, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "cast to union type is a GNU extension", 309, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_comparison_of_distinct_pointers, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "comparison of distinct pointer types%diff{ ($ and $)|}0,1", 140, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_comparison_of_fptr_to_void, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "equality comparison between function pointer and void pointer (%0 and %1)", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_comparison_of_pointer_integer, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "comparison between pointer and integer (%0 and %1)", 585, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_cond_incompatible_operands, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "incompatible operand types (%0 and %1)", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_cond_incompatible_pointers, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "pointer type mismatch%diff{ ($ and $)|}0,1", 588, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_cond_one_void, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "C99 forbids conditional expressions with only one void side", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_cond_pointer_integer_mismatch, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "pointer/integer type mismatch in conditional expression%diff{ ($ and $)|}0,1", 143, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_convert_discards_qualifiers, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 discards qualifiers", 347, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_convert_incompatible_function_pointer, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "incompatible function pointer types %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3", 343, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_convert_incompatible_pointer, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "incompatible pointer types %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3", 346, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_convert_incompatible_pointer_sign, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 converts between pointers to integer types with different sign", 586, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_convert_int_pointer, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "incompatible integer to pointer conversion %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3", 367, SFINAE_SubstitutionFailure, false, false, 26)
DIAG(ext_typecheck_convert_pointer_int, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "incompatible pointer to integer conversion %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2%select{|; dereference with *|; take the address with &|; remove *|; remove &}3", 367, SFINAE_Suppress, false, false, 26)
DIAG(ext_typecheck_convert_pointer_void_func, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "%select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2 converts between void pointer and function pointer", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_decl_incomplete_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "tentative definition of variable with internal linkage has incomplete non-array type %0", 724, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_indirection_through_void_pointer, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++ does not allow indirection on operand of type %0", 818, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_ordered_comparison_of_function_pointers, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ordered comparison of function pointers (%0 and %1)", 557, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_ordered_comparison_of_pointer_and_zero, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ordered comparison between pointer and zero (%0 and %1) is an extension", 579, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_ordered_comparison_of_pointer_integer, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ordered comparison between pointer and integer (%0 and %1)", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_typecheck_zero_array_size, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "zero size arrays are an extension", 826, SFINAE_Suppress, false, false, 2)
DIAG(ext_typedef_without_a_name, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "typedef requires a name", 449, SFINAE_Suppress, false, false, 2)
DIAG(ext_typename_missing, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "missing 'typename' prior to dependent type name '%0%1'", 737, SFINAE_Suppress, false, false, 2)
DIAG(ext_typename_outside_of_template, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'typename' occurs outside of a template", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_undeclared_unqual_id_with_dependent_base, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of undeclared identifier %0; unqualified lookup into dependent bases of class template %1 is a Microsoft extension", 435, SFINAE_Suppress, false, false, 2)
DIAG(ext_undefined_internal_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C++ requires a definition in this translation unit for %select{function|variable}0 %q1 because its type does not have linkage", 746, SFINAE_Suppress, false, false, 2)
DIAG(ext_unelaborated_friend_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "unelaborated friend declaration is a C++11 extension; specify '%select{struct|interface|union|class|enum}0' to befriend %1", 86, SFINAE_Suppress, false, false, 2)
DIAG(ext_union_member_of_reference_type, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "union member %0 has reference type %1, which is a Microsoft extension", 437, SFINAE_Suppress, false, false, 2)
DIAG(ext_use_out_of_scope_declaration, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of out-of-scope declaration of %0%select{| whose type is not compatible with that of an implicit declaration}1", 559, SFINAE_Suppress, false, false, 2)
DIAG(ext_using_undefined_std, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "using directive refers to implicitly-defined namespace 'std'", 0, SFINAE_Suppress, false, false, 2)
DIAG(ext_variable_sized_type_in_struct, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "field %0 with variable sized type %1 not at the end of a struct or class is a GNU extension", 310, SFINAE_Suppress, false, false, 2)
DIAG(ext_variable_template, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "variable templates are a C++14 extension", 94, SFINAE_Suppress, false, false, 2)
DIAG(ext_variadic_main, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'main' is not allowed to be declared variadic", 402, SFINAE_Suppress, false, false, 2)
DIAG(ext_vla, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "variable length arrays are a C99 feature", 817, SFINAE_Suppress, false, false, 2)
DIAG(ext_vla_folded_to_constant, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "variable length array folded to constant array as an extension", 300, SFINAE_Suppress, false, false, 2)
DIAG(ext_wchar_t_sign_spec, CLASS_EXTENSION, (unsigned)diag::Severity::Error, "'%0' cannot be signed or unsigned", 666, SFINAE_Suppress, false, false, 2)
DIAG(note_access_constrained_by_path, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constrained by %select{|implicitly }1%select{private|protected}0 inheritance here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_access_natural, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|implicitly }1declared %select{private|protected}0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_access_protected_restricted_ctordtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "protected %select{constructor|destructor}0 can only be used to %select{construct|destroy}0 a base class subobject", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_access_protected_restricted_noobject, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "must name member using the type of the current context %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_access_protected_restricted_object, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "can only access this member on an object of type %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_add_std_move, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "call 'std::move' explicitly to avoid copying", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_add_std_move_in_cxx11, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "call 'std::move' explicitly to avoid copying on older compilers", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_add_synthesize_directive, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add a '@synthesize' directive", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_additional_parens_for_variable_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add a pair of parentheses to declare a variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_addrof_ovl_candidate_disabled_by_enable_if_attr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate function made ineligible by enable_if", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_alignas_on_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared with %0 attribute here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_allocated_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "allocated with 'new%select{[]|}0' here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambig_member_ref_object_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "lookup in the object type %0 refers here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambig_member_ref_scope, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "lookup from the current scope refers here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambiguous_atomic_constraints, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "similar constraint expressions not considered equivalent; constraint expressions cannot be considered equivalent unless they originate from the same concept", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambiguous_atomic_constraints_similar_expression, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "similar constraint expression here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambiguous_candidate, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate found by name lookup is %q0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambiguous_inherited_constructor_using, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "inherited from base class %0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambiguous_member_found, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member found by ambiguous name lookup", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ambiguous_type_conversion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because of ambiguity in conversion %diff{of $ to $|between types}0,1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_anonymous_namespace, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "anonymous namespace begins here", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_arc_bridge, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use __bridge to convert directly (no change in ownership)", 0, SFINAE_Suppress, false, false, 7)
DIAG(note_arc_bridge_retained, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use %select{__bridge_retained|CFBridgingRetain call}1 to make an ARC object available as a +1 %0", 0, SFINAE_Suppress, false, false, 7)
DIAG(note_arc_bridge_transfer, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use %select{__bridge_transfer|CFBridgingRelease call}1 to transfer ownership of a +1 %0 into ARC", 0, SFINAE_Suppress, false, false, 7)
DIAG(note_arc_cstyle_bridge, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use __bridge with C-style cast to convert directly (no change in ownership)", 0, SFINAE_Suppress, false, false, 7)
DIAG(note_arc_cstyle_bridge_retained, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use __bridge_retained with C-style cast to make an ARC object available as a +1 %0", 0, SFINAE_Suppress, false, false, 7)
DIAG(note_arc_cstyle_bridge_transfer, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use __bridge_transfer with C-style cast to transfer ownership of a +1 %0 into ARC", 0, SFINAE_Suppress, false, false, 7)
DIAG(note_arc_field_with_ownership, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "field has non-trivial ownership qualification", 0, SFINAE_Suppress, false, false, 10)
DIAG(note_arc_forbidden_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration uses type that is ill-formed in ARC", 0, SFINAE_Suppress, false, false, 10)
DIAG(note_arc_gained_method_convention, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration in interface is not in the '%select{alloc|copy|init|new}0' family because %select{its result type is not an object pointer|its result type is unrelated to its receiver type}1", 0, SFINAE_Suppress, false, false, 5)
DIAG(note_arc_init_returns_unrelated, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "init method must return a type related to its receiver type", 0, SFINAE_Suppress, false, false, 10)
DIAG(note_arc_lost_method_convention, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration in interface", 0, SFINAE_Suppress, false, false, 5)
DIAG(note_arc_retain_cycle_owner, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "block will be retained by %select{the captured object|an object strongly retained by the captured object}0", 0, SFINAE_Suppress, false, false, 28)
DIAG(note_arc_weak_also_accessed_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "also accessed here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_arc_weak_disabled, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration uses __weak, but ARC is disabled", 0, SFINAE_Suppress, false, false, 10)
DIAG(note_arc_weak_no_runtime, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration uses __weak, which the current deployment target does not support", 0, SFINAE_Suppress, false, false, 10)
DIAG(note_array_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "array %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_array_init_plain_string_into_char8_t, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add 'u8' prefix to form a 'char8_t' string literal", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_array_size_conversion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conversion to %select{integral|enumeration}0 type %1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_asm_input_duplicate_first, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constraint '%0' is already present here", 0, SFINAE_Suppress, false, false, 12)
DIAG(note_asm_missing_constraint_modifier, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use constraint modifier \"%0\"", 0, SFINAE_Suppress, false, false, 12)
DIAG(note_assign_lhs_incomplete, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type %0 is incomplete", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_atomic_constraint_evaluated_to_false, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' evaluated to false", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_atomic_constraint_evaluated_to_false_elaborated, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' (%2 %3 %4) evaluated to false", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_atomic_property_fixup_suggest, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "setter and getter must both be synthesized, or both be user defined,or the property must be nonatomic", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_attribute, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "attribute is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_attribute_overloadable_prev_overload, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous %select{unmarked |}0overload of function is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_auto_readonly_iboutlet_fixup_suggest, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "property should be changed to be readwrite", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_availability_specified_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 has been explicitly marked %select{unavailable|deleted|deprecated}1 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_await_ready_no_bool_conversion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "return type of 'await_ready' is required to be contextually convertible to 'bool'", 0, SFINAE_Suppress, false, false, 14)
DIAG(note_bad_memaccess_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicitly cast the pointer to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_base_class_specified_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "base class %0 specified here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_bitfield_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "bit-field is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_block_var_fixit_add_initialization, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean to use __block %0?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_called_by, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "called by %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_callee_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_callee_static_array, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "callee declares array parameter as static here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_carries_dependency_missing_first_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration missing '[[carries_dependency]]' attribute is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_cast_to_void, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cast expression to void to silence warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_cat_conform_to_noescape_prot, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{category|class extension}0 conforms to protocol %1 which defines method %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_change_bitfield_sign, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "consider making the bitfield type %select{unsigned|signed}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_change_calling_conv_fixit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "consider defining %0 with the '%1' calling convention", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_checking_constraints_for_class_spec_id_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking constraint satisfaction for class template partial specialization '%0' required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_checking_constraints_for_function_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking constraint satisfaction for function '%0' required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_checking_constraints_for_template_id_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking constraint satisfaction for template '%0' required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_checking_constraints_for_var_spec_id_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking constraint satisfaction for variable template partial specialization '%0' required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_class_declared, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_cocoa_naming_declare_family, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicitly declare getter %objcinstance0 with '%1' to return an 'unowned' object", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_collapse_loop_count, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "parameter of the 'collapse' clause", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_comparison_synthesized_at, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in defaulted %select{<ERROR>|equality|three-way|equality|relational}0 comparison operator for %1 first required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_compat_assoc, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "compatible type %0 specified here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_concept_specialization_constraint_evaluated_to_false, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' evaluated to false", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_concept_specialization_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking the satisfaction of concept '%0' requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_condition_assign_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "place parentheses around the assignment to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_condition_assign_to_comparison, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use '==' to turn this assignment into an equality comparison", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_condition_or_assign_to_comparison, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use '!=' to turn this compound assignment into an inequality comparison", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_conflicting_attribute, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conflicting attribute is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_conflicting_try_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conflicting %0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constexpr_body_previous_return, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous return statement is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constexpr_ctor_missing_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member not initialized by constructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constexpr_dtor_subobject, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{data member %1|base class %2}0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constexpr_virtual_base_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "virtual base class declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constinit_missing_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add the %select{'require_constant_initialization' attribute|'constinit' specifier}0 to the initializing declaration here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constinit_specified_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "variable declared constinit here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constraint_normalization_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while calculating associated constraint of template '%0' here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constraint_substitution_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while substituting template arguments into constraint expression here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_constraints_not_satisfied, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constraints not satisfied", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_conv_function_declared_at, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type conversion function declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_convert_inline_to_static, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use 'static' to give inline function %0 internal linkage", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_coroutine_promise_call_implicitly_required, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "call to %0 implicitly required by coroutine function here", 0, SFINAE_Suppress, false, false, 14)
DIAG(note_coroutine_promise_implicit_await_transform_required_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "call to 'await_transform' implicitly required by 'co_await' here", 0, SFINAE_Suppress, false, false, 14)
DIAG(note_coroutine_promise_suspend_implicitly_required, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "call to '%select{initial_suspend|final_suspend}0' implicitly required by the %select{initial suspend point|final suspend point}0", 0, SFINAE_Suppress, false, false, 14)
DIAG(note_cuda_conflicting_device_function_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conflicting __device__ function declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_cuda_ovl_candidate_target_mismatch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: target attributes do not match", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_cxx2a_compat_utf8_string_remove_u8, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove 'u8' prefix to avoid a change of behavior; Clang encodes unprefixed narrow string literals as UTF-8", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_decl_unguarded_availability_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "annotate %select{%1|anonymous %1}0 with an availability attribute to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_declaration_not_a_prototype, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "this declaration is not a prototype; add %select{'void'|parameter declarations}0 to make it %select{a prototype for a zero-parameter function|one}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_declare_parameter_strong, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declare the parameter __strong or capture a __block __strong variable to keep values alive across autorelease pools", 0, SFINAE_Suppress, false, false, 5)
DIAG(note_declared_coroutine_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "function is a coroutine due to use of '%0' here", 0, SFINAE_Suppress, false, false, 14)
DIAG(note_declared_nonnull, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared %select{'returns_nonnull'|'nonnull'}0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_declared_required_constant_init_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "required by %select{'require_constant_initialization' attribute|'constinit' specifier}0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deduced_template_arg_substitution_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "during template argument deduction for %select{class|variable}0 template %select{partial specialization |}1%2 %3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deduction_guide_access, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "deduction guide declared %0 by intervening access specifier", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deduction_guide_template_access, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member template declared %0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_default_arg_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of default argument for '%0' required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_default_argument_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "default argument declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_default_function_arg_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of default function argument expression for '%0' required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_ambiguous, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defaulted %0 is implicitly deleted because implied %select{|'==' |'<' }1comparison %select{|for member %3 |for base class %3 }2is ambiguous", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_calls_deleted, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defaulted %0 is implicitly deleted because it would invoke a deleted comparison function%select{| for member %2| for base class %2}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_cannot_deduce, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "return type of defaulted 'operator<=>' cannot be deduced because return type %2 of three-way comparison for %select{|member|base class}0 %1 is not a standard comparison category type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_cannot_deduce_callee, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "selected 'operator<=>' for %select{|member|base class}0 %1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_cannot_deduce_undeduced_auto, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|member|base class}0 %1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_inaccessible, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defaulted %0 is implicitly deleted because it would invoke a %select{private|protected}3 %4%select{ member of %6| member of %6 to compare member %2| to compare base class %2}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_no_viable_function, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defaulted %0 is implicitly deleted because there is no viable comparison function%select{| for member %2| for base class %2}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_no_viable_function_synthesized, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "three-way comparison cannot be synthesized because there is no viable function for %select{'=='|'<'}0 comparison", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_not_constexpr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-constexpr comparison function would be used to compare %select{|member %1|base class %1}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_not_constexpr_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-constexpr comparison function declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_not_rewritten_callee, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defaulted %0 is implicitly deleted because this non-rewritten comparison function would be the best match for the comparison", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_reference_member, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defaulted %0 is implicitly deleted because class %1 has a reference member", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defaulted_comparison_union, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defaulted %0 is implicitly deleted because %2 is a %select{union-like class|union}1 with variant members", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_defined_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 defined here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_delete_conversion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conversion to pointer type %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_delete_non_virtual, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "qualify call to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_assign_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{copy|move}0 assignment operator of %1 is implicitly deleted because field %2 is of %select{reference|const-qualified}4 type %3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_copy_ctor_rvalue_reference, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "copy constructor of %0 is implicitly deleted because field %1 is of rvalue reference type %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_copy_user_declared_move, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "copy %select{constructor|assignment operator}0 is implicitly deleted because %1 has a user-declared move %select{constructor|assignment operator}2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_default_ctor_all_const, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{default constructor of|constructor inherited by}0 %1 is implicitly deleted because all %select{data members|data members of an anonymous union member}2 are const-qualified", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_default_ctor_uninit_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{default constructor of|constructor inherited by}0 %1 is implicitly deleted because field %2 of %select{reference|const-qualified}4 type %3 would not be initialized", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_dtor_no_operator_delete, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "virtual destructor requires an unambiguous, accessible 'operator delete'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_special_member_class_subobject, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{default constructor of|copy constructor of|move constructor of|copy assignment operator of|move assignment operator of|destructor of|constructor inherited by}0 %1 is implicitly deleted because %select{base class %3|%select{||||variant }4field %3}2 %select{has %select{no|a deleted|multiple|an inaccessible|a non-trivial}4 %select{%select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor|%select{default|corresponding|default|default|default}4 constructor}0|destructor}5%select{||s||}4|is an ObjC pointer}6", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deleted_type_mismatch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "function is implicitly deleted because its declared type does not match the type of an implicit %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_dependent_function_template_spec_discard_reason, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate ignored: %select{not a function template|not a member of the enclosing namespace; did you mean to explicitly qualify the specialization?}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_dependent_non_type_default_arg_in_partial_spec, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template parameter is used in default argument declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_dependent_var_use, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "must qualify identifier to find this declaration in dependent base class", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_deprecated_this_capture, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add an explicit capture of 'this' to capture '*this' by reference", 0, SFINAE_Suppress, false, false, 3)
DIAG(note_designated_init_mixed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "first non-designated initializer is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_destructor_type_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type %0 is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_direct_method_declared_at, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "direct method %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_due_to_dllexported_class, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "due to %0 being dllexported%select{|; try compiling in C++11 mode}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_duplicate_asm_operand_name, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "asm operand name \"%0\" first referenced here", 0, SFINAE_Suppress, false, false, 12)
DIAG(note_duplicate_element, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "element %0 also has value %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_empty_body_on_separate_line, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "put the semicolon on a separate line to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_empty_parens_default_ctor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove parentheses to declare a variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_empty_parens_function_call, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "change this ',' to a ';' to call %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_empty_parens_zero_initialize, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "replace parentheses with an initializer to declare a variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_enters_block_captures_cxx_obj, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump enters lifetime of block which captures a destructible C++ object", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_enters_block_captures_non_trivial_c_struct, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump enters lifetime of block which captures a C struct that is non-trivial to destroy", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_enters_block_captures_strong, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump enters lifetime of block which strongly captures a variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_enters_block_captures_weak, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump enters lifetime of block which weakly captures a variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_entity_declared_at, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_enum_specialized_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "enum %0 was explicitly specialized here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_equality_comparison_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove extraneous parentheses around the comparison to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_equality_comparison_to_assign, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use '=' to turn this equality comparison into an assignment", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_equivalent_internal_linkage_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared here%select{ in module '%1'|}0", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_evaluate_comparison_first, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "place parentheses around comparison expression to evaluate it first", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_evaluating_exception_spec_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in evaluation of exception specification for %q0 needed here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits___block, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits scope of __block variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_block_captures_cxx_obj, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits lifetime of block which captures a destructible C++ object", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_block_captures_non_trivial_c_struct, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits lifetime of block which captures a C struct that is non-trivial to destroy", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_block_captures_strong, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits lifetime of block which strongly captures a variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_block_captures_weak, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits lifetime of block which weakly captures a variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_cleanup, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits scope of variable with __attribute__((cleanup))", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_cxx_catch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits catch block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_cxx_try, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits try block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits scope of variable with non-trivial destructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_objc_autoreleasepool, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits autoreleasepool block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_objc_catch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits @catch block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_objc_finally, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits @finally block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_objc_strong, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits scope of __strong variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_objc_synchronized, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits @synchronized block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_objc_try, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits @try block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_objc_weak, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits scope of __weak variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_seh_except, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits __except block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_seh_finally, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits __finally block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_seh_try, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits __try block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_exits_temporary_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump exits scope of lifetime-extended temporary with non-trivial destructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_explicit_ctor_deduction_guide_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit %select{constructor|deduction guide}0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_explicit_instantiation_candidate, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit instantiation candidate function %q0 template here %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_explicit_instantiation_definition_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit instantiation definition is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_explicit_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit instantiation refers here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_explicit_specialization_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit specialization declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_explicit_template_arg_substitution_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while substituting explicitly-specified template arguments into function template %0 %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_explicit_template_spec_does_not_need_header, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'template<>' header not required for explicitly-specialized class %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_export, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "export block begins here", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_expr_requirement_constraints_not_satisfied, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 type constraint '%1' was not satisfied:", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_expr_requirement_constraints_not_satisfied_simple, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 %1 does not satisfy %2:", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_expr_requirement_expr_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid: %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_expr_requirement_expr_unknown_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_expr_requirement_noexcept_not_met, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' may throw an exception", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_expr_requirement_type_requirement_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid: %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_expr_requirement_type_requirement_unknown_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_extern_c_begins_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "extern \"C\" language linkage specification begins here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_extern_c_global_conflict, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared %select{in global scope|with C language linkage}0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_fallthrough_insert_semi_fixit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you forget ';'?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_field_designator_found, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "field designator refers here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_final_dtor_non_final_class_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "mark %0 as '%select{final|sealed}1' to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_final_overrider, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "final overrider of %q0 in %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_flexible_array_member, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "initialized flexible array member %0 is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_for_range_begin_end, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "selected '%select{begin|end}0' %select{function|template }1%2 with iterator type %3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_for_range_invalid_iterator, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in implicit call to 'operator%select{!=|*|++}0' for iterator of type %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_for_range_member_begin_end_ignored, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member is not a candidate because range type %0 has no '%select{end|begin}1' member", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_format_fix_specifier, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean to use '%0'?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_format_security_fixit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "treat the string as an argument to avoid this", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_format_string_defined, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "format string is defined here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_forward_class, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "forward declaration of class here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_forward_template_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "forward declaration of template entity is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_found_mutex_near_match, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "found near match '%0'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_from_diagnose_if, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "from 'diagnose_if' attribute on %0:", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_function_style_cast_add_parentheses, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add enclosing parentheses to perform a function-style cast", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_function_suggestion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean %0?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_function_template_deduction_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while substituting deduced template arguments into function template %0 %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_function_template_spec_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of function template specialization %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_function_template_spec_matched, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "function template %q0 matches specialization %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_function_to_function_call, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "suffix with parentheses to turn this into a function call", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_function_warning_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "prefix with the address-of operator to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_getter_unavailable, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "or because setter is declared here, but no getter method %0 is found", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_global_module_introducer_missing, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add 'module;' to the start of the file to introduce a global module fragment", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_goto_ms_asm_label, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "inline assembly label %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_guarded_by_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "Guarded_by declared here.", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_hidden_overloaded_virtual_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "hidden overloaded virtual function %q0 declared here%select{|: different classes%diff{ ($ vs $)|}2,3|: different number of parameters (%2 vs %3)|: type mismatch at %ordinal2 parameter%diff{ ($ vs $)|}3,4|: different return type%diff{ ($ vs $)|}2,3|: different qualifiers (%2 vs %3)|: different exception specifications}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_hidden_tag, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type declaration hidden", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_hiding_object, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration hides type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ice_conversion_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conversion to %select{integral|enumeration}0 type %1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_illegal_field_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "field of illegal %select{type|pointer type}0 %1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_implementation_declared, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class implementation is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_implemented_by_class, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "when implemented by class %0", 0, SFINAE_Suppress, false, false, 9)
DIAG(note_implicit_delete_this_in_destructor_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking implicit 'delete this' for virtual destructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_implicit_member_target_infer_collision, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "implicit %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 inferred target collision: call to both %select{__device__|__global__|__host__|__host__ __device__}1 and %select{__device__|__global__|__host__|__host__ __device__}2 members", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_implicit_param_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is an implicit parameter", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_implicitly_deleted, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicitly defaulted function was implicitly deleted here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_binding_decl_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in implicit initialization of binding declaration %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_class_initializer_float_type_cxx11, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add 'constexpr'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_class_initializer_not_yet_parsed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "default member initializer declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_declaration_of_implicit_equality_comparison, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while declaring the corresponding implicit 'operator==' for this defaulted 'operator<=>'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_declaration_of_implicit_special_member, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while declaring the implicit %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}1 for %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_for_range, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "when looking up '%select{begin|end}0' function for range expression of type %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_omitted_aggregate_initializer, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in implicit initialization of %select{array element %1 with omitted initializer|field %1 with omitted initializer|trailing array elements in runtime-sized array new}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_in_reference_temporary_list_initializer, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in initialization of temporary of type %0 created to list-initialize this reference", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_include_header_or_declare, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "include the header <%0> or explicitly provide a declaration for '%1'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_incomplete_class_and_qualified_id, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conformance of forward class %0 to protocol %1 can not be confirmed", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_indirect_goto_target, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "possible target of %select{indirect|asm}0 goto statement", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_indirection_through_null, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "consider using __builtin_trap() or qualifying pointer with 'volatile'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_inequality_comparison_to_or_assign, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use '|=' to turn this inequality comparison into an or-assignment", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_init_list_narrowing_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "insert an explicit cast to silence this issue", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_init_with_default_member_initalizer, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "initializing field %0 with default member initializer", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_insert_break_fixit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "insert 'break;' to avoid fall-through", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_insert_fallthrough_fixit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "insert '%0;' to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_inst_declaration_hint, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add an explicit instantiation declaration to suppress this warning if %q0 is explicitly instantiated in another translation unit", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_instantiation_contexts_suppressed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "(skipping %0 context%s0 in backtrace; use -ftemplate-backtrace-limit=0 to see all)", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_instantiation_required_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{implicit|explicit}0 instantiation first required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_it_delegates_to, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "it delegates to", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ivar_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "instance variable is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_lambda_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "lambda expression begins here", 0, SFINAE_Suppress, false, false, 3)
DIAG(note_lambda_to_block_conv, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "implicit capture of lambda object due to conversion to block pointer here", 0, SFINAE_Suppress, false, false, 3)
DIAG(note_lifetime_extending_member_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{%select{reference|'std::initializer_list'}0 member|member with %select{reference|'std::initializer_list'}0 subobject}1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_local_decl_close_match, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "local declaration nearly matches", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_local_decl_close_param_match, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type of %ordinal0 parameter of local declaration does not match definition%diff{ ($ vs $)|}1,2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_local_var_initializer, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{via initialization of|binding reference}0 variable %select{%2 |}1here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_lock_exclusive_and_shared, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "the other acquisition of %0 '%1' is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_locked_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 acquired here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_logical_instead_of_bitwise_change_operator, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use '%0' for a bitwise operation", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_logical_instead_of_bitwise_remove_constant, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove constant to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_logical_not_fix, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add parentheses after the '!' to evaluate the %select{comparison|bitwise operator}0 first", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_logical_not_silence_with_parens, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add parentheses around left hand side expression to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_loop_iteration_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{decremented|incremented}0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_main_change_return_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "change return type to 'int'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_main_remove_noreturn, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove '_Noreturn'", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_declared_at, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_def_close_const_match, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member declaration does not match because it %select{is|is not}0 const qualified", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_def_close_match, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member declaration nearly matches", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_def_close_param_match, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type of %ordinal0 parameter of member declaration does not match definition%diff{ ($ vs $)|}1,2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_first_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "member %0 first declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_reference_arrow_from_operator_arrow, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'->' applied to return value of the operator->() declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_member_synthesized_at, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in %select{implicit|defaulted}0 %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}1 for %2 first required here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_memsize_comparison_cast_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicitly cast the argument to size_t to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_memsize_comparison_paren, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean to compare the result of %0 instead?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_method_declared_at, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "method %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_method_return_type_change, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "compiler has implicitly changed method %0 return type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_method_sent_forward_class, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "method %0 is used for the forward class", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_module_import_not_at_top_level, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 begins here", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_multiversioning_caused_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "function multiversioning caused by this declaration", 0, SFINAE_Suppress, false, false, 0)
DIAG(note_namespace_defined_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "namespace %0 defined here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_neon_vector_initializer_non_portable, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "consider using vld1_%0%1() to initialize a vector from memory, or vcreate_%0%1() to initialize from an integer constant", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_neon_vector_initializer_non_portable_q, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "consider using vld1q_%0%1() to initialize a vector from memory, or vcombine_%0%1(vcreate_%0%1(), vcreate_%0%1()) to initialize from integer constants", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nested_requirement_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking the satisfaction of nested requirement requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nested_requirement_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid: %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nested_requirement_unknown_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_next_field_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "next field declaration is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_next_ivar_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "next %select{instance variable declaration|synthesized instance variable}0 is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_deducible_parameter, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-deducible template parameter %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_instantiated_member_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "not-yet-instantiated member is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_base_class, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is not literal because it has base class %1 of non-literal type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is not literal because it has data member %1 of %select{non-literal|volatile}3 type %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_incomplete, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "incomplete type %0 is not a literal type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_lambda, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "lambda closure types are non-literal types before C++17", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_no_constexpr_ctors, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is not literal because it is not an aggregate and has no constexpr constructors other than copy or move constructors", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_non_constexpr_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is not literal because its destructor is not constexpr", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_nontrivial_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is not literal because it has a non-trivial destructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_user_provided_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is not literal because it has a user-provided destructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_literal_virtual_base, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{struct|interface|class}0 with virtual base %plural{1:class|:classes}1 is not a literal type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_template_in_template_id_found, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-template declaration found by name lookup", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_trivial_c_union, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{%2 has subobjects that are|%3 has type %2 that is}0 non-trivial to %select{default-initialize|destruct|copy}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_non_usual_function_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-usual %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontemplate_decl_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-templated declaration is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_default_arg, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because it has a default argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "field is non-trivial to %select{copy|default-initialize}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_has_virtual, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because type %0 has a virtual %select{member function|base class}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_in_class_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because field %0 has an initializer", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_no_copy, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because no %select{<<ERROR>>|constructor|constructor|assignment operator|assignment operator|<<ERROR>>}2 can be used to %select{<<ERROR>>|copy|move|copy|move|<<ERROR>>}2 %select{base class|field|an object}0 of type %3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_no_def_ctor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because %select{base class of |field of |}0type %1 has no default constructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_objc_ownership, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because type %0 has a member with %select{no|no|__strong|__weak|__autoreleasing}1 ownership", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_param_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because its parameter is %diff{of type $, not $|of the wrong type}2,3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_subobject, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because the function selected to %select{construct|copy|move|copy|move|destroy}2 %select{base class|field}0 of type %1 is not trivial", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_user_provided, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because %select{base class of |field of |}0type %1 has a user-provided %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_variadic, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because it is a variadic function", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_nontrivial_virtual_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "destructor for %0 is not trivial because it is virtual", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_noreturn_missing_first_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declaration missing '[[noreturn]]' attribute is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_not_found_by_two_phase_lookup, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 should be declared prior to the call site%select{| or in %2| or in an associated namespace of one of its arguments}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_not_module_interface_add_export, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add 'export' here if this is intended to be a module interface unit", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_nullability_fix_it, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "insert '%select{_Nonnull|_Nullable|_Null_unspecified}0' if the %select{pointer|block pointer|member pointer|array parameter}1 %select{should never be null|may be null|should not declare nullability}0", 0, SFINAE_Suppress, false, false, 21)
DIAG(note_nullability_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 specified here", 0, SFINAE_Suppress, false, false, 21)
DIAG(note_nullability_type_specifier, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use nullability type specifier %0 to affect the innermost pointer type of %1", 0, SFINAE_Suppress, false, false, 21)
DIAG(note_objc_circular_container_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_objc_designated_init_marked_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "method marked as designated initializer of the class here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_objc_literal_comparison_isequal, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use 'isEqual:' instead", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_objc_literal_method_param, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{first|second|third}0 parameter has unexpected type %1 (should be %2)", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_objc_literal_method_return, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "method returns unexpected type %0 (should be an object type)", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_objc_needs_superclass, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add a super class to fix this problem", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_objc_type_param_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type parameter %0 declared here", 0, SFINAE_Suppress, false, false, 22)
DIAG(note_objc_unsafe_perform_selector_method_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "method %0 that returns %1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_omp_atomic_capture, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{expected assignment expression|expected compound statement|expected exactly two expression statements|expected in right hand side of the first expression}0", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_atomic_previous_clause, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'%0' clause used here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_atomic_read_write, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{expected an expression statement|expected built-in assignment operator|expected expression of scalar type|expected lvalue expression}0", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_atomic_update, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{expected an expression statement|expected built-in binary or unary operator|expected unary decrement/increment operation|expected expression of scalar type|expected assignment expression|expected built-in binary operator|expected one of '+', '*', '-', '/', '&', '^', '%|', '<<', or '>>' built-in operations|expected in right hand side of expression}0", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_collapse_ordered_expr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "as specified in %select{'collapse'|'ordered'|'collapse' and 'ordered'}0 clause%select{||s}0", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_conversion_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conversion to %select{integral|enumeration}0 type %1 declared here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_critical_hint_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|previous }0'hint' clause with value '%1'", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_critical_no_hint, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|previous }0directive with no 'hint' clause specified", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_default_dsa_none, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit data sharing attribute requested here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_defaultmap_attr_none, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit data sharing attribute, data mapping attribute, or is_device_ptr clause requested here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_explicit_dsa, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "defined as %0", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_implicit_dsa, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "implicitly determined as %0", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_invalid_length_on_this_ptr_mapping, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "expected length on mapping of 'this' array section expression to be '1'", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_invalid_lower_bound_on_this_ptr_mapping, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "expected lower bound on mapping of 'this' array section expression to be '0' or not specified", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_invalid_subscript_on_this_ptr_map, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "expected 'this' subscript expression on map clause to be 'this[0]'", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_loop_cond_requres_compatible_incr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "loop step is expected to be %select{negative|positive}0 due to this condition", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_marked_declare_variant_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "marked as 'declare variant' here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_marked_device_type_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "marked as 'device_type(%0)' here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_nested_statement_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{statement|directive}0 outside teams construct here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_nested_teams_construct_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "nested teams construct here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_nowait_clause_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'nowait' clause is here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_ordered_param, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'ordered' clause with specified parameter", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_predetermined_dsa, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{static data member is predetermined as shared|variable with static storage duration is predetermined as shared|loop iteration variable is predetermined as private|loop iteration variable is predetermined as linear|loop iteration variable is predetermined as lastprivate|constant variable is predetermined as shared|global variable is predetermined as shared|non-shared variable in a task construct is predetermined as firstprivate|variable with automatic storage duration is predetermined as private}0%select{|; perhaps you forget to enclose 'omp %2' directive into a parallel or another task region?}1", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_previous_allocator, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous allocator is specified here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_previous_critical_region, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous 'critical' region starts here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_previous_grainsize_num_tasks, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'%0' clause is specified here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_previous_named_if_clause, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous clause with directive name modifier specified here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_previous_reduction_identifier, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previously marked as task_reduction with different reduction operation", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_referenced, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previously referenced here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_requires_encountered_target, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "target previously encountered here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_requires_previous_clause, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 clause previously used here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_omp_task_predetermined_firstprivate_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "predetermined as a firstprivate in a task construct here", 0, SFINAE_Suppress, false, false, 11)
DIAG(note_opencl_typedef_access_qualifier, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previously declared '%0' here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_operator_arrow_depth, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use -foperator-arrow-depth=N to increase 'operator->' limit", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_operator_arrow_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'operator->' declared here produces an object of type %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_operator_arrows_suppressed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "(skipping %0 'operator->'%s0 in backtrace)", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_overridden_marked_noescape, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "parameter of overridden method is annotated with __attribute__((noescape))", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_overridden_method, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "overridden method is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_overridden_virtual_function, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "overridden virtual function is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_ambiguous_oper_binary_reversed_candidate, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "ambiguity is between a regular call to this operator and a call with the argument order reversed", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_builtin_candidate, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "built-in candidate %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %3}1%select{| has different class%diff{ (expected $ but has $)|}5,6| has different number of parameters (expected %5 but has %6)| has type mismatch at %ordinal5 parameter%diff{ (expected $ but has $)|}6,7| has different return type%diff{ ($ expected but has $)|}5,6| has different qualifiers (expected %5 but found %6)| has different exception specification}4", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_arity, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: requires%select{ at least| at most|}3 %4 argument%s4, but %5 %plural{1:was|:were}5 provided", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_arity_one, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: %select{requires at least|allows at most single|requires single}3 argument %4, but %plural{0:no|:%5}5 arguments were provided", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_addrspace, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: cannot %select{pass pointer to|bind reference in}5 %3 %select{as a pointer to|to object in}5 %4 in %ordinal6 argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_addrspace_this, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: 'this' object is in %3, but method expects object in %4", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_arc_conv, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: cannot implicitly convert argument %diff{of type $ to $|type to parameter type}3,4 for %select{%ordinal6 argument|object argument}5 under ARC", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_base_to_derived_conv, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: cannot %select{convert from|convert from|bind}3 %select{base class pointer|superclass|base class object of type}3 %4 to %select{derived class pointer|subclass|derived class reference}3 %5 for %ordinal6 argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_conv, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: no known conversion %diff{from $ to $|from argument type to parameter type}3,4 for %select{%ordinal6 argument|object argument}5%select{|; dereference the argument with *|; take the address of the argument with &|; remove *|; remove &}7", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_conv_incomplete, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: cannot convert argument of incomplete type %diff{$ to $|to parameter type}3,4 for %select{%ordinal6 argument|object argument}5%select{|; dereference the argument with *|; take the address of the argument with &|; remove *|; remove &}7", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_cvr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: %ordinal5 argument (%3) would lose %select{const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}4 qualifier%select{||s||s|s|s}4", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_cvr_this, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: 'this' argument has type %3, but method is not marked %select{const|restrict|const or restrict|volatile|const or volatile|volatile or restrict|const, volatile, or restrict}4", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_deduction, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: failed template argument deduction", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_gc, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: %select{%ordinal7|'this'}6 argument (%3) has %select{no|__weak|__strong}4 ownership, but parameter has %select{no|__weak|__strong}5 ownership", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_list_argument, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: cannot convert initializer list argument to %4", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_lvalue, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: expects an l-value for %select{%ordinal4 argument|object argument}3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_overload, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: no overload of %4 matching %3 for %ordinal5 argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_ownership, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: %select{%ordinal7|'this'}6 argument (%3) has %select{no|__unsafe_unretained|__strong|__weak|__autoreleasing}4 ownership, but parameter has %select{no|__unsafe_unretained|__strong|__weak|__autoreleasing}5 ownership", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_target, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: call to %select{__device__|__global__|__host__|__host__ __device__|invalid}3 function from %select{__device__|__global__|__host__|__host__ __device__|invalid}4 function", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_bad_unaligned, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: %ordinal5 argument (%3) would lose __unaligned qualifier", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_constraints_not_satisfied, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 not viable: constraints not satisfied", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_deduced_mismatch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: deduced type %diff{$ of %select{|element of }4%ordinal0 parameter does not match adjusted type $ of %select{|element of }4argument|of %select{|element of }4%ordinal0 parameter does not match adjusted type of %select{|element of }4argument}1,2%3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_deleted, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{function|function|function (with reversed parameter order)|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|constructor (the implicit move constructor)|function (the implicit copy assignment operator)|function (the implicit move assignment operator)|function (the implicit 'operator==' for this 'operator<=>)'|inherited constructor}0%select{| template| %2}1 has been %select{explicitly made unavailable|explicitly deleted|implicitly deleted}3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_disabled_by_enable_if, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: disabled by %0%1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_disabled_by_extension, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate unavailable as it requires OpenCL extension '%0' to be enabled", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_disabled_by_function_cond_attr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate disabled: %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_disabled_by_requirement, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: requirement '%0' was not satisfied%1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_explicit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit %select{constructor|conversion function|deduction guide}0 is not a candidate%select{| (explicit specifier evaluates to true)}1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_explicit_arg_mismatch_named, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: invalid explicitly-specified argument for template parameter %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_explicit_arg_mismatch_unnamed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: invalid explicitly-specified argument for %ordinal0 template parameter", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_has_pass_object_size_params, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate address cannot be taken because parameter %0 has pass_object_size attribute", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_illegal_constructor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{constructor|template}0 ignored: instantiation %select{takes|would take}0 its own class type by value", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_illegal_constructor_adrspace_mismatch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate constructor ignored: cannot be used to construct an object in address space %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_incomplete_deduction, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: couldn't infer template argument %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_incomplete_deduction_pack, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: deduced too few arguments for expanded pack %0; no argument for %ordinal1 expanded parameter in deduced argument pack %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_inconsistent_deduction, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: deduced %select{conflicting types|conflicting values|conflicting templates|packs of different lengths}0 for parameter %1%diff{ ($ vs. $)|}2,3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_inconsistent_deduction_types, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: deduced values %diff{of conflicting types for parameter %0 (%1 of type $ vs. %3 of type $)|%1 and %3 of conflicting types for parameter %0}2,4", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_inherited_constructor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constructor from base class %0 inherited here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_inherited_constructor_slice, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate %select{constructor|template}0 ignored: inherited constructor cannot be used to %select{copy|move}1 object", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_instantiation_depth, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: substitution exceeded maximum template instantiation depth", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_non_deduced_mismatch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: could not match %diff{$ against $|types}0,1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_non_deduced_mismatch_qualified, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: could not match %q0 against %q1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_substitution_failure, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: substitution failure%0%1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_underqualified, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: cannot deduce a type for %0 that would make %2 equal %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_candidate_unsatisfied_constraints, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "candidate template ignored: constraints not satisfied%0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_surrogate_cand, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conversion candidate of type %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ovl_too_many_candidates, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remaining %0 candidate%s0 omitted; pass -fshow-overloads=all to show them", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_ownership_returns_index_mismatch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared with index %0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_parameter_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "passing argument to parameter here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_parameter_mapping_substitution_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while substituting into concept arguments here; substitution failures not allowed in concept arguments", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_parameter_named_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "passing argument to parameter %0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_parameter_pack_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "parameter pack %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_parameter_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "parameter of type %0 is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_partial_availability_specified_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 has been marked as being introduced in %1 %2 here, but the deployment target is %1 %3", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_partial_spec_match, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "partial specialization matches %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_partial_spec_not_more_specialized_than_primary, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_partial_specialization_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicit specialization declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_performs_forbidden_arc_conversion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "inline function performs a conversion which is forbidden in ARC", 0, SFINAE_Suppress, false, false, 10)
DIAG(note_pointer_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "pointer %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_possible_target_of_call, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "possible target for call", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_pragma_attribute_applied_decl_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "when applied to this declaration", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_pragma_attribute_region_ends_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'#pragma clang attribute push' regions ends here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_pragma_pack_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous '#pragma pack' directive that modifies alignment is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_pragma_pack_pop_instead_reset, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you intend to use '#pragma pack (pop)' instead of '#pragma pack()'?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_precedence_bitwise_first, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "place parentheses around the %0 expression to evaluate it first", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_precedence_conditional_first, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "place parentheses around the '?:' expression to evaluate it first", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_precedence_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "place parentheses around the '%0' expression to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_prev_module_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous module declaration is here", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_prev_module_definition, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previously defined here", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_prev_module_definition_from_ast_file, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "module loaded from '%0'", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_prev_partial_spec_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous declaration of class template partial specialization %0 is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_access_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previously declared '%1' here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_attribute, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous attribute is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_builtin_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is a builtin with type %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_exception_handler, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "for type %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_explicit_instantiation, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous explicit instantiation is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_field_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous initialization for field %0 is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_initializer, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous initialization %select{|with side effects }0is here%select{| (side effects will not occur at run time)}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_ms_inheritance, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous inheritance model specified here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_namespace_alias, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previously defined as an alias for %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_template_specialization, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous template specialization is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_previous_uuid, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous uuid specified here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_printf_c_str, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean to call the %0 method?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_prior_template_arg_substitution, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while substituting prior template arguments into %select{non-type|template}0 template parameter%1 %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_private_extern, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use __attribute__((visibility(\"hidden\"))) attribute instead", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_private_module_fragment, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "private module fragment begins here", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_property_attribute, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "property %0 is declared %select{deprecated|unavailable|partial}1 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_property_declare, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "property declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_property_synthesize, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "property synthesized here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by___block, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses setup of __block variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_cleanup, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of variable with __attribute__((cleanup))", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_constexpr_if, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump enters controlled statement of constexpr if", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_cxx_catch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of catch block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_cxx_try, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of try block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_if_available, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump enters controlled statement of if available", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_non_trivial_c_struct_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of variable of non-trivial C struct type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_autoreleasepool, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses auto release push of @autoreleasepool block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_catch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of @catch block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_fast_enumeration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump enters Objective-C fast enumeration loop", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_finally, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of @finally block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_strong_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of __strong variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_synchronized, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of @synchronized block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_try, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of @try block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_objc_weak_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of __weak variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_seh_except, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of __except block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_seh_finally, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of __finally block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_seh_try, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of __try block", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_variable_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses variable initialization", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_variable_non_pod, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of non-POD variable", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_variable_nontriv_destructor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses variable with a non-trivial destructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_vla, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of variable length array", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_vla_type_alias, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of VLA type alias", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protected_by_vla_typedef, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "jump bypasses initialization of VLA typedef", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protocol_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "protocol is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protocol_decl_undefined, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "protocol %0 has no definition", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protocol_method, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "protocol method is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_protocol_property_declare, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "it could also be property %select{of type %1|without attribute '%1'|with attribute '%1'|with getter %1|with setter %1}0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_pure_qualified_call_kext, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "qualified call to %0::%1 is treated as a virtual call to %1 due to -fapple-kext", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_pure_virtual_function, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "unimplemented pure virtual method %0 in %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_raii_guard_add_name, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add a variable name to declare a %0 initialized with %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_receiver_class_declared, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "receiver is instance of class declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_receiver_expr_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "receiver expression is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_receiver_is_id, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "receiver is treated with 'id' type for purpose of method lookup", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_redefinition_include_same_file, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'%0' included multiple times, additional include site here", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_redefinition_modules_same_file, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'%0' included multiple times, additional include site in header from module '%1'", 0, SFINAE_Suppress, false, false, 13)
DIAG(note_ref_or_ptr_member_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{reference|pointer}0 member declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_refconst_member_not_initialized, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{const|reference}0 member %1 will never be initialized", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_reference_is_return_value, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 returns a reference", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_referenced_class_template, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class template declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_reinterpret_updowncast_use_static, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use 'static_cast' to adjust the pointer correctly while %select{upcasting|downcasting}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_related_result_type_explicit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{overridden|current}0 method is explicitly declared 'instancetype'%select{| and is expected to return an instance of its class type}0", 0, SFINAE_Suppress, false, false, 19)
DIAG(note_related_result_type_family, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{overridden|current}0 method is part of the '%select{|alloc|copy|init|mutableCopy|new|autorelease|dealloc|finalize|release|retain|retainCount|self}1' method family%select{| and is expected to return an instance of its class type}0", 0, SFINAE_Suppress, false, false, 19)
DIAG(note_related_result_type_inferred, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{class|instance}0 method %1 is assumed to return an instance of its receiver type (%2)", 0, SFINAE_Suppress, false, false, 19)
DIAG(note_related_result_type_overridden, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "overridden method returns an instance of its class type", 0, SFINAE_Suppress, false, false, 19)
DIAG(note_remove_abs, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove the call to '%0' since unsigned values cannot be negative", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_remove_max_call, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove call to max function and unsigned zero argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_remove_move, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove std::move call here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_remove_parens_for_variable_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove parentheses to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_replace_abs_function, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use function '%0' instead", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_requires_expr_ill_formed_expr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "expression is invalid: %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_requires_expr_no_implicit_conversion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "no implicit conversion exists between expression type %0 and expected type %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_rewriting_operator_as_spaceship, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while rewriting comparison as call to 'operator<=>' declared here", 0, SFINAE_Suppress, false, false, 0)
DIAG(note_riscv_repeated_interrupt_attribute, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "repeated RISC-V 'interrupt' attribute is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_sentinel_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{function|method|block}0 has been explicitly marked sentinel here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_shadow_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared here", 0, SFINAE_Suppress, false, false, 0)
DIAG(note_silence_aligned_allocation_unavailable, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "if you supply your own aligned allocation functions, use -faligned-allocation to silence this diagnostic", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_single_arg_concept_specialization_constraint_evaluated_to_false, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 %1 does not satisfy %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_specialized_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "attempt to specialize declaration here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_specialized_entity, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "explicitly specialized declaration is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_static_for_internal_linkage, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declare 'static' if the %select{variable|function}0 is not intended to be used outside of this translation unit", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_string_plus_scalar_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use array indexing to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_strlcpycat_wrong_size, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "change size argument to be the size of the destination", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_strncat_wrong_size, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "change the argument to be the free space in the destination buffer minus the terminating null byte", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_struct_class_suggestion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean %select{struct|interface|class}0 here?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_substituted_constraint_expr_is_ill_formed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "because substituted constraint expression is ill-formed%0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_suppress_ctad_maybe_unsupported, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add a deduction guide to suppress this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_suppressed_class_declare, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class with specified objc_requires_property_definitions attribute is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_surrounding_namespace_ends_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "surrounding namespace with visibility attribute ends here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_surrounding_namespace_starts_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "surrounding namespace with visibility attribute starts here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_suspicious_bzero_size_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "parenthesize the second argument to silence", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_suspicious_sizeof_memset_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{parenthesize the third argument|cast the second argument to 'int'}0 to silence", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_switch_conversion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conversion to %select{integral|enumeration}0 type %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_arg_internal_object, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-type template argument refers to %select{function|object}0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_arg_refers_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-type template argument refers here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_arg_refers_here_func, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template argument refers to function template %0, here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_class_explicit_specialization_was_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class template %0 was explicitly specialized here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_class_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of template class %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_class_instantiation_was_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class template %0 was instantiated here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_decl_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{function template|class template|variable template|type alias template|template template parameter}0 %1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_default_arg_checking, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "while checking a default template argument used here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_enum_def_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of enumeration %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_exception_spec_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of exception specification for %0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_kw_refers_to_non_template, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared as a non-template here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_member_class_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of member class %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_member_function_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of member function %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_nontype_parm_different_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template non-type parameter has a different type %0 in template argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_nontype_parm_prev_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous non-type template parameter with type %0 is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_nsdmi_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of default member initializer %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_param_different_kind, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template parameter has a different kind in template argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_param_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template parameter is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_param_list_different_arity, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{too few|too many}0 template parameters in template template argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_param_prev_default_arg, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous default template argument defined here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_parameter_pack_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous %select{template type|non-type template|template template}0 parameter%select{| pack}1 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_parameter_pack_non_pack, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{template type|non-type template|template template}0 parameter%select{| pack}1 does not match %select{template type|non-type template|template template}0 parameter%select{ pack|}1 in template argument", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_prev_declaration, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous template %select{declaration|template parameter}0 is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_recursion_depth, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use -ftemplate-depth=N to increase recursive template instantiation depth", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_requirement_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of requirement here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_static_data_member_def_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of static data member %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_type_alias_instantiation_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of template type alias %0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_unnamed_type_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "unnamed type used in template argument was declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_template_variable_def_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in instantiation of variable template specialization %q0 requested here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_thread_warning_in_fun, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "Thread warning in function %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_throw_in_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{destructor|deallocator}0 has a %select{non-throwing|implicit non-throwing}1 exception specification", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_throw_in_function, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "function declared non-throwing here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_throw_underaligned_obj, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "required alignment of type %0 (%1 bytes) is larger than the supported alignment of C++ exception objects on this target (%2 bytes)", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_transparent_union_first_field_size_align, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{alignment|size}0 of first field is %1 bits", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_type_incomplete, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is incomplete", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_type_requirement_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid: %2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_type_requirement_unknown_substitution_error, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{and|because}0 '%1' would be invalid", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_typecheck_assign_const, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{function %1 which returns const-qualified type %2 declared here|variable %1 declared const here|%select{non-|}1static data member %2 declared const here|member function %q1 is declared const here|%select{|nested }1data member %2 declared const here}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_typecheck_invalid_operands_converted, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{first|second}0 operand was implicitly converted to type %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_typecheck_member_reference_suggestion, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean to use '.' instead?", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_typedef_changes_linkage, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use a tag name here to establish linkage prior to definition", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_typename_member_refers_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "referenced member %0 is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_typename_refers_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "referenced %0 is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_unguarded_available_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "enclose %0 in %select{an @available|a __builtin_available}1 check to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_uninit_fixit_remove_cond, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "remove the %select{'%1' if its condition|condition if it}0 is always %select{false|true}2", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_uninit_in_this_constructor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "during field initialization in %select{this|the implicit default}0 constructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_uninit_reference_member, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "uninitialized reference member is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_uninit_var_use, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{uninitialized use occurs|variable is captured by block}0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_unreachable_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "silence by adding parentheses to mark code as explicitly dead", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_use_ifdef_guards, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "unguarded header; consider using #ifdef guards or #pragma once", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_use_non_reference_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use non-reference type %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_use_reference_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use reference type %0 to prevent copying", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_use_thread_local, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use 'thread_local' to allow this", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_use_type_or_non_reference, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use non-reference type %0 to keep the copy or type %1 to prevent copying", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_used_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "used here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_used_in_initialization_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "used in initialization here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_user_declared_ctor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "implicit default constructor suppressed by user-declared constructor", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_using_decl, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|previous }0using declaration", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_using_decl_class_member_workaround, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use %select{an alias declaration|a typedef declaration|a reference|a const variable|a constexpr variable}0 instead", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_using_decl_conflict, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "conflicting declaration", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_using_decl_target, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "target of using declaration", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_using_value_decl_missing_typename, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "add 'typename' to treat this using declaration as a type", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_value_initialization_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in value-initialization of type %0 here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_var_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "variable %0 is declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_var_explicitly_captured_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "variable %0 is%select{| explicitly}1 captured here", 0, SFINAE_Suppress, false, false, 3)
DIAG(note_var_fixit_add_initialization, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "initialize the variable %0 to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_var_prev_partial_spec_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous declaration of variable template partial specialization is here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_vbase_moved_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{%1 is a virtual base class of base class %2 declared here|virtual base class %1 declared here}0", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_vla_unsupported, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "variable length arrays are not supported for the current target", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_which_delegates_to, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "which delegates to", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_while_in_implementation, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "detected while default synthesizing properties in class implementation", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_widen_bitfield, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "widen this field to %0 bits to store all values of %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_within_field_of_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "within field of type %0 declared here", 0, SFINAE_Suppress, false, false, 2)
DIAG(note_xor_used_as_pow_silence, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "replace expression with '%0' %select{|or use 'xor' instead of '^' }1to silence this warning", 0, SFINAE_Suppress, false, false, 2)
DIAG(override_keyword_hides_virtual_member_function, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-virtual member function marked '%0' hides virtual member %select{function|functions}1", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(override_keyword_only_allowed_on_virtual_member_functions, CLASS_ERROR, (unsigned)diag::Severity::Error, "only virtual member functions can be marked '%0'", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(warn_abs_too_small, CLASS_WARNING, (unsigned)diag::Severity::Warning, "absolute value function %0 given an argument of type %1 but has parameter of type %2 which may cause truncation of value", 8, SFINAE_Suppress, false, false, 2)
DIAG(warn_abstract_final_class, CLASS_WARNING, (unsigned)diag::Severity::Warning, "abstract class is marked '%select{final|sealed}0'", 9, SFINAE_Suppress, false, false, 2)
DIAG(warn_abstract_vbase_init_ignored, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "initializer for virtual base class %0 of abstract class %1 will never be used", 10, SFINAE_Suppress, false, false, 2)
DIAG(warn_access_decl_deprecated, CLASS_WARNING, (unsigned)diag::Severity::Warning, "access declarations are deprecated; use using declarations instead", 179, SFINAE_Suppress, false, false, 29)
DIAG(warn_accessor_property_type_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "type of property %0 does not match type of accessor %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_acquire_requires_negative_cap, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "acquiring %0 '%1' requires negative capability '%2'", 729, SFINAE_Suppress, false, false, 2)
DIAG(warn_acquired_before, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 '%1' must be acquired before '%2'", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_acquired_before_after_cycle, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "Cycle in acquired_before/after dependencies, starting with '%0'", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_addition_in_bitshift, CLASS_WARNING, (unsigned)diag::Severity::Warning, "operator '%0' has lower precedence than '%1'; '%1' will be evaluated first", 658, SFINAE_Suppress, false, false, 2)
DIAG(warn_address_of_reference_bool_conversion, CLASS_WARNING, (unsigned)diag::Severity::Warning, "reference cannot be bound to dereferenced null pointer in well-defined C++ code; pointer may be assumed to always convert to true", 742, SFINAE_Suppress, false, false, 26)
DIAG(warn_address_of_reference_null_compare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "reference cannot be bound to dereferenced null pointer in well-defined C++ code; comparison may be assumed to always evaluate to %select{true|false}0", 721, SFINAE_Suppress, false, false, 2)
DIAG(warn_alignment_builtin_useless, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{aligning a value|the result of checking whether a value is aligned}0 to 1 byte is %select{a no-op|always true}0", 713, SFINAE_Suppress, false, false, 2)
DIAG(warn_alloca, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of function %0 is discouraged; there is no way to check for failure but failure may still occur, resulting in a possibly exploitable security vulnerability", 16, SFINAE_Suppress, false, false, 2)
DIAG(warn_alloca_align_alignof, CLASS_WARNING, (unsigned)diag::Severity::Warning, "second argument to __builtin_alloca_with_align is supposed to be in bits", 17, SFINAE_Suppress, false, false, 2)
DIAG(warn_ambiguous_suitable_delete_function_found, CLASS_WARNING, (unsigned)diag::Severity::Warning, "multiple suitable %0 functions for %1; no 'operator delete' function will be invoked if initialization throws an exception", 18, SFINAE_Suppress, false, false, 2)
DIAG(warn_anon_bitfield_width_exceeds_type_width, CLASS_WARNING, (unsigned)diag::Severity::Warning, "width of anonymous bit-field (%0 bits) exceeds width of its type; value will be truncated to %1 bit%s1", 65, SFINAE_Suppress, false, false, 2)
DIAG(warn_arc_lifetime_result_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ARC %select{unused|__unsafe_unretained|__strong|__weak|__autoreleasing}0 lifetime qualifier on return type is ignored", 322, SFINAE_Suppress, false, false, 5)
DIAG(warn_arc_literal_assign, CLASS_WARNING, (unsigned)diag::Severity::Warning, "assigning %select{array literal|dictionary literal|numeric literal|boxed expression|<should not happen>|block literal}0 to a weak %select{property|variable}1; object will be released after assignment", 33, SFINAE_Suppress, false, false, 5)
DIAG(warn_arc_object_memaccess, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{destination for|source of}0 this %1 call is a pointer to ownership-qualified type %2", 29, SFINAE_Suppress, false, false, 5)
DIAG(warn_arc_perform_selector_leaks, CLASS_WARNING, (unsigned)diag::Severity::Warning, "performSelector may cause a leak because its selector is unknown", 30, SFINAE_Suppress, false, false, 2)
DIAG(warn_arc_possible_repeated_use_of_weak, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "weak %select{variable|property|implicit property|instance variable}0 %1 may be accessed multiple times in this %select{function|method|block|lambda}2 and may be unpredictably set to nil; assign to a strong variable to keep the object alive", 28, SFINAE_Suppress, false, false, 2)
DIAG(warn_arc_repeated_use_of_weak, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "weak %select{variable|property|implicit property|instance variable}0 %1 is accessed multiple times in this %select{function|method|block|lambda}2 but may be unpredictably set to nil; assign to a strong variable to keep the object alive", 31, SFINAE_Suppress, false, false, 2)
DIAG(warn_arc_retain_cycle, CLASS_WARNING, (unsigned)diag::Severity::Warning, "capturing %0 strongly in this block is likely to lead to a retain cycle", 32, SFINAE_Suppress, false, false, 28)
DIAG(warn_arc_retained_assign, CLASS_WARNING, (unsigned)diag::Severity::Warning, "assigning retained object to %select{weak|unsafe_unretained}0 %select{property|variable}1; object will be released after assignment", 33, SFINAE_Suppress, false, false, 5)
DIAG(warn_arc_retained_property_assign, CLASS_WARNING, (unsigned)diag::Severity::Warning, "assigning retained object to unsafe property; object will be released after assignment", 33, SFINAE_Suppress, false, false, 5)
DIAG(warn_arc_strong_pointer_objc_pointer, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "method parameter of type %0 with no explicit ownership", 245, SFINAE_Suppress, false, false, 10)
DIAG(warn_argument_invalid_range, CLASS_WARNING, (unsigned)diag::Severity::Error, "argument value %0 is outside the valid range [%1, %2]", 34, SFINAE_Suppress, false, false, 2)
DIAG(warn_arith_conv_enum_float, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 %select{floating-point|enumeration}1 type %2 %plural{2:with|4:from|:and}0 %select{enumeration|floating-point}1 type %3", 238, SFINAE_Suppress, false, false, 26)
DIAG(warn_arith_conv_enum_float_cxx2a, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 %select{floating-point|enumeration}1 type %2 %plural{2:with|4:from|:and}0 %select{enumeration|floating-point}1 type %3 is deprecated", 191, SFINAE_Suppress, false, false, 29)
DIAG(warn_arith_conv_mixed_anon_enum_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2", 24, SFINAE_Suppress, false, false, 2)
DIAG(warn_arith_conv_mixed_anon_enum_types_cxx2a, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2 is deprecated", 180, SFINAE_Suppress, false, false, 29)
DIAG(warn_arith_conv_mixed_enum_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2", 237, SFINAE_Suppress, false, false, 26)
DIAG(warn_arith_conv_mixed_enum_types_cxx2a, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2 is deprecated", 190, SFINAE_Suppress, false, false, 29)
DIAG(warn_arm_interrupt_calling_convention, CLASS_WARNING, (unsigned)diag::Severity::Warning, "call to function without interrupt attribute could clobber interruptee's VFP registers", 250, SFINAE_Suppress, false, false, 2)
DIAG(warn_array_index_exceeds_bounds, CLASS_WARNING, (unsigned)diag::Severity::Warning, "array index %0 is past the end of the array (which contains %1 element%s2)", 35, SFINAE_Suppress, false, false, 2)
DIAG(warn_array_index_precedes_bounds, CLASS_WARNING, (unsigned)diag::Severity::Warning, "array index %0 is before the beginning of the array", 35, SFINAE_Suppress, false, false, 2)
DIAG(warn_asm_label_on_auto_decl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignored asm label '%0' on automatic variable", 0, SFINAE_Suppress, false, false, 12)
DIAG(warn_asm_mismatched_size_modifier, CLASS_WARNING, (unsigned)diag::Severity::Warning, "value size does not match register size specified by the constraint and modifier", 39, SFINAE_Suppress, false, false, 12)
DIAG(warn_assume_aligned_too_great, CLASS_WARNING, (unsigned)diag::Severity::Warning, "requested alignment must be %0 bytes or smaller; maximum alignment assumed", 74, SFINAE_Suppress, false, false, 2)
DIAG(warn_assume_side_effects, CLASS_WARNING, (unsigned)diag::Severity::Warning, "the argument to %0 has side effects that will be discarded", 41, SFINAE_Suppress, false, false, 2)
DIAG(warn_at_available_unchecked_use, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{@available|__builtin_available}0 does not guard availability here; use if (%select{@available|__builtin_available}0) instead", 775, SFINAE_Suppress, false, false, 2)
DIAG(warn_atl_uuid_deprecated, CLASS_WARNING, (unsigned)diag::Severity::Warning, "specifying 'uuid' as an ATL attribute is deprecated; use __declspec instead", 186, SFINAE_Suppress, false, false, 29)
DIAG(warn_atomic_implicit_seq_cst, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit use of sequentially-consistent atomic may incur stronger memory barriers than necessary", 45, SFINAE_Suppress, false, false, 2)
DIAG(warn_atomic_op_has_invalid_memory_order, CLASS_WARNING, (unsigned)diag::Severity::Warning, "memory order argument to atomic operation is invalid", 46, SFINAE_Suppress, false, false, 2)
DIAG(warn_atomic_property_rule, CLASS_WARNING, (unsigned)diag::Severity::Warning, "writable atomic property %0 cannot pair a synthesized %select{getter|setter}1 with a user defined %select{getter|setter}2", 48, SFINAE_Suppress, false, false, 2)
DIAG(warn_attr_abi_tag_namespace, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'abi_tag' attribute on %select{non-inline|anonymous}0 namespace ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attr_on_unconsumable_class, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "consumed analysis attribute is attached to member of class '%0' which isn't marked as consumable", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_address_multiple_identical_qualifiers, CLASS_WARNING, (unsigned)diag::Severity::Warning, "multiple identical address spaces specified for type", 218, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_after_definition_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 after definition is ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_argument_n_negative, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute parameter %1 is negative and will be ignored", 161, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_dll_instantiated_base_class, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "propagating dll attribute to %select{already instantiated|explicitly specialized}0 base class template without dll attribute is not supported", 777, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_dll_redeclaration, CLASS_WARNING, (unsigned)diag::Severity::Warning, "redeclaration of %q0 should not add %q1 attribute", 208, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_dllexport_explicit_instantiation_decl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "explicit instantiation declaration should not be 'dllexport'", 209, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_dllexport_explicit_instantiation_def, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'dllexport' attribute ignored on explicit instantiation definition", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_dllimport_static_field_definition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "definition of dllimport static field", 210, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_iboutlet, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute can only be applied to instance variables or properties", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_ignored_for_field_of_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute ignored for field of type %1", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_ignored_on_inline, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute ignored on inline function", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_invalid_on_definition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' attribute cannot be specified on a definition", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_no_builtin_invalid_builtin_name, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' is not a valid builtin name for %1", 378, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_nonnull_no_pointers, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'nonnull' attribute applied to function with no pointer arguments", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_nonnull_parm_no_args, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'nonnull' attribute when used on parameters takes no arguments", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_not_on_decl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute ignored when parsing type", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_packed_for_bitfield, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'packed' attribute was ignored on bit-fields with single-byte alignment in older versions of GCC and Clang", 49, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_pointer_or_reference_only, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to a pointer or reference (%1 is invalid)", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_pointers_only, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to%select{| constant}1 pointer arguments", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_precede_definition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute declaration must precede definition", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_protected_visibility, CLASS_WARNING, (unsigned)diag::Severity::Warning, "target does not support 'protected' visibility; using 'default'", 782, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_return_pointers_only, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to return values that are pointers", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_return_pointers_refs_only, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to return values that are pointers or references", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_section_drectve, CLASS_WARNING, (unsigned)diag::Severity::Warning, "#pragma %0(\".drectve\") has undefined behavior, use #pragma comment(linker, ...) instead", 418, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_section_on_redeclaration, CLASS_WARNING, (unsigned)diag::Severity::Warning, "section attribute is specified on redeclared variable", 637, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_sentinel_named_arguments, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'sentinel' attribute requires named arguments", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_sentinel_not_variadic, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'sentinel' attribute only supported for variadic %select{functions|blocks}0", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_type_not_supported, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute argument not supported: %1", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_unknown_visibility, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unknown visibility %0", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_void_function_method, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 cannot be applied to %select{functions|Objective-C method}1 without return value", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_weak_on_field, CLASS_WARNING, (unsigned)diag::Severity::Warning, "__weak attribute cannot be specified on a field declaration", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_weak_on_local, CLASS_WARNING, (unsigned)diag::Severity::Warning, "__weak attribute cannot be specified on an automatic variable when ARC is not enabled", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_wrong_decl_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to %select{functions|unions|variables and functions|functions and methods|functions, methods and blocks|functions, methods, and parameters|variables|variables and fields|variables, data members and tag types|types and namespaces|variables, functions and classes|kernel functions|non-K&R-style functions}1", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_attribute_wrong_decl_type_str, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to %1", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_auto_implicit_atomic_property, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "property is assumed atomic when auto-synthesizing the property", 324, SFINAE_Suppress, false, false, 2)
DIAG(warn_auto_readonly_iboutlet_property, CLASS_WARNING, (unsigned)diag::Severity::Warning, "readonly IBOutlet property %0 when auto-synthesized may not work correctly with 'nib' loader", 613, SFINAE_Suppress, false, false, 2)
DIAG(warn_auto_storage_class, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'auto' storage class specifier is redundant and incompatible with C++11", 82, SFINAE_Suppress, false, false, 2)
DIAG(warn_auto_synthesizing_protocol_property, CLASS_WARNING, (unsigned)diag::Severity::Warning, "auto property synthesis will not synthesize property %0 declared in protocol %1", 535, SFINAE_Suppress, false, false, 2)
DIAG(warn_auto_var_is_id, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'auto' deduced as 'id' in declaration of %0", 54, SFINAE_Suppress, false, false, 2)
DIAG(warn_autosynthesis_property_in_superclass, CLASS_WARNING, (unsigned)diag::Severity::Warning, "auto property synthesis will not synthesize property %0; it will be implemented by its superclass, use @dynamic to acknowledge intention", 533, SFINAE_Suppress, false, false, 2)
DIAG(warn_autosynthesis_property_ivar_match, CLASS_WARNING, (unsigned)diag::Severity::Warning, "autosynthesized property %0 will use %select{|synthesized}1 instance variable %2, not existing instance variable %3", 509, SFINAE_Suppress, false, false, 2)
DIAG(warn_availability_on_static_initializer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring availability attribute %select{on '+load' method|with constructor attribute|with destructor attribute}0", 55, SFINAE_Suppress, false, false, 2)
DIAG(warn_availability_swift_unavailable_deprecated_only, CLASS_WARNING, (unsigned)diag::Severity::Warning, "only 'unavailable' and 'deprecated' are supported for Swift availability", 55, SFINAE_Suppress, false, false, 2)
DIAG(warn_availability_unknown_platform, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unknown platform %0 in availability macro", 55, SFINAE_Suppress, false, false, 2)
DIAG(warn_availability_version_ordering, CLASS_WARNING, (unsigned)diag::Severity::Warning, "feature cannot be %select{introduced|deprecated|obsoleted}0 in %1 version %2 before it was %select{introduced|deprecated|obsoleted}3 in version %4; attribute ignored", 55, SFINAE_Suppress, false, false, 2)
DIAG(warn_bad_cxx_cast_nested_pointer_addr_space, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{reinterpret_cast|C-style cast}0 from %1 to %2 changes address space of nested pointers", 347, SFINAE_Suppress, false, false, 2)
DIAG(warn_bad_function_cast, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "cast from function call of type %0 to non-matching type %1", 59, SFINAE_Suppress, false, false, 2)
DIAG(warn_bad_receiver_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "receiver type %0 is not 'id' or interface pointer, consider casting it to 'id'", 614, SFINAE_Suppress, false, false, 2)
DIAG(warn_base_class_is_uninit, CLASS_WARNING, (unsigned)diag::Severity::Warning, "base class %0 is uninitialized when used here to access %q1", 757, SFINAE_Suppress, false, false, 2)
DIAG(warn_bind_ref_member_to_parameter, CLASS_WARNING, (unsigned)diag::Severity::Warning, "binding reference member %0 to stack allocated %select{variable|parameter}2 %1", 165, SFINAE_Suppress, false, false, 2)
DIAG(warn_binding_null_to_reference, CLASS_WARNING, (unsigned)diag::Severity::Warning, "binding dereferenced null pointer to reference has undefined behavior", 500, SFINAE_Suppress, false, false, 2)
DIAG(warn_bitfield_too_small_for_enum, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "bit-field %0 is not wide enough to store all enumerators of %1", 64, SFINAE_Suppress, false, false, 26)
DIAG(warn_bitfield_width_exceeds_type_width, CLASS_WARNING, (unsigned)diag::Severity::Warning, "width of bit-field %0 (%1 bits) exceeds the width of its type; value will be truncated to %2 bit%s2", 65, SFINAE_Suppress, false, false, 2)
DIAG(warn_bitwise_negation_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "bitwise negation of a boolean expression%select{;| always evaluates to 'true';}0 did you mean logical negation?", 71, SFINAE_Suppress, false, false, 2)
DIAG(warn_bitwise_op_in_bitwise_op, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'%0' within '%1'", 67, SFINAE_Suppress, false, false, 2)
DIAG(warn_block_capture_autoreleasing, CLASS_WARNING, (unsigned)diag::Severity::Warning, "block captures an autoreleasing out-parameter, which may result in use-after-free bugs", 68, SFINAE_Suppress, false, false, 5)
DIAG(warn_block_literal_attributes_on_omitted_return_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 ignored, because it cannot be applied to omitted return type", 317, SFINAE_Suppress, false, false, 0)
DIAG(warn_block_literal_qualifiers_on_omitted_return_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' qualifier on omitted return type %1 has no effect", 322, SFINAE_Suppress, false, false, 0)
DIAG(warn_bool_switch_condition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "switch condition has boolean value", 707, SFINAE_Suppress, false, false, 2)
DIAG(warn_braces_around_scalar_init, CLASS_WARNING, (unsigned)diag::Severity::Warning, "braces around scalar initializer", 72, SFINAE_Suppress, false, false, 2)
DIAG(warn_break_binds_to_switch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'break' is bound to loop, GCC binds it to switch", 283, SFINAE_Suppress, false, false, 2)
DIAG(warn_builtin_chk_overflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' will always overflow; destination buffer has size %1, but size argument is %2", 76, SFINAE_Suppress, false, false, 2)
DIAG(warn_builtin_unknown, CLASS_WARNING, (unsigned)diag::Severity::Error, "use of unknown builtin %0", 331, SFINAE_Suppress, false, false, 2)
DIAG(warn_call_to_pure_virtual_member_function_from_ctor_dtor, CLASS_WARNING, (unsigned)diag::Severity::Warning, "call to pure virtual member function %0 has undefined behavior; overrides of %0 in subclasses are not available in the %select{constructor|destructor}1 of %2", 127, SFINAE_Suppress, false, false, 2)
DIAG(warn_call_wrong_number_of_arguments, CLASS_WARNING, (unsigned)diag::Severity::Warning, "too %select{few|many}0 arguments in call to %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_cannot_pass_non_pod_arg_to_vararg, CLASS_WARNING, (unsigned)diag::Severity::Error, "cannot pass object of %select{non-POD|non-trivial}0 type %1 through variadic %select{function|block|method|constructor}2; call will abort at runtime", 487, SFINAE_Suppress, false, false, 2)
DIAG(warn_cannot_resolve_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "cannot resolve lock expression", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_case_empty_range, CLASS_WARNING, (unsigned)diag::Severity::Warning, "empty case range specified", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_case_value_overflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "overflow converting case value to switch condition type (%0 to %1)", 706, SFINAE_Suppress, false, false, 2)
DIAG(warn_cast_align, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "cast from %0 to %1 increases required alignment from %2 to %3", 128, SFINAE_Suppress, false, false, 2)
DIAG(warn_cast_calling_conv, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cast between incompatible calling conventions '%0' and '%1'; calls through this pointer may abort at runtime", 129, SFINAE_Suppress, false, false, 2)
DIAG(warn_cast_nonnull_to_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "nonnull %select{function call|parameter}0 '%1' will evaluate to 'true' on first encounter", 583, SFINAE_Suppress, false, false, 26)
DIAG(warn_cast_pointer_from_sel, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cast of type %0 to %1 is deprecated; use sel_getName instead", 130, SFINAE_Suppress, false, false, 2)
DIAG(warn_cast_qual, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "cast from %0 to %1 drops %select{const and volatile qualifiers|const qualifier|volatile qualifier}2", 131, SFINAE_Suppress, false, false, 2)
DIAG(warn_cast_qual2, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "cast from %0 to %1 must have all intermediate pointers const qualified to be safe", 131, SFINAE_Suppress, false, false, 2)
DIAG(warn_category_method_impl_match, CLASS_WARNING, (unsigned)diag::Severity::Warning, "category is implementing a method which will also be implemented by its primary class", 534, SFINAE_Suppress, false, false, 2)
DIAG(warn_cconv_knr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "function with no prototype cannot use the %0 calling convention", 457, SFINAE_Suppress, false, false, 2)
DIAG(warn_cconv_unsupported, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 calling convention is not supported %select{for this target|on variadic function|on constructor/destructor|on builtin function}1", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_cdtor_function_try_handler_mem_expr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cannot refer to a non-static member from the handler of a %select{constructor|destructor}0 function try block", 240, SFINAE_Suppress, false, false, 2)
DIAG(warn_cfstring_truncated, CLASS_WARNING, (unsigned)diag::Severity::Warning, "input conversion stopped due to an input byte that does not belong to the input codeset UTF-8", 3, SFINAE_Suppress, false, false, 2)
DIAG(warn_class_method_not_found, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class method %objcclass0 not found (return type defaults to 'id')", 522, SFINAE_Suppress, false, false, 2)
DIAG(warn_class_method_not_found_with_typo, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class method %objcclass0 not found (return type defaults to 'id'); did you mean %objcclass2?", 522, SFINAE_Suppress, false, false, 2)
DIAG(warn_cleanup_ext, CLASS_WARNING, (unsigned)diag::Severity::Warning, "GCC does not allow the 'cleanup' attribute argument to be anything other than a simple identifier", 283, SFINAE_Suppress, false, false, 2)
DIAG(warn_cocoa_naming_owned_rule, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property follows Cocoa naming convention for returning 'owned' objects", 531, SFINAE_Suppress, false, false, 2)
DIAG(warn_collection_expr_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "collection expression type %0 may not respond to %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_comma_operator, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "possible misuse of comma operator here", 137, SFINAE_Suppress, false, false, 2)
DIAG(warn_comparison_always, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{self-|array }0comparison always evaluates to %select{a constant|true|false|'std::strong_ordering::equal'}1", 713, SFINAE_Suppress, false, false, 2)
DIAG(warn_comparison_bitwise_always, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "bitwise comparison always evaluates to %select{false|true}0", 712, SFINAE_Suppress, false, false, 2)
DIAG(warn_comparison_bitwise_or, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "bitwise or with non-zero value always evaluates to true", 712, SFINAE_Suppress, false, false, 2)
DIAG(warn_comparison_mixed_enum_types, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2", 233, SFINAE_Suppress, false, false, 2)
DIAG(warn_comparison_mixed_enum_types_cxx2a, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2 is deprecated", 188, SFINAE_Suppress, false, false, 29)
DIAG(warn_comparison_of_mixed_enum_types_switch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "comparison of different enumeration types in switch statement%diff{ ($ and $)|}0,1", 235, SFINAE_Suppress, false, false, 2)
DIAG(warn_concatenated_nsarray_literal, CLASS_WARNING, (unsigned)diag::Severity::Warning, "concatenated NSString literal for an NSArray expression - possibly missing a comma", 545, SFINAE_Suppress, false, false, 2)
DIAG(warn_condition_is_assignment, CLASS_WARNING, (unsigned)diag::Severity::Warning, "using the result of an assignment as a condition without parentheses", 571, SFINAE_Suppress, false, false, 2)
DIAG(warn_condition_is_idiomatic_assignment, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "using the result of an assignment as a condition without parentheses", 316, SFINAE_Suppress, false, false, 2)
DIAG(warn_conditional_mixed_enum_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2", 234, SFINAE_Suppress, false, false, 26)
DIAG(warn_conditional_mixed_enum_types_cxx2a, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{arithmetic between|bitwise operation between|comparison of|conditional expression between|compound assignment of}0 different enumeration types%diff{ ($ and $)|}1,2 is deprecated", 189, SFINAE_Suppress, false, false, 29)
DIAG(warn_conflicting_overriding_param_modifiers, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting distributed object modifiers on parameter type in declaration of %0", 567, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_overriding_param_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting parameter types in declaration of %0%diff{: $ vs $|}1,2", 567, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_overriding_ret_type_modifiers, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting distributed object modifiers on return type in declaration of %0", 567, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_overriding_ret_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting return type in declaration of %0%diff{: $ vs $|}1,2", 567, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_overriding_variadic, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting variadic declaration of method and its implementation", 567, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_param_modifiers, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conflicting distributed object modifiers on parameter type in implementation of %0", 205, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_param_types, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conflicting parameter types in implementation of %0%diff{: $ vs $|}1,2", 444, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_ret_type_modifiers, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conflicting distributed object modifiers on return type in implementation of %0", 205, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_ret_types, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conflicting return type in implementation of %0%diff{: $ vs $|}1,2", 445, SFINAE_Suppress, false, false, 2)
DIAG(warn_conflicting_variadic, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conflicting variadic declaration of method and its implementation", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_conv_to_base_not_used, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conversion function converting %0 to its base class %1 will never be used", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_conv_to_self_not_used, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conversion function converting %0 to itself will never be used", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_conv_to_void_not_used, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conversion function converting %0 to %1 will never be used", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_coroutine_promise_unhandled_exception_required_with_exceptions, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 is required to declare the member 'unhandled_exception()' when exceptions are enabled", 154, SFINAE_Suppress, false, false, 14)
DIAG(warn_cstruct_memaccess, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{destination for|source of|first operand of|second operand of}0 this %1 call is a pointer to record %2 that is not trivial to %select{primitive-default-initialize|primitive-copy}3", 494, SFINAE_Suppress, false, false, 2)
DIAG(warn_ctad_maybe_unsupported, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 may not intend to support class template argument deduction", 158, SFINAE_Suppress, false, false, 2)
DIAG(warn_ctor_parm_shadows_field, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constructor parameter %0 shadows the field %1 of %2", 651, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_compat_constexpr_body_invalid_stmt, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of this statement in a constexpr %select{function|constructor}0 is incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_compat_constexpr_body_multiple_return, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "multiple return statements in constexpr function is incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_compat_constexpr_body_no_return, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constexpr function with no return statements is incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_compat_constexpr_local_var, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable declaration in a constexpr %select{function|constructor}0 is incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_compat_constexpr_type_definition, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "type definition in a constexpr %select{function|constructor}0 is incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_compat_deduced_return_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "return type deduction is incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_compat_generic_lambda, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "generic lambdas are incompatible with C++11", 114, SFINAE_Suppress, false, false, 3)
DIAG(warn_cxx11_compat_init_capture, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "initialized lambda captures are incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 3)
DIAG(warn_cxx11_compat_variable_template, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable templates are incompatible with C++ standards before C++14", 114, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx11_gnu_attribute_on_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 ignored, because it cannot be applied to a type", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx14_compat_class_template_argument_deduction, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "class template argument deduction is incompatible with C++ standards before C++17%select{|; for compatibility, use explicit type name %1}0", 112, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx14_compat_constexpr_not_const, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'constexpr' non-static member function will not be implicitly 'const' in C++14; add 'const' to avoid a change in behavior", 149, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx14_compat_decomp_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "decomposition declarations are incompatible with C++ standards before C++17", 112, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx14_compat_inline_variable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "inline variables are incompatible with C++ standards before C++17", 112, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx14_compat_star_this_lambda_capture, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "by value capture of '*this' is incompatible with C++ standards before C++17", 112, SFINAE_Suppress, false, false, 3)
DIAG(warn_cxx14_compat_template_nontype_parm_auto_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "non-type template parameters declared with %0 are incompatible with C++ standards before C++17", 112, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_adl_only_template_id, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of function template name with no prior function template declaration in function call with explicit template arguments is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_constexpr_body_invalid_stmt, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of this statement in a constexpr %select{function|constructor}0 is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_constexpr_ctor_missing_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constexpr constructor that does not initialize all members is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_constexpr_function_try_block, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "function try block in constexpr %select{function|constructor}0 is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_constexpr_local_var_no_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "uninitialized variable in a constexpr %select{function|constructor}0 is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_constexpr_union_ctor_no_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constexpr union constructor that does not initialize any member is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_constexpr_virtual, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "virtual constexpr functions are incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_decomp_decl_spec, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "decomposition declaration declared %plural{1:'%1'|:with '%1' specifiers}0 is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_defaulted_comparison, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "defaulted comparison operators are incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_defaulted_method_type_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicitly defaulting this %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 with a type different from the implicit type is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_designated_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "designated initializers are incompatible with C++ standards before C++20", 111, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_equals_this_lambda_capture, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicit capture of 'this' with a capture default of '=' is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 3)
DIAG(warn_cxx17_compat_exception_spec_in_signature, CLASS_WARNING, (unsigned)diag::Severity::Warning, "mangled name of %0 will change in C++17 due to non-throwing exception specification in function signature", 96, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_init_capture_pack, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "initialized lambda capture packs are incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 3)
DIAG(warn_cxx17_compat_lambda_def_ctor_assign, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{default construction|assignment}0 of lambda is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 3)
DIAG(warn_cxx17_compat_pointer_to_const_ref_member_on_rvalue, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "invoking a pointer to a 'const &' member function on an rvalue is incompatible with C++ standards before C++20", 111, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx17_compat_unicode_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'char8_t' type specifier is incompatible with C++ standards before C++20", 110, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx20_compat_constinit, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'constinit' specifier is incompatible with C++ standards before C++20", 103, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx2a_compat_aggregate_init_with_ctors, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "aggregate initialization of type %0 with user-declared constructors is incompatible with C++20", 103, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx2a_compat_utf8_string, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "type of UTF-8 string literal will change from array of const char to array of const char8_t in C++20", 103, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_array_size_conversion, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion from array size expression of type %0 to %select{integral|enumeration}1 type %2 is incompatible with C++98", 121, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_auto_type_specifier, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'auto' type specifier is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_cast_fn_obj, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "cast between pointer-to-function and pointer-to-object is incompatible with C++98", 121, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_constexpr, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'constexpr' specifier is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_ctor_list_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constructor call from initializer list is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_delegating_ctor, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "delegating constructors are incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_empty_scalar_initializer, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "scalar initialized from empty initializer list is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_enum_friend, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "befriending enumeration type %0 is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_enum_nested_name_spec, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "enumeration type in nested name specifier is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_explicit_conversion_functions, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicit conversion functions are incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_friend_is_member, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "friend declaration naming a member of the declaring class is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_goto_into_protected_scope, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "jump from this goto statement to its label is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_indirect_goto_in_protected_scope, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "jump from this %select{indirect|asm}0 goto statement to one of its possible targets is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_initializer_list_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "initialization of initializer_list object is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_non_static_member_use, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of non-static data member %0 in an unevaluated context is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_nonclass_type_friend, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "non-class friend type %0 is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_nontrivial_union_or_anon_struct_member, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{anonymous struct|union}0 member %1 with a non-trivial %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}2 is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_pass_non_pod_arg_to_vararg, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "passing object of trivial but non-POD type %0 through variadic %select{function|block|method|constructor}1 is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_reference_list_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "reference initialized from initializer list is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_sfinae_access_control, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "substitution failure due to access control is incompatible with C++98", 117, SFINAE_Report, false, false, 2)
DIAG(warn_cxx98_compat_static_data_member_in_union, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "static data member %0 in union is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_switch_into_protected_scope, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "jump from switch statement to this case label is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_temp_copy, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{copying variable|copying parameter|returning object|initializing statement expression result|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element|capturing value}1 of type %2 when binding a reference to a temporary would %select{invoke an inaccessible constructor|find no viable constructor|find ambiguous constructors|invoke a deleted constructor}0 in C++98", 118, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_extra_parens, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "redundant parentheses surrounding address non-type template argument are incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_local_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "local type %0 as template argument is incompatible with C++98", 120, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_null, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of null pointer as non-type template argument is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_object_internal, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "non-type template argument referring to %select{function|object}0 %1 with internal linkage is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_template_arg_unnamed_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unnamed type as template argument is incompatible with C++98", 122, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_template_outside_of_template, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of 'template' keyword outside of a template is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_template_parameter_default_in_function_template, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "default template arguments for a function template are incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_typename_outside_of_template, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of 'typename' outside of a template is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_unelaborated_friend_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "befriending %1 without '%select{struct|interface|union|class|enum}0' keyword is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_unicode_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'%0' type specifier is incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx98_compat_using_decl_constructor, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "inheriting constructors are incompatible with C++98", 117, SFINAE_Suppress, false, false, 2)
DIAG(warn_cxx_ms_struct, CLASS_WARNING, (unsigned)diag::Severity::Error, "ms_struct may not produce Microsoft-compatible layouts for classes with base classes or virtual functions", 345, SFINAE_Suppress, false, false, 2)
DIAG(warn_dangling_lifetime_pointer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "object backing the pointer will be destroyed at the end of the full-expression", 166, SFINAE_Suppress, false, false, 2)
DIAG(warn_dangling_lifetime_pointer_member, CLASS_WARNING, (unsigned)diag::Severity::Warning, "initializing pointer member %0 to point to a temporary object whose lifetime is shorter than the lifetime of the constructed object", 166, SFINAE_Suppress, false, false, 2)
DIAG(warn_dangling_member, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{reference|backing array for 'std::initializer_list'}2 %select{|subobject of }1member %0 %select{binds to|is}2 a temporary object whose lifetime is shorter than the lifetime of the constructed object", 165, SFINAE_Suppress, false, false, 2)
DIAG(warn_dangling_variable, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{temporary %select{whose address is used as value of|%select{|implicitly }2bound to}4 %select{%select{|reference }4member of local variable|local %select{variable|reference}4}1|array backing %select{initializer list subobject of local variable|local initializer list}1}0 %select{%3 |}2will be destroyed at the end of the full-expression", 163, SFINAE_Suppress, false, false, 2)
DIAG(warn_dealloc_in_category, CLASS_WARNING, (unsigned)diag::Severity::Warning, "-dealloc is being overridden in a category", 170, SFINAE_Suppress, false, false, 2)
DIAG(warn_decl_in_param_list, CLASS_WARNING, (unsigned)diag::Severity::Warning, "declaration of %0 will not be visible outside of this function", 815, SFINAE_Suppress, false, false, 2)
DIAG(warn_decl_shadow, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "declaration shadows a %select{local variable|variable in %2|static data member of %2|field of %2|typedef in %2|type alias in %2}1", 648, SFINAE_Suppress, false, false, 2)
DIAG(warn_decl_shadow_uncaptured_local, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "declaration shadows a %select{local variable|variable in %2|static data member of %2|field of %2|typedef in %2|type alias in %2}1", 654, SFINAE_Suppress, false, false, 2)
DIAG(warn_declspec_allocator_nonpointer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring __declspec(allocator) because the function return type %0 is not a pointer or reference type", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_declspec_attribute_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 is ignored, place it after \"%select{class|struct|interface|union|enum}1\" to apply attribute to type declaration", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_deep_exception_specs_differ, CLASS_WARNING, (unsigned)diag::Severity::Warning, "exception specifications of %select{return|argument}0 types differ", 342, SFINAE_Suppress, false, false, 2)
DIAG(warn_def_missing_case, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%plural{1:enumeration value %1 not explicitly handled in switch|2:enumeration values %1 and %2 not explicitly handled in switch|3:enumeration values %1, %2, and %3 not explicitly handled in switch|:%0 enumeration values not explicitly handled in switch: %1, %2, %3...}0", 709, SFINAE_Suppress, false, false, 2)
DIAG(warn_default_atomic_custom_getter_setter, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "atomic by default property %0 has a user defined %select{getter|setter}1 (property should be marked 'atomic' if this is intended)", 162, SFINAE_Suppress, false, false, 2)
DIAG(warn_defaulted_comparison_deleted, CLASS_WARNING, (unsigned)diag::Severity::Warning, "explicitly defaulted %select{<ERROR>|equality|three-way|equality|relational}0 comparison operator is implicitly deleted", 173, SFINAE_Suppress, false, false, 2)
DIAG(warn_defaulted_method_deleted, CLASS_WARNING, (unsigned)diag::Severity::Warning, "explicitly defaulted %select{default constructor|copy constructor|move constructor|copy assignment operator|move assignment operator|destructor}0 is implicitly deleted", 173, SFINAE_Suppress, false, false, 2)
DIAG(warn_delegating_ctor_cycle, CLASS_WARNING, (unsigned)diag::Severity::Error, "constructor for %0 creates a delegation cycle", 174, SFINAE_Suppress, false, false, 2)
DIAG(warn_delete_abstract_non_virtual_dtor, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{delete|destructor}0 called on %1 that is abstract but has non-virtual destructor", 175, SFINAE_Suppress, false, true, 2)
DIAG(warn_delete_array_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'delete' applied to a pointer-to-array type %0 treated as 'delete[]'", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_delete_incomplete, CLASS_WARNING, (unsigned)diag::Severity::Warning, "deleting pointer to incomplete type %0 may cause undefined behavior", 176, SFINAE_Suppress, false, false, 2)
DIAG(warn_delete_non_virtual_dtor, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{delete|destructor}0 called on non-final %1 that has virtual functions but non-virtual destructor", 177, SFINAE_Suppress, false, true, 2)
DIAG(warn_depr_array_comparison, CLASS_WARNING, (unsigned)diag::Severity::Warning, "comparison between two arrays is deprecated; to compare array addresses, use unary '+' to decay operands to pointers", 181, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 is deprecated", 186, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_anonymous_namespace, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'deprecated' attribute on anonymous namespace ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_deprecated_comma_subscript, CLASS_WARNING, (unsigned)diag::Severity::Warning, "top-level comma expression in array subscript is deprecated", 183, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_compound_assign_volatile, CLASS_WARNING, (unsigned)diag::Severity::Warning, "compound assignment to object of volatile-qualified type %0 is deprecated", 199, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_copy_dtor_operation, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "definition of implicit copy %select{constructor|assignment operator}1 for %0 is deprecated because it has a user-declared destructor", 185, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_copy_operation, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "definition of implicit copy %select{constructor|assignment operator}1 for %0 is deprecated because it has a user-declared copy %select{assignment operator|constructor}1", 184, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_def, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implementing deprecated %select{method|class|category}0", 192, SFINAE_Suppress, false, false, 2)
DIAG(warn_deprecated_fwdclass_message, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 may be deprecated because the receiver type is unknown", 186, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_increment_decrement_volatile, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{decrement|increment}0 of object of volatile-qualified type %1 is deprecated", 199, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_message, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 is deprecated: %1", 186, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_redundant_constexpr_static_def, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "out-of-line definition of constexpr static data member is redundant in C++17 and is deprecated", 179, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_register, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'register' storage class specifier is deprecated and incompatible with C++17", 197, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_simple_assign_volatile, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use of result of assignment to object of volatile-qualified type %0 is deprecated", 199, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_string_literal_conversion, CLASS_WARNING, (unsigned)diag::Severity::Warning, "conversion from string literal to %0 is deprecated", 83, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_this_capture, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit capture of 'this' with a capture default of '=' is deprecated", 198, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_volatile_param, CLASS_WARNING, (unsigned)diag::Severity::Warning, "volatile-qualified parameter type %0 is deprecated", 199, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_volatile_return, CLASS_WARNING, (unsigned)diag::Severity::Warning, "volatile-qualified return type %0 is deprecated", 199, SFINAE_Suppress, false, false, 29)
DIAG(warn_deprecated_volatile_structured_binding, CLASS_WARNING, (unsigned)diag::Severity::Warning, "volatile qualifier in structured binding declaration is deprecated", 199, SFINAE_Suppress, false, false, 29)
DIAG(warn_dereference_of_noderef_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "dereferencing %0; was declared with a 'noderef' type", 481, SFINAE_Suppress, false, false, 0)
DIAG(warn_dereference_of_noderef_type_no_decl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "dereferencing expression marked as 'noderef'", 481, SFINAE_Suppress, false, false, 0)
DIAG(warn_destructor_marked_not_override_overriding, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 overrides a destructor but is not marked 'override'", 356, SFINAE_Suppress, false, false, 2)
DIAG(warn_diagnose_if_succeeded, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0", 808, SFINAE_Suppress, false, true, 2)
DIAG(warn_direct_initialize_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "explicit call to +initialize results in duplicate call to +initialize", 244, SFINAE_Suppress, false, false, 2)
DIAG(warn_direct_ivar_access, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "instance variable %0 is being directly accessed", 201, SFINAE_Suppress, false, false, 2)
DIAG(warn_direct_super_initialize_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "explicit call to [super initialize] should only be in implementation of +initialize", 244, SFINAE_Suppress, false, false, 2)
DIAG(warn_dispatch_body_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "body of cpu_dispatch function will be ignored", 281, SFINAE_Suppress, false, false, 0)
DIAG(warn_division_sizeof_array, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expression does not compute the number of elements in this array; element type is %0, not %1", 669, SFINAE_Suppress, false, false, 2)
DIAG(warn_division_sizeof_ptr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' will return the size of the pointer, not the array itself", 670, SFINAE_Suppress, false, false, 2)
DIAG(warn_dllimport_dropped_from_inline_function, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%q0 redeclared inline; %1 attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_double_const_requires_fp64, CLASS_WARNING, (unsigned)diag::Severity::Warning, "double precision constant requires cl_khr_fp64, casting to single precision", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_double_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "acquiring %0 '%1' that is already held", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_duplicate_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 is already applied with different parameters", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_duplicate_attribute_exact, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 is already applied", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_duplicate_codeseg_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "duplicate code segment specifiers", 637, SFINAE_Suppress, false, false, 2)
DIAG(warn_duplicate_enum_values, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "element %0 has been implicitly assigned %1 which another element has been assigned", 219, SFINAE_Suppress, false, false, 2)
DIAG(warn_duplicate_method_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "multiple declarations of method %0 found and ignored", 221, SFINAE_Suppress, false, false, 2)
DIAG(warn_duplicate_protocol_def, CLASS_WARNING, (unsigned)diag::Severity::Warning, "duplicate protocol definition of %0 is ignored", 222, SFINAE_Suppress, false, false, 2)
DIAG(warn_dyn_class_memaccess, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{destination for|source of|first operand of|second operand of}0 this %1 call is a pointer to %select{|class containing a }2dynamic class %3; vtable pointer will be %select{overwritten|copied|moved|compared}4", 223, SFINAE_Suppress, false, false, 2)
DIAG(warn_empty_for_body, CLASS_WARNING, (unsigned)diag::Severity::Warning, "for loop has empty body", 227, SFINAE_Suppress, false, false, 2)
DIAG(warn_empty_format_string, CLASS_WARNING, (unsigned)diag::Severity::Warning, "format string is empty", 274, SFINAE_Suppress, false, false, 30)
DIAG(warn_empty_if_body, CLASS_WARNING, (unsigned)diag::Severity::Warning, "if statement has empty body", 227, SFINAE_Suppress, false, false, 2)
DIAG(warn_empty_parens_are_function_decl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "empty parentheses interpreted as a function declaration", 814, SFINAE_Suppress, false, false, 2)
DIAG(warn_empty_range_based_for_body, CLASS_WARNING, (unsigned)diag::Severity::Warning, "range-based for loop has empty body", 227, SFINAE_Suppress, false, false, 2)
DIAG(warn_empty_switch_body, CLASS_WARNING, (unsigned)diag::Severity::Warning, "switch statement has empty body", 227, SFINAE_Suppress, false, false, 2)
DIAG(warn_empty_while_body, CLASS_WARNING, (unsigned)diag::Severity::Warning, "while loop has empty body", 227, SFINAE_Suppress, false, false, 2)
DIAG(warn_enum_constant_in_bool_context, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "converting the enum constant to a boolean", 369, SFINAE_Suppress, false, false, 2)
DIAG(warn_enum_value_overflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "overflow in enumeration value", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_equality_with_extra_parens, CLASS_WARNING, (unsigned)diag::Severity::Warning, "equality comparison with extraneous parentheses", 572, SFINAE_Suppress, false, false, 2)
DIAG(warn_exception_caught_by_earlier_handler, CLASS_WARNING, (unsigned)diag::Severity::Warning, "exception of type %0 will be caught by earlier handler", 240, SFINAE_Suppress, false, false, 2)
DIAG(warn_exit_time_destructor, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "declaration requires an exit-time destructor", 241, SFINAE_Suppress, false, false, 2)
DIAG(warn_expecting_lock_held_on_loop, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "expecting %0 '%1' to be held at start of each loop", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_expecting_locked, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "expecting %0 '%1' to be held at the end of function", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_explicit_instantiation_after_specialization, CLASS_WARNING, (unsigned)diag::Severity::Warning, "explicit instantiation of %0 that occurs after an explicit specialization has no effect", 366, SFINAE_Suppress, false, false, 2)
DIAG(warn_explicit_instantiation_inline_0x, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicit instantiation cannot be 'inline'", 82, SFINAE_Suppress, false, false, 2)
DIAG(warn_explicit_instantiation_must_be_global_0x, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicit instantiation of %0 must occur at global scope", 82, SFINAE_Suppress, false, false, 2)
DIAG(warn_explicit_instantiation_out_of_scope_0x, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicit instantiation of %0 not in a namespace enclosing %1", 82, SFINAE_Suppress, false, false, 2)
DIAG(warn_explicit_instantiation_unqualified_wrong_namespace_0x, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicit instantiation of %q0 must occur in namespace %1", 82, SFINAE_Suppress, false, false, 2)
DIAG(warn_extern_init, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'extern' variable has an initializer", 249, SFINAE_Suppress, false, false, 2)
DIAG(warn_falloff_nonvoid_coroutine, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-void coroutine does not return a value", 634, SFINAE_Suppress, false, false, 2)
DIAG(warn_falloff_nonvoid_function, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-void function does not return a value", 634, SFINAE_Suppress, false, false, 2)
DIAG(warn_falloff_nonvoid_lambda, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-void lambda does not return a value", 634, SFINAE_Suppress, false, false, 3)
DIAG(warn_falloff_noreturn_function, CLASS_WARNING, (unsigned)diag::Severity::Warning, "function declared 'noreturn' should not return", 379, SFINAE_Suppress, false, false, 2)
DIAG(warn_fallthrough_attr_unreachable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "fallthrough annotation in unreachable code", 327, SFINAE_Suppress, false, false, 2)
DIAG(warn_field_is_uninit, CLASS_WARNING, (unsigned)diag::Severity::Warning, "field %0 is uninitialized when used here", 757, SFINAE_Suppress, false, false, 2)
DIAG(warn_final_dtor_non_final_class, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class with destructor marked '%select{final|sealed}0' cannot be inherited from", 256, SFINAE_Suppress, false, false, 2)
DIAG(warn_flag_enum_constant_out_of_range, CLASS_WARNING, (unsigned)diag::Severity::Warning, "enumeration value %0 is out of range of flags in enumeration type %1", 258, SFINAE_Suppress, false, false, 2)
DIAG(warn_float_overflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "magnitude of floating-point constant too large for type %0; maximum is %1", 395, SFINAE_Suppress, false, false, 2)
DIAG(warn_float_underflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "magnitude of floating-point constant too small for type %0; minimum is %1", 395, SFINAE_Suppress, false, false, 2)
DIAG(warn_floatingpoint_eq, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "comparing floating point with == or != is unsafe", 261, SFINAE_Suppress, false, false, 2)
DIAG(warn_for_range_begin_end_types_differ, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'begin' and 'end' returning different types (%0 and %1) is incompatible with C++ standards before C++17", 112, SFINAE_Suppress, false, false, 2)
DIAG(warn_for_range_const_reference_copy, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "loop variable %0 %diff{has type $ but is initialized with type $| is initialized with a value of a different type}1,2 resulting in a copy", 612, SFINAE_Suppress, false, false, 2)
DIAG(warn_for_range_copy, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "loop variable %0 of type %1 creates a copy from type %2", 612, SFINAE_Suppress, false, false, 2)
DIAG(warn_for_range_variable_always_copy, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "loop variable %0 is always a copy because the range of type %1 does not return a reference", 611, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_P_no_precision, CLASS_WARNING, (unsigned)diag::Severity::Warning, "using '%%P' format specifier without precision", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_argument_needs_cast, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{values of type|enum values with underlying type}2 '%0' should not be used as format arguments; add an explicit cast to %1 instead", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_argument_needs_cast_pedantic, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{values of type|enum values with underlying type}2 '%0' should not be used as format arguments; add an explicit cast to %1 instead", 270, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_bool_as_character, CLASS_WARNING, (unsigned)diag::Severity::Warning, "using '%0' format specifier, but argument has boolean value", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_conversion_argument_type_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "format specifies type %0 but the argument has %select{type|underlying type}2 %1", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_conversion_argument_type_mismatch_confusion, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "format specifies type %0 but the argument has %select{type|underlying type}2 %1", 272, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_conversion_argument_type_mismatch_pedantic, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "format specifies type %0 but the argument has %select{type|underlying type}2 %1", 270, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_invalid_annotation, CLASS_WARNING, (unsigned)diag::Severity::Warning, "using '%0' format specifier annotation outside of os_log()/os_trace()", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_invalid_conversion, CLASS_WARNING, (unsigned)diag::Severity::Warning, "invalid conversion specifier '%0'", 267, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_invalid_positional_specifier, CLASS_WARNING, (unsigned)diag::Severity::Warning, "invalid position specified for %select{field width|field precision}0", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_mix_positional_nonpositional_args, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cannot mix positional and non-positional arguments in format string", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_non_standard, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'%0' %select{length modifier|conversion specifier}1 is not supported by ISO C", 268, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_non_standard_conversion_spec, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "using length modifier '%0' with conversion specifier '%1' is not supported by ISO C", 268, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_non_standard_positional_arg, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "positional arguments are not supported by ISO C", 268, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_nonliteral, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "format string is not a string literal", 269, SFINAE_Suppress, false, false, 2)
DIAG(warn_format_nonliteral_noargs, CLASS_WARNING, (unsigned)diag::Severity::Warning, "format string is not a string literal (potentially insecure)", 271, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_nonsensical_length, CLASS_WARNING, (unsigned)diag::Severity::Warning, "length modifier '%0' results in undefined behavior or no effect with '%1' conversion specifier", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_string_is_wide_literal, CLASS_WARNING, (unsigned)diag::Severity::Warning, "format string should not be a wide string", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_format_zero_positional_specifier, CLASS_WARNING, (unsigned)diag::Severity::Warning, "position arguments in format strings start counting at 1 (not 0)", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_fortify_source_overflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' will always overflow; destination buffer has size %1, but size argument is %2", 276, SFINAE_Suppress, false, false, 2)
DIAG(warn_fortify_source_size_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' size argument is too large; destination buffer has size %1, but size argument is %2", 276, SFINAE_Suppress, false, false, 2)
DIAG(warn_forward_class_redefinition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "redefinition of forward class %0 of a typedef name of an object type is ignored", 516, SFINAE_Suppress, false, false, 2)
DIAG(warn_fun_excludes_mutex, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "cannot call function '%1' while %0 '%2' is held", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_fun_requires_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "calling function %1 requires holding %0 %select{'%2'|'%2' exclusively}3", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_fun_requires_lock_precise, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "calling function %1 requires holding %0 %select{'%2'|'%2' exclusively}3", 730, SFINAE_Suppress, false, false, 2)
DIAG(warn_func_template_missing, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "instantiation of function %q0 required here, but no definition is available", 743, SFINAE_Suppress, false, false, 2)
DIAG(warn_function_def_in_objc_container, CLASS_WARNING, (unsigned)diag::Severity::Warning, "function definition inside an Objective-C container is deprecated", 280, SFINAE_Suppress, false, false, 2)
DIAG(warn_function_marked_not_override_overriding, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 overrides a member function but is not marked 'override'", 357, SFINAE_Suppress, false, false, 2)
DIAG(warn_gc_attribute_weak_on_local, CLASS_WARNING, (unsigned)diag::Severity::Warning, "Objective-C GC does not allow weak variables on the stack", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_gcc_ignores_type_attr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "GCC does not allow the %0 attribute to be written on a type", 283, SFINAE_Suppress, false, false, 2)
DIAG(warn_global_constructor, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "declaration requires a global constructor", 284, SFINAE_Suppress, false, false, 2)
DIAG(warn_global_destructor, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "declaration requires a global destructor", 284, SFINAE_Suppress, false, false, 2)
DIAG(warn_gnu_inline_attribute_requires_inline, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'gnu_inline' attribute requires function to be marked 'inline', attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_gnu_inline_cplusplus_without_extern, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'gnu_inline' attribute without 'extern' in C++ treated as externally available, this changed in Clang 10", 303, SFINAE_Suppress, false, false, 2)
DIAG(warn_gnu_null_ptr_arith, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "arithmetic on a null pointer treated as a cast from integer to pointer is a GNU extension", 501, SFINAE_Suppress, false, false, 2)
DIAG(warn_guarded_pass_by_reference, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "passing variable %1 by reference requires holding %0 %select{'%2'|'%2' exclusively}3", 731, SFINAE_Suppress, false, false, 2)
DIAG(warn_iboutlet_object_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{instance variable|property}2 with %0 attribute must be an object type (invalid %1)", 375, SFINAE_Suppress, false, false, 2)
DIAG(warn_iboutletcollection_property_assign, CLASS_WARNING, (unsigned)diag::Severity::Warning, "IBOutletCollection properties should be copy/strong and not assign", 375, SFINAE_Suppress, false, false, 2)
DIAG(warn_identity_field_assign, CLASS_WARNING, (unsigned)diag::Severity::Warning, "assigning %select{field|instance variable}0 to itself", 641, SFINAE_Suppress, false, false, 2)
DIAG(warn_ignored_ms_inheritance, CLASS_WARNING, (unsigned)diag::Severity::Warning, "inheritance model ignored on %select{primary template|partial specialization}0", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_ignored_objc_externally_retained, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'objc_externally_retained' can only be applied to local variables %select{of retainable type|with strong ownership}0", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_illegal_constant_array_size, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "size of static array must be an integer constant expression", 579, SFINAE_Suppress, false, false, 2)
DIAG(warn_impcast_bitfield_precision_constant, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit truncation from %2 to bit-field changes value from %0 to %1", 63, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_bool_to_null_pointer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "initialization of pointer of type %0 to null from a constant boolean expression", 69, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_complex_scalar, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion discards imaginary component: %0 to %1", 151, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_constant_value_to_objc_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion from constant value %0 to 'BOOL'; the only well defined values for 'BOOL' are YES and NO", 510, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_different_enum_types, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion from enumeration type %0 to different enumeration type %1", 236, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_double_promotion, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion increases floating-point precision: %0 to %1", 217, SFINAE_Suppress, false, false, 2)
DIAG(warn_impcast_fixed_point_range, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion from %0 cannot fit within the range of values for %1", 329, SFINAE_Suppress, false, false, 2)
DIAG(warn_impcast_float_integer, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion turns floating-point number into integer: %0 to %1", 260, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_float_precision, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion loses floating-point precision: %0 to %1", 330, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_float_result_precision, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion when assigning computation result loses floating-point precision: %0 to %1", 330, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_float_to_integer, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion from %0 to %1 changes value from %2 to %3", 262, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_float_to_integer_out_of_range, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion of out of range value from %0 to %1 is undefined", 262, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_float_to_integer_zero, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion from %0 to %1 changes non-zero value from %2 to %3", 263, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_float_to_objc_signed_char_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion from floating-point type %0 to 'BOOL'", 542, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_floating_point_to_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion turns floating-point number into bool: %0 to %1", 325, SFINAE_Suppress, false, false, 2)
DIAG(warn_impcast_high_order_zero_bits, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "higher order bits are zeroes after implicit conversion", 333, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_int_to_objc_signed_char_bool, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion from integral type %0 to 'BOOL'", 543, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_integer_64_32, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion loses integer precision: %0 to %1", 661, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_integer_float_precision, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion from %0 to %1 may lose precision", 334, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_integer_float_precision_constant, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion from %2 to %3 changes value from %0 to %1", 334, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_integer_precision, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion loses integer precision: %0 to %1", 333, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_integer_precision_constant, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion from %2 to %3 changes value from %0 to %1", 146, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_integer_sign, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion changes signedness: %0 to %1", 663, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_integer_sign_conditional, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "operand of ? changes signedness: %0 to %1", 663, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_literal_float_to_integer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion from %0 to %1 changes value from %2 to %3", 394, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_literal_float_to_integer_out_of_range, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion of out of range value from %0 to %1 is undefined", 394, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_nonnegative_result, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "the resulting value is always non-negative after implicit conversion", 663, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_null_pointer_to_integer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit conversion of %select{NULL|nullptr}0 constant to %1", 499, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_objective_c_literal_to_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "implicit boolean conversion of Objective-C object literal always evaluates to true", 519, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_pointer_to_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "address of%select{| function| array}0 '%1' will always evaluate to 'true'", 583, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_string_literal_to_bool, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion turns string literal into bool: %0 to %1", 698, SFINAE_Suppress, false, false, 26)
DIAG(warn_impcast_vector_scalar, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion turns vector to scalar: %0 to %1", 151, SFINAE_Suppress, false, false, 26)
DIAG(warn_impl_required_for_class_property, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class property %0 requires method %1 to be defined - use @dynamic or provide a method implementation in this class implementation", 529, SFINAE_Suppress, false, false, 2)
DIAG(warn_impl_required_in_category_for_class_property, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class property %0 requires method %1 to be defined - use @dynamic or provide a method implementation in this category", 529, SFINAE_Suppress, false, false, 2)
DIAG(warn_implements_nscopying, CLASS_WARNING, (unsigned)diag::Severity::Warning, "default assign attribute on property %0 which implements NSCopying protocol is not appropriate with -fobjc-gc[-only]", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_implicit_atomic_property, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "property is assumed atomic by default", 324, SFINAE_Suppress, false, false, 2)
DIAG(warn_implicit_decl_no_jmp_buf, CLASS_WARNING, (unsigned)diag::Severity::Warning, "declaration of built-in function '%0' requires the declaration of the 'jmp_buf' type, commonly provided in the header <setjmp.h>.", 353, SFINAE_Suppress, false, false, 2)
DIAG(warn_implicit_decl_requires_sysheader, CLASS_WARNING, (unsigned)diag::Severity::Warning, "declaration of built-in function '%1' requires inclusion of the header <%0>", 77, SFINAE_Suppress, false, false, 2)
DIAG(warn_implicit_function_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit declaration of function %0", 331, SFINAE_Suppress, false, false, 2)
DIAG(warn_implicitly_retains_self, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "block implicitly retains 'self'; explicitly mention 'self' to indicate this is intended behavior", 335, SFINAE_Suppress, false, false, 2)
DIAG(warn_inaccessible_base_class, CLASS_WARNING, (unsigned)diag::Severity::Warning, "direct base %0 is inaccessible due to ambiguity:%1", 339, SFINAE_Suppress, false, false, 2)
DIAG(warn_incompatible_exception_specs, CLASS_WARNING, (unsigned)diag::Severity::Warning, "target exception specification is not superset of source", 342, SFINAE_Suppress, false, false, 2)
DIAG(warn_incompatible_qualified_id, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{%diff{assigning to $ from incompatible type $|assigning to type from incompatible type}0,1|%diff{passing $ to parameter of incompatible type $|passing type to parameter of incompatible type}0,1|%diff{returning $ from a function with incompatible result type $|returning type from a function with incompatible result type}0,1|%diff{converting $ to incompatible type $|converting type to incompatible type}0,1|%diff{initializing $ with an expression of incompatible type $|initializing type with an expression of incompatible type}0,1|%diff{sending $ to parameter of incompatible type $|sending type to parameter of incompatible type}0,1|%diff{casting $ to incompatible type $|casting type to incompatible type}0,1}2", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_incompatible_vectors, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "incompatible vector types %select{%diff{assigning to $ from $|assigning to different types}0,1|%diff{passing $ to parameter of type $|passing to parameter of different type}0,1|%diff{returning $ from a function with result type $|returning from function with different return type}0,1|%diff{converting $ to type $|converting between types}0,1|%diff{initializing $ with an expression of type $|initializing with expression of different type}0,1|%diff{sending $ to parameter of type $|sending to parameter of different type}0,1|%diff{casting $ to type $|casting between types}0,1}2", 812, SFINAE_Suppress, false, false, 2)
DIAG(warn_incomplete_encoded_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "encoding of %0 type is incomplete because %1 component has unknown encoding", 231, SFINAE_Suppress, false, false, 2)
DIAG(warn_increment_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "incrementing expression of type bool is deprecated and incompatible with C++17", 193, SFINAE_Suppress, false, false, 29)
DIAG(warn_independentclass_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'objc_independent_class' attribute may be put on a typedef only; attribute is ignored", 5, SFINAE_Suppress, false, false, 2)
DIAG(warn_indirection_through_null, CLASS_WARNING, (unsigned)diag::Severity::Warning, "indirection of non-volatile null pointer will be deleted, not trap", 500, SFINAE_Suppress, false, false, 2)
DIAG(warn_infinite_recursive_function, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "all paths through this function will call itself", 359, SFINAE_Suppress, false, false, 2)
DIAG(warn_init_list_constant_narrowing, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constant expression evaluates to %0 which cannot be narrowed to type %1 in C++11", 90, SFINAE_Suppress, false, false, 2)
DIAG(warn_init_list_type_narrowing, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "type %0 cannot be narrowed to %1 in initializer list in C++11", 90, SFINAE_Suppress, false, false, 2)
DIAG(warn_init_list_variable_narrowing, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "non-constant-expression cannot be narrowed from type %0 to %1 in initializer list in C++11", 90, SFINAE_Suppress, false, false, 2)
DIAG(warn_init_ptr_member_to_parameter_addr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "initializing pointer member %0 with the stack address of %select{variable|parameter}2 %1", 165, SFINAE_Suppress, false, false, 2)
DIAG(warn_initializer_out_of_order, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{field|base class}0 %1 will be initialized after %select{field|base}2 %3", 624, SFINAE_Suppress, false, false, 2)
DIAG(warn_initializer_overrides, CLASS_WARNING, (unsigned)diag::Severity::Warning, "initializer %select{partially |}0overrides prior initialization of this subobject", 361, SFINAE_Suppress, false, false, 2)
DIAG(warn_inline_namespace_reopened_noninline, CLASS_WARNING, (unsigned)diag::Severity::Warning, "inline namespace reopened as a non-inline namespace", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_inst_method_not_found, CLASS_WARNING, (unsigned)diag::Severity::Warning, "instance method %objcinstance0 not found (return type defaults to 'id')", 522, SFINAE_Suppress, false, false, 2)
DIAG(warn_instance_method_not_found_with_typo, CLASS_WARNING, (unsigned)diag::Severity::Warning, "instance method %objcinstance0 not found (return type defaults to 'id'); did you mean %objcinstance2?", 522, SFINAE_Suppress, false, false, 2)
DIAG(warn_instance_method_on_class_found, CLASS_WARNING, (unsigned)diag::Severity::Warning, "instance method %0 found instead of class method %1", 522, SFINAE_Suppress, false, false, 2)
DIAG(warn_int_to_pointer_cast, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cast to %1 from smaller integer type %0", 370, SFINAE_Suppress, false, false, 2)
DIAG(warn_int_to_void_pointer_cast, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cast to %1 from smaller integer type %0", 371, SFINAE_Suppress, false, false, 2)
DIAG(warn_integer_constants_in_conditional_always_true, CLASS_WARNING, (unsigned)diag::Severity::Warning, "converting the result of '?:' with integer constants to a boolean always evaluates to 'true'", 714, SFINAE_Suppress, false, false, 2)
DIAG(warn_internal_linkage_local_storage, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'internal_linkage' attribute on a non-static local variable is ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_interrupt_attribute_invalid, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{MIPS|MSP430|RISC-V}0 'interrupt' attribute only applies to functions that have %select{no parameters|a 'void' return type}1", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_invalid_asm_cast_lvalue, CLASS_WARNING, (unsigned)diag::Severity::Warning, "invalid use of a cast in an inline asm context requiring an l-value: accepted due to -fheinous-gnu-extensions, but clang may remove support for this in the future", 0, SFINAE_Suppress, false, false, 12)
DIAG(warn_invalid_capability_name, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "invalid capability name '%0'; capability name must be 'mutex' or 'role'", 727, SFINAE_Suppress, false, false, 2)
DIAG(warn_invalid_initializer_from_system_header, CLASS_WARNING, (unsigned)diag::Severity::Warning, "invalid constructor form class in system header, should not be explicit", 376, SFINAE_Suppress, false, false, 2)
DIAG(warn_ivar_use_hidden, CLASS_WARNING, (unsigned)diag::Severity::Warning, "local declaration of %0 hides instance variable", 653, SFINAE_Suppress, false, false, 2)
DIAG(warn_ivars_in_interface, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "declaration of instance variables in the interface is deprecated", 517, SFINAE_Suppress, false, false, 2)
DIAG(warn_jump_out_of_seh_finally, CLASS_WARNING, (unsigned)diag::Severity::Warning, "jump out of __finally block has undefined behavior", 387, SFINAE_Suppress, false, false, 2)
DIAG(warn_kern_is_inline, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignored 'inline' attribute on kernel function %0", 161, SFINAE_Suppress, false, false, 2)
DIAG(warn_kern_is_method, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "kernel function %0 is a member function; this may not be accepted by nvcc", 161, SFINAE_Suppress, false, false, 2)
DIAG(warn_left_shift_always, CLASS_WARNING, (unsigned)diag::Severity::Warning, "converting the result of '<<' to a boolean always evaluates to %select{false|true}0", 714, SFINAE_Suppress, false, false, 2)
DIAG(warn_left_shift_in_bool_context, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "converting the result of '<<' to a boolean; did you mean '(%0) != 0'?", 369, SFINAE_Suppress, false, false, 2)
DIAG(warn_lock_exclusive_and_shared, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 '%1' is acquired exclusively and shared in the same scope", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_lock_some_predecessors, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 '%1' is not held on every path through here", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_logical_and_in_logical_or, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'&&' within '||'", 398, SFINAE_Suppress, false, false, 2)
DIAG(warn_logical_instead_of_bitwise, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use of logical '%0' with constant operand", 148, SFINAE_Suppress, false, false, 2)
DIAG(warn_logical_not_on_lhs_of_check, CLASS_WARNING, (unsigned)diag::Severity::Warning, "logical not is only applied to the left hand side of this %select{comparison|bitwise operator}0", 397, SFINAE_Suppress, false, false, 2)
DIAG(warn_loop_ctrl_binds_to_inner, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' is bound to current loop, GCC binds it to the enclosing loop", 283, SFINAE_Suppress, false, false, 2)
DIAG(warn_loop_state_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "state of variable '%0' must match at the entry and exit of loop", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_main_one_arg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "only one parameter on 'main' declaration", 402, SFINAE_Suppress, false, false, 2)
DIAG(warn_main_redefined, CLASS_WARNING, (unsigned)diag::Severity::Warning, "variable named 'main' with external linkage has undefined behavior", 402, SFINAE_Suppress, false, false, 2)
DIAG(warn_main_returns_bool_literal, CLASS_WARNING, (unsigned)diag::Severity::Warning, "bool literal returned from 'main'", 402, SFINAE_Suppress, false, false, 2)
DIAG(warn_max_unsigned_zero, CLASS_WARNING, (unsigned)diag::Severity::Warning, "taking the max of %select{a value and unsigned zero|unsigned zero and a value}0 is always equal to the other value", 406, SFINAE_Suppress, false, false, 2)
DIAG(warn_maybe_falloff_nonvoid_coroutine, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-void coroutine does not return a value in all control paths", 634, SFINAE_Suppress, false, false, 2)
DIAG(warn_maybe_falloff_nonvoid_function, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-void function does not return a value in all control paths", 634, SFINAE_Suppress, false, false, 2)
DIAG(warn_maybe_falloff_nonvoid_lambda, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-void lambda does not return a value in all control paths", 634, SFINAE_Suppress, false, false, 3)
DIAG(warn_maybe_uninit_var, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable %0 may be uninitialized when %select{used here|captured by block}1", 144, SFINAE_Suppress, false, false, 2)
DIAG(warn_maynot_respond, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 may not respond to %1", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_member_extra_qualification, CLASS_WARNING, (unsigned)diag::Severity::Warning, "extra qualification on member %0", 425, SFINAE_Suppress, false, false, 2)
DIAG(warn_memsize_comparison, CLASS_WARNING, (unsigned)diag::Severity::Warning, "size argument in %0 call is a comparison", 408, SFINAE_Suppress, false, false, 2)
DIAG(warn_messaging_unqualified_id, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "messaging unqualified id", 521, SFINAE_Suppress, false, false, 2)
DIAG(warn_mig_server_routine_does_not_return_kern_return_t, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'mig_server_routine' attribute only applies to routines that return a kern_return_t", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_mismatched_availability, CLASS_WARNING, (unsigned)diag::Severity::Warning, "availability does not match previous declaration", 55, SFINAE_Suppress, false, false, 2)
DIAG(warn_mismatched_availability_override, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{|overriding }4method %select{introduced after|deprecated before|obsoleted before}0 %select{the protocol method it implements|overridden method}4 on %1 (%2 vs. %3)", 55, SFINAE_Suppress, false, false, 2)
DIAG(warn_mismatched_availability_override_unavail, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{|overriding }1method cannot be unavailable on %0 when %select{the protocol method it implements|its overridden method}1 is available", 55, SFINAE_Suppress, false, false, 2)
DIAG(warn_mismatched_delete_new, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'delete%select{|[]}0' applied to a pointer that was allocated with 'new%select{[]|}0'; did you mean 'delete%select{[]|}0'?", 443, SFINAE_Suppress, false, false, 2)
DIAG(warn_mismatched_nullability_attr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "nullability specifier %0 conflicts with existing specifier %1", 502, SFINAE_Suppress, false, false, 21)
DIAG(warn_mismatched_section, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{codeseg|section}0 does not match previous declaration", 637, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_braces, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "suggest braces around initialization of subobject", 447, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_case, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%plural{1:enumeration value %1 not handled in switch|2:enumeration values %1 and %2 not handled in switch|3:enumeration values %1, %2, and %3 not handled in switch|:%0 enumeration values not handled in switch: %1, %2, %3...}0", 706, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_case_for_condition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "no case matching constant switch condition '%0'", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_explicit_synthesis, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "auto property synthesis is synthesizing property not explicitly synthesized", 523, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_field_initializers, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "missing field %0 initializer", 451, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_format_string, CLASS_WARNING, (unsigned)diag::Severity::Warning, "format string missing", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_missing_method_return_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "method has no return type specified; defaults to 'id'", 454, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_prototype, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "no previous prototype for function %0", 458, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_sentinel, CLASS_WARNING, (unsigned)diag::Severity::Warning, "missing sentinel in %select{function call|method dispatch|block call}0", 645, SFINAE_Suppress, false, false, 2)
DIAG(warn_missing_variable_declarations, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "no previous extern declaration for non-static variable %0", 461, SFINAE_Suppress, false, false, 2)
DIAG(warn_mixed_sign_comparison, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "comparison of integers of different signs: %0 and %1", 662, SFINAE_Suppress, false, false, 2)
DIAG(warn_modifying_shadowing_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "modifying constructor parameter %0 that shadows a field of %1", 652, SFINAE_Suppress, false, false, 2)
DIAG(warn_multiple_method_decl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "multiple methods named %0 found", 525, SFINAE_Suppress, false, false, 2)
DIAG(warn_multiple_selectors, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "several methods with selector %0 of mismatched types are found for the @selector expression", 639, SFINAE_Suppress, false, false, 2)
DIAG(warn_multiversion_duplicate_entries, CLASS_WARNING, (unsigned)diag::Severity::Warning, "CPU list contains duplicate entries; attribute ignored", 281, SFINAE_Suppress, false, false, 0)
DIAG(warn_namespace_member_extra_qualification, CLASS_WARNING, (unsigned)diag::Severity::Warning, "extra qualification on member %0", 251, SFINAE_Suppress, false, false, 2)
DIAG(warn_neon_vector_initializer_non_portable, CLASS_WARNING, (unsigned)diag::Severity::Warning, "vector initializers are not compatible with NEON intrinsics in big endian mode", 493, SFINAE_Suppress, false, false, 2)
DIAG(warn_new_dangling_initializer_list, CLASS_WARNING, (unsigned)diag::Severity::Warning, "array backing %select{initializer list subobject of the allocated object|the allocated initializer list}0 will be destroyed at the end of the full-expression", 167, SFINAE_Suppress, false, false, 2)
DIAG(warn_new_dangling_reference, CLASS_WARNING, (unsigned)diag::Severity::Warning, "temporary bound to reference member of allocated object will be destroyed at the end of the full-expression", 165, SFINAE_Suppress, false, false, 2)
DIAG(warn_no_autosynthesis_property, CLASS_WARNING, (unsigned)diag::Severity::Warning, "auto property synthesis will not synthesize property %0 because it is 'readwrite' but it will be synthesized 'readonly' via another property", 533, SFINAE_Suppress, false, false, 2)
DIAG(warn_no_autosynthesis_shared_ivar_property, CLASS_WARNING, (unsigned)diag::Severity::Warning, "auto property synthesis will not synthesize property %0 because it cannot share an ivar with another synthesized property", 533, SFINAE_Suppress, false, false, 2)
DIAG(warn_no_constructor_for_refconst, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{struct|interface|union|class|enum}0 %1 does not declare any constructor to initialize its non-modifiable members", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_no_underlying_type_specified_for_enum_bitfield, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "enums in the Microsoft ABI are signed integers by default; consider giving the enum %0 an unsigned underlying type to make this code portable", 665, SFINAE_Suppress, false, false, 2)
DIAG(warn_no_unlock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 '%1' is still held at the end of function", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_nocf_check_attribute_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'nocf_check' attribute ignored; use -fcf-protection to enable the attribute", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_noderef_on_non_pointer_or_array, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'noderef' can only be used on an array or pointer type", 317, SFINAE_Suppress, false, false, 0)
DIAG(warn_noderef_to_dereferenceable_pointer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "casting to dereferenceable pointer removes 'noderef' attribute", 481, SFINAE_Suppress, false, false, 0)
DIAG(warn_non_contravariant_overriding_param_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting parameter types in declaration of %0: %1 vs %2", 567, SFINAE_Suppress, false, false, 2)
DIAG(warn_non_contravariant_param_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting parameter types in implementation of %0: %1 vs %2", 409, SFINAE_Suppress, false, false, 2)
DIAG(warn_non_covariant_overriding_ret_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting return type in declaration of %0: %1 vs %2", 567, SFINAE_Suppress, false, false, 2)
DIAG(warn_non_covariant_ret_types, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "conflicting return type in implementation of %0: %1 vs %2", 409, SFINAE_Suppress, false, false, 2)
DIAG(warn_non_literal_null_pointer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expression which evaluates to zero treated as a null pointer constant of type %0", 484, SFINAE_Suppress, false, false, 26)
DIAG(warn_non_pod_vararg_with_format_string, CLASS_WARNING, (unsigned)diag::Severity::Error, "cannot pass %select{non-POD|non-trivial}0 object of type %1 to variadic %select{function|block|method|constructor}2; expected type from format string was %3", 487, SFINAE_Suppress, false, false, 2)
DIAG(warn_non_virtual_dtor, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 has virtual functions but non-virtual destructor", 488, SFINAE_Suppress, false, false, 2)
DIAG(warn_nonnull_expr_compare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "comparison of nonnull %select{function call|parameter}0 '%1' %select{not |}2equal to a null pointer is '%select{true|false}2' on first encounter", 719, SFINAE_Suppress, false, false, 2)
DIAG(warn_noreturn_function_has_return_expr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "function %0 declared 'noreturn' should not return", 379, SFINAE_Suppress, false, false, 2)
DIAG(warn_not_a_doxygen_trailing_member_comment, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "not a Doxygen trailing comment", 211, SFINAE_Suppress, false, false, 27)
DIAG(warn_not_compound_assign, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use of unary operator that may be intended as compound assignment (%0=)", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_not_enough_argument, CLASS_WARNING, (unsigned)diag::Severity::Warning, "not enough variable arguments in %0 declaration to fit a sentinel", 645, SFINAE_Suppress, false, false, 2)
DIAG(warn_not_in_enum, CLASS_WARNING, (unsigned)diag::Severity::Warning, "case value not in enumerated type %0", 706, SFINAE_Suppress, false, false, 2)
DIAG(warn_not_in_enum_assignment, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "integer constant not in range of enumerated type %0", 40, SFINAE_Suppress, false, false, 2)
DIAG(warn_nothrow_attribute_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'nothrow' attribute conflicts with exception specification; attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_ns_attribute_wrong_parameter_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to %select{Objective-C object|pointer|pointer-to-CF-pointer|pointer/reference-to-OSObject-pointer}1 parameters", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_ns_attribute_wrong_return_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute only applies to %select{functions|methods|properties}1 that return %select{an Objective-C object|a pointer|a non-retainable pointer}2", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_nsconsumed_attribute_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "overriding method has mismatched ns_consumed attribute on its parameter", 495, SFINAE_Suppress, false, false, 2)
DIAG(warn_nsobject_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'NSObject' attribute may be put on a typedef only; attribute is ignored", 6, SFINAE_Suppress, false, false, 2)
DIAG(warn_nsreturns_retained_attribute_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "overriding method has mismatched ns_returns_%select{not_retained|retained}0 attributes", 496, SFINAE_Suppress, false, false, 2)
DIAG(warn_null_arg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "null passed to a callee that requires a non-null argument", 489, SFINAE_Suppress, false, false, 30)
DIAG(warn_null_in_arithmetic_operation, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use of NULL in arithmetic operation", 497, SFINAE_Suppress, false, false, 2)
DIAG(warn_null_in_comparison_operation, CLASS_WARNING, (unsigned)diag::Severity::Warning, "comparison between NULL and non-pointer %select{(%1 and NULL)|(NULL and %1)}0", 497, SFINAE_Suppress, false, false, 2)
DIAG(warn_null_pointer_compare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "comparison of %select{address of|function|array}0 '%1' %select{not |}2equal to a null pointer is always %select{true|false}2", 719, SFINAE_Suppress, false, false, 2)
DIAG(warn_null_resettable_setter, CLASS_WARNING, (unsigned)diag::Severity::Warning, "synthesized setter %0 for null_resettable property %1 does not handle nil", 502, SFINAE_Suppress, false, false, 21)
DIAG(warn_null_ret, CLASS_WARNING, (unsigned)diag::Severity::Warning, "null returned from %select{function|method}0 that requires a non-null return value", 489, SFINAE_Suppress, false, false, 30)
DIAG(warn_nullability_declspec, CLASS_WARNING, (unsigned)diag::Severity::Error, "nullability specifier %0 cannot be applied to non-pointer type %1; did you mean to apply the specifier to the %select{pointer|block pointer|member pointer|function pointer|member function pointer}2?", 505, SFINAE_Suppress, false, false, 21)
DIAG(warn_nullability_inferred_on_nested_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "inferring '_Nonnull' for pointer type within %select{array|reference}0 is deprecated", 507, SFINAE_Suppress, false, false, 21)
DIAG(warn_nullability_lost, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implicit conversion from nullable pointer %0 to non-nullable pointer type %1", 508, SFINAE_Suppress, false, false, 21)
DIAG(warn_nullability_missing, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{pointer|block pointer|member pointer}0 is missing a nullability type specifier (_Nonnull, _Nullable, or _Null_unspecified)", 503, SFINAE_Suppress, false, false, 21)
DIAG(warn_nullability_missing_array, CLASS_WARNING, (unsigned)diag::Severity::Warning, "array parameter is missing a nullability type specifier (_Nonnull, _Nullable, or _Null_unspecified)", 504, SFINAE_Suppress, false, false, 21)
DIAG(warn_objc_boxing_invalid_utf8_string, CLASS_WARNING, (unsigned)diag::Severity::Warning, "string is ill-formed as UTF-8 and will become a null %0 when boxed", 511, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_cdirective_format_string, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "using %0 directive in %select{NSString|CFString}1 which is being passed as a formatting argument to the formatting %select{method|CFfunction}2", 157, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_circular_container, CLASS_WARNING, (unsigned)diag::Severity::Warning, "adding %0 to %1 might cause circular dependency in container", 512, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_collection_literal_element, CLASS_WARNING, (unsigned)diag::Severity::Warning, "object of type %0 is not compatible with %select{array element type|dictionary key type|dictionary value type}1 %2", 519, SFINAE_Suppress, false, false, 26)
DIAG(warn_objc_designated_init_missing_super_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "designated initializer missing a 'super' call to a designated initializer of the super class", 514, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_designated_init_non_designated_init_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "designated initializer invoked a non-designated initializer", 514, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_designated_init_non_super_designated_init_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "designated initializer should only invoke a designated initializer on 'super'", 514, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_direct_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute isn't implemented by this Objective-C runtime", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_direct_property_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "direct attribute on property %0 ignored (not implemented by this Objective-C runtime)", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_implementation_missing_designated_init_override, CLASS_WARNING, (unsigned)diag::Severity::Warning, "method override for the designated initializer of the superclass %objcinstance0 not found", 514, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_invalid_bridge, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 bridges to %1, not %2", 73, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_invalid_bridge_to_cf, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 cannot bridge to %1", 73, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_isa_assign, CLASS_WARNING, (unsigned)diag::Severity::Warning, "assignment to Objective-C's isa is deprecated in favor of object_setClass()", 194, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_isa_use, CLASS_WARNING, (unsigned)diag::Severity::Warning, "direct access to Objective-C's isa is deprecated in favor of object_getClass()", 194, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_literal_comparison, CLASS_WARNING, (unsigned)diag::Severity::Warning, "direct comparison of %select{an array literal|a dictionary literal|a numeric literal|a boxed expression|}0 has undefined behavior", 518, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_missing_super_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "method possibly missing a [super %0] call", 524, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_pointer_cxx_catch_fragile, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cannot catch an exception thrown with @throw in C++ in the non-unified exception model", 527, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_pointer_masking, CLASS_WARNING, (unsigned)diag::Severity::Warning, "bitmasking for introspection of Objective-C object pointers is strongly discouraged", 195, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_pointer_masking_performSelector, CLASS_WARNING, (unsigned)diag::Severity::Warning, "bitmasking for introspection of Objective-C object pointers is strongly discouraged", 196, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_precise_lifetime_meaningless, CLASS_ERROR, (unsigned)diag::Severity::Error, "objc_precise_lifetime is not meaningful for %select{__unsafe_unretained|__autoreleasing}0 objects", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(warn_objc_property_assign_on_object, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'assign' property of object type may become a dangling reference; consider using 'unsafe_unretained'", 528, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_property_copy_missing_on_block, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'copy' attribute must be specified for the block property when -fobjc-gc-only is specified", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_property_default_assign_on_object, CLASS_WARNING, (unsigned)diag::Severity::Warning, "default property attribute 'assign' not appropriate for object", 532, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_property_no_assignment_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "no 'assign', 'retain', or 'copy' attribute is specified - 'assign' is assumed", 532, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_property_retain_of_block, CLASS_WARNING, (unsigned)diag::Severity::Warning, "retain'ed block property does not copy the block - use copy attribute instead", 526, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_readonly_property_has_setter, CLASS_WARNING, (unsigned)diag::Severity::Warning, "setter cannot be specified for a readonly property", 537, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_redundant_literal_use, CLASS_WARNING, (unsigned)diag::Severity::Warning, "using %0 with a literal is redundant", 539, SFINAE_Suppress, false, false, 31)
DIAG(warn_objc_redundant_qualified_class_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "parameterized class %0 already conforms to the protocols listed; did you forget a '*'?", 536, SFINAE_Suppress, false, false, 0)
DIAG(warn_objc_requires_super_protocol, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute cannot be applied to %select{methods in protocols|dealloc}1", 627, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_root_class_missing, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class %0 defined without specifying a base class", 540, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_secondary_init_missing_init_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "convenience initializer missing a 'self' call to another initializer", 514, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_secondary_init_super_init_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "convenience initializer should not invoke an initializer on 'super'", 514, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_string_literal_comparison, CLASS_WARNING, (unsigned)diag::Severity::Warning, "direct comparison of a string literal has undefined behavior", 544, SFINAE_Suppress, false, false, 2)
DIAG(warn_objc_unsafe_perform_selector, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 is incompatible with selectors that return a %select{struct|union|vector}1 type", 546, SFINAE_Suppress, false, false, 2)
DIAG(warn_old_style_cast, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of old-style cast", 548, SFINAE_Suppress, false, false, 2)
DIAG(warn_omp_alignment_not_power_of_two, CLASS_WARNING, (unsigned)diag::Severity::Warning, "aligned clause will be ignored because the requested alignment is not a power of 2", 552, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_allocate_thread_on_task_target_directive, CLASS_WARNING, (unsigned)diag::Severity::Warning, "allocator with the 'thread' trait access has unspecified behavior on '%0' directive", 552, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_declare_target_after_first_use, CLASS_WARNING, (unsigned)diag::Severity::Warning, "declaration marked as declare target after first use, it may lead to incorrect results", 555, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_declare_variant_after_emitted, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'#pragma omp declare variant' cannot be applied to the function that was defined already; the original function might be used", 674, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_declare_variant_after_used, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'#pragma omp declare variant' cannot be applied for function after first usage; the original function might be used", 674, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_declare_variant_marked_as_declare_variant, CLASS_WARNING, (unsigned)diag::Severity::Warning, "variant function in '#pragma omp declare variant' is itself marked as '#pragma omp declare variant'", 674, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_linear_step_zero, CLASS_WARNING, (unsigned)diag::Severity::Warning, "zero linear step (%0 %select{|and other variables in clause }1should probably be const)", 552, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_loop_64_bit_var, CLASS_WARNING, (unsigned)diag::Severity::Warning, "OpenMP loop iteration variable cannot have more than 64 bits size and will be narrowed", 553, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_nesting_simd, CLASS_WARNING, (unsigned)diag::Severity::Warning, "OpenMP only allows an ordered construct with the simd clause nested in a simd construct", 674, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_non_trivial_type_mapped, CLASS_WARNING, (unsigned)diag::Severity::Warning, "Type %0 is not trivially copyable and not guaranteed to be mapped correctly", 554, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_not_in_target_context, CLASS_WARNING, (unsigned)diag::Severity::Warning, "declaration is not declared in any declare target region", 555, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_section_is_char, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "array section %select{lower bound|length}0 is of type 'char'", 134, SFINAE_Suppress, false, false, 11)
DIAG(warn_omp_used_different_allocator, CLASS_WARNING, (unsigned)diag::Severity::Warning, "allocate directive specifies %select{default|'%1'}0 allocator while previously used %select{default|'%3'}2", 552, SFINAE_Suppress, false, false, 11)
DIAG(warn_on_superclass_use, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class implementation may not have super class", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_opencl_attr_deprecated_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 attribute is deprecated and ignored in OpenCL version %1", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_opencl_generic_address_space_arg, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "passing non-generic address space pointer to %0 may cause dynamic conversion affecting performance", 151, SFINAE_Suppress, false, false, 26)
DIAG(warn_operator_new_returns_null, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 should not return a null pointer unless it is declared 'throw()'%select{| or 'noexcept'}1", 479, SFINAE_Suppress, false, false, 2)
DIAG(warn_os_log_format_narg, CLASS_ERROR, (unsigned)diag::Severity::Error, "os_log() '%%n' format specifier is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 2)
DIAG(warn_out_of_range_compare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "result of comparison of %select{constant %0|true|false}1 with %select{expression of type %2|boolean expression}3 is always %4", 716, SFINAE_Suppress, false, false, 2)
DIAG(warn_overaligned_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "type %0 requires %1 bytes of alignment and the default allocator only guarantees %2 bytes", 560, SFINAE_Suppress, false, false, 2)
DIAG(warn_overloaded_shift_in_comparison, CLASS_WARNING, (unsigned)diag::Severity::Warning, "overloaded operator %select{>>|<<}0 has higher precedence than comparison operator", 563, SFINAE_Suppress, false, false, 2)
DIAG(warn_overloaded_virtual, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%q0 hides overloaded virtual %select{function|functions}1", 564, SFINAE_Suppress, false, false, 2)
DIAG(warn_overriding_method_missing_noescape, CLASS_WARNING, (unsigned)diag::Severity::Warning, "parameter of overriding method should be annotated with __attribute__((noescape))", 455, SFINAE_Suppress, false, false, 2)
DIAG(warn_param_return_typestate_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "parameter '%0' not in expected state when the function returns: expected '%1', observed '%2'", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_param_typestate_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "argument not in expected state; expected '%0', observed '%1'", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_parameter_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 is a large (%1 bytes) pass-by-value argument; pass it by reference instead ?", 392, SFINAE_Suppress, false, false, 2)
DIAG(warn_parens_disambiguated_as_function_declaration, CLASS_WARNING, (unsigned)diag::Severity::Warning, "parentheses were disambiguated as a function declaration", 814, SFINAE_Suppress, false, false, 2)
DIAG(warn_parens_disambiguated_as_variable_declaration, CLASS_WARNING, (unsigned)diag::Severity::Warning, "parentheses were disambiguated as redundant parentheses around declaration of variable named %0", 814, SFINAE_Suppress, false, false, 2)
DIAG(warn_pass_class_arg_to_vararg, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "passing object of class type %0 through variadic %select{function|block|method|constructor}1%select{|; did you mean to call '%3'?}2", 136, SFINAE_Suppress, false, false, 2)
DIAG(warn_pessimizing_move_on_initialization, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "moving a temporary object prevents copy elision", 581, SFINAE_Suppress, false, false, 2)
DIAG(warn_pessimizing_move_on_return, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "moving a local object in a return statement prevents copy elision", 581, SFINAE_Suppress, false, false, 2)
DIAG(warn_pointer_abs, CLASS_WARNING, (unsigned)diag::Severity::Warning, "taking the absolute value of %select{pointer|function|array}0 type %1 is suspicious", 8, SFINAE_Suppress, false, false, 2)
DIAG(warn_pointer_arith_null_ptr, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "performing pointer arithmetic on a null pointer has undefined behavior%select{| if the offset is nonzero}0", 501, SFINAE_Suppress, false, false, 2)
DIAG(warn_pointer_compare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "comparing a pointer to a null character constant; did you mean to compare to %select{NULL|(void *)0}0?", 584, SFINAE_Suppress, false, false, 2)
DIAG(warn_pointer_indirection_from_incompatible_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "dereference of type %1 that was reinterpret_cast from type %0 has undefined behavior", 747, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_attribute_unused, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unused attribute %0 in '#pragma clang attribute push' region", 591, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_options_align_reset_failed, CLASS_WARNING, (unsigned)diag::Severity::Warning, "#pragma options align=reset failed: %0", 321, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_pack_invalid_alignment, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected #pragma pack parameter to be '1', '2', '4', '8', or '16'", 321, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_pack_modified_after_include, CLASS_WARNING, (unsigned)diag::Severity::Warning, "the current #pragma pack alignment value is modified in the included file", 593, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_pack_no_pop_eof, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unterminated '#pragma pack (push, ...)' at end of file", 593, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_pack_non_default_at_include, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "non-default #pragma pack value changes the alignment of struct or union members in the included file", 594, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_pack_pop_identifier_and_alignment, CLASS_WARNING, (unsigned)diag::Severity::Warning, "specifying both a name and alignment to 'pop' is undefined", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_pack_show, CLASS_WARNING, (unsigned)diag::Severity::Warning, "value of #pragma pack(show) == %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_pop_failed, CLASS_WARNING, (unsigned)diag::Severity::Warning, "#pragma %0(pop, ...) failed: %1", 321, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_unused_expected_var_arg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "only variables can be arguments to '#pragma unused'", 321, SFINAE_Suppress, false, false, 2)
DIAG(warn_pragma_unused_undeclared_var, CLASS_WARNING, (unsigned)diag::Severity::Warning, "undeclared variable %0 used as an argument for '#pragma unused'", 321, SFINAE_Suppress, false, false, 2)
DIAG(warn_precedence_bitwise_conditional, CLASS_WARNING, (unsigned)diag::Severity::Warning, "operator '?:' has lower precedence than '%0'; '%0' will be evaluated first", 66, SFINAE_Suppress, false, false, 2)
DIAG(warn_precedence_bitwise_rel, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 has lower precedence than %1; %1 will be evaluated first", 571, SFINAE_Suppress, false, false, 2)
DIAG(warn_precedence_conditional, CLASS_WARNING, (unsigned)diag::Severity::Warning, "operator '?:' has lower precedence than '%0'; '%0' will be evaluated first", 571, SFINAE_Suppress, false, false, 2)
DIAG(warn_printf_ObjCflags_without_ObjCConversion, CLASS_WARNING, (unsigned)diag::Severity::Warning, "object format flags cannot be used with '%0' conversion specifier", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_asterisk_missing_arg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%select{*|.*}0' specified field %select{width|precision}0 is missing a matching 'int' argument", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_asterisk_wrong_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "field %select{width|precision}0 should have type %1, but argument has type %2", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_data_arg_not_used, CLASS_WARNING, (unsigned)diag::Severity::Warning, "data argument not used by format string", 266, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_empty_objc_flag, CLASS_WARNING, (unsigned)diag::Severity::Warning, "missing object format flag", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_format_string_contains_null_char, CLASS_WARNING, (unsigned)diag::Severity::Warning, "format string contains '\\0' within the string body", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_format_string_not_null_terminated, CLASS_WARNING, (unsigned)diag::Severity::Warning, "format string is not null-terminated", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_ignored_flag, CLASS_WARNING, (unsigned)diag::Severity::Warning, "flag '%0' is ignored when flag '%1' is present", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_incomplete_specifier, CLASS_WARNING, (unsigned)diag::Severity::Warning, "incomplete format specifier", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_insufficient_data_args, CLASS_WARNING, (unsigned)diag::Severity::Warning, "more '%%' conversions than data arguments", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_invalid_objc_flag, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' is not a valid object format flag", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_nonsensical_flag, CLASS_WARNING, (unsigned)diag::Severity::Warning, "flag '%0' results in undefined behavior with '%1' conversion specifier", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_nonsensical_optional_amount, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{field width|precision}0 used with '%1' conversion specifier, resulting in undefined behavior", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_printf_positional_arg_exceeds_data_args, CLASS_WARNING, (unsigned)diag::Severity::Warning, "data argument position '%0' exceeds the number of data arguments (%1)", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_private_extern, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use of __private_extern__ on a declaration may not produce external symbol private to the linkage unit and is deprecated", 598, SFINAE_Suppress, false, false, 2)
DIAG(warn_property_access_suggest, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property %0 not found on object of type %1; did you mean to access property %2?", 604, SFINAE_Suppress, false, false, 2)
DIAG(warn_property_attr_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property attribute in class extension does not match the primary class", 605, SFINAE_Suppress, false, false, 2)
DIAG(warn_property_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%1' attribute on property %0 does not match the property inherited from %2", 605, SFINAE_Suppress, false, false, 2)
DIAG(warn_property_getter_owning_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property declared as returning non-retained objects; getter returning retained objects", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_property_implicitly_mismatched, CLASS_WARNING, (unsigned)diag::Severity::Warning, "primary property declaration is implicitly strong while redeclaration in class extension is weak", 530, SFINAE_Suppress, false, false, 2)
DIAG(warn_property_method_deprecated, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property access is using %0 method which is deprecated", 186, SFINAE_Suppress, false, false, 29)
DIAG(warn_property_redecl_getter_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "getter name mismatch between property redeclaration (%1) and its original declaration (%0)", 605, SFINAE_Suppress, false, false, 2)
DIAG(warn_property_types_are_incompatible, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property type %0 is incompatible with type %1 inherited from %2", 348, SFINAE_Suppress, false, false, 2)
DIAG(warn_protocol_property_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property %select{of type %1|with attribute '%1'|without attribute '%1'|with getter %1|with setter %1}0 was selected for synthesis", 607, SFINAE_Suppress, false, false, 2)
DIAG(warn_pt_guarded_pass_by_reference, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "passing the value that %1 points to by reference requires holding %0 %select{'%2'|'%2' exclusively}3", 731, SFINAE_Suppress, false, false, 2)
DIAG(warn_ptr_arith_exceeds_bounds, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "the pointer incremented by %0 refers past the end of the array (that contains %1 element%s2)", 36, SFINAE_Suppress, false, false, 2)
DIAG(warn_ptr_arith_precedes_bounds, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "the pointer decremented by %0 refers before the beginning of the array", 36, SFINAE_Suppress, false, false, 2)
DIAG(warn_ptr_independentclass_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'objc_independent_class' attribute may be put on Objective-C object pointer type only; attribute is ignored", 5, SFINAE_Suppress, false, false, 2)
DIAG(warn_qual_return_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'%0' type qualifier%s1 on return type %plural{1:has|:have}1 no effect", 322, SFINAE_Suppress, false, false, 2)
DIAG(warn_readonly_property, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute 'readonly' of property %0 restricts attribute 'readwrite' of property inherited from %1", 605, SFINAE_Suppress, false, false, 2)
DIAG(warn_receiver_forward_class, CLASS_WARNING, (unsigned)diag::Severity::Warning, "receiver %0 is a forward class and corresponding @interface may not exist", 615, SFINAE_Suppress, false, false, 2)
DIAG(warn_receiver_forward_instance, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "receiver type %0 for instance message is a forward declaration", 615, SFINAE_Suppress, false, false, 5)
DIAG(warn_redecl_library_builtin, CLASS_WARNING, (unsigned)diag::Severity::Warning, "incompatible redeclaration of library function %0", 344, SFINAE_Suppress, false, false, 2)
DIAG(warn_redeclaration_without_attribute_prev_attribute_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%q0 redeclared without %1 attribute: previous %1 ignored", 355, SFINAE_Suppress, false, false, 2)
DIAG(warn_redeclaration_without_import_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%q0 redeclared without 'dllimport' attribute: 'dllexport' attribute added", 355, SFINAE_Suppress, false, false, 2)
DIAG(warn_redefine_extname_not_applied, CLASS_WARNING, (unsigned)diag::Severity::Warning, "#pragma redefine_extname is applicable to external C declarations only; not applied to %select{function|variable}0 %1", 596, SFINAE_Suppress, false, false, 2)
DIAG(warn_redefinition_in_param_list, CLASS_WARNING, (unsigned)diag::Severity::Warning, "redefinition of %0 will not be visible outside of this function", 815, SFINAE_Suppress, false, false, 2)
DIAG(warn_redundant_loop_iteration, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable %0 is %select{decremented|incremented}1 both in the loop header and in the loop body", 264, SFINAE_Suppress, false, false, 2)
DIAG(warn_redundant_move_on_return, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "redundant move in return statement", 618, SFINAE_Suppress, false, false, 2)
DIAG(warn_redundant_parens_around_declarator, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "redundant parentheses surrounding declarator", 619, SFINAE_Suppress, false, false, 2)
DIAG(warn_reference_field_is_uninit, CLASS_WARNING, (unsigned)diag::Severity::Warning, "reference %0 is not yet bound to a value when used here", 757, SFINAE_Suppress, false, false, 2)
DIAG(warn_register_objc_catch_parm, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'register' storage specifier on @catch parameter will be ignored", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_reinterpret_different_from_static, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'reinterpret_cast' %select{from|to}3 class %0 %select{to|from}3 its %select{virtual base|base at non-zero offset}2 %1 behaves differently from 'static_cast'", 621, SFINAE_Suppress, false, false, 2)
DIAG(warn_related_result_type_compatibility_class, CLASS_WARNING, (unsigned)diag::Severity::Warning, "method is expected to return an instance of its class type %diff{$, but is declared to return $|, but is declared to return different type}0,1", 0, SFINAE_Suppress, false, false, 19)
DIAG(warn_related_result_type_compatibility_protocol, CLASS_WARNING, (unsigned)diag::Severity::Warning, "protocol method is expected to return an instance of the implementing class, but is declared to return %0", 0, SFINAE_Suppress, false, false, 19)
DIAG(warn_remainder_division_by_zero, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{remainder|division}0 by zero is undefined", 207, SFINAE_Suppress, false, false, 2)
DIAG(warn_require_const_init_added_too_late, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'require_constant_initialization' attribute added after initialization of variable", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_ret_addr_label, CLASS_WARNING, (unsigned)diag::Severity::Warning, "returning address of label, which is local", 631, SFINAE_Suppress, false, false, 2)
DIAG(warn_ret_local_temp_addr_ref, CLASS_WARNING, (unsigned)diag::Severity::Warning, "returning %select{address of|reference to}0 local temporary object", 631, SFINAE_Suppress, false, false, 2)
DIAG(warn_ret_stack_addr_ref, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{address of|reference to}0 stack memory associated with %select{local variable|parameter}2 %1 returned", 631, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_missing_expr, CLASS_WARNING, (unsigned)diag::Severity::Error, "non-void %select{function|method}1 %0 should return a value", 634, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_std_move, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "local variable %0 will be copied despite being %select{returned|thrown}1 by name", 632, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_std_move_in_cxx11, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "prior to the resolution of a defect report against ISO C++11, local variable %0 would have been copied despite being returned by name, due to its not matching the function return type%diff{ ($ vs $)|}1,2", 633, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_typestate_for_unconsumable_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "return state set for an unconsumable type '%0'", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_typestate_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "return value not in expected state; expected '%0', observed '%1'", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_value_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "return value of %0 is a large (%1 bytes) pass-by-value object; pass it by reference instead ?", 392, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_value_udt, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 has C-linkage specified, but returns user-defined type %1 which is incompatible with C", 635, SFINAE_Suppress, false, false, 2)
DIAG(warn_return_value_udt_incomplete, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 has C-linkage specified, but returns incomplete type %1 which could be incompatible with C", 635, SFINAE_Suppress, false, false, 2)
DIAG(warn_riscv_repeated_interrupt_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "repeated RISC-V 'interrupt' attribute", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_root_inst_method_not_found, CLASS_WARNING, (unsigned)diag::Severity::Warning, "instance method %0 is being used on 'Class' which is not in the root class", 522, SFINAE_Suppress, false, false, 2)
DIAG(warn_sampler_initializer_invalid_bits, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "sampler initializer has invalid %0 bits", 675, SFINAE_Suppress, false, false, 2)
DIAG(warn_scanf_nonzero_width, CLASS_WARNING, (unsigned)diag::Severity::Warning, "zero field width in scanf format string is unused", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_scanf_scanlist_incomplete, CLASS_WARNING, (unsigned)diag::Severity::Warning, "no closing ']' for '%%[' in scanf format string", 265, SFINAE_Suppress, false, false, 30)
DIAG(warn_second_arg_of_va_start_not_last_named_param, CLASS_WARNING, (unsigned)diag::Severity::Warning, "second argument to 'va_start' is not the last named parameter", 809, SFINAE_Suppress, false, false, 2)
DIAG(warn_second_parameter_to_va_arg_never_compatible, CLASS_WARNING, (unsigned)diag::Severity::Warning, "second argument to 'va_arg' is of promotable type %0; this va_arg has undefined behavior because arguments will be promoted to %1", 809, SFINAE_Suppress, false, false, 2)
DIAG(warn_second_parameter_to_va_arg_not_pod, CLASS_WARNING, (unsigned)diag::Severity::Error, "second argument to 'va_arg' is of non-POD type %0", 487, SFINAE_Suppress, false, false, 2)
DIAG(warn_second_parameter_to_va_arg_ownership_qualified, CLASS_WARNING, (unsigned)diag::Severity::Error, "second argument to 'va_arg' is of ARC ownership-qualified type %0", 487, SFINAE_Suppress, false, false, 2)
DIAG(warn_self_assignment_builtin, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicitly assigning value of variable of type %0 to itself", 640, SFINAE_Suppress, false, false, 2)
DIAG(warn_self_assignment_overloaded, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicitly assigning value of variable of type %0 to itself", 642, SFINAE_Suppress, false, false, 2)
DIAG(warn_self_move, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicitly moving variable of type %0 to itself", 643, SFINAE_Suppress, false, false, 2)
DIAG(warn_setter_getter_impl_required, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property %0 requires method %1 to be defined - use @synthesize, @dynamic or provide a method implementation in this class implementation", 529, SFINAE_Suppress, false, false, 2)
DIAG(warn_setter_getter_impl_required_in_category, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property %0 requires method %1 to be defined - use @dynamic or provide a method implementation in this category", 529, SFINAE_Suppress, false, false, 2)
DIAG(warn_shadow_field, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{parameter|non-static data member}3 %0 %select{|of %1 }3shadows member inherited from type %2", 650, SFINAE_Suppress, false, false, 0)
DIAG(warn_shift_gt_typewidth, CLASS_WARNING, (unsigned)diag::Severity::Warning, "shift count >= width of type", 656, SFINAE_Suppress, false, false, 2)
DIAG(warn_shift_lhs_negative, CLASS_WARNING, (unsigned)diag::Severity::Warning, "shifting a negative signed value is undefined", 657, SFINAE_Suppress, false, false, 2)
DIAG(warn_shift_negative, CLASS_WARNING, (unsigned)diag::Severity::Warning, "shift count is negative", 655, SFINAE_Suppress, false, false, 2)
DIAG(warn_shift_result_gt_typewidth, CLASS_WARNING, (unsigned)diag::Severity::Warning, "signed shift result (%0) requires %1 bits to represent, but %2 only has %3 bits", 659, SFINAE_Suppress, false, false, 2)
DIAG(warn_shift_result_sets_sign_bit, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "signed shift result (%0) sets the sign bit of the shift expression's type (%1) and becomes negative", 660, SFINAE_Suppress, false, false, 2)
DIAG(warn_side_effects_typeid, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expression with side effects will be evaluated despite being used as an operand to 'typeid'", 590, SFINAE_Suppress, false, false, 34)
DIAG(warn_side_effects_unevaluated_context, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expression with side effects has no effect in an unevaluated context", 750, SFINAE_Suppress, false, false, 34)
DIAG(warn_signed_bitfield_enum_conversion, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "signed bit-field %0 needs an extra bit to represent the largest positive enumerators of %1", 64, SFINAE_Suppress, false, false, 26)
DIAG(warn_sizeof_array_decay, CLASS_WARNING, (unsigned)diag::Severity::Warning, "sizeof on pointer operation will return size of %0 instead of %1", 668, SFINAE_Suppress, false, false, 2)
DIAG(warn_sizeof_array_param, CLASS_WARNING, (unsigned)diag::Severity::Warning, "sizeof on array function parameter will return size of %0 instead of %1", 667, SFINAE_Suppress, false, false, 2)
DIAG(warn_sizeof_pointer_expr_memaccess, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' call operates on objects of type %1 while the size is based on a different type %2", 671, SFINAE_Suppress, false, false, 2)
DIAG(warn_sizeof_pointer_expr_memaccess_note, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "did you mean to %select{dereference the argument to 'sizeof' (and multiply it by the number of elements)|remove the addressof in the argument to 'sizeof' (and multiply it by the number of elements)|provide an explicit length}0?", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_sizeof_pointer_type_memaccess, CLASS_WARNING, (unsigned)diag::Severity::Warning, "argument to 'sizeof' in %0 call is the same pointer type %1 as the %select{destination|source}2; expected %3 or an explicit length", 671, SFINAE_Suppress, false, false, 2)
DIAG(warn_sometimes_uninit_var, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable %0 is %select{used|captured}1 uninitialized whenever %select{'%3' condition is %select{true|false}4|'%3' loop %select{is entered|exits because its condition is false}4|'%3' loop %select{condition is true|exits because its condition is false}4|switch %3 is taken|its declaration is reached|%3 is called}2", 673, SFINAE_Suppress, false, false, 2)
DIAG(warn_standalone_specifier, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' ignored on this declaration", 449, SFINAE_Suppress, false, false, 2)
DIAG(warn_static_array_too_small, CLASS_WARNING, (unsigned)diag::Severity::Warning, "array argument is too small; %select{contains %0 elements|is of size %0}2, callee requires at least %1", 35, SFINAE_Suppress, false, false, 2)
DIAG(warn_static_local_in_extern_inline, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-constant static local variable in inline function may be different in different files", 681, SFINAE_Suppress, false, false, 2)
DIAG(warn_static_main, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'main' should not be declared static", 402, SFINAE_Suppress, false, false, 2)
DIAG(warn_static_self_reference_in_init, CLASS_WARNING, (unsigned)diag::Severity::Warning, "static variable %0 is suspiciously used within its own initialization", 682, SFINAE_Suppress, false, false, 2)
DIAG(warn_strict_multiple_method_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "multiple methods named %0 found", 696, SFINAE_Suppress, false, false, 2)
DIAG(warn_strict_prototypes, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "this %select{function declaration is not|block declaration is not|old-style function definition is not preceded by}0 a prototype", 695, SFINAE_Suppress, false, false, 2)
DIAG(warn_string_plus_char, CLASS_WARNING, (unsigned)diag::Severity::Warning, "adding %0 to a string pointer does not append to the string", 699, SFINAE_Suppress, false, false, 2)
DIAG(warn_string_plus_int, CLASS_WARNING, (unsigned)diag::Severity::Warning, "adding %0 to a string does not append to the string", 700, SFINAE_Suppress, false, false, 2)
DIAG(warn_stringcompare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "result of comparison against %select{a string literal|@encode}0 is unspecified (use an explicit string comparison function instead)", 697, SFINAE_Suppress, false, false, 2)
DIAG(warn_strlcpycat_wrong_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "size argument in %0 call appears to be size of the source; expected the size of the destination", 701, SFINAE_Suppress, false, false, 2)
DIAG(warn_strncat_large_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "the value of the size argument in 'strncat' is too large, might lead to a buffer overflow", 702, SFINAE_Suppress, false, false, 2)
DIAG(warn_strncat_src_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "size argument in 'strncat' call appears to be size of the source", 702, SFINAE_Suppress, false, false, 2)
DIAG(warn_strncat_wrong_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "the value of the size argument to 'strncat' is wrong", 702, SFINAE_Suppress, false, false, 2)
DIAG(warn_struct_class_previous_tag_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%2 defined as %select{a struct|an interface|a class}0%select{| template}1 here but previously declared as %select{a struct|an interface|a class}3%select{| template}1; this is valid, but may result in linker errors under the Microsoft C++ ABI", 446, SFINAE_Suppress, false, false, 2)
DIAG(warn_struct_class_tag_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{struct|interface|class}0%select{| template}1 %2 was previously declared as a %select{struct|interface|class}3%select{| template}1; this is valid, but may result in linker errors under the Microsoft C++ ABI", 446, SFINAE_Suppress, false, false, 2)
DIAG(warn_sub_ptr_zero_size_types, CLASS_WARNING, (unsigned)diag::Severity::Warning, "subtraction of pointers to type %0 of zero size has undefined behavior", 582, SFINAE_Suppress, false, false, 2)
DIAG(warn_subscript_is_char, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "array subscript is of type 'char'", 134, SFINAE_Suppress, false, false, 2)
DIAG(warn_suggest_noreturn_block, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "block could be declared with attribute 'noreturn'", 456, SFINAE_Suppress, false, false, 2)
DIAG(warn_suggest_noreturn_function, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{function|method}0 %1 could be declared with attribute 'noreturn'", 456, SFINAE_Suppress, false, false, 2)
DIAG(warn_superclass_variable_sized_type_not_at_end, CLASS_WARNING, (unsigned)diag::Severity::Warning, "field %0 can overwrite instance variable %1 with variable sized type %2 in superclass %3", 515, SFINAE_Suppress, false, false, 2)
DIAG(warn_suspicious_bzero_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'size' argument to bzero is '0'", 704, SFINAE_Suppress, false, false, 2)
DIAG(warn_suspicious_sizeof_memset, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{'size' argument to memset is '0'|setting buffer to a 'sizeof' expression}0; did you mean to transpose the last two arguments?", 407, SFINAE_Suppress, false, false, 2)
DIAG(warn_sycl_kernel_invalid_template_param_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "template parameter of a function template with the 'sycl_kernel' attribute cannot be a non-type template parameter", 317, SFINAE_Suppress, false, false, 0)
DIAG(warn_sycl_kernel_num_of_function_params, CLASS_WARNING, (unsigned)diag::Severity::Warning, "function template with 'sycl_kernel' attribute must have a single parameter", 317, SFINAE_Suppress, false, false, 0)
DIAG(warn_sycl_kernel_num_of_template_params, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'sycl_kernel' attribute only applies to a function template with at least two template parameters", 317, SFINAE_Suppress, false, false, 0)
DIAG(warn_sycl_kernel_return_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "function template with 'sycl_kernel' attribute must have a 'void' return type", 317, SFINAE_Suppress, false, false, 0)
DIAG(warn_sync_fetch_and_nand_semantics_change, CLASS_WARNING, (unsigned)diag::Severity::Warning, "the semantics of this intrinsic changed with GCC version 4.4 - the newer semantics are provided here", 710, SFINAE_Suppress, false, false, 2)
DIAG(warn_taking_address_of_packed_member, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "taking address of packed member %0 of class or structure %q1 may result in an unaligned pointer value", 12, SFINAE_Suppress, false, false, 2)
DIAG(warn_tautological_bool_compare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "result of comparison of %select{constant %0|true|false}1 with %select{expression of type %2|boolean expression}3 is always %4", 714, SFINAE_Suppress, false, false, 2)
DIAG(warn_tautological_compare_objc_bool, CLASS_WARNING, (unsigned)diag::Severity::Warning, "result of comparison of constant %0 with expression of type 'BOOL' is always %1, as the only well defined values for 'BOOL' are YES and NO", 717, SFINAE_Suppress, false, false, 2)
DIAG(warn_tautological_constant_compare, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "result of comparison %select{%3|%1}0 %2 %select{%1|%3}0 is always %4", 720, SFINAE_Suppress, false, false, 2)
DIAG(warn_tautological_overlap_comparison, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "overlapping comparisons always evaluate to %select{false|true}0", 718, SFINAE_Suppress, false, false, 2)
DIAG(warn_template_arg_negative, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "non-type template argument with value '%0' converted to '%1' for unsigned template parameter of type %2", 151, SFINAE_Suppress, false, false, 26)
DIAG(warn_template_arg_too_large, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "non-type template argument value '%0' truncated to '%1' for template parameter of type %2", 151, SFINAE_Suppress, false, false, 26)
DIAG(warn_template_export_unsupported, CLASS_WARNING, (unsigned)diag::Severity::Warning, "exported templates are unsupported", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_template_qualified_friend_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "dependent nested name specifier '%0' for friend template declaration is not supported; ignoring this friend declaration", 778, SFINAE_Suppress, false, false, 2)
DIAG(warn_template_qualified_friend_unsupported, CLASS_WARNING, (unsigned)diag::Severity::Warning, "dependent nested name specifier '%0' for friend class declaration is not supported; turning off access control for %1", 778, SFINAE_Suppress, false, false, 2)
DIAG(warn_template_spec_extra_headers, CLASS_WARNING, (unsigned)diag::Severity::Warning, "extraneous template parameter list in template specialization", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_tentative_incomplete_array, CLASS_WARNING, (unsigned)diag::Severity::Warning, "tentative array definition assumed to have one element", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_this_bool_conversion, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'this' pointer cannot be null in well-defined C++ code; pointer may be assumed to always convert to true", 742, SFINAE_Suppress, false, false, 26)
DIAG(warn_this_null_compare, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'this' pointer cannot be null in well-defined C++ code; comparison may be assumed to always evaluate to %select{true|false}0", 721, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_attribute_argument_not_lockable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 attribute requires arguments whose type is annotated with 'capability' attribute; type here is %1", 727, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_attribute_decl_not_lockable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 attribute can only be applied in a context annotated with 'capability(\"mutex\")' attribute", 727, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_attribute_decl_not_pointer, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 only applies to pointer types; type here is %1", 727, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_attribute_ignored, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "ignoring %0 attribute because its argument is invalid", 727, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_attribute_not_on_capability_member, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 attribute without capability arguments refers to 'this', but %1 isn't annotated with 'capability' or 'scoped_lockable' attribute", 727, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_attribute_not_on_non_static_member, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 attribute without capability arguments can only be applied to non-static methods of a class", 727, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_safety_beta, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "Thread safety beta warning.", 728, SFINAE_Suppress, false, false, 2)
DIAG(warn_thread_safety_verbose, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "Thread safety verbose warning.", 732, SFINAE_Suppress, false, false, 2)
DIAG(warn_throw_in_noexcept_func, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 has a non-throwing exception specification but can still throw", 240, SFINAE_Suppress, false, false, 2)
DIAG(warn_throw_underaligned_obj, CLASS_WARNING, (unsigned)diag::Severity::Warning, "underaligned exception object thrown", 749, SFINAE_Suppress, false, false, 2)
DIAG(warn_transparent_union_attribute_field_size_align, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{alignment|size}0 of field %1 (%2 bits) does not match the %select{alignment|size}0 of the first field in transparent union; transparent_union attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_transparent_union_attribute_floating, CLASS_WARNING, (unsigned)diag::Severity::Warning, "first field of a transparent union cannot have %select{floating point|vector}0 type %1; transparent_union attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_transparent_union_attribute_not_definition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "transparent_union attribute can only be applied to a union definition; attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_transparent_union_attribute_zero_fields, CLASS_WARNING, (unsigned)diag::Severity::Warning, "transparent union definition must contain at least one field; transparent_union attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_type_attribute_wrong_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' only applies to %select{function|pointer|Objective-C object or block pointer}1 types; type here is %2", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_type_safety_null_pointer_required, CLASS_WARNING, (unsigned)diag::Severity::Warning, "specified %0 type tag requires a null pointer", 735, SFINAE_Suppress, false, false, 2)
DIAG(warn_type_safety_type_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "argument type %0 doesn't match specified %1 type tag %select{that requires %3|}2", 735, SFINAE_Suppress, false, false, 2)
DIAG(warn_type_tag_for_datatype_wrong_kind, CLASS_WARNING, (unsigned)diag::Severity::Warning, "this type tag was not designed to be used with this function", 735, SFINAE_Suppress, false, false, 2)
DIAG(warn_typecheck_function_qualifiers_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' qualifier on function type %1 has no effect", 322, SFINAE_Suppress, false, false, 2)
DIAG(warn_typecheck_function_qualifiers_unspecified, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' qualifier on function type %1 has unspecified behavior", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_typecheck_reference_qualifiers, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' qualifier on reference type %1 has no effect", 322, SFINAE_Suppress, false, false, 2)
DIAG(warn_typecheck_vector_element_sizes_not_equal, CLASS_WARNING, (unsigned)diag::Severity::Error, "vector operands do not have the same elements sizes (%0 and %1)", 811, SFINAE_Suppress, false, false, 2)
DIAG(warn_typecheck_zero_static_array_size, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'static' has no effect on zero-length arrays", 35, SFINAE_Suppress, false, false, 2)
DIAG(warn_unannotated_fallthrough, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unannotated fall-through between switch labels", 327, SFINAE_Suppress, false, false, 2)
DIAG(warn_unannotated_fallthrough_per_function, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unannotated fall-through between switch labels in partly-annotated function", 328, SFINAE_Suppress, false, false, 2)
DIAG(warn_unavailable_def, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "implementing unavailable method", 192, SFINAE_Suppress, false, false, 2)
DIAG(warn_unavailable_fwdclass_message, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 may be unavailable because the receiver type is unknown", 739, SFINAE_Suppress, false, false, 2)
DIAG(warn_undeclared_selector, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "undeclared selector %0", 740, SFINAE_Suppress, false, false, 2)
DIAG(warn_undeclared_selector_with_typo, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "undeclared selector %0; did you mean %1?", 740, SFINAE_Suppress, false, false, 2)
DIAG(warn_undef_interface, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cannot find interface declaration for %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_undef_interface_suggest, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cannot find interface declaration for %0; did you mean %1?", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_undef_method_impl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "method definition for %0 not found", 351, SFINAE_Suppress, false, false, 2)
DIAG(warn_undef_protocolref, CLASS_WARNING, (unsigned)diag::Severity::Warning, "cannot find protocol definition for %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_undefined_inline, CLASS_WARNING, (unsigned)diag::Severity::Warning, "inline function %q0 is not defined", 744, SFINAE_Suppress, false, false, 2)
DIAG(warn_undefined_internal, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{function|variable}0 %q1 has internal linkage but is not defined", 745, SFINAE_Suppress, false, false, 2)
DIAG(warn_undefined_reinterpret_cast, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "reinterpret_cast from %0 to %1 has undefined behavior", 747, SFINAE_Suppress, false, false, 2)
DIAG(warn_unguarded_availability, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 is only available on %1 %2 or newer", 751, SFINAE_Suppress, false, false, 2)
DIAG(warn_unguarded_availability_new, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 is only available on %1 %2 or newer", 752, SFINAE_Suppress, false, false, 2)
DIAG(warn_unhandled_ms_attribute_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "__declspec attribute %0 is not supported", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_unimplemented_protocol_method, CLASS_WARNING, (unsigned)diag::Severity::Warning, "method %0 in protocol %1 not implemented", 606, SFINAE_Suppress, false, false, 2)
DIAG(warn_unimplemented_selector, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "no method with selector %0 is implemented in this translation unit", 638, SFINAE_Suppress, false, false, 2)
DIAG(warn_uninit_byref_blockvar_captured_by_block, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "block pointer variable %0 is %select{uninitialized|null}1 when captured by block", 757, SFINAE_Suppress, false, false, 2)
DIAG(warn_uninit_self_reference_in_init, CLASS_WARNING, (unsigned)diag::Severity::Warning, "variable %0 is uninitialized when used within its own initialization", 757, SFINAE_Suppress, false, false, 2)
DIAG(warn_uninit_self_reference_in_reference_init, CLASS_WARNING, (unsigned)diag::Severity::Warning, "reference %0 is not yet bound to a value when used within its own initialization", 757, SFINAE_Suppress, false, false, 2)
DIAG(warn_uninit_var, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable %0 is uninitialized when %select{used here|captured by block}1", 757, SFINAE_Suppress, false, false, 2)
DIAG(warn_unknown_sanitizer_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unknown sanitizer '%0' ignored", 763, SFINAE_Suppress, false, false, 2)
DIAG(warn_unlock_but_no_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "releasing %0 '%1' that was not held", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_unlock_kind_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "releasing %0 '%1' using %select{shared|exclusive}2 access, expected %select{shared|exclusive}3 access", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_unneeded_internal_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{function|variable}0 %1 is not needed and will not be emitted", 766, SFINAE_Suppress, false, false, 34)
DIAG(warn_unneeded_member_function, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "member function %0 is not needed and will not be emitted", 767, SFINAE_Suppress, false, false, 2)
DIAG(warn_unneeded_static_internal_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'static' function %0 declared in header file should be declared 'static inline'", 766, SFINAE_Suppress, false, false, 34)
DIAG(warn_unreachable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "code will never be executed", 768, SFINAE_Suppress, false, false, 2)
DIAG(warn_unreachable_break, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'break' will never be executed", 770, SFINAE_Suppress, false, false, 2)
DIAG(warn_unreachable_default, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "default label in switch which covers all enumeration values", 155, SFINAE_Suppress, false, false, 2)
DIAG(warn_unreachable_loop_increment, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "loop will run at most once (loop increment never executed)", 771, SFINAE_Suppress, false, false, 2)
DIAG(warn_unreachable_return, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'return' will never be executed", 772, SFINAE_Suppress, false, false, 2)
DIAG(warn_unsequenced_mod_mod, CLASS_WARNING, (unsigned)diag::Severity::Warning, "multiple unsequenced modifications to %0", 773, SFINAE_Suppress, false, false, 2)
DIAG(warn_unsequenced_mod_use, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unsequenced modification and access to %0", 773, SFINAE_Suppress, false, false, 2)
DIAG(warn_unsigned_abs, CLASS_WARNING, (unsigned)diag::Severity::Warning, "taking the absolute value of unsigned type %0 has no effect", 8, SFINAE_Suppress, false, false, 2)
DIAG(warn_unsigned_always_true_comparison, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "result of comparison of %select{%3|unsigned expression}0 %2 %select{unsigned expression|%3}0 is always %4", 723, SFINAE_Suppress, false, false, 2)
DIAG(warn_unsigned_bitfield_assigned_signed_enum, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "assigning value of signed enum type %1 to unsigned bit-field %0; negative enumerators of enum %1 will be converted to positive values", 64, SFINAE_Suppress, false, false, 26)
DIAG(warn_unsigned_enum_always_true_comparison, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "result of comparison of %select{%3|unsigned enum expression}0 %2 %select{unsigned enum expression|%3}0 is always %4", 722, SFINAE_Suppress, false, false, 2)
DIAG(warn_unsupported_lifetime_extension, CLASS_WARNING, (unsigned)diag::Severity::Warning, "sorry, lifetime extension of %select{temporary|backing array of initializer list}0 created by aggregate initialization using default member initializer is not supported; lifetime of %select{temporary|backing array}0 will end at the end of the full-expression", 163, SFINAE_Suppress, false, false, 2)
DIAG(warn_unsupported_target_attribute, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{unsupported|duplicate}0%select{| architecture}1 '%2' in the 'target' attribute string; 'target' attribute ignored", 317, SFINAE_Suppress, false, false, 2)
DIAG(warn_unused_call, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring return value of function declared with %0 attribute", 803, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_comparison, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{equality|inequality|relational|three-way}0 comparison result unused", 787, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_const_variable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused variable %0", 788, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_constructor, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring temporary created by a constructor declared with %0 attribute", 803, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_constructor_msg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring temporary created by a constructor declared with %0 attribute: %1", 803, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_container_subscript_expr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "container access result unused - container access should not be used for side effects", 803, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_exception_param, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused exception parameter %0", 789, SFINAE_Suppress, false, false, 2)
DIAG(warn_unused_expr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expression result unused", 803, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_function, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused function %0", 790, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_label, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused label %0", 792, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_lambda_capture, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "lambda capture %0 is not %select{used|required to be captured for this use}1", 793, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_local_typedef, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused %select{typedef|type alias}0 %1", 794, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_member_function, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused member function %0", 797, SFINAE_Suppress, false, false, 2)
DIAG(warn_unused_parameter, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused parameter %0", 798, SFINAE_Suppress, false, false, 2)
DIAG(warn_unused_private_field, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "private field %0 is not used", 799, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_property_backing_ivar, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "ivar %0 which backs the property is not referenced in this property's accessor", 800, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_property_expr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property access result unused - getters should not be used for side effects", 791, SFINAE_Suppress, false, false, 2)
DIAG(warn_unused_result, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring return value of function declared with %0 attribute", 801, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_result_msg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring return value of function declared with %0 attribute: %1", 801, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_template, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused %select{function|variable}0 template %1", 802, SFINAE_Suppress, false, false, 2)
DIAG(warn_unused_variable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unused variable %0", 804, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_voidptr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expression result unused; should this cast be to 'void'?", 803, SFINAE_Suppress, false, false, 34)
DIAG(warn_unused_volatile, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expression result unused; assign into a variable to force a volatile load", 805, SFINAE_Suppress, false, false, 2)
DIAG(warn_use_in_invalid_state, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "invalid invocation of method '%0' on object '%1' while it is in the '%2' state", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_use_of_temp_in_invalid_state, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "invalid invocation of method '%0' on a temporary object while it is in the '%1' state", 150, SFINAE_Suppress, false, false, 2)
DIAG(warn_used_but_marked_unused, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 was marked unused but was used", 806, SFINAE_Suppress, false, false, 2)
DIAG(warn_user_literal_reserved, CLASS_WARNING, (unsigned)diag::Severity::Warning, "user-defined literal suffixes not starting with '_' are reserved%select{; no literal will invoke this operator|}0", 807, SFINAE_Suppress, false, false, 2)
DIAG(warn_using_directive_in_header, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "using namespace directive in global context in header", 314, SFINAE_Suppress, false, false, 2)
DIAG(warn_va_start_type_is_undefined, CLASS_WARNING, (unsigned)diag::Severity::Warning, "passing %select{an object that undergoes default argument promotion|an object of reference type|a parameter declared with the 'register' keyword}0 to 'va_start' has undefined behavior", 809, SFINAE_Suppress, false, false, 2)
DIAG(warn_var_deref_requires_any_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{reading|writing}1 the value pointed to by %0 requires holding %select{any mutex|any mutex exclusively}1", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_var_deref_requires_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{reading|writing}3 the value pointed to by %1 requires holding %0 %select{'%2'|'%2' exclusively}3", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_var_deref_requires_lock_precise, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{reading|writing}3 the value pointed to by %1 requires holding %0 %select{'%2'|'%2' exclusively}3", 730, SFINAE_Suppress, false, false, 2)
DIAG(warn_var_template_missing, CLASS_WARNING, (unsigned)diag::Severity::Warning, "instantiation of variable %q0 required here, but no definition is available", 748, SFINAE_Suppress, false, false, 2)
DIAG(warn_variable_requires_any_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{reading|writing}1 variable %0 requires holding %select{any mutex|any mutex exclusively}1", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_variable_requires_lock, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{reading|writing}3 variable %1 requires holding %0 %select{'%2'|'%2' exclusively}3", 726, SFINAE_Suppress, false, false, 2)
DIAG(warn_variable_requires_lock_precise, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{reading|writing}3 variable %1 requires holding %0 %select{'%2'|'%2' exclusively}3", 730, SFINAE_Suppress, false, false, 2)
DIAG(warn_variable_sized_ivar_visibility, CLASS_WARNING, (unsigned)diag::Severity::Warning, "field %0 with variable sized type %1 is not visible to subclasses and can conflict with their instance variables", 515, SFINAE_Suppress, false, false, 2)
DIAG(warn_variables_not_in_loop_body, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable%select{s| %1|s %1 and %2|s %1, %2, and %3|s %1, %2, %3, and %4}0 used in loop condition not modified in loop body", 264, SFINAE_Suppress, false, false, 2)
DIAG(warn_vbase_moved_multiple_times, CLASS_WARNING, (unsigned)diag::Severity::Warning, "defaulted move assignment operator of %0 will move assign virtual base class %1 multiple times", 475, SFINAE_Suppress, false, false, 2)
DIAG(warn_vector_long_decl_spec_combination, CLASS_WARNING, (unsigned)diag::Severity::Warning, "Use of 'long' with '__vector' is deprecated", 179, SFINAE_Suppress, false, false, 29)
DIAG(warn_vector_mode_deprecated, CLASS_WARNING, (unsigned)diag::Severity::Warning, "specifying vector types with the 'mode' attribute is deprecated; use the 'vector_size' attribute instead", 182, SFINAE_Suppress, false, false, 29)
DIAG(warn_vla_used, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "variable length array used", 816, SFINAE_Suppress, false, false, 2)
DIAG(warn_weak_identifier_undeclared, CLASS_WARNING, (unsigned)diag::Severity::Warning, "weak identifier %0 never declared", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_weak_import, CLASS_WARNING, (unsigned)diag::Severity::Warning, "an already-declared variable is made a weak_import declaration %0", 0, SFINAE_Suppress, false, false, 2)
DIAG(warn_weak_template_vtable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "explicit template instantiation %0 will emit a vtable in every translation unit", 820, SFINAE_Suppress, false, false, 2)
DIAG(warn_weak_vtable, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%0 has no out-of-line virtual method definitions; its vtable will be emitted in every translation unit", 821, SFINAE_Suppress, false, false, 2)
DIAG(warn_wrong_absolute_value_type, CLASS_WARNING, (unsigned)diag::Severity::Warning, "using %select{integer|floating point|complex}1 absolute value function %0 when argument is of %select{integer|floating point|complex}2 type", 8, SFINAE_Suppress, false, false, 2)
DIAG(warn_xor_used_as_pow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "result of '%0' is %1; did you mean exponentiation?", 824, SFINAE_Suppress, false, false, 2)
DIAG(warn_xor_used_as_pow_base, CLASS_WARNING, (unsigned)diag::Severity::Warning, "result of '%0' is %1; did you mean '%2'?", 824, SFINAE_Suppress, false, false, 2)
DIAG(warn_xor_used_as_pow_base_extra, CLASS_WARNING, (unsigned)diag::Severity::Warning, "result of '%0' is %1; did you mean '%2' (%3)?", 824, SFINAE_Suppress, false, false, 2)
DIAG(warn_zero_as_null_pointer_constant, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "zero as null pointer constant", 825, SFINAE_Suppress, false, false, 21)
DIAG(warn_zero_size_struct_union_compat, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{|empty }0%select{struct|union}1 has size 0 in C, %select{size 1|non-zero size}2 in C++", 78, SFINAE_Suppress, false, false, 2)
DIAG(warn_zero_size_struct_union_in_extern_c, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{|empty }0%select{struct|union}1 has size 0 in C, %select{size 1|non-zero size}2 in C++", 248, SFINAE_Suppress, false, false, 2)
