'''OpenGL extension AMD.transform_feedback3_lines_triangles

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.transform_feedback3_lines_triangles to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL 4.0 introduced the ability to record primitives into multiple output
	streams using transform feedback. However, the restriction that all streams
	must output POINT primitives when more than one output stream is active was
	also introduced. This extension simply removes that restriction, allowing
	the same set of primitives to be used with multiple transform feedback
	streams as with a single stream.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/transform_feedback3_lines_triangles.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.transform_feedback3_lines_triangles import *
from OpenGL.raw.GL.AMD.transform_feedback3_lines_triangles import _EXTENSION_NAME

def glInitTransformFeedback3LinesTrianglesAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION