function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from "prop-types";
import { EuiBasicTable } from './basic_table';
import { defaults as paginationBarDefaults } from './pagination_bar';
import { isString } from '../../services/predicate';
import { Comparators } from '../../services/sort';
import { EuiSearchBar } from '../search_bar';
import { EuiSpacer } from '../spacer';

function isEuiSearchBarProps(x) {
  return typeof x !== 'boolean';
}

var getQueryFromSearch = function getQueryFromSearch(search, defaultQuery) {
  var query;

  if (!search) {
    query = '';
  } else {
    query = (defaultQuery ? search.defaultQuery || search.query || '' : search.query) || '';
  }

  return isString(query) ? EuiSearchBar.Query.parse(query) : query;
};

var getInitialPagination = function getInitialPagination(pagination) {
  if (!pagination) {
    return {
      pageIndex: undefined,
      pageSize: undefined
    };
  }

  var _ref = pagination,
      _ref$initialPageIndex = _ref.initialPageIndex,
      initialPageIndex = _ref$initialPageIndex === void 0 ? 0 : _ref$initialPageIndex,
      initialPageSize = _ref.initialPageSize,
      _ref$pageSizeOptions = _ref.pageSizeOptions,
      pageSizeOptions = _ref$pageSizeOptions === void 0 ? paginationBarDefaults.pageSizeOptions : _ref$pageSizeOptions,
      hidePerPageOptions = _ref.hidePerPageOptions;

  if (!hidePerPageOptions && initialPageSize && (!pageSizeOptions || !pageSizeOptions.includes(initialPageSize))) {
    throw new Error("EuiInMemoryTable received initialPageSize ".concat(initialPageSize, ", which wasn't provided within pageSizeOptions."));
  }

  var defaultPageSize = pageSizeOptions ? pageSizeOptions[0] : paginationBarDefaults.pageSizeOptions[0];
  return {
    pageIndex: initialPageIndex,
    pageSize: initialPageSize || defaultPageSize,
    pageSizeOptions: pageSizeOptions,
    hidePerPageOptions: hidePerPageOptions
  };
};

function findColumnByProp(columns, prop, value) {
  for (var i = 0; i < columns.length; i++) {
    var column = columns[i];

    if (column[prop] === value) {
      return column;
    }
  }
}

function getInitialSorting(columns, sorting) {
  if (!sorting || !sorting.sort) {
    return {
      sortName: undefined,
      sortDirection: undefined
    };
  }

  var _sort = sorting.sort,
      sortable = _sort.field,
      sortDirection = _sort.direction; // sortable could be a column's `field` or its `name`
  // for backwards compatibility `field` must be checked first

  var sortColumn = findColumnByProp(columns, 'field', sortable);

  if (sortColumn == null) {
    sortColumn = findColumnByProp(columns, 'name', sortable);
  }

  if (sortColumn == null) {
    return {
      sortName: undefined,
      sortDirection: undefined
    };
  }

  var sortName = sortColumn.name;
  return {
    sortName: sortName,
    sortDirection: sortDirection
  };
}

export var EuiInMemoryTable =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiInMemoryTable, _Component);

  _createClass(EuiInMemoryTable, null, [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var updatedPrevState = prevState;
      var componentShouldUpdate = false;

      if (nextProps.items !== prevState.prevProps.items) {
        // We have new items because an external search has completed, so reset pagination state.
        componentShouldUpdate = true;
        updatedPrevState = _objectSpread({}, updatedPrevState, {
          prevProps: _objectSpread({}, updatedPrevState.prevProps, {
            items: nextProps.items
          }),
          pageIndex: 0
        });
      }

      var _getInitialSorting = getInitialSorting(nextProps.columns, nextProps.sorting),
          sortName = _getInitialSorting.sortName,
          sortDirection = _getInitialSorting.sortDirection;

      if (sortName !== prevState.prevProps.sortName || sortDirection !== prevState.prevProps.sortDirection) {
        componentShouldUpdate = true;
        updatedPrevState = _objectSpread({}, updatedPrevState, {
          sortName: sortName,
          sortDirection: sortDirection
        });
      }

      var nextQuery = nextProps.search ? nextProps.search.query : '';
      var prevQuery = prevState.prevProps.search ? prevState.prevProps.search.query : '';

      if (nextQuery !== prevQuery) {
        componentShouldUpdate = true;
        updatedPrevState = _objectSpread({}, updatedPrevState, {
          prevProps: _objectSpread({}, updatedPrevState.prevProps, {
            search: nextProps.search
          }),
          query: getQueryFromSearch(nextProps.search, false)
        });
      }

      if (componentShouldUpdate) {
        return updatedPrevState;
      }

      return null;
    }
  }]);

  function EuiInMemoryTable(props) {
    var _this;

    _classCallCheck(this, EuiInMemoryTable);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EuiInMemoryTable).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "tableRef", void 0);

    _defineProperty(_assertThisInitialized(_this), "onTableChange", function (_ref2) {
      var page = _ref2.page,
          sort = _ref2.sort;

      var _ref3 = page || {},
          pageIndex = _ref3.index,
          pageSize = _ref3.size;

      var _ref4 = sort || {},
          sortName = _ref4.field,
          sortDirection = _ref4.direction; // To keep backwards compatibility reportedSortName needs to be tracked separately
      // from sortName; sortName gets stored internally while reportedSortName is sent to the callback


      var reportedSortName = sortName; // EuiBasicTable returns the column's `field` if it exists instead of `name`,
      // map back to `name` if this is the case

      for (var i = 0; i < _this.props.columns.length; i++) {
        var column = _this.props.columns[i];

        if (column.field === sortName) {
          sortName = column.name;
          break;
        }
      } // Allow going back to 'neutral' sorting


      if (_this.state.allowNeutralSort && _this.state.sortName === sortName && _this.state.sortDirection === 'desc' && sortDirection === 'asc') {
        sortName = '';
        reportedSortName = '';
        sortDirection = 'asc'; // Default sort direction.
      }

      if (_this.props.onTableChange) {
        _this.props.onTableChange({
          // @ts-ignore complex relationship between pagination's existance and criteria, the code logic ensures this is correctly maintained
          page: page,
          sort: {
            field: reportedSortName,
            direction: sortDirection
          }
        });
      }

      _this.setState({
        pageIndex: pageIndex,
        pageSize: pageSize,
        sortName: sortName,
        sortDirection: sortDirection
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onQueryChange", function (_ref5) {
      var query = _ref5.query,
          queryText = _ref5.queryText,
          error = _ref5.error;
      var search = _this.props.search;

      if (isEuiSearchBarProps(search)) {
        if (search.onChange) {
          var shouldQueryInMemory = error == null ? search.onChange({
            query: query,
            queryText: queryText,
            error: null
          }) : search.onChange({
            query: null,
            queryText: queryText,
            error: error
          });

          if (!shouldQueryInMemory) {
            return;
          }
        }
      } // Reset pagination state.


      _this.setState(function (state) {
        return {
          prevProps: _objectSpread({}, state.prevProps, {
            search: search
          }),
          query: query,
          pageIndex: 0
        };
      });
    });

    var columns = props.columns,
        _search = props.search,
        pagination = props.pagination,
        sorting = props.sorting,
        allowNeutralSort = props.allowNeutralSort;

    var _getInitialPagination = getInitialPagination(pagination),
        _pageIndex = _getInitialPagination.pageIndex,
        _pageSize = _getInitialPagination.pageSize,
        pageSizeOptions = _getInitialPagination.pageSizeOptions,
        hidePerPageOptions = _getInitialPagination.hidePerPageOptions;

    var _getInitialSorting2 = getInitialSorting(columns, sorting),
        _sortName = _getInitialSorting2.sortName,
        _sortDirection = _getInitialSorting2.sortDirection;

    _this.state = {
      prevProps: {
        items: props.items,
        sortName: _sortName,
        sortDirection: _sortDirection,
        search: _search
      },
      search: _search,
      query: getQueryFromSearch(_search, true),
      pageIndex: _pageIndex || 0,
      pageSize: _pageSize,
      pageSizeOptions: pageSizeOptions,
      sortName: _sortName,
      sortDirection: _sortDirection,
      allowNeutralSort: allowNeutralSort !== false,
      hidePerPageOptions: hidePerPageOptions
    };
    _this.tableRef = React.createRef();
    return _this;
  }

  _createClass(EuiInMemoryTable, [{
    key: "setSelection",
    value: function setSelection(newSelection) {
      if (this.tableRef.current) {
        this.tableRef.current.setSelection(newSelection);
      }
    }
  }, {
    key: "renderSearchBar",
    value: function renderSearchBar() {
      var search = this.props.search;

      if (search) {
        var searchBarProps = {};

        if (isEuiSearchBarProps(search)) {
          var onChange = search.onChange,
              _searchBarProps = _objectWithoutProperties(search, ["onChange"]);

          searchBarProps = _searchBarProps;

          if (searchBarProps.box && searchBarProps.box.schema === true) {
            searchBarProps.box = _objectSpread({}, searchBarProps.box, {
              schema: this.resolveSearchSchema()
            });
          }
        }

        return React.createElement(EuiSearchBar, _extends({
          onChange: this.onQueryChange
        }, searchBarProps));
      }
    }
  }, {
    key: "resolveSearchSchema",
    value: function resolveSearchSchema() {
      var columns = this.props.columns;
      return columns.reduce(function (schema, column) {
        var _ref6 = column,
            field = _ref6.field,
            dataType = _ref6.dataType;

        if (field) {
          var type = dataType || 'string';
          schema.fields[field] = {
            type: type
          };
        }

        return schema;
      }, {
        strict: true,
        fields: {}
      });
    }
  }, {
    key: "getItemSorter",
    value: function getItemSorter() {
      var _this$state = this.state,
          sortName = _this$state.sortName,
          sortDirection = _this$state.sortDirection;
      var columns = this.props.columns;
      var sortColumn = columns.find(function (_ref7) {
        var name = _ref7.name;
        return name === sortName;
      });

      if (sortColumn == null) {
        // can't return a non-function so return a function that says everything is the same
        return function () {
          return 0;
        };
      }

      var sortable = sortColumn.sortable;

      if (typeof sortable === 'function') {
        return Comparators.value(sortable, Comparators.default(sortDirection));
      }

      return Comparators.property(sortColumn.field, Comparators.default(sortDirection));
    }
  }, {
    key: "getItems",
    value: function getItems() {
      var executeQueryOptions = this.props.executeQueryOptions;
      var items = this.state.prevProps.items;

      if (!items.length) {
        return {
          items: [],
          totalItemCount: 0
        };
      }

      var _this$state2 = this.state,
          query = _this$state2.query,
          sortName = _this$state2.sortName,
          pageIndex = _this$state2.pageIndex,
          pageSize = _this$state2.pageSize;
      var matchingItems = query ? EuiSearchBar.Query.execute(query, items, executeQueryOptions) : items;
      var sortedItems = sortName ? matchingItems.slice(0) // avoid mutating the source array
      .sort(this.getItemSorter()) // sort, causes mutation
      : matchingItems;
      var visibleItems = pageSize ? function () {
        var startIndex = pageIndex * pageSize;
        return sortedItems.slice(startIndex, Math.min(startIndex + pageSize, sortedItems.length));
      }() : sortedItems;
      return {
        items: visibleItems,
        totalItemCount: matchingItems.length
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          columns = _this$props.columns,
          loading = _this$props.loading,
          message = _this$props.message,
          error = _this$props.error,
          selection = _this$props.selection,
          isSelectable = _this$props.isSelectable,
          hasActions = _this$props.hasActions,
          compressed = _this$props.compressed,
          hasPagination = _this$props.pagination,
          hasSorting = _this$props.sorting,
          itemIdToExpandedRowMap = _this$props.itemIdToExpandedRowMap,
          itemId = _this$props.itemId,
          rowProps = _this$props.rowProps,
          cellProps = _this$props.cellProps,
          tableLayout = _this$props.tableLayout,
          _unuseditems = _this$props.items,
          search = _this$props.search,
          onTableChange = _this$props.onTableChange,
          executeQueryOptions = _this$props.executeQueryOptions,
          allowNeutralSort = _this$props.allowNeutralSort,
          rest = _objectWithoutProperties(_this$props, ["columns", "loading", "message", "error", "selection", "isSelectable", "hasActions", "compressed", "pagination", "sorting", "itemIdToExpandedRowMap", "itemId", "rowProps", "cellProps", "tableLayout", "items", "search", "onTableChange", "executeQueryOptions", "allowNeutralSort"]);

      var _this$state3 = this.state,
          pageIndex = _this$state3.pageIndex,
          pageSize = _this$state3.pageSize,
          pageSizeOptions = _this$state3.pageSizeOptions,
          sortName = _this$state3.sortName,
          sortDirection = _this$state3.sortDirection,
          hidePerPageOptions = _this$state3.hidePerPageOptions;

      var _this$getItems = this.getItems(),
          items = _this$getItems.items,
          totalItemCount = _this$getItems.totalItemCount;

      var pagination = !hasPagination ? undefined : {
        pageIndex: pageIndex,
        pageSize: pageSize || 1,
        pageSizeOptions: pageSizeOptions,
        totalItemCount: totalItemCount,
        hidePerPageOptions: hidePerPageOptions
      }; // Data loaded from a server can have a default sort order which is meaningful to the
      // user, but can't be reproduced with client-side sort logic. So we allow the table to display
      // rows in the order in which they're initially loaded by providing an undefined sorting prop.

      var sorting = !hasSorting ? undefined : {
        sort: !sortName && !sortDirection ? undefined : {
          field: sortName,
          direction: sortDirection
        },
        allowNeutralSort: this.state.allowNeutralSort
      };
      var searchBar = this.renderSearchBar();
      var table = // @ts-ignore complex relationship between pagination's existance and criteria, the code logic ensures this is correctly maintained
      React.createElement(EuiBasicTable, _extends({
        ref: this.tableRef,
        items: items,
        itemId: itemId,
        rowProps: rowProps,
        cellProps: cellProps,
        columns: columns,
        pagination: pagination,
        sorting: sorting,
        selection: selection,
        isSelectable: isSelectable,
        hasActions: hasActions,
        onChange: this.onTableChange,
        error: error,
        loading: loading,
        noItemsMessage: message,
        tableLayout: tableLayout,
        compressed: compressed,
        itemIdToExpandedRowMap: itemIdToExpandedRowMap
      }, rest));

      if (!searchBar) {
        return table;
      }

      return React.createElement("div", null, searchBar, React.createElement(EuiSpacer, {
        size: "l"
      }), table);
    }
  }]);

  return EuiInMemoryTable;
}(Component);

_defineProperty(EuiInMemoryTable, "defaultProps", {
  responsive: true,
  tableLayout: 'fixed'
});

EuiInMemoryTable.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  itemId: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.func.isRequired]),
  itemIdToExpandedRowMap: PropTypes.shape({}),
  items: PropTypes.arrayOf(PropTypes.any.isRequired),
  cellProps: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.func.isRequired]),
  columns: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
    field: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.string.isRequired]).isRequired,
    // supports outer.inner key paths
    name: PropTypes.node.isRequired,
    description: PropTypes.string,
    dataType: PropTypes.oneOf(["auto", "string", "number", "boolean", "date"]),
    width: PropTypes.string,
    sortable: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.func.isRequired]),
    isExpander: PropTypes.bool,
    textOnly: PropTypes.bool,
    align: PropTypes.oneOf(["left", "right", "center"]),
    truncateText: PropTypes.bool,
    isMobileHeader: PropTypes.bool,
    mobileOptions: PropTypes.shape({
      show: PropTypes.bool,
      only: PropTypes.bool,
      render: PropTypes.func,
      header: PropTypes.bool
    }),
    hideForMobile: PropTypes.bool,
    render: PropTypes.func,
    footer: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired, PropTypes.func.isRequired]),
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }).isRequired, PropTypes.shape({
    render: PropTypes.func.isRequired,
    name: PropTypes.node,
    description: PropTypes.string,
    sortable: PropTypes.func,
    width: PropTypes.string,
    truncateText: PropTypes.bool,
    isExpander: PropTypes.bool,
    align: PropTypes.oneOf(["left", "right", "center"]),
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }).isRequired, PropTypes.shape({
    actions: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
      type: PropTypes.oneOfType([PropTypes.oneOf(["button"]), PropTypes.oneOf(["icon"]).isRequired]),
      color: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.oneOf(["primary", "danger", "disabled", "text", "ghost"]).isRequired, PropTypes.func.isRequired]), PropTypes.oneOfType([PropTypes.oneOf(["danger", "disabled", "ghost", "primary", "subdued", "success", "text", "warning"]).isRequired, PropTypes.func.isRequired])]),
      name: PropTypes.node.isRequired,
      description: PropTypes.string.isRequired,
      onClick: PropTypes.func,
      href: PropTypes.string,
      target: PropTypes.string,
      available: PropTypes.func,
      enabled: PropTypes.func,
      isPrimary: PropTypes.bool,
      "data-test-subj": PropTypes.string,
      icon: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.func.isRequired])
    }).isRequired, PropTypes.shape({
      render: PropTypes.func.isRequired,
      available: PropTypes.func,
      enabled: PropTypes.func,
      isPrimary: PropTypes.bool
    }).isRequired]).isRequired).isRequired,
    name: PropTypes.node,
    description: PropTypes.string,
    width: PropTypes.string
  }).isRequired]).isRequired),
  error: PropTypes.string,
  tableCaption: PropTypes.string,
  rowHeader: PropTypes.string,
  hasActions: PropTypes.bool,
  isExpandable: PropTypes.bool,
  isSelectable: PropTypes.bool,
  loading: PropTypes.bool,
  onChange: PropTypes.func,
  rowProps: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.func.isRequired]),
  selection: PropTypes.shape({
    onSelectionChange: PropTypes.func,
    selectable: PropTypes.func,
    selectableMessage: PropTypes.func,
    initialSelected: PropTypes.arrayOf(PropTypes.any.isRequired)
  }),
  message: PropTypes.node,
  search: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    onChange: PropTypes.func,

    /**
       The initial query the bar will hold when first mounted
       */
    defaultQuery: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.string.isRequired]),

    /**
       If you wish to use the search bar as a controlled component, continuously pass the query
       via this prop
       */
    query: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.string.isRequired]),

    /**
       Configures the search box. Set `placeholder` to change the placeholder text in the box and
       `incremental` to support incremental (as you type) search.
       */
    box: PropTypes.shape({
      name: PropTypes.string,
      id: PropTypes.string,
      placeholder: PropTypes.string,
      value: PropTypes.string,
      isInvalid: PropTypes.bool,
      fullWidth: PropTypes.bool,
      isLoading: PropTypes.bool,

      /**
         * Called when the user presses [Enter] OR on change if the incremental prop is `true`.
         * If you don't need the on[Enter] functionality, prefer using onChange
         */
      onSearch: PropTypes.func,

      /**
         * When `true` the search will be executed (that is, the `onSearch` will be called) as the
         * user types.
         */
      incremental: PropTypes.bool,

      /**
         * when `true` creates a shorter height input
         */
      compressed: PropTypes.bool,
      inputRef: PropTypes.func,

      /**
         * Shows a button that quickly clears any input
         */
      isClearable: PropTypes.bool,

      /**
         * Creates an input group with element(s) coming before input
         * `string` | `ReactElement` or an array of these
         */
      prepend: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),

      /**
         * Creates an input group with element(s) coming after input.
         * `string` | `ReactElement` or an array of these
         */
      append: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      // Boolean values are not meaningful to this EuiSearchBox, but are allowed so that other
      // components can use e.g. a true value to mean "auto-derive a schema". See EuiInMemoryTable.
      // Admittedly, this is a bit of a hack.
      schema: PropTypes.oneOfType([PropTypes.shape({
        strict: PropTypes.bool,
        fields: PropTypes.any,
        flags: PropTypes.arrayOf(PropTypes.string.isRequired)
      }).isRequired, PropTypes.bool.isRequired])
    }),

    /**
       An array of search filters.
       */
    filters: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
      type: PropTypes.oneOf(["is"]).isRequired,
      field: PropTypes.string.isRequired,
      name: PropTypes.string.isRequired,
      negatedName: PropTypes.string,
      available: PropTypes.func
    }).isRequired, PropTypes.shape({
      type: PropTypes.oneOf(["field_value_selection"]).isRequired,
      field: PropTypes.string,
      name: PropTypes.string.isRequired,
      options: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.shape({
        field: PropTypes.string,
        value: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.bool.isRequired, PropTypes.shape({
          type: PropTypes.oneOf(["date"]).isRequired,
          raw: PropTypes.any.isRequired,
          granularity: PropTypes.oneOfType([PropTypes.shape({
            es: PropTypes.oneOf(["d", "w", "M", "y"]).isRequired,
            js: PropTypes.oneOf(["day", "week", "month", "year"]).isRequired,
            isSame: PropTypes.func.isRequired,
            start: PropTypes.func.isRequired,
            startOfNext: PropTypes.func.isRequired,
            iso8601: PropTypes.func.isRequired
          }).isRequired, PropTypes.oneOf([undefined])]).isRequired,
          text: PropTypes.string.isRequired,
          resolve: PropTypes.func.isRequired
        }).isRequired]).isRequired,
        name: PropTypes.string,
        view: PropTypes.node
      }).isRequired).isRequired, PropTypes.func.isRequired]).isRequired,
      filterWith: PropTypes.oneOfType([PropTypes.oneOf(["prefix", "includes"]), PropTypes.func.isRequired]),
      cache: PropTypes.number,
      multiSelect: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["and", "or"])]),
      loadingMessage: PropTypes.string,
      noOptionsMessage: PropTypes.string,
      searchThreshold: PropTypes.number,
      available: PropTypes.func,
      autoClose: PropTypes.bool
    }).isRequired, PropTypes.shape({
      type: PropTypes.oneOf(["field_value_toggle"]).isRequired,
      field: PropTypes.string.isRequired,
      value: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.bool.isRequired, PropTypes.shape({
        type: PropTypes.oneOf(["date"]).isRequired,
        raw: PropTypes.any.isRequired,
        granularity: PropTypes.oneOfType([PropTypes.shape({
          es: PropTypes.oneOf(["d", "w", "M", "y"]).isRequired,
          js: PropTypes.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: PropTypes.func.isRequired,
          start: PropTypes.func.isRequired,
          startOfNext: PropTypes.func.isRequired,
          iso8601: PropTypes.func.isRequired
        }).isRequired, PropTypes.oneOf([undefined])]).isRequired,
        text: PropTypes.string.isRequired,
        resolve: PropTypes.func.isRequired
      }).isRequired]).isRequired,
      name: PropTypes.string.isRequired,
      negatedName: PropTypes.string,
      available: PropTypes.func,
      operator: PropTypes.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
    }).isRequired, PropTypes.shape({
      type: PropTypes.oneOf(["field_value_toggle_group"]).isRequired,
      field: PropTypes.string.isRequired,
      items: PropTypes.arrayOf(PropTypes.shape({
        value: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.bool.isRequired]).isRequired,
        name: PropTypes.string.isRequired,
        negatedName: PropTypes.string,
        operator: PropTypes.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
      }).isRequired).isRequired,
      available: PropTypes.func
    }).isRequired]).isRequired),

    /**
       * Tools which go to the left of the search bar.
       */
    toolsLeft: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.arrayOf(PropTypes.element.isRequired).isRequired]),

    /**
       * Tools which go to the right of the search bar.
       */
    toolsRight: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.arrayOf(PropTypes.element.isRequired).isRequired]),

    /**
       * Date formatter to use when parsing date values
       */
    dateFormat: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }).isRequired]),
  pagination: PropTypes.oneOfType([PropTypes.oneOf([undefined]), PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    initialPageIndex: PropTypes.number,
    initialPageSize: PropTypes.number,
    pageSizeOptions: PropTypes.arrayOf(PropTypes.number.isRequired),
    hidePerPageOptions: PropTypes.bool
  }).isRequired])]),
  sorting: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    sort: PropTypes.shape({
      field: PropTypes.string.isRequired,
      direction: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]).isRequired
    }).isRequired
  }).isRequired]),

  /**
     * Set `allowNeutralSort` to false to force column sorting. Defaults to true.
     */

  /**
     * Set `allowNeutralSort` to false to force column sorting. Defaults to true.
     */
  allowNeutralSort: PropTypes.bool,
  onTableChange: PropTypes.func,
  executeQueryOptions: PropTypes.shape({
    defaultFields: PropTypes.arrayOf(PropTypes.string.isRequired),
    isClauseMatcher: PropTypes.func,
    explain: PropTypes.bool
  })
};
EuiInMemoryTable.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "setSelection",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "newSelection",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onTableChange",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "{\n  page,\n  sort\n}",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onQueryChange",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "{\n  query,\n  queryText,\n  error\n}",
      "type": null
    }],
    "returns": null
  }, {
    "name": "renderSearchBar",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "resolveSearchSchema",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "getItemSorter",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "getItems",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }],
  "displayName": "EuiInMemoryTable",
  "props": {
    "responsive": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "required": false
    },
    "tableLayout": {
      "defaultValue": {
        "value": "'fixed'",
        "computed": false
      },
      "required": false
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "itemId": {
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "number"
        }, {
          "name": "func"
        }]
      },
      "required": false,
      "description": ""
    },
    "itemIdToExpandedRowMap": {
      "type": {
        "name": "shape",
        "value": {}
      },
      "required": false,
      "description": ""
    },
    "items": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "any"
        }
      },
      "required": false,
      "description": ""
    },
    "cellProps": {
      "type": {
        "name": "union",
        "value": [{
          "name": "any"
        }, {
          "name": "func"
        }]
      },
      "required": false,
      "description": ""
    },
    "columns": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "union",
          "value": [{
            "name": "shape",
            "value": {
              "field": {
                "name": "union",
                "value": [{
                  "name": "any"
                }, {
                  "name": "string"
                }],
                "required": true
              },
              "name": {
                "name": "node",
                "required": true
              },
              "description": {
                "name": "string",
                "required": false
              },
              "dataType": {
                "name": "enum",
                "value": [{
                  "value": "\"auto\"",
                  "computed": false
                }, {
                  "value": "\"string\"",
                  "computed": false
                }, {
                  "value": "\"number\"",
                  "computed": false
                }, {
                  "value": "\"boolean\"",
                  "computed": false
                }, {
                  "value": "\"date\"",
                  "computed": false
                }],
                "required": false
              },
              "width": {
                "name": "string",
                "required": false
              },
              "sortable": {
                "name": "union",
                "value": [{
                  "name": "bool"
                }, {
                  "name": "func"
                }],
                "required": false
              },
              "isExpander": {
                "name": "bool",
                "required": false
              },
              "textOnly": {
                "name": "bool",
                "required": false
              },
              "align": {
                "name": "enum",
                "value": [{
                  "value": "\"left\"",
                  "computed": false
                }, {
                  "value": "\"right\"",
                  "computed": false
                }, {
                  "value": "\"center\"",
                  "computed": false
                }],
                "required": false
              },
              "truncateText": {
                "name": "bool",
                "required": false
              },
              "isMobileHeader": {
                "name": "bool",
                "required": false
              },
              "mobileOptions": {
                "name": "shape",
                "value": {
                  "show": {
                    "name": "bool",
                    "required": false
                  },
                  "only": {
                    "name": "bool",
                    "required": false
                  },
                  "render": {
                    "name": "func",
                    "required": false
                  },
                  "header": {
                    "name": "bool",
                    "required": false
                  }
                },
                "required": false
              },
              "hideForMobile": {
                "name": "bool",
                "required": false
              },
              "render": {
                "name": "func",
                "required": false
              },
              "footer": {
                "name": "union",
                "value": [{
                  "name": "string"
                }, {
                  "name": "element"
                }, {
                  "name": "func"
                }],
                "required": false
              },
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              }
            }
          }, {
            "name": "shape",
            "value": {
              "render": {
                "name": "func",
                "required": true
              },
              "name": {
                "name": "node",
                "required": false
              },
              "description": {
                "name": "string",
                "required": false
              },
              "sortable": {
                "name": "func",
                "required": false
              },
              "width": {
                "name": "string",
                "required": false
              },
              "truncateText": {
                "name": "bool",
                "required": false
              },
              "isExpander": {
                "name": "bool",
                "required": false
              },
              "align": {
                "name": "enum",
                "value": [{
                  "value": "\"left\"",
                  "computed": false
                }, {
                  "value": "\"right\"",
                  "computed": false
                }, {
                  "value": "\"center\"",
                  "computed": false
                }],
                "required": false
              },
              "className": {
                "name": "string",
                "required": false
              },
              "aria-label": {
                "name": "string",
                "required": false
              },
              "data-test-subj": {
                "name": "string",
                "required": false
              }
            }
          }, {
            "name": "shape",
            "value": {
              "actions": {
                "name": "arrayOf",
                "value": {
                  "name": "union",
                  "value": [{
                    "name": "shape",
                    "value": {
                      "type": {
                        "name": "union",
                        "value": [{
                          "name": "enum",
                          "value": [{
                            "value": "\"button\"",
                            "computed": false
                          }]
                        }, {
                          "name": "enum",
                          "value": [{
                            "value": "\"icon\"",
                            "computed": false
                          }]
                        }],
                        "required": false
                      },
                      "color": {
                        "name": "union",
                        "value": [{
                          "name": "union",
                          "value": [{
                            "name": "enum",
                            "value": [{
                              "value": "\"primary\"",
                              "computed": false
                            }, {
                              "value": "\"danger\"",
                              "computed": false
                            }, {
                              "value": "\"disabled\"",
                              "computed": false
                            }, {
                              "value": "\"text\"",
                              "computed": false
                            }, {
                              "value": "\"ghost\"",
                              "computed": false
                            }]
                          }, {
                            "name": "func"
                          }]
                        }, {
                          "name": "union",
                          "value": [{
                            "name": "enum",
                            "value": [{
                              "value": "\"danger\"",
                              "computed": false
                            }, {
                              "value": "\"disabled\"",
                              "computed": false
                            }, {
                              "value": "\"ghost\"",
                              "computed": false
                            }, {
                              "value": "\"primary\"",
                              "computed": false
                            }, {
                              "value": "\"subdued\"",
                              "computed": false
                            }, {
                              "value": "\"success\"",
                              "computed": false
                            }, {
                              "value": "\"text\"",
                              "computed": false
                            }, {
                              "value": "\"warning\"",
                              "computed": false
                            }]
                          }, {
                            "name": "func"
                          }]
                        }],
                        "required": false
                      },
                      "name": {
                        "name": "node",
                        "required": true
                      },
                      "description": {
                        "name": "string",
                        "required": true
                      },
                      "onClick": {
                        "name": "func",
                        "required": false
                      },
                      "href": {
                        "name": "string",
                        "required": false
                      },
                      "target": {
                        "name": "string",
                        "required": false
                      },
                      "available": {
                        "name": "func",
                        "required": false
                      },
                      "enabled": {
                        "name": "func",
                        "required": false
                      },
                      "isPrimary": {
                        "name": "bool",
                        "required": false
                      },
                      "data-test-subj": {
                        "name": "string",
                        "required": false
                      },
                      "icon": {
                        "name": "union",
                        "value": [{
                          "name": "enum",
                          "value": [{
                            "value": "\"accessibility\"",
                            "computed": false
                          }, {
                            "value": "\"addDataApp\"",
                            "computed": false
                          }, {
                            "value": "\"advancedSettingsApp\"",
                            "computed": false
                          }, {
                            "value": "\"aggregate\"",
                            "computed": false
                          }, {
                            "value": "\"alert\"",
                            "computed": false
                          }, {
                            "value": "\"annotation\"",
                            "computed": false
                          }, {
                            "value": "\"apmApp\"",
                            "computed": false
                          }, {
                            "value": "\"apmTrace\"",
                            "computed": false
                          }, {
                            "value": "\"apps\"",
                            "computed": false
                          }, {
                            "value": "\"arrowDown\"",
                            "computed": false
                          }, {
                            "value": "\"arrowLeft\"",
                            "computed": false
                          }, {
                            "value": "\"arrowRight\"",
                            "computed": false
                          }, {
                            "value": "\"arrowUp\"",
                            "computed": false
                          }, {
                            "value": "\"asterisk\"",
                            "computed": false
                          }, {
                            "value": "\"auditbeatApp\"",
                            "computed": false
                          }, {
                            "value": "\"beaker\"",
                            "computed": false
                          }, {
                            "value": "\"bell\"",
                            "computed": false
                          }, {
                            "value": "\"bellSlash\"",
                            "computed": false
                          }, {
                            "value": "\"bolt\"",
                            "computed": false
                          }, {
                            "value": "\"boxesHorizontal\"",
                            "computed": false
                          }, {
                            "value": "\"boxesVertical\"",
                            "computed": false
                          }, {
                            "value": "\"branch\"",
                            "computed": false
                          }, {
                            "value": "\"broom\"",
                            "computed": false
                          }, {
                            "value": "\"brush\"",
                            "computed": false
                          }, {
                            "value": "\"bug\"",
                            "computed": false
                          }, {
                            "value": "\"bullseye\"",
                            "computed": false
                          }, {
                            "value": "\"calendar\"",
                            "computed": false
                          }, {
                            "value": "\"canvasApp\"",
                            "computed": false
                          }, {
                            "value": "\"codeApp\"",
                            "computed": false
                          }, {
                            "value": "\"check\"",
                            "computed": false
                          }, {
                            "value": "\"checkInCircleFilled\"",
                            "computed": false
                          }, {
                            "value": "\"cheer\"",
                            "computed": false
                          }, {
                            "value": "\"clock\"",
                            "computed": false
                          }, {
                            "value": "\"cloudDrizzle\"",
                            "computed": false
                          }, {
                            "value": "\"cloudStormy\"",
                            "computed": false
                          }, {
                            "value": "\"cloudSunny\"",
                            "computed": false
                          }, {
                            "value": "\"compute\"",
                            "computed": false
                          }, {
                            "value": "\"console\"",
                            "computed": false
                          }, {
                            "value": "\"consoleApp\"",
                            "computed": false
                          }, {
                            "value": "\"controlsHorizontal\"",
                            "computed": false
                          }, {
                            "value": "\"controlsVertical\"",
                            "computed": false
                          }, {
                            "value": "\"copy\"",
                            "computed": false
                          }, {
                            "value": "\"copyClipboard\"",
                            "computed": false
                          }, {
                            "value": "\"createAdvancedJob\"",
                            "computed": false
                          }, {
                            "value": "\"createMultiMetricJob\"",
                            "computed": false
                          }, {
                            "value": "\"createPopulationJob\"",
                            "computed": false
                          }, {
                            "value": "\"createSingleMetricJob\"",
                            "computed": false
                          }, {
                            "value": "\"cross\"",
                            "computed": false
                          }, {
                            "value": "\"crossClusterReplicationApp\"",
                            "computed": false
                          }, {
                            "value": "\"crosshairs\"",
                            "computed": false
                          }, {
                            "value": "\"crossInACircleFilled\"",
                            "computed": false
                          }, {
                            "value": "\"currency\"",
                            "computed": false
                          }, {
                            "value": "\"cut\"",
                            "computed": false
                          }, {
                            "value": "\"dashboardApp\"",
                            "computed": false
                          }, {
                            "value": "\"database\"",
                            "computed": false
                          }, {
                            "value": "\"dataVisualizer\"",
                            "computed": false
                          }, {
                            "value": "\"devToolsApp\"",
                            "computed": false
                          }, {
                            "value": "\"discoverApp\"",
                            "computed": false
                          }, {
                            "value": "\"document\"",
                            "computed": false
                          }, {
                            "value": "\"documentEdit\"",
                            "computed": false
                          }, {
                            "value": "\"documents\"",
                            "computed": false
                          }, {
                            "value": "\"dot\"",
                            "computed": false
                          }, {
                            "value": "\"download\"",
                            "computed": false
                          }, {
                            "value": "\"editorAlignCenter\"",
                            "computed": false
                          }, {
                            "value": "\"editorAlignLeft\"",
                            "computed": false
                          }, {
                            "value": "\"editorAlignRight\"",
                            "computed": false
                          }, {
                            "value": "\"editorBold\"",
                            "computed": false
                          }, {
                            "value": "\"editorCodeBlock\"",
                            "computed": false
                          }, {
                            "value": "\"editorComment\"",
                            "computed": false
                          }, {
                            "value": "\"editorDistributeHorizontal\"",
                            "computed": false
                          }, {
                            "value": "\"editorDistributeVertical\"",
                            "computed": false
                          }, {
                            "value": "\"editorHeading\"",
                            "computed": false
                          }, {
                            "value": "\"editorItalic\"",
                            "computed": false
                          }, {
                            "value": "\"editorItemAlignLeft\"",
                            "computed": false
                          }, {
                            "value": "\"editorItemAlignBottom\"",
                            "computed": false
                          }, {
                            "value": "\"editorItemAlignCenter\"",
                            "computed": false
                          }, {
                            "value": "\"editorItemAlignMiddle\"",
                            "computed": false
                          }, {
                            "value": "\"editorItemAlignRight\"",
                            "computed": false
                          }, {
                            "value": "\"editorItemAlignTop\"",
                            "computed": false
                          }, {
                            "value": "\"editorLink\"",
                            "computed": false
                          }, {
                            "value": "\"editorOrderedList\"",
                            "computed": false
                          }, {
                            "value": "\"editorPositionBottomLeft\"",
                            "computed": false
                          }, {
                            "value": "\"editorPositionBottomRight\"",
                            "computed": false
                          }, {
                            "value": "\"editorPositionTopLeft\"",
                            "computed": false
                          }, {
                            "value": "\"editorPositionTopRight\"",
                            "computed": false
                          }, {
                            "value": "\"editorRedo\"",
                            "computed": false
                          }, {
                            "value": "\"editorStrike\"",
                            "computed": false
                          }, {
                            "value": "\"editorTable\"",
                            "computed": false
                          }, {
                            "value": "\"editorUnderline\"",
                            "computed": false
                          }, {
                            "value": "\"editorUndo\"",
                            "computed": false
                          }, {
                            "value": "\"editorUnorderedList\"",
                            "computed": false
                          }, {
                            "value": "\"email\"",
                            "computed": false
                          }, {
                            "value": "\"empty\"",
                            "computed": false
                          }, {
                            "value": "\"emsApp\"",
                            "computed": false
                          }, {
                            "value": "\"exit\"",
                            "computed": false
                          }, {
                            "value": "\"expand\"",
                            "computed": false
                          }, {
                            "value": "\"expandMini\"",
                            "computed": false
                          }, {
                            "value": "\"exportAction\"",
                            "computed": false
                          }, {
                            "value": "\"eye\"",
                            "computed": false
                          }, {
                            "value": "\"eyeClosed\"",
                            "computed": false
                          }, {
                            "value": "\"faceHappy\"",
                            "computed": false
                          }, {
                            "value": "\"faceNeutral\"",
                            "computed": false
                          }, {
                            "value": "\"faceSad\"",
                            "computed": false
                          }, {
                            "value": "\"filebeatApp\"",
                            "computed": false
                          }, {
                            "value": "\"filter\"",
                            "computed": false
                          }, {
                            "value": "\"flag\"",
                            "computed": false
                          }, {
                            "value": "\"folderCheck\"",
                            "computed": false
                          }, {
                            "value": "\"folderClosed\"",
                            "computed": false
                          }, {
                            "value": "\"folderExclamation\"",
                            "computed": false
                          }, {
                            "value": "\"folderOpen\"",
                            "computed": false
                          }, {
                            "value": "\"fullScreen\"",
                            "computed": false
                          }, {
                            "value": "\"gear\"",
                            "computed": false
                          }, {
                            "value": "\"gisApp\"",
                            "computed": false
                          }, {
                            "value": "\"glasses\"",
                            "computed": false
                          }, {
                            "value": "\"globe\"",
                            "computed": false
                          }, {
                            "value": "\"grab\"",
                            "computed": false
                          }, {
                            "value": "\"grabHorizontal\"",
                            "computed": false
                          }, {
                            "value": "\"graphApp\"",
                            "computed": false
                          }, {
                            "value": "\"grid\"",
                            "computed": false
                          }, {
                            "value": "\"grokApp\"",
                            "computed": false
                          }, {
                            "value": "\"heart\"",
                            "computed": false
                          }, {
                            "value": "\"heartbeatApp\"",
                            "computed": false
                          }, {
                            "value": "\"heatmap\"",
                            "computed": false
                          }, {
                            "value": "\"help\"",
                            "computed": false
                          }, {
                            "value": "\"home\"",
                            "computed": false
                          }, {
                            "value": "\"iInCircle\"",
                            "computed": false
                          }, {
                            "value": "\"image\"",
                            "computed": false
                          }, {
                            "value": "\"importAction\"",
                            "computed": false
                          }, {
                            "value": "\"indexClose\"",
                            "computed": false
                          }, {
                            "value": "\"indexEdit\"",
                            "computed": false
                          }, {
                            "value": "\"indexFlush\"",
                            "computed": false
                          }, {
                            "value": "\"indexManagementApp\"",
                            "computed": false
                          }, {
                            "value": "\"indexMapping\"",
                            "computed": false
                          }, {
                            "value": "\"indexOpen\"",
                            "computed": false
                          }, {
                            "value": "\"indexPatternApp\"",
                            "computed": false
                          }, {
                            "value": "\"indexRollupApp\"",
                            "computed": false
                          }, {
                            "value": "\"indexSettings\"",
                            "computed": false
                          }, {
                            "value": "\"inputOutput\"",
                            "computed": false
                          }, {
                            "value": "\"inspect\"",
                            "computed": false
                          }, {
                            "value": "\"invert\"",
                            "computed": false
                          }, {
                            "value": "\"ip\"",
                            "computed": false
                          }, {
                            "value": "\"keyboardShortcut\"",
                            "computed": false
                          }, {
                            "value": "\"kqlField\"",
                            "computed": false
                          }, {
                            "value": "\"kqlFunction\"",
                            "computed": false
                          }, {
                            "value": "\"kqlOperand\"",
                            "computed": false
                          }, {
                            "value": "\"kqlSelector\"",
                            "computed": false
                          }, {
                            "value": "\"kqlValue\"",
                            "computed": false
                          }, {
                            "value": "\"lensApp\"",
                            "computed": false
                          }, {
                            "value": "\"link\"",
                            "computed": false
                          }, {
                            "value": "\"list\"",
                            "computed": false
                          }, {
                            "value": "\"listAdd\"",
                            "computed": false
                          }, {
                            "value": "\"lock\"",
                            "computed": false
                          }, {
                            "value": "\"lockOpen\"",
                            "computed": false
                          }, {
                            "value": "\"logsApp\"",
                            "computed": false
                          }, {
                            "value": "\"logoAerospike\"",
                            "computed": false
                          }, {
                            "value": "\"logoApache\"",
                            "computed": false
                          }, {
                            "value": "\"logoAPM\"",
                            "computed": false
                          }, {
                            "value": "\"logoAppSearch\"",
                            "computed": false
                          }, {
                            "value": "\"logoAWS\"",
                            "computed": false
                          }, {
                            "value": "\"logoAWSMono\"",
                            "computed": false
                          }, {
                            "value": "\"logoAzure\"",
                            "computed": false
                          }, {
                            "value": "\"logoAzureMono\"",
                            "computed": false
                          }, {
                            "value": "\"logoBeats\"",
                            "computed": false
                          }, {
                            "value": "\"logoBusinessAnalytics\"",
                            "computed": false
                          }, {
                            "value": "\"logoCeph\"",
                            "computed": false
                          }, {
                            "value": "\"logoCloud\"",
                            "computed": false
                          }, {
                            "value": "\"logoCloudEnterprise\"",
                            "computed": false
                          }, {
                            "value": "\"logoCode\"",
                            "computed": false
                          }, {
                            "value": "\"logoCodesandbox\"",
                            "computed": false
                          }, {
                            "value": "\"logoCouchbase\"",
                            "computed": false
                          }, {
                            "value": "\"logoDocker\"",
                            "computed": false
                          }, {
                            "value": "\"logoDropwizard\"",
                            "computed": false
                          }, {
                            "value": "\"logoElastic\"",
                            "computed": false
                          }, {
                            "value": "\"logoElasticsearch\"",
                            "computed": false
                          }, {
                            "value": "\"logoElasticStack\"",
                            "computed": false
                          }, {
                            "value": "\"logoEnterpriseSearch\"",
                            "computed": false
                          }, {
                            "value": "\"logoEtcd\"",
                            "computed": false
                          }, {
                            "value": "\"logoGCP\"",
                            "computed": false
                          }, {
                            "value": "\"logoGCPMono\"",
                            "computed": false
                          }, {
                            "value": "\"logoGithub\"",
                            "computed": false
                          }, {
                            "value": "\"logoGmail\"",
                            "computed": false
                          }, {
                            "value": "\"logoGolang\"",
                            "computed": false
                          }, {
                            "value": "\"logoGoogleG\"",
                            "computed": false
                          }, {
                            "value": "\"logoHAproxy\"",
                            "computed": false
                          }, {
                            "value": "\"logoIBM\"",
                            "computed": false
                          }, {
                            "value": "\"logoIBMMono\"",
                            "computed": false
                          }, {
                            "value": "\"logoKafka\"",
                            "computed": false
                          }, {
                            "value": "\"logoKibana\"",
                            "computed": false
                          }, {
                            "value": "\"logoKubernetes\"",
                            "computed": false
                          }, {
                            "value": "\"logoLogging\"",
                            "computed": false
                          }, {
                            "value": "\"logoLogstash\"",
                            "computed": false
                          }, {
                            "value": "\"logoMaps\"",
                            "computed": false
                          }, {
                            "value": "\"logoMemcached\"",
                            "computed": false
                          }, {
                            "value": "\"logoMetrics\"",
                            "computed": false
                          }, {
                            "value": "\"logoMongodb\"",
                            "computed": false
                          }, {
                            "value": "\"logoMySQL\"",
                            "computed": false
                          }, {
                            "value": "\"logoNginx\"",
                            "computed": false
                          }, {
                            "value": "\"logoObservability\"",
                            "computed": false
                          }, {
                            "value": "\"logoOsquery\"",
                            "computed": false
                          }, {
                            "value": "\"logoPhp\"",
                            "computed": false
                          }, {
                            "value": "\"logoPostgres\"",
                            "computed": false
                          }, {
                            "value": "\"logoPrometheus\"",
                            "computed": false
                          }, {
                            "value": "\"logoRabbitmq\"",
                            "computed": false
                          }, {
                            "value": "\"logoRedis\"",
                            "computed": false
                          }, {
                            "value": "\"logoSecurity\"",
                            "computed": false
                          }, {
                            "value": "\"logoSiteSearch\"",
                            "computed": false
                          }, {
                            "value": "\"logoSketch\"",
                            "computed": false
                          }, {
                            "value": "\"logoSlack\"",
                            "computed": false
                          }, {
                            "value": "\"logoUptime\"",
                            "computed": false
                          }, {
                            "value": "\"logoWebhook\"",
                            "computed": false
                          }, {
                            "value": "\"logoWindows\"",
                            "computed": false
                          }, {
                            "value": "\"logoWorkplaceSearch\"",
                            "computed": false
                          }, {
                            "value": "\"logstashFilter\"",
                            "computed": false
                          }, {
                            "value": "\"logstashIf\"",
                            "computed": false
                          }, {
                            "value": "\"logstashInput\"",
                            "computed": false
                          }, {
                            "value": "\"logstashOutput\"",
                            "computed": false
                          }, {
                            "value": "\"logstashQueue\"",
                            "computed": false
                          }, {
                            "value": "\"machineLearningApp\"",
                            "computed": false
                          }, {
                            "value": "\"magnet\"",
                            "computed": false
                          }, {
                            "value": "\"magnifyWithMinus\"",
                            "computed": false
                          }, {
                            "value": "\"magnifyWithPlus\"",
                            "computed": false
                          }, {
                            "value": "\"managementApp\"",
                            "computed": false
                          }, {
                            "value": "\"mapMarker\"",
                            "computed": false
                          }, {
                            "value": "\"memory\"",
                            "computed": false
                          }, {
                            "value": "\"menu\"",
                            "computed": false
                          }, {
                            "value": "\"menuLeft\"",
                            "computed": false
                          }, {
                            "value": "\"menuRight\"",
                            "computed": false
                          }, {
                            "value": "\"merge\"",
                            "computed": false
                          }, {
                            "value": "\"metricbeatApp\"",
                            "computed": false
                          }, {
                            "value": "\"metricsApp\"",
                            "computed": false
                          }, {
                            "value": "\"minimize\"",
                            "computed": false
                          }, {
                            "value": "\"minusInCircle\"",
                            "computed": false
                          }, {
                            "value": "\"minusInCircleFilled\"",
                            "computed": false
                          }, {
                            "value": "\"monitoringApp\"",
                            "computed": false
                          }, {
                            "value": "\"moon\"",
                            "computed": false
                          }, {
                            "value": "\"nested\"",
                            "computed": false
                          }, {
                            "value": "\"node\"",
                            "computed": false
                          }, {
                            "value": "\"notebookApp\"",
                            "computed": false
                          }, {
                            "value": "\"number\"",
                            "computed": false
                          }, {
                            "value": "\"offline\"",
                            "computed": false
                          }, {
                            "value": "\"online\"",
                            "computed": false
                          }, {
                            "value": "\"package\"",
                            "computed": false
                          }, {
                            "value": "\"packetbeatApp\"",
                            "computed": false
                          }, {
                            "value": "\"pageSelect\"",
                            "computed": false
                          }, {
                            "value": "\"pagesSelect\"",
                            "computed": false
                          }, {
                            "value": "\"partial\"",
                            "computed": false
                          }, {
                            "value": "\"paperClip\"",
                            "computed": false
                          }, {
                            "value": "\"pause\"",
                            "computed": false
                          }, {
                            "value": "\"pencil\"",
                            "computed": false
                          }, {
                            "value": "\"pin\"",
                            "computed": false
                          }, {
                            "value": "\"pinFilled\"",
                            "computed": false
                          }, {
                            "value": "\"pipelineApp\"",
                            "computed": false
                          }, {
                            "value": "\"play\"",
                            "computed": false
                          }, {
                            "value": "\"plusInCircle\"",
                            "computed": false
                          }, {
                            "value": "\"plusInCircleFilled\"",
                            "computed": false
                          }, {
                            "value": "\"popout\"",
                            "computed": false
                          }, {
                            "value": "\"push\"",
                            "computed": false
                          }, {
                            "value": "\"questionInCircle\"",
                            "computed": false
                          }, {
                            "value": "\"quote\"",
                            "computed": false
                          }, {
                            "value": "\"recentlyViewedApp\"",
                            "computed": false
                          }, {
                            "value": "\"refresh\"",
                            "computed": false
                          }, {
                            "value": "\"reporter\"",
                            "computed": false
                          }, {
                            "value": "\"reportingApp\"",
                            "computed": false
                          }, {
                            "value": "\"save\"",
                            "computed": false
                          }, {
                            "value": "\"savedObjectsApp\"",
                            "computed": false
                          }, {
                            "value": "\"scale\"",
                            "computed": false
                          }, {
                            "value": "\"search\"",
                            "computed": false
                          }, {
                            "value": "\"searchProfilerApp\"",
                            "computed": false
                          }, {
                            "value": "\"securityAnalyticsApp\"",
                            "computed": false
                          }, {
                            "value": "\"securityApp\"",
                            "computed": false
                          }, {
                            "value": "\"securitySignal\"",
                            "computed": false
                          }, {
                            "value": "\"securitySignalDetected\"",
                            "computed": false
                          }, {
                            "value": "\"securitySignalResolved\"",
                            "computed": false
                          }, {
                            "value": "\"shard\"",
                            "computed": false
                          }, {
                            "value": "\"share\"",
                            "computed": false
                          }, {
                            "value": "\"snowflake\"",
                            "computed": false
                          }, {
                            "value": "\"sortable\"",
                            "computed": false
                          }, {
                            "value": "\"sortDown\"",
                            "computed": false
                          }, {
                            "value": "\"sortLeft\"",
                            "computed": false
                          }, {
                            "value": "\"sortRight\"",
                            "computed": false
                          }, {
                            "value": "\"sortUp\"",
                            "computed": false
                          }, {
                            "value": "\"spacesApp\"",
                            "computed": false
                          }, {
                            "value": "\"sqlApp\"",
                            "computed": false
                          }, {
                            "value": "\"starEmpty\"",
                            "computed": false
                          }, {
                            "value": "\"starEmptySpace\"",
                            "computed": false
                          }, {
                            "value": "\"starFilled\"",
                            "computed": false
                          }, {
                            "value": "\"starFilledSpace\"",
                            "computed": false
                          }, {
                            "value": "\"starMinusEmpty\"",
                            "computed": false
                          }, {
                            "value": "\"starMinusFilled\"",
                            "computed": false
                          }, {
                            "value": "\"starPlusEmpty\"",
                            "computed": false
                          }, {
                            "value": "\"starPlusFilled\"",
                            "computed": false
                          }, {
                            "value": "\"stats\"",
                            "computed": false
                          }, {
                            "value": "\"stop\"",
                            "computed": false
                          }, {
                            "value": "\"stopFilled\"",
                            "computed": false
                          }, {
                            "value": "\"stopSlash\"",
                            "computed": false
                          }, {
                            "value": "\"storage\"",
                            "computed": false
                          }, {
                            "value": "\"string\"",
                            "computed": false
                          }, {
                            "value": "\"submodule\"",
                            "computed": false
                          }, {
                            "value": "\"swatchInput\"",
                            "computed": false
                          }, {
                            "value": "\"symlink\"",
                            "computed": false
                          }, {
                            "value": "\"tableOfContents\"",
                            "computed": false
                          }, {
                            "value": "\"tableDensityExpanded\"",
                            "computed": false
                          }, {
                            "value": "\"tableDensityCompact\"",
                            "computed": false
                          }, {
                            "value": "\"tableDensityNormal\"",
                            "computed": false
                          }, {
                            "value": "\"tag\"",
                            "computed": false
                          }, {
                            "value": "\"tear\"",
                            "computed": false
                          }, {
                            "value": "\"temperature\"",
                            "computed": false
                          }, {
                            "value": "\"timeline\"",
                            "computed": false
                          }, {
                            "value": "\"timelionApp\"",
                            "computed": false
                          }, {
                            "value": "\"training\"",
                            "computed": false
                          }, {
                            "value": "\"trash\"",
                            "computed": false
                          }, {
                            "value": "\"upgradeAssistantApp\"",
                            "computed": false
                          }, {
                            "value": "\"uptimeApp\"",
                            "computed": false
                          }, {
                            "value": "\"user\"",
                            "computed": false
                          }, {
                            "value": "\"users\"",
                            "computed": false
                          }, {
                            "value": "\"usersRolesApp\"",
                            "computed": false
                          }, {
                            "value": "\"vector\"",
                            "computed": false
                          }, {
                            "value": "\"videoPlayer\"",
                            "computed": false
                          }, {
                            "value": "\"visArea\"",
                            "computed": false
                          }, {
                            "value": "\"visAreaStacked\"",
                            "computed": false
                          }, {
                            "value": "\"visBarHorizontal\"",
                            "computed": false
                          }, {
                            "value": "\"visBarHorizontalStacked\"",
                            "computed": false
                          }, {
                            "value": "\"visBarVertical\"",
                            "computed": false
                          }, {
                            "value": "\"visBarVerticalStacked\"",
                            "computed": false
                          }, {
                            "value": "\"visGauge\"",
                            "computed": false
                          }, {
                            "value": "\"visGoal\"",
                            "computed": false
                          }, {
                            "value": "\"visLine\"",
                            "computed": false
                          }, {
                            "value": "\"visMapCoordinate\"",
                            "computed": false
                          }, {
                            "value": "\"visMapRegion\"",
                            "computed": false
                          }, {
                            "value": "\"visMetric\"",
                            "computed": false
                          }, {
                            "value": "\"visPie\"",
                            "computed": false
                          }, {
                            "value": "\"visTable\"",
                            "computed": false
                          }, {
                            "value": "\"visTagCloud\"",
                            "computed": false
                          }, {
                            "value": "\"visText\"",
                            "computed": false
                          }, {
                            "value": "\"visTimelion\"",
                            "computed": false
                          }, {
                            "value": "\"visualizeApp\"",
                            "computed": false
                          }, {
                            "value": "\"visVega\"",
                            "computed": false
                          }, {
                            "value": "\"visVisualBuilder\"",
                            "computed": false
                          }, {
                            "value": "\"watchesApp\"",
                            "computed": false
                          }, {
                            "value": "\"wrench\"",
                            "computed": false
                          }, {
                            "value": "\"tokenClass\"",
                            "computed": false
                          }, {
                            "value": "\"tokenProperty\"",
                            "computed": false
                          }, {
                            "value": "\"tokenEnum\"",
                            "computed": false
                          }, {
                            "value": "\"tokenVariable\"",
                            "computed": false
                          }, {
                            "value": "\"tokenMethod\"",
                            "computed": false
                          }, {
                            "value": "\"tokenAnnotation\"",
                            "computed": false
                          }, {
                            "value": "\"tokenException\"",
                            "computed": false
                          }, {
                            "value": "\"tokenInterface\"",
                            "computed": false
                          }, {
                            "value": "\"tokenParameter\"",
                            "computed": false
                          }, {
                            "value": "\"tokenField\"",
                            "computed": false
                          }, {
                            "value": "\"tokenElement\"",
                            "computed": false
                          }, {
                            "value": "\"tokenFunction\"",
                            "computed": false
                          }, {
                            "value": "\"tokenBoolean\"",
                            "computed": false
                          }, {
                            "value": "\"tokenString\"",
                            "computed": false
                          }, {
                            "value": "\"tokenArray\"",
                            "computed": false
                          }, {
                            "value": "\"tokenNumber\"",
                            "computed": false
                          }, {
                            "value": "\"tokenConstant\"",
                            "computed": false
                          }, {
                            "value": "\"tokenObject\"",
                            "computed": false
                          }, {
                            "value": "\"tokenEvent\"",
                            "computed": false
                          }, {
                            "value": "\"tokenKey\"",
                            "computed": false
                          }, {
                            "value": "\"tokenNull\"",
                            "computed": false
                          }, {
                            "value": "\"tokenStruct\"",
                            "computed": false
                          }, {
                            "value": "\"tokenPackage\"",
                            "computed": false
                          }, {
                            "value": "\"tokenOperator\"",
                            "computed": false
                          }, {
                            "value": "\"tokenEnumMember\"",
                            "computed": false
                          }, {
                            "value": "\"tokenRepo\"",
                            "computed": false
                          }, {
                            "value": "\"tokenSymbol\"",
                            "computed": false
                          }, {
                            "value": "\"tokenFile\"",
                            "computed": false
                          }, {
                            "value": "\"tokenModule\"",
                            "computed": false
                          }, {
                            "value": "\"tokenNamespace\"",
                            "computed": false
                          }, {
                            "value": "\"tokenDate\"",
                            "computed": false
                          }, {
                            "value": "\"tokenIP\"",
                            "computed": false
                          }, {
                            "value": "\"tokenNested\"",
                            "computed": false
                          }, {
                            "value": "\"tokenAlias\"",
                            "computed": false
                          }, {
                            "value": "\"tokenShape\"",
                            "computed": false
                          }, {
                            "value": "\"tokenGeo\"",
                            "computed": false
                          }, {
                            "value": "\"tokenRange\"",
                            "computed": false
                          }, {
                            "value": "\"tokenBinary\"",
                            "computed": false
                          }, {
                            "value": "\"tokenJoin\"",
                            "computed": false
                          }, {
                            "value": "\"tokenPercolator\"",
                            "computed": false
                          }, {
                            "value": "\"tokenFlattened\"",
                            "computed": false
                          }, {
                            "value": "\"tokenRankFeature\"",
                            "computed": false
                          }, {
                            "value": "\"tokenRankFeatures\"",
                            "computed": false
                          }, {
                            "value": "\"tokenKeyword\"",
                            "computed": false
                          }, {
                            "value": "\"tokenCompletionSuggester\"",
                            "computed": false
                          }, {
                            "value": "\"tokenDenseVector\"",
                            "computed": false
                          }, {
                            "value": "\"tokenText\"",
                            "computed": false
                          }, {
                            "value": "\"tokenTokenCount\"",
                            "computed": false
                          }, {
                            "value": "\"tokenSearchType\"",
                            "computed": false
                          }, {
                            "value": "\"tokenHistogram\"",
                            "computed": false
                          }]
                        }, {
                          "name": "func"
                        }],
                        "required": false
                      }
                    }
                  }, {
                    "name": "shape",
                    "value": {
                      "render": {
                        "name": "func",
                        "required": true
                      },
                      "available": {
                        "name": "func",
                        "required": false
                      },
                      "enabled": {
                        "name": "func",
                        "required": false
                      },
                      "isPrimary": {
                        "name": "bool",
                        "required": false
                      }
                    }
                  }]
                },
                "required": true
              },
              "name": {
                "name": "node",
                "required": false
              },
              "description": {
                "name": "string",
                "required": false
              },
              "width": {
                "name": "string",
                "required": false
              }
            }
          }]
        }
      },
      "required": false,
      "description": ""
    },
    "error": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "tableCaption": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "rowHeader": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "hasActions": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "isExpandable": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "isSelectable": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "loading": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "onChange": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "rowProps": {
      "type": {
        "name": "union",
        "value": [{
          "name": "any"
        }, {
          "name": "func"
        }]
      },
      "required": false,
      "description": ""
    },
    "selection": {
      "type": {
        "name": "shape",
        "value": {
          "onSelectionChange": {
            "name": "func",
            "required": false
          },
          "selectable": {
            "name": "func",
            "required": false
          },
          "selectableMessage": {
            "name": "func",
            "required": false
          },
          "initialSelected": {
            "name": "arrayOf",
            "value": {
              "name": "any"
            },
            "required": false
          }
        }
      },
      "required": false,
      "description": ""
    },
    "message": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "search": {
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "shape",
          "value": {
            "onChange": {
              "name": "func",
              "required": false
            },
            "defaultQuery": {
              "name": "union",
              "value": [{
                "name": "any"
              }, {
                "name": "string"
              }],
              "description": "The initial query the bar will hold when first mounted",
              "required": false
            },
            "query": {
              "name": "union",
              "value": [{
                "name": "any"
              }, {
                "name": "string"
              }],
              "description": "If you wish to use the search bar as a controlled component, continuously pass the query\n       via this prop",
              "required": false
            },
            "box": {
              "name": "shape",
              "value": {
                "name": {
                  "name": "string",
                  "required": false
                },
                "id": {
                  "name": "string",
                  "required": false
                },
                "placeholder": {
                  "name": "string",
                  "required": false
                },
                "value": {
                  "name": "string",
                  "required": false
                },
                "isInvalid": {
                  "name": "bool",
                  "required": false
                },
                "fullWidth": {
                  "name": "bool",
                  "required": false
                },
                "isLoading": {
                  "name": "bool",
                  "required": false
                },
                "onSearch": {
                  "name": "func",
                  "description": "Called when the user presses [Enter] OR on change if the incremental prop is `true`.\nIf you don't need the on[Enter] functionality, prefer using onChange",
                  "required": false
                },
                "incremental": {
                  "name": "bool",
                  "description": "When `true` the search will be executed (that is, the `onSearch` will be called) as the\nuser types.",
                  "required": false
                },
                "compressed": {
                  "name": "bool",
                  "description": "when `true` creates a shorter height input",
                  "required": false
                },
                "inputRef": {
                  "name": "func",
                  "required": false
                },
                "isClearable": {
                  "name": "bool",
                  "description": "Shows a button that quickly clears any input",
                  "required": false
                },
                "prepend": {
                  "name": "union",
                  "value": [{
                    "name": "union",
                    "value": [{
                      "name": "string"
                    }, {
                      "name": "element"
                    }]
                  }, {
                    "name": "arrayOf",
                    "value": {
                      "name": "union",
                      "value": [{
                        "name": "string"
                      }, {
                        "name": "element"
                      }]
                    }
                  }],
                  "description": "Creates an input group with element(s) coming before input\n`string` | `ReactElement` or an array of these",
                  "required": false
                },
                "append": {
                  "name": "union",
                  "value": [{
                    "name": "union",
                    "value": [{
                      "name": "string"
                    }, {
                      "name": "element"
                    }]
                  }, {
                    "name": "arrayOf",
                    "value": {
                      "name": "union",
                      "value": [{
                        "name": "string"
                      }, {
                        "name": "element"
                      }]
                    }
                  }],
                  "description": "Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these",
                  "required": false
                },
                "className": {
                  "name": "string",
                  "required": false
                },
                "aria-label": {
                  "name": "string",
                  "required": false
                },
                "data-test-subj": {
                  "name": "string",
                  "required": false
                },
                "schema": {
                  "name": "union",
                  "value": [{
                    "name": "shape",
                    "value": {
                      "strict": {
                        "name": "bool",
                        "required": false
                      },
                      "fields": {
                        "name": "any",
                        "required": false
                      },
                      "flags": {
                        "name": "arrayOf",
                        "value": {
                          "name": "string"
                        },
                        "required": false
                      }
                    }
                  }, {
                    "name": "bool"
                  }],
                  "required": false
                }
              },
              "description": "Configures the search box. Set `placeholder` to change the placeholder text in the box and\n       `incremental` to support incremental (as you type) search.",
              "required": false
            },
            "filters": {
              "name": "arrayOf",
              "value": {
                "name": "union",
                "value": [{
                  "name": "shape",
                  "value": {
                    "type": {
                      "name": "enum",
                      "value": [{
                        "value": "\"is\"",
                        "computed": false
                      }],
                      "required": true
                    },
                    "field": {
                      "name": "string",
                      "required": true
                    },
                    "name": {
                      "name": "string",
                      "required": true
                    },
                    "negatedName": {
                      "name": "string",
                      "required": false
                    },
                    "available": {
                      "name": "func",
                      "required": false
                    }
                  }
                }, {
                  "name": "shape",
                  "value": {
                    "type": {
                      "name": "enum",
                      "value": [{
                        "value": "\"field_value_selection\"",
                        "computed": false
                      }],
                      "required": true
                    },
                    "field": {
                      "name": "string",
                      "required": false
                    },
                    "name": {
                      "name": "string",
                      "required": true
                    },
                    "options": {
                      "name": "union",
                      "value": [{
                        "name": "arrayOf",
                        "value": {
                          "name": "shape",
                          "value": {
                            "field": {
                              "name": "string",
                              "required": false
                            },
                            "value": {
                              "name": "union",
                              "value": [{
                                "name": "string"
                              }, {
                                "name": "number"
                              }, {
                                "name": "bool"
                              }, {
                                "name": "shape",
                                "value": {
                                  "type": {
                                    "name": "enum",
                                    "value": [{
                                      "value": "\"date\"",
                                      "computed": false
                                    }],
                                    "required": true
                                  },
                                  "raw": {
                                    "name": "any",
                                    "required": true
                                  },
                                  "granularity": {
                                    "name": "union",
                                    "value": [{
                                      "name": "shape",
                                      "value": {
                                        "es": {
                                          "name": "enum",
                                          "value": [{
                                            "value": "\"d\"",
                                            "computed": false
                                          }, {
                                            "value": "\"w\"",
                                            "computed": false
                                          }, {
                                            "value": "\"M\"",
                                            "computed": false
                                          }, {
                                            "value": "\"y\"",
                                            "computed": false
                                          }],
                                          "required": true
                                        },
                                        "js": {
                                          "name": "enum",
                                          "value": [{
                                            "value": "\"day\"",
                                            "computed": false
                                          }, {
                                            "value": "\"week\"",
                                            "computed": false
                                          }, {
                                            "value": "\"month\"",
                                            "computed": false
                                          }, {
                                            "value": "\"year\"",
                                            "computed": false
                                          }],
                                          "required": true
                                        },
                                        "isSame": {
                                          "name": "func",
                                          "required": true
                                        },
                                        "start": {
                                          "name": "func",
                                          "required": true
                                        },
                                        "startOfNext": {
                                          "name": "func",
                                          "required": true
                                        },
                                        "iso8601": {
                                          "name": "func",
                                          "required": true
                                        }
                                      }
                                    }, {
                                      "name": "enum",
                                      "value": [{
                                        "value": "undefined",
                                        "computed": true
                                      }]
                                    }],
                                    "required": true
                                  },
                                  "text": {
                                    "name": "string",
                                    "required": true
                                  },
                                  "resolve": {
                                    "name": "func",
                                    "required": true
                                  }
                                }
                              }],
                              "required": true
                            },
                            "name": {
                              "name": "string",
                              "required": false
                            },
                            "view": {
                              "name": "node",
                              "required": false
                            }
                          }
                        }
                      }, {
                        "name": "func"
                      }],
                      "required": true
                    },
                    "filterWith": {
                      "name": "union",
                      "value": [{
                        "name": "enum",
                        "value": [{
                          "value": "\"prefix\"",
                          "computed": false
                        }, {
                          "value": "\"includes\"",
                          "computed": false
                        }]
                      }, {
                        "name": "func"
                      }],
                      "required": false
                    },
                    "cache": {
                      "name": "number",
                      "required": false
                    },
                    "multiSelect": {
                      "name": "union",
                      "value": [{
                        "name": "bool"
                      }, {
                        "name": "enum",
                        "value": [{
                          "value": "\"and\"",
                          "computed": false
                        }, {
                          "value": "\"or\"",
                          "computed": false
                        }]
                      }],
                      "required": false
                    },
                    "loadingMessage": {
                      "name": "string",
                      "required": false
                    },
                    "noOptionsMessage": {
                      "name": "string",
                      "required": false
                    },
                    "searchThreshold": {
                      "name": "number",
                      "required": false
                    },
                    "available": {
                      "name": "func",
                      "required": false
                    },
                    "autoClose": {
                      "name": "bool",
                      "required": false
                    }
                  }
                }, {
                  "name": "shape",
                  "value": {
                    "type": {
                      "name": "enum",
                      "value": [{
                        "value": "\"field_value_toggle\"",
                        "computed": false
                      }],
                      "required": true
                    },
                    "field": {
                      "name": "string",
                      "required": true
                    },
                    "value": {
                      "name": "union",
                      "value": [{
                        "name": "string"
                      }, {
                        "name": "number"
                      }, {
                        "name": "bool"
                      }, {
                        "name": "shape",
                        "value": {
                          "type": {
                            "name": "enum",
                            "value": [{
                              "value": "\"date\"",
                              "computed": false
                            }],
                            "required": true
                          },
                          "raw": {
                            "name": "any",
                            "required": true
                          },
                          "granularity": {
                            "name": "union",
                            "value": [{
                              "name": "shape",
                              "value": {
                                "es": {
                                  "name": "enum",
                                  "value": [{
                                    "value": "\"d\"",
                                    "computed": false
                                  }, {
                                    "value": "\"w\"",
                                    "computed": false
                                  }, {
                                    "value": "\"M\"",
                                    "computed": false
                                  }, {
                                    "value": "\"y\"",
                                    "computed": false
                                  }],
                                  "required": true
                                },
                                "js": {
                                  "name": "enum",
                                  "value": [{
                                    "value": "\"day\"",
                                    "computed": false
                                  }, {
                                    "value": "\"week\"",
                                    "computed": false
                                  }, {
                                    "value": "\"month\"",
                                    "computed": false
                                  }, {
                                    "value": "\"year\"",
                                    "computed": false
                                  }],
                                  "required": true
                                },
                                "isSame": {
                                  "name": "func",
                                  "required": true
                                },
                                "start": {
                                  "name": "func",
                                  "required": true
                                },
                                "startOfNext": {
                                  "name": "func",
                                  "required": true
                                },
                                "iso8601": {
                                  "name": "func",
                                  "required": true
                                }
                              }
                            }, {
                              "name": "enum",
                              "value": [{
                                "value": "undefined",
                                "computed": true
                              }]
                            }],
                            "required": true
                          },
                          "text": {
                            "name": "string",
                            "required": true
                          },
                          "resolve": {
                            "name": "func",
                            "required": true
                          }
                        }
                      }],
                      "required": true
                    },
                    "name": {
                      "name": "string",
                      "required": true
                    },
                    "negatedName": {
                      "name": "string",
                      "required": false
                    },
                    "available": {
                      "name": "func",
                      "required": false
                    },
                    "operator": {
                      "name": "enum",
                      "value": [{
                        "value": "\"eq\"",
                        "computed": false
                      }, {
                        "value": "\"exact\"",
                        "computed": false
                      }, {
                        "value": "\"gt\"",
                        "computed": false
                      }, {
                        "value": "\"gte\"",
                        "computed": false
                      }, {
                        "value": "\"lt\"",
                        "computed": false
                      }, {
                        "value": "\"lte\"",
                        "computed": false
                      }],
                      "required": false
                    }
                  }
                }, {
                  "name": "shape",
                  "value": {
                    "type": {
                      "name": "enum",
                      "value": [{
                        "value": "\"field_value_toggle_group\"",
                        "computed": false
                      }],
                      "required": true
                    },
                    "field": {
                      "name": "string",
                      "required": true
                    },
                    "items": {
                      "name": "arrayOf",
                      "value": {
                        "name": "shape",
                        "value": {
                          "value": {
                            "name": "union",
                            "value": [{
                              "name": "string"
                            }, {
                              "name": "number"
                            }, {
                              "name": "bool"
                            }],
                            "required": true
                          },
                          "name": {
                            "name": "string",
                            "required": true
                          },
                          "negatedName": {
                            "name": "string",
                            "required": false
                          },
                          "operator": {
                            "name": "enum",
                            "value": [{
                              "value": "\"eq\"",
                              "computed": false
                            }, {
                              "value": "\"exact\"",
                              "computed": false
                            }, {
                              "value": "\"gt\"",
                              "computed": false
                            }, {
                              "value": "\"gte\"",
                              "computed": false
                            }, {
                              "value": "\"lt\"",
                              "computed": false
                            }, {
                              "value": "\"lte\"",
                              "computed": false
                            }],
                            "required": false
                          }
                        }
                      },
                      "required": true
                    },
                    "available": {
                      "name": "func",
                      "required": false
                    }
                  }
                }]
              },
              "description": "An array of search filters.",
              "required": false
            },
            "toolsLeft": {
              "name": "union",
              "value": [{
                "name": "element"
              }, {
                "name": "arrayOf",
                "value": {
                  "name": "element"
                }
              }],
              "description": "Tools which go to the left of the search bar.",
              "required": false
            },
            "toolsRight": {
              "name": "union",
              "value": [{
                "name": "element"
              }, {
                "name": "arrayOf",
                "value": {
                  "name": "element"
                }
              }],
              "description": "Tools which go to the right of the search bar.",
              "required": false
            },
            "dateFormat": {
              "name": "any",
              "description": "Date formatter to use when parsing date values",
              "required": false
            },
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            }
          }
        }]
      },
      "required": false,
      "description": ""
    },
    "pagination": {
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "undefined",
            "computed": true
          }]
        }, {
          "name": "union",
          "value": [{
            "name": "bool"
          }, {
            "name": "shape",
            "value": {
              "initialPageIndex": {
                "name": "number",
                "required": false
              },
              "initialPageSize": {
                "name": "number",
                "required": false
              },
              "pageSizeOptions": {
                "name": "arrayOf",
                "value": {
                  "name": "number"
                },
                "required": false
              },
              "hidePerPageOptions": {
                "name": "bool",
                "required": false
              }
            }
          }]
        }]
      },
      "required": false,
      "description": ""
    },
    "sorting": {
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "shape",
          "value": {
            "sort": {
              "name": "shape",
              "value": {
                "field": {
                  "name": "string",
                  "required": true
                },
                "direction": {
                  "name": "union",
                  "value": [{
                    "name": "any"
                  }, {
                    "name": "any"
                  }],
                  "required": true
                }
              },
              "required": true
            }
          }
        }]
      },
      "required": false,
      "description": ""
    },
    "allowNeutralSort": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Set `allowNeutralSort` to false to force column sorting. Defaults to true."
    },
    "onTableChange": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "executeQueryOptions": {
      "type": {
        "name": "shape",
        "value": {
          "defaultFields": {
            "name": "arrayOf",
            "value": {
              "name": "string"
            },
            "required": false
          },
          "isClauseMatcher": {
            "name": "func",
            "required": false
          },
          "explain": {
            "name": "bool",
            "required": false
          }
        }
      },
      "required": false,
      "description": ""
    }
  }
};