"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxOptionsList = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactVirtualized = require("react-virtualized");

var _code = require("../../../components/code");

var _flex = require("../../flex");

var _highlight = require("../../highlight");

var _panel = require("../../panel");

var _text = require("../../text");

var _loading = require("../../loading");

var _combo_box_title = require("./combo_box_title");

var _i18n = require("../../i18n");

var _filter_select_item = require("../../filter_group/filter_select_item");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var positionToClassNameMap = {
  top: 'euiComboBoxOptionsList--top',
  bottom: 'euiComboBoxOptionsList--bottom'
};
var OPTION_CONTENT_CLASSNAME = 'euiComboBoxOption__content';

var EuiComboBoxOptionsList =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiComboBoxOptionsList, _Component);

  function EuiComboBoxOptionsList() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiComboBoxOptionsList);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiComboBoxOptionsList)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "listRefInstance", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updatePosition", function () {
      // Wait a beat for the DOM to update, since we depend on DOM elements' bounds.
      requestAnimationFrame(function () {
        _this.props.updatePosition(_this.listRefInstance);
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closeListOnScroll", function (event) {
      // Close the list when a scroll event happens, but not if the scroll happened in the options list.
      // This mirrors Firefox's approach of auto-closing `select` elements onscroll.
      if (_this.listRefInstance && event.target && _this.listRefInstance.contains(event.target) === false) {
        _this.props.onCloseList();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "listRefCallback", function (ref) {
      _this.props.listRef(ref);

      _this.listRefInstance = ref;
    });
    return _this;
  }

  (0, _createClass2.default)(EuiComboBoxOptionsList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      // Wait a frame, otherwise moving focus from one combo box to another will result in the class
      // being removed from the body.
      requestAnimationFrame(function () {
        document.body.classList.add('euiBody-hasPortalContent');
      });
      this.updatePosition();
      window.addEventListener('resize', this.updatePosition); // Firefox will trigger a scroll event in many common situations when the options list div is appended
      // to the DOM; in testing it was always within 100ms, but setting a timeout here for 500ms to be safe

      setTimeout(function () {
        window.addEventListener('scroll', _this2.closeListOnScroll, {
          passive: true,
          // for better performance as we won't call preventDefault
          capture: true // scroll events don't bubble, they must be captured instead

        });
      }, 500);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var options = prevProps.options,
          selectedOptions = prevProps.selectedOptions,
          searchValue = prevProps.searchValue; // We don't compare matchingOptions because that will result in a loop.

      if (searchValue !== this.props.searchValue || options !== this.props.options || selectedOptions !== this.props.selectedOptions) {
        this.updatePosition();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', this.updatePosition);
      window.removeEventListener('scroll', this.closeListOnScroll, {
        capture: true
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          dataTestSubj = _this$props['data-test-subj'],
          activeOptionIndex = _this$props.activeOptionIndex,
          areAllOptionsSelected = _this$props.areAllOptionsSelected,
          fullWidth = _this$props.fullWidth,
          getSelectedOptionForSearchValue = _this$props.getSelectedOptionForSearchValue,
          isLoading = _this$props.isLoading,
          listRef = _this$props.listRef,
          matchingOptions = _this$props.matchingOptions,
          onCloseList = _this$props.onCloseList,
          onCreateOption = _this$props.onCreateOption,
          onOptionClick = _this$props.onOptionClick,
          onOptionEnterKey = _this$props.onOptionEnterKey,
          onScroll = _this$props.onScroll,
          optionRef = _this$props.optionRef,
          options = _this$props.options,
          position = _this$props.position,
          renderOption = _this$props.renderOption,
          rootId = _this$props.rootId,
          rowHeight = _this$props.rowHeight,
          scrollToIndex = _this$props.scrollToIndex,
          searchValue = _this$props.searchValue,
          selectedOptions = _this$props.selectedOptions,
          singleSelection = _this$props.singleSelection,
          updatePosition = _this$props.updatePosition,
          width = _this$props.width,
          delimiter = _this$props.delimiter,
          zIndex = _this$props.zIndex,
          style = _this$props.style,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["data-test-subj", "activeOptionIndex", "areAllOptionsSelected", "fullWidth", "getSelectedOptionForSearchValue", "isLoading", "listRef", "matchingOptions", "onCloseList", "onCreateOption", "onOptionClick", "onOptionEnterKey", "onScroll", "optionRef", "options", "position", "renderOption", "rootId", "rowHeight", "scrollToIndex", "searchValue", "selectedOptions", "singleSelection", "updatePosition", "width", "delimiter", "zIndex", "style"]);
      var emptyStateContent;

      if (isLoading) {
        emptyStateContent = _react.default.createElement(_flex.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "center"
        }, _react.default.createElement(_flex.EuiFlexItem, {
          grow: false
        }, _react.default.createElement(_loading.EuiLoadingSpinner, {
          size: "m"
        })), _react.default.createElement(_flex.EuiFlexItem, {
          grow: false
        }, _react.default.createElement(_i18n.EuiI18n, {
          token: "euiComboBoxOptionsList.loadingOptions",
          default: "Loading options"
        })));
      } else if (searchValue && matchingOptions && matchingOptions.length === 0) {
        if (onCreateOption && getSelectedOptionForSearchValue) {
          var selectedOptionForValue = getSelectedOptionForSearchValue(searchValue, selectedOptions);

          if (selectedOptionForValue) {
            // Disallow duplicate custom options.
            emptyStateContent = _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
              token: "euiComboBoxOptionsList.alreadyAdded",
              default: "{label} has already been added",
              values: {
                label: _react.default.createElement("strong", null, selectedOptionForValue.label)
              }
            }));
          } else {
            emptyStateContent = _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
              token: "euiComboBoxOptionsList.createCustomOption",
              default: "Hit {key} to add {searchValue} as a custom option",
              values: {
                key: _react.default.createElement(_code.EuiCode, null, "ENTER"),
                searchValue: _react.default.createElement("strong", null, searchValue)
              }
            }));
          }
        } else {
          if (delimiter && searchValue.includes(delimiter)) {
            emptyStateContent = _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
              token: "euiComboBoxOptionsList.delimiterMessage",
              default: "Hit enter to add each item separated by {delimiter}",
              values: {
                delimiter: _react.default.createElement("strong", null, delimiter)
              }
            }));
          } else {
            emptyStateContent = _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
              token: "euiComboBoxOptionsList.noMatchingOptions",
              default: "{searchValue} doesn't match any options",
              values: {
                searchValue: _react.default.createElement("strong", null, searchValue)
              }
            }));
          }
        }
      } else if (!options.length) {
        emptyStateContent = _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
          token: "euiComboBoxOptionsList.noAvailableOptions",
          default: "There aren't any options available"
        }));
      } else if (areAllOptionsSelected) {
        emptyStateContent = _react.default.createElement("p", null, _react.default.createElement(_i18n.EuiI18n, {
          token: "euiComboBoxOptionsList.allOptionsSelected",
          default: "You've selected all available options"
        }));
      }

      var emptyState = emptyStateContent ? _react.default.createElement(_text.EuiText, {
        size: "xs",
        className: "euiComboBoxOptionsList__empty"
      }, emptyStateContent) : undefined;
      var numVisibleOptions = matchingOptions.length < 7 ? matchingOptions.length : 7;
      var height = numVisibleOptions * rowHeight;

      var optionsList = _react.default.createElement(_reactVirtualized.List, {
        height: height,
        id: rootId('listbox'),
        onScroll: onScroll,
        rowRenderer: function rowRenderer(_ref) {
          var key = _ref.key,
              index = _ref.index,
              style = _ref.style;
          var option = matchingOptions[index];
          var isGroupLabelOption = option.isGroupLabelOption,
              label = option.label,
              value = option.value,
              rest = (0, _objectWithoutProperties2.default)(option, ["isGroupLabelOption", "label", "value"]);

          if (isGroupLabelOption) {
            return _react.default.createElement("div", {
              key: key,
              style: style
            }, _react.default.createElement(_combo_box_title.EuiComboBoxTitle, null, label));
          }

          var checked = undefined;

          if (singleSelection && selectedOptions.length && selectedOptions[0].label === label) {
            checked = 'on';
          }

          return _react.default.createElement(_filter_select_item.EuiFilterSelectItem, (0, _extends2.default)({
            style: style,
            key: option.label.toLowerCase(),
            onClick: function onClick() {
              if (onOptionClick) {
                onOptionClick(option);
              }
            },
            ref: optionRef.bind(_this3, index),
            isFocused: activeOptionIndex === index,
            checked: checked,
            showIcons: singleSelection ? true : false,
            id: rootId("_option-".concat(index)),
            title: label
          }, rest), renderOption ? renderOption(option, searchValue, OPTION_CONTENT_CLASSNAME) : _react.default.createElement(_highlight.EuiHighlight, {
            search: searchValue,
            className: OPTION_CONTENT_CLASSNAME
          }, label));
        },
        role: "listbox",
        rowCount: matchingOptions.length,
        rowHeight: rowHeight,
        scrollToIndex: scrollToIndex,
        width: width
      });

      var classes = (0, _classnames.default)('euiComboBoxOptionsList', position ? positionToClassNameMap[position] : '', {
        'euiComboBoxOptionsList--fullWidth': fullWidth
      });
      return _react.default.createElement(_panel.EuiPanel, (0, _extends2.default)({
        paddingSize: "none",
        className: classes,
        panelRef: this.listRefCallback,
        "data-test-subj": "comboBoxOptionsList ".concat(dataTestSubj),
        style: _objectSpread({}, style, {
          zIndex: zIndex
        })
      }, rest), _react.default.createElement("div", {
        className: "euiComboBoxOptionsList__rowWrap"
      }, emptyState || optionsList));
    }
  }]);
  return EuiComboBoxOptionsList;
}(_react.Component);

exports.EuiComboBoxOptionsList = EuiComboBoxOptionsList;
(0, _defineProperty2.default)(EuiComboBoxOptionsList, "defaultProps", {
  'data-test-subj': '',
  rowHeight: 27 // row height of default option renderer

});
EuiComboBoxOptionsList.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string.isRequired]),
  activeOptionIndex: _propTypes.default.number,
  areAllOptionsSelected: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  getSelectedOptionForSearchValue: _propTypes.default.func,
  isLoading: _propTypes.default.bool,
  listRef: _propTypes.default.any.isRequired,
  matchingOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any
  }).isRequired).isRequired,
  onCloseList: _propTypes.default.func.isRequired,
  onCreateOption: _propTypes.default.func,
  onOptionClick: _propTypes.default.func,
  onOptionEnterKey: _propTypes.default.func,
  onScroll: _propTypes.default.any,
  optionRef: _propTypes.default.func.isRequired,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any
  }).isRequired).isRequired,
  position: _propTypes.default.oneOf(["top", "bottom"]),
  renderOption: _propTypes.default.func,
  rootId: _propTypes.default.any.isRequired,
  rowHeight: _propTypes.default.number.isRequired,
  scrollToIndex: _propTypes.default.number,
  searchValue: _propTypes.default.string.isRequired,
  selectedOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any
  }).isRequired).isRequired,
  updatePosition: _propTypes.default.func.isRequired,
  width: _propTypes.default.number.isRequired,
  singleSelection: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    asPlainText: _propTypes.default.bool
  }).isRequired]),
  delimiter: _propTypes.default.string,
  zIndex: _propTypes.default.number
};
EuiComboBoxOptionsList.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "updatePosition",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "closeListOnScroll",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "listRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiComboBoxOptionsList",
  "props": {
    "data-test-subj": {
      "defaultValue": {
        "value": "''",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "rowHeight": {
      "defaultValue": {
        "value": "27",
        "computed": false
      },
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "activeOptionIndex": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "areAllOptionsSelected": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "fullWidth": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "getSelectedOptionForSearchValue": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "isLoading": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "listRef": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": ""
    },
    "matchingOptions": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            },
            "isGroupLabelOption": {
              "name": "bool",
              "required": false
            },
            "label": {
              "name": "string",
              "required": true
            },
            "options": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "isGroupLabelOption": {
                    "name": "bool",
                    "required": false
                  },
                  "label": {
                    "name": "string",
                    "required": true
                  },
                  "options": {
                    "name": "arrayOf",
                    "value": {
                      "name": "any"
                    },
                    "required": false
                  },
                  "value": {
                    "name": "any",
                    "required": false
                  }
                }
              },
              "required": false
            },
            "value": {
              "name": "any",
              "required": false
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "onCloseList": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "onCreateOption": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onOptionClick": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onOptionEnterKey": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onScroll": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "optionRef": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "options": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            },
            "isGroupLabelOption": {
              "name": "bool",
              "required": false
            },
            "label": {
              "name": "string",
              "required": true
            },
            "options": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "isGroupLabelOption": {
                    "name": "bool",
                    "required": false
                  },
                  "label": {
                    "name": "string",
                    "required": true
                  },
                  "options": {
                    "name": "arrayOf",
                    "value": {
                      "name": "any"
                    },
                    "required": false
                  },
                  "value": {
                    "name": "any",
                    "required": false
                  }
                }
              },
              "required": false
            },
            "value": {
              "name": "any",
              "required": false
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "position": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"top\"",
          "computed": false
        }, {
          "value": "\"bottom\"",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "renderOption": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "rootId": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": ""
    },
    "scrollToIndex": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "searchValue": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "selectedOptions": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            },
            "isGroupLabelOption": {
              "name": "bool",
              "required": false
            },
            "label": {
              "name": "string",
              "required": true
            },
            "options": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "isGroupLabelOption": {
                    "name": "bool",
                    "required": false
                  },
                  "label": {
                    "name": "string",
                    "required": true
                  },
                  "options": {
                    "name": "arrayOf",
                    "value": {
                      "name": "any"
                    },
                    "required": false
                  },
                  "value": {
                    "name": "any",
                    "required": false
                  }
                }
              },
              "required": false
            },
            "value": {
              "name": "any",
              "required": false
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "updatePosition": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "width": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": ""
    },
    "singleSelection": {
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "shape",
          "value": {
            "asPlainText": {
              "name": "bool",
              "required": false
            }
          }
        }]
      },
      "required": false,
      "description": ""
    },
    "delimiter": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "zIndex": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    }
  }
};