/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiCallOut, EuiText } from '@elastic/eui';
import { FormattedMessage, I18nProvider } from '@kbn/i18n/react'; // @ts-ignore

import { FAILURE_REASONS, LOADING_STATUS } from '../../angular/context/query';
export function ContextErrorMessage(_ref) {
  var status = _ref.status,
      reason = _ref.reason;

  if (status !== LOADING_STATUS.FAILED) {
    return null;
  }

  return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(EuiCallOut, {
    title: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.context.failedToLoadAnchorDocumentDescription",
      defaultMessage: "Failed to load the anchor document"
    }),
    color: "danger",
    iconType: "alert",
    "data-test-subj": "contextErrorMessageTitle"
  }, /*#__PURE__*/React.createElement(EuiText, {
    "data-test-subj": "contextErrorMessageBody"
  }, reason === FAILURE_REASONS.UNKNOWN && /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "discover.context.reloadPageDescription.reloadOrVisitTextMessage",
    defaultMessage: "Please reload or go back to the document list to select a valid anchor document."
  }))));
}