function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useEffect } from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiToolTip, EuiText, EuiSelect, EuiIconTip } from '@elastic/eui';
import { I18nProvider } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
export function TimechartHeader(_ref) {
  var from = _ref.from,
      to = _ref.to,
      options = _ref.options,
      onChangeInterval = _ref.onChangeInterval,
      stateInterval = _ref.stateInterval,
      showScaledInfo = _ref.showScaledInfo,
      bucketIntervalDescription = _ref.bucketIntervalDescription,
      bucketIntervalScale = _ref.bucketIntervalScale;

  var _useState = useState(stateInterval),
      _useState2 = _slicedToArray(_useState, 2),
      interval = _useState2[0],
      setInterval = _useState2[1];

  useEffect(function () {
    setInterval(stateInterval);
  }, [stateInterval]);

  var handleIntervalChange = function handleIntervalChange(e) {
    setInterval(e.target.value);
    onChangeInterval(e.target.value);
  };

  return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s",
    responsive: true,
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiToolTip, {
    content: i18n.translate('discover.howToChangeTheTimeTooltip', {
      defaultMessage: 'To change the time, use the global time filter above'
    }),
    delay: "long"
  }, /*#__PURE__*/React.createElement(EuiText, {
    "data-test-subj": "discoverIntervalDateRange",
    size: "s"
  }, "".concat(from, " - ").concat(to, " ").concat(interval !== 'auto' ? i18n.translate('discover.timechartHeader.timeIntervalSelect.per', {
    defaultMessage: 'per'
  }) : '')))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiSelect, {
    "aria-label": i18n.translate('discover.timechartHeader.timeIntervalSelect.ariaLabel', {
      defaultMessage: 'Time interval'
    }),
    compressed: true,
    id: "dscResultsIntervalSelector",
    "data-test-subj": "discoverIntervalSelect",
    options: options.filter(function (_ref2) {
      var val = _ref2.val;
      return val !== 'custom';
    }).map(function (_ref3) {
      var display = _ref3.display,
          val = _ref3.val;
      return {
        text: display,
        value: val,
        label: display
      };
    }),
    value: interval,
    onChange: handleIntervalChange,
    append: showScaledInfo ? /*#__PURE__*/React.createElement(EuiIconTip, {
      id: "discoverIntervalIconTip",
      content: i18n.translate('discover.bucketIntervalTooltip', {
        defaultMessage: 'This interval creates {bucketsDescription} to show in the selected time range, so it has been scaled to {bucketIntervalDescription}.',
        values: {
          bucketsDescription: bucketIntervalScale && bucketIntervalScale > 1 ? i18n.translate('discover.bucketIntervalTooltip.tooLargeBucketsText', {
            defaultMessage: 'buckets that are too large'
          }) : i18n.translate('discover.bucketIntervalTooltip.tooManyBucketsText', {
            defaultMessage: 'too many buckets'
          }),
          bucketIntervalDescription: bucketIntervalDescription
        }
      }),
      color: "warning",
      size: "s",
      type: "alert"
    }) : undefined
  }))));
}