function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { cloneDeep } from 'lodash';
import { AggGroupNames } from '../../../../../data/public';
import { EditorStateActionTypes } from './constants';
import { getEnabledMetricAggsCount } from '../../agg_group_helper';

function initEditorState(vis) {
  return _objectSpread({}, vis.clone());
}

var createEditorStateReducer = function createEditorStateReducer(_ref) {
  var createAggConfigs = _ref.aggs.createAggConfigs;
  return function (state, action) {
    switch (action.type) {
      case EditorStateActionTypes.ADD_NEW_AGG:
        {
          var schema = action.payload.schema;
          var defaultConfig = !state.data.aggs.aggs.find(function (agg) {
            return agg.schema === schema.name;
          }) && schema.defaults ? schema.defaults.slice(0, schema.max) : {
            schema: schema.name
          };
          var aggConfig = state.data.aggs.createAggConfig(defaultConfig, {
            addToAggConfigs: false
          });
          aggConfig.brandNew = true;
          var newAggs = [].concat(_toConsumableArray(state.data.aggs.aggs), [aggConfig]);
          return _objectSpread(_objectSpread({}, state), {}, {
            data: _objectSpread(_objectSpread({}, state.data), {}, {
              aggs: createAggConfigs(state.data.indexPattern, newAggs)
            })
          });
        }

      case EditorStateActionTypes.DISCARD_CHANGES:
        {
          return initEditorState(action.payload);
        }

      case EditorStateActionTypes.CHANGE_AGG_TYPE:
        {
          var _action$payload = action.payload,
              aggId = _action$payload.aggId,
              value = _action$payload.value;

          var _newAggs = state.data.aggs.aggs.map(function (agg) {
            if (agg.id === aggId) {
              agg.type = value;
              return agg.toJSON();
            }

            return agg;
          });

          return _objectSpread(_objectSpread({}, state), {}, {
            data: _objectSpread(_objectSpread({}, state.data), {}, {
              aggs: createAggConfigs(state.data.indexPattern, _newAggs)
            })
          });
        }

      case EditorStateActionTypes.SET_AGG_PARAM_VALUE:
        {
          var _action$payload2 = action.payload,
              _aggId = _action$payload2.aggId,
              paramName = _action$payload2.paramName,
              _value = _action$payload2.value;

          var _newAggs2 = state.data.aggs.aggs.map(function (agg) {
            if (agg.id === _aggId) {
              var parsedAgg = agg.toJSON();
              return _objectSpread(_objectSpread({}, parsedAgg), {}, {
                params: _objectSpread(_objectSpread({}, parsedAgg.params), {}, _defineProperty({}, paramName, _value))
              });
            }

            return agg;
          });

          return _objectSpread(_objectSpread({}, state), {}, {
            data: _objectSpread(_objectSpread({}, state.data), {}, {
              aggs: createAggConfigs(state.data.indexPattern, _newAggs2)
            })
          });
        }

      case EditorStateActionTypes.SET_STATE_PARAM_VALUE:
        {
          var _action$payload3 = action.payload,
              _paramName = _action$payload3.paramName,
              _value2 = _action$payload3.value;
          return _objectSpread(_objectSpread({}, state), {}, {
            params: _objectSpread(_objectSpread({}, state.params), {}, _defineProperty({}, _paramName, _value2))
          });
        }

      case EditorStateActionTypes.REMOVE_AGG:
        {
          var isMetric = false;

          var _newAggs3 = state.data.aggs.aggs.filter(function (_ref2) {
            var id = _ref2.id,
                schema = _ref2.schema;

            if (id === action.payload.aggId) {
              var schemaDef = action.payload.schemas.find(function (s) {
                return s.name === schema;
              });

              if (schemaDef && schemaDef.group === AggGroupNames.Metrics) {
                isMetric = true;
              }

              return false;
            }

            return true;
          });

          if (isMetric && getEnabledMetricAggsCount(_newAggs3) === 0) {
            var aggToEnable = _newAggs3.find(function (agg) {
              return agg.schema === 'metric';
            });

            if (aggToEnable) {
              aggToEnable.enabled = true;
            }
          }

          return _objectSpread(_objectSpread({}, state), {}, {
            data: _objectSpread(_objectSpread({}, state.data), {}, {
              aggs: createAggConfigs(state.data.indexPattern, _newAggs3)
            })
          });
        }

      case EditorStateActionTypes.REORDER_AGGS:
        {
          var _action$payload4 = action.payload,
              sourceAgg = _action$payload4.sourceAgg,
              destinationAgg = _action$payload4.destinationAgg;
          var destinationIndex = state.data.aggs.aggs.indexOf(destinationAgg);

          var _newAggs4 = _toConsumableArray(state.data.aggs.aggs);

          _newAggs4.splice(destinationIndex, 0, _newAggs4.splice(state.data.aggs.aggs.indexOf(sourceAgg), 1)[0]);

          return _objectSpread(_objectSpread({}, state), {}, {
            data: _objectSpread(_objectSpread({}, state.data), {}, {
              aggs: createAggConfigs(state.data.indexPattern, _newAggs4)
            })
          });
        }

      case EditorStateActionTypes.TOGGLE_ENABLED_AGG:
        {
          var _action$payload5 = action.payload,
              _aggId2 = _action$payload5.aggId,
              enabled = _action$payload5.enabled;

          var _newAggs5 = state.data.aggs.aggs.map(function (agg) {
            if (agg.id === _aggId2) {
              var parsedAgg = agg.toJSON();
              return _objectSpread(_objectSpread({}, parsedAgg), {}, {
                enabled: enabled
              });
            }

            return agg;
          });

          return _objectSpread(_objectSpread({}, state), {}, {
            data: _objectSpread(_objectSpread({}, state.data), {}, {
              aggs: createAggConfigs(state.data.indexPattern, _newAggs5)
            })
          });
        }

      case EditorStateActionTypes.UPDATE_STATE_PARAMS:
        {
          var params = action.payload.params;
          return _objectSpread(_objectSpread({}, state), {}, {
            params: cloneDeep(params)
          });
        }
    }
  };
};

export { createEditorStateReducer, initEditorState };