"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var colors_1 = require("./colors");
var theme_commons_1 = require("./theme_commons");
exports.DARK_THEME = {
    chartPaddings: theme_commons_1.DEFAULT_CHART_PADDING,
    chartMargins: theme_commons_1.DEFAULT_CHART_MARGINS,
    lineSeriesStyle: {
        line: {
            visible: true,
            strokeWidth: 1,
            opacity: 1,
        },
        point: {
            visible: true,
            strokeWidth: 1,
            fill: 'black',
            radius: 2,
            opacity: 1,
        },
    },
    bubbleSeriesStyle: {
        point: {
            visible: true,
            strokeWidth: 1,
            fill: 'black',
            radius: 2,
            opacity: 1,
        },
    },
    areaSeriesStyle: {
        area: {
            visible: true,
            opacity: 0.3,
        },
        line: {
            visible: true,
            strokeWidth: 1,
            opacity: 1,
        },
        point: {
            visible: false,
            fill: 'black',
            strokeWidth: 0.5,
            radius: 1,
            opacity: 1,
        },
    },
    barSeriesStyle: {
        rect: {
            opacity: 1,
        },
        rectBorder: {
            visible: false,
            strokeWidth: 0,
        },
        displayValue: {
            fontSize: 8,
            fontStyle: 'normal',
            fontFamily: 'sans-serif',
            padding: 0,
            fill: '#999',
            offsetX: 0,
            offsetY: 0,
        },
    },
    arcSeriesStyle: {
        arc: {
            visible: true,
            stroke: 'white',
            strokeWidth: 1,
            opacity: 1,
        },
    },
    sharedStyle: theme_commons_1.DEFAULT_GEOMETRY_STYLES,
    scales: {
        barsPadding: 0.25,
        histogramPadding: 0.05,
    },
    axes: {
        axisTitleStyle: {
            fontSize: 12,
            fontStyle: 'bold',
            fontFamily: 'sans-serif',
            padding: 8,
            fill: '#D4D4D4',
        },
        axisLineStyle: {
            stroke: '#444',
            strokeWidth: 1,
        },
        tickLabelStyle: {
            fontSize: 10,
            fontFamily: 'sans-serif',
            fontStyle: 'normal',
            fill: '#999',
            padding: 1,
        },
        tickLineStyle: {
            visible: true,
            stroke: '#444',
            strokeWidth: 1,
        },
        gridLineStyle: {
            horizontal: {
                visible: true,
                stroke: '#D3DAE6',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
            vertical: {
                visible: true,
                stroke: '#D3DAE6',
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
        },
    },
    colors: {
        vizColors: colors_1.palettes.echPaletteColorBlind.colors,
        defaultVizColor: theme_commons_1.DEFAULT_MISSING_COLOR,
    },
    legend: {
        verticalWidth: 200,
        horizontalHeight: 64,
        spacingBuffer: 10,
    },
    crosshair: {
        band: {
            fill: '#2A2A2A',
            visible: true,
        },
        line: {
            stroke: '#999',
            strokeWidth: 1,
            dash: [5, 5],
            visible: true,
        },
    },
    background: {
        color: 'transparent',
    },
};
//# sourceMappingURL=dark_theme.js.map