
/**
 * Kibana entry file
 *
 * This is programmatically created and updated, do not modify
 *
 * Any changes to this file should be kept in sync with
 * src/core/public/entry_point.ts
 *
 * context: {
  "appExtensions": {
    "hacks": [
      "absolute:src/legacy/core_plugins/timelion/public/legacy"
    ]
  },
  "buildNum": 33912,
  "env": "production",
  "kbnVersion": "7.9.1"
}
 */


import { i18n } from '@kbn/i18n';
import { CoreSystem } from '__kibanaCore__'

const injectedMetadata = JSON.parse(document.querySelector('kbn-injected-metadata').getAttribute('data'));



i18n.load(injectedMetadata.i18n.translationsUrl)
  .catch(e => e)
  .then((i18nError) => {
    const coreSystem = new CoreSystem({
      injectedMetadata,
      rootDomElement: document.body,
      browserSupportsCsp: !window.__kbnCspNotEnforced__,
      requireLegacyFiles: () => {
        require('plugins/status_page/status_page');
      },
      requireLegacyBootstrapModule: () => require('ui/chrome'),
      requireNewPlatformShimModule: () => require('ui/new_platform'),
    });

    coreSystem
      .setup()
      .then((coreSetup) => {
        if (i18nError) {
          coreSetup.fatalErrors.add(i18nError);
        }

        return coreSystem.start();
      });
  });
