function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export var executeScript = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
    var name, lang, script, indexPatternTitle, query, _ref$additionalFields, additionalFields, http, header, search, body, esResp;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            name = _ref.name, lang = _ref.lang, script = _ref.script, indexPatternTitle = _ref.indexPatternTitle, query = _ref.query, _ref$additionalFields = _ref.additionalFields, additionalFields = _ref$additionalFields === void 0 ? [] : _ref$additionalFields, http = _ref.http;
            // Using _msearch because _search with index name in path dorks everything up
            header = {
              index: indexPatternTitle,
              ignore_unavailable: true
            };
            search = {
              query: {
                match_all: {}
              },
              script_fields: _defineProperty({}, name, {
                script: {
                  lang: lang,
                  source: script
                }
              }),
              _source: undefined,
              size: 10,
              timeout: '30s'
            };

            if (additionalFields.length > 0) {
              search._source = additionalFields;
            }

            if (query) {
              search.query = query;
            }

            body = "".concat(JSON.stringify(header), "\n").concat(JSON.stringify(search), "\n");
            _context.next = 8;
            return http.fetch('/elasticsearch/_msearch', {
              method: 'POST',
              body: body
            });

          case 8:
            esResp = _context.sent;
            return _context.abrupt("return", esResp.responses[0]);

          case 10:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function executeScript(_x) {
    return _ref2.apply(this, arguments);
  };
}();
export var isScriptValid = /*#__PURE__*/function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(_ref3) {
    var name, lang, script, indexPatternTitle, http, scriptResponse;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            name = _ref3.name, lang = _ref3.lang, script = _ref3.script, indexPatternTitle = _ref3.indexPatternTitle, http = _ref3.http;
            _context2.next = 3;
            return executeScript({
              name: name,
              lang: lang,
              script: script,
              indexPatternTitle: indexPatternTitle,
              http: http
            });

          case 3:
            scriptResponse = _context2.sent;

            if (!(scriptResponse.status !== 200)) {
              _context2.next = 6;
              break;
            }

            return _context2.abrupt("return", false);

          case 6:
            return _context2.abrupt("return", true);

          case 7:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));

  return function isScriptValid(_x2) {
    return _ref4.apply(this, arguments);
  };
}();