function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import { EuiContextMenuItem, EuiContextMenuPanel, EuiEmptyPrompt, EuiFieldSearch, EuiFilterButton, EuiFilterGroup, EuiFlexGroup, EuiFlexItem, EuiListGroup, EuiListGroupItem, EuiLoadingSpinner, EuiPagination, EuiPopover, EuiSpacer, EuiTablePagination } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { LISTING_LIMIT_SETTING } from '../../common';

var SavedObjectFinderUi = /*#__PURE__*/function (_React$Component) {
  _inherits(SavedObjectFinderUi, _React$Component);

  var _super = _createSuper(SavedObjectFinderUi);

  function SavedObjectFinderUi(props) {
    var _this;

    _classCallCheck(this, SavedObjectFinderUi);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "isComponentMounted", false);

    _defineProperty(_assertThisInitialized(_this), "debouncedFetch", _.debounce( /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(query) {
        var metaDataMap, fields, perPage, resp;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                metaDataMap = _this.getSavedObjectMetaDataMap();
                fields = Object.values(metaDataMap).map(function (metaData) {
                  return metaData.includeFields || [];
                }).reduce(function (allFields, currentFields) {
                  return allFields.concat(currentFields);
                }, ['title']);
                perPage = _this.props.uiSettings.get(LISTING_LIMIT_SETTING);
                _context.next = 5;
                return _this.props.savedObjects.client.find({
                  type: Object.keys(metaDataMap),
                  fields: _toConsumableArray(new Set(fields)),
                  search: query ? "".concat(query, "*") : undefined,
                  page: 1,
                  perPage: perPage,
                  searchFields: ['title^3', 'description'],
                  defaultSearchOperator: 'AND'
                });

              case 5:
                resp = _context.sent;
                resp.savedObjects = resp.savedObjects.filter(function (savedObject) {
                  var metaData = metaDataMap[savedObject.type];

                  if (metaData.showSavedObject) {
                    return metaData.showSavedObject(savedObject);
                  } else {
                    return true;
                  }
                });

                if (_this.isComponentMounted) {
                  _context.next = 9;
                  break;
                }

                return _context.abrupt("return");

              case 9:
                // We need this check to handle the case where search results come back in a different
                // order than they were sent out. Only load results for the most recent search.
                if (query === _this.state.query) {
                  _this.setState({
                    isFetchingItems: false,
                    page: 0,
                    items: resp.savedObjects.map(function (savedObject) {
                      var title = savedObject.attributes.title,
                          id = savedObject.id,
                          type = savedObject.type;
                      return {
                        title: typeof title === 'string' ? title : '',
                        id: id,
                        type: type,
                        savedObject: savedObject
                      };
                    })
                  });
                }

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }(), 300));

    _defineProperty(_assertThisInitialized(_this), "getPageOfItems", function () {
      // do not sort original list to preserve elasticsearch ranking order
      var items = _this.state.items.slice();

      var sortDirection = _this.state.sortDirection;

      if (sortDirection || !_this.state.query) {
        items.sort(function (_ref2, _ref3) {
          var titleA = _ref2.title;
          var titleB = _ref3.title;
          var order = 1;

          if (sortDirection === 'desc') {
            order = -1;
          }

          return order * (titleA || '').toLowerCase().localeCompare((titleB || '').toLowerCase());
        });
      } // If begin is greater than the length of the sequence, an empty array is returned.


      var startIndex = _this.state.page * _this.state.perPage; // If end is greater than the length of the sequence, slice extracts through to the end of the sequence (arr.length).

      var lastIndex = startIndex + _this.state.perPage;
      return items.filter(function (item) {
        return _this.state.filteredTypes.length === 0 || _this.state.filteredTypes.includes(item.type);
      }).slice(startIndex, lastIndex);
    });

    _defineProperty(_assertThisInitialized(_this), "fetchItems", function () {
      _this.setState({
        isFetchingItems: true
      }, _this.debouncedFetch.bind(null, _this.state.query));
    });

    _this.state = {
      items: [],
      isFetchingItems: false,
      page: 0,
      perPage: props.initialPageSize || props.fixedPageSize || 10,
      query: '',
      filterOpen: false,
      filteredTypes: [],
      sortOpen: false
    };
    return _this;
  }

  _createClass(SavedObjectFinderUi, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.isComponentMounted = false;
      this.debouncedFetch.cancel();
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.isComponentMounted = true;
      this.fetchItems();
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(React.Fragment, null, this.renderSearchBar(), this.renderListing());
    }
  }, {
    key: "getSavedObjectMetaDataMap",
    value: function getSavedObjectMetaDataMap() {
      return this.props.savedObjectMetaData.reduce(function (map, metaData) {
        return _objectSpread(_objectSpread({}, map), {}, _defineProperty({}, metaData.type, metaData));
      }, {});
    }
  }, {
    key: "getPageCount",
    value: function getPageCount() {
      var _this2 = this;

      return Math.ceil((this.state.filteredTypes.length === 0 ? this.state.items.length : this.state.items.filter(function (item) {
        return _this2.state.filteredTypes.length === 0 || _this2.state.filteredTypes.includes(item.type);
      }).length) / this.state.perPage);
    } // server-side paging not supported
    // 1) saved object client does not support sorting by title because title is only mapped as analyzed
    // 2) can not search on anything other than title because all other fields are stored in opaque JSON strings,
    //    for example, visualizations need to be search by isLab but this is not possible in Elasticsearch side
    //    with the current mappings

  }, {
    key: "getAvailableSavedObjectMetaData",
    value: function getAvailableSavedObjectMetaData() {
      var typesInItems = new Set();
      this.state.items.forEach(function (item) {
        typesInItems.add(item.type);
      });
      return this.props.savedObjectMetaData.filter(function (metaData) {
        return typesInItems.has(metaData.type);
      });
    }
  }, {
    key: "getSortOptions",
    value: function getSortOptions() {
      var _this3 = this;

      var sortOptions = [/*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: "asc",
        icon: this.state.sortDirection === 'asc' || this.state.query === '' && this.state.sortDirection !== 'desc' ? 'check' : 'empty',
        onClick: function onClick() {
          _this3.setState({
            sortDirection: 'asc'
          });
        }
      }, i18n.translate('savedObjects.finder.sortAsc', {
        defaultMessage: 'Ascending'
      })), /*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: "desc",
        icon: this.state.sortDirection === 'desc' ? 'check' : 'empty',
        onClick: function onClick() {
          _this3.setState({
            sortDirection: 'desc'
          });
        }
      }, i18n.translate('savedObjects.finder.sortDesc', {
        defaultMessage: 'Descending'
      }))];

      if (this.state.query) {
        sortOptions.push( /*#__PURE__*/React.createElement(EuiContextMenuItem, {
          key: "auto",
          icon: !this.state.sortDirection ? 'check' : 'empty',
          onClick: function onClick() {
            _this3.setState({
              sortDirection: undefined
            });
          }
        }, i18n.translate('savedObjects.finder.sortAuto', {
          defaultMessage: 'Best match'
        })));
      }

      return sortOptions;
    }
  }, {
    key: "renderSearchBar",
    value: function renderSearchBar() {
      var _this4 = this;

      var availableSavedObjectMetaData = this.getAvailableSavedObjectMetaData();
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        gutterSize: "m"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: true
      }, /*#__PURE__*/React.createElement(EuiFieldSearch, {
        placeholder: i18n.translate('savedObjects.finder.searchPlaceholder', {
          defaultMessage: 'Search…'
        }),
        "aria-label": i18n.translate('savedObjects.finder.searchPlaceholder', {
          defaultMessage: 'Search…'
        }),
        fullWidth: true,
        value: this.state.query,
        onChange: function onChange(e) {
          _this4.setState({
            query: e.target.value
          }, _this4.fetchItems);
        },
        "data-test-subj": "savedObjectFinderSearchInput",
        isLoading: this.state.isFetchingItems
      })), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiFilterGroup, null, /*#__PURE__*/React.createElement(EuiPopover, {
        id: "addPanelSortPopover",
        panelClassName: "euiFilterGroup__popoverPanel",
        panelPaddingSize: "none",
        isOpen: this.state.sortOpen,
        closePopover: function closePopover() {
          return _this4.setState({
            sortOpen: false
          });
        },
        button: /*#__PURE__*/React.createElement(EuiFilterButton, {
          onClick: function onClick() {
            return _this4.setState(function (_ref4) {
              var sortOpen = _ref4.sortOpen;
              return {
                sortOpen: !sortOpen
              };
            });
          },
          iconType: "arrowDown",
          isSelected: this.state.sortOpen,
          "data-test-subj": "savedObjectFinderSortButton"
        }, i18n.translate('savedObjects.finder.sortButtonLabel', {
          defaultMessage: 'Sort'
        }))
      }, /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
        watchedItemProps: ['icon', 'disabled'],
        items: this.getSortOptions()
      })), this.props.showFilter && /*#__PURE__*/React.createElement(EuiPopover, {
        id: "addPanelFilterPopover",
        panelClassName: "euiFilterGroup__popoverPanel",
        panelPaddingSize: "none",
        isOpen: this.state.filterOpen,
        closePopover: function closePopover() {
          return _this4.setState({
            filterOpen: false
          });
        },
        button: /*#__PURE__*/React.createElement(EuiFilterButton, {
          onClick: function onClick() {
            return _this4.setState(function (_ref5) {
              var filterOpen = _ref5.filterOpen;
              return {
                filterOpen: !filterOpen
              };
            });
          },
          iconType: "arrowDown",
          "data-test-subj": "savedObjectFinderFilterButton",
          isSelected: this.state.filterOpen,
          numFilters: this.props.savedObjectMetaData.length,
          hasActiveFilters: this.state.filteredTypes.length > 0,
          numActiveFilters: this.state.filteredTypes.length
        }, i18n.translate('savedObjects.finder.filterButtonLabel', {
          defaultMessage: 'Types'
        }))
      }, /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
        watchedItemProps: ['icon', 'disabled'],
        items: this.props.savedObjectMetaData.map(function (metaData) {
          return /*#__PURE__*/React.createElement(EuiContextMenuItem, {
            key: metaData.type,
            disabled: !availableSavedObjectMetaData.includes(metaData),
            icon: _this4.state.filteredTypes.includes(metaData.type) ? 'check' : 'empty',
            "data-test-subj": "savedObjectFinderFilter-".concat(metaData.type),
            onClick: function onClick() {
              _this4.setState(function (_ref6) {
                var filteredTypes = _ref6.filteredTypes;
                return {
                  filteredTypes: filteredTypes.includes(metaData.type) ? filteredTypes.filter(function (t) {
                    return t !== metaData.type;
                  }) : [].concat(_toConsumableArray(filteredTypes), [metaData.type]),
                  page: 0
                };
              });
            }
          }, metaData.name);
        })
      })))), this.props.children ? /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, this.props.children) : null);
    }
  }, {
    key: "renderListing",
    value: function renderListing() {
      var _this5 = this;

      var items = this.state.items.length === 0 ? [] : this.getPageOfItems();
      var _this$props = this.props,
          onChoose = _this$props.onChoose,
          savedObjectMetaData = _this$props.savedObjectMetaData;
      return /*#__PURE__*/React.createElement(React.Fragment, null, this.state.isFetchingItems && this.state.items.length === 0 && /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "center"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiSpacer, null), /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
        "data-test-subj": "savedObjectFinderLoadingIndicator"
      }))), items.length > 0 ? /*#__PURE__*/React.createElement(EuiListGroup, {
        "data-test-subj": "savedObjectFinderItemList",
        maxWidth: false
      }, items.map(function (item) {
        var currentSavedObjectMetaData = savedObjectMetaData.find(function (metaData) {
          return metaData.type === item.type;
        });
        var fullName = currentSavedObjectMetaData.getTooltipForSavedObject ? currentSavedObjectMetaData.getTooltipForSavedObject(item.savedObject) : "".concat(item.title, " (").concat(currentSavedObjectMetaData.name, ")");
        var iconType = (currentSavedObjectMetaData || {
          getIconForSavedObject: function getIconForSavedObject() {
            return 'document';
          }
        }).getIconForSavedObject(item.savedObject);
        return /*#__PURE__*/React.createElement(EuiListGroupItem, {
          key: item.id,
          iconType: iconType,
          label: item.title,
          onClick: onChoose ? function () {
            onChoose(item.id, item.type, fullName, item.savedObject);
          } : undefined,
          title: fullName,
          "data-test-subj": "savedObjectTitle".concat((item.title || '').split(' ').join('-'))
        });
      })) : !this.state.isFetchingItems && /*#__PURE__*/React.createElement(EuiEmptyPrompt, {
        body: this.props.noItemsMessage
      }), this.getPageCount() > 1 && (this.props.fixedPageSize ? /*#__PURE__*/React.createElement(EuiPagination, {
        activePage: this.state.page,
        pageCount: this.getPageCount(),
        onPageClick: function onPageClick(page) {
          _this5.setState({
            page: page
          });
        }
      }) : /*#__PURE__*/React.createElement(EuiTablePagination, {
        activePage: this.state.page,
        pageCount: this.getPageCount(),
        onChangePage: function onChangePage(page) {
          _this5.setState({
            page: page
          });
        },
        onChangeItemsPerPage: function onChangeItemsPerPage(perPage) {
          _this5.setState({
            perPage: perPage
          });
        },
        itemsPerPage: this.state.perPage,
        itemsPerPageOptions: [5, 10, 15, 25]
      })));
    }
  }]);

  return SavedObjectFinderUi;
}(React.Component);

_defineProperty(SavedObjectFinderUi, "propTypes", {
  onChoose: PropTypes.func,
  noItemsMessage: PropTypes.node,
  savedObjectMetaData: PropTypes.array.isRequired,
  initialPageSize: PropTypes.oneOf([5, 10, 15, 25]),
  fixedPageSize: PropTypes.number,
  showFilter: PropTypes.bool
});

var getSavedObjectFinder = function getSavedObjectFinder(savedObject, uiSettings) {
  return function (props) {
    return /*#__PURE__*/React.createElement(SavedObjectFinderUi, _extends({}, props, {
      savedObjects: savedObject,
      uiSettings: uiSettings
    }));
  };
};

export { getSavedObjectFinder, SavedObjectFinderUi };