function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { VisualizeEmbeddable } from './visualize_embeddable';
import { ErrorEmbeddable } from '../../../../plugins/embeddable/public';
import { DisabledLabEmbeddable } from './disabled_lab_embeddable';
import { getSavedVisualizationsLoader, getUISettings, getHttp, getTimeFilter, getCapabilities } from '../services';
import { VISUALIZE_ENABLE_LABS_SETTING } from '../../common/constants';
export var createVisEmbeddableFromObject = function createVisEmbeddableFromObject(deps) {
  return /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(vis, input, parent) {
      var savedVisualizations, visId, editPath, editUrl, isLabsEnabled, indexPattern, indexPatterns, editable;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              savedVisualizations = getSavedVisualizationsLoader();
              _context.prev = 1;
              visId = vis.id;
              editPath = visId ? savedVisualizations.urlFor(visId) : '';
              editUrl = visId ? getHttp().basePath.prepend("/app/visualize".concat(savedVisualizations.urlFor(visId))) : '';
              isLabsEnabled = getUISettings().get(VISUALIZE_ENABLE_LABS_SETTING);

              if (!(!isLabsEnabled && vis.type.stage === 'experimental')) {
                _context.next = 8;
                break;
              }

              return _context.abrupt("return", new DisabledLabEmbeddable(vis.title, input));

            case 8:
              indexPattern = vis.data.indexPattern;
              indexPatterns = indexPattern ? [indexPattern] : [];
              editable = getCapabilities().visualize.save;
              return _context.abrupt("return", new VisualizeEmbeddable(getTimeFilter(), {
                vis: vis,
                indexPatterns: indexPatterns,
                editPath: editPath,
                editUrl: editUrl,
                editable: editable,
                deps: deps
              }, input, parent));

            case 14:
              _context.prev = 14;
              _context.t0 = _context["catch"](1);
              console.error(_context.t0); // eslint-disable-line no-console

              return _context.abrupt("return", new ErrorEmbeddable(_context.t0, input, parent));

            case 18:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[1, 14]]);
    }));

    return function (_x, _x2, _x3) {
      return _ref.apply(this, arguments);
    };
  }();
};