#! /usr/bin/perl

# ex:ts=8 sw=4:
# $OpenBSD: Quirks.pm,v 1.1257.2.1 2021/05/21 17:52:42 bket Exp $
#
# Copyright (c) 2009 Marc Espie <espie@openbsd.org>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

use strict;
use warnings;
use OpenBSD::PackageName;

package OpenBSD::Quirks;

sub new
{
	my ($class, $version) = @_;
	if ($version == 1 || $version == 2 || $version == 3) {
		return OpenBSD::Quirks3->new;
	} else {
		return undef;
	}
}

package OpenBSD::Quirks3;
use Config;
sub new
{
	my $class = shift;

	bless {}, $class;
}


# ->tweak_list(\@l, $state):
#	allows Quirks to do anything to the list of packages to install,
#	if something is needed. Usually, it won't do anything
sub tweak_list
{
}

# packages to remove
# stem => existing file   hash table
#	if file exists, then it's now in base and we can remove it.

my $p5a = $Config{archlib};
my $p5 = "/usr/libdata/perl5";
my $base_exceptions = {
# 5.6
	'unbound' => '/usr/sbin/unbound',
# 5.7
	'p5-IO-Socket-IP' => "$p5/IO/Socket/IP.pm",
# 5.8
	'libepoxy' => '/usr/X11R6/lib/libepoxy.so.*',
	'flex' => '/usr/bin/flex',
# 6.0
	'p5-Term-ReadKey' => "$p5a/Term/ReadKey.pm",
# 6.2
	'p5-Test-use-ok' => "$p5/Test/use/ok.pm",
	'p5-Test-Tester' => "$p5/Test/Tester.pm",
# 6.5
	'libelf' => '/usr/lib/libelf.so.*',
# 6.9
	'acme-client' => '/usr/sbin/acme-client',
};

my $stem_extensions = {
# 5.6
	'p5-Class-MOP' => 'p5-Moose',
	'libproxy-mozilla' => 'libproxy-webkit',
	'p5-Mozilla-CA' => 'p5-Mozilla-CA-Fake',
	'gnome-extra' => 'gnome-extras',
	'py-Imaging' => 'py-Pillow',
	'p5-Nagios-Plugin' => 'p5-Monitoring-Plugin',
	'nagios-plugins' => 'monitoring-plugins',
	'nagios-plugins-fping' => 'monitoring-plugins-fping',
	'nagios-plugins-game' => 'monitoring-plugins-game',
	'nagios-plugins-ntp' => 'monitoring-plugins', # merged to -main
	'nagios-plugins-samba' => 'monitoring-plugins-samba',
	'nagios-plugins-snmp' => 'monitoring-plugins-snmp',
	'nagios-plugins-dbi' => 'monitoring-plugins-dbi',
	'nagios-plugins-ldap' => 'monitoring-plugins-ldap',
	'nagios-plugins-mysql' => 'monitoring-plugins-mysql',
	'nagios-plugins-pgsql' => 'monitoring-plugins-pgsql',
	'kdnssd' => 'zeroconf-ioslave',
	'kwallet' => 'kwalletmanager',
	'p5-TAP-Parser' => 'p5-Test-Harness',
# 5.7
	'qlandkarte' => 'qlandkartegt',
	'mysql-client' => 'mariadb-client',
	'mysql-server' => 'mariadb-server',
	'mysql-tests' => 'mariadb-tests',
	'py3-distribute' => 'py3-setuptools',
	'symon-mon' => 'symon',
	'symon-mux' => 'symux',
	'ruby-dbus' => 'ruby21-dbus',
	'polarssl' => 'mbedtls',
	'mscore' => 'musescore',
# 5.8
	'california' => 'calendar',
	'ipv6-toolkit' => 'ipv6toolkit',
	'p5-Search-Xapian' => 'xapian-bindings-perl',
	'ruby-archive-tar-minitar' => 'ruby-minitar',
	'racket' => 'racket-minimal',
	'ruby-passenger-standalone' => 'ruby-passenger',
	'ruby19-passenger-standalone' => 'ruby19-passenger',
	'ruby20-passenger-standalone' => 'ruby20-passenger',
	'ruby21-passenger-standalone' => 'ruby21-passenger',
	'ruby22-passenger-standalone' => 'ruby22-passenger',
	'mirall' => 'owncloudclient',
# 5.9
	'consolekit' => 'consolekit2',
	'tint' => 'tint2',
	'py-nmap' => 'py3-nmap',
	'pudb' => 'py-pudb',
	'openexr-ctl' => 'ctl',
	'nimrod' => 'nim',
	'icinga2-mysql' => 'icinga2-ido-mysql',
	'icinga2-pgsql' => 'icinga2-ido-pgsql',
	'rcsparse' => 'py-rcsparse',
	'tesseract-dan-frak' => 'tesseract-dan_frak',
	'grive' => 'grive2',
	'py-reportlab-renderPM' => 'py-reportlab',
	'cmus-flac' => 'cmus',
	'cmus-wavpack' => 'cmus',
	'quake2' => 'yquake2',
	'apertium-es-an' => 'apertium-spa-arg',
	'apertium-nn-nb' => 'apertium-nno-nob',
	'weblint' => 'p5-HTML-Lint',
	'py-fabric' => 'fabric',
# 6.0
	'cosmic-sans-neue-mono' => 'fantasque-sans',
	'droid-fonts' => 'noto-fonts',
	'py-logilab-astng' => 'py-astroid',
	'apache-httpd-openbsd' => 'apache-httpd',
	'openmotif' => 'motif',
	'go-websocket' => 'go-net',
	'letsencrypt' => 'certbot',
# 6.1
	'zarafa-webaccess' => 'zarafa-mapi',
	'railo' => 'lucee',
	'radare-bindings2' => 'radare2-bindings',
	'py-httpie' => 'httpie',
	'py-ripe.atlas.tools' => 'ripe.atlas.tools',
	'u-boot' => 'u-boot-arm',
	'ja-w3m' => 'w3m',
	'markdown' => 'py-markdown',
	'netperf-wrapper' => 'flent',
	'kamailio-xmlrpc' => 'kamailio-xml',
# 6.2
	'qt3d-html' => 'qt5-html',
	'qtactiveqt-html' => 'qt5-html',
	'qtbase-html' => 'qt5-html',
	'qtcanvas3d-html' => 'qt5-html',
	'qtcharts-html' => 'qt5-html',
	'qtconnectivity-html' => 'qt5-html',
	'qtdatavis3d-html' => 'qt5-html',
	'qtdeclarative-html' => 'qt5-html',
	'qtdoc-html' => 'qt5-html',
	'qtgamepad-html' => 'qt5-html',
	'qtgraphicaleffects-html' => 'qt5-html',
	'qtimageformats-html' => 'qt5-html',
	'qtlocation-html' => 'qt5-html',
	'qtmultimedia-html' => 'qt5-html',
	'qtnetworkauth-html' => 'qt5-html',
	'qtpurchasing-html' => 'qt5-html',
	'qtquickcontrols-html' => 'qt5-html',
	'qtquickcontrols2-html' => 'qt5-html',
	'qtremoteobjects-html' => 'qt5-html',
	'qtscript-html' => 'qt5-html',
	'qtscxml-html' => 'qt5-html',
	'qtsensors-html' => 'qt5-html',
	'qtserialbus-html' => 'qt5-html',
	'qtserialport-html' => 'qt5-html',
	'qtspeech-html' => 'qt5-html',
	'qtsvg-html' => 'qt5-html',
	'qtvirtualkeyboard-html' => 'qt5-html',
	'qtwebchannel-html' => 'qt5-html',
	'qtwebkit-html' => 'qt5-html',
	'qtwebsockets-html' => 'qt5-html',
	'qtx11extras-html' => 'qt5-html',
	'qtxmlpatterns-html' => 'qt5-html',

	'qt3d-qch' => 'qt5-qch',
	'qtactiveqt-qch' => 'qt5-qch',
	'qtbase-qch' => 'qt5-qch',
	'qtcanvas3d-qch' => 'qt5-qch',
	'qtcharts-qch' => 'qt5-qch',
	'qtconnectivity-qch' => 'qt5-qch',
	'qtdatavis3d-qch' => 'qt5-qch',
	'qtdeclarative-qch' => 'qt5-qch',
	'qtdoc-qch' => 'qt5-qch',
	'qtgamepad-qch' => 'qt5-qch',
	'qtgraphicaleffects-qch' => 'qt5-qch',
	'qtimageformats-qch' => 'qt5-qch',
	'qtlocation-qch' => 'qt5-qch',
	'qtmultimedia-qch' => 'qt5-qch',
	'qtnetworkauth-qch' => 'qt5-qch',
	'qtpurchasing-qch' => 'qt5-qch',
	'qtquickcontrols-qch' => 'qt5-qch',
	'qtquickcontrols2-qch' => 'qt5-qch',
	'qtremoteobjects-qch' => 'qt5-qch',
	'qtscript-qch' => 'qt5-qch',
	'qtscxml-qch' => 'qt5-qch',
	'qtsensors-qch' => 'qt5-qch',
	'qtserialbus-qch' => 'qt5-qch',
	'qtserialport-qch' => 'qt5-qch',
	'qtspeech-qch' => 'qt5-qch',
	'qtsvg-qch' => 'qt5-qch',
	'qtvirtualkeyboard-qch' => 'qt5-qch',
	'qtwebchannel-qch' => 'qt5-qch',
	'qtwebkit-qch' => 'qt5-qch',
	'qtwebsockets-qch' => 'qt5-qch',
	'qtx11extras-qch' => 'qt5-qch',
	'qtxmlpatterns-qch' => 'qt5-qch',
	'cargo' => 'rust',
	'apertium-fr-ca' => 'apertium-fra-cat',
	'py-doit' => 'doit',
	'cython' => 'py-cython',

	'zarafa' => 'kopano-core',
	'zarafa-mapi' => 'kopano-mapi',
	'zarafa-webapp' => 'kopano-webapp',
	'extract_url' => 'extracturl',
# 6.3
	'ruby-arirang' => 'arirang',
	'ja-mplus-ttf' => 'mixfont-mplus-ipa',
	'kdirstat' => 'qdirstat',
	'stem' => 'py-stem',
	'arm' => 'nyx',
	'luabitop' => 'lua-bitop',
	'livestreamer' => 'streamlink',
	'newsbeuter' => 'newsboat',
	'php-fastcgi' => 'php-cgi',
	'advancemess' => 'advancemame',
# 6.4
	'gnome-tweak-tool' => 'gnome-tweaks',
	'latexila' => 'gnome-latex',
	'osh' => 'etsh',
	'gnome-themes-standard' => 'gnome-themes-extra',
	'open-cobol' => 'gnucobol',
	'fanstasque-sans' => 'fantasque-sans',
	'rope' => 'py-rope',
	'py-upt-rubygems' => 'upt-rubygems',
	'pygame' => 'py-game',
	'py-cryptodomex' => 'py-cryptodome',
	'py3-cryptodomex' => 'py3-cryptodome',
	'py-crypto' => 'py-cryptodome',
	'py3-crypto' => 'py3-cryptodome',
	'py-link-grammar' => 'py3-link-grammar',
	'py-buildbot' => 'buildbot',
	'py-buildbot-www' => 'py3-buildbot-www',
	'py-buildbot-pkg' => 'py3-buildbot-pkg',
	'py-buildbot-grid-view' => 'py3-buildbot-grid-view',
	'py-buildbot-console-view' => 'py3-buildbot-console-view',
	'py-buildbot-waterfall-view' => 'py3-buildbot-waterfall-view',
	'py-buildslave' => 'buildbot-worker',
	'sdlmame' => 'mame',
	'sdlmame-tools' => 'mame',
	'sdlmess' => 'mame',
	'suricata-update' => 'suricata',
# 6.5
	'ValyriaTear' => 'valyriatear',
	'apertium-es-ast_NO-PN' => 'apertium-es-ast',
	'py-pafy' => 'py3-pafy',
	'py-libmagic' => 'py-magic',
	'py3-libmagic' => 'py3-magic',
	'pecl-chroot' => 'pecl71-chroot',
	'pecl-geoip' => 'pecl71-geoip',
	'pecl-http' => 'pecl71-pecl_http',
	'pecl-imagick' => 'pecl71-imagick',
	'pecl-libsodium' => 'pecl71-libsodium',
	'pecl-lzf' => 'pecl71-lzf',
	'pecl-mailparse' => 'pecl71-mailparse',
	'pecl-memcached' => 'pecl71-memcached',
	'pecl-proctitle' => 'pecl71-proctitle',
	'pecl-propro' => 'pecl71-propro',
	'pecl-raphf' => 'pecl71-raphf',
	'pecl-rar' => 'pecl71-rar',
	'pecl-redis' => 'pecl71-redis',
	'pecl-ssh2' => 'pecl71-ssh2',
	'pecl56-chroot' => 'pecl71-chroot',
	'pecl56-geoip' => 'pecl71-geoip',
	'pecl56-http' => 'pecl71-pecl_http',
	'pecl56-imagick' => 'pecl71-imagick',
	'pecl56-libsodium' => 'pecl71-libsodium',
	'pecl56-lzf' => 'pecl71-lzf',
	'pecl56-mailparse' => 'pecl71-mailparse',
	'pecl56-memcached' => 'pecl71-memcached',
	'pecl56-proctitle' => 'pecl71-proctitle',
	'pecl56-propro' => 'pecl71-propro',
	'pecl56-raphf' => 'pecl71-raphf',
	'pecl56-rar' => 'pecl71-rar',
	'pecl56-redis' => 'pecl71-redis',
	'pecl56-ssh2' => 'pecl71-ssh2',
	'pecl70-chroot' => 'pecl71-chroot',
	'pecl70-geoip' => 'pecl71-geoip',
	'pecl70-http' => 'pecl71-pecl_http',
	'pecl70-imagick' => 'pecl71-imagick',
	'pecl70-libsodium' => 'pecl71-libsodium',
	'pecl70-lzf' => 'pecl71-lzf',
	'pecl70-mailparse' => 'pecl71-mailparse',
	'pecl70-memcached' => 'pecl71-memcached',
	'pecl70-proctitle' => 'pecl71-proctitle',
	'pecl70-propro' => 'pecl71-propro',
	'pecl70-raphf' => 'pecl71-raphf',
	'pecl70-rar' => 'pecl71-rar',
	'pecl70-redis' => 'pecl71-redis',
	'pecl70-ssh2' => 'pecl71-ssh2',
	'zh-bg5ps' => 'bg5ps',
	'zh-bg5pdf' => 'bg5pdf',
	'wxWidgets-gtk2' => 'wxWidgets-gtk3',
	'atf-allwinner' => 'arm-trusted-firmware',
	'u-boot-pinebook' => 'u-boot-aarch64',
	'suricata-update' => 'suricata',
	'wireshark-gtk' => 'wireshark',
	'py-zeroconf' => 'py3-zeroconf',
	'digikam' => 'digikam-kde4',
	'apertium-sv-da' => 'apertium-swe-dan',
# 6.6
	'Xonotic' => 'xonotic',
	'Xonotic-data' => 'xonotic-data',
	'Xonotic-server' => 'xonotic-server',
	'gettext' => 'gettext-runtime',
	'kwebapp' => 'openradtool',
	'py-xmldiff' => 'py3-xmldiff',
	'bro' => 'zeek',
	'filter-rspamd' => 'opensmtpd-filter-rspamd',
	'filter-senderscore' => 'opensmtpd-filter-senderscore',
	'ilmbase' => 'OpenEXR',
	'openexr-viewers' => 'OpenEXR-tools',
	'libvirt-python' => 'py-libvirt',
# 6.7
	'py-jaraco-functoolsjaraco.functools' => 'py-jaraco-functools',
	'py3-jaraco-functoolsjaraco.functools' => 'py3-jaraco-functools',
	'py-netmiko' => 'py3-netmiko',
	'py-napalm' => 'py3-napalm',
	'py-IOSXR' => 'py3-IOSXR',
	'py-cligj' => 'py3-cligj',
	'py-fiona' => 'py3-fiona',
	'py-laspy' => 'py3-laspy',
	'py-owslib' => 'py3-owslib',
	'py-proj' => 'py3-proj',
	'py-planet' => 'py3-planet',
	'py-rasterio' => 'py3-rasterio',
	'py-rio-cogeo' => 'py3-rio-cogeo',
	'py-shapely' => 'py3-shapely',
	'py-terminado' => 'py3-terminado',
	'py-prometheus_client' => 'py3-prometheus_client',
	'py-influxdb' => 'py3-influxdb',
	'py-pandas' => 'py3-pandas',
	'py-siphon' => 'py3-siphon',
	'py-mlpack' => 'py3-mlpack',
	'py-bottleneck' => 'py3-bottleneck',
	'py-daemon' => 'py3-daemon',
	'py-nbval' => 'py3-nbval',
	'py-oauthlib' => 'py3-oauthlib',
	'py-requests-oauthlib' => 'py3-requests-oauthlib',
	'py-discogs-client' => 'py3-discogs-client',
	'py-semver' => 'py3-semver',
	'py-seaborn' => 'py3-seaborn',
	'py-natsort' => 'py3-natsort',
	'py-mastodon.py' => 'py3-mastodon.py',
	'py-bokeh' => 'py3-bokeh',
	'py-algorithm-munkres' => 'py3-algorithm-munkres',
	'py-pdfminer' => 'py3-pdfminer',
	'jupyter-notebook3' => 'jupyter-notebook',
	'py-html2text' => 'py3-html2text',
	'py-acme' => 'py3-acme',
	'py-josepy' => 'py3-josepy',
	'py-spyder-kernels' => 'py3-spyder-kernels',
	'spyder' => 'spyder3',
	'py-qtconsole' => 'py3-qtconsole',
	'py-sympy' => 'py3-sympy',
	'py-wurlitzer' => 'py3-wurlitzer',
	'py-gunicorn' => 'py3-gunicorn',
	'py-multidict' => 'py3-multidict',
	'py-elasticsearch' => 'py3-elasticsearch',
	'py-vmomi' => 'py3-vmomi',
	'py-nbconvert' => 'py3-nbconvert',
	'py-smbc' => 'py3-smbc',
	'py-git2' => 'py3-git2',
	'py-bencode' => 'py3-bencode',
	'py-dfwinreg' => 'py3-dfwinreg',
	'py-dfvfs' => 'py3-dfvfs',
	'py-dfdatetime' => 'py3-dfdatetime',
	'py-artifacts' => 'py3-artifacts',
	'py-rope' => 'py3-rope',
	'py-xlrd' => 'py3-xlrd',
	'ipython' => 'ipython3',
	'py-ipykernel' => 'py3-ipykernel',
	'py-jupyter_client' => 'py3-jupyter_client',
	'py-jupyter_core' => 'py3-jupyter_core',
	'py-nbformat' => 'py3-nbformat',
	'py-traitlets' => 'py3-traitlets',
	'py-parso' => 'py3-parso',
	'py-jedi' => 'py3-jedi',
	'py-botocore' => 'py3-botocore',
	'py-boto3' => 'py3-boto3',
	'py-s3transfer' => 'py3-s3transfer',
	'py-libpst' => 'py3-libpst',
	'Clementine' => 'clementine',
	'py-curtsies' => 'py3-curtsies',
	'bpython3' => 'bpython',
	'py-prompt_toolkit' => 'py3-prompt_toolkit',
	'py-wcwidth' => 'py3-wcwidth',
	'py-twitter' => 'py3-twitter',
	'py-irclib' => 'py3-irclib',
	'py-casttube' => 'py3-casttube',
	'py-libcloud' => 'py3-libcloud',
	'gegl03' => 'gegl04',
	'py-mysql' => 'py-mysqlclient',
# 6.8
	'py-dulwich' => 'py3-dulwich',
	'py-cups' => 'py3-cups',
	'py-fastimport' => 'py3-fastimport',
	'py-impacket' => 'py3-impacket',
	'py-pynetbox' => 'py3-pynetbox',
	'py-libvirt' => 'py3-libvirt',
	'py-libxml' => 'py3-libxml',
	'py-rsa' => 'py3-rsa',
	'py-unicorn' => 'py3-unicorn',
	'prison' => 'prison-kf5',
	'kdegraphics-mobipocket' => 'kdegraphics-mobipocket-kf5',
	'kdegraphics-thumbnailers' => 'kdegraphics-thumbnailers-kf5',
	'svgpart' => 'svgpart-kf5',
	'kdenetwork-filesharing' => 'kdenetwork-filesharing-kf5',
	'py-cloudpickle' => 'py3-cloudpickle',
	'py-podcastparser' => 'py3-podcastparser',
	'py-configargparse' => 'py3-configargparse',
	'py-aiodns' => 'py3-aiodns',
	'ebc' => 'bc-gh',
	'py-cares' => 'py3-cares',
	'py-astroid' => 'py3-astroid',
	'pylint' => 'pylint3',
	'pylint-gui' => 'pylint3-gui',
	'py-M2Crypto' => 'py3-M2Crypto',
	'sslscan-openssl' => 'sslscan',
	'py-rarfile' => 'py3-rarfile',
	'py-pygfm' => 'py3-pygfm',
	'py-humanize' => 'py3-humanize',
	'py-sabyenc' => 'py3-sabyenc',
	'py-cftime' => 'py3-cftime',
	'py-astral' => 'py3-astral',
	'py-ropper' => 'py3-ropper',
	'py-snuggs' => 'py3-snuggs',
	'py-osqp' => 'py3-osqp',
	'py-ecos' => 'py3-ecos',
	'py-numexpr' => 'py3-numexpr',
	'py-notmuch' => 'py3-notmuch',
	'py-webpy' => 'py3-webpy',
	'phonon-qt5' => 'phonon',
	'phonon-qt5-gstreamer' => 'phonon-backend-gstreamer',
	'phonon-qt5-vlc' => 'phonon-backend-vlc',
	'phonon-gstreamer-icons' => 'phonon-backend-gstreamer',
	'iosevka-fonts-default' => 'iosevka',
	'iosevka-fonts-term' => 'iosevka',
	'py-distutils-extra' => 'py3-distutils-extra',
	'uqm-remix1' => 'uqm-remix',
	'uqm-remix2' => 'uqm-remix',
	'uqm-remix3' => 'uqm-remix',
	'uqm-remix4' => 'uqm-remix',
	'py-responses' => 'py3-responses',
	'py-pudb' => 'py3-pudb',
        'py-keyring' => 'py3-keyring',
        'py-secretstorage' => 'py3-secretstorage',
        'rgain' => 'rgain3',
	'py-urwid' => 'py3-urwid',
	'py-ply' => 'py3-ply',
	'py-dtfabric' => 'py3-dtfabric',
# 6.9
	'py-qscintilla' => 'py3-qscintilla',
	'py-gobject3' => 'py3-gobject3',
	'py-nltk' => 'py3-nltk',
	'py-numpydoc' => 'py3-numpydoc',
	'py-passlib' => 'py3-passlib',
	'py-matplotlib' => 'py3-matplotlib',
	'py-patsy' => 'py3-patsy',
	'py-scs' => 'py3-scs',
	'py-augeas' => 'py3-augeas',
	'py-construct' => 'py3-construct',
	'py-sane' => 'py3-sane',
	'py-zmq' => 'py3-zmq',
	'py-kiwisolver' => 'py3-kiwisolver',
	'py-scipy' => 'py3-scipy',
	'spidermonkey' => 'spidermonkey78',
	'spidermonkey68' => 'spidermonkey78',
	'py-relatorio' => 'py3-relatorio',
	'py-croniter' => 'py3-croniter',
	'biopython' => 'py3-biopython',
	'py-rrd' => 'py-rrdtool',
	'py-whisper' => 'py3-whisper',
	'py-carbon' => 'py3-carbon',
	'py-elftools' => 'py3-elftools',
	'py-lockfile' => 'py3-lockfile',
	'py-toml' => 'py3-toml',
	'py-textfsm' => 'py3-textfsm',
	'py-unicodecsv' => 'py3-unicodecsv',
	'py-enchant' => 'py3-enchant',
	'py-sqlparse' => 'py3-sqlparse',
	'py-sqlalchemy-migrate' => 'py3-sqlalchemy-migrate',
	'py-pygresql' => 'py3-pygresql',
	'py-tagpy' => 'py3-tagpy',
	'py-mpd2' => 'py3-mpd2',
	'py-autobahn' => 'py3-autobahn',
	'py-txaio' => 'py3-txaio',
	'py-qrcode' => 'py3-qrcode',
	'py-acoustid' => 'py3-acoustid',
	'openjpeg' => 'openjp2',
	'py-mysqlclient' => 'py3-mysqlclient',
	'py-pyx' => 'py3-pyx',
	'fvwm2+fvicons' => 'fvwm2',
	'fvicons' => 'fvwm2',
	'py-frozen-flask' => 'py3-frozen-flask',
	'glibmm26' => 'glibmm268',
	'docker' => 'docker-cli',
	'py-lazy-object-proxy' => 'py3-lazy-project-proxy',
	'py3-scapy' => 'scapy',
	'py-sqlobject' => 'py3-sqlobject',
	'pyglet' => 'py-pyglet',
	'py-tzlocal' => 'py3-tzlocal',
	'py-sphinx-notfound-page' => 'py3-sphinx-notfound-page',
	'py-mulpyplexer' => 'py3-mulpyplexer',
	'py-commonmark' => 'py3-commonmark',
	'py-recommonmark' => 'py3-recommonmark',
	'py-sphinx_guzzle_theme' => 'py3-sphinx_guzzle_theme',
	'py-tornado' => 'py3-tornado',
	'py-sphinx-intl' => 'py3-sphinx-intl',
	'stegcracker' => 'stegseek',
	'py-ldap3' => 'py3-ldap3',
	'py-qtpy' => 'py3-qtpy',
	'py-sip' => 'py3-sip',
	'py-sip-qt5' => 'py3-pyqt5_sip',
	'py3-sip-qt5' => 'py3-pyqt5_sip',
	'py-qt5' => 'py3-qt5',
	'py-ndg_httpsclient' => 'py3-ndg_httpsclient',
	'py-trustme' => 'py3-trustme',
	'py-mechanize' => 'py3-mechanize',
	'py-ripe.atlas.cousteau' => 'py3-ripe.atlas.cousteau',
	'py-ripe.atlas.sagan' => 'py3-ripe.atlas.sagan',
	'py-qtawesome' => 'py3-qtawesome',
	'py-twisted' => 'py3-twisted',
	'py-hamcrest' => 'py3-hamcrest',
	'py-automat' => 'py3-automat',
	'py-constantly' => 'py3-constantly',
	'py-incremental' => 'py3-incremental',
	'py-zopeevent' => 'py3-zopeevent',
	'py-zopeinterface' => 'py3-zopeinterface',
	'py-zopetesting' => 'py3-zopetesting',
	'py-zopecomponent' => 'py3-zopecomponent',
	'py-service_identity' => 'py3-service_identity',
	'py-hyperlink' => 'py3-hyperlink',
	'py-asn1-modules' => 'py3-asn1-modules',
	'py-ldap' => 'py3-ldap',
	'py-ldap-examples' => 'py3-ldap-examples',
	'py-pexpect' => 'py3-pexpect',
	'py-gevent' => 'py3-gevent',
	'py-statgrab' => 'py3-statgrab',
	'py-parallel-ssh' => 'py3-parallel-ssh',
	'py-geventhttpclient' => 'py3-geventhttpclient',
	'py-gnupg' => 'py3-gnupg',
	'py-babel' => 'py3-babel',
	'py-imagesize' => 'py3-imagesize',
	'py-alabaster' => 'py3-alabaster',
	'py-docutils' => 'py3-docutils',
	'py-pygments' => 'py3-pygments',
	'py-snowballstemmer' => 'py3-snowballstemmer',
	'py-stemmer' => 'py3-stemmer',
	'py-sphinx' => 'py3-sphinx',
	'py-sphinx_rtd_theme' => 'py3-sphinx_rtd_theme',
	'py-codestyle' => 'py3-codestyle',
	'pyflakes3' => 'pyflakes',
	'py-dot' => 'py3-dot',
	'py-last' => 'py3-last',
	'py-flask-principal' => 'py3-flask-principal',
	'py-flask-sqlalchemy' => 'py3-flask-sqlalchemy',
	'py-flask-login' => 'py3-flask-login',
	'py-flask-wtf' => 'py3-flask-wtf',
	'py-pygal' => 'py3-pygal',
	'py-wtforms' => 'py3-wtforms',
	'py-apsw' => 'py3-apsw',
	'cdiff' => 'ydiff',
	'xmonad-lib' => 'xmonad',
	'py-test-httpbin' => 'py3-test-httpbin',
	'py-test-localserver' => 'py3-test-localserver',
	'py-test-vcr' => 'py3-test-vcr',
	'py-flask' => 'py3-flask',
	'py-httpbin' => 'py3-httpbin',
	'py-itsdangerous' => 'py3-itsdangerous',
	'py-vcrpy' => 'py3-vcrpy',
	'py-werkzeug' => 'py3-werkzeug',
	'py-blinker' => 'py3-blinker',
	'py-ifaddr' => 'py3-ifaddr',
	'py-colorama' => 'py3-colorama',
	'py-emoji' => 'py3-emoji',
	'py-query' => 'py3-query',
	'py-ofxparse' => 'py3-ofxparse',
	'py-puppetboard' => 'py3-puppetboard',
	'py-urlgrabber' => 'py3-urlgrabber',
	'py-webob' => 'py3-webob',
	'py-webtest' => 'py3-webtest',
	'py-genshi' => 'py3-genshi',
	'py-musicbrainzngs' => 'py3-musicbrainzngs',
	'py-setproctitle' => 'py3-setproctitle',
	'py-ptyprocess' => 'py3-ptyprocess',
	'py-jwt' => 'py3-jwt',
	'py-pg_activity' => 'pg_activity', # intentionally removing py- prefix
	'py-axolotl' => 'py3-axolotl',
	'py-protobuf' => 'py3-protobuf',
	'py-http_ece' => 'py3-http_ece',
	'yubiserve' => 'yubikeyedup',
	'py-openssl' => 'py3-openssl',
	'py-junos-eznc' => 'py3-junos-eznc',
	'py-ncclient' => 'py3-ncclient',
	'py-beautifulsoup4' => 'py3-beautifulsoup4',
};

my $obsolete_reason = {
# 5.6
	'radiusd-cistron' => 2,
	'radiusd-lucent' => 2,
	'emesene' => 0,
	'celt051' => 0,
	'lasem' => 0,
	'memphis' => 3,
	'bzip' => 3,
	'silverstripe' => 1,
	'dnetc' => 0,
	'gitlist' => 1,
	'telepathy-inspector' => 0,
	'telepathy-spec' => 0,
	'svk' => 3,
	'p5-SVN-Dump' => 3,
	'p5-SVN-Mirror' => 3,
	'chipmunk' => 0,
	'maple' => 3,
	'mapleshare' => 3,
	'p5-Event-Lib' => 3,
	'gnome-search-tool' => 3,
	'gnome-system-log' => 3,
	'mash' => 3,
	'p5-RTx-Tags' => 0,
	'gedit-cossa' => 3,
	'anjuta-extras' => 3,
	'moserial' => 3,
	'ethos' => 3,
	'ekiga' => 0,
	'kpoppassd' => 2,
	'p5-Authen-Krb5-Simple' => 2,
	'py-pykpass' => 2,
	'mod_auth_kerb' => 2,
	'p5-GSSAPI' => 2,
	'opal' => 0,
	'p5-GetLive' => 3,
	'bonk' => 3,
	'xmms-bonk' => 3,
	'mailcrypt' => 0,
	'tcpcat' => 4,
# 5.7
	'ctm' => 3,
	'papyon' => 3,
	'bacula-web' => 1,
	'waf' => 0,
	'ruby-echoe' => 3,
	'ruby-rubyforge' => 0,
	'luastatgrab' => 3,
	'ruby-home_run' => 3,
	'ruby-parsetree' => 3,
	'ruby-rdoc' => 3,
	'ruby-rcov' => 3,
	'ruby-fastercsv' => 3,
	'ruby-fastri' => 3,
	'ruby-mongrel' => 3,
	'eruby' => 3,
	'mod_ruby' => 3,
	'py3-distribute' => 3,
	'raggle' => 3,
	'gnome-icon-theme-extras' => 3,
	'ruby-fastthread' => 3,
	'dellflash' => 0,
	'libgee06' => 3,
	'smarty' => 2,
	'smarty-docs' => 2,
	'wdsetup' => 0,
	'pptp' => 0,
	'aumix' => 0,
	'ac3dec' => 3,
	'flash' => 3,
	'ruby-columnize' => 3,
	'ruby-mini_magick' => 3,
	'ruby-spreadsheet' => 3,
	'ruby-minion' => 3,
	'ruby-bunny' => 3,
	'ruby-randexp' => 3,
	'synaesthesia' => 0,
	'auctex' => 0,
	'emacs-zenirc' => 3,
	'emacs-zenirc-el' => 3,
	'newsfetch' => 2,
	'esound' => 3,
	'extace' => 3,
	'gkrellmss' => 3,
	'mixer.app' => 0,
	'wmix' => 0,
	'wmmixer' => 0,
	'xmix' => 0,
	'xmmix' => 0,
	'pecl-APC' => 3,
	'fxtv' => 3,
	'hudson' => 2,
	'epdfview' => 0,
	'p5-HTTP-GHTTP' => 3,
	'libghttp' => 3,
	'ruby-hub' => 3,
	'erl-webmachine' => 0,
	'commons-io' => 2,
	'qt4-qtsolutions-singleinstance' => 3,
	'hs-HsParrot' => 5,
	'hs-HsSyck' => 5,
	'hs-MetaObject' => 5,
	'hs-control-timeout' => 5,
	'hs-pugs-DrIFT' => 5,
	'hs-pugs-compat' => 5,
	'hs-regex-pcre-builtin' => 5,
	'hs-stringtable-atom' => 5,
	'pugs' => 5,
	'xawtv' => 5,
# 5.8
	'qt4-eventsview' => 0,
	'rioutil' => 3,
	'chmsee' => 0,
	'p5-Image-Scale' => 0,
	'appdata-tools' => 3,
	'ksmp3play' => 3,
	'xchat' => 3,
	'moovida' => 3,
	'moovida-plugins-bad' => 3,
	'moovida-plugins-good' => 3,
	'moovida-plugins-ugly' => 3,
	'ntop' => 2,
	'onyx' => 3,
	'libunicode' => 5,
	'cook' => 3,
	'schroedinger' => 3,
	'wordpress' => 1,
	'polari' => 6,
	'gtk3-xfce-engine' => 3,
	'shell-fm' => 6,
	'ruby-cucumber' => 0,
	'ap2-mod_fastcgi' => 6,
	'ap2-mod_fcgid' => 6,
	'mono-basic' => 5,
	'boo' => 5,
	'nant' => 5,
	'ADMfzap' => 0,
	'ruby-jekyll' => 5,
	'ruby-couchrest' => 5,
	'ruby-rest-client' => 5,
	'libavl' => 6,
	'daapd' => 0,
	'gnomad2' => 3,
	'mpdBrowser' => 3,
	'p5-Palm' => 6,
	'palm2ical' => 6,
	'aguri' => 3,
	'bonnie' => 3,
	'xlogout' => 3,
	'mp3encode' => 3,
	'xmms-smpeg' => 3,
	'nvi-m17n' => 3,
	'ruby-term-ansicolor' => 5,
	'star' => 6,
	'sdd' => 6,
	'tt-rss' => 1,
	'pear-Benchmark' => 5,
	'pear-PHPUnit2' => 3,
	'pear-HTML-Common2' => 5,
	'pear-HTML-QuickForm' => 5,
	'p5-XML-LibXML-Common' => 5,
	'drac' => 3,
	'vifm' => 0,
	'ruby-amqp' => 5,
	'dbh' => 5,
	'yaws' => 6,
	'pidgin-facebookchat' => 6,
	'py-sslwrapper' => 0,
	'hs-snap' => 5,
	'hs-snap-core' => 5,
	'hs-snap-loader-dynamic' => 5,
	'hs-snap-loader-static' => 5,
	'hs-snap-server' => 5,
	'lmbench' => 5,
	'wterm' => 0,
	'hs-asn1-data' => 5,
	'hs-attoparsec-enumerator' => 5,
	'hs-attoparsec-iteratee' => 5,
	'hs-heist' => 5,
	'hs-certificate' => 5,
	'hs-tls' => 5,
	'opera' => 2,
	'redhat_libc5' => 2,
	'p5-Net-TCLink' => 2,
	'pg_top' => 5,
	'qtoctave' => 3,
	'ocsync' => 6,
	'tla' => 3,
	'googlecl' => 3,
	'cyphertite' => 3,
# 5.9
	'cxxtools' => 5,
	'tntnet' => 6,
	'dwb' => 6,
	'ns4' => 3,
	'tcplist' => 0,
	'wide-dhcp' => 0,
	'cfs' => 0,
	'rubinius' => 5,
	'xorp' => 5,
	'faac' => 6,
	'god' => 5,
	'ivan' => 3,
	'hs-xhtml-combinators' => 5,
	'feldspar-compiler' => 5,
	'feldspar-language' => 5,
	'hs-MonadCatchIO-mtl' => 5,
	'hs-MonadCatchIO-transformers' => 5,
	'hs-QuickAnnotate' => 5,
	'hs-clientsession' => 5,
	'hs-comonad' => 5,
	'hs-comonad-transformers' => 5,
	'hs-comonads-fd' => 5,
	'hs-contravariant' => 5,
	'hs-cprng-aes' => 5,
	'hs-data-lens' => 5,
	'hs-data-lens-template' => 5,
	'hs-distributive' => 5,
	'hs-either' => 5,
	'hs-errors' => 5,
	'hs-ghc-mtl' => 5,
	'hs-hint' => 5,
	'hs-iteratee' => 5,
	'hs-lens' => 5,
	'hs-monads-tf' => 5,
	'hs-semigroupoids' => 5,
	'hs-syntactic' => 5,
	'hs-type-level' => 5,
	'hs-vector-algorithms' => 5,
	'hs-ListLike' => 5,
	'hs-atom' => 5,
	'gstreamermm' => 3,
	'opencm' => 3,
	'libglademm' => 3,
	'hs-zlib-enum' => 5,
	'hs-blaze-builder-enumerator' => 5,
	'hs-monad-par' => 5,
	'hs-monad-par-extras' => 5,
	'swfdec-plugin' => 3,
	'yui' => 2,
	'yui-docs' => 2,
	'tkrat' => 3,
	'bustle' => 5,
	'bluetile' => 5,
	'hs-cairo' => 5,
	'hs-gio' => 5,
	'hs-glade' => 5,
	'hs-glib' => 5,
	'hs-gtk' => 5,
	'hs-pango' => 5,
	'hs-webkit' => 5,
	'node-pg' => 7,
	'node-sqlite3' => 7,
	'node-async' => 7,
	'node-bindings' => 7,
	'node-buffer-writer' => 7,
	'node-cloned' => 7,
	'node-expresso' => 7,
	'node-fibers' => 7,
	'node-generic-pool' => 7,
	'node-gir' => 7,
	'node-mnm' => 7,
	'node-canvas' => 7,
	'node-java' => 7,
	'node-typescript' => 7,
	'node-bcrypt' => 7,
	'node-always' => 7,
	'node-daemon' => 7,
	'node-rmdir' => 7,
	'node-syslog' => 7,
	'gtk2hs-buildtools' => 5,
	'coffeescript' => 7,
	'pb-browser' => 0,
	'unace' => 0,
	'edict' => 3,
	'ADMsmb' => 6,
	'mrtd' => 3,
	'openobex' => 6,
	'obexftp' => 6,
	'py-openbsd' => 3,
	'antisniff' => 3,
	'WebGUI' => 2,
	'tinyca2' => 3,
	'kxmleditor' => 3,
	'hs-hashed-storage' => 5,
	'gnome-common' => 3,
	'emacs-haskell' => 7,
	'statusnet' => 1,
	'p5-Goo-Canvas' => 6,
	'hs-blaze-builder-conduit' => 3,
	'hs-network-conduit' => 3,
	'hs-http-attoparsec' => 5,
	'hs-shellish' => 5,
	'hs-xmlhtml' => 5,
	'hs-blaze-html' => 5,
	'hs-blaze-markup' => 5,
	'zsnes' => 2,
	'its4' => 3,
	'august' => 3,
	'hs-hlint' => 7,
	'monodevelop' => 5,
	'hs-hoogle' => 7,
	'hs-configurator' => 5,
	'hs-safe' => 5,
	'hs-uniplate' => 5,
	'hs-vault' => 5,
	'hs-haskell-src-exts' => 5,
	'hs-tagsoup' => 5,
	'hs-http-types' => 5,
	'hs-wai' => 5,
	'hs-warp' => 5,
	'hs-hackage-db' => 5,
	'c2hs' => 5,
	'hs-language-c' => 5,
	'hs-simple-sendfile' => 5,
	'monadius' => 3,
	'hs-bimap' => 5,
# 6.0
	'nicotine' => 3,
	'toprump' => 3,
	'fedora_base' => 0,
	'fedora_cups' => 0,
	'fedora_gtk+2' => 0,
	'adom' => 0,
	'xcept' => 0,
	'cqcam' => 6,
	'uisp' => 6,
	'libretto-config' => 6,
	'courtney' => 2,
	'junkbuster' => 2,
	'icb' => 0,
	'libshrink' => 3,
	'libclog' => 3,
	'libexude' => 3,
	'assl' => 3,
	'libxmlsd' => 3,
	'p5-I18N-LangTags' => 4,
	'p5-Text-Restructured' => 3,
	'p5-Safe-World' => 3,
	'p5-Safe-Hole' => 3,
	'p5-Slay-Makefile-Gress' => 3,
	'p5-Slay-Makefile' => 3,
	'p5-Slay-Maker' => 3,
	'p5-Test-Harness' => 4,
	'mpegaudio' => 0,
	'fvwm95' => 0,
	'rplay' => 0,
	'amsn' => 6,
	'pebrot' => 6,
	'alacarte' => 3,
	'logstash-forwarder' => 3,
	'py-Xlib' => 5,
	'pypanel' => 3,
	'gtkhtml3' => 5,
	'libunique3' => 5,
	'swfdec' => 3,
	'asm' => 5,
	'libqzeitgeist' => 6,
	'zeitgeist' => 6,
	'gedit-latex' => 3,
	'rackmonkey' => 3,
	'mod_auth_bsd' => 6,
	'mod_auth_ldap' => 6,
	'mod_auth_mysql' => 6,
	'mod_auth_pgsql' => 6,
	'mod_auth_radius' => 6,
	'mod_encoding' => 6,
	'mod_fastcgi' => 6,
	'mod_geoip' => 6,
	'mod_gzip' => 6,
	'mod_jk' => 6,
	'mod_layout' => 6,
	'mod_ldapvhost' => 6,
	'mod_log_sql' => 6,
	'mod_mp3' => 6,
	'mod_random' => 6,
	'mod_scgi' => 6,
	'mod_security' => 6,
	'mod_text2html' => 6,
	'p5-CGI-SpeedyCGI' => 6,
	'p5-HTML-Embperl' => 6,
	'p5-libapreq' => 6,
	'mod_perl' => 6,
	'ocamlduce' => 0,
	'yt' => 0,
	'gmime-sharp' => 6,
	'py-subvertpy' => 5,
# 6.1
	'clamz' => 3,
	'p5-Net-Abuse-Utils-Spamhaus' => 6,
	'mlite' => 3,
	'hgd' => 3,
	'gfortran' => 5,
	'cherokee' => 3,
	'cherokee-geoip' => 3,
	'cherokee-ldap' => 3,
	'cherokee-mysql' => 3,
	'cherokee-streaming' => 3,
	'gecko-mediaplayer' => 3,
	'io' => 5,
	'dbic++' => 5,
	'hs-postgresql-simple' => 5,
	'hs-uuid' => 5,
	"ocaml-mlgmp" => 3,
	"ocaml-batteries" => 5,
	"ocaml-bitstring" => 5,
	"ocaml-calendar" => 5,
	"ocaml-curses" => 5,
	"ocaml-net" => 5,
	"ocaml-camlimages" => 5,
	"ocaml-cryptokit" => 5,
	"ocaml-csv" => 5,
	"ocaml-rss" => 5,
	"ocaml-xml-light" => 5,
	"ocaml-xmlm" => 5,
	"ocaml-postgresql" => 5,
	"ocaml-sqlite3" => 5,
	"utop" => 7,
	"ocaml-lambda-term" => 5,
	"ocaml-lwt" => 5,
	"ocaml-react" => 5,
	"ocaml-text" => 5,
	"ocaml-ssl" => 5,
	"ocaml-ppx-tools" => 5,
	"ocaml-zed" => 5,
	"ocaml-camomile" => 5,
	"elinks" => 2,
	"wyrd" => 3,
	"sudoku-solver" => 3,
	"clearsilver" => 3,
	"poppler-qt" => 3,
	'amarok' => 2,
	'digikam-doc' => 6,
	'gwenview-i18n' => 6,
	'kaffeine' => 6,
	'kbiff' => 6,
	'kdbg' => 3,
	'kdewebdev' => 5,
	'kmplayer' => 6,
	'kountdown' => 3,
	'kslide' => 3,
	'ktimeclock' => 6,
	'okle' => 2,
	'qinx' => 6,
	'quadkonsole' => 6,
	'taskjuggler' => 6,
	'icinga2-migration' => 3,
	'poppassd' => 0,
	'wmthemeinstall' => 0,
	'gkrellmms' => 5,
	'py-xmms' => 5,
	'xmms' => 5,
	'xmms-faad' => 5,
	'xmms-flac' => 5,
	'xmms-fmradio' => 5,
	'xmms-kj' => 5,
	'xmms-mad' => 5,
	'xmms-mikmod' => 5,
	'xmms-mp3' => 5,
	'xmms-shn' => 5,
	'xmms-sid' => 5,
	'xmms-speex' => 5,
	'xmms-tremor' => 5,
	'xmms-vorbis' => 5,
	'xmms-wavpack' => 5,
	'xmms-xf86audio' => 5,
	'xmmsctrl' => 5,
	'glib' => 5,
	'gtk+' => 5,
	'gnome-user-share' => 8,
	'letskencrypt' => 4,
	'emiclock' => 0,
	'rygel' => 8,
	'ttcp' => 0,
	'aget' => 3,
	'xfprint' => 3,
	'notification-daemon-xfce' => 3,
	'xfce4-wmdock' => 3,
	'xfce4-modemlights' => 3,
	'xfce4-quicklauncher' => 3,
	'libxfcegui4' => 5,
	'libsexy' => 5,
	'twitux' => 3,
	'gnash' => 2,
	'eclipse-sdk' => 2,
	'swt' => 2,
	'swt-gnome' => 2,
	'eclipse-plugin-emf-sdk' => 2,
	'eclipse-plugin-epic' => 2,
	'eclipse-plugin-findbugs' => 2,
	'eclipse-plugin-gef-sdk' => 2,
	'eclipse-plugin-ivyde' => 2,
	'py-dev' => 2,
	'eclipse-plugin-rdt' => 2,
	'eclipse-plugin-struts-console' => 2,
	'eclipse-plugin-subclipse' => 2,
	'eclipse-plugin-uml2-sdk' => 2,
	'eclipse-plugin-wtp-sdk' => 2,
	'lsof' => 0,
	'l0phtcrack' => 0,
	'bunny' => 3,
	'jakarta-servletapi' => 5,
	'ldistfp' => 0,
	'py-webkitgtk' => 2,
	'xombrero' => 3,
	'claws-mail-htmlviewer' => 2,
	'postgresql-jdbc' => 6,
	'postgresql-jdbc-docs' => 6,
	'plor' => 3,
	'coherence' => 3,
	'hugs98' => 3,
	'hmake' => 3,
	'nhc98' => 3,
	'logsurfer' => 3,
	'scsh' => 3,
	'bladeenc' => 3,
	'pilot_makedoc' => 6,
	'clog' => 4,
	'pigment' => 3,
	'py-pigment' => 3,
	'gogo' => 3,
# 6.2
	'spectemu' => 3,
	'pinpoint' => 3,
	'anjuta' => 3,
	'libneural' => 5,
	'toolame' => 5,
	'gpointing-device-settings' => 3,
	'ja-jvim' => 3,
	'teknap' => 6,
	'trafd' => 4,
	'topbeat' => 3,
	'logic2cnf' => 3,
	'bytebench' => 3,
	'libdivxdecore' => 5,
	'xgrab' => 9,
	'quirc' => 3,
	'xspread' => 3,
	'sharity-light' => 6,
	'py-axiom' => 5,
	'py-epsilon' => 5,
	'hellanzb'=> 3,
	'londonlaw'=> 3,
	'castle-combat'=> 3,
	'rxvt' => 2,
	'irssi-silc' => 3,
	'teapop' => 3,
	'daala' => 6,
	'aiccu' => 6,
	'samhain' => 5,
	'samhain-docs' => 5,
	'samhain-server' => 5,
	'texapp' => 6,
	'surf2' => 5,
	'mrxvt' => 2,
	'cutegram' => 3,
	'libqtelegram-aseman-edition' => 5,
	'qca-tls' => 3,
	'py-qt5-docs' => 3,
	'qtenginio' => 3,
	'qtenginio-docindex' => 3,
	'qtenginio-examples' => 3,
	'qtenginio-html' => 3,
	'qtenginio-qch' => 3,
	'crxvt' => 2,
	'qt3d-docindex' => 6,
	'qtactiveqt-docindex' => 6,
	'qtbase-docindex' => 6,
	'qtcanvas3d-docindex' => 6,
	'qtcharts-docindex' => 6,
	'qtconnectivity-docindex' => 6,
	'qtdatavis3d-docindex' => 6,
	'qtdeclarative-docindex' => 6,
	'qtdoc-docindex' => 6,
	'qtgamepad-docindex' => 6,
	'qtgraphicaleffects-docindex' => 6,
	'qtimageformats-docindex' => 6,
	'qtlocation-docindex' => 6,
	'qtmultimedia-docindex' => 6,
	'qtnetworkauth-docindex' => 6,
	'qtpurchasing-docindex' => 6,
	'qtquickcontrols-docindex' => 6,
	'qtquickcontrols2-docindex' => 6,
	'qtremoteobjects-docindex' => 6,
	'qtscript-docindex' => 6,
	'qtscxml-docindex' => 6,
	'qtsensors-docindex' => 6,
	'qtserialbus-docindex' => 6,
	'qtserialport-docindex' => 6,
	'qtspeech-docindex' => 6,
	'qtsvg-docindex' => 6,
	'qtvirtualkeyboard-docindex' => 6,
	'qtwebchannel-docindex' => 6,
	'qtwebkit-docindex' => 6,
	'qtwebsockets-docindex' => 6,
	'qtx11extras-docindex' => 6,
	'qtxmlpatterns-docindex' => 6,
	'conkeror' => 3,
	'xulrunner' => 5,
	'xulrunner-devel' => 5,
	'libaccounts-glib' => 6,
	'mico' => 0,
	'leveldb' => 5,
	'py-graphics' => 3,
	'akode' => 5,
	'zendframework' => 5,
	'kbilliards' => 5,
	'knutclient' => 5,
	'pgpsendmail' => 3,
	'banshee' => 3,
	'mono-zeroconf' => 5,
	'mono-avahi' => 5,
	'pgp' => 3,
	'gonzui' => 3,
# 6.3
	'puppet-dashboard' => 5,
	'dnsfilter' => 3,
	'empathy' => 6,
	'telepathy-salut' => 3,
	'telepthy-haze' => 3,
	'telepathy-idle' => 3,
	'telepathy-gabble' => 3,
	'telepathy-qt' => 3,
	'telepathy-farstream' => 3,
	'farstream' => 3,
	'libnice' => 6,
	'ardour' => 5,
	'aubio' => 5,
	'liblo' => 5,
	'libgnomecanvasmm' => 5,
	'mixmaster' => 2,
	'xscorch' => 0,
	'libwbxml' => 5,
	'haskell-platform' => 6,
	'gnokii' => 0,
	'dee' => 5,
	'pidgin-tlen' => 6,
	'pep8' => 5,
	'hs-aeson' => 6,
	'hs-GLURaw' => 6,
	'hs-GLUT' => 6,
	'hs-OpenGL' => 6,
	'hs-OpenGLRaw' => 6,
	'gnuvd' => 6,
	'gtkhtml4' => 5,
	'livestreamer-curses' => 6,
	'xdmchoose' => 6,
	'hs-BoundedChan' => 6,
	'hs-HDBC-mysql' => 6,
	'hs-HDBC-postgresql' => 6,
	'hs-MonadRandom' => 6,
	'hs-ObjectName' => 6,
	'hs-PSQueue' => 6,
	'hs-StateVar' => 6,
	'hs-abstract-deque' => 6,
	'hs-abstract-par' => 6,
	'hs-base-unicode-symbols' => 6,
	'hs-blaze-textual' => 6,
	'hs-bytestring-mmap' => 6,
	'hs-bytestring-nums' => 6,
	'hs-case-insensitive' => 6,
	'hs-cgi' => 6,
	'hs-cmdlib' => 6,
	'hs-concurrent-extra' => 6,
	'hs-crypto' => 6,
	'hs-cryptocipher' => 6,
	'hs-curl' => 6,
	'hs-data-hash' => 6,
	'hs-directory-tree' => 6,
	'hs-enumerator' => 6,
	'hs-failure' => 6,
	'hs-ghc-paths' => 6,
	'hs-half' => 6,
	'hs-hashtables' => 6,
	'hs-haskell-src' => 6,
	'hs-hedis' => 6,
	'hs-hexpat' => 6,
	'hs-hood' => 6,
	'hs-largeword' => 6,
	'hs-logict' => 6,
	'hs-murmur-hash' => 6,
	'hs-mwc-random' => 6,
	'hs-network-info' => 6,
	'hs-newtype' => 6,
	'hs-parallel' => 6,
	'hs-patch-combinators' => 6,
	'hs-postgresql-libpq' => 6,
	'hs-pwstore-fast' => 6,
	'hs-readline' => 6,
	'hs-sendfile' => 6,
	'hs-skein' => 6,
	'hs-strict' => 6,
	'hs-tuple' => 6,
	'hs-zlib-bindings' => 6,
	'vomit' => 0,
	'p5-WWW-YouTube-Download' => 6,
	'oggtag' => 6,
	'aimsniff' => 6,
	'pork' => 6,
	'ntimed' => 3,
	'hs-dataenc' => 3,
	'man2web' => 2,
	'decss' => 6,
	'libgcal' => 6,
	'akonadi-googledata' => 6,
	'arora' => 3,
	'powerdns-ldap' => 6,
	'p5-Net-LDNS' => 6,
	'sirc' => 0,
	'hgview' => 6,
	'xerces' => 5,
# 6.4
	'mozjs17' => 2,
	'qvwm' => 3,
	'prepop' => 3,
	'centerim' => 3,
	'gpgmepp' => 3,
	'hs-resource-pool' => 6,
	'hs-List' => 6,
	'hs-OneTuple' => 6,
	'hs-blaze-builder' => 6,
	'hs-unbounded-delays' => 6,
	'hs-unordered-containers' => 6,
	'hscolour' => 6,
	'hs-multipart' => 6,
	'hs-bytestring-lexing' => 6,
	'hs-scanner' => 6,
	'xnc' => 0,
	'nepenthes' => 3,
	'mongrel2' => 6,
	'ja-groff' => 6,
	'gtkglextmm' => 3,
	'goocanvas' => 3,
	'osm2go' => 6,
	'kedpm' => 6,
	'mediatomb' => 3,
	'apache-couchdb' => 6,
	'py-couchdb' => 6,
	'chive' => 3,
	'opengroupware' => 3,
	'git-bz' => 3,
	'hot-babe' => 3,
	'wmgrabimage' => 0,
	'wmphoto' => 0,
	'wmminichess' => 0,
	'wmifinfo' => 0,
	'wmnet' => 0,
	'wmwave' => 0,
	'wmcb' => 0,
	'wmpinboard' => 0,
	'wmbiff' => 0,
	'wmmail' => 0,
	'wmtimer' => 0,
	'py-crypto' => 3,
	'py3-crypto' => 3,
	'tremor' => 5,
	'tremor-tools' => 5,
	'xtrkcad' => 3,
	'webkit' => 2,
	'py-test-capturelog' => 5,
	'py3-test-capturelog' => 5,
	'snapdl' => 3,
	'ccnet' => 6,
	'dkim-milter' => 10,
	'aircontrol' => 11,
	'corebird' => 3,
	'py-pcs' => 5,
	'ifmcstat' => 5,
	'suricata-update' => 6,
# 6.5
	'py-dtopt' => 5,
	'py3-dtopt' => 5,
	'memtest86+' => 0,
	'py-reat' => 5,
	'dovecot-antispam' => 12,
	'py-hgtools' => 3,
	'py3-hgtools' => 3,
	'py-hgsubversion' => 3,
	'py-hgnested' => 5,
	'py-keyczar' => 6,
	'py-hg-git' => 5,
	'py-czmq' => 3,
	'p5-Math-Pari' => 13,
	'p5-Math-BigInt-Pari' => 13,
	'p5-Crypt-Random' => 13,
	'p5-Crypt-DH' => 13,
	'p5-Crypt-Primes' => 13,
	'p5-Crypt-RSA' => 13,
	'directoryassistant' => 0,
	'x-pack' => 3,
	'libepc' => 5,
	'dysnomia-en' => 0,
	'casperjs' => 3,
	'phantomjs' => 3,
	'owncloud' => 6,
	'php-librdf' => 13,
	'nedi' => 13,
	'xcache' => 13,
	'pecl-memcache' => 13,
	'pecl56-memcache' => 13,
	'pecl-swish' => 13,
	'pecl56-swish' => 13,
	'pecl-uploadprogress' => 13,
	'pecl56-uploadprogress' => 13,
	'sickbeard' => 3,
	'nxssh' => 2,
	'opennx' => 3,
	'iaxcomm' => 3,
	'pinot' => 0,
	'gaia' => 0,
	'openafs' => 0,
	'emerillon' => 3,
	'mplex' => 5,
	'gromit' => 0,
	'discwrapper' => 3,
	'libhttpseverywhere' => 6,
	'poppler-qt4' => 3,
	'ushare' => 3,
	'ffmpeg2theora' => 6,
	'p5-WWW-Google-SiteMap' => 3,
	'p5-YAML-Perl' => 3,
	'py-nevow' => 5,
	'gupnp-ui' => 3,
	'suricata-update' => 6,
	'exploitdb-papers' => 1,
	'nautilus-sendto' => 3,
	'libstrophe' => 5,
	'ghostview' => 2,
	'libcudf' => 7,
	'ocaml-cudf' => 7,
	'ocaml-cmdliner' => 7,
	'ocaml-cppo' => 7,
	'ocaml-dose' => 7,
	'ocaml-extlib' => 7,
	'ocaml-jsonm' => 7,
	'ocaml-re' => 7,
	'omake' => 7,
	'ounit' => 7,
	'obc' => 5,
	'mlbviewer' => 3,
	'upsd' => 3,
	'vagalume' => 0,
	'ocaml-uutf' => 7,
	'xbat' => 3,
	'xripple' => 3,
	'sliderule' => 3,
	'swisswatch' => 3,
	'xaniroc' => 3,
	'xmascot' => 3,
	'xmold' => 3,
	'xsnow' => 3,
	'xtattr' => 3,
	'ruby25-akami' => 1,
	'ruby25-gyoku' => 1,
	'ruby25-httpclient' => 1,
	'ruby25-httpi' => 1,
	'ruby25-nori' => 1,
	'ruby25-savon' => 1,
	'ruby25-sonos' => 1,
	'ruby25-wasabi' => 1,
	'linuxdoc' => 6,
	'luna' => 3,
	'rsynth' => 3,
	'agm' => 3,
	'connect4' => 3,
	'xchomp' => 3,
	'xdeblock' => 3,
	'xzip' => 3,
	'jive' => 3,
	'compface' => 3,
	'mirror' => 3,
	'dclock' => 3,
	'xfishtank' => 3,
	'mpeg_play' => 6,
# 6.6
	'py-async' => 5,
	'py3-async' => 5,
	'py3-funcsigs' => 5,
	'rust-doc' => 1,
	'glib-openssl' => 6,
	'gcj' => 5,
	'classpath' => 5,
	'jamvm' => 5,
	'gnome-code-assistance' => 3,
	'gedit-code-assistance' => 3,
	'py3-backports-abc' => 5,
	'libkgeomap' => 0,
	'piwik' => 1,
	'wml' => 5,
	'junit' => 1,
	'jeoip' => 6,
	'gnaughty' => 0,
	'mysql++' => 5,
	'mysqlcc' => 3,
	'relayd-updateconf' => 6,
	'java-getopt' => 1,
	'avidemux' => 5,
	'OGIlexicon' => 5,
	'festival' => 5,
	'festlex_CMU' => 5,
	'festlex_OALD' => 5,
	'festlex_POSLEX' => 5,
	'festvox_cmu_us_awb_arctic_hts' => 5,
	'festvox_cmu_us_bdl_arctic_hts' => 5,
	'festvox_cmu_us_jmk_arctic_hts' => 5,
	'festvox_cmu_us_slt_arctic_hts' => 5,
	'festvox_cstr_us_awb_arctic_multisyn' => 5,
	'festvox_cstr_us_jmk_arctic_multisyn' => 5,
	'festvox_don' => 5,
	'festvox_ellpc11k' => 5,
	'festvox_kallpc16k' => 5,
	'festvox_kedlpc16k' => 5,
	'festvox_rablpc16k' => 5,
	'voice_aec_di' => 5,
	'voice_jph_di' => 5,
	'voice_mwm_di' => 5,
	'voice_tll_di' => 5,
	'proxy-suite' => 3,
	'py-amf' => 6,
	'lam' => 3,
	'gxml' => 6,
	'nulib' => 3,
	'py-turbocheetah' => 3,
	'py-turbokid' => 3,
	'py-addons' => 3,
	'py-peak-rules' => 3,
	'py-prioritized_methods' => 3,
	'py-extremes' => 3,
	'py-kid' => 3,
	'py-Chart' => 3,
	'py-id3' => 3,
	'py-tagger' => 3,
	'py-zhCodecs' => 3,
	'py-iconvcodec' => 3,
	'py-cjkcodecs' => 3,
	'py-cdb' => 3,
	'py-pgsql' => 3,
	'pgworksheet' => 3,
	'py-HappyDoc' => 3,
	'py-Rijndael' => 3,
	'py-adns' => 3,
	'py-cherrypy2' => 3,
	'py-clientform' => 3,
	'py-crack' => 3,
	'py-cryptkit' => 3,
	'py-epydoc' => 3,
	'py-flowd' => 3,
	'py-flowtools' => 3,
	'py-gnuplot' => 3,
	'py-htmltmpl' => 3,
	'py-jaxml' => 3,
	'py-kiwi' => 3,
	'py-medusa' => 3,
	'py-monthdelta' => 3,
	'py-optik' => 3,
	'py-osd' => 3,
	'py-probstat' => 3,
	'py-protocols' => 3,
	'py-rtf' => 3,
	'py-ruledispatch' => 3,
	'py-silc' => 3,
	'py-tpg' => 3,
	'py-unit' => 3,
	'pybugz' => 3,
	'pymissile' => 3,
	'arm-elf-binutils' => 6,
	'arm-elf-gcc' => 6,
	'arm-elf-gdb' => 6,
	'arm-elf-newlib' => 6,
	'g77' => 5,
	'libf2c' => 5,
	'p5-WWW-Curl' => 3,
	'java-tanukiwraper' => 5,
	'opencv-docs' => 6,
	'p5-Device-USB' => 6,
	'p5-Crypt-GpgME' => 0,
	'p5-HTTP-BrowserDetect' => 6,
# 6.7
	'awless' => 3,
	'mousetweaks' => 3,
	'py-ioflo' => 6,
	'py3-ioflo' => 6,
	'postgresql-plv8' => 5,
	'py-GeoIP' => 6,
	'cvsync' => 3,
	'pecl-geoip' => 6,
	'clive' => 5,
	'aws-shell' => 6,
	'aqsis' => 5,
	'gtk-xfce-engine' => 3,
	'firewalk' => 0,
	'goffice08' => 5,
	'terraform-provider-terraform' => 3,
	'py-webdav' => 3,
	'yabause' => 6,
	'terraform-provider-softlayer' => 3,
	'py-elementtidy' => 5,
	'py-gd' => 5,
	'py-oauth2' => 5,
	'afm' => 6,
	'p5-Geo-IP' => 6,
	'py-libnacl' => 3,
	'py3-typing' => 5,
	'p5-Net-IRC' => 3,
	'pangox-compat' => 0,
	'tmake' => 5,
	'qt3-sqlite3' => 5,
	'eigen' => 5,
	'eigen2' => 5,
	'qt-gstreamer' => 5,
	'qsynergy' => 3,
	'kqoauth' => 5,
	'valknut' => 3,
	'dclib' => 3,
	'luma' => 3,
	'qhacc' => 15,
	'nginx-geoip' => 17,
	'qgo' => 16,
	'qrfcview' => 3,
	'mutella' => 3,
	'erl-bcrypt' => 5,
	'erl-mochiweb' => 5,
	'rebar18' => 5,
	'rebar17' => 5,
	'bouml' => 3,
	'beediff' => 18,
	'php-mcrypt' => 3,
	'sqliteman' => 19,
	'entomologist' => 3,
	'fcitx-qt4' => 6,
	'partiwm' => 3,
	'ejabberd' => 2,
	'rebar16' => 5,
	'tortoisehg' => 5,
	'cjc' => 3,
	'spectrum' => 3,
	'py-xmpp' => 3,
	'mirage' => 0,
	'rpm' => 0,
	'oggconvert' => 3,
	'radiotray' => 3,
	'xevil' => 0,
	'py-vatnumber' => 3,
	'nap' => 6,
	'qucs' => 5,
	'py-arrow' => 1,
	'py3-arrow' => 1,
	'py-chai' => 1,
	'py3-chai' => 1,
	'py-binaryornot' => 1,
	'py3-binaryornot' => 1,
	'py-whichcraft' => 1,
	'py3-whichcraft' => 1,
	'celt07' => 20,
	'terraform-provider-alicloud' => 1,
	'terraform-provider-archive' => 1,
	'terraform-provider-arukas' => 1,
	'terraform-provider-atlas' => 1,
	'terraform-provider-aws' => 1,
	'terraform-provider-azure' => 1,
	'terraform-provider-azurerm' => 1,
	'terraform-provider-bitbucket' => 1,
	'terraform-provider-chef' => 1,
	'terraform-provider-circonus' => 1,
	'terraform-provider-clc' => 1,
	'terraform-provider-cloudflare' => 1,
	'terraform-provider-cloudstack' => 1,
	'terraform-provider-cobbler' => 1,
	'terraform-provider-consul' => 1,
	'terraform-provider-datadog' => 1,
	'terraform-provider-digitalocean' => 1,
	'terraform-provider-dme' => 1,
	'terraform-provider-dns' => 1,
	'terraform-provider-dnsimple' => 1,
	'terraform-provider-docker' => 1,
	'terraform-provider-dyn' => 1,
	'terraform-provider-exoscale' => 1,
	'terraform-provider-external' => 1,
	'terraform-provider-fastly' => 1,
	'terraform-provider-github' => 1,
	'terraform-provider-gitlab' => 1,
	'terraform-provider-google' => 1,
	'terraform-provider-grafana' => 1,
	'terraform-provider-heroku' => 1,
	'terraform-provider-http' => 1,
	'terraform-provider-icinga2' => 1,
	'terraform-provider-ignition' => 1,
	'terraform-provider-influxdb' => 1,
	'terraform-provider-kubernetes' => 1,
	'terraform-provider-librato' => 1,
	'terraform-provider-local' => 1,
	'terraform-provider-logentries' => 1,
	'terraform-provider-mailgun' => 1,
	'terraform-provider-mysql' => 1,
	'terraform-provider-newrelic' => 1,
	'terraform-provider-nomad' => 1,
	'terraform-provider-ns1' => 1,
	'terraform-provider-null' => 1,
	'terraform-provider-oneandone' => 1,
	'terraform-provider-opc' => 1,
	'terraform-provider-openstack' => 1,
	'terraform-provider-opsgenie' => 1,
	'terraform-provider-ovh' => 1,
	'terraform-provider-packet' => 1,
	'terraform-provider-pagerduty' => 1,
	'terraform-provider-postgresql' => 1,
	'terraform-provider-powerdns' => 1,
	'terraform-provider-profitbricks' => 1,
	'terraform-provider-rabbitmq' => 1,
	'terraform-provider-rancher' => 1,
	'terraform-provider-random' => 1,
	'terraform-provider-rundeck' => 1,
	'terraform-provider-scaleway' => 1,
	'terraform-provider-spotinst' => 1,
	'terraform-provider-statuscake' => 1,
	'terraform-provider-template' => 1,
	'terraform-provider-tls' => 1,
	'terraform-provider-triton' => 1,
	'terraform-provider-ultradns' => 1,
	'terraform-provider-vault' => 1,
	'terraform-provider-vcd' => 1,
	'terraform-provider-vsphere' => 1,
	'radare2-bindings' => 6,
	'py3-django' => 1,
	'py3-django-lts' => 1,
	'dspam' => 3,
	'dspam-mysql' => 3,
	'dspam-pgsql' => 3,
	'py-iniparse' => 5,
	'qt5-declarative-xmllistmodel' => 3,
	'jabberd' => 3,
	'GeoIP' => 22,
	'akpop3d' => 2,
	'gtk+4-cloudprint' => 6,
# 6.8
	'planner' => 3,
	'gnome-recipes' => 3,
	'shared-color-targets' => 6,
	'argyll' => 6,
	'libcroco' => 3,
	'libnipper' => 23,
	'nipper' => 23,
	'bg5pdf' => 13,
	'pdflib' => 23,
	'pop3gwd' => 3,
	'tircd' => 3,
	'gtksourceviewmm3' => 6,
	'hpodder' => 3,
	'hs-HDBC' => 5,
	'hs-HDBC-sqlite3' => 5,
	'hs-ConfigFile' => 5,
	'hs-MissingH' => 5,
	'hs-HaXml' => 5,
	'py-gstreamer' => 5,
	'py-libxslt' => 3,
	'gconf-editor' => 3,
	'amide' => 3,
	'xmedcon' => 3,
	'gq' => 3,
	'gnome-doc-utils' => 3,
	'rarian' => 3,
	'qtcanvas3d' => 3,
	'qtcanvas3d-examples' => 3,
	'gtkparasite' => 3,
	'gutenpy' => 3,
	'klogic' => 3,
	'soprano' => 3,
	'automoc' => 3,
	'qimageblitz' => 3,
	'cagibi' => 3,
	'libkvkontakte' => 3,
	'libkfbapi' => 3,
	'libkgapi' => 3,
	'attica' => 3,
	'kwebkitpart' => 3,
	'grantlee' => 3,
	'libkscreen' => 3,
	'polkit-qt' => 3,
	'phonon-gstreamer' => 3,
	'phonon-gstreamer-icons' => 3,
	'phonon-vlc' => 3,
	'kde4-minimal' => 3,
	'kde4' => 3,
	'kde4-extras' => 3,
	'kdeadmin' => 3,
	'kdegames' => 3,
	'kdenetwork' => 3,
	'kdesdk' => 3,
	'kdetoys' => 3,
	'kdeadmin' => 3,
	'kdegames' => 3,
	'kdenetwork' => 3,
	'kdesdk' => 3,
	'kdetoys' => 3,
	'kde-l10n-ar' => 3,
	'kde-l10n-bg' => 3,
	'kde-l10n-bs' => 3,
	'kde-l10n-ca' => 3,
	'kde-l10n-ca@valencia' => 3,
	'kde-l10n-cs' => 3,
	'kde-l10n-da' => 3,
	'kde-l10n-de' => 3,
	'kde-l10n-el' => 3,
	'kde-l10n-en_GB' => 3,
	'kde-l10n-es' => 3,
	'kde-l10n-et' => 3,
	'kde-l10n-eu' => 3,
	'kde-l10n-fa' => 3,
	'kde-l10n-fi' => 3,
	'kde-l10n-fr' => 3,
	'kde-l10n-ga' => 3,
	'kde-l10n-gl' => 3,
	'kde-l10n-he' => 3,
	'kde-l10n-hi' => 3,
	'kde-l10n-hr' => 3,
	'kde-l10n-hu' => 3,
	'kde-l10n-ia' => 3,
	'kde-l10n-id' => 3,
	'kde-l10n-is' => 3,
	'kde-l10n-it' => 3,
	'kde-l10n-ja' => 3,
	'kde-l10n-kk' => 3,
	'kde-l10n-km' => 3,
	'kde-l10n-ko' => 3,
	'kde-l10n-lt' => 3,
	'kde-l10n-lv' => 3,
	'kde-l10n-mr' => 3,
	'kde-l10n-nb' => 3,
	'kde-l10n-nds' => 3,
	'kde-l10n-nl' => 3,
	'kde-l10n-nn' => 3,
	'kde-l10n-pa' => 3,
	'kde-l10n-pl' => 3,
	'kde-l10n-pt' => 3,
	'kde-l10n-pt_BR' => 3,
	'kde-l10n-ro' => 3,
	'kde-l10n-ru' => 3,
	'kde-l10n-sk' => 3,
	'kde-l10n-sl' => 3,
	'kde-l10n-sr' => 3,
	'kde-l10n-sv' => 3,
	'kde-l10n-tr' => 3,
	'kde-l10n-ug' => 3,
	'kde-l10n-uk' => 3,
	'kde-l10n-wa' => 3,
	'kde-l10n-zh_CN' => 3,
	'kde-l10n-zh_TW' => 3,
	'amor' => 3,
	'audiocd-kio' => 3,
	'baloo-widgets' => 3,
	'ffmpegthumbs' => 3,
	'jovie' => 3,
	'kaccessible' => 3,
	'kactivities' => 3,
	'kde-base-artwork' => 3,
	'kde-emoticons' => 3,
	'kde-runtime' => 3,
	'kde-shared-data' => 3,
	'kde-wallpapers' => 3,
	'kde-workspace' => 3,
	'kde4-kopete-sounds' => 3,
	'kde4-langlist' => 3,
	'kde4-locale' => 3,
	'kde4-locale-en_US' => 3,
	'kdegraphics-strigi-analyzer' => 3,
	'kdelibs' => 3,
	'kdenetwork' => 3,
	'kdenetwork-strigi-analyzers' => 3,
	'kdepim' => 3,
	'kdepim-runtime' => 3,
	'kdepimlibs' => 3,
	'kdeplasma-addons' => 3,
	'kdesdk-strigi-analyzers' => 3,
	'kdewebdev' => 3,
	'kfilemetadata' => 3,
	'kgamma' => 3,
	'kgpg' => 3,
	'kimono' => 3,
	'kopete' => 3,
	'korundum' => 3,
	'kpat' => 3,
	'kppp' => 3,
	'kremotecontrol' => 3,
	'kross-java' => 3,
	'kscd' => 3,
	'ktux' => 3,
	'kuser' => 3,
	'libkcddb' => 3,
	'libkcompactdisc' => 3,
	'libkdeedu' => 3,
	'libkdegames' => 3,
	'libkexiv2' => 3,
	'mplayerthumbs' => 3,
	'nepomuk-core' => 3,
	'nepomuk-widgets' => 3,
	'p5-kde' => 3,
	'p5-qt' => 3,
	'pairs' => 3,
	'parley' => 3,
	'py-kde' => 3,
	'qyoto' => 3,
	'ruby26-qt4' => 3,
	'smokegen' => 3,
	'smokekde' => 3,
	'smokeqt' => 3,
	'superkaramba' => 3,
	'gbirthday' => 24,
	'wireguard-go' => 4,
	'wiresep' => 4,
	'wireless' => 4,
	'sisctrl' => 6,
	'vteplugin' => 0,
	'p5-Net-GPSD' => 5,
	'mozplugger' => 0,
	'ajaxterm' => 3,
	'uim-kde' => 1,
	'uim-qt' => 1,
	'uim-qt4' => 1,
	'dbusmenu-qt' => 5,
	'qlandkartegt' => 25,
	'qca' => 3,
	'qca-gnupg' => 3,
	'qca-ossl' => 3,
	'keepassx' => 26,
	'go-xlsx' => 7,
	'go-check-v1' => 7,
	'freemat' => 6,
	'scim-qtimm' => 6,
	'gambatte-qt' => 6,
	'liblxqt-l10n' => 3,
	'lxqt-about-l10n' => 3,
	'lxqt-config-l10n' => 3,
	'lxqt-notificationd-l10n' => 3,
	'lxqt-openssh-askpass-l10n' => 3,
	'lxqt-panel-l10n' => 3,
	'lxqt-policykit-l10n' => 3,
	'lxqt-powermanagement-l10n' => 3,
	'lxqt-runner-l10n' => 3,
	'lxqt-session-l10n' => 3,
	'lxqt-sudo-l10n' => 3,
	'lximage-l10n' => 3,
	'compton-conf-l10n' => 3,
	'obconf-l10n' => 3,
	'libfm-qt-l10n' => 3,
	'pavucontrol-qt-l10n' => 3,
	'pcmanfm-qt-l10n' => 3,
	'qtermwidget-l10n' => 3,
	'qterminal-l10n' => 3,
	'gmc4cc' => 6,
	'py-sockjs-tornado' => 5,
	'apache-activemq' => 5,
	'libgda-ui' => 5,
	'ocrfeeder' => 6,
	'goocanvas2' => 5,
	'py-termcolor' => 5,
	'py3-termcolor' => 5,
	'py-carddav' => 3,
	'py-rdflib' => 5,
	'py3-rdflib' => 5,
	'fookebox' => 3,
	'py-pylons' => 5,
	'py-routes' => 5,
	'py-weberror' => 5,
	'py-webhelpers' => 5,
	'hedgewars' => 0,
	'lazarus' => 0,
	'fpc' => 5,
	'exaile' => 13,
	'instead-launcher' => 3,
# 6.9
	'py-notify' => 3,
	'glimpse' => 3,
	'py-metlog' => 3,
	'pdfmod' => 3,
	'hyena' => 5,
	'mono-taglib' => 5,
	'spatialite_gis' => 3,
	'librewms' => 3,
	'libgaiagraphics' => 3,
	'librasterlite' => 3,
	'dbus-sharp' => 5,
	'dbus-sharp-glib' => 5,
	'mono-gdata' => 5,
	'mono-notify' => 5,
	'ndesk-dbus' => 5,
	'ndesk-dbus-glib' => 5,
	'mono-xsp' => 5,
	'py-Numeric' => 3,
	'k3dsurf' => 3,
	'spacehulk' => 3,
	'taxipilot' => 3,
	'pympd' => 3,
	'py-vte' => 5,
	'vte' => 5,
	'keybinder' => 6,
	'vinagre' => 3,
	'gnome-getting-started-docs' => 5,
	'py-poppler' => 3,
	'pdfshuffler' => 3,
	'colord' => 27,
	'colord-gtk' => 27,
	'gnome-color-manager' => 5,
	'zeya' => 3,
	'py-trollius' => 3,
	'kde-i18n-af' => 3,
	'kde-i18n-ar' => 3,
	'kde-i18n-az' => 3,
	'kde-i18n-be' => 3,
	'kde-i18n-bg' => 3,
	'kde-i18n-bn' => 3,
	'kde-i18n-br' => 3,
	'kde-i18n-bs' => 3,
	'kde-i18n-ca' => 3,
	'kde-i18n-cs' => 3,
	'kde-i18n-csb' => 3,
	'kde-i18n-cy' => 3,
	'kde-i18n-da' => 3,
	'kde-i18n-de' => 3,
	'kde-i18n-el' => 3,
	'kde-i18n-en_GB' => 3,
	'kde-i18n-eo' => 3,
	'kde-i18n-es' => 3,
	'kde-i18n-et' => 3,
	'kde-i18n-eu' => 3,
	'kde-i18n-fa' => 3,
	'kde-i18n-fi' => 3,
	'kde-i18n-fr' => 3,
	'kde-i18n-fy' => 3,
	'kde-i18n-ga' => 3,
	'kde-i18n-gl' => 3,
	'kde-i18n-he' => 3,
	'kde-i18n-hi' => 3,
	'kde-i18n-hr' => 3,
	'kde-i18n-hu' => 3,
	'kde-i18n-is' => 3,
	'kde-i18n-it' => 3,
	'kde-i18n-ja' => 3,
	'kde-i18n-kk' => 3,
	'kde-i18n-km' => 3,
	'kde-i18n-ko' => 3,
	'kde-i18n-lt' => 3,
	'kde-i18n-lv' => 3,
	'kde-i18n-mk' => 3,
	'kde-i18n-mn' => 3,
	'kde-i18n-ms' => 3,
	'kde-i18n-nb' => 3,
	'kde-i18n-nds' => 3,
	'kde-i18n-nl' => 3,
	'kde-i18n-nn' => 3,
	'kde-i18n-pa' => 3,
	'kde-i18n-pl' => 3,
	'kde-i18n-pt' => 3,
	'kde-i18n-pt_BR' => 3,
	'kde-i18n-ro' => 3,
	'kde-i18n-ru' => 3,
	'kde-i18n-rw' => 3,
	'kde-i18n-se' => 3,
	'kde-i18n-sk' => 3,
	'kde-i18n-sl' => 3,
	'kde-i18n-sr' => 3,
	'kde-i18n-sr@Latn' => 3,
	'kde-i18n-ss' => 3,
	'kde-i18n-sv' => 3,
	'kde-i18n-ta' => 3,
	'kde-i18n-te' => 3,
	'kde-i18n-tg' => 3,
	'kde-i18n-th' => 3,
	'kde-i18n-tr' => 3,
	'kde-i18n-uk' => 3,
	'kde-i18n-uz' => 3,
	'kde-i18n-uz@cyrillic' => 3,
	'kde-i18n-vi' => 3,
	'kde-i18n-wa' => 3,
	'kde-i18n-zh_CN' => 3,
	'kde-i18n-zh_TW' => 3,
	'kde-shared-data' => 3,
	'kde3-langlist' => 3,
	'kde3-locale' => 3,
	'kde3-locale-en_US' => 3,
	'kdeaccessibility' => 3,
	'kdebase' => 3,
	'kdegames' => 3,
	'kdelibs' => 3,
	'kdesamba' => 3,
	'qt3-examples' => 3,
	'qt3-html' => 3,
	'qt3-mt' => 3,
	'qt3-mysql' => 3,
	'qt3-postgresql' => 3,
	'qt3-sqlite2' => 3,
	'gtk3mm-documentation' => 6,
	'libxml++3' => 5,
	'orage' => 3,
	'xfce4-statusnotifier' => 3,
	'pylint3-gui' => 3,
	'e_dbus' => 3,
	'ecore' => 3,
	'edje' => 3,
	'eet' => 3,
	'efreet' => 3,
	'eina' => 3,
	'eio' => 3,
	'elementary' => 3,
	'embryo' => 3,
	'emotion' => 3,
	'enlightenment' => 3,
	'ethumb' => 3,
	'evas' => 3,
	'qtstyleplugins' => 3,
	'p5-Regexp-Copy' => 0,
	'mcollective-puppet-agent' => 28,
	'kdepim-apps-libs' => 3,
	'gns3' => 29,
	'py-qt4' => 3,
	'py-qt4-docs' => 3,
	'hitch' => 29,
	'xtraceroute' => 30,
	'py-vorbis' => 31,
	'py-ogg' => 31,
	'sattrack' => 32,
	'sattrack' => 33,
	'packit' => 34,
	'nemesis' => 34,
	'lxnb' => 6,
	'siphon' => 35,
	'avinfo' => 6,
	'xfed' => 0,
	'www6to4' => 36,
	'gimmix' => 37,
	'xhippo' => 3,
	'hnb' => 0,
	'icinga' => 38,
	'icinga-web' => 38,
	'icinga-cgi' => 38,
	'icinga-idoutils' => 38,
	'swftools' => 39,
	'swfmill' => 39,
	'ming' => 39,
	'quvi' => 39,
	'libquvi' => 39,
	'libquvi-scripts' => 39,
	'cclive' => 6,
	'viz' => 4,
	'driftnet' => 40,
	'enjoympeg' => 6,
	'trac-ldapplugin' => 6,
	'xboing' => 0,
	'beaver' => 3,
	'tracnav' => 3,
	'flasm' => 39,
	'mpd-add-similar' => 31,
	'py-mpd' => 31,
	'abs' => 3,
	'arena' => 3,
	'teagtk' => 3,
	'hs-cryptohash-sha256' => 5,
	'hs-ed25519' => 5,
	'hs-hackage-security' => 5,
	'tempwatch' => 5,
	'avenger' => 29,
	'mk' => 41,
	'sabredav' => 1,
	'mollify' => 3,
	'seyon' => 3,
	'mingw' => 6,
	'bsd-airtools' => 3,
	'gtkpod' => 3,
	'golem' => 0,
	'py-beautifulsoup' => 14,
	'wmmultipop3' => 3,
	'wmpop3' => 3,
	'angst' => 3,
	'audiopreview' => 3,
	'pcsxr' => 3,
	'libbio' => 41,
	'libfmt' => 41,
	'libregexp9' => 41,
	'libutf' => 41,
	'hs-FindBin' => 5,
	'hs-HTTP' => 5,
	'hs-HUnit' => 5,
	'hs-QuickCheck' => 5,
	'hs-SHA' => 5,
	'hs-X11' => 5,
	'hs-X11-xft' => 5,
	'hs-ansi-terminal' => 5,
	'hs-ansi-wl-pprint' => 5,
	'hs-async' => 5,
	'hs-attoparsec' => 5,
	'hs-base-compat' => 5,
	'hs-base16-bytestring' => 5,
	'hs-base64-bytestring' => 5,
	'hs-byteable' => 5,
	'hs-bytestring-show' => 5,
	'hs-cereal' => 5,
	'hs-cmdargs' => 5,
	'hs-colour' => 5,
	'hs-conduit' => 5,
	'hs-constraints' => 5,
	'hs-convertible' => 5,
	'hs-crypto-api' => 5,
	'hs-cryptohash' => 5,
	'hs-data-default' => 5,
	'hs-data-ordlist' => 5,
	'hs-dbus' => 5,
	'hs-digest' => 5,
	'hs-dlist' => 5,
	'hs-echo' => 5,
	'hs-edit-distance' => 5,
	'hs-enclosed-exceptions' => 5,
	'hs-entropy' => 5,
	'hs-exceptions' => 5,
	'hs-extensible-exceptions' => 5,
	'hs-fgl' => 5,
	'hs-graphviz' => 5,
	'hs-hashable' => 5,
	'hs-hinotify' => 5,
	'hs-hostname' => 5,
	'hs-hslogger' => 5,
	'hs-html' => 5,
	'hs-json' => 5,
	'hs-libmpd' => 5,
	'hs-libxml-sax' => 5,
	'hs-lifted-async' => 5,
	'hs-lifted-base' => 5,
	'hs-mmap' => 5,
	'hs-mmorph' => 5,
	'hs-monad-control' => 5,
	'hs-mono-traversable' => 5,
	'hs-nats' => 5,
	'hs-network' => 5,
	'hs-network-uri' => 5,
	'hs-old-locale' => 5,
	'hs-old-time' => 5,
	'hs-polyparse' => 5,
	'hs-primitive' => 5,
	'hs-random' => 5,
	'hs-regex-applicative' => 5,
	'hs-regex-base' => 5,
	'hs-regex-compat' => 5,
	'hs-regex-compat-tdfa' => 5,
	'hs-regex-posix' => 5,
	'hs-regex-tdfa' => 5,
	'hs-resourcet' => 5,
	'hs-sandi' => 5,
	'hs-scientific' => 5,
	'hs-semigroups' => 5,
	'hs-shelly' => 5,
	'hs-split' => 5,
	'hs-syb' => 5,
	'hs-system-fileio' => 5,
	'hs-system-filepath' => 5,
	'hs-tagged' => 5,
	'hs-tar' => 5,
	'hs-temporary' => 5,
	'hs-test-framework' => 5,
	'hs-test-framework-hunit' => 5,
	'hs-test-framework-quickcheck2' => 5,
	'hs-tf-random' => 5,
	'hs-transformers-base' => 5,
	'hs-transformers-compat' => 5,
	'hs-unix-compat' => 5,
	'hs-unliftio-core' => 5,
	'hs-unordered-containers' => 5,
	'hs-utf8-string' => 5,
	'hs-vector' => 5,
	'hs-vector-algorithms' => 5,
	'hs-void' => 5,
	'hs-wl-pprint-text' => 5,
	'hs-xml' => 5,
	'hs-xml-types' => 5,
	'hs-xmonad-contrib' => 5,
	'hs-zip-archive' => 5,
	'hs-zlib' => 5,
	'gstreamer' => 6,
	'gstreamer-ffmpeg' => 6,
	'gstreamer-plugins-bad' => 6,
	'gstreamer-plugins-base' => 6,
	'gstreamer-plugins-gl' => 6,
	'gstreamer-plugins-good' => 6,
	'gstreamer-plugins-ugly' => 6,
	'lives' => 42,
	'py-wsgiproxy' => 5,
	'py-sqlite' => 5,
	'upt' => 43,
	'upt-cpan' => 43,
	'upt-openbsd' => 43,
	'upt-pypi' => 43,
	'upt-rubygems' => 43,
	'p5-VCP-autrijus' => 3,
};

# reasons for obsolete packages
my @msg = (
	"ancient software that doesn't work", #0
	"no benefit to being packaged", #1
	"no longer maintained and full of security holes", #2
	"no longer maintained upstream", #3
	"superseded by base component", #4
	"outdated and/or no longer required by other ports", #5
	"no longer useful", #6
	"removed in favor of using languages package manager", #7
	"requires systemd", #8
	"256 colors only, suggest scrot or xwd", #9
	"has been replaced by opendkim", #10
	"no longer packageable", #11
	"replace with IMAPSieve, see https://wiki.dovecot.org/HowTo/AntispamWithSieve", #12
	"has a dependency on obsolete software", #13
	"python2 port superseded by python3 version", #14
	"no longer maintained upstream, suggest homebank, gnucash, kmymoney", #15
	"no longer maintained upstream, suggest kigo", #16
	"old GeoIP databases end-of-life, see alternative using geoip2/libmaxminddb", #17
	"no longer maintained upstream, suggest kompare", #18
	"no longer maintained upstream, suggest sqlitebrowser, kexi", #19
	"merged into IETF Opus codec, obsolete, audio/mumble uses bundled version now", #20
	"upstream recommends to use composer to build a drupal site", #21
	"the original GeoIP database is end of life; use libmaxminddb/GeoIP2", #22
	"no longer maintained upstream, became commercial over ten years ago", #23
	"no longer maintained upstream, suggest qbirthday", #24
	"no longer maintained upstream, suggest qmapshack", #25
	"outdated Qt4 application, suggest keepassxc", #26
	"requires GUdev or GUsb", #27
	"consider migrating MCollective agents and filters using tools like Bolt and PuppetDB's Puppet Query Language", #28
	"unmaintained port that was blocking other changes in ports", #29
	"crashes in many different ways at runtime, does not build with '-fno-common'", #30
	"upstream is dead, python2-only, nothing uses it", #31
	"no more public distfiles, license forbids distributing package due to local changes", #32
	"no longer maintained upstream, website suggests https://cronometer.com until rewrite is done", #33
	"upstream is dead, basic functionality does not work, use tcpdump(1) and scapy(1) instead", #34
	"upstream is dead, no longer useful, does not support IPv6", #35
	"ancient software, use pf.conf(5) 'af-to'", #36
	"upstream is dead, default settings cause crash when connecting to mpd", #37
	"icinga 1 is end-of-life, migrate to icinga 2 (needs config rewrite)", #38
	"Flash/SWF is end-of-life", #39
	"ancient software that often crashes and relies on single HTTP (no TLS) connections, use wireshark", #40
	"upstream moved to unversioned tarballs, use the plan9port (same upstream) package instead", #41
	"unmaintained port that was blocking other changes in ports, suggest kdenlive or shotcut", #42
	"using portgen instead is recommended", #43
);

# ->is_base_system($handle, $state):
#	checks whether an existing handle is now part of the base system
#	and thus no longer needed.

sub is_base_system
{
	my ($self, $handle, $state) = @_;

	my $pkgname = $handle->pkgname;
	my $stem = OpenBSD::PackageName::splitstem($pkgname);

	my $test = $base_exceptions->{$stem};
	if (defined $test) {
		require File::Glob;
		if (defined File::Glob::bsd_glob($test)) {
			$state->say("Removing #1 #2", $handle->pkgname,
			    " (part of base system now)");
			return 1;
		} else {
			$state->say("Not removing #1 #2 #3 #4", $handle->pkgname,
			 ", ", $test, " not found");
			return 0;
		}
	} else {
		return 0;
	}
}

# ->filter_obsolete(\@list)
# explicitly mark packages as no longer there. Remove them from the
# list of "normal" stuff.

sub filter_obsolete
{
	my ($self, $list, $state) = @_;
	my @in = @$list;
	$list = [];
	for my $pkgname (@in) {
		my $stem = OpenBSD::PackageName::splitstem($pkgname);
		my $reason = $obsolete_reason->{$stem};
		$reason = 3 if (!defined $reason && $pkgname =~ m/^(ruby(19|2[0-5])-|ruby-[^0-9])/);
		$reason = 21 if (!defined $reason && $pkgname =~ m/^drupal/);
		if (defined $reason) {
			$state->say("Obsolete package: #1 (#2)", $pkgname, 
			    $msg[$reason]);
		} else {
			push(@$list, $pkgname);
		}
	}
}


# ->tweak_search(\@s, $handle, $state):
#	tweaks the normal search for a given handle, in case (for instance)
#	of a stem name change.

sub tweak_search
{
	my ($self, $l, $handle, $state) = @_;

	if (@$l == 0 || !$l->[0]->can("add_stem")) {
		return;
	}
	my $stem = OpenBSD::PackageName::splitstem($handle->pkgname);
	my $extra = $stem_extensions->{$stem};
	if (defined $extra) {
		if (ref $extra) {
			for my $e (@$extra) {
				$l->[0]->add_stem($e);
			}
		} else {
			$l->[0]->add_stem($extra);
		}
	}
}

# list of
#   cat/path => badspec
my $cve = {
	'archivers/brotli' => 'brotli-<1.0.9',
	'archivers/cabextract' => 'cabextract-<1.8',
	'archivers/libmspack' => 'libmspack-<0.8alpha',
	'archivers/lz4' => 'lz4-<1.9.3p0',
	'archivers/p5-Archive-Zip' => 'p5-Archive-Zip-<1.64',
	'audio/flac' => 'flac-<1.3.0p1',
	'databases/mariadb,-main' => 'mariadb-client-<10.3.22',
	'databases/mariadb,-server' => 'mariadb-server-<10.3.15',
	'databases/postgresql,-main' => 'postgresql-client-<10.6',
	'databases/postgresql,-server' => 'postgresql-server-<10.6',
	'databases/sqlite3' => 'sqlite3-<3.25.3',
	'devel/apache-ant' => 'apache-ant-<1.10.9',
	'devel/git,-main' => 'git-<2.30.2',
	'devel/git,-svn' => 'git-svn-<2.30.2',
	'devel/git,-x11' => 'git-x11-<2.30.2',
	'devel/jenkins/devel' => 'jenkins-<2.154',
	'devel/jenkins/stable' => 'jenkins-<2.138.4',
	'devel/libgit2/libgit2' => 'libgit2-<0.27.7',
	'devel/mercurial,-main' => 'mercurial-<4.5.3p1',
	'devel/mercurial,-x11' => 'mercurial-x11-<4.5.3p1',
	'devel/pcre' => 'pcre-<8.38',
	'devel/sdl2-image' => 'sdl2-image-<2.0.4',
	'editors/vim,-main' => 'vim-<8.1.1483',
	'graphics/png' => 'png-<1.6.37',
	'graphics/tiff' => 'tiff-<4.0.4beta',
	'lang/php/7.1,-main' => 'php->7.1,<7.1.29',
	'lang/php/7.2,-main' => 'php->7.2,<7.2.18',
	'lang/php/7.3,-main' => 'php->7.3,<7.3.5',
	'lang/python/2.7,-main' => 'python->2.7,<2.7.16',
	'lang/python/3.7,-main' => 'python->3.7,<3.7.9',
	'lang/python/3.8,-main' => 'python->3.8,<3.8.8',
	'lang/python/3.9,-main' => 'python->3.9,<3.9.2',
	'lang/ruby/2.3,-main' => 'ruby-<2.3.8',
	'lang/ruby/2.4,-main' => 'ruby->2.4,<2.4.5p2',
	'lang/ruby/2.5,-main' => 'ruby->2.5,<2.5.5',
	'lang/ruby/2.6,-main' => 'ruby->2.6,<2.6.2',
	'mail/dovecot,-server' => 'dovecot-<2.3.10.1',
	'mail/exim' => 'exim-<4.83',
	'mail/isync' => 'isync-<1.3.5',
	'mail/mailman' => 'mailman-<2.1.30',
	'mail/p5-Mail-SpamAssassin' => 'p5-Mail-SpamAssassin-<3.4.4',
	'mail/roundcubemail' => 'roundcubemail-<1.3.8',
	'math/hdf5' => 'hdf5-<1.8.21',
	'multimedia/libquicktime' => 'libquicktime-<1.2.4p13',
	'net/curl' => 'curl-<7.65.0',
	'net/dhcpcd' => 'dhcpcd-<7.2.2',
	'net/haproxy' => 'haproxy-<2.0.14',
	'net/icecast' => 'icecast-<2.4.4',
	'net/irssi' => 'irssi-<1.2.1',
	'net/isc-bind' => 'isc-bind-<9.16.3',
	'net/libssh' => 'libssh-<0.9.5',
	'net/libssh2' => 'libssh2-<1.8.2',
	'net/lldpd' => 'lldpd-<0.7.18p0',
	'net/mosquitto' => 'mosquitto-<1.5.6',
	'net/ntp' => 'ntp-<4.2.8pl7',
	'net/openconnect' => 'openconnect-<8.10',
	'net/openvpn' => 'openvpn-<2.4.9',
	'net/powerdns,-main' => 'powerdns-<4.1.5',
	'net/powerdns,-mysql' => 'powerdns-mysql-<4.1.5',
	'net/powerdns,-pgsql' => 'powerdns-pgsql-<4.1.5',
	'net/powerdns_recursor' => 'powerdns-recursor-<4.3.1',
	'net/rsync' => 'rsync-<3.1.3p0',
	'net/samba,-main' => 'samba-<4.8.18',
	'net/tinc' => 'tinc-<1.0.35v0',
	'net/transmission,-gtk' => 'transmission-gtk-<2.84',
	'net/transmission,-main' => 'transmission-<2.84',
	'net/transmission,-qt' => 'transmission-qt-<2.84',
	'net/wget' => 'wget-<1.20.3',
	'net/wireshark,-gtk' => 'wireshark-gtk-<2.6.3',
	'net/wireshark,-main' => 'wireshark-<2.6.3',
	'net/wireshark,-text' => 'tshark-<2.6.3',
	'net/zeromq' => 'zeromq-<4.3.3',
	'net/znc' => 'znc-<1.7.3',
	'print/cups,-main' => 'cups-<1.7.4',
	'security/clamav' => 'clamav-<0.100.2',
	'security/libssh' => 'libssh-<0.9.4',
	'security/opensc' => 'opensc-<0.20.0',
	'security/openssl/1.1' => 'openssl-<1.1.1g',
	'security/polarssl' => 'mbedtls-<2.16.6',
	'security/sudo' => 'sudo-<1.8.31',
	'shells/bash' => 'bash-<4.3.27',
	'sysutils/ansible,-main' => 'ansible-<2.7.1',
	'sysutils/mcollective' => 'mcollective-<2.5.3',
	'sysutils/rclone' => 'rclone-<1.53.3',
	'sysutils/salt' => 'salt-<3002',
	'telephony/asterisk,-main' => 'asterisk-<13.23.1',
	'telephony/coturn' => 'turnserver-<4.5.1.2',
	'textproc/mdbook' => 'mdbook-<0.4.6',
	'www/apache-httpd,-main' => 'apache-httpd-<2.4.35',
	'www/bozohttpd' => 'bozohttpd-<20130711p0',
	'www/chromium' => 'chromium-<69.0.3497.100',
	'www/drupal7/core7' => 'drupal->=7.0,<7.60',
	'www/drupal7/theme-newsflash' => 'drupal7-theme-newsflash-<2.5',
	'www/gitea' => 'gitea-<1.7.6',
	'www/hiawatha' => 'hiawatha-<10.8.4',
	'www/iridium' => 'iridium-<2018.5.67',
	'www/jupyter-notebook' => 'jupyter-notebook-<5.7.8',
	'www/jupyter-notebook,python3' => 'jupyter-notebook3-<5.7.8',
	'www/mozilla-firefox' => 'firefox-<62.0.2p0',
	'www/nginx' => 'nginx-<1.4.1',
	'www/p5-CGI-Application' => 'p5-CGI-Application-<4.50p0',
	'www/p5-Catalyst-Plugin-Static-Simple' => 'p5-Catalyst-Plugin-Static-Simple-<0.36',
	'www/privoxy' => 'privoxy-<3.0.31',
	'www/py-django/lts' => 'py-django-lts-<1.11.19',
	'www/py-django/stable' => 'py-django-<2.1.6',
	'www/py-requests' => 'py-requests-<2.20.0',
	'www/py-requests,python3' => 'py3-requests-<2.20.0',
	'www/py-urllib3' => 'py-urllib3-<1.24.3',
	'www/py-urllib3,python3' => 'py3-urllib3-<1.24.3',
	'www/ruby-rack,ruby24' => 'ruby24-rack-<2.0.6',
	'www/ruby-rack,ruby25' => 'ruby25-rack-<2.0.6',
	'www/tomcat/v7' => 'tomcat-<7.0.104',
	'www/tomcat/v8' => 'tomcat-<8.5.55',
	'www/tomcat/v9' => 'tomcat-<9.0.35',
	'www/webkitgtk4' => 'webkitgtk4-<2.20.5',
	'x11/gnome/gdm' => 'gdm-<3.28.3',
	'x11/rdesktop' => 'rdesktop-<1.8.4',
};
# please maintain sort order in above $cve list, future updates need to
# replace existing entries

for my $sub (qw(calendar http_post ldap odbc pgsql snmp speex tds)) {
	$cve->{"telephony/asterisk,-$sub"} = "asterisk-$sub-<13.23.1";
}

for my $sub (qw(apache cgi dbg bz2 curl dba gd gmp intl imap ldap mysqli
    odbc pcntl pdo_mysql pdo_odbc pdo_pgsql pdo_sqlite pgsql pspell
    shmop soap snmp sqlite3 pdo_dblib tidy xmlrpc xsl zip mysql
    sybase_ct mssql mcrypt)) {
	$cve->{"lang/php/7.1,-$sub"} = "php-$sub->7.1,<7.1.22";
	$cve->{"lang/php/7.2,-$sub"} = "php-$sub->7.2,<7.2.10";
}


# ->check_security($path)
#	return an insecure specification for the matching path
#	e.g., you should update.

sub check_security
{
	my ($self, $path) = @_;
	if (defined $cve->{$path}) {
		return $cve->{$path};
	} else {
		return undef;
	}
}

my $optional_tag = {
#	emacs => 'emacs-*|xemacs-*',
};

# -> is_optional_tag($tag)
#	return either undef or a pkgspec where to find the definition

sub is_optional_tag
{
	my ($self, $tag) = @_;
	return $optional_tag->{$tag->name};
}

1;
