.\" Copyright 1988, 1994, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\"
.Dd $Mdocdate: August 30 2021 $
.Dt XENODM 1
.Os __xorgversion__
.Sh NAME
.Nm xenodm
.Nd X Display Manager
.Sh SYNOPSIS
.Nm xenodm
.Op Fl config Ar configuration_file
.Op Fl nodaemon
.Op Fl debug Ar debug_level
.Op Fl error Ar error_log_file
.Op Fl resources Ar resource_file
.Op Fl server Ar server_entry
.Op Fl session Ar session_program
.Sh DESCRIPTION
.Nm
manages a collection of X displays on the local host.
.Nm
provides services similar to those provided by
.Xr getty 8
and
.Xr login 1
on character terminals: prompting for login name and password,
authenticating the user, and running a
.Dq session .
.Pp
A
.Dq session
is defined by the lifetime of a particular process; in the
traditional character-based terminal world, it is the user's login shell.
In the
.Nm
context, it is an arbitrary session manager.
This is because in a windowing environment,
a user's login shell process does not necessarily have any terminal-like
interface with which to connect.
When a real session manager is not available, a window manager or terminal
emulator is typically used as the
.Dq session manager ,
meaning that termination of this process terminates the user's session.
.Pp
When the session is terminated,
.Nm
resets the X server and (optionally) restarts the whole process.
.Pp
Because
.Nm
provides the first interface that users will see, it is designed to be
simple to use and easy to customize to the needs of a particular site.
.Nm
has many options, most of which have reasonable defaults.
Browse through the various sections of this manual,
picking and choosing the things you want to change.
Pay particular attention to the
.Sx SESSION PROGRAM
section, which will describe how to set up the style of session desired.
.Sh OVERVIEW
.Nm
is highly configurable,
and most of its behavior can be controlled by resource files and shell scripts.
The names of these files themselves are resources read from the file
.Pa xenodm-config
or the file named by the
.Fl config
option.
.Pp
.Nm
can manage X servers running on the local machine and specified in
.Pa Xservers .
.Pp
The resources of the X clients run by
.Nm
outside the user's session, including
.Nm Ns 's
own login window, can be affected by setting resources in the
.Pa Xresources
file.
.Pp
If
.Ic autoLogin
is not set (the default), after resetting the X server,
.Nm
runs the
.Pa Xsetup
script to assist in setting up the screen the user sees along with the
xlogin widget, which
.Nm
presents.
The xlogin widget offers the familiar login and password prompts.
.Pp
If
.Ic autoLogin
is set the designated user is automatically logged in.
.Pp
After the user logged in,
.Nm
runs the
.Pa Xstartup
script as root.
.Pp
Then
.Nm
runs the
.Pa Xsession
script as the user.
This system session file may do some additional startup and typically runs the
.Pa .xsession
script in the user's home directory.
When the
.Pa Xsession
script exits, the session is over.
.Pp
At the end of the session, the
.Pa Xreset
script is run to clean up, the X server is reset, and the cycle starts over.
.Pp
The file
.Pa XENODMLOGDIR/xenodm.log
will contain error messages from
.Nm
and anything output to
.Dv stderr
by
.Pa Xsetup , Xstartup , Xsession
or
.Pa Xreset .
When you have trouble getting
.Nm
working, check this file to see if
.Nm
has any clues to the trouble.
.Sh OPTIONS
All of these options, except
.Fl config
itself, specify values that can also be specified in the configuration file
as resources.
.Bl -tag -width Ds
.It Fl config Ar configuration_file
Names the configuration file, which specifies resources to control
the behavior of
.Nm .
.Pa XENODMDIR/xenodm-config
is the default.
See the section
.Sx CONFIGURATION FILE .
.It Fl nodaemon
Specifies
.Cm false
as the value for the
.Ic DisplayManager.daemonMode
resource.
This suppresses the normal daemon behavior, which is for
.Nm
to close all file descriptors,
disassociate itself from the controlling terminal,
and put itself in the background when it first starts up.
.It Fl debug Ar debug_level
Specifies the numeric value for the
.Ic DisplayManager.debugLevel
resource.
A non-zero value causes
.Nm
to print lots of debugging statements to the terminal; it also disables the
.Ic DisplayManager.daemonMode
resource, forcing
.Nm
to run synchronously.
To interpret these debugging messages, a copy of the source code for
.Nm
is almost a necessity.
No attempt has been made to rationalize or standardize the output.
.It Fl error Ar error_log_file
Specifies the value for the
.Ic DisplayManager.errorLogFile
resource.
This file contains errors from
.Nm
as well as anything written to
.Dv stderr
by the various scripts and programs run during the progress of the session.
.It Fl resources Ar resource_file
Specifies the value for the
.Ic DisplayManager*resources
resource.
This file is loaded using
.Xr xrdb 1
to specify configuration parameters for the authentication widget.
.It Fl server Ar server_entry
Specifies the value for the
.Ic DisplayManager.servers
resource.
See the section
.Sx LOCAL SERVER SPECIFICATION
for a description of this resource.
.It Fl session Ar session_program
Specifies the value for the
.Ic DisplayManager*session
resource.
This indicates the program to run as the session after the user has logged in.
.It Fl xrm Ar resource_specification
Allows an arbitrary resource to be specified, as in most X Toolkit applications.
.El
.Sh RESOURCES
At many stages the actions of
.Nm
can be controlled through the use of its configuration file, which is in the
X resource format.
Some resources modify the behavior of
.Nm
on all displays, while others modify its behavior on a single display.
Where actions relate to a specific display,
the display name is inserted into the resource name between
.Dq DisplayManager
and the final resource name segment.
.Pp
For local displays, the resource name and class are as read from the
.Pa Xservers
file.
.Pp
Because the resource manager uses colons to separate the name of the resource
from its value and dots to separate resource name parts,
.Nm
substitutes underscores for both dots and colons when generating the resource
name.
For example,
.Ic DisplayManager.expo_x_org_0.startup
is the name of the resource which defines the startup shell file for the
.Dq expo.x.org:0
display.
.Bl -tag -width Ds
.It Ic DisplayManager.servers
This resource either specifies a file name full of server entries, one per
line (if the value starts with a slash), or a single server entry.
See the section
.Sx LOCAL SERVER SPECIFICATION
for the details.
.It Ic DisplayManager.errorLogFile
Error output is normally directed at the system console.
To redirect it, set this resource to a file name.
A method to send these messages to
.Xr syslog 3
should be developed for systems which support it; however, the wide variety
of interfaces precludes any system-independent implementation.
This file also contains any output directed to
.Dv stderr
by the
.Pa Xsetup , Xstartup , Xsession
and
.Pa Xreset
files, so it will contain descriptions of problems in those scripts as well.
.It Ic DisplayManager.debugLevel
If the integer value of this resource is greater than zero,
reams of debugging information will be printed.
It also disables daemon mode, which would redirect the information into
the bit-bucket, and allows non-root users to run
.Nm ,
which would normally not be useful.
.It Ic DisplayManager.daemonMode
Normally,
.Nm
attempts to make itself into a daemon process unassociated with any terminal.
This is accomplished by forking and leaving the parent process to exit,
then closing file descriptors and releasing the controlling terminal.
In some environments this is not desired (in particular, when debugging).
Setting this resource to
.Cm false
will disable this feature.
.It Ic DisplayManager.authDir
This names a directory under which
.Nm
stores authorization files while initializing the session.
The default value is
.Pa XENODMXAUTHDIR .
Can be overridden for specific displays by
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .authFile .
.It Ic DisplayManager.autoRescan
This boolean controls whether
.Nm
rescans the configuration, servers, access control and authentication keys
files after a session terminates and the files have changed.
By default it is
.Cm true .
You can force
.Nm
to reread these files by sending a
.Dv SIGHUP
to the main process.
.It Ic DisplayManager.exportList
A list of additional environment variables, separated by white space,
to pass on to the
.Pa Xsetup , Xstartup , Xsession ,
and
.Pa Xreset
programs.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .autoLogin
This resource specifies the name of an user that will be logged in
automatically, without displaying the xlogin widget.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .resources
This resource specifies the name of the file to be loaded by
.Xr xrdb 1
as the resource database onto the root window of screen 0 of the display.
The
.Pa Xsetup
program and the Login widget will use the resources set in this file.
This resource database is loaded just before the authentication procedure
is started, so it can control the appearance of the login window.
See the section
.Sx AUTHENTICATION WIDGET ,
which describes the various resources
that are appropriate to place in this file.
There is no default value for this resource, but
.Pa XENODMDIR/Xresources
is the conventional name.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .xrdb
Specifies the program used to load the resources.
By default,
.Nm
uses
.Pa BINDIR/xrdb .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .cpp
This specifies the name of the C preprocessor which is used by
.Xr xrdb 1 .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .setup
This specifies a program which is run (as root) before offering the
Login window.
This may be used to change the appearance of the screen
around the Login window or to put up other windows (e.g., you may want
to run
.Xr xconsole 1
here).
By default, no program is run.
The conventional name for a file used here is
.Pa Xsetup .
See the section
.Sx SETUP PROGRAM .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .startup
This specifies a program which is run (as root) after the authentication
process succeeds.
By default, no program is run.
The conventional name for a file used here is
.Pa Xstartup .
See the section
.Sx STARTUP PROGRAM .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .session
This specifies the session to be executed (not running as root).
By default,
.Pa BINDIR/xterm
is run.
The conventional name is
.Pa Xsession .
See the section
.Sx SESSION PROGRAM .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .reset
This specifies a program which is run (as root) after the session terminates.
By default, no program is run.
The conventional name is
.Pa Xreset .
See the section
.Sx RESET PROGRAM .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .openDelay
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .openRepeat
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .openTimeout
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .startAttempts
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .reservAttempts
These numeric resources control the behavior of
.Nm
when attempting to open intransigent servers.
.Ic openDelay
is the length of the pause in seconds between successive attempts,
.Ic openRepeat
is the number of attempts to make,
.Ic openTimeout
is the amount of time to wait while actually attempting the open
(i.e., the maximum time spent in the
.Xr connect 2
system call) and
.Ic startAttempts
is the number of times this entire process is done
before giving up on the server.
After
.Ic openRepeat
attempts have been made, or if
.Ic openTimeout
seconds elapse in any particular attempt,
.Nm
terminates and restarts the server, attempting to connect again.
This process is repeated
.Ic startAttempts
times, at which point the display is declared dead and disabled.
Although this behavior may seem arbitrary,
it has been empirically developed and works quite well on most systems.
The bound
.Ic reservAttempts
is the number of times a successful connect is allowed to be followed
by a fatal error.
When reached, the display is disabled.
The default values are
.Ic openDelay :
15,
.Ic openRepeat :
5,
.Ic openTimeout :
120,
.Ic startAttempts :
4 and
.Ic reservAttempts :
2.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .terminateServer
This boolean resource specifies whether the X server should be terminated
when a session terminates (instead of resetting it).
This option can be used when the server tends to grow without bound over time,
in order to limit the amount of time the server is run.
The default value is
.Cm false .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .userPath
.Nm
sets the
.Ev PATH
environment variable for the session to this value.
It should be a colon separated list of directories; see
.Xr sh 1
for a full description.
The default value is
.Dq DEF_USER_PATH .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .systemPath
.Nm
sets the
.Ev PATH
environment variable for the startup and reset scripts to the
value of this resource.
The default for this resource is
.Dq DEF_SYSTEM_PATH .
Note the absence of
.Ql \&.
from this entry.
This is a good practice to follow for root;
it avoids many common Trojan Horse system penetration schemes.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .systemShell
.Nm
sets the
.Ev SHELL
environment variable for the startup and reset scripts to the
value of this resource.
It is
.Pa /bin/sh
by default.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .failsafeClient
If the default session fails to execute,
.Nm
will fall back to this program.
This program is executed with no arguments,
but executes using the same environment variables as the session would have had
(see the section
.Sx SESSION PROGRAM ) .
By default,
.Pa BINDIR/xterm
is used.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .grabServer
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .grabTimeout
To improve security,
.Nm
grabs the server and keyboard while reading the login name and password.
The
.Ic grabServer
resource specifies if the server should be held
for the duration of the name/password reading.
When
.Cm false ,
the server is ungrabbed after the keyboard grab succeeds,
otherwise the server is grabbed until just before the session begins.
The default is
.Cm false .
The
.Ic grabTimeout
resource specifies the maximum time
.Nm
will wait for the grab to succeed.
The grab may fail if some other client has the server grabbed,
or possibly if the network latencies are very high.
This resource has a default value of 3 seconds; you should be cautious when
raising it, as a user can be spoofed by a look-alike window on the display.
If the grab fails,
.Nm
kills and restarts the server (if possible) and the session.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .authorize
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .authName
.Ic authorize
is a boolean resource which controls whether
.Nm
generates and uses authorization for the local server connections.
If
authorization is used,
.Ic authName
is a list of authorization mechanisms to use, separated by white space.
When
.Ic authorize
is set for a display and authorization is not available, the user is informed
by having a different message displayed in the login widget.
By default,
.Ic authorize
is
.Cm true ,
.Ic authName
is
.Dq MIT-MAGIC-COOKIE-1 ,
or, if
XDM-AUTHORIZATION-1 is available,
.Dq XDM-AUTHORIZATION-1 MIT-MAGIC-COOKIE-1 .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .authFile
This file is used to communicate the authorization data from
.Nm
to the server, using the
.Fl auth
server command line option.
It should be kept in a directory which is not world-writable as it could easily
be removed, disabling the authorization mechanism in the server.
If not specified, a name is generated from DisplayManager.authDir and
the name of the display.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .authComplain
If set to
.Cm false ,
disables the use of the
.Ic unsecureGreeting
in the login window.
See the section
.Sx AUTHENTICATION WIDGET .
The default is
.Cm true .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .resetSignal
The number of the signal
.Nm
sends to reset the server.
See the section
.Sx CONTROLLING THE SERVER .
The default is 1
.Pq Dv SIGHUP .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .termSignal
The number of the signal
.Nm
sends to terminate the server.
See the section
.Sx CONTROLLING THE SERVER .
The default is 15
.Pq Dv SIGTERM .
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .resetForAuth
The original implementation of authorization in the sample server reread the
authorization file at server reset time,
instead of when checking the initial connection.
As
.Nm
generates the authorization information just before connecting to the display,
an old server would not get up-to-date authorization information.
This resource causes
.Nm
to send
.Dv SIGHUP
to the server after setting up the file, causing an additional server reset
to occur, during which time the new authorization information will be read.
The default is
.Cm false ,
which will work for all MIT servers.
.It Ic DisplayManager. Ns Ar DISPLAY Ns Ic .listenTcp
If set to
.Cm true ,
enable the
.Ic listen Ic tcp
option for the given X server.
When this setting is set to
.Cm false ,
.Nm
will only generate authorizations for the local (ie Unix socket)
transport mechanism.
Otherwise full authorization for all possible transport mechanisms
will be generated.
The default is
.Cm false .
.El
.Sh CONFIGURATION FILE
First, the
.Nm
configuration file should be set up.
Make a directory (usually
.Pa XENODMDIR )
to contain all of the relevant files.
.Pp
Here is a reasonable configuration file, which could be named
.Pa xenodm-config :
.Bd -literal -offset Ds
DisplayManager.servers:      XENODMDIR/Xservers
DisplayManager.errorLogFile: XENODMLOGDIR/xenodm.log
DisplayManager*resources:    XENODMDIR/Xresources
DisplayManager*startup:      XENODMDIR/Xstartup
DisplayManager*session:      XENODMDIR/Xsession
DisplayManager._0.authorize: true
DisplayManager*authorize:    false
.Ed
.Pp
Note that this file mostly contains references to other files.
Note also that some of the resources are specified with
.Ql *
separating the components.
These resources can be made unique for each different display, by replacing the
.Ql *
with the display-name, but normally this is not very useful.
See the
.Sx RESOURCES
section for a complete discussion.
.Sh LOCAL SERVER SPECIFICATION
The resource
.Ic DisplayManager.servers
gives a server specification or, if the value starts with a slash
.Pq Ql / ,
the name of a file containing server specifications, one per line.
.Pp
Each specification
indicates a display which should constantly be managed.
If the resource or the file named by the resource is empty,
.Nm
will exit.
.Pp
Each specification consists of at least three parts:
a display name, a display class, a display type, and a command
line to start the server.
A typical entry for local display number 0 would be:
.Pp
.D1 :0 local BINDIR/X :0
.Pp
The only recognized display type is:
.Bl -column local -offset indent
.It Ic local Ta local display: Nm xenodm No will run the server
.El
.Pp
The display name must be something that can be passed in the
.Fl display
option to an X program.
This string is used to generate the display-specific resource names,
so be careful to match the names (e.g., use
.Dq :0 local BINDIR/X :0
instead of
.Dq localhost:0 local BINDIR/X :0
if your other resources are specified as
.Dq DisplayManager._0.session ) .
The display class portion is also used in the display-specific resources,
as the class of the resource.
This is
useful if you have a large collection of similar displays (such as a corral of
X terminals) and would like to set resources for groups of them.
.Pp
When
.Nm
starts a session, it sets up authorization data for the server.
For local servers,
.Nm
passes
.Dq Fl auth Ar filename
on the server's command line to point it at its authorization data.
.Sh RESOURCES FILE
The
.Pa Xresources
file is loaded onto the display as a resource database using
.Xr xrdb 1 .
As the authentication widget reads this database before starting up,
it usually contains parameters for that widget:
.Bd -literal -offset Ds
xlogin*login.translations: #override\e
	<Key>F1: set-session-argument(failsafe) finish-field()\en\e
	<Key>Return: set-session-argument() finish-field()
xlogin*borderWidth: 3
xlogin*greeting: CLIENTHOST
#ifdef COLOR
xlogin*greetColor: CadetBlue
xlogin*failColor: red
#endif
.Ed
.Pp
Please note the translations entry;
it specifies a few new translations for the widget which allow users to escape
from the default session (and avoid troubles that may occur in it).
Note that if #override is not specified,
the default translations are removed and replaced by the new value,
not a very useful result as some of the default translations are quite useful
(such as
.Dq <Key>: insert-char ()
which responds to normal typing).
.Pp
This file may also contain resources for the setup program.
.Sh SETUP PROGRAM
The
.Pa Xsetup
shell script is run after the server is reset, but before the Login window
is offered.
It is run as root, so should be careful about security.
This is the place to change the root background or bring up other
windows that should appear on the screen along with the Login widget.
.Pp
In addition to any specified by
.Ic DisplayManager.exportList ,
the following environment variables are passed:
.Pp
.Bl -tag -offset Ds -width XAUTHORITY -compact
.It Ev DISPLAY
the associated display name
.It Ev PATH
the value of
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .systemPath
.It Ev SHELL
the value of
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .systemShell
.It Ev XAUTHORITY
may be set to an authority file
.El
.Pp
Note that since
.Nm
grabs the keyboard,
any other windows will not be able to receive keyboard input.
They will be able to interact with the mouse, however;
beware of potential security holes here.
If
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .grabServer
is set,
.Pa Xsetup
will not be able to connect to the display at all.
Resources for this program can be put into the file named by
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .resources .
.Sh AUTHENTICATION WIDGET
The authentication widget prompts the user for the username, password, and/or
other required authentication data from the keyboard.
Nearly every imaginable parameter can be controlled with a resource.
Resources for this widget should be put into the file named by
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .resources .
All of these have reasonable default values,
so it is not necessary to specify any of them.
.Pp
The resource file is loaded with
.Xr xrdb 1
so it may use the substitutions defined by that program such as CLIENTHOST
for the client hostname in the login message, or C pre-processor #ifdef
statements to produce different displays depending on color depth or other
variables.
.Pp
.Nm
is compiled with support for the
.Xr Xft 3
library for font rendering.
Font faces are specified using the resources with names ending in
.Dq face
in the fontconfig face format described in the
.Dq Font Names
section of
.Xr fonts.conf 5 .
.Bl -tag -width Ds
.It Ic xlogin.Login.width , xlogin.Login.height , xlogin.Login.x , \
xlogin.Login.y
The geometry of the Login widget is normally computed automatically.
If you
wish to position it elsewhere, specify each of these resources.
.It Ic xlogin.Login.foreground
The color used to display the input typed by the user.
.It Ic xlogin.Login.face
The face used to display the input typed by the user.
The default is
.Dq Serif-18 .
.It Ic xlogin.Login.greeting
A string which identifies this window.
The default is
.Dq X Window System .
.It Ic xlogin.Login.unsecureGreeting
When X authorization is requested in the configuration file for this display
and none is in use, this greeting replaces the standard greeting.
The default is
.Dq This is an unsecure session .
.It Ic xlogin.Login.greetFace
The face used to display the greeting.
The default is
.Dq Serif-24:italic .
.It Ic xlogin.Login.greetColor
The color used to display the greeting.
.It Ic xlogin.Login.namePrompt
The string displayed to prompt for a user name.
.Xr xrdb 1
strips trailing white space from resource values, so to add spaces at the end
of the prompt (usually a nice thing), add spaces escaped with backslashes.
The default is
.Dq "Login:  " .
.It Ic xlogin.Login.passwdPrompt
The string displayed to prompt for a password, when not using an authentication
system such as PAM that provides its own prompts.
The default is
.Dq "Password:  " .
.It Ic xlogin.Login.promptFace
The face used to display prompts.
The default is
.Dq Serif-18:bold .
.It Ic xlogin.Login.promptColor
The color used to display prompts.
.It Ic xlogin.Login.changePasswdMessage
A message which is displayed when the user's password has expired.
The default is
.Dq Password Change Required .
.It Ic xlogin.Login.fail
A message which is displayed when the authentication fails, when not using an
authentication system such as PAM that provides its own prompts.
The default is
.Dq Login incorrect .
.It Ic xlogin.Login.failFace
The face used to display the failure message.
The default is
.Dq Serif-18:bold .
.It Ic xlogin.Login.failColor
The color used to display the failure message.
.It Ic xlogin.Login.failTimeout
The number of seconds that the failure message is displayed.
The default is 10.
.It Ic xlogin.Login.logoFileName
Name of an XPM format pixmap to display in the greeter window,
if built with XPM support.
The default is no pixmap.
.It Ic xlogin.Login.logoPadding
Number of pixels of space between the logo pixmap and other elements of the
greeter window, if the pixmap is displayed.
The default is 5.
.It Ic xlogin.Login.useShape
If set to
.Cm true ,
when built with XPM support, attempt to use
the X Non-Rectangular Window Shape Extension to set the window shape.
The default is
.Cm true .
.It Ic xlogin.Login.hiColor , xlogin.Login.shdColor
Raised appearance bezels may be drawn around
the greeter frame and text input boxes by setting these resources.
.Ic hiColor
is the highlight color, used on the top and left sides of the frame,
and the bottom and right sides of text input areas.
.Ic shdColor
is the shadow color, used on the bottom and right sides of the frame,
and the top and left sides of text input areas.
The default for both is the foreground color, providing a flat appearance.
.It Ic xlogin.Login.frameWidth
.Ic frameWidth
is the width in pixels of the area around the greeter frame drawn in
.Ic hiColor
and
.Ic shdColor .
.It Ic xlogin.Login.innerFramesWidth
.Ic innerFramesWidth
is the width in pixels of the area around text input areas drawn in
.Ic hiColor
and
.Ic shdColor .
.It Ic xlogin.Login.sepWidth
.Ic sepWidth
is the width in pixels of the bezeled line between the greeting and input areas
drawn in
.Ic hiColor
and
.Ic shdColor .
.It Ic xlogin.Login.allowRootLogin
If set to
.Cm false ,
don't allow root (and any other user with uid = 0) to log in directly.
The default is
.Cm true .
This setting is only checked by some of the authentication backends at this
time.
.It Ic xlogin.Login.allowNullPasswd
If set to
.Cm true ,
allow an otherwise failing password match to succeed
if the account does not require a password at all.
The default is
.Cm false ,
so only users that have passwords assigned can log in.
.It Ic xlogin.Login.echoPasswd
If set to
.Cm true ,
a placeholder character
.Pq Ic echoPasswdChar
will be shown for fields normally set to not echo, such as password input.
The default is
.Cm false .
.It Ic xlogin.Login.echoPasswdChar
Character to display if
.Ic echoPasswd
is true.
The default is
.Ql * .
If set to an empty value, the cursor will advance for each character input,
but no text will be drawn.
.It Ic xlogin.Login.translations
This specifies the translations used for the login widget.
Refer to the X Toolkit documentation for a complete discussion on translations.
The default translation table is:
.Bd -literal -offset Ds
Ctrl<Key>H:     delete-previous-character() \en\e
Ctrl<Key>D:     delete-character() \en\e
Ctrl<Key>B:     move-backward-character() \en\e
Ctrl<Key>F:     move-forward-character() \en\e
Ctrl<Key>A:     move-to-begining() \en\e
Ctrl<Key>E:     move-to-end() \en\e
Ctrl<Key>K:     erase-to-end-of-line() \en\e
Ctrl<Key>U:     erase-line() \en\e
Ctrl<Key>X:     erase-line() \en\e
Ctrl<Key>C:     restart-session() \en\e
Ctrl<Key>\e\e:    abort-session() \en\e
<Key>BackSpace: delete-previous-character() \en\e
<Key>Delete:    delete-previous-character() \en\e
<Key>Return:    finish-field() \en\e
<Key>Escape:	erase-line() \en\e
<Key>:          insert-char() \e
.Ed
.Pp
The actions which are supported by the widget are:
.Bl -tag -width Ds
.It Ic delete-previous-character
Erases the character before the cursor.
.It Ic delete-character
Erases the character after the cursor.
.It Ic move-backward-character
Moves the cursor backward.
.It Ic move-forward-character
Moves the cursor forward.
.It Ic move-to-begining
(Apologies about the spelling error.)
Moves the cursor to the beginning of the editable text.
.It Ic move-to-end
Moves the cursor to the end of the editable text.
.It Ic erase-to-end-of-line
Erases all text after the cursor.
.It Ic erase-line
Erases the entire text.
.It Ic finish-field
If the cursor is in the name field, proceeds to the password field;
if the cursor is in the password field, checks the current name/password pair.
If the name/password pair is valid,
.Nm
starts the session.
Otherwise the failure message is displayed and the user is prompted again.
.It Ic abort-session
Terminates and restarts the server.
.It Ic abort-display
Terminates the server, disabling it.
This action is not accessible in the default configuration.
There are various reasons to stop
.Nm
on a system console, such as when shutting the system down,
or to generally access the console.
Sending
.Nm
a
.Dv SIGHUP
will restart the display.
See the section
.Sx CONTROLLING XENODM .
.It Ic restart-session
Resets the X server and starts a new session.
This can be used when
the resources have been changed and you want to test them or when
the screen has been overwritten with system messages.
.It Ic insert-char
Inserts the character typed.
.It Ic set-session-argument
Specifies a single word argument which is passed to the session at startup.
See the section
.Sx SESSION PROGRAM .
.It Ic allow-all-access
Disables access control in the server.
This can be used when the
.Pa .Xauthority
file cannot be created by
.Nm .
Be very careful using this;
it might be better to disconnect the machine from the network
before doing this.
.El
.El
.Pp
On some systems
.Pq Ox
the user's shell must be listed in
.Pa /etc/shells
to allow login through xenodm.
The normal password and account expiration dates are enforced too.
.Sh STARTUP PROGRAM
The
.Pa Xstartup
program is run as root when the user logs in.
It is typically a shell script.
Since it is run as root,
.Pa Xstartup
should be very careful about security.
The default script updates
.Xr wtmp 5
files using the
.Xr sessreg 1
program, or aborts the session if logins are not allowed when the
.Pa /etc/nologin
file is present.
.Pp
In addition to any specified by
.Ic DisplayManager.exportList ,
the following environment variables are passed:
.Pp
.Bl -tag -width WINDOWPATH -compact -offset Ds
.It Ev DISPLAY
the associated display name
.It Ev HOME
the initial working directory of the user
.It Ev LOGNAME
the user name
.It Ev USER
the user name
.It Ev PATH
the value of
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .systemPath
.It Ev SHELL
the value of
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .systemShell
.It Ev XAUTHORITY
may be set to an authority file
.It Ev WINDOWPATH
may be set to the window path leading to the X server
.El
.Pp
No arguments are passed to the script.
.Nm
waits until this script exits before starting the user session.
If the exit value of this script is non-zero,
.Nm
discontinues the session and starts another authentication cycle.
.Sh SESSION PROGRAM
The
.Pa Xsession
program is the command which is run as the user's session.
It is run with the permissions of the authorized user.
.Pp
In addition to any specified by
.Ic DisplayManager.exportList ,
the following environment variables are passed:
.Pp
.Bl -tag -compact -width WINDOWPATH -offset Ds
.It Ev DISPLAY
the associated display name
.It Ev HOME
the initial working directory of the user
.It Ev LOGNAME
the user name
.It Ev USER
the user name
.It Ev PATH
the value of
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .userPath
.It Ev SHELL
the user's default shell (from
.Xr getpwnam 3 )
.It Ev XAUTHORITY
may be set to a non-standard authority file
.It Ev WINDOWPATH
may be set to the window path leading to the X server
.El
.Pp
The default
.Pa Xsession
program looks in
.Pa $HOME
for a script named
.Pa .xsession ,
which contains commands that each user would like to use as a session.
.Pa Xsession
also implements a system default session
if no user-specified session exists.
.Pp
An argument may be passed to this program from the authentication widget
using the
.Ic set-session-argument
action.
This can be used to select different styles of session.
By default it recognizes the special failsafe mode,
specified in the translations in the
.Pa Xresources
file, to provide an escape from the ordinary session.
It also requires that the
.Pa .xsession
file be executable so we don't have to guess what shell it wants to use.
.Pp
Errors from the user's
.Pa .xsession
script are logged in
.Pa ${HOME}/.xsession-errors .
.Pp
The user's
.Pa .xsession
file might look something like this example.
Don't forget that the file must have execute permission.
.Bd -literal -offset Ds
#! /bin/sh
xrdb -merge "$HOME/.Xresources"
emacs -geometry +0+50 &
xbiff -geometry -430+5 &
xterm -geometry -0+50 -ls &
exec fvwm
.Ed
.Sh RESET PROGRAM
Symmetrical with
.Pa Xstartup ,
the
.Pa Xreset
script is run after the user session has terminated.
Run as root, it contains commands that undo the effects of commands in
.Pa Xstartup ,
updating entries in
.Xr wtmp 5
files.
The environment variables that were passed to
.Pa Xstartup
are also passed to
.Pa Xreset .
.Sh CONTROLLING THE SERVER
.Nm
controls local servers using POSIX signals.
.Dv SIGHUP
is expected to reset the server,
closing all client connections and performing other cleanup duties.
.Dv SIGTERM
is expected to terminate the server.
If these signals do not perform the expected actions, the resources
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .resetSignal
and
.Ic DisplayManager. Ns Ar DISPLAY Ns Ic .termSignal
can specify alternate signals.
.Sh CONTROLLING XENODM
.Nm
responds to two signals:
.Dv SIGHUP
and
.Dv SIGTERM .
When sent a
.Dv SIGHUP ,
.Nm
rereads the configuration file, the access control file, and the servers file.
For the servers file, it notices if entries have been added or removed.
If a new entry has been added,
.Nm
starts a session on the associated display.
Entries which have been removed are disabled immediately,
meaning that any session in progress will be terminated without notice
and no new session will be started.
.Pp
When sent a
.Dv SIGTERM ,
.Nm
terminates all sessions in progress and exits.
This can be used when shutting down the system.
.Pp
.Nm
attempts to mark its various sub-processes for
.Xr ps 1
by editing the command line argument list in place.
Because
.Nm
can't allocate additional space for this task, it is useful to start
.Nm
with a reasonably long command line
(using the full path name should be enough).
Each process which is servicing a display is marked
.Fl Ns Ar display .
.Sh ADDITIONAL LOCAL DISPLAYS
To add an additional local display, add a line for it to the
.Pa Xservers
file.
(See the section
.Sx LOCAL SERVER SPECIFICATION . )
.Pp
Examine the display-specific resources in
.Pa xenodm-config
(e.g.,
.Ic DisplayManager._0.authorize )
and consider which of them should be copied for the new display.
The default
.Pa xenodm-config
has all the appropriate lines for displays :0 and :1.
.Sh OTHER POSSIBILITIES
You can use
.Nm
to run a single session at a time, using the 4.3
.Xr init 8
options or other suitable daemon by specifying the server on the command line:
.Pp
.D1 xenodm -server \(dq:0 local BINDIR/X :0\(dq
.Sh LIMITATIONS
One thing that
.Nm
isn't very good at doing is coexisting with other window systems.
To use multiple window systems on the same hardware, you'll probably be more
interested in
.Xr xinit 1 .
.Sh FILES
.Bl -tag -width Ds -compact
.It Pa XENODMDIR/xenodm-config
default configuration file
.It Pa XENODMLOGDIR/xenodm.log
system log file
.It Pa $HOME/.Xauthority
user authorization file where
.Nm
stores keys for clients to read
.It Pa $HOME/.xsession
user session script
.It Pa $HOME/.xsession-errors
log file for the user session
.It Pa BINDIR/xrdb
default resource database loader
.It Pa BINDIR/X
default X server
.It Pa BINDIR/xterm
default session program and failsafe client
.It Pa XENODMXAUTHDIR/A Ns Ar display Ns - Ns Ar suffix
default place for authorization files
.El
.Sh SEE ALSO
.Xr sessreg 1 ,
.Xr xauth 1 ,
.Xr xinit 1 ,
.Xr xrdb 1 ,
.Xr Xserver 1 ,
.Xr fonts.conf 5 ,
.Xr X 7 ,
.Xr Xsecurity 7
.Rs
.%T X Display Manager Control Protocol
.Re
.Rs
.%A R. Hinden
.%A S. Deering
.%D February 2006
.%R RFC 4291
.%T IP Version 6 Addressing Architecture
.Re
.Sh AUTHOR
Keith Packard, MIT X Consortium
