/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public class ConditionalNode
extends ValueNode {
    ValueNode testCondition;
    ValueNodeList thenElseList;
    boolean thisIsNullIfNode;

    public void init(Object object, Object object2, Object object3) {
        this.testCondition = (ValueNode)object;
        this.thenElseList = (ValueNodeList)object2;
        this.thisIsNullIfNode = (Boolean)object3;
    }

    public void printSubNodes(int n) {
    }

    private boolean isCastNode(ValueNode valueNode) {
        return valueNode.getNodeType() == 60;
    }

    private boolean isCastToChar(ValueNode valueNode) throws StandardException {
        return valueNode.getTypeServices().getTypeName().equals("CHAR");
    }

    private boolean isNullNode(ValueNode valueNode) {
        return this.isCastNode(valueNode) && ((CastNode)valueNode).castOperand instanceof UntypedNullConstantNode;
    }

    private boolean isConditionalNode(ValueNode valueNode) {
        return valueNode.getNodeType() == 54;
    }

    private boolean shouldCast(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) throws StandardException {
        return dataTypeDescriptor != null && (dataTypeDescriptor2 == null || !dataTypeDescriptor2.getTypeId().equals(dataTypeDescriptor.getTypeId()));
    }

    private DataTypeDescriptor findType(ValueNodeList valueNodeList, FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        ValueNode valueNode = ((ValueNode)valueNodeList.elementAt(0)).bindExpression(fromList, subqueryList, vector);
        ValueNode valueNode2 = ((ValueNode)valueNodeList.elementAt(1)).bindExpression(fromList, subqueryList, vector);
        DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
        DataTypeDescriptor dataTypeDescriptor2 = valueNode2.getTypeServices();
        DataTypeDescriptor dataTypeDescriptor3 = null;
        if (dataTypeDescriptor != null && !this.isCastNode(valueNode) && !this.isConditionalNode(valueNode)) {
            return dataTypeDescriptor;
        }
        if (this.isCastNode(valueNode) && !this.isCastToChar(valueNode)) {
            return valueNode.getTypeServices();
        }
        if (dataTypeDescriptor2 != null && !this.isCastNode(valueNode2) && !this.isConditionalNode(valueNode2)) {
            return dataTypeDescriptor2;
        }
        if (this.isCastNode(valueNode2) && !this.isCastToChar(valueNode2)) {
            return valueNode2.getTypeServices();
        }
        if (this.isConditionalNode(valueNode)) {
            dataTypeDescriptor3 = this.findType(((ConditionalNode)valueNode).thenElseList, fromList, subqueryList, vector);
        }
        if (dataTypeDescriptor3 != null) {
            return dataTypeDescriptor3;
        }
        if (this.isConditionalNode(valueNode2)) {
            dataTypeDescriptor3 = this.findType(((ConditionalNode)valueNode2).thenElseList, fromList, subqueryList, vector);
        }
        if (dataTypeDescriptor3 != null) {
            return dataTypeDescriptor3;
        }
        return null;
    }

    private void recastNullNodes(ValueNodeList valueNodeList, DataTypeDescriptor dataTypeDescriptor, FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (dataTypeDescriptor == null) {
            return;
        }
        dataTypeDescriptor = dataTypeDescriptor.getNullabilityType(true);
        ValueNode valueNode = (ValueNode)valueNodeList.elementAt(0);
        ValueNode valueNode2 = (ValueNode)valueNodeList.elementAt(1);
        if (this.isNullNode(valueNode) && this.shouldCast(dataTypeDescriptor, valueNode.getTypeServices())) {
            valueNodeList.setElementAt(this.recastNullNode(valueNode, dataTypeDescriptor), 0);
            ((ValueNode)valueNodeList.elementAt(0)).bindExpression(fromList, subqueryList, vector);
        } else if (this.isConditionalNode(valueNode)) {
            this.recastNullNodes(((ConditionalNode)valueNode).thenElseList, dataTypeDescriptor, fromList, subqueryList, vector);
        }
        if (this.isNullNode(valueNode2) && this.shouldCast(dataTypeDescriptor, valueNode2.getTypeServices())) {
            valueNodeList.setElementAt(this.recastNullNode(valueNode2, dataTypeDescriptor), 1);
            ((ValueNode)valueNodeList.elementAt(1)).bindExpression(fromList, subqueryList, vector);
        } else if (this.isConditionalNode(valueNode2)) {
            this.recastNullNodes(((ConditionalNode)valueNode2).thenElseList, dataTypeDescriptor, fromList, subqueryList, vector);
        }
    }

    private QueryTreeNode recastNullNode(ValueNode valueNode, DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        return (QueryTreeNode)this.getNodeFactory().getNode(60, ((CastNode)valueNode).castOperand, dataTypeDescriptor, this.getContextManager());
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        Object object;
        QueryTreeNode queryTreeNode;
        ValueNode valueNode;
        CompilerContext compilerContext = this.getCompilerContext();
        int n = this.orReliability(16384);
        this.testCondition = this.testCondition.bindExpression(fromList, subqueryList, vector);
        if (this.thisIsNullIfNode) {
            valueNode = (BinaryComparisonOperatorNode)this.testCondition;
            queryTreeNode = (QueryTreeNode)this.getNodeFactory().getNode(60, this.thenElseList.elementAt(0), ((BinaryOperatorNode)valueNode).getLeftOperand().getTypeServices().getNullabilityType(true), this.getContextManager());
            this.thenElseList.setElementAt(queryTreeNode, 0);
            this.thenElseList.bindExpression(fromList, subqueryList, vector);
        } else {
            this.recastNullNodes(this.thenElseList, this.findType(this.thenElseList, fromList, subqueryList, vector), fromList, subqueryList, vector);
        }
        valueNode = (ValueNode)this.thenElseList.elementAt(0);
        queryTreeNode = (ValueNode)this.thenElseList.elementAt(1);
        if (this.testCondition.requiresTypeFromContext()) {
            this.testCondition.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        } else if (!this.testCondition.getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X88");
        }
        if (this.thenElseList.containsAllParameterNodes()) {
            throw StandardException.newException("42X87", "conditional");
        }
        if (this.thenElseList.containsParameterNode()) {
            object = valueNode.requiresTypeFromContext() ? ((ValueNode)queryTreeNode).getTypeServices() : valueNode.getTypeServices();
            this.thenElseList.setParameterDescriptor((DataTypeDescriptor)object);
        }
        object = this.getClassFactory().getClassInspector();
        if (!(valueNode.getTypeServices().comparable(((ValueNode)queryTreeNode).getTypeServices(), false, this.getClassFactory()) || ((ClassInspector)object).assignableTo(valueNode.getTypeId().getCorrespondingJavaTypeName(), ((ValueNode)queryTreeNode).getTypeId().getCorrespondingJavaTypeName()) || ((ClassInspector)object).assignableTo(((ValueNode)queryTreeNode).getTypeId().getCorrespondingJavaTypeName(), valueNode.getTypeId().getCorrespondingJavaTypeName()))) {
            throw StandardException.newException("42X89", (Object)valueNode.getTypeId().getSQLTypeName(), (Object)((ValueNode)queryTreeNode).getTypeId().getSQLTypeName());
        }
        this.setType(this.thenElseList.getDominantTypeServices());
        TypeId typeId = this.getTypeId();
        TypeId typeId2 = ((ValueNode)this.thenElseList.elementAt(0)).getTypeId();
        TypeId typeId3 = ((ValueNode)this.thenElseList.elementAt(1)).getTypeId();
        if (typeId2.typePrecedence() != typeId.typePrecedence()) {
            ValueNode valueNode2 = (ValueNode)this.getNodeFactory().getNode(60, this.thenElseList.elementAt(0), this.getTypeServices(), this.getContextManager());
            valueNode2 = valueNode2.bindExpression(fromList, subqueryList, vector);
            this.thenElseList.setElementAt(valueNode2, 0);
        } else if (typeId3.typePrecedence() != typeId.typePrecedence()) {
            ValueNode valueNode3 = (ValueNode)this.getNodeFactory().getNode(60, this.thenElseList.elementAt(1), this.getTypeServices(), this.getContextManager());
            valueNode3 = valueNode3.bindExpression(fromList, subqueryList, vector);
            this.thenElseList.setElementAt(valueNode3, 1);
        }
        compilerContext.setReliability(n);
        return this;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.testCondition = this.testCondition.preprocess(n, fromList, subqueryList, predicateList);
        this.thenElseList.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = this.testCondition.categorize(jBitSet, bl);
        bl2 = this.thenElseList.categorize(jBitSet, bl) && bl2;
        return bl2;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.testCondition = this.testCondition.remapColumnReferencesToExpressions();
        this.thenElseList = this.thenElseList.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.testCondition.isConstantExpression() && this.thenElseList.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.testCondition.constantExpression(predicateList) && this.thenElseList.constantExpression(predicateList);
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (!bl) {
            return this;
        }
        ValueNode valueNode = (ValueNode)this.thenElseList.elementAt(0);
        ValueNode valueNode2 = (ValueNode)this.thenElseList.elementAt(1);
        this.thenElseList.setElementAt(valueNode2, 0);
        this.thenElseList.setElementAt(valueNode, 1);
        return this;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.testCondition.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast("org.apache.derby.iapi.types.BooleanDataValue");
        methodBuilder.push(true);
        methodBuilder.callMethod((short)185, null, "equals", "boolean", 1);
        methodBuilder.conditionalIf();
        ((ValueNode)this.thenElseList.elementAt(0)).generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.startElseCode();
        ((ValueNode)this.thenElseList.elementAt(1)).generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.completeConditional();
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.testCondition != null) {
            this.testCondition = (ValueNode)this.testCondition.accept(visitor);
        }
        if (this.thenElseList != null) {
            this.thenElseList = (ValueNodeList)this.thenElseList.accept(visitor);
        }
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeType(valueNode)) {
            ConditionalNode conditionalNode = (ConditionalNode)valueNode;
            return this.testCondition.isEquivalent(conditionalNode.testCondition) && this.thenElseList.isEquivalent(conditionalNode.thenElseList);
        }
        return false;
    }
}

