/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import liquibase.repackaged.com.opencsv.bean.BeanField;
import liquibase.repackaged.com.opencsv.bean.ComplexFieldMapEntry;
import liquibase.repackaged.com.opencsv.bean.FieldMap;
import liquibase.repackaged.org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractFieldMap<I, K extends Comparable<K>, C extends ComplexFieldMapEntry<I, K, T>, T>
implements FieldMap<I, K, C, T> {
    protected Locale errorLocale;
    protected final SortedMap<K, BeanField<T, K>> simpleMap = new TreeMap<K, BeanField<T, K>>();
    protected final List<C> complexMapList = new ArrayList<C>();

    protected AbstractFieldMap(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public BeanField<T, K> get(K key) {
        BeanField f2 = (BeanField)this.simpleMap.get(key);
        if (f2 == null) {
            f2 = this.complexMapList.stream().filter(r2 -> r2.contains(key)).map(ComplexFieldMapEntry::getBeanField).findAny().orElse(null);
        }
        return f2;
    }

    @Override
    public BeanField<T, K> put(K key, BeanField<T, K> value) {
        return this.simpleMap.put(key, value);
    }

    @Override
    public Collection<BeanField<T, K>> values() {
        ArrayList l2 = new ArrayList(this.simpleMap.size() + this.complexMapList.size());
        l2.addAll(this.simpleMap.values());
        this.complexMapList.forEach(r2 -> l2.add(r2.getBeanField()));
        return l2;
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        this.complexMapList.forEach(e2 -> e2.setErrorLocale(this.errorLocale));
    }
}

