/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.protobuf.starlink.StarLinkMessage;

public class StarLinkProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_EVENT_REPORT = 6;
    private static final Pattern PATTERN = new PatternBuilder().expression(".").text("SLU").number("(x{6}|d{15}),").number("(d+),").number("(d+),").expression("(.+)").text("*").number("xx").compile();
    private String format;
    private String dateFormat;

    public StarLinkProtocolDecoder(Protocol protocol) {
        super(protocol);
        this.setFormat(Context.getConfig().getString(this.getProtocolName() + ".format", "#EDT#,#EID#,#PDT#,#LAT#,#LONG#,#SPD#,#HEAD#,#ODO#,#IN1#,#IN2#,#IN3#,#IN4#,#OUT1#,#OUT2#,#OUT3#,#OUT4#,#LAC#,#CID#,#VIN#,#VBAT#,#DEST#,#IGN#,#ENG#"));
        this.setDateFormat(Context.getConfig().getString(this.getProtocolName() + ".dateFormat", "yyMMddHHmmss"));
    }

    public String[] getFormat(long deviceId) {
        return Context.getIdentityManager().lookupAttributeString(deviceId, this.getProtocolName() + ".format", this.format, false, false).split(",");
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public DateFormat getDateFormat(long deviceId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(Context.getIdentityManager().lookupAttributeString(deviceId, this.getProtocolName() + ".dateFormat", this.dateFormat, false, false));
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    private double parseCoordinate(String value) {
        int minutesIndex = value.indexOf(46) - 2;
        double result = Double.parseDouble(value.substring(1, minutesIndex));
        return value.charAt(0) == '+' ? result : -(result += Double.parseDouble(value.substring(minutesIndex)) / 60.0);
    }

    private String decodeAlarm(int event) {
        switch (event) {
            case 6: {
                return "overspeed";
            }
            case 7: {
                return "geofenceEnter";
            }
            case 8: {
                return "geofenceExit";
            }
            case 9: {
                return "powerCut";
            }
            case 11: {
                return "lowBattery";
            }
            case 26: {
                return "tow";
            }
            case 36: {
                return "sos";
            }
            case 42: {
                return "jamming";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        int type = parser.nextInt(0);
        if (type != 6) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        position.set("index", parser.nextInt(0));
        String[] data = parser.next().split(",");
        Integer lac = null;
        Integer cid = null;
        int event = 0;
        String[] dataTags = this.getFormat(deviceSession.getDeviceId());
        DateFormat dateFormat = this.getDateFormat(deviceSession.getDeviceId());
        block96: for (int i = 0; i < Math.min(data.length, dataTags.length); ++i) {
            if (data[i].isEmpty()) continue;
            switch (dataTags[i]) {
                case "#ALT#": 
                case "#ALTD#": {
                    position.setAltitude(Double.parseDouble(data[i]));
                    continue block96;
                }
                case "#DAL#": 
                case "#DID#": {
                    position.set("driverUniqueId", data[i]);
                    continue block96;
                }
                case "#EDT#": {
                    position.setDeviceTime(dateFormat.parse(data[i]));
                    continue block96;
                }
                case "#EDV1#": 
                case "#EDV2#": {
                    position.set("external" + dataTags[i].charAt(4), data[i]);
                    continue block96;
                }
                case "#EID#": {
                    event = Integer.parseInt(data[i]);
                    position.set("alarm", this.decodeAlarm(event));
                    position.set("event", event);
                    if (event == 24) {
                        position.set("ignition", true);
                        continue block96;
                    }
                    if (event != 25) continue block96;
                    position.set("ignition", false);
                    continue block96;
                }
                case "#EDSC#": {
                    position.set("reason", data[i]);
                    continue block96;
                }
                case "#IARM#": {
                    position.set("armed", Integer.parseInt(data[i]) > 0);
                    continue block96;
                }
                case "#PDT#": {
                    position.setFixTime(dateFormat.parse(data[i]));
                    continue block96;
                }
                case "#LAT#": {
                    position.setLatitude(this.parseCoordinate(data[i]));
                    continue block96;
                }
                case "#LONG#": {
                    position.setLongitude(this.parseCoordinate(data[i]));
                    continue block96;
                }
                case "#SPD#": {
                    position.setSpeed(Double.parseDouble(data[i]));
                    continue block96;
                }
                case "#SPDK#": {
                    position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(data[i])));
                    continue block96;
                }
                case "#HEAD#": {
                    position.setCourse(Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#ODO#": 
                case "#ODOD#": {
                    position.set("odometer", (long)(Double.parseDouble(data[i]) * 1000.0));
                    continue block96;
                }
                case "#BATC#": {
                    position.set("batteryLevel", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#BATH#": {
                    position.set("batteryHealth", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#TVI#": {
                    position.set("deviceTemp", Double.parseDouble(data[i]));
                    continue block96;
                }
                case "#CFL#": {
                    position.set("fuel", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#CFL2#": {
                    position.set("fuel2", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#IN1#": 
                case "#IN2#": 
                case "#IN3#": 
                case "#IN4#": {
                    position.set("in" + dataTags[i].charAt(3), Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#OUT1#": 
                case "#OUT2#": 
                case "#OUT3#": 
                case "#OUT4#": {
                    position.set("out" + dataTags[i].charAt(4), Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#OUTA#": 
                case "#OUTB#": 
                case "#OUTC#": 
                case "#OUTD#": {
                    position.set("out" + (dataTags[i].charAt(4) - 65 + 1), Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#PDOP#": {
                    position.set("pdop", Double.parseDouble(data[i]));
                    continue block96;
                }
                case "#LAC#": {
                    if (data[i].isEmpty()) continue block96;
                    lac = Integer.parseInt(data[i]);
                    continue block96;
                }
                case "#CID#": {
                    if (data[i].isEmpty()) continue block96;
                    cid = Integer.parseInt(data[i]);
                    continue block96;
                }
                case "#CSS#": {
                    position.set("rssi", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#VIN#": {
                    position.set("power", Double.parseDouble(data[i]));
                    continue block96;
                }
                case "#VBAT#": {
                    position.set("battery", Double.parseDouble(data[i]));
                    continue block96;
                }
                case "#DEST#": {
                    position.set("destination", data[i]);
                    continue block96;
                }
                case "#IGN#": 
                case "#IGNL#": 
                case "#ENG#": {
                    position.set("ignition", Integer.parseInt(data[i]) > 0);
                    continue block96;
                }
                case "#DUR#": 
                case "#TDUR#": {
                    position.set("hours", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#SAT#": 
                case "#SATN#": {
                    position.set("satVisible", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#SATU#": {
                    position.set("sat", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#STRT#": {
                    position.set("starter", Double.parseDouble(data[i]));
                    continue block96;
                }
                case "#TS1#": {
                    position.set("sensor1State", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#TS2#": {
                    position.set("sensor2State", Integer.parseInt(data[i]));
                    continue block96;
                }
                case "#TD1#": 
                case "#TD2#": {
                    StarLinkMessage.mEventReport_TDx message = StarLinkMessage.mEventReport_TDx.parseFrom(DataConverter.parseBase64(data[i]));
                    position.set("sensor" + message.getSensorNumber() + "Id", message.getSensorID());
                    position.set("sensor" + message.getSensorNumber() + "Temp", (double)message.getTemperature() * 0.1);
                    position.set("sensor" + message.getSensorNumber() + "Humidity", (double)message.getTemperature() * 0.1);
                    position.set("sensor" + message.getSensorNumber() + "Voltage", (double)message.getVoltage() * 0.001);
                    continue block96;
                }
            }
        }
        if (position.getFixTime() == null) {
            this.getLastLocation(position, null);
        }
        if (lac != null && cid != null) {
            position.setNetwork(new Network(CellTower.fromLacCid(lac, cid.intValue())));
        }
        if (event == 20) {
            String rfid = data[data.length - 1];
            if (rfid.matches("0+")) {
                rfid = data[data.length - 2];
            }
            position.set("driverUniqueId", rfid);
        }
        return position;
    }
}

