"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var axis_type_utils_1 = require("../../utils/axis_type_utils");
function getSpecsById(specs, id) {
    return specs.find(function (spec) { return spec.id === id; });
}
exports.getSpecsById = getSpecsById;
function getAxesSpecForSpecId(axesSpecs, groupId) {
    var e_1, _a;
    var xAxis;
    var yAxis;
    try {
        for (var axesSpecs_1 = __values(axesSpecs), axesSpecs_1_1 = axesSpecs_1.next(); !axesSpecs_1_1.done; axesSpecs_1_1 = axesSpecs_1.next()) {
            var axisSpec = axesSpecs_1_1.value;
            if (axisSpec.groupId !== groupId) {
                continue;
            }
            if (axis_type_utils_1.isVerticalAxis(axisSpec.position)) {
                yAxis = axisSpec;
            }
            else {
                xAxis = axisSpec;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (axesSpecs_1_1 && !axesSpecs_1_1.done && (_a = axesSpecs_1.return)) _a.call(axesSpecs_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return {
        xAxis: xAxis,
        yAxis: yAxis,
    };
}
exports.getAxesSpecForSpecId = getAxesSpecForSpecId;
//# sourceMappingURL=spec.js.map