/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ir.LoopNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.Label;

public class WhileLoopNode
extends LoopNode {
    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitWhileLoop(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        if (this.getConditionNode() != null) {
            this.getConditionNode().visit(irTreeVisitor, scope);
        }
        if (this.getBlockNode() != null) {
            this.getBlockNode().visit(irTreeVisitor, scope);
        }
    }

    public WhileLoopNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        WriteScope.Variable loop;
        methodWriter.writeStatementOffset(this.getLocation());
        writeScope = writeScope.newScope();
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        if (!this.isContinuous()) {
            this.getConditionNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), this.getLocation());
        }
        if (this.getBlockNode() != null) {
            this.getBlockNode().continueLabel = begin;
            this.getBlockNode().breakLabel = end;
            this.getBlockNode().write(classWriter, methodWriter, writeScope);
        }
        if (this.getBlockNode() == null || !this.getBlockNode().doAllEscape()) {
            methodWriter.goTo(begin);
        }
        methodWriter.mark(end);
    }
}

