/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import org.rrd4j.core.InvalidRrdException;
import org.rrd4j.core.jrrd.Constants;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class Header
implements Constants {
    private static final double FLOAT_COOKIE = 8.642135E130;
    private static final long offset = 0L;
    private final long size;
    final String version;
    private final int iVersion;
    final int dsCount;
    final int rraCount;
    final int pdpStep;

    Header(RRDFile file) throws IOException {
        if (!file.readString(4).equals("RRD")) {
            throw new InvalidRrdException("Invalid COOKIE");
        }
        this.version = file.readString(5);
        try {
            this.iVersion = Integer.parseInt(this.version);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unsupported RRD version (" + this.version + ")");
        }
        if (this.iVersion > 3) {
            throw new RuntimeException("Unsupported RRD version (" + this.version + ")");
        }
        file.align();
        double cookie = file.readDouble();
        if (cookie != 8.642135E130) {
            throw new RuntimeException("This RRD was created on another architecture");
        }
        this.dsCount = file.readLong();
        this.rraCount = file.readLong();
        this.pdpStep = file.readLong();
        UnivalArray par = file.getUnivalArray(10);
        this.size = file.getFilePointer() - 0L;
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionAsInt() {
        return this.iVersion;
    }

    public int getDSCount() {
        return this.dsCount;
    }

    public int getRRACount() {
        return this.rraCount;
    }

    public int getPDPStep() {
        return this.pdpStep;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[Header: OFFSET=0x00, SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", version=");
        sb.append(this.version);
        sb.append(", dsCount=");
        sb.append(this.dsCount);
        sb.append(", rraCount=");
        sb.append(this.rraCount);
        sb.append(", pdpStep=");
        sb.append(this.pdpStep);
        sb.append("]");
        return sb.toString();
    }
}

