/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.opensearch.action.admin.cluster.node.info.NodesInfoAction;
import org.opensearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.opensearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.opensearch.action.admin.cluster.node.info.PluginsAndModules;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.plugins.PluginInfo;

@OpenForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;", "Lorg/opensearch/cluster/ClusterStateListener;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;)V", "<set-?>", "", "flag", "getFlag", "()Z", "hasLegacyPlugin", "getHasLegacyPlugin", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "clusterChanged", "", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "sweepISMPluginVersion", "opensearch-index-management"})
public class SkipExecution
implements ClusterStateListener {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    private final Logger logger;
    private volatile boolean flag;
    private volatile boolean hasLegacyPlugin;

    public SkipExecution(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
        this.logger = LogManager.getLogger(this.getClass());
        this.clusterService.addListener((ClusterStateListener)this);
    }

    public final boolean getFlag() {
        return this.flag;
    }

    public final boolean getHasLegacyPlugin() {
        return this.hasLegacyPlugin;
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.nodesChanged() || event.isNewCluster()) {
            this.sweepISMPluginVersion();
        }
    }

    public void sweepISMPluginVersion() {
        NodesInfoRequest request = new NodesInfoRequest(new String[0]).clear().addMetric("plugins");
        this.client.execute((ActionType)NodesInfoAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<NodesInfoResponse>(this){
            final /* synthetic */ SkipExecution this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull NodesInfoResponse response2) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                Set versionSet = new LinkedHashSet<E>();
                Set legacyVersionSet = new LinkedHashSet<E>();
                List list = response2.getNodes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"response.nodes");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NodeInfo nodeInfo = (NodeInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((PluginsAndModules)it.getInfo(PluginsAndModules.class)).getPluginInfos());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    List it = (List)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Iterable $this$forEach$iv2 = it;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String string;
                        PluginInfo nodePlugin = (PluginInfo)element$iv2;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)nodePlugin.getName(), (Object)"opensearch-index-management") || Intrinsics.areEqual((Object)nodePlugin.getName(), (Object)"opensearch_index_management")) {
                            string = nodePlugin.getVersion();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodePlugin.version");
                            versionSet.add(string);
                        }
                        if (!Intrinsics.areEqual((Object)nodePlugin.getName(), (Object)"opendistro-index-management") && !Intrinsics.areEqual((Object)nodePlugin.getName(), (Object)"opendistro_index_management")) continue;
                        string = nodePlugin.getVersion();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodePlugin.version");
                        legacyVersionSet.add(string);
                    }
                }
                if (versionSet.size() + legacyVersionSet.size() > 1) {
                    SkipExecution.access$setFlag$p(this.this$0, true);
                    SkipExecution.access$getLogger$p(this.this$0).info("There are multiple versions of Index Management plugins in the cluster: [" + versionSet + ", " + legacyVersionSet + "]");
                } else {
                    SkipExecution.access$setFlag$p(this.this$0, false);
                }
                if (!((Collection)versionSet).isEmpty() && !((Collection)legacyVersionSet).isEmpty()) {
                    SkipExecution.access$setHasLegacyPlugin$p(this.this$0, true);
                    SkipExecution.access$getLogger$p(this.this$0).info("Found legacy plugin versions [" + legacyVersionSet + "] and opensearch plugins versions [" + versionSet + "] in the cluster");
                } else {
                    SkipExecution.access$setHasLegacyPlugin$p(this.this$0, false);
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SkipExecution.access$getLogger$p(this.this$0).error("Failed sweeping nodes for ISM plugin versions: " + e);
                SkipExecution.access$setFlag$p(this.this$0, false);
            }
        });
    }

    public static final /* synthetic */ void access$setFlag$p(SkipExecution $this, boolean bl) {
        $this.flag = bl;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SkipExecution $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setHasLegacyPlugin$p(SkipExecution $this, boolean bl) {
        $this.hasLegacyPlugin = bl;
    }
}

