/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.config;

import org.opensearch.sql.analysis.Analyzer;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.expression.config.ExpressionConfig;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.ppl.PPLService;
import org.opensearch.sql.ppl.antlr.PPLSyntaxParser;
import org.opensearch.sql.storage.StorageEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ExpressionConfig.class})
public class PPLServiceConfig {
    @Autowired
    private StorageEngine storageEngine;
    @Autowired
    private ExecutionEngine executionEngine;
    @Autowired
    private BuiltinFunctionRepository functionRepository;

    @Bean
    public Analyzer analyzer() {
        return new Analyzer(new ExpressionAnalyzer(this.functionRepository), this.storageEngine);
    }

    @Bean
    public PPLService pplService() {
        return new PPLService(new PPLSyntaxParser(), this.analyzer(), this.storageEngine, this.executionEngine, this.functionRepository);
    }
}

