/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public class HotNodeRca
extends Rca<ResourceFlowUnit<HotNodeSummary>> {
    private static final Logger LOG = LogManager.getLogger(HotNodeRca.class);
    private Rca<ResourceFlowUnit<HotResourceSummary>>[] hotResourceRcas;
    private boolean hasUnhealthyFlowUnit;
    private final int rcaPeriod;
    private int counter;

    public <R extends Rca<ResourceFlowUnit<HotResourceSummary>>> HotNodeRca(int rcaPeriod, R ... hotResourceRcas) {
        super(5L);
        this.hotResourceRcas = (Rca[])hotResourceRcas.clone();
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.hasUnhealthyFlowUnit = false;
    }

    @Override
    public ResourceFlowUnit<HotNodeSummary> operate() {
        ++this.counter;
        ArrayList<HotResourceSummary> hotResourceSummaryList = new ArrayList<HotResourceSummary>();
        for (int i = 0; i < this.hotResourceRcas.length; ++i) {
            List hotResourceFlowUnits = this.hotResourceRcas[i].getFlowUnits();
            for (Object hotResourceFlowUnit : hotResourceFlowUnits) {
                if (((GenericFlowUnit)hotResourceFlowUnit).isEmpty()) continue;
                if (((ResourceFlowUnit)hotResourceFlowUnit).hasResourceSummary()) {
                    hotResourceSummaryList.add((HotResourceSummary)((ResourceFlowUnit)hotResourceFlowUnit).getSummary());
                }
                if (!((ResourceFlowUnit)hotResourceFlowUnit).getResourceContext().isUnhealthy()) continue;
                this.hasUnhealthyFlowUnit = true;
            }
        }
        if (this.counter == this.rcaPeriod) {
            InstanceDetails instanceDetails = this.getInstanceDetails();
            HotNodeSummary summary = new HotNodeSummary(instanceDetails.getInstanceId(), instanceDetails.getInstanceIp());
            for (HotResourceSummary hotResourceSummary : hotResourceSummaryList) {
                summary.appendNestedSummary(hotResourceSummary);
            }
            ResourceContext context = this.hasUnhealthyFlowUnit ? new ResourceContext(Resources.State.UNHEALTHY) : new ResourceContext(Resources.State.HEALTHY);
            this.counter = 0;
            this.hasUnhealthyFlowUnit = false;
            boolean isDataNode = !instanceDetails.getIsMaster();
            return new ResourceFlowUnit<HotNodeSummary>(System.currentTimeMillis(), context, summary, isDataNode);
        }
        return new ResourceFlowUnit<HotNodeSummary>(System.currentTimeMillis());
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList flowUnitList = new ArrayList();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(ResourceFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }
}

