/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.cluster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class BaseClusterRca
extends Rca<ResourceFlowUnit<HotClusterSummary>> {
    private static final Logger LOG = LogManager.getLogger(BaseClusterRca.class);
    private static final int DEFAULT_NUM_OF_FLOWUNITS = 1;
    private static final long TIMESTAMP_EXPIRATION_IN_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    private final List<Rca<ResourceFlowUnit<HotNodeSummary>>> nodeRcas;
    protected final Table<NodeKey, String, LinkedList<ResourceFlowUnit<HotNodeSummary>>> nodeTable;
    private final int rcaPeriod;
    private int counter;
    protected Clock clock;
    protected int numOfFlowUnitsInMap;
    protected boolean collectFromMasterNode;
    protected long expirationTimeWindow;

    @SafeVarargs
    public <R extends Rca<ResourceFlowUnit<HotNodeSummary>>> BaseClusterRca(int rcaPeriod, R ... nodeRca) {
        super(5L);
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.clock = Clock.systemUTC();
        this.numOfFlowUnitsInMap = 1;
        this.nodeTable = HashBasedTable.create();
        this.collectFromMasterNode = false;
        this.expirationTimeWindow = TIMESTAMP_EXPIRATION_IN_MILLIS;
        this.nodeRcas = Arrays.asList(nodeRca);
    }

    @VisibleForTesting
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @VisibleForTesting
    public void setCollectFromMasterNode(boolean collectFromMasterNode) {
        this.collectFromMasterNode = collectFromMasterNode;
    }

    private void addUpstreamFlowUnits(Rca<ResourceFlowUnit<HotNodeSummary>> nodeRca) {
        List flowUnits = nodeRca.getFlowUnits();
        for (ResourceFlowUnit flowUnit : flowUnits) {
            if (flowUnit.isEmpty() || !flowUnit.hasResourceSummary()) continue;
            HotNodeSummary nodeSummary = (HotNodeSummary)flowUnit.getSummary();
            NodeKey nodeKey = new NodeKey(nodeSummary.getNodeID(), nodeSummary.getHostAddress());
            if (this.nodeTable.get((Object)nodeKey, (Object)nodeRca.name()) == null) {
                this.nodeTable.put((Object)nodeKey, (Object)nodeRca.name(), new LinkedList());
            }
            LinkedList linkedList = (LinkedList)this.nodeTable.get((Object)nodeKey, (Object)nodeRca.name());
            linkedList.addLast(flowUnit);
            if (linkedList.size() <= this.numOfFlowUnitsInMap) continue;
            linkedList.pollFirst();
        }
    }

    private List<InstanceDetails> getClusterNodesDetails() {
        if (this.collectFromMasterNode) {
            return this.getAllClusterInstances();
        }
        return this.getDataNodeInstances();
    }

    private void removeInactiveNodeFromNodeMap() {
        HashSet<InstanceDetails.Id> nodeIdSet = new HashSet<InstanceDetails.Id>();
        ArrayList<NodeKey> inactiveNodes = new ArrayList<NodeKey>();
        for (InstanceDetails nodeDetail : this.getClusterNodesDetails()) {
            nodeIdSet.add(nodeDetail.getInstanceId());
        }
        for (NodeKey nodeKey2 : this.nodeTable.rowKeySet()) {
            if (nodeIdSet.contains(nodeKey2.getNodeId())) continue;
            inactiveNodes.add(nodeKey2);
            LOG.info("RCA: remove node {} from node map", (Object)nodeKey2);
        }
        inactiveNodes.forEach(nodeKey -> this.nodeTable.row(nodeKey).clear());
    }

    private ResourceFlowUnit<HotClusterSummary> generateFlowUnit() {
        ArrayList<HotNodeSummary> unhealthyNodeSummaries = new ArrayList<HotNodeSummary>();
        long timestamp = this.clock.millis();
        List<InstanceDetails> clusterNodesDetails = this.getClusterNodesDetails();
        for (InstanceDetails nodeDetails : clusterNodesDetails) {
            HotNodeSummary newNodeSummary;
            NodeKey nodeKey = new NodeKey(nodeDetails.getInstanceId(), nodeDetails.getInstanceIp());
            if (!this.nodeTable.containsRow((Object)nodeKey) || (newNodeSummary = this.generateNodeSummary(nodeKey)) == null) continue;
            unhealthyNodeSummaries.add(newNodeSummary);
        }
        if (!unhealthyNodeSummaries.isEmpty()) {
            HotClusterSummary clusterSummary = new HotClusterSummary(clusterNodesDetails.size(), unhealthyNodeSummaries.size());
            for (HotNodeSummary nodeSummary : unhealthyNodeSummaries) {
                clusterSummary.appendNestedSummary(nodeSummary);
            }
            PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.CLUSTER_RCA_NAMED_COUNT, this.getClass().getName(), 1);
            return new ResourceFlowUnit<HotClusterSummary>(timestamp, new ResourceContext(Resources.State.UNHEALTHY), clusterSummary, true);
        }
        return new ResourceFlowUnit<Object>(timestamp, new ResourceContext(Resources.State.HEALTHY), null);
    }

    protected HotNodeSummary generateNodeSummary(NodeKey nodeKey) {
        HotNodeSummary nodeSummary = null;
        long timestamp = this.clock.millis();
        for (Rca<ResourceFlowUnit<HotNodeSummary>> nodeRca : this.nodeRcas) {
            ResourceFlowUnit flowUnit;
            if (this.nodeTable.get((Object)nodeKey, (Object)nodeRca.name()) == null || timestamp - (flowUnit = (ResourceFlowUnit)((LinkedList)this.nodeTable.get((Object)nodeKey, (Object)nodeRca.name())).getLast()).getTimeStamp() > TIMESTAMP_EXPIRATION_IN_MILLIS || flowUnit.getResourceContext().isHealthy() || flowUnit.getSummary() == null) continue;
            if (nodeSummary == null) {
                nodeSummary = new HotNodeSummary(nodeKey.getNodeId(), nodeKey.getHostAddress());
            }
            ((HotNodeSummary)flowUnit.getSummary()).getHotResourceSummaryList().forEach(nodeSummary::appendNestedSummary);
        }
        return nodeSummary;
    }

    @Override
    public ResourceFlowUnit<HotClusterSummary> operate() {
        ++this.counter;
        this.nodeRcas.forEach(this::addUpstreamFlowUnits);
        if (this.counter >= this.rcaPeriod) {
            this.counter = 0;
            this.removeInactiveNodeFromNodeMap();
            return this.generateFlowUnit();
        }
        return new ResourceFlowUnit<HotClusterSummary>(System.currentTimeMillis());
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }
}

