/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.Removable;

public class ShardStateMetricsSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(ShardStateMetricsSnapshot.class);
    private final DSLContext create;
    private final String tableName;
    private static final List<Field<?>> columns = new ArrayList<Field<?>>(){
        {
            this.add(DSL.field((Name)DSL.name((String)AllMetrics.ShardStateDimension.INDEX_NAME.toString()), String.class));
            this.add(DSL.field((Name)DSL.name((String)AllMetrics.ShardStateDimension.SHARD_ID.toString()), String.class));
            this.add(DSL.field((Name)DSL.name((String)AllMetrics.ShardStateDimension.SHARD_TYPE.toString()), String.class));
            this.add(DSL.field((Name)DSL.name((String)AllMetrics.ShardStateDimension.NODE_NAME.toString()), String.class));
            this.add(DSL.field((Name)DSL.name((String)AllMetrics.ShardStateDimension.SHARD_STATE.toString()), String.class));
        }
    };

    public ShardStateMetricsSnapshot(Connection conn, Long windowStartTime) {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.tableName = "shard_state_" + windowStartTime;
        this.create.createTable(this.tableName).columns(columns).execute();
    }

    @Override
    public void remove() throws Exception {
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    public BatchBindStep startBatchPut() {
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (int i = 0; i < columns.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    @VisibleForTesting
    public void putMetrics(String shard_state, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)AllMetrics.ShardStateDimension.SHARD_STATE.toString()), String.class), (Object)shard_state).set(dimensionMap).execute();
    }
}

