/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rest;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.jooq.Record;
import org.jooq.Result;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.grpc.MetricsRequest;
import org.opensearch.performanceanalyzer.grpc.MetricsResponse;
import org.opensearch.performanceanalyzer.metrics.MetricsRestUtil;
import org.opensearch.performanceanalyzer.metricsdb.MetricsDB;
import org.opensearch.performanceanalyzer.model.MetricAttributes;
import org.opensearch.performanceanalyzer.model.MetricsModel;
import org.opensearch.performanceanalyzer.net.NetClient;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.reader.ReaderMetricsProcessor;
import org.opensearch.performanceanalyzer.rest.MetricsHandler;
import org.opensearch.performanceanalyzer.util.JsonConverter;

public class QueryMetricsRequestHandler
extends MetricsHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(QueryMetricsRequestHandler.class);
    private static final int TIME_OUT_VALUE = 2;
    private static final TimeUnit TIME_OUT_UNIT = TimeUnit.SECONDS;
    private NetClient netClient;
    MetricsRestUtil metricsRestUtil;
    private final AppContext appContext;

    public QueryMetricsRequestHandler(NetClient netClient, MetricsRestUtil metricsRestUtil, AppContext appContext) {
        this.netClient = netClient;
        this.metricsRestUtil = metricsRestUtil;
        this.appContext = appContext;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        LOG.info("{} {} {}", (Object)exchange.getRequestMethod(), (Object)exchange.getRemoteAddress(), (Object)exchange.getRequestURI());
        ReaderMetricsProcessor mp = ReaderMetricsProcessor.getInstance();
        if (mp == null) {
            this.sendResponse(exchange, "{\"error\":\"Metrics Processor is not initialized. The reader has run into an issue or has just started.\"}", 503);
            LOG.warn("Metrics Processor is not initialized. The reader has run into an issue or has just started.");
            return;
        }
        Map.Entry<Long, MetricsDB> dbEntry = mp.getMetricsDB();
        if (dbEntry == null) {
            this.sendResponse(exchange, "{\"error\":\"There are no metrics databases. The reader has run into an issue or has just started.\"}", 503);
            LOG.warn("There are no metrics databases. The reader has run into an issue or has just started.");
            return;
        }
        MetricsDB db = dbEntry.getValue();
        Long dbTimestamp = dbEntry.getKey();
        if (requestMethod.equalsIgnoreCase("GET")) {
            LOG.debug("Query handler called.");
            if (this.isUnitLookUp(exchange)) {
                this.getMetricUnits(exchange);
                return;
            }
            Map<String, String> params = this.getParamsMap(exchange.getRequestURI().getQuery());
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            try {
                Result<Record> metricResult;
                String nodes = params.get("nodes");
                List<String> metricList = this.metricsRestUtil.parseArrayParam(params, "metrics", false);
                List<String> aggList = this.metricsRestUtil.parseArrayParam(params, "agg", false);
                List<String> dimList = this.metricsRestUtil.parseArrayParam(params, "dim", true);
                if (metricList.size() != aggList.size()) {
                    this.sendResponse(exchange, "{\"error\":\"metrics/aggregations should have the same number of entries.\"}", 400);
                    return;
                }
                if (!this.validParams(exchange, metricList, dimList, aggList)) {
                    return;
                }
                String localResponse = db != null ? ((metricResult = db.queryMetric(metricList, aggList, dimList)) == null ? "{}" : metricResult.formatJSON()) : "{}";
                String localResponseWithTimestamp = String.format("{\"timestamp\": %d, \"data\": %s}", dbTimestamp, localResponse);
                ConcurrentHashMap<String, String> nodeResponses = new ConcurrentHashMap<String, String>();
                List<InstanceDetails> allNodes = this.appContext.getAllClusterInstances();
                String localNodeId = "local";
                if (allNodes.size() != 0) {
                    localNodeId = allNodes.get(0).getInstanceId().toString();
                }
                nodeResponses.put(localNodeId, localResponseWithTimestamp);
                String response = this.metricsRestUtil.nodeJsonBuilder(nodeResponses);
                if (nodes == null || !nodes.equals("all") || allNodes.size() <= 1) {
                    this.sendResponse(exchange, response, 200);
                } else if (nodes.equals("all")) {
                    CountDownLatch doneSignal = new CountDownLatch(allNodes.size() - 1);
                    for (int i = 1; i < allNodes.size(); ++i) {
                        InstanceDetails node = allNodes.get(i);
                        LOG.debug("Collecting remote stats");
                        try {
                            this.collectRemoteStats(node, metricList, aggList, dimList, nodeResponses, doneSignal);
                            continue;
                        }
                        catch (Exception e) {
                            LOG.error("Unable to collect stats for node, addr:{}, exception: {} ExceptionCode: {}", (Object)node.getInstanceIp(), (Object)e, (Object)StatExceptionCode.REQUEST_REMOTE_ERROR.toString());
                            StatsCollector.instance().logException(StatExceptionCode.REQUEST_REMOTE_ERROR);
                        }
                    }
                    boolean completed = doneSignal.await(2L, TIME_OUT_UNIT);
                    if (!completed) {
                        LOG.debug("Timeout while collecting remote stats");
                        StatsCollector.instance().logException(StatExceptionCode.REQUEST_REMOTE_ERROR);
                    }
                    this.sendResponseWhenRequestCompleted(nodeResponses, exchange);
                }
            }
            catch (InvalidParameterException e) {
                LOG.error("DB file path : {}", (Object)db.getDBFilePath());
                LOG.error(() -> new ParameterizedMessage("QueryException {} ExceptionCode: {}.", (Object)e.toString(), (Object)StatExceptionCode.REQUEST_ERROR.toString()), (Throwable)e);
                StatsCollector.instance().logException(StatExceptionCode.REQUEST_ERROR);
                String response = "{\"error\":\"" + e.getMessage() + "\"}";
                this.sendResponse(exchange, response, 400);
            }
            catch (Exception e) {
                LOG.error("DB file path : {}", (Object)db.getDBFilePath());
                LOG.error(() -> new ParameterizedMessage("QueryException {} ExceptionCode: {}.", (Object)e.toString(), (Object)StatExceptionCode.REQUEST_ERROR.toString()), (Throwable)e);
                StatsCollector.instance().logException(StatExceptionCode.REQUEST_ERROR);
                String response = "{\"error\":\"" + e.toString() + "\"}";
                this.sendResponse(exchange, response, 500);
            }
        } else {
            exchange.sendResponseHeaders(404, -1L);
            exchange.close();
        }
    }

    void collectRemoteStats(InstanceDetails node, List<String> metricList, List<String> aggList, List<String> dimList, ConcurrentHashMap<String, String> nodeResponses, CountDownLatch doneSignal) {
        MetricsRequest request = MetricsRequest.newBuilder().addAllMetricList(metricList).addAllAggList(aggList).addAllDimList(dimList).build();
        ThreadSafeStreamObserver responseObserver = new ThreadSafeStreamObserver(node, nodeResponses, doneSignal);
        try {
            this.netClient.getMetrics(node, request, responseObserver);
        }
        catch (Exception e) {
            LOG.error("Metrics : Exception occurred while getting Metrics {}", e.getCause());
        }
    }

    private boolean isUnitLookUp(HttpExchange exchange) throws IOException {
        return exchange.getRequestURI().toString().equals("/_plugins/_performanceanalyzer/metrics/units");
    }

    private void getMetricUnits(HttpExchange exchange) throws IOException {
        HashMap<String, String> metricUnits = new HashMap<String, String>();
        for (Map.Entry<String, MetricAttributes> entry : MetricsModel.ALL_METRICS.entrySet()) {
            String metric = entry.getKey();
            String unit = entry.getValue().unit;
            metricUnits.put(metric, unit);
        }
        this.sendResponse(exchange, JsonConverter.writeValueAsString(metricUnits), 200);
    }

    private boolean validParams(HttpExchange exchange, List<String> metricList, List<String> dimList, List<String> aggList) throws IOException {
        for (String metric : metricList) {
            if (MetricsModel.ALL_METRICS.get(metric) == null) {
                this.sendResponse(exchange, String.format("{\"error\":\"%s is an invalid metric.\"}", metric), 400);
                return false;
            }
            for (String dim : dimList) {
                if (MetricsModel.ALL_METRICS.get((Object)metric).dimensionNames.contains(dim)) continue;
                this.sendResponse(exchange, String.format("{\"error\":\"%s is an invalid dimension for %s metric.\"}", dim, metric), 400);
                return false;
            }
        }
        for (String agg : aggList) {
            if (MetricsDB.AGG_VALUES.contains(agg)) continue;
            this.sendResponse(exchange, String.format("{\"error\":\"%s is an invalid aggregation type.\"}", agg), 400);
            return false;
        }
        return true;
    }

    private void sendResponseWhenRequestCompleted(ConcurrentHashMap<String, String> nodeResponses, HttpExchange exchange) {
        if (nodeResponses.size() == 0) {
            return;
        }
        String response = this.metricsRestUtil.nodeJsonBuilder(nodeResponses);
        try {
            this.sendResponse(exchange, response, 200);
        }
        catch (Exception e) {
            LOG.error("Exception occurred while sending response {}", e.getCause());
        }
    }

    private void sendResponse(HttpExchange exchange, String response, int status) throws IOException {
        try (OutputStream os = exchange.getResponseBody();){
            exchange.sendResponseHeaders(status, response.length());
            os.write(response.getBytes());
        }
        catch (Exception e) {
            response = e.toString();
            exchange.sendResponseHeaders(500, response.length());
        }
    }

    private static class ThreadSafeStreamObserver
    implements StreamObserver<MetricsResponse> {
        private final CountDownLatch doneSignal;
        private final ConcurrentHashMap<String, String> nodeResponses;
        private final InstanceDetails node;

        ThreadSafeStreamObserver(InstanceDetails node, ConcurrentHashMap<String, String> nodeResponses, CountDownLatch doneSignal) {
            this.node = node;
            this.doneSignal = doneSignal;
            this.nodeResponses = nodeResponses;
        }

        public void onNext(MetricsResponse value) {
            this.nodeResponses.putIfAbsent(this.node.getInstanceId().toString(), value.getMetricsResult());
        }

        public void onError(Throwable t) {
            LOG.info("Metrics : Error occurred while getting Metrics for " + this.node.getInstanceIp());
            this.doneSignal.countDown();
        }

        public void onCompleted() {
            this.doneSignal.countDown();
        }
    }
}

